/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.instance.reader;

import com.graphhopper.jsprit.core.problem.AbstractJob;
import com.graphhopper.jsprit.core.problem.AbstractVehicle;
import com.graphhopper.jsprit.core.problem.Location;
import com.graphhopper.jsprit.core.problem.VehicleRoutingProblem;
import com.graphhopper.jsprit.core.problem.job.Service;
import com.graphhopper.jsprit.core.problem.vehicle.VehicleImpl;
import com.graphhopper.jsprit.core.problem.vehicle.VehicleType;
import com.graphhopper.jsprit.core.problem.vehicle.VehicleTypeImpl;
import com.graphhopper.jsprit.core.util.Coordinate;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BelhaizaReader {
    private int fixedCosts;
    private static Logger logger = LoggerFactory.getLogger(BelhaizaReader.class);
    private final VehicleRoutingProblem.Builder vrpBuilder;
    private double coordProjectionFactor = 1.0;
    private double timeProjectionFactor = 1.0;
    private double variableCostProjectionFactor = 1.0;
    private double fixedCostPerVehicle = 0.0;

    public void setVariableCostProjectionFactor(double costProjectionFactor) {
        this.variableCostProjectionFactor = costProjectionFactor;
    }

    public BelhaizaReader(VehicleRoutingProblem.Builder vrpBuilder) {
        this.vrpBuilder = vrpBuilder;
    }

    public BelhaizaReader(VehicleRoutingProblem.Builder vrpBuilder, double fixedCostPerVehicle) {
        this.vrpBuilder = vrpBuilder;
        this.fixedCostPerVehicle = fixedCostPerVehicle;
    }

    public void read(String solomonFile) {
        String line;
        this.vrpBuilder.setFleetSize(VehicleRoutingProblem.FleetSize.INFINITE);
        BufferedReader reader = this.getReader(solomonFile);
        int vehicleCapacity = 0;
        int counter = 0;
        while ((line = this.readLine(reader)) != null) {
            String[] tokens = line.replace("\r", "").trim().split("\\s+");
            if (++counter == 2) {
                vehicleCapacity = Integer.parseInt(tokens[1]);
                continue;
            }
            if (counter <= 2 || tokens.length < 7) continue;
            Coordinate coord = this.makeCoord(tokens[1], tokens[2]);
            String customerId = tokens[0];
            int demand = Integer.parseInt(tokens[4]);
            double serviceTime = Double.parseDouble(tokens[3]) * this.timeProjectionFactor;
            if (counter == 3) {
                VehicleTypeImpl.Builder typeBuilder = VehicleTypeImpl.Builder.newInstance((String)"solomonType").addCapacityDimension(0, vehicleCapacity);
                typeBuilder.setCostPerDistance(1.0 * this.variableCostProjectionFactor).setFixedCost(this.fixedCostPerVehicle).setCostPerWaitingTime(0.8);
                System.out.println("fix: " + this.fixedCostPerVehicle + "; perDistance: 1.0; perWaitingTime: 0.8");
                VehicleTypeImpl vehicleType = typeBuilder.build();
                double end = Double.parseDouble(tokens[8]) * this.timeProjectionFactor;
                VehicleImpl vehicle = VehicleImpl.Builder.newInstance((String)"solomonVehicle").setEarliestStart(0.0).setLatestArrival(end).setStartLocation(Location.Builder.newInstance().setId(customerId).setCoordinate(coord).build()).setType((VehicleType)vehicleType).build();
                this.vrpBuilder.addVehicle((AbstractVehicle)vehicle);
                continue;
            }
            Service.Builder serviceBuilder = Service.Builder.newInstance((String)customerId);
            serviceBuilder.addSizeDimension(0, demand).setLocation(Location.Builder.newInstance().setCoordinate(coord).setId(customerId).build()).setServiceTime(serviceTime);
            int noTimeWindows = Integer.parseInt(tokens[7]);
            for (int i = 0; i < noTimeWindows * 2; i += 2) {
                double earliest = Double.parseDouble(tokens[8 + i]);
                double latest = Double.parseDouble(tokens[8 + i + 1]);
                serviceBuilder.addTimeWindow(earliest, latest);
            }
            this.vrpBuilder.addJob((AbstractJob)serviceBuilder.build());
        }
        this.close(reader);
    }

    public void setCoordProjectionFactor(double coordProjectionFactor) {
        this.coordProjectionFactor = coordProjectionFactor;
    }

    private void close(BufferedReader reader) {
        try {
            reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            logger.error(e.toString());
            System.exit(1);
        }
    }

    private String readLine(BufferedReader reader) {
        try {
            return reader.readLine();
        }
        catch (IOException e) {
            e.printStackTrace();
            logger.error(e.toString());
            System.exit(1);
            return null;
        }
    }

    private Coordinate makeCoord(String xString, String yString) {
        double x = Double.parseDouble(xString);
        double y = Double.parseDouble(yString);
        return new Coordinate(x * this.coordProjectionFactor, y * this.coordProjectionFactor);
    }

    private BufferedReader getReader(String solomonFile) {
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(solomonFile));
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
            logger.error(e1.toString());
            System.exit(1);
        }
        return reader;
    }

    public void setTimeProjectionFactor(double timeProjection) {
        this.timeProjectionFactor = timeProjection;
    }

    public void setFixedCosts(int fixedCosts) {
        this.fixedCostPerVehicle = fixedCosts;
    }
}

