/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.instance.reader;

import com.graphhopper.jsprit.core.problem.AbstractJob;
import com.graphhopper.jsprit.core.problem.AbstractVehicle;
import com.graphhopper.jsprit.core.problem.Location;
import com.graphhopper.jsprit.core.problem.VehicleRoutingProblem;
import com.graphhopper.jsprit.core.problem.job.Service;
import com.graphhopper.jsprit.core.problem.vehicle.VehicleImpl;
import com.graphhopper.jsprit.core.problem.vehicle.VehicleType;
import com.graphhopper.jsprit.core.problem.vehicle.VehicleTypeImpl;
import com.graphhopper.jsprit.core.util.Coordinate;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChristofidesReader {
    private static Logger logger = LoggerFactory.getLogger(ChristofidesReader.class);
    private final VehicleRoutingProblem.Builder vrpBuilder;
    private double coordProjectionFactor = 1.0;

    public ChristofidesReader(VehicleRoutingProblem.Builder vrpBuilder) {
        this.vrpBuilder = vrpBuilder;
    }

    public void read(String fileName) {
        String line;
        this.vrpBuilder.setFleetSize(VehicleRoutingProblem.FleetSize.INFINITE);
        BufferedReader reader = this.getReader(fileName);
        int vehicleCapacity = 0;
        double serviceTime = 0.0;
        double endTime = Double.MAX_VALUE;
        int counter = 0;
        while ((line = this.readLine(reader)) != null) {
            line = line.replace("\r", "");
            line = line.trim();
            String[] tokens = line.split(" ");
            if (counter == 0) {
                vehicleCapacity = Integer.parseInt(tokens[1].trim());
                endTime = Double.parseDouble(tokens[2].trim());
                serviceTime = Double.parseDouble(tokens[3].trim());
            } else if (counter == 1) {
                Coordinate depotCoord = this.makeCoord(tokens[0].trim(), tokens[1].trim());
                VehicleTypeImpl vehicleType = VehicleTypeImpl.Builder.newInstance((String)"christophidesType").addCapacityDimension(0, vehicleCapacity).setCostPerDistance(1.0).build();
                VehicleImpl vehicle = VehicleImpl.Builder.newInstance((String)"christophidesVehicle").setLatestArrival(endTime).setStartLocation(Location.newInstance((double)depotCoord.getX(), (double)depotCoord.getY())).setType((VehicleType)vehicleType).build();
                this.vrpBuilder.addVehicle((AbstractVehicle)vehicle);
            } else {
                Coordinate customerCoord = this.makeCoord(tokens[0].trim(), tokens[1].trim());
                int demand = Integer.parseInt(tokens[2].trim());
                String customer = Integer.valueOf(counter - 1).toString();
                Service service = Service.Builder.newInstance((String)customer).addSizeDimension(0, demand).setServiceTime(serviceTime).setLocation(Location.newInstance((double)customerCoord.getX(), (double)customerCoord.getY())).build();
                this.vrpBuilder.addJob((AbstractJob)service);
            }
            ++counter;
        }
        this.close(reader);
    }

    public void setCoordProjectionFactor(double coordProjectionFactor) {
        this.coordProjectionFactor = coordProjectionFactor;
    }

    private void close(BufferedReader reader) {
        try {
            reader.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String readLine(BufferedReader reader) {
        try {
            return reader.readLine();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Coordinate makeCoord(String xString, String yString) {
        double x = Double.parseDouble(xString);
        double y = Double.parseDouble(yString);
        return new Coordinate(x * this.coordProjectionFactor, y * this.coordProjectionFactor);
    }

    private BufferedReader getReader(String solomonFile) {
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(solomonFile));
        }
        catch (FileNotFoundException e1) {
            throw new RuntimeException(e1);
        }
        return reader;
    }
}

