/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.instance.reader;

import com.graphhopper.jsprit.core.problem.AbstractJob;
import com.graphhopper.jsprit.core.problem.AbstractVehicle;
import com.graphhopper.jsprit.core.problem.Location;
import com.graphhopper.jsprit.core.problem.VehicleRoutingProblem;
import com.graphhopper.jsprit.core.problem.job.Service;
import com.graphhopper.jsprit.core.problem.vehicle.VehicleImpl;
import com.graphhopper.jsprit.core.problem.vehicle.VehicleType;
import com.graphhopper.jsprit.core.problem.vehicle.VehicleTypeImpl;
import com.graphhopper.jsprit.core.util.Coordinate;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CordeauReader {
    private static Logger logger = LoggerFactory.getLogger(CordeauReader.class);
    private final VehicleRoutingProblem.Builder vrpBuilder;
    private double coordProjectionFactor = 1.0;

    public CordeauReader(VehicleRoutingProblem.Builder vrpBuilder) {
        this.vrpBuilder = vrpBuilder;
    }

    public void read(String fileName) {
        String line;
        this.vrpBuilder.setFleetSize(VehicleRoutingProblem.FleetSize.FINITE);
        BufferedReader reader = this.getReader(fileName);
        int nOfDepots = 0;
        int nOfCustomers = 0;
        int nOfVehiclesAtEachDepot = 0;
        int counter = 0;
        ArrayList vehiclesAtDepot = new ArrayList();
        int depotCounter = 0;
        while ((line = this.readLine(reader)) != null) {
            line = line.replace("\r", "");
            line = line.trim();
            String[] tokens = line.split("\\s+");
            if (counter == 0) {
                int vrpType = Integer.parseInt(tokens[0].trim());
                if (vrpType != 2) {
                    throw new IllegalStateException("expect vrpType to be equal to 2 and thus to be MDVRP");
                }
                nOfVehiclesAtEachDepot = Integer.parseInt(tokens[1].trim());
                nOfCustomers = Integer.parseInt(tokens[2].trim());
                nOfDepots = Integer.parseInt(tokens[3].trim());
            } else if (counter <= nOfDepots) {
                String depot = Integer.valueOf(counter).toString();
                int duration = Integer.parseInt(tokens[0].trim());
                if (duration == 0) {
                    duration = 999999;
                }
                int capacity = Integer.parseInt(tokens[1].trim());
                VehicleTypeImpl vehicleType = VehicleTypeImpl.Builder.newInstance((String)(counter + "_cordeauType")).addCapacityDimension(0, capacity).setCostPerDistance(1.0).setFixedCost(0.0).build();
                ArrayList<VehicleImpl.Builder> builders = new ArrayList<VehicleImpl.Builder>();
                for (int vehicleCounter = 0; vehicleCounter < nOfVehiclesAtEachDepot; ++vehicleCounter) {
                    VehicleImpl.Builder vBuilder = VehicleImpl.Builder.newInstance((String)(depot + "_" + (vehicleCounter + 1) + "_cordeauVehicle"));
                    vBuilder.setLatestArrival((double)duration).setType((VehicleType)vehicleType);
                    builders.add(vBuilder);
                }
                vehiclesAtDepot.add(builders);
            } else if (counter <= nOfCustomers + nOfDepots) {
                String id = tokens[0].trim();
                Coordinate customerCoord = this.makeCoord(tokens[1].trim(), tokens[2].trim());
                double serviceTime = Double.parseDouble(tokens[3].trim());
                int demand = Integer.parseInt(tokens[4].trim());
                Service service = Service.Builder.newInstance((String)id).addSizeDimension(0, demand).setServiceTime(serviceTime).setLocation(Location.Builder.newInstance().setId(id).setCoordinate(customerCoord).build()).build();
                this.vrpBuilder.addJob((AbstractJob)service);
            } else if (counter <= nOfCustomers + nOfDepots + nOfDepots) {
                Coordinate depotCoord = this.makeCoord(tokens[1].trim(), tokens[2].trim());
                List vBuilders = (List)vehiclesAtDepot.get(depotCounter);
                for (VehicleImpl.Builder vBuilder : vBuilders) {
                    vBuilder.setStartLocation(Location.newInstance((double)depotCoord.getX(), (double)depotCoord.getY()));
                    VehicleImpl vehicle = vBuilder.build();
                    this.vrpBuilder.addVehicle((AbstractVehicle)vehicle);
                }
                ++depotCounter;
            } else {
                throw new IllegalStateException("there are more lines than expected in file.");
            }
            ++counter;
        }
        this.close(reader);
    }

    public void setCoordProjectionFactor(double coordProjectionFactor) {
        this.coordProjectionFactor = coordProjectionFactor;
    }

    private void close(BufferedReader reader) {
        try {
            reader.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String readLine(BufferedReader reader) {
        try {
            return reader.readLine();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Coordinate makeCoord(String xString, String yString) {
        double x = Double.parseDouble(xString);
        double y = Double.parseDouble(yString);
        return new Coordinate(x * this.coordProjectionFactor, y * this.coordProjectionFactor);
    }

    private BufferedReader getReader(String solomonFile) {
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(solomonFile));
        }
        catch (FileNotFoundException e1) {
            throw new RuntimeException(e1);
        }
        return reader;
    }
}

