/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.instance.reader;

import com.graphhopper.jsprit.core.problem.Location;
import com.graphhopper.jsprit.core.problem.cost.VehicleRoutingTransportCosts;
import com.graphhopper.jsprit.core.problem.driver.Driver;
import com.graphhopper.jsprit.core.problem.vehicle.Vehicle;
import com.graphhopper.jsprit.core.util.Coordinate;
import com.graphhopper.jsprit.core.util.EuclideanDistanceCalculator;
import com.graphhopper.jsprit.core.util.Locations;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class Figliozzi {

    public static class TDCosts
    implements VehicleRoutingTransportCosts {
        private List<Double> timeBins;
        private List<Double> speed;
        private Locations locations;
        private double transportDistanceParameter = 1.0;
        private double transportTimeParameter = 1.0;

        public TDCosts(Locations locations, List<Double> timeBins, List<Double> speedValues) {
            this.speed = speedValues;
            this.timeBins = timeBins;
            this.locations = locations;
        }

        public void setTransportDistanceParameter(double transportDistanceParameter) {
            this.transportDistanceParameter = transportDistanceParameter;
        }

        public void setTransportTimeParameter(double transportTimeParameter) {
            this.transportTimeParameter = transportTimeParameter;
        }

        public double getTransportCost(Location from, Location to, double departureTime, Driver driver, Vehicle vehicle) {
            return this.transportDistanceParameter * EuclideanDistanceCalculator.calculateDistance((Coordinate)this.locations.getCoord(from.getId()), (Coordinate)this.locations.getCoord(to.getId())) + this.transportTimeParameter * this.getTransportTime(from, to, departureTime, driver, vehicle);
        }

        public double getBackwardTransportCost(Location from, Location to, double arrivalTime, Driver driver, Vehicle vehicle) {
            return this.transportDistanceParameter * EuclideanDistanceCalculator.calculateDistance((Coordinate)this.locations.getCoord(from.getId()), (Coordinate)this.locations.getCoord(to.getId())) + this.transportTimeParameter * this.getBackwardTransportTime(from, to, arrivalTime, driver, vehicle);
        }

        public double getTransportTime(Location from, Location to, double departureTime, Driver driver, Vehicle vehicle) {
            if (from.equals((Object)to)) {
                return 0.0;
            }
            double totalTravelTime = 0.0;
            double distanceToTravel = EuclideanDistanceCalculator.calculateDistance((Coordinate)this.locations.getCoord(from.getId()), (Coordinate)this.locations.getCoord(to.getId()));
            double currentTime = departureTime;
            for (int i = 0; i < this.timeBins.size(); ++i) {
                double timeThreshold = this.timeBins.get(i);
                if (!(currentTime < timeThreshold)) continue;
                double maxReachableDistance = (timeThreshold - currentTime) * this.speed.get(i);
                if (distanceToTravel > maxReachableDistance) {
                    distanceToTravel -= maxReachableDistance;
                    totalTravelTime += timeThreshold - currentTime;
                    currentTime = timeThreshold;
                    continue;
                }
                return totalTravelTime += distanceToTravel / this.speed.get(i);
            }
            return Double.MAX_VALUE;
        }

        public double getBackwardTransportTime(Location from, Location to, double arrivalTime, Driver driver, Vehicle vehicle) {
            if (from.equals((Object)to)) {
                return 0.0;
            }
            double totalTravelTime = 0.0;
            double distanceToTravel = EuclideanDistanceCalculator.calculateDistance((Coordinate)this.locations.getCoord(from.getId()), (Coordinate)this.locations.getCoord(to.getId()));
            double currentTime = arrivalTime;
            for (int i = this.timeBins.size() - 1; i >= 0; --i) {
                double nextLowerTimeThreshold = i > 0 ? this.timeBins.get(i - 1) : 0.0;
                if (!(currentTime > nextLowerTimeThreshold)) continue;
                double maxReachableDistance = (currentTime - nextLowerTimeThreshold) * this.speed.get(i);
                if (distanceToTravel > maxReachableDistance) {
                    distanceToTravel -= maxReachableDistance;
                    totalTravelTime += currentTime - nextLowerTimeThreshold;
                    currentTime = nextLowerTimeThreshold;
                    continue;
                }
                return totalTravelTime += distanceToTravel / this.speed.get(i);
            }
            return Double.MAX_VALUE;
        }

        public double getDistance(Location from, Location to, double departureTime, Vehicle vehicle) {
            return EuclideanDistanceCalculator.calculateDistance((Coordinate)this.locations.getCoord(from.getId()), (Coordinate)this.locations.getCoord(to.getId()));
        }
    }

    public static class TimeDependentTransportCostsFactory {
        public static TDCosts createCosts(Locations locations, SpeedDistribution speedDistribution, double depotClosingTime) {
            List<Double> timeBins = TimeDependentTransportCostsFactory.createTimeBins(depotClosingTime);
            List<Double> speedValues = TimeDependentTransportCostsFactory.createSpeedValues(speedDistribution);
            return new TDCosts(locations, timeBins, speedValues);
        }

        static List<Double> createSpeedValues(SpeedDistribution speedDistribution) {
            List<Double> speedValues = Collections.emptyList();
            switch (speedDistribution) {
                case TD1a: {
                    speedValues = Arrays.asList(1.0, 1.6, 1.05, 1.6, 1.0);
                    break;
                }
                case TD2a: {
                    speedValues = Arrays.asList(1.0, 2.0, 1.5, 2.0, 1.0);
                    break;
                }
                case TD3a: {
                    speedValues = Arrays.asList(1.0, 2.5, 1.75, 2.5, 1.0);
                    break;
                }
                case TD1b: {
                    speedValues = Arrays.asList(1.6, 1.0, 1.05, 1.0, 1.6);
                    break;
                }
                case TD2b: {
                    speedValues = Arrays.asList(2.0, 1.0, 1.5, 1.0, 2.0);
                    break;
                }
                case TD3b: {
                    speedValues = Arrays.asList(2.5, 1.0, 1.75, 1.0, 2.5);
                    break;
                }
                case TD1c: {
                    speedValues = Arrays.asList(1.6, 1.6, 1.05, 1.0, 1.0);
                    break;
                }
                case TD2c: {
                    speedValues = Arrays.asList(2.0, 2.0, 1.5, 1.0, 1.0);
                    break;
                }
                case TD3c: {
                    speedValues = Arrays.asList(2.5, 2.5, 1.75, 1.0, 1.0);
                    break;
                }
                case TD1d: {
                    speedValues = Arrays.asList(1.0, 1.0, 1.05, 1.6, 1.6);
                    break;
                }
                case TD2d: {
                    speedValues = Arrays.asList(1.0, 1.0, 1.5, 2.0, 2.0);
                    break;
                }
                case TD3d: {
                    speedValues = Arrays.asList(1.0, 1.0, 1.75, 2.5, 2.5);
                    break;
                }
                case TD4: {
                    speedValues = Arrays.asList(1.1, 0.85, 1.1, 0.85, 1.1);
                    break;
                }
                case TD5: {
                    speedValues = Arrays.asList(1.2, 0.8, 1.0, 0.8, 1.2);
                    break;
                }
                case TD6: {
                    speedValues = Arrays.asList(1.2, 0.7, 1.2, 0.7, 1.2);
                    break;
                }
                case CLASSIC: {
                    speedValues = Arrays.asList(1.0, 1.0, 1.0, 1.0, 1.0);
                }
            }
            return speedValues;
        }

        private static List<Double> createTimeBins(double depotClosingTime) {
            ArrayList<Double> timeBins = new ArrayList<Double>();
            timeBins.add(0.2 * depotClosingTime);
            timeBins.add(0.4 * depotClosingTime);
            timeBins.add(0.6 * depotClosingTime);
            timeBins.add(0.8 * depotClosingTime);
            timeBins.add(depotClosingTime);
            return timeBins;
        }

        public static enum SpeedDistribution {
            TD1a,
            TD1b,
            TD1c,
            TD2a,
            TD2b,
            TD2c,
            TD3a,
            TD3b,
            TD3c,
            TD1d,
            TD2d,
            TD3d,
            TD4,
            TD5,
            TD6,
            CLASSIC;

        }
    }
}

