/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.instance.reader;

import com.graphhopper.jsprit.core.problem.AbstractJob;
import com.graphhopper.jsprit.core.problem.AbstractVehicle;
import com.graphhopper.jsprit.core.problem.Location;
import com.graphhopper.jsprit.core.problem.VehicleRoutingProblem;
import com.graphhopper.jsprit.core.problem.job.Shipment;
import com.graphhopper.jsprit.core.problem.solution.route.activity.TimeWindow;
import com.graphhopper.jsprit.core.problem.vehicle.VehicleImpl;
import com.graphhopper.jsprit.core.problem.vehicle.VehicleType;
import com.graphhopper.jsprit.core.problem.vehicle.VehicleTypeImpl;
import com.graphhopper.jsprit.core.util.Coordinate;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LiLimReader {
    private static Logger logger = LoggerFactory.getLogger(LiLimReader.class);
    private VehicleRoutingProblem.Builder vrpBuilder;
    private int vehicleCapacity;
    private String depotId;
    private Map<String, CustomerData> customers = new HashMap<String, CustomerData>();
    private Collection<Relation> relations = new ArrayList<Relation>();
    private double depotOpeningTime;
    private double depotClosingTime;
    private int fixCosts = 0;

    public LiLimReader(VehicleRoutingProblem.Builder vrpBuilder) {
        this.vrpBuilder = vrpBuilder;
    }

    public LiLimReader(VehicleRoutingProblem.Builder builder, int fixCosts) {
        this.vrpBuilder = builder;
        this.fixCosts = fixCosts;
    }

    public void read(String filename) {
        this.readShipments(filename);
        this.buildShipments();
        VehicleTypeImpl type = VehicleTypeImpl.Builder.newInstance((String)"type").addCapacityDimension(0, this.vehicleCapacity).setCostPerDistance(1.0).setFixedCost((double)this.fixCosts).build();
        VehicleImpl vehicle = VehicleImpl.Builder.newInstance((String)"vehicle").setEarliestStart(this.depotOpeningTime).setLatestArrival(this.depotClosingTime).setStartLocation(Location.Builder.newInstance().setCoordinate(this.customers.get((Object)this.depotId).coord).build()).setType((VehicleType)type).build();
        this.vrpBuilder.addVehicle((AbstractVehicle)vehicle);
    }

    private void buildShipments() {
        Integer counter = 0;
        for (Relation rel : this.relations) {
            Integer n = counter;
            Integer n2 = counter = Integer.valueOf(counter + 1);
            String from = rel.from;
            String to = rel.to;
            int demand = rel.demand;
            Shipment s = Shipment.Builder.newInstance((String)counter.toString()).addSizeDimension(0, demand).setPickupLocation(Location.Builder.newInstance().setCoordinate(this.customers.get((Object)from).coord).build()).setPickupServiceTime(this.customers.get((Object)from).serviceTime).setPickupTimeWindow(TimeWindow.newInstance((double)this.customers.get((Object)from).start, (double)this.customers.get((Object)from).end)).setDeliveryLocation(Location.Builder.newInstance().setCoordinate(this.customers.get((Object)to).coord).build()).setDeliveryServiceTime(this.customers.get((Object)to).serviceTime).setDeliveryTimeWindow(TimeWindow.newInstance((double)this.customers.get((Object)to).start, (double)this.customers.get((Object)to).end)).build();
            this.vrpBuilder.addJob((AbstractJob)s);
        }
    }

    private BufferedReader getReader(String file) {
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(file));
        }
        catch (FileNotFoundException e1) {
            throw new RuntimeException(e1);
        }
        return reader;
    }

    private void readShipments(String file) {
        BufferedReader reader = this.getReader(file);
        String line = null;
        boolean firstLine = true;
        try {
            while ((line = reader.readLine()) != null) {
                line = line.replace("\r", "");
                line = line.trim();
                String[] tokens = line.split("\t");
                if (firstLine) {
                    int vehicleCapacity;
                    this.vehicleCapacity = vehicleCapacity = this.getInt(tokens[1]);
                    firstLine = false;
                    continue;
                }
                String customerId = tokens[0];
                Coordinate coord = this.makeCoord(tokens[1], tokens[2]);
                int demand = this.getInt(tokens[3]);
                double startTimeWindow = this.getDouble(tokens[4]);
                double endTimeWindow = this.getDouble(tokens[5]);
                double serviceTime = this.getDouble(tokens[6]);
                this.customers.put(customerId, new CustomerData(coord, startTimeWindow, endTimeWindow, serviceTime));
                if (customerId.equals("0")) {
                    this.depotId = customerId;
                    this.depotOpeningTime = startTimeWindow;
                    this.depotClosingTime = endTimeWindow;
                }
                if (demand <= 0) continue;
                this.relations.add(new Relation(customerId, tokens[8], demand));
            }
            reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private Coordinate makeCoord(String xString, String yString) {
        double x = Double.parseDouble(xString);
        double y = Double.parseDouble(yString);
        return new Coordinate(x, y);
    }

    private double getDouble(String string) {
        return Double.parseDouble(string);
    }

    private int getInt(String string) {
        return Integer.parseInt(string);
    }

    static class Relation {
        public String from;
        public String to;
        public int demand;

        public Relation(String from, String to, int demand) {
            this.from = from;
            this.to = to;
            this.demand = demand;
        }
    }

    static class CustomerData {
        public Coordinate coord;
        public double start;
        public double end;
        public double serviceTime;

        public CustomerData(Coordinate coord, double start, double end, double serviceTime) {
            this.coord = coord;
            this.start = start;
            this.end = end;
            this.serviceTime = serviceTime;
        }
    }
}

