/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.instance.reader;

import com.graphhopper.jsprit.core.problem.AbstractJob;
import com.graphhopper.jsprit.core.problem.AbstractVehicle;
import com.graphhopper.jsprit.core.problem.Location;
import com.graphhopper.jsprit.core.problem.VehicleRoutingProblem;
import com.graphhopper.jsprit.core.problem.cost.VehicleRoutingTransportCosts;
import com.graphhopper.jsprit.core.problem.job.Service;
import com.graphhopper.jsprit.core.problem.solution.route.activity.TimeWindow;
import com.graphhopper.jsprit.core.problem.vehicle.VehicleImpl;
import com.graphhopper.jsprit.core.util.FastVehicleRoutingTransportCostsMatrix;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LopezIbanezBlumReader {
    private static Logger logger = LoggerFactory.getLogger(LopezIbanezBlumReader.class);
    private VehicleRoutingProblem.Builder builder;

    public LopezIbanezBlumReader(VehicleRoutingProblem.Builder builder) {
        this.builder = builder;
    }

    public void read(String instanceFile) {
        String line;
        this.builder.setFleetSize(VehicleRoutingProblem.FleetSize.FINITE);
        BufferedReader reader = this.getReader(instanceFile);
        int noNodes = 0;
        int lineCount = 1;
        FastVehicleRoutingTransportCostsMatrix.Builder matrixBuilder = null;
        while ((line = this.readLine(reader)) != null) {
            if (line.startsWith("#")) continue;
            if (lineCount == 1) {
                noNodes = Integer.parseInt(line);
                matrixBuilder = FastVehicleRoutingTransportCostsMatrix.Builder.newInstance((int)noNodes, (boolean)false);
                ++lineCount;
                continue;
            }
            if (lineCount <= 1 + noNodes) {
                String[] wimaTokens = line.split("\\s+");
                int nodeIndex = lineCount - 2;
                for (int toIndex = 0; toIndex < wimaTokens.length; ++toIndex) {
                    matrixBuilder.addTransportDistance(nodeIndex, toIndex, Double.parseDouble(wimaTokens[toIndex]));
                    matrixBuilder.addTransportTime(nodeIndex, toIndex, Double.parseDouble(wimaTokens[toIndex]));
                }
                ++lineCount;
                continue;
            }
            int nodeIndex = lineCount - 2 - noNodes;
            String[] twTokens = line.split("\\s+");
            if (nodeIndex == 0) {
                VehicleImpl travelingSalesman = VehicleImpl.Builder.newInstance((String)"traveling_salesman").setStartLocation(Location.newInstance((int)nodeIndex)).setEarliestStart(Double.parseDouble(twTokens[0])).setLatestArrival(Double.parseDouble(twTokens[1])).build();
                this.builder.addVehicle((AbstractVehicle)travelingSalesman);
            } else {
                Service s = Service.Builder.newInstance((String)("" + nodeIndex)).setLocation(Location.newInstance((int)nodeIndex)).setTimeWindow(TimeWindow.newInstance((double)Double.parseDouble(twTokens[0]), (double)Double.parseDouble(twTokens[1]))).build();
                this.builder.addJob((AbstractJob)s);
            }
            ++lineCount;
        }
        this.builder.setRoutingCost((VehicleRoutingTransportCosts)matrixBuilder.build());
        this.close(reader);
    }

    public static void main(String[] args) {
        VehicleRoutingProblem.Builder builder = VehicleRoutingProblem.Builder.newInstance();
        new LopezIbanezBlumReader(builder).read("input/Dumas/n20w20.001.txt");
        VehicleRoutingProblem vrp = builder.build();
        System.out.println("0->1: " + vrp.getTransportCosts().getTransportCost(Location.newInstance((int)0), Location.newInstance((int)1), 0.0, null, null));
        System.out.println("0->20: " + vrp.getTransportCosts().getTransportCost(Location.newInstance((int)0), Location.newInstance((int)20), 0.0, null, null));
        System.out.println("4->18: " + vrp.getTransportCosts().getTransportCost(Location.newInstance((int)4), Location.newInstance((int)18), 0.0, null, null));
        System.out.println("20->8: " + vrp.getTransportCosts().getTransportCost(Location.newInstance((int)20), Location.newInstance((int)8), 0.0, null, null));
        System.out.println("18: " + ((Service)vrp.getJobs().get("18")).getTimeWindow().getStart() + " " + ((Service)vrp.getJobs().get("18")).getTimeWindow().getEnd());
        System.out.println("20: " + ((Service)vrp.getJobs().get("20")).getTimeWindow().getStart() + " " + ((Service)vrp.getJobs().get("20")).getTimeWindow().getEnd());
        System.out.println("1: " + ((Service)vrp.getJobs().get("1")).getTimeWindow().getStart() + " " + ((Service)vrp.getJobs().get("1")).getTimeWindow().getEnd());
    }

    private void close(BufferedReader reader) {
        try {
            reader.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String readLine(BufferedReader reader) {
        try {
            return reader.readLine();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private BufferedReader getReader(String solomonFile) {
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(solomonFile));
        }
        catch (FileNotFoundException e1) {
            throw new RuntimeException(e1);
        }
        return reader;
    }
}

