/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.instance.reader;

import com.graphhopper.jsprit.core.problem.AbstractJob;
import com.graphhopper.jsprit.core.problem.AbstractVehicle;
import com.graphhopper.jsprit.core.problem.Location;
import com.graphhopper.jsprit.core.problem.VehicleRoutingProblem;
import com.graphhopper.jsprit.core.problem.job.Service;
import com.graphhopper.jsprit.core.problem.solution.route.activity.TimeWindow;
import com.graphhopper.jsprit.core.problem.vehicle.VehicleImpl;
import com.graphhopper.jsprit.core.problem.vehicle.VehicleType;
import com.graphhopper.jsprit.core.problem.vehicle.VehicleTypeImpl;
import com.graphhopper.jsprit.core.util.Coordinate;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LuiShenReader {
    private static Logger logger = LoggerFactory.getLogger(LuiShenReader.class);
    private final VehicleRoutingProblem.Builder vrpBuilder;
    private double coordProjectionFactor = 1.0;

    public LuiShenReader(VehicleRoutingProblem.Builder vrpBuilder) {
        this.vrpBuilder = vrpBuilder;
    }

    public void read(String instanceFile, String vehicleFile, String costScenario) {
        this.vrpBuilder.setFleetSize(VehicleRoutingProblem.FleetSize.INFINITE);
        BufferedReader reader = this.getReader(instanceFile);
        int counter = 0;
        String line = null;
        while ((line = this.readLine(reader)) != null) {
            line = line.replace("\r", "");
            line = line.trim();
            String[] tokens = line.split(" +");
            if (++counter <= 9 || tokens.length < 7) continue;
            Coordinate coord = this.makeCoord(tokens[1], tokens[2]);
            String customerId = tokens[0];
            int demand = Integer.parseInt(tokens[3]);
            double start = Double.parseDouble(tokens[4]) * this.coordProjectionFactor;
            double end = Double.parseDouble(tokens[5]) * this.coordProjectionFactor;
            double serviceTime = Double.parseDouble(tokens[6]) * this.coordProjectionFactor;
            if (counter == 10) {
                this.createVehicles(vehicleFile, costScenario, customerId, coord, start, end);
                continue;
            }
            Service service = Service.Builder.newInstance((String)("" + (counter - 10))).addSizeDimension(0, demand).setLocation(Location.Builder.newInstance().setCoordinate(coord).setId(customerId).build()).setServiceTime(serviceTime).setTimeWindow(TimeWindow.newInstance((double)start, (double)end)).build();
            this.vrpBuilder.addJob((AbstractJob)service);
        }
        this.close(reader);
    }

    private void createVehicles(String vehicleFileName, String costScenario, String locationId, Coordinate coord, double start, double end) {
        BufferedReader reader = this.getReader(vehicleFileName);
        int costScenarioColumn = this.getCostScenarioColumn(costScenario);
        int vehicleIdColumn = 0;
        int capacityColumn = 1;
        boolean firstLine = true;
        String line = null;
        while ((line = this.readLine(reader)) != null) {
            if (firstLine) {
                firstLine = false;
                continue;
            }
            String[] tokens = line.split(";");
            String vehicleId = tokens[vehicleIdColumn];
            int capacity = Integer.parseInt(tokens[capacityColumn]);
            int fixCost = Integer.parseInt(tokens[costScenarioColumn]);
            VehicleTypeImpl.Builder typeBuilder = VehicleTypeImpl.Builder.newInstance((String)vehicleId).addCapacityDimension(0, capacity);
            typeBuilder.setFixedCost((double)fixCost).setCostPerDistance(1.0);
            VehicleTypeImpl type = typeBuilder.build();
            VehicleImpl reprVehicle = VehicleImpl.Builder.newInstance((String)vehicleId).setEarliestStart(start).setLatestArrival(end).setStartLocation(Location.Builder.newInstance().setId(locationId).setCoordinate(coord).build()).setType((VehicleType)type).build();
            this.vrpBuilder.addVehicle((AbstractVehicle)reprVehicle);
        }
        this.close(reader);
    }

    private int getCostScenarioColumn(String costScenario) {
        if (costScenario.equals("a")) {
            return 2;
        }
        if (costScenario.equals("b")) {
            return 3;
        }
        if (costScenario.equals("c")) {
            return 4;
        }
        throw new IllegalStateException("costScenario " + costScenario + " not known");
    }

    public void setCoordProjectionFactor(double coordProjectionFactor) {
        this.coordProjectionFactor = coordProjectionFactor;
    }

    private void close(BufferedReader reader) {
        try {
            reader.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String readLine(BufferedReader reader) {
        try {
            return reader.readLine();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Coordinate makeCoord(String xString, String yString) {
        double x = Double.parseDouble(xString);
        double y = Double.parseDouble(yString);
        return new Coordinate(x * this.coordProjectionFactor, y * this.coordProjectionFactor);
    }

    private BufferedReader getReader(String solomonFile) {
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(solomonFile));
        }
        catch (FileNotFoundException e1) {
            throw new RuntimeException(e1);
        }
        return reader;
    }
}

