/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.instance.reader;

import com.graphhopper.jsprit.core.problem.AbstractJob;
import com.graphhopper.jsprit.core.problem.AbstractVehicle;
import com.graphhopper.jsprit.core.problem.Location;
import com.graphhopper.jsprit.core.problem.VehicleRoutingProblem;
import com.graphhopper.jsprit.core.problem.job.Service;
import com.graphhopper.jsprit.core.problem.solution.route.activity.TimeWindow;
import com.graphhopper.jsprit.core.problem.vehicle.VehicleImpl;
import com.graphhopper.jsprit.core.problem.vehicle.VehicleType;
import com.graphhopper.jsprit.core.problem.vehicle.VehicleTypeImpl;
import com.graphhopper.jsprit.core.util.Coordinate;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolomonReader {
    private static Logger logger = LoggerFactory.getLogger(SolomonReader.class);
    private final VehicleRoutingProblem.Builder vrpBuilder;
    private double coordProjectionFactor = 1.0;
    private double timeProjectionFactor = 1.0;
    private double variableCostProjectionFactor = 1.0;
    private double fixedCostPerVehicle = 0.0;

    public void setVariableCostProjectionFactor(double costProjectionFactor) {
        this.variableCostProjectionFactor = costProjectionFactor;
    }

    public SolomonReader(VehicleRoutingProblem.Builder vrpBuilder) {
        this.vrpBuilder = vrpBuilder;
    }

    public SolomonReader(VehicleRoutingProblem.Builder vrpBuilder, double fixedCostPerVehicle) {
        this.vrpBuilder = vrpBuilder;
        this.fixedCostPerVehicle = fixedCostPerVehicle;
    }

    public void read(String solomonFile) {
        String line;
        this.vrpBuilder.setFleetSize(VehicleRoutingProblem.FleetSize.INFINITE);
        BufferedReader reader = this.getReader(solomonFile);
        int vehicleCapacity = 0;
        int counter = 0;
        while ((line = this.readLine(reader)) != null) {
            line = line.replace("\r", "");
            line = line.trim();
            String[] tokens = line.split(" +");
            if (++counter == 5) {
                vehicleCapacity = Integer.parseInt(tokens[1]);
                continue;
            }
            if (counter <= 9 || tokens.length < 7) continue;
            Coordinate coord = this.makeCoord(tokens[1], tokens[2]);
            String customerId = tokens[0];
            int demand = Integer.parseInt(tokens[3]);
            double start = Double.parseDouble(tokens[4]) * this.timeProjectionFactor;
            double end = Double.parseDouble(tokens[5]) * this.timeProjectionFactor;
            double serviceTime = Double.parseDouble(tokens[6]) * this.timeProjectionFactor;
            if (counter == 10) {
                VehicleTypeImpl.Builder typeBuilder = VehicleTypeImpl.Builder.newInstance((String)"solomonType").addCapacityDimension(0, vehicleCapacity);
                typeBuilder.setCostPerDistance(1.0 * this.variableCostProjectionFactor).setFixedCost(this.fixedCostPerVehicle);
                VehicleTypeImpl vehicleType = typeBuilder.build();
                VehicleImpl vehicle = VehicleImpl.Builder.newInstance((String)"solomonVehicle").setEarliestStart(start).setLatestArrival(end).setStartLocation(Location.Builder.newInstance().setId(customerId).setCoordinate(coord).build()).setType((VehicleType)vehicleType).build();
                this.vrpBuilder.addVehicle((AbstractVehicle)vehicle);
                continue;
            }
            Service service = Service.Builder.newInstance((String)customerId).addSizeDimension(0, demand).setLocation(Location.Builder.newInstance().setCoordinate(coord).setId(customerId).build()).setServiceTime(serviceTime).setTimeWindow(TimeWindow.newInstance((double)start, (double)end)).build();
            this.vrpBuilder.addJob((AbstractJob)service);
        }
        this.close(reader);
    }

    public void setCoordProjectionFactor(double coordProjectionFactor) {
        this.coordProjectionFactor = coordProjectionFactor;
    }

    private void close(BufferedReader reader) {
        try {
            reader.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String readLine(BufferedReader reader) {
        try {
            return reader.readLine();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Coordinate makeCoord(String xString, String yString) {
        double x = Double.parseDouble(xString);
        double y = Double.parseDouble(yString);
        return new Coordinate(x * this.coordProjectionFactor, y * this.coordProjectionFactor);
    }

    private BufferedReader getReader(String solomonFile) {
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(solomonFile));
        }
        catch (FileNotFoundException e1) {
            throw new RuntimeException(e1);
        }
        return reader;
    }

    public void setTimeProjectionFactor(double timeProjection) {
        this.timeProjectionFactor = timeProjection;
    }
}

