/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.instance.reader;

import com.graphhopper.jsprit.core.util.VehicleRoutingTransportCostsMatrix;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;

public class TSPLIB95CostMatrixReader {
    private VehicleRoutingTransportCostsMatrix.Builder costMatrixBuilder;

    public TSPLIB95CostMatrixReader(VehicleRoutingTransportCostsMatrix.Builder costMatrixBuilder) {
        this.costMatrixBuilder = costMatrixBuilder;
    }

    public void read(String matrixFile) {
        String line;
        BufferedReader reader = this.getBufferedReader(matrixFile);
        boolean isEdgeWeights = false;
        int fromIndex = 0;
        while ((line = this.getLine(reader)) != null) {
            if (line.startsWith("EDGE_WEIGHT_SECTION")) {
                isEdgeWeights = true;
                continue;
            }
            if (line.startsWith("DEMAND_SECTION")) {
                isEdgeWeights = false;
                continue;
            }
            if (!isEdgeWeights) continue;
            String[] tokens = line.split("\\s+");
            String fromId = "" + (fromIndex + 1);
            for (int i = 0; i < tokens.length; ++i) {
                double distance = Double.parseDouble(tokens[i]);
                String toId = "" + (i + 1);
                this.costMatrixBuilder.addTransportDistance(fromId, toId, distance);
                this.costMatrixBuilder.addTransportTime(fromId, toId, distance);
            }
            ++fromIndex;
        }
        this.close(reader);
    }

    private void close(BufferedReader reader) {
        try {
            reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String getLine(BufferedReader reader) {
        String s = null;
        try {
            s = reader.readLine();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return s;
    }

    private BufferedReader getBufferedReader(String filename) {
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(new File(filename)));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        return bufferedReader;
    }
}

