/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.instance.reader;

import com.graphhopper.jsprit.core.problem.AbstractJob;
import com.graphhopper.jsprit.core.problem.AbstractVehicle;
import com.graphhopper.jsprit.core.problem.Location;
import com.graphhopper.jsprit.core.problem.VehicleRoutingProblem;
import com.graphhopper.jsprit.core.problem.cost.VehicleRoutingTransportCosts;
import com.graphhopper.jsprit.core.problem.job.Job;
import com.graphhopper.jsprit.core.problem.job.Service;
import com.graphhopper.jsprit.core.problem.vehicle.Vehicle;
import com.graphhopper.jsprit.core.problem.vehicle.VehicleImpl;
import com.graphhopper.jsprit.core.problem.vehicle.VehicleType;
import com.graphhopper.jsprit.core.problem.vehicle.VehicleTypeImpl;
import com.graphhopper.jsprit.core.util.Coordinate;
import com.graphhopper.jsprit.core.util.FastVehicleRoutingTransportCostsMatrix;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class TSPLIB95Reader {
    private VehicleRoutingProblem.Builder vrpBuilder;
    private boolean switchCoordinates = false;

    public void setSwitchCoordinates(boolean switchCoordinates) {
        this.switchCoordinates = switchCoordinates;
    }

    public TSPLIB95Reader(VehicleRoutingProblem.Builder vrpBuilder) {
        this.vrpBuilder = vrpBuilder;
    }

    public void read(String filename) {
        Iterator line;
        String line_;
        BufferedReader reader = this.getBufferedReader(filename);
        Coordinate[] coords = null;
        int[] demands = null;
        Integer capacity = null;
        String edgeType = null;
        String edgeWeightFormat = null;
        ArrayList<Integer> depotIds = new ArrayList<Integer>();
        boolean isCoordSection = false;
        boolean isDemandSection = false;
        boolean isDepotSection = false;
        boolean isEdgeWeightSection = false;
        ArrayList<Double> edgeWeights = new ArrayList<Double>();
        int dimensions = 0;
        int coordIndex = 0;
        HashMap<Integer, Integer> indexMap = new HashMap<Integer, Integer>();
        while ((line_ = this.getLine(reader)) != null && !((String)((Object)(line = line_.trim()))).startsWith("EOF") && !((String)((Object)line)).contains("EOF")) {
            String[] tokens;
            if (((String)((Object)line)).startsWith("DIMENSION")) {
                tokens = ((String)((Object)line)).split(":");
                String string = tokens[1].trim();
                dimensions = Integer.parseInt(string);
                coords = new Coordinate[dimensions];
                demands = new int[dimensions];
                continue;
            }
            if (((String)((Object)line)).startsWith("CAPACITY")) {
                tokens = ((String)((Object)line)).trim().split(":");
                capacity = Integer.parseInt(tokens[1].trim());
                continue;
            }
            if (((String)((Object)line)).startsWith("EDGE_WEIGHT_TYPE")) {
                tokens = ((String)((Object)line)).trim().split(":");
                edgeType = tokens[1].trim();
                continue;
            }
            if (((String)((Object)line)).startsWith("EDGE_WEIGHT_FORMAT")) {
                tokens = ((String)((Object)line)).trim().split(":");
                edgeWeightFormat = tokens[1].trim();
                continue;
            }
            if (((String)((Object)line)).startsWith("NODE_COORD_SECTION")) {
                isCoordSection = true;
                isDemandSection = false;
                isDepotSection = false;
                isEdgeWeightSection = false;
                continue;
            }
            if (((String)((Object)line)).startsWith("DEMAND_SECTION")) {
                isDemandSection = true;
                isCoordSection = false;
                isDepotSection = false;
                isEdgeWeightSection = false;
                continue;
            }
            if (((String)((Object)line)).startsWith("DEPOT_SECTION")) {
                isDepotSection = true;
                isDemandSection = false;
                isCoordSection = false;
                isEdgeWeightSection = false;
                continue;
            }
            if (((String)((Object)line)).startsWith("EDGE_WEIGHT_SECTION")) {
                isDepotSection = false;
                isCoordSection = false;
                isDemandSection = false;
                isEdgeWeightSection = true;
                continue;
            }
            if (((String)((Object)line)).startsWith("DISPLAY_DATA_SECTION")) {
                isDepotSection = false;
                isCoordSection = true;
                isDemandSection = false;
                isEdgeWeightSection = false;
                continue;
            }
            if (isCoordSection) {
                if (coords == null) {
                    throw new IllegalStateException("DIMENSION tag missing");
                }
                tokens = ((String)((Object)line)).trim().split("\\s+");
                Integer n = Integer.parseInt(tokens[0]);
                coords[coordIndex] = this.switchCoordinates ? Coordinate.newInstance((double)Double.parseDouble(tokens[2]), (double)Double.parseDouble(tokens[1])) : Coordinate.newInstance((double)Double.parseDouble(tokens[1]), (double)Double.parseDouble(tokens[2]));
                indexMap.put(n, coordIndex);
                ++coordIndex;
                continue;
            }
            if (isDemandSection) {
                if (demands == null) {
                    throw new IllegalStateException("DIMENSION tag missing");
                }
                tokens = ((String)((Object)line)).trim().split("\\s+");
                Integer n = Integer.parseInt(tokens[0]);
                int index = (Integer)indexMap.get(n);
                demands[index] = Integer.parseInt(tokens[1]);
                continue;
            }
            if (isDepotSection) {
                if (((String)((Object)line)).equals("-1")) {
                    isDepotSection = false;
                    continue;
                }
                depotIds.add(Integer.parseInt(line));
                continue;
            }
            if (!isEdgeWeightSection) continue;
            for (String s : tokens = ((String)((Object)line)).trim().split("\\s+")) {
                edgeWeights.add(Double.parseDouble(s));
            }
        }
        this.close(reader);
        this.vrpBuilder.setFleetSize(VehicleRoutingProblem.FleetSize.FINITE);
        for (Integer depotId : depotIds) {
            VehicleTypeImpl vehicleTypeImpl = VehicleTypeImpl.Builder.newInstance((String)"type").addCapacityDimension(0, capacity.intValue()).build();
            VehicleImpl vehicle = VehicleImpl.Builder.newInstance((String)"vehicle").setStartLocation(Location.Builder.newInstance().setId(depotId.toString()).setCoordinate(coords[depotId - 1]).build()).setType((VehicleType)vehicleTypeImpl).build();
            this.vrpBuilder.addVehicle((AbstractVehicle)vehicle);
        }
        for (Iterator id_ : indexMap.keySet()) {
            String string = ((Integer)((Object)id_)).toString();
            int index = (Integer)indexMap.get(id_);
            if (depotIds.isEmpty() && index == 0) {
                VehicleImpl vehicle = VehicleImpl.Builder.newInstance((String)"traveling_salesman").setStartLocation(Location.Builder.newInstance().setId(string).setCoordinate(coords[index]).setIndex(index).build()).build();
                this.vrpBuilder.addVehicle((AbstractVehicle)vehicle);
                continue;
            }
            Service service = Service.Builder.newInstance((String)string).setLocation(Location.Builder.newInstance().setId(string).setCoordinate(coords[index]).setIndex(index).build()).addSizeDimension(0, demands[index]).build();
            this.vrpBuilder.addJob((AbstractJob)service);
        }
        if (edgeType.equals("GEO")) {
            ArrayList<Location> locations = new ArrayList<Location>();
            for (Vehicle vehicle : this.vrpBuilder.getAddedVehicles()) {
                locations.add(vehicle.getStartLocation());
            }
            for (Job job : this.vrpBuilder.getAddedJobs()) {
                locations.add(((Service)job).getLocation());
            }
            this.vrpBuilder.setRoutingCost(this.getGEOMatrix(locations));
        } else if (edgeType.equals("EXPLICIT")) {
            FastVehicleRoutingTransportCostsMatrix.Builder matrixBuilder;
            if (edgeWeightFormat.equals("UPPER_ROW")) {
                matrixBuilder = FastVehicleRoutingTransportCostsMatrix.Builder.newInstance((int)dimensions, (boolean)true);
                int fromIndex = 0;
                boolean bl = true;
                for (int i = 0; i < edgeWeights.size(); ++i) {
                    int n;
                    if (n == dimensions) {
                        n = ++fromIndex + 1;
                    }
                    matrixBuilder.addTransportDistance(fromIndex, n, ((Double)edgeWeights.get(i)).doubleValue());
                    matrixBuilder.addTransportTime(fromIndex, n, ((Double)edgeWeights.get(i)).doubleValue());
                    ++n;
                }
                this.vrpBuilder.setRoutingCost((VehicleRoutingTransportCosts)matrixBuilder.build());
            } else if (edgeWeightFormat.equals("UPPER_DIAG_ROW")) {
                matrixBuilder = FastVehicleRoutingTransportCostsMatrix.Builder.newInstance((int)dimensions, (boolean)true);
                int fromIndex = 0;
                boolean bl = false;
                for (int i = 0; i < edgeWeights.size(); ++i) {
                    int n;
                    if (n == dimensions) {
                        n = ++fromIndex;
                    }
                    matrixBuilder.addTransportDistance(fromIndex, n, ((Double)edgeWeights.get(i)).doubleValue());
                    matrixBuilder.addTransportTime(fromIndex, n, ((Double)edgeWeights.get(i)).doubleValue());
                    ++n;
                }
                this.vrpBuilder.setRoutingCost((VehicleRoutingTransportCosts)matrixBuilder.build());
            } else if (edgeWeightFormat.equals("LOWER_DIAG_ROW")) {
                matrixBuilder = FastVehicleRoutingTransportCostsMatrix.Builder.newInstance((int)dimensions, (boolean)true);
                int fromIndex = 0;
                boolean bl = false;
                for (int i = 0; i < edgeWeights.size(); ++i) {
                    int n;
                    if (n > fromIndex) {
                        ++fromIndex;
                        n = 0;
                    }
                    matrixBuilder.addTransportDistance(fromIndex, n, ((Double)edgeWeights.get(i)).doubleValue());
                    matrixBuilder.addTransportTime(fromIndex, n, ((Double)edgeWeights.get(i)).doubleValue());
                    ++n;
                }
                this.vrpBuilder.setRoutingCost((VehicleRoutingTransportCosts)matrixBuilder.build());
            } else if (edgeWeightFormat.equals("FULL_MATRIX")) {
                matrixBuilder = FastVehicleRoutingTransportCostsMatrix.Builder.newInstance((int)dimensions, (boolean)false);
                int fromIndex = 0;
                boolean bl = false;
                for (int i = 0; i < edgeWeights.size(); ++i) {
                    int n;
                    if (n == dimensions) {
                        ++fromIndex;
                        n = 0;
                    }
                    matrixBuilder.addTransportDistance(fromIndex, n, ((Double)edgeWeights.get(i)).doubleValue());
                    matrixBuilder.addTransportTime(fromIndex, n, ((Double)edgeWeights.get(i)).doubleValue());
                    ++n;
                }
                this.vrpBuilder.setRoutingCost((VehicleRoutingTransportCosts)matrixBuilder.build());
            }
        }
    }

    private VehicleRoutingTransportCosts getGEOMatrix(List<Location> noLocations) {
        FastVehicleRoutingTransportCostsMatrix.Builder matrixBuilder = FastVehicleRoutingTransportCostsMatrix.Builder.newInstance((int)noLocations.size(), (boolean)true);
        for (Location i : noLocations) {
            for (Location j : noLocations) {
                matrixBuilder.addTransportDistance(i.getIndex(), j.getIndex(), this.getDistance(i, j));
                matrixBuilder.addTransportTime(i.getIndex(), j.getIndex(), this.getDistance(i, j));
            }
        }
        return matrixBuilder.build();
    }

    private double getDistance(Location from, Location to) {
        double longitude_from = this.getLongitude(from);
        double longitude_to = this.getLongitude(to);
        double latitude_from = this.getLatitude(from);
        double latitude_to = this.getLatitude(to);
        double q1 = Math.cos(longitude_from - longitude_to);
        double q2 = Math.cos(latitude_from - latitude_to);
        double q3 = Math.cos(latitude_from + latitude_to);
        return 6378.388 * Math.acos(0.5 * ((1.0 + q1) * q2 - (1.0 - q1) * q3)) + 1.0;
    }

    private double getLatitude(Location loc) {
        int deg = (int)loc.getCoordinate().getX();
        double min = loc.getCoordinate().getX() - (double)deg;
        return Math.PI * ((double)deg + 5.0 * min / 3.0) / 180.0;
    }

    private double getLongitude(Location loc) {
        int deg = (int)loc.getCoordinate().getY();
        double min = loc.getCoordinate().getY() - (double)deg;
        return Math.PI * ((double)deg + 5.0 * min / 3.0) / 180.0;
    }

    private void close(BufferedReader reader) {
        try {
            reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String getLine(BufferedReader reader) {
        String s = null;
        try {
            s = reader.readLine();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return s;
    }

    private BufferedReader getBufferedReader(String filename) {
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(new File(filename)));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        return bufferedReader;
    }
}

