/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.instance.reader;

import com.graphhopper.jsprit.core.problem.AbstractJob;
import com.graphhopper.jsprit.core.problem.AbstractVehicle;
import com.graphhopper.jsprit.core.problem.Location;
import com.graphhopper.jsprit.core.problem.VehicleRoutingProblem;
import com.graphhopper.jsprit.core.problem.job.Service;
import com.graphhopper.jsprit.core.problem.vehicle.VehicleImpl;
import com.graphhopper.jsprit.core.problem.vehicle.VehicleType;
import com.graphhopper.jsprit.core.problem.vehicle.VehicleTypeImpl;
import com.graphhopper.jsprit.core.util.Coordinate;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;

public class VrphGoldenReader {
    private final VehicleRoutingProblem.Builder vrpBuilder;
    private final VrphType vrphType;

    public VrphGoldenReader(VehicleRoutingProblem.Builder vrpBuilder, VrphType vrphType) {
        this.vrpBuilder = vrpBuilder;
        this.vrphType = vrphType;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void read(String filename) {
        String line;
        BufferedReader reader = this.getReader(filename);
        boolean firstline = true;
        Coordinate depotCoord = null;
        int customerCount = 0;
        Integer nuOfCustomer = 0;
        while ((line = this.readLine(reader)) != null) {
            String trimedLine = line.trim();
            if (trimedLine.startsWith("//")) continue;
            String[] tokens = trimedLine.split("\\s+");
            if (firstline) {
                nuOfCustomer = Integer.parseInt(tokens[0]);
                customerCount = 0;
                firstline = false;
                continue;
            }
            if (customerCount <= nuOfCustomer) {
                if (customerCount == 0) {
                    depotCoord = Coordinate.newInstance((double)Double.parseDouble(tokens[1]), (double)Double.parseDouble(tokens[2]));
                } else {
                    Service.Builder serviceBuilder = Service.Builder.newInstance((String)tokens[0]).addSizeDimension(0, Integer.parseInt(tokens[3]));
                    serviceBuilder.setLocation(Location.newInstance((double)Double.parseDouble(tokens[1]), (double)Double.parseDouble(tokens[2])));
                    this.vrpBuilder.addJob((AbstractJob)serviceBuilder.build());
                }
                ++customerCount;
                continue;
            }
            if (!trimedLine.startsWith("v")) continue;
            VehicleTypeImpl.Builder typeBuilder = VehicleTypeImpl.Builder.newInstance((String)("type_" + tokens[1])).addCapacityDimension(0, Integer.parseInt(tokens[2]));
            int nuOfVehicles = 1;
            if (this.vrphType.equals((Object)VrphType.FSMF)) {
                typeBuilder.setFixedCost(Double.parseDouble(tokens[3]));
            } else if (this.vrphType.equals((Object)VrphType.FSMFD)) {
                typeBuilder.setFixedCost(Double.parseDouble(tokens[3]));
                if (tokens.length <= 4) throw new IllegalStateException("option " + (Object)((Object)this.vrphType) + " cannot be applied with this instance");
                typeBuilder.setCostPerDistance(Double.parseDouble(tokens[4]));
            } else if (this.vrphType.equals((Object)VrphType.FSMD)) {
                if (tokens.length <= 4) throw new IllegalStateException("option " + (Object)((Object)this.vrphType) + " cannot be applied with this instance");
                typeBuilder.setCostPerDistance(Double.parseDouble(tokens[4]));
            } else if (this.vrphType.equals((Object)VrphType.HVRPD)) {
                if (tokens.length <= 4) throw new IllegalStateException("option " + (Object)((Object)this.vrphType) + " cannot be applied with this instance");
                typeBuilder.setCostPerDistance(Double.parseDouble(tokens[4]));
                nuOfVehicles = Integer.parseInt(tokens[5]);
                this.vrpBuilder.setFleetSize(VehicleRoutingProblem.FleetSize.FINITE);
            } else if (this.vrphType.equals((Object)VrphType.HVRPFD)) {
                if (tokens.length <= 4) throw new IllegalStateException("option " + (Object)((Object)this.vrphType) + " cannot be applied with this instance");
                typeBuilder.setFixedCost(Double.parseDouble(tokens[3]));
                typeBuilder.setCostPerDistance(Double.parseDouble(tokens[4]));
                nuOfVehicles = Integer.parseInt(tokens[5]);
                this.vrpBuilder.setFleetSize(VehicleRoutingProblem.FleetSize.FINITE);
            }
            for (int i = 0; i < nuOfVehicles; ++i) {
                VehicleTypeImpl type = typeBuilder.build();
                VehicleImpl vehicle = VehicleImpl.Builder.newInstance((String)("vehicle_" + tokens[1] + "_" + i)).setStartLocation(Location.newInstance((double)depotCoord.getX(), (double)depotCoord.getY())).setType((VehicleType)type).build();
                this.vrpBuilder.addVehicle((AbstractVehicle)vehicle);
            }
        }
        this.closeReader(reader);
    }

    private void closeReader(BufferedReader reader) {
        try {
            reader.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String readLine(BufferedReader reader) {
        String readLine = null;
        try {
            readLine = reader.readLine();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return readLine;
    }

    private BufferedReader getReader(String filename) {
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(new File(filename)));
            return bufferedReader;
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static enum VrphType {
        FSMD,
        HVRPD,
        FSMF,
        FSMFD,
        HVRPFD;

    }
}

