/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.instance.util;

import com.graphhopper.jsprit.core.problem.VehicleRoutingProblem;
import com.graphhopper.jsprit.core.util.BenchmarkInstance;
import com.graphhopper.jsprit.instance.reader.ChristofidesReader;
import com.graphhopper.jsprit.instance.reader.CordeauReader;
import com.graphhopper.jsprit.instance.reader.SolomonReader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class Instances {
    public static Collection<BenchmarkInstance> getAllCordeauP(String inputFolder) {
        ArrayList<BenchmarkInstance> instances = new ArrayList<BenchmarkInstance>();
        for (int i = 0; i < 23; ++i) {
            VehicleRoutingProblem.Builder builder = VehicleRoutingProblem.Builder.newInstance();
            String file = inputFolder + "/p" + Instances.getInstanceNu(i + 1);
            new CordeauReader(builder).read(file);
            VehicleRoutingProblem p = builder.build();
            instances.add(new BenchmarkInstance("p" + Instances.getInstanceNu(i + 1), p, Double.valueOf(Instances.getBestKnown(file)), null));
        }
        return instances;
    }

    private static double getBestKnown(String file) {
        try {
            BufferedReader reader = new BufferedReader(new FileReader(new File(file + ".res")));
            String first = reader.readLine();
            Double result = Double.valueOf(first);
            reader.close();
            return result;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return 0.0;
    }

    private static String getInstanceNu(int i) {
        if (i < 10) {
            return "0" + i;
        }
        return "" + i;
    }

    public static Collection<BenchmarkInstance> getAllCordeauPR(String inputFolder) {
        ArrayList<BenchmarkInstance> instances = new ArrayList<BenchmarkInstance>();
        for (int i = 0; i < 10; ++i) {
            VehicleRoutingProblem.Builder builder = VehicleRoutingProblem.Builder.newInstance();
            String file = inputFolder + "/pr" + Instances.getInstanceNu(i + 1);
            new CordeauReader(builder).read(file);
            VehicleRoutingProblem p = builder.build();
            instances.add(new BenchmarkInstance("pr" + Instances.getInstanceNu(i + 1), p, Double.valueOf(Instances.getBestKnown(file)), null));
        }
        return instances;
    }

    public static Collection<BenchmarkInstance> getAllChristofides(String inputFolder) {
        List<Double> bestKnown = Arrays.asList(524.61, 835.26, 826.14, 1028.42, 1291.29, 555.43, 909.68, 865.49, 1162.55, 1395.85, 1042.11, 819.56, 1541.14, 866.37);
        ArrayList<BenchmarkInstance> instances = new ArrayList<BenchmarkInstance>();
        for (int i = 0; i < 14; ++i) {
            VehicleRoutingProblem.Builder builder = VehicleRoutingProblem.Builder.newInstance();
            String file = inputFolder + "/vrpnc" + (i + 1) + ".txt";
            new ChristofidesReader(builder).read(file);
            VehicleRoutingProblem p = builder.build();
            instances.add(new BenchmarkInstance("vrpnc" + Instances.getInstanceNu(i + 1), p, Double.valueOf(bestKnown.get(i)), null));
        }
        return instances;
    }

    public static Collection<BenchmarkInstance> getAllSolomonC1(String inputFolder) {
        List<Double> bestKnown = Arrays.asList(828.94, 828.94, 828.06, 824.78, 828.94, 828.94, 828.94, 828.94, 828.94);
        List<Double> bestKnowVehicles = Arrays.asList(10.0, 10.0, 10.0, 10.0, 10.0, 10.0, 10.0, 10.0, 10.0);
        ArrayList<BenchmarkInstance> instances = new ArrayList<BenchmarkInstance>();
        for (int i = 0; i < 9; ++i) {
            VehicleRoutingProblem.Builder builder = VehicleRoutingProblem.Builder.newInstance();
            String file = inputFolder + "/C1" + Instances.getInstanceNu(i + 1) + ".txt";
            new SolomonReader(builder).read(file);
            VehicleRoutingProblem p = builder.build();
            instances.add(new BenchmarkInstance("C1" + Instances.getInstanceNu(i + 1), p, Double.valueOf(bestKnown.get(i)), Double.valueOf(bestKnowVehicles.get(i))));
        }
        return instances;
    }

    public static Collection<BenchmarkInstance> getAllSolomonC2(String inputFolder) {
        List<Double> bestKnown = Arrays.asList(591.56, 591.56, 591.17, 590.6, 588.88, 588.49, 588.29, 588.32);
        List<Double> bestKnowVehicles = Arrays.asList(3.0, 3.0, 3.0, 3.0, 3.0, 3.0, 3.0, 3.0);
        ArrayList<BenchmarkInstance> instances = new ArrayList<BenchmarkInstance>();
        for (int i = 0; i < 8; ++i) {
            VehicleRoutingProblem.Builder builder = VehicleRoutingProblem.Builder.newInstance();
            String file = inputFolder + "/C2" + Instances.getInstanceNu(i + 1) + ".txt";
            new SolomonReader(builder).read(file);
            VehicleRoutingProblem p = builder.build();
            instances.add(new BenchmarkInstance("C2" + Instances.getInstanceNu(i + 1), p, Double.valueOf(bestKnown.get(i)), Double.valueOf(bestKnowVehicles.get(i))));
        }
        return instances;
    }

    public static Collection<BenchmarkInstance> getAllSolomonR1(String inputFolder) {
        List<Double> bestKnown = Arrays.asList(1650.8, 1486.12, 1292.68, 1007.31, 1377.11, 1252.03, 1104.66, 960.88, 1194.73, 1118.84, 1096.72, 982.14);
        List<Double> bestKnowVehicles = Arrays.asList(19.0, 17.0, 13.0, 9.0, 14.0, 12.0, 10.0, 9.0, 11.0, 10.0, 10.0, 9.0);
        ArrayList<BenchmarkInstance> instances = new ArrayList<BenchmarkInstance>();
        for (int i = 0; i < 12; ++i) {
            VehicleRoutingProblem.Builder builder = VehicleRoutingProblem.Builder.newInstance();
            String file = inputFolder + "/R1" + Instances.getInstanceNu(i + 1) + ".txt";
            new SolomonReader(builder).read(file);
            VehicleRoutingProblem p = builder.build();
            instances.add(new BenchmarkInstance("R1" + Instances.getInstanceNu(i + 1), p, Double.valueOf(bestKnown.get(i)), Double.valueOf(bestKnowVehicles.get(i))));
        }
        return instances;
    }

    public static Collection<BenchmarkInstance> getAllSolomonR2(String inputFolder) {
        List<Double> bestKnown = Arrays.asList(1252.37, 1191.7, 939.5, 825.52, 994.42, 906.14, 890.61, 726.82, 909.16, 939.37, 885.71);
        List<Double> bestKnowVehicles = Arrays.asList(4.0, 3.0, 3.0, 2.0, 3.0, 3.0, 2.0, 2.0, 3.0, 3.0, 2.0);
        ArrayList<BenchmarkInstance> instances = new ArrayList<BenchmarkInstance>();
        for (int i = 0; i < 11; ++i) {
            VehicleRoutingProblem.Builder builder = VehicleRoutingProblem.Builder.newInstance();
            String file = inputFolder + "/R2" + Instances.getInstanceNu(i + 1) + ".txt";
            new SolomonReader(builder).read(file);
            VehicleRoutingProblem p = builder.build();
            instances.add(new BenchmarkInstance("R2" + Instances.getInstanceNu(i + 1), p, Double.valueOf(bestKnown.get(i)), Double.valueOf(bestKnowVehicles.get(i))));
        }
        return instances;
    }

    public static Collection<BenchmarkInstance> getAllSolomonRC1(String inputFolder) {
        List<Double> bestKnown = Arrays.asList(1696.94, 1554.75, 1261.67, 1135.48, 1629.44, 1424.73, 1230.48, 1139.82);
        List<Double> bestKnowVehicles = Arrays.asList(14.0, 12.0, 11.0, 10.0, 13.0, 11.0, 11.0, 10.0);
        ArrayList<BenchmarkInstance> instances = new ArrayList<BenchmarkInstance>();
        for (int i = 0; i < 8; ++i) {
            VehicleRoutingProblem.Builder builder = VehicleRoutingProblem.Builder.newInstance();
            String file = inputFolder + "/RC1" + Instances.getInstanceNu(i + 1) + ".txt";
            new SolomonReader(builder).read(file);
            VehicleRoutingProblem p = builder.build();
            instances.add(new BenchmarkInstance("RC1" + Instances.getInstanceNu(i + 1), p, Double.valueOf(bestKnown.get(i)), Double.valueOf(bestKnowVehicles.get(i))));
        }
        return instances;
    }

    public static Collection<BenchmarkInstance> getAllSolomonRC2(String inputFolder) {
        List<Double> bestKnown = Arrays.asList(1406.94, 1365.65, 1049.62, 798.46, 1297.65, 1146.32, 1061.14, 828.14);
        List<Double> bestKnowVehicles = Arrays.asList(4.0, 3.0, 3.0, 3.0, 4.0, 3.0, 3.0, 3.0);
        ArrayList<BenchmarkInstance> instances = new ArrayList<BenchmarkInstance>();
        for (int i = 0; i < 8; ++i) {
            VehicleRoutingProblem.Builder builder = VehicleRoutingProblem.Builder.newInstance();
            String file = inputFolder + "/RC2" + Instances.getInstanceNu(i + 1) + ".txt";
            new SolomonReader(builder).read(file);
            VehicleRoutingProblem p = builder.build();
            instances.add(new BenchmarkInstance("RC2" + Instances.getInstanceNu(i + 1), p, Double.valueOf(bestKnown.get(i)), Double.valueOf(bestKnowVehicles.get(i))));
        }
        return instances;
    }
}

