/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.io.algorithm;

import com.graphhopper.jsprit.core.util.Resource;
import com.graphhopper.jsprit.io.algorithm.AlgorithmConfig;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.commons.configuration.ConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class AlgorithmConfigXmlReader {
    private static Logger log = LoggerFactory.getLogger((String)AlgorithmConfigXmlReader.class.getName());
    private AlgorithmConfig algorithmConfig;
    private boolean schemaValidation = true;

    public AlgorithmConfigXmlReader setSchemaValidation(boolean schemaValidation) {
        this.schemaValidation = schemaValidation;
        return this;
    }

    public AlgorithmConfigXmlReader(AlgorithmConfig algorithmConfig) {
        this.algorithmConfig = algorithmConfig;
    }

    public void read(URL url) {
        log.debug("read algorithm: " + url);
        this.algorithmConfig.getXMLConfiguration().setURL(url);
        this.algorithmConfig.getXMLConfiguration().setAttributeSplittingDisabled(true);
        this.algorithmConfig.getXMLConfiguration().setDelimiterParsingDisabled(true);
        if (this.schemaValidation) {
            final InputStream resource = Resource.getAsInputStream((String)"algorithm_schema.xsd");
            if (resource != null) {
                EntityResolver resolver = new EntityResolver(){

                    @Override
                    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                        InputSource is = new InputSource(resource);
                        return is;
                    }
                };
                this.algorithmConfig.getXMLConfiguration().setEntityResolver(resolver);
                this.algorithmConfig.getXMLConfiguration().setSchemaValidation(true);
            } else {
                log.warn("cannot find schema-xsd file (algorithm_xml_schema.xsd). try to read xml without xml-file-validation.");
            }
        }
        try {
            this.algorithmConfig.getXMLConfiguration().load();
        }
        catch (ConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    public void read(String filename) {
        log.debug("read algorithm-config from file " + filename);
        URL url = Resource.getAsURL((String)filename);
        this.read(url);
    }
}

