/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.io.algorithm;

import com.graphhopper.jsprit.core.algorithm.PrettyAlgorithmBuilder;
import com.graphhopper.jsprit.core.algorithm.SearchStrategy;
import com.graphhopper.jsprit.core.algorithm.SearchStrategyModule;
import com.graphhopper.jsprit.core.algorithm.VariablePlusFixedSolutionCostCalculatorFactory;
import com.graphhopper.jsprit.core.algorithm.VehicleRoutingAlgorithm;
import com.graphhopper.jsprit.core.algorithm.acceptor.AcceptNewRemoveFirst;
import com.graphhopper.jsprit.core.algorithm.acceptor.ExperimentalSchrimpfAcceptance;
import com.graphhopper.jsprit.core.algorithm.acceptor.GreedyAcceptance;
import com.graphhopper.jsprit.core.algorithm.acceptor.SchrimpfAcceptance;
import com.graphhopper.jsprit.core.algorithm.acceptor.SchrimpfInitialThresholdGenerator;
import com.graphhopper.jsprit.core.algorithm.acceptor.SolutionAcceptor;
import com.graphhopper.jsprit.core.algorithm.listener.AlgorithmEndsListener;
import com.graphhopper.jsprit.core.algorithm.listener.VehicleRoutingAlgorithmListener;
import com.graphhopper.jsprit.core.algorithm.listener.VehicleRoutingAlgorithmListeners;
import com.graphhopper.jsprit.core.algorithm.module.RuinAndRecreateModule;
import com.graphhopper.jsprit.core.algorithm.recreate.InsertionStrategy;
import com.graphhopper.jsprit.core.algorithm.ruin.ClusterRuinStrategyFactory;
import com.graphhopper.jsprit.core.algorithm.ruin.JobNeighborhoods;
import com.graphhopper.jsprit.core.algorithm.ruin.JobNeighborhoodsFactory;
import com.graphhopper.jsprit.core.algorithm.ruin.RadialRuinStrategyFactory;
import com.graphhopper.jsprit.core.algorithm.ruin.RandomRuinStrategyFactory;
import com.graphhopper.jsprit.core.algorithm.ruin.RuinStrategy;
import com.graphhopper.jsprit.core.algorithm.ruin.distance.AvgServiceAndShipmentDistance;
import com.graphhopper.jsprit.core.algorithm.ruin.distance.JobDistance;
import com.graphhopper.jsprit.core.algorithm.selector.SelectBest;
import com.graphhopper.jsprit.core.algorithm.selector.SelectRandomly;
import com.graphhopper.jsprit.core.algorithm.selector.SolutionSelector;
import com.graphhopper.jsprit.core.algorithm.state.StateManager;
import com.graphhopper.jsprit.core.algorithm.state.StateUpdater;
import com.graphhopper.jsprit.core.algorithm.state.UpdateActivityTimes;
import com.graphhopper.jsprit.core.algorithm.state.UpdateEndLocationIfRouteIsOpen;
import com.graphhopper.jsprit.core.algorithm.state.UpdateVariableCosts;
import com.graphhopper.jsprit.core.algorithm.state.UpdateVehicleDependentPracticalTimeWindows;
import com.graphhopper.jsprit.core.algorithm.termination.IterationWithoutImprovementTermination;
import com.graphhopper.jsprit.core.algorithm.termination.PrematureAlgorithmTermination;
import com.graphhopper.jsprit.core.algorithm.termination.TimeTermination;
import com.graphhopper.jsprit.core.algorithm.termination.VariationCoefficientTermination;
import com.graphhopper.jsprit.core.problem.VehicleRoutingProblem;
import com.graphhopper.jsprit.core.problem.constraint.ConstraintManager;
import com.graphhopper.jsprit.core.problem.constraint.HardRouteConstraint;
import com.graphhopper.jsprit.core.problem.constraint.SwitchNotFeasible;
import com.graphhopper.jsprit.core.problem.cost.ForwardTransportTime;
import com.graphhopper.jsprit.core.problem.solution.SolutionCostCalculator;
import com.graphhopper.jsprit.core.problem.solution.VehicleRoutingProblemSolution;
import com.graphhopper.jsprit.core.problem.solution.route.VehicleRoute;
import com.graphhopper.jsprit.core.problem.solution.route.activity.End;
import com.graphhopper.jsprit.core.problem.solution.route.activity.ReverseActivityVisitor;
import com.graphhopper.jsprit.core.problem.solution.route.activity.TourActivity;
import com.graphhopper.jsprit.core.problem.solution.route.state.RouteAndActivityStateGetter;
import com.graphhopper.jsprit.core.problem.vehicle.FiniteFleetManagerFactory;
import com.graphhopper.jsprit.core.problem.vehicle.InfiniteFleetManagerFactory;
import com.graphhopper.jsprit.core.problem.vehicle.Vehicle;
import com.graphhopper.jsprit.core.problem.vehicle.VehicleFleetManager;
import com.graphhopper.jsprit.core.problem.vehicle.VehicleTypeKey;
import com.graphhopper.jsprit.core.util.ActivityTimeTracker;
import com.graphhopper.jsprit.io.algorithm.AlgorithmConfig;
import com.graphhopper.jsprit.io.algorithm.AlgorithmConfigXmlReader;
import com.graphhopper.jsprit.io.algorithm.InsertionFactory;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.XMLConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VehicleRoutingAlgorithms {
    private static Logger log = LoggerFactory.getLogger((String)VehicleRoutingAlgorithms.class.getName());

    private VehicleRoutingAlgorithms() {
    }

    public static VehicleRoutingAlgorithm createAlgorithm(VehicleRoutingProblem vrp, AlgorithmConfig algorithmConfig) {
        return VehicleRoutingAlgorithms.createAlgo(vrp, algorithmConfig.getXMLConfiguration(), 0, null);
    }

    public static VehicleRoutingAlgorithm createAlgorithm(VehicleRoutingProblem vrp, int nThreads, AlgorithmConfig algorithmConfig) {
        return VehicleRoutingAlgorithms.createAlgo(vrp, algorithmConfig.getXMLConfiguration(), nThreads, null);
    }

    public static VehicleRoutingAlgorithm readAndCreateAlgorithm(VehicleRoutingProblem vrp, URL configURL) {
        AlgorithmConfig algorithmConfig = new AlgorithmConfig();
        AlgorithmConfigXmlReader xmlReader = new AlgorithmConfigXmlReader(algorithmConfig);
        xmlReader.read(configURL);
        return VehicleRoutingAlgorithms.createAlgo(vrp, algorithmConfig.getXMLConfiguration(), 0, null);
    }

    public static VehicleRoutingAlgorithm readAndCreateAlgorithm(VehicleRoutingProblem vrp, int nThreads, URL configURL) {
        AlgorithmConfig algorithmConfig = new AlgorithmConfig();
        AlgorithmConfigXmlReader xmlReader = new AlgorithmConfigXmlReader(algorithmConfig);
        xmlReader.read(configURL);
        return VehicleRoutingAlgorithms.createAlgo(vrp, algorithmConfig.getXMLConfiguration(), nThreads, null);
    }

    public static VehicleRoutingAlgorithm readAndCreateAlgorithm(VehicleRoutingProblem vrp, String configFileName) {
        AlgorithmConfig algorithmConfig = new AlgorithmConfig();
        AlgorithmConfigXmlReader xmlReader = new AlgorithmConfigXmlReader(algorithmConfig);
        xmlReader.read(configFileName);
        return VehicleRoutingAlgorithms.createAlgo(vrp, algorithmConfig.getXMLConfiguration(), 0, null);
    }

    public static VehicleRoutingAlgorithm readAndCreateAlgorithm(VehicleRoutingProblem vrp, String configFileName, StateManager stateManager) {
        AlgorithmConfig algorithmConfig = new AlgorithmConfig();
        AlgorithmConfigXmlReader xmlReader = new AlgorithmConfigXmlReader(algorithmConfig);
        xmlReader.read(configFileName);
        return VehicleRoutingAlgorithms.createAlgo(vrp, algorithmConfig.getXMLConfiguration(), 0, stateManager);
    }

    public static VehicleRoutingAlgorithm readAndCreateAlgorithm(VehicleRoutingProblem vrp, int nThreads, String configFileName, StateManager stateManager) {
        AlgorithmConfig algorithmConfig = new AlgorithmConfig();
        AlgorithmConfigXmlReader xmlReader = new AlgorithmConfigXmlReader(algorithmConfig);
        xmlReader.read(configFileName);
        return VehicleRoutingAlgorithms.createAlgo(vrp, algorithmConfig.getXMLConfiguration(), nThreads, stateManager);
    }

    public static VehicleRoutingAlgorithm readAndCreateAlgorithm(VehicleRoutingProblem vrp, int nThreads, String configFileName) {
        AlgorithmConfig algorithmConfig = new AlgorithmConfig();
        AlgorithmConfigXmlReader xmlReader = new AlgorithmConfigXmlReader(algorithmConfig);
        xmlReader.read(configFileName);
        return VehicleRoutingAlgorithms.createAlgo(vrp, algorithmConfig.getXMLConfiguration(), nThreads, null);
    }

    private static VehicleRoutingAlgorithm createAlgo(VehicleRoutingProblem vrp, XMLConfiguration config, int nuOfThreads, StateManager stateMan) {
        StateManager stateManager = stateMan != null ? stateMan : new StateManager(vrp);
        stateManager.updateLoadStates();
        stateManager.updateTimeWindowStates();
        stateManager.updateSkillStates();
        stateManager.addStateUpdater((StateUpdater)new UpdateEndLocationIfRouteIsOpen());
        stateManager.addStateUpdater((StateUpdater)new OpenRouteStateVerifier());
        ConstraintManager constraintManager = new ConstraintManager(vrp, (RouteAndActivityStateGetter)stateManager);
        constraintManager.addTimeWindowConstraint();
        constraintManager.addLoadConstraint();
        constraintManager.addSkillsConstraint();
        constraintManager.addConstraint((HardRouteConstraint)new SwitchNotFeasible(stateManager));
        return VehicleRoutingAlgorithms.readAndCreateAlgorithm(vrp, config, nuOfThreads, null, stateManager, constraintManager, true, true);
    }

    public static VehicleRoutingAlgorithm readAndCreateAlgorithm(VehicleRoutingProblem vrp, AlgorithmConfig config, int nuOfThreads, SolutionCostCalculator solutionCostCalculator, StateManager stateManager, ConstraintManager constraintManager, boolean addDefaultCostCalculators) {
        return VehicleRoutingAlgorithms.readAndCreateAlgorithm(vrp, config.getXMLConfiguration(), nuOfThreads, solutionCostCalculator, stateManager, constraintManager, addDefaultCostCalculators);
    }

    public static VehicleRoutingAlgorithm readAndCreateAlgorithm(VehicleRoutingProblem vrp, AlgorithmConfig config, int nuOfThreads, SolutionCostCalculator solutionCostCalculator, StateManager stateManager, ConstraintManager constraintManager, boolean addDefaultCostCalculators, boolean addCoreConstraints) {
        return VehicleRoutingAlgorithms.readAndCreateAlgorithm(vrp, config.getXMLConfiguration(), nuOfThreads, solutionCostCalculator, stateManager, constraintManager, addDefaultCostCalculators, addCoreConstraints);
    }

    private static VehicleRoutingAlgorithm readAndCreateAlgorithm(VehicleRoutingProblem vrp, XMLConfiguration config, int nuOfThreads, SolutionCostCalculator solutionCostCalculator, StateManager stateManager, ConstraintManager constraintManager, boolean addDefaultCostCalculators) {
        return VehicleRoutingAlgorithms.readAndCreateAlgorithm(vrp, config, nuOfThreads, solutionCostCalculator, stateManager, constraintManager, addDefaultCostCalculators, true);
    }

    private static VehicleRoutingAlgorithm readAndCreateAlgorithm(final VehicleRoutingProblem vrp, XMLConfiguration config, int nuOfThreads, SolutionCostCalculator solutionCostCalculator, StateManager stateManager, ConstraintManager constraintManager, boolean addDefaultCostCalculators, boolean addCoreConstraints) {
        PrematureAlgorithmTermination prematureAlgorithmTermination;
        InsertionStrategy initialInsertionStrategy;
        ActivityTimeTracker.ActivityPolicy activityPolicy;
        ExecutorService executorService;
        TypedMap definedClasses = new TypedMap();
        HashSet<VehicleRoutingAlgorithmListeners.PrioritizedVRAListener> algorithmListeners = new HashSet<VehicleRoutingAlgorithmListeners.PrioritizedVRAListener>();
        ArrayList insertionListeners = new ArrayList();
        if (nuOfThreads > 0) {
            log.debug("setup executor-service with " + nuOfThreads + " threads");
            executorService = Executors.newFixedThreadPool(nuOfThreads);
            algorithmListeners.add(new VehicleRoutingAlgorithmListeners.PrioritizedVRAListener(VehicleRoutingAlgorithmListeners.Priority.LOW, (VehicleRoutingAlgorithmListener)new AlgorithmEndsListener(){

                public void informAlgorithmEnds(VehicleRoutingProblem problem, Collection<VehicleRoutingProblemSolution> solutions) {
                    log.debug("shutdown executor-service");
                    executorService.shutdown();
                }
            }));
            Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                @Override
                public void uncaughtException(Thread arg0, Throwable arg1) {
                    System.err.println(arg1.toString());
                }
            });
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    if (!executorService.isShutdown()) {
                        System.err.println("shutdowHook shuts down executorService");
                        executorService.shutdown();
                    }
                }
            });
        } else {
            executorService = null;
        }
        VehicleFleetManager vehicleFleetManager = VehicleRoutingAlgorithms.createFleetManager(vrp);
        String switchString = config.getString("construction.insertion.allowVehicleSwitch");
        boolean switchAllowed = switchString != null ? Boolean.parseBoolean(switchString) : true;
        if (stateManager.timeWindowUpdateIsActivated()) {
            UpdateVehicleDependentPracticalTimeWindows timeWindowUpdater = new UpdateVehicleDependentPracticalTimeWindows(stateManager, vrp.getTransportCosts(), vrp.getActivityCosts());
            timeWindowUpdater.setVehiclesToUpdate(new UpdateVehicleDependentPracticalTimeWindows.VehiclesToUpdate(){
                Map<VehicleTypeKey, Vehicle> uniqueTypes = new HashMap<VehicleTypeKey, Vehicle>();

                public Collection<Vehicle> get(VehicleRoute vehicleRoute) {
                    if (this.uniqueTypes.isEmpty()) {
                        for (Vehicle v : vrp.getVehicles()) {
                            if (this.uniqueTypes.containsKey(v.getVehicleTypeIdentifier())) continue;
                            this.uniqueTypes.put(v.getVehicleTypeIdentifier(), v);
                        }
                    }
                    ArrayList<Vehicle> vehicles = new ArrayList<Vehicle>();
                    vehicles.addAll(this.uniqueTypes.values());
                    return vehicles;
                }
            });
            stateManager.addStateUpdater((StateUpdater)timeWindowUpdater);
            activityPolicy = ActivityTimeTracker.ActivityPolicy.AS_SOON_AS_TIME_WINDOW_OPENS;
        } else {
            activityPolicy = ActivityTimeTracker.ActivityPolicy.AS_SOON_AS_ARRIVED;
        }
        stateManager.addStateUpdater((StateUpdater)new UpdateActivityTimes((ForwardTransportTime)vrp.getTransportCosts(), activityPolicy, vrp.getActivityCosts()));
        stateManager.addStateUpdater((StateUpdater)new UpdateVariableCosts(vrp.getActivityCosts(), vrp.getTransportCosts(), stateManager, activityPolicy));
        SolutionCostCalculator costCalculator = solutionCostCalculator == null ? VehicleRoutingAlgorithms.getDefaultCostCalculator(stateManager) : solutionCostCalculator;
        PrettyAlgorithmBuilder prettyAlgorithmBuilder = PrettyAlgorithmBuilder.newInstance((VehicleRoutingProblem)vrp, (VehicleFleetManager)vehicleFleetManager, (StateManager)stateManager, (ConstraintManager)constraintManager);
        if (addCoreConstraints) {
            prettyAlgorithmBuilder.addCoreStateAndConstraintStuff();
        }
        if ((initialInsertionStrategy = VehicleRoutingAlgorithms.createInitialSolution(config, vrp, vehicleFleetManager, stateManager, algorithmListeners, definedClasses, executorService, nuOfThreads, costCalculator, constraintManager, addDefaultCostCalculators)) != null) {
            prettyAlgorithmBuilder.constructInitialSolutionWith(initialInsertionStrategy, costCalculator);
        }
        int solutionMemory = config.getInt("strategy.memory");
        List strategyConfigs = config.configurationsAt("strategy.searchStrategies.searchStrategy");
        for (HierarchicalConfiguration strategyConfig : strategyConfigs) {
            String name = VehicleRoutingAlgorithms.getName(strategyConfig);
            SolutionAcceptor acceptor = VehicleRoutingAlgorithms.getAcceptor(strategyConfig, vrp, algorithmListeners, definedClasses, solutionMemory);
            SolutionSelector selector = VehicleRoutingAlgorithms.getSelector(strategyConfig, vrp, algorithmListeners, definedClasses);
            SearchStrategy strategy = new SearchStrategy(name, selector, acceptor, costCalculator);
            strategy.setName(name);
            List modulesConfig = strategyConfig.configurationsAt("modules.module");
            for (HierarchicalConfiguration moduleConfig : modulesConfig) {
                SearchStrategyModule module = VehicleRoutingAlgorithms.buildModule(moduleConfig, vrp, vehicleFleetManager, stateManager, algorithmListeners, definedClasses, executorService, nuOfThreads, constraintManager, addDefaultCostCalculators);
                strategy.addModule(module);
            }
            prettyAlgorithmBuilder.withStrategy(strategy, strategyConfig.getDouble("probability"));
        }
        VehicleRoutingAlgorithm metaAlgorithm = prettyAlgorithmBuilder.build();
        int maxIterations = VehicleRoutingAlgorithms.getMaxIterations(config);
        if (maxIterations > -1) {
            metaAlgorithm.setMaxIterations(maxIterations);
        }
        if ((prematureAlgorithmTermination = VehicleRoutingAlgorithms.getPrematureTermination(config, algorithmListeners)) != null) {
            metaAlgorithm.setPrematureAlgorithmTermination(prematureAlgorithmTermination);
        } else {
            List terminationCriteria = config.configurationsAt("terminationCriteria.termination");
            for (HierarchicalConfiguration terminationConfig : terminationCriteria) {
                PrematureAlgorithmTermination termination = VehicleRoutingAlgorithms.getTerminationCriterion(terminationConfig, algorithmListeners);
                if (termination == null) continue;
                metaAlgorithm.addTerminationCriterion(termination);
            }
        }
        for (VehicleRoutingAlgorithmListeners.PrioritizedVRAListener l : algorithmListeners) {
            metaAlgorithm.getAlgorithmListeners().add(l);
        }
        return metaAlgorithm;
    }

    private static int getMaxIterations(XMLConfiguration config) {
        String maxIterationsString = config.getString("iterations");
        if (maxIterationsString == null) {
            maxIterationsString = config.getString("maxIterations");
        }
        if (maxIterationsString != null) {
            return Integer.parseInt(maxIterationsString);
        }
        return -1;
    }

    private static SolutionCostCalculator getDefaultCostCalculator(StateManager stateManager) {
        return new VariablePlusFixedSolutionCostCalculatorFactory((RouteAndActivityStateGetter)stateManager).createCalculator();
    }

    private static VehicleFleetManager createFleetManager(VehicleRoutingProblem vrp) {
        if (vrp.getFleetSize().equals((Object)VehicleRoutingProblem.FleetSize.INFINITE)) {
            return new InfiniteFleetManagerFactory(vrp.getVehicles()).createFleetManager();
        }
        if (vrp.getFleetSize().equals((Object)VehicleRoutingProblem.FleetSize.FINITE)) {
            return new FiniteFleetManagerFactory(vrp.getVehicles()).createFleetManager();
        }
        throw new IllegalStateException("fleet size can only be infinite or finite. makes sure your config file contains one of these options");
    }

    private static PrematureAlgorithmTermination getTerminationCriterion(HierarchicalConfiguration config, Set<VehicleRoutingAlgorithmListeners.PrioritizedVRAListener> algorithmListeners) {
        String basedOn = config.getString("[@basedOn]");
        if (basedOn == null) {
            log.debug("set default prematureBreak, i.e. no premature break at all.");
            return null;
        }
        if (basedOn.equals("iterations")) {
            log.debug("set prematureBreak based on iterations");
            String iter = config.getString("iterations");
            if (iter == null) {
                throw new IllegalStateException("iterations is missing");
            }
            int iterations = Integer.valueOf(iter);
            return new IterationWithoutImprovementTermination(iterations);
        }
        if (basedOn.equals("time")) {
            log.debug("set prematureBreak based on time");
            String timeString = config.getString("time");
            if (timeString == null) {
                throw new IllegalStateException("time is missing");
            }
            long time = Long.parseLong(timeString);
            TimeTermination timeBreaker = new TimeTermination(time);
            algorithmListeners.add(new VehicleRoutingAlgorithmListeners.PrioritizedVRAListener(VehicleRoutingAlgorithmListeners.Priority.LOW, (VehicleRoutingAlgorithmListener)timeBreaker));
            return timeBreaker;
        }
        if (basedOn.equals("variationCoefficient")) {
            log.debug("set prematureBreak based on variation coefficient");
            String thresholdString = config.getString("threshold");
            String iterationsString = config.getString("iterations");
            if (thresholdString == null) {
                throw new IllegalStateException("threshold is missing");
            }
            if (iterationsString == null) {
                throw new IllegalStateException("iterations is missing");
            }
            double threshold = Double.valueOf(thresholdString);
            int iterations = Integer.valueOf(iterationsString);
            VariationCoefficientTermination variationCoefficientBreaker = new VariationCoefficientTermination(iterations, threshold);
            algorithmListeners.add(new VehicleRoutingAlgorithmListeners.PrioritizedVRAListener(VehicleRoutingAlgorithmListeners.Priority.LOW, (VehicleRoutingAlgorithmListener)variationCoefficientBreaker));
            return variationCoefficientBreaker;
        }
        throw new IllegalStateException("prematureBreak basedOn " + basedOn + " is not defined");
    }

    private static PrematureAlgorithmTermination getPrematureTermination(XMLConfiguration config, Set<VehicleRoutingAlgorithmListeners.PrioritizedVRAListener> algorithmListeners) {
        String basedOn = config.getString("prematureBreak[@basedOn]");
        if (basedOn == null) {
            log.debug("set default prematureBreak, i.e. no premature break at all.");
            return null;
        }
        if (basedOn.equals("iterations")) {
            log.debug("set prematureBreak based on iterations");
            String iter = config.getString("prematureBreak.iterations");
            if (iter == null) {
                throw new IllegalStateException("prematureBreak.iterations is missing");
            }
            int iterations = Integer.valueOf(iter);
            return new IterationWithoutImprovementTermination(iterations);
        }
        if (basedOn.equals("time")) {
            log.debug("set prematureBreak based on time");
            String timeString = config.getString("prematureBreak.time");
            if (timeString == null) {
                throw new IllegalStateException("prematureBreak.time is missing");
            }
            long time = Long.parseLong(timeString);
            TimeTermination timeBreaker = new TimeTermination(time);
            algorithmListeners.add(new VehicleRoutingAlgorithmListeners.PrioritizedVRAListener(VehicleRoutingAlgorithmListeners.Priority.LOW, (VehicleRoutingAlgorithmListener)timeBreaker));
            return timeBreaker;
        }
        if (basedOn.equals("variationCoefficient")) {
            log.debug("set prematureBreak based on variation coefficient");
            String thresholdString = config.getString("prematureBreak.threshold");
            String iterationsString = config.getString("prematureBreak.iterations");
            if (thresholdString == null) {
                throw new IllegalStateException("prematureBreak.threshold is missing");
            }
            if (iterationsString == null) {
                throw new IllegalStateException("prematureBreak.iterations is missing");
            }
            double threshold = Double.valueOf(thresholdString);
            int iterations = Integer.valueOf(iterationsString);
            VariationCoefficientTermination variationCoefficientBreaker = new VariationCoefficientTermination(iterations, threshold);
            algorithmListeners.add(new VehicleRoutingAlgorithmListeners.PrioritizedVRAListener(VehicleRoutingAlgorithmListeners.Priority.LOW, (VehicleRoutingAlgorithmListener)variationCoefficientBreaker));
            return variationCoefficientBreaker;
        }
        throw new IllegalStateException("prematureBreak basedOn " + basedOn + " is not defined");
    }

    private static String getName(HierarchicalConfiguration strategyConfig) {
        if (strategyConfig.containsKey("[@name]")) {
            return strategyConfig.getString("[@name]");
        }
        return "";
    }

    private static InsertionStrategy createInitialSolution(XMLConfiguration config, VehicleRoutingProblem vrp, VehicleFleetManager vehicleFleetManager, StateManager routeStates, Set<VehicleRoutingAlgorithmListeners.PrioritizedVRAListener> algorithmListeners, TypedMap definedClasses, ExecutorService executorService, int nuOfThreads, SolutionCostCalculator solutionCostCalculator, ConstraintManager constraintManager, boolean addDefaultCostCalculators) {
        ModKey modKey;
        TypedMap.InsertionStrategyKey insertionStrategyKey;
        InsertionStrategy insertionStrategy;
        List modConfigs = config.configurationsAt("construction.insertion");
        if (modConfigs == null) {
            return null;
        }
        if (modConfigs.isEmpty()) {
            return null;
        }
        if (modConfigs.size() != 1) {
            throw new IllegalStateException("#construction.modules != 1. 1 expected");
        }
        HierarchicalConfiguration modConfig = (HierarchicalConfiguration)modConfigs.get(0);
        String insertionName = modConfig.getString("[@name]");
        if (insertionName == null) {
            throw new IllegalStateException("insertion[@name] is missing.");
        }
        String insertionId = modConfig.getString("[@id]");
        if (insertionId == null) {
            insertionId = "noId";
        }
        if ((insertionStrategy = definedClasses.get(insertionStrategyKey = new TypedMap.InsertionStrategyKey(modKey = VehicleRoutingAlgorithms.makeKey(insertionName, insertionId)))) == null) {
            ArrayList<VehicleRoutingAlgorithmListeners.PrioritizedVRAListener> prioListeners = new ArrayList<VehicleRoutingAlgorithmListeners.PrioritizedVRAListener>();
            insertionStrategy = VehicleRoutingAlgorithms.createInsertionStrategy(modConfig, vrp, vehicleFleetManager, routeStates, prioListeners, executorService, nuOfThreads, constraintManager, addDefaultCostCalculators);
            algorithmListeners.addAll(prioListeners);
            definedClasses.put(insertionStrategyKey, insertionStrategy);
        }
        return insertionStrategy;
    }

    private static SolutionSelector getSelector(HierarchicalConfiguration strategyConfig, VehicleRoutingProblem vrp, Set<VehicleRoutingAlgorithmListeners.PrioritizedVRAListener> algorithmListeners, TypedMap definedSelectors) {
        ModKey modKey;
        TypedMap.SelectorKey selectorKey;
        SolutionSelector definedSelector;
        String selectorName = strategyConfig.getString("selector[@name]");
        if (selectorName == null) {
            throw new IllegalStateException("no solutionSelector defined. define either \"selectRandomly\" or \"selectBest\"");
        }
        String selectorId = strategyConfig.getString("selector[@id]");
        if (selectorId == null) {
            selectorId = "noId";
        }
        if ((definedSelector = definedSelectors.get(selectorKey = new TypedMap.SelectorKey(modKey = VehicleRoutingAlgorithms.makeKey(selectorName, selectorId)))) != null) {
            return definedSelector;
        }
        if (selectorName.equals("selectRandomly")) {
            SelectRandomly selector = SelectRandomly.getInstance();
            definedSelectors.put(selectorKey, selector);
            return selector;
        }
        if (selectorName.equals("selectBest")) {
            SelectBest selector = SelectBest.getInstance();
            definedSelectors.put(selectorKey, selector);
            return selector;
        }
        throw new IllegalStateException("solutionSelector is not know. Currently, it only knows \"selectRandomly\" and \"selectBest\"");
    }

    private static ModKey makeKey(String name, String id) {
        return new ModKey(name, id);
    }

    private static SolutionAcceptor getAcceptor(HierarchicalConfiguration strategyConfig, VehicleRoutingProblem vrp, Set<VehicleRoutingAlgorithmListeners.PrioritizedVRAListener> algorithmListeners, TypedMap typedMap, int solutionMemory) {
        TypedMap.AcceptorKey acceptorKey;
        SolutionAcceptor definedAcceptor;
        String acceptorName = strategyConfig.getString("acceptor[@name]");
        if (acceptorName == null) {
            throw new IllegalStateException("no solution acceptor is defined");
        }
        String acceptorId = strategyConfig.getString("acceptor[@id]");
        if (acceptorId == null) {
            acceptorId = "noId";
        }
        if ((definedAcceptor = typedMap.get(acceptorKey = new TypedMap.AcceptorKey(VehicleRoutingAlgorithms.makeKey(acceptorName, acceptorId)))) != null) {
            return definedAcceptor;
        }
        if (acceptorName.equals("acceptNewRemoveWorst")) {
            GreedyAcceptance acceptor = new GreedyAcceptance(solutionMemory);
            typedMap.put(acceptorKey, acceptor);
            return acceptor;
        }
        if (acceptorName.equals("acceptNewRemoveFirst")) {
            AcceptNewRemoveFirst acceptor = new AcceptNewRemoveFirst(solutionMemory);
            typedMap.put(acceptorKey, acceptor);
            return acceptor;
        }
        if (acceptorName.equals("greedyAcceptance")) {
            GreedyAcceptance acceptor = new GreedyAcceptance(solutionMemory);
            typedMap.put(acceptorKey, acceptor);
            return acceptor;
        }
        if (acceptorName.equals("schrimpfAcceptance")) {
            String nuWarmupIterations = strategyConfig.getString("acceptor.warmup");
            double alpha = strategyConfig.getDouble("acceptor.alpha");
            SchrimpfAcceptance schrimpf = new SchrimpfAcceptance(solutionMemory, alpha);
            if (nuWarmupIterations != null) {
                SchrimpfInitialThresholdGenerator iniThresholdGenerator = new SchrimpfInitialThresholdGenerator(schrimpf, Integer.parseInt(nuWarmupIterations));
                algorithmListeners.add(new VehicleRoutingAlgorithmListeners.PrioritizedVRAListener(VehicleRoutingAlgorithmListeners.Priority.LOW, (VehicleRoutingAlgorithmListener)iniThresholdGenerator));
            } else {
                double threshold = strategyConfig.getDouble("acceptor.initialThreshold");
                schrimpf.setInitialThreshold(threshold);
            }
            algorithmListeners.add(new VehicleRoutingAlgorithmListeners.PrioritizedVRAListener(VehicleRoutingAlgorithmListeners.Priority.LOW, (VehicleRoutingAlgorithmListener)schrimpf));
            typedMap.put(acceptorKey, schrimpf);
            return schrimpf;
        }
        if (acceptorName.equals("experimentalSchrimpfAcceptance")) {
            int iterOfSchrimpf = strategyConfig.getInt("acceptor.warmup");
            double alpha = strategyConfig.getDouble("acceptor.alpha");
            ExperimentalSchrimpfAcceptance schrimpf = new ExperimentalSchrimpfAcceptance(solutionMemory, alpha, iterOfSchrimpf);
            algorithmListeners.add(new VehicleRoutingAlgorithmListeners.PrioritizedVRAListener(VehicleRoutingAlgorithmListeners.Priority.LOW, (VehicleRoutingAlgorithmListener)schrimpf));
            typedMap.put(acceptorKey, schrimpf);
            return schrimpf;
        }
        throw new IllegalStateException("solution acceptor " + acceptorName + " is not known");
    }

    private static SearchStrategyModule buildModule(HierarchicalConfiguration moduleConfig, VehicleRoutingProblem vrp, VehicleFleetManager vehicleFleetManager, StateManager routeStates, Set<VehicleRoutingAlgorithmListeners.PrioritizedVRAListener> algorithmListeners, TypedMap definedClasses, ExecutorService executorService, int nuOfThreads, ConstraintManager constraintManager, boolean addDefaultCostCalculators) {
        ModKey modKey;
        TypedMap.StrategyModuleKey strategyModuleKey;
        SearchStrategyModule definedModule;
        String moduleName = moduleConfig.getString("[@name]");
        if (moduleName == null) {
            throw new IllegalStateException("module(-name) is missing.");
        }
        String moduleId = moduleConfig.getString("[@id]");
        if (moduleId == null) {
            moduleId = "noId";
        }
        if ((definedModule = definedClasses.get(strategyModuleKey = new TypedMap.StrategyModuleKey(modKey = VehicleRoutingAlgorithms.makeKey(moduleName, moduleId)))) != null) {
            return definedModule;
        }
        if (moduleName.equals("ruin_and_recreate")) {
            ModKey insertionKey;
            TypedMap.InsertionStrategyKey insertionStrategyKey;
            InsertionStrategy insertion;
            RuinStrategy ruin;
            String shareToRuinString;
            String ruin_name = moduleConfig.getString("ruin[@name]");
            if (ruin_name == null) {
                throw new IllegalStateException("module.ruin[@name] is missing.");
            }
            String ruin_id = moduleConfig.getString("ruin[@id]");
            if (ruin_id == null) {
                ruin_id = "noId";
            }
            ModKey ruinKey = VehicleRoutingAlgorithms.makeKey(ruin_name, ruin_id);
            if (ruin_name.equals("randomRuin")) {
                shareToRuinString = moduleConfig.getString("ruin.share");
                if (shareToRuinString == null) {
                    throw new IllegalStateException("module.ruin.share is missing.");
                }
                double shareToRuin = Double.valueOf(shareToRuinString);
                ruin = VehicleRoutingAlgorithms.getRandomRuin(vrp, routeStates, definedClasses, ruinKey, shareToRuin);
            } else if (ruin_name.equals("radialRuin")) {
                shareToRuinString = moduleConfig.getString("ruin.share");
                if (shareToRuinString == null) {
                    throw new IllegalStateException("module.ruin.share is missing.");
                }
                double shareToRuin = Double.valueOf(shareToRuinString);
                AvgServiceAndShipmentDistance jobDistance = new AvgServiceAndShipmentDistance(vrp.getTransportCosts());
                ruin = VehicleRoutingAlgorithms.getRadialRuin(vrp, routeStates, definedClasses, ruinKey, shareToRuin, (JobDistance)jobDistance);
            } else if (ruin_name.equals("clusterRuin")) {
                String initialNumberJobsToRemoveString = moduleConfig.getString("ruin.initRemoveJobs");
                if (initialNumberJobsToRemoveString == null) {
                    throw new IllegalStateException("module.ruin.initRemoveJobs is missing.");
                }
                int initialNumberJobsToRemove = Integer.valueOf(initialNumberJobsToRemoveString);
                ruin = VehicleRoutingAlgorithms.getClusterRuin(vrp, routeStates, definedClasses, ruinKey, initialNumberJobsToRemove);
            } else {
                throw new IllegalStateException("ruin[@name] " + ruin_name + " is not known. Use either randomRuin or radialRuin.");
            }
            String insertionName = moduleConfig.getString("insertion[@name]");
            if (insertionName == null) {
                throw new IllegalStateException("module.insertion[@name] is missing. set it to \"regretInsertion\" or \"bestInsertion\"");
            }
            String insertionId = moduleConfig.getString("insertion[@id]");
            if (insertionId == null) {
                insertionId = "noId";
            }
            if ((insertion = definedClasses.get(insertionStrategyKey = new TypedMap.InsertionStrategyKey(insertionKey = VehicleRoutingAlgorithms.makeKey(insertionName, insertionId)))) == null) {
                List insertionConfigs = moduleConfig.configurationsAt("insertion");
                if (insertionConfigs.size() != 1) {
                    throw new IllegalStateException("this should be 1");
                }
                ArrayList<VehicleRoutingAlgorithmListeners.PrioritizedVRAListener> prioListeners = new ArrayList<VehicleRoutingAlgorithmListeners.PrioritizedVRAListener>();
                insertion = VehicleRoutingAlgorithms.createInsertionStrategy((HierarchicalConfiguration)insertionConfigs.get(0), vrp, vehicleFleetManager, routeStates, prioListeners, executorService, nuOfThreads, constraintManager, addDefaultCostCalculators);
                algorithmListeners.addAll(prioListeners);
            }
            InsertionStrategy final_insertion = insertion;
            RuinAndRecreateModule rrModule = new RuinAndRecreateModule("ruin_and_recreate", final_insertion, ruin);
            return rrModule;
        }
        throw new NullPointerException("no module found with moduleName=" + moduleName + "\n\tcheck config whether the correct names are used\n\tcurrently there are following modules available: \n\tbestInsertion\n\trandomRuin\n\tradialRuin\n\tclusterRuin");
    }

    private static RuinStrategy getRadialRuin(VehicleRoutingProblem vrp, StateManager routeStates, TypedMap definedClasses, ModKey modKey, double shareToRuin, JobDistance jobDistance) {
        TypedMap.RuinStrategyKey stratKey = new TypedMap.RuinStrategyKey(modKey);
        RuinStrategy ruin = definedClasses.get(stratKey);
        if (ruin == null) {
            ruin = new RadialRuinStrategyFactory(shareToRuin, jobDistance).createStrategy(vrp);
            definedClasses.put(stratKey, ruin);
        }
        return ruin;
    }

    private static RuinStrategy getClusterRuin(VehicleRoutingProblem vrp, StateManager routeStates, TypedMap definedClasses, ModKey modKey, int initialNumberJobsToRemove) {
        JobNeighborhoods jobNeighborhoods = new JobNeighborhoodsFactory().createNeighborhoods(vrp, (JobDistance)new AvgServiceAndShipmentDistance(vrp.getTransportCosts()));
        TypedMap.RuinStrategyKey stratKey = new TypedMap.RuinStrategyKey(modKey);
        RuinStrategy ruin = definedClasses.get(stratKey);
        if (ruin == null) {
            ruin = new ClusterRuinStrategyFactory(initialNumberJobsToRemove, jobNeighborhoods).createStrategy(vrp);
            definedClasses.put(stratKey, ruin);
        }
        return ruin;
    }

    private static RuinStrategy getRandomRuin(VehicleRoutingProblem vrp, StateManager routeStates, TypedMap definedClasses, ModKey modKey, double shareToRuin) {
        TypedMap.RuinStrategyKey stratKey = new TypedMap.RuinStrategyKey(modKey);
        RuinStrategy ruin = definedClasses.get(stratKey);
        if (ruin == null) {
            ruin = new RandomRuinStrategyFactory(shareToRuin).createStrategy(vrp);
            definedClasses.put(stratKey, ruin);
        }
        return ruin;
    }

    private static InsertionStrategy createInsertionStrategy(HierarchicalConfiguration moduleConfig, VehicleRoutingProblem vrp, VehicleFleetManager vehicleFleetManager, StateManager routeStates, List<VehicleRoutingAlgorithmListeners.PrioritizedVRAListener> algorithmListeners, ExecutorService executorService, int nuOfThreads, ConstraintManager constraintManager, boolean addDefaultCostCalculators) {
        return InsertionFactory.createInsertion(vrp, moduleConfig, vehicleFleetManager, routeStates, algorithmListeners, executorService, nuOfThreads, constraintManager, addDefaultCostCalculators);
    }

    private static class OpenRouteStateVerifier
    implements StateUpdater,
    ReverseActivityVisitor {
        private End end;
        private boolean firstAct = true;
        private Vehicle vehicle;

        private OpenRouteStateVerifier() {
        }

        public void begin(VehicleRoute route) {
            this.end = route.getEnd();
            this.vehicle = route.getVehicle();
        }

        public void visit(TourActivity activity) {
            if (this.firstAct) {
                this.firstAct = false;
                if (!this.vehicle.isReturnToDepot()) assert (activity.getLocation().getId().equals(this.end.getLocation().getId())) : "route end and last activity are not equal even route is open. this should not be.";
            }
        }

        public void finish() {
            this.firstAct = true;
        }
    }

    static class ModKey {
        private String name;
        private String id;

        public ModKey(String name, String id) {
            this.name = name;
            this.id = id;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ModKey other = (ModKey)obj;
            if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
                return false;
            }
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }
    }

    static class TypedMap {
        private Map<AbstractKey<?>, Object> map = new HashMap();

        TypedMap() {
        }

        public <T> T get(AbstractKey<T> key) {
            if (this.map.get(key) == null) {
                return null;
            }
            return key.getType().cast(this.map.get(key));
        }

        public <T> T put(AbstractKey<T> key, T value) {
            return key.getType().cast(this.map.put(key, key.getType().cast(value)));
        }

        public Set<AbstractKey<?>> keySet() {
            return this.map.keySet();
        }

        static class InsertionStrategyKey
        implements AbstractKey<InsertionStrategy> {
            private ModKey modKey;

            public InsertionStrategyKey(ModKey modKey) {
                this.modKey = modKey;
            }

            public int hashCode() {
                int prime = 31;
                int result = 1;
                result = 31 * result + (this.modKey == null ? 0 : this.modKey.hashCode());
                return result;
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                InsertionStrategyKey other = (InsertionStrategyKey)obj;
                return !(this.modKey == null ? other.modKey != null : !this.modKey.equals(other.modKey));
            }

            @Override
            public Class<InsertionStrategy> getType() {
                return InsertionStrategy.class;
            }
        }

        static class RuinStrategyKey
        implements AbstractKey<RuinStrategy> {
            private ModKey modKey;

            public RuinStrategyKey(ModKey modKey) {
                this.modKey = modKey;
            }

            public int hashCode() {
                int prime = 31;
                int result = 1;
                result = 31 * result + (this.modKey == null ? 0 : this.modKey.hashCode());
                return result;
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                RuinStrategyKey other = (RuinStrategyKey)obj;
                return !(this.modKey == null ? other.modKey != null : !this.modKey.equals(other.modKey));
            }

            @Override
            public Class<RuinStrategy> getType() {
                return RuinStrategy.class;
            }
        }

        static class StrategyModuleKey
        implements AbstractKey<SearchStrategyModule> {
            private ModKey modKey;

            public StrategyModuleKey(ModKey modKey) {
                this.modKey = modKey;
            }

            public int hashCode() {
                int prime = 31;
                int result = 1;
                result = 31 * result + (this.modKey == null ? 0 : this.modKey.hashCode());
                return result;
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                StrategyModuleKey other = (StrategyModuleKey)obj;
                return !(this.modKey == null ? other.modKey != null : !this.modKey.equals(other.modKey));
            }

            @Override
            public Class<SearchStrategyModule> getType() {
                return SearchStrategyModule.class;
            }
        }

        static class SelectorKey
        implements AbstractKey<SolutionSelector> {
            private ModKey modKey;

            public SelectorKey(ModKey modKey) {
                this.modKey = modKey;
            }

            public int hashCode() {
                int prime = 31;
                int result = 1;
                result = 31 * result + (this.modKey == null ? 0 : this.modKey.hashCode());
                return result;
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                SelectorKey other = (SelectorKey)obj;
                return !(this.modKey == null ? other.modKey != null : !this.modKey.equals(other.modKey));
            }

            @Override
            public Class<SolutionSelector> getType() {
                return SolutionSelector.class;
            }
        }

        static class AcceptorKey
        implements AbstractKey<SolutionAcceptor> {
            private ModKey modKey;

            public AcceptorKey(ModKey modKey) {
                this.modKey = modKey;
            }

            public int hashCode() {
                int prime = 31;
                int result = 1;
                result = 31 * result + (this.modKey == null ? 0 : this.modKey.hashCode());
                return result;
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (!(obj instanceof AcceptorKey)) {
                    return false;
                }
                AcceptorKey other = (AcceptorKey)obj;
                return !(this.modKey == null ? other.modKey != null : !this.modKey.equals(other.modKey));
            }

            @Override
            public Class<SolutionAcceptor> getType() {
                return SolutionAcceptor.class;
            }
        }

        static interface AbstractKey<K> {
            public Class<K> getType();
        }
    }
}

