/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.io.problem;

import com.graphhopper.jsprit.core.problem.AbstractJob;
import com.graphhopper.jsprit.core.problem.AbstractVehicle;
import com.graphhopper.jsprit.core.problem.Location;
import com.graphhopper.jsprit.core.problem.VehicleRoutingProblem;
import com.graphhopper.jsprit.core.problem.driver.Driver;
import com.graphhopper.jsprit.core.problem.driver.DriverImpl;
import com.graphhopper.jsprit.core.problem.job.Break;
import com.graphhopper.jsprit.core.problem.job.Delivery;
import com.graphhopper.jsprit.core.problem.job.Pickup;
import com.graphhopper.jsprit.core.problem.job.Service;
import com.graphhopper.jsprit.core.problem.job.Shipment;
import com.graphhopper.jsprit.core.problem.solution.VehicleRoutingProblemSolution;
import com.graphhopper.jsprit.core.problem.solution.route.VehicleRoute;
import com.graphhopper.jsprit.core.problem.solution.route.activity.TimeWindow;
import com.graphhopper.jsprit.core.problem.vehicle.Vehicle;
import com.graphhopper.jsprit.core.problem.vehicle.VehicleImpl;
import com.graphhopper.jsprit.core.problem.vehicle.VehicleType;
import com.graphhopper.jsprit.core.problem.vehicle.VehicleTypeImpl;
import com.graphhopper.jsprit.core.util.Coordinate;
import com.graphhopper.jsprit.core.util.Resource;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.XMLConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class VrpXMLReader {
    private static Logger logger = LoggerFactory.getLogger(VrpXMLReader.class);
    private VehicleRoutingProblem.Builder vrpBuilder;
    private Map<String, Vehicle> vehicleMap;
    private Map<String, Service> serviceMap;
    private Map<String, Shipment> shipmentMap;
    private Set<String> freezedJobIds = new HashSet<String>();
    private boolean schemaValidation = true;
    private Collection<VehicleRoutingProblemSolution> solutions;
    private ServiceBuilderFactory serviceBuilderFactory = new DefaultServiceBuilderFactory();

    public void setSchemaValidation(boolean schemaValidation) {
        this.schemaValidation = schemaValidation;
    }

    public VrpXMLReader(VehicleRoutingProblem.Builder vrpBuilder, Collection<VehicleRoutingProblemSolution> solutions) {
        this.vrpBuilder = vrpBuilder;
        this.vehicleMap = new LinkedHashMap<String, Vehicle>();
        this.serviceMap = new LinkedHashMap<String, Service>();
        this.shipmentMap = new LinkedHashMap<String, Shipment>();
        this.solutions = solutions;
    }

    public VrpXMLReader(VehicleRoutingProblem.Builder vrpBuilder) {
        this.vrpBuilder = vrpBuilder;
        this.vehicleMap = new LinkedHashMap<String, Vehicle>();
        this.serviceMap = new LinkedHashMap<String, Service>();
        this.shipmentMap = new LinkedHashMap<String, Shipment>();
        this.solutions = null;
    }

    public void read(String filename) {
        logger.debug("read vrp: {}", (Object)filename);
        XMLConfiguration xmlConfig = this.createXMLConfiguration();
        try {
            xmlConfig.load(filename);
        }
        catch (ConfigurationException e) {
            throw new RuntimeException(e);
        }
        this.read(xmlConfig);
    }

    public void read(InputStream fileContents) {
        XMLConfiguration xmlConfig = this.createXMLConfiguration();
        try {
            xmlConfig.load(fileContents);
        }
        catch (ConfigurationException e) {
            throw new RuntimeException(e);
        }
        this.read(xmlConfig);
    }

    private XMLConfiguration createXMLConfiguration() {
        XMLConfiguration xmlConfig = new XMLConfiguration();
        xmlConfig.setAttributeSplittingDisabled(true);
        xmlConfig.setDelimiterParsingDisabled(true);
        if (this.schemaValidation) {
            final InputStream resource = Resource.getAsInputStream((String)"vrp_xml_schema.xsd");
            if (resource != null) {
                EntityResolver resolver = new EntityResolver(){

                    @Override
                    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                        InputSource is = new InputSource(resource);
                        return is;
                    }
                };
                xmlConfig.setEntityResolver(resolver);
                xmlConfig.setSchemaValidation(true);
            } else {
                logger.debug("cannot find schema-xsd file (vrp_xml_schema.xsd). try to read xml without xml-file-validation.");
            }
        }
        return xmlConfig;
    }

    private void read(XMLConfiguration xmlConfig) {
        this.readProblemType(xmlConfig);
        this.readVehiclesAndTheirTypes(xmlConfig);
        this.readShipments(xmlConfig);
        this.readServices(xmlConfig);
        this.readInitialRoutes(xmlConfig);
        this.readSolutions(xmlConfig);
        this.addJobsAndTheirLocationsToVrp();
    }

    private void addJobsAndTheirLocationsToVrp() {
        for (Service service : this.serviceMap.values()) {
            if (this.freezedJobIds.contains(service.getId())) continue;
            this.vrpBuilder.addJob((AbstractJob)service);
        }
        for (Shipment shipment : this.shipmentMap.values()) {
            if (this.freezedJobIds.contains(shipment.getId())) continue;
            this.vrpBuilder.addJob((AbstractJob)shipment);
        }
    }

    private void readInitialRoutes(XMLConfiguration xmlConfig) {
        List initialRouteConfigs = xmlConfig.configurationsAt("initialRoutes.route");
        for (HierarchicalConfiguration routeConfig : initialRouteConfigs) {
            DriverImpl.NoDriver driver = DriverImpl.noDriver();
            String vehicleId = routeConfig.getString("vehicleId");
            Vehicle vehicle = this.getVehicle(vehicleId);
            if (vehicle == null) {
                throw new IllegalArgumentException("vehicle is missing.");
            }
            String start = routeConfig.getString("start");
            if (start == null) {
                throw new IllegalArgumentException("route start-time is missing.");
            }
            double departureTime = Double.parseDouble(start);
            VehicleRoute.Builder routeBuilder = VehicleRoute.Builder.newInstance((Vehicle)vehicle, (Driver)driver);
            routeBuilder.setDepartureTime(departureTime);
            List actConfigs = routeConfig.configurationsAt("act");
            for (HierarchicalConfiguration actConfig : actConfigs) {
                String endTimeS;
                String type = actConfig.getString("[@type]");
                if (type == null) {
                    throw new IllegalArgumentException("act[@type] is missing.");
                }
                double arrTime = 0.0;
                double endTime = 0.0;
                String arrTimeS = actConfig.getString("arrTime");
                if (arrTimeS != null) {
                    arrTime = Double.parseDouble(arrTimeS);
                }
                if ((endTimeS = actConfig.getString("endTime")) != null) {
                    endTime = Double.parseDouble(endTimeS);
                }
                String serviceId = actConfig.getString("serviceId");
                if (type.equals("break")) {
                    Break currentbreak = this.getBreak(vehicleId);
                    routeBuilder.addBreak(currentbreak);
                    continue;
                }
                if (serviceId != null) {
                    Service service = this.getService(serviceId);
                    if (service == null) {
                        throw new IllegalArgumentException("service to serviceId " + serviceId + " is missing (reference in one of your initial routes). make sure you define the service you refer to here in <services> </services>.");
                    }
                    this.freezedJobIds.add(serviceId);
                    routeBuilder.addService(service);
                    continue;
                }
                String shipmentId = actConfig.getString("shipmentId");
                if (shipmentId == null) {
                    throw new IllegalArgumentException("either serviceId or shipmentId is missing");
                }
                Shipment shipment = this.getShipment(shipmentId);
                if (shipment == null) {
                    throw new IllegalArgumentException("shipment to shipmentId " + shipmentId + " is missing (reference in one of your initial routes). make sure you define the shipment you refer to here in <shipments> </shipments>.");
                }
                this.freezedJobIds.add(shipmentId);
                if (type.equals("pickupShipment")) {
                    routeBuilder.addPickup(shipment);
                    continue;
                }
                if (type.equals("deliverShipment")) {
                    routeBuilder.addDelivery(shipment);
                    continue;
                }
                throw new IllegalArgumentException("type " + type + " is not supported. Use 'pickupShipment' or 'deliverShipment' here");
            }
            VehicleRoute route = routeBuilder.build();
            this.vrpBuilder.addInitialVehicleRoute(route);
        }
    }

    private void readSolutions(XMLConfiguration vrpProblem) {
        if (this.solutions == null) {
            return;
        }
        List solutionConfigs = vrpProblem.configurationsAt("solutions.solution");
        for (HierarchicalConfiguration solutionConfig : solutionConfigs) {
            String totalCost = solutionConfig.getString("cost");
            double cost = -1.0;
            if (totalCost != null) {
                cost = Double.parseDouble(totalCost);
            }
            List routeConfigs = solutionConfig.configurationsAt("routes.route");
            ArrayList<VehicleRoute> routes = new ArrayList<VehicleRoute>();
            for (HierarchicalConfiguration routeConfig : routeConfigs) {
                DriverImpl.NoDriver driver = DriverImpl.noDriver();
                String vehicleId = routeConfig.getString("vehicleId");
                Vehicle vehicle = this.getVehicle(vehicleId);
                if (vehicle == null) {
                    throw new IllegalArgumentException("vehicle is missing.");
                }
                String start = routeConfig.getString("start");
                if (start == null) {
                    throw new IllegalArgumentException("route start-time is missing.");
                }
                double departureTime = Double.parseDouble(start);
                String end = routeConfig.getString("end");
                if (end == null) {
                    throw new IllegalArgumentException("route end-time is missing.");
                }
                VehicleRoute.Builder routeBuilder = VehicleRoute.Builder.newInstance((Vehicle)vehicle, (Driver)driver);
                routeBuilder.setDepartureTime(departureTime);
                List actConfigs = routeConfig.configurationsAt("act");
                for (HierarchicalConfiguration actConfig : actConfigs) {
                    String endTimeS;
                    String type = actConfig.getString("[@type]");
                    if (type == null) {
                        throw new IllegalArgumentException("act[@type] is missing.");
                    }
                    double arrTime = 0.0;
                    double endTime = 0.0;
                    String arrTimeS = actConfig.getString("arrTime");
                    if (arrTimeS != null) {
                        arrTime = Double.parseDouble(arrTimeS);
                    }
                    if ((endTimeS = actConfig.getString("endTime")) != null) {
                        endTime = Double.parseDouble(endTimeS);
                    }
                    if (type.equals("break")) {
                        Break currentbreak = this.getBreak(vehicleId);
                        routeBuilder.addBreak(currentbreak);
                        continue;
                    }
                    String serviceId = actConfig.getString("serviceId");
                    if (serviceId != null) {
                        Service service = this.getService(serviceId);
                        routeBuilder.addService(service);
                        continue;
                    }
                    String shipmentId = actConfig.getString("shipmentId");
                    if (shipmentId == null) {
                        throw new IllegalArgumentException("either serviceId or shipmentId is missing");
                    }
                    Shipment shipment = this.getShipment(shipmentId);
                    if (shipment == null) {
                        throw new IllegalArgumentException("shipment with id " + shipmentId + " does not exist.");
                    }
                    if (type.equals("pickupShipment")) {
                        routeBuilder.addPickup(shipment);
                        continue;
                    }
                    if (type.equals("deliverShipment")) {
                        routeBuilder.addDelivery(shipment);
                        continue;
                    }
                    throw new IllegalArgumentException("type " + type + " is not supported. Use 'pickupShipment' or 'deliverShipment' here");
                }
                routes.add(routeBuilder.build());
            }
            VehicleRoutingProblemSolution solution = new VehicleRoutingProblemSolution(routes, cost);
            List unassignedJobConfigs = solutionConfig.configurationsAt("unassignedJobs.job");
            for (HierarchicalConfiguration unassignedJobConfig : unassignedJobConfigs) {
                String jobId = unassignedJobConfig.getString("[@id]");
                Shipment job = this.getShipment(jobId);
                if (job == null) {
                    job = this.getService(jobId);
                }
                if (job == null) {
                    throw new IllegalArgumentException("cannot find unassignedJob with id " + jobId);
                }
                solution.getUnassignedJobs().add(job);
            }
            this.solutions.add(solution);
        }
    }

    private Shipment getShipment(String shipmentId) {
        return this.shipmentMap.get(shipmentId);
    }

    private Service getService(String serviceId) {
        return this.serviceMap.get(serviceId);
    }

    private Vehicle getVehicle(String vehicleId) {
        return this.vehicleMap.get(vehicleId);
    }

    private Break getBreak(String vehicleId) {
        return this.vehicleMap.get(vehicleId).getBreak();
    }

    private void readProblemType(XMLConfiguration vrpProblem) {
        String fleetSize = vrpProblem.getString("problemType.fleetSize");
        if (fleetSize == null) {
            this.vrpBuilder.setFleetSize(VehicleRoutingProblem.FleetSize.INFINITE);
        } else if (fleetSize.toUpperCase().equals(VehicleRoutingProblem.FleetSize.INFINITE.toString())) {
            this.vrpBuilder.setFleetSize(VehicleRoutingProblem.FleetSize.INFINITE);
        } else {
            this.vrpBuilder.setFleetSize(VehicleRoutingProblem.FleetSize.FINITE);
        }
    }

    private void readShipments(XMLConfiguration config) {
        List shipmentConfigs = config.configurationsAt("shipments.shipment");
        for (HierarchicalConfiguration shipmentConfig : shipmentConfigs) {
            String skillString;
            List deliveryTWConfigs;
            String deliveryLocationIndex;
            Coordinate deliveryCoord;
            List pickupTWConfigs;
            String pickupLocationIndex;
            Coordinate pickupCoord;
            Shipment.Builder builder;
            String id = shipmentConfig.getString("[@id]");
            if (id == null) {
                throw new IllegalArgumentException("shipment[@id] is missing.");
            }
            String capacityString = shipmentConfig.getString("capacity-demand");
            boolean capacityDimensionsExist = shipmentConfig.containsKey("capacity-dimensions.dimension(0)");
            if (capacityString == null && !capacityDimensionsExist) {
                throw new IllegalArgumentException("capacity of shipment is not set. use 'capacity-dimensions'");
            }
            if (capacityString != null && capacityDimensionsExist) {
                throw new IllegalArgumentException("either use capacity or capacity-dimension, not both. prefer the use of 'capacity-dimensions' over 'capacity'.");
            }
            if (capacityString != null) {
                builder = Shipment.Builder.newInstance((String)id).addSizeDimension(0, Integer.parseInt(capacityString));
            } else {
                builder = Shipment.Builder.newInstance((String)id);
                List dimensionConfigs = shipmentConfig.configurationsAt("capacity-dimensions.dimension");
                for (HierarchicalConfiguration dimension : dimensionConfigs) {
                    Integer index = dimension.getInt("[@index]");
                    Integer value = dimension.getInt("");
                    builder.addSizeDimension(index.intValue(), value.intValue());
                }
            }
            String name = shipmentConfig.getString("name");
            if (name != null) {
                builder.setName(name);
            }
            Location.Builder pickupLocationBuilder = Location.Builder.newInstance();
            String pickupLocationId = shipmentConfig.getString("pickup.locationId");
            if (pickupLocationId == null) {
                pickupLocationId = shipmentConfig.getString("pickup.location.id");
            }
            if (pickupLocationId != null) {
                pickupLocationBuilder.setId(pickupLocationId);
            }
            if ((pickupCoord = VrpXMLReader.getCoord(shipmentConfig, "pickup.")) == null) {
                pickupCoord = VrpXMLReader.getCoord(shipmentConfig, "pickup.location.");
            }
            if (pickupCoord != null) {
                pickupLocationBuilder.setCoordinate(pickupCoord);
            }
            if ((pickupLocationIndex = shipmentConfig.getString("pickup.location.index")) != null) {
                pickupLocationBuilder.setIndex(Integer.parseInt(pickupLocationIndex));
            }
            builder.setPickupLocation(pickupLocationBuilder.build());
            String pickupServiceTime = shipmentConfig.getString("pickup.duration");
            if (pickupServiceTime != null) {
                builder.setPickupServiceTime(Double.parseDouble(pickupServiceTime));
            }
            if (!(pickupTWConfigs = shipmentConfig.configurationsAt("pickup.timeWindows.timeWindow")).isEmpty()) {
                for (HierarchicalConfiguration pu_twConfig : pickupTWConfigs) {
                    builder.addPickupTimeWindow(TimeWindow.newInstance((double)pu_twConfig.getDouble("start"), (double)pu_twConfig.getDouble("end")));
                }
            }
            Location.Builder deliveryLocationBuilder = Location.Builder.newInstance();
            String deliveryLocationId = shipmentConfig.getString("delivery.locationId");
            if (deliveryLocationId == null) {
                deliveryLocationId = shipmentConfig.getString("delivery.location.id");
            }
            if (deliveryLocationId != null) {
                deliveryLocationBuilder.setId(deliveryLocationId);
            }
            if ((deliveryCoord = VrpXMLReader.getCoord(shipmentConfig, "delivery.")) == null) {
                deliveryCoord = VrpXMLReader.getCoord(shipmentConfig, "delivery.location.");
            }
            if (deliveryCoord != null) {
                deliveryLocationBuilder.setCoordinate(deliveryCoord);
            }
            if ((deliveryLocationIndex = shipmentConfig.getString("delivery.location.index")) != null) {
                deliveryLocationBuilder.setIndex(Integer.parseInt(deliveryLocationIndex));
            }
            builder.setDeliveryLocation(deliveryLocationBuilder.build());
            String deliveryServiceTime = shipmentConfig.getString("delivery.duration");
            if (deliveryServiceTime != null) {
                builder.setDeliveryServiceTime(Double.parseDouble(deliveryServiceTime));
            }
            if (!(deliveryTWConfigs = shipmentConfig.configurationsAt("delivery.timeWindows.timeWindow")).isEmpty()) {
                for (HierarchicalConfiguration dl_twConfig : deliveryTWConfigs) {
                    builder.addDeliveryTimeWindow(TimeWindow.newInstance((double)dl_twConfig.getDouble("start"), (double)dl_twConfig.getDouble("end")));
                }
            }
            if ((skillString = shipmentConfig.getString("requiredSkills")) != null) {
                String[] skillTokens;
                String cleaned = skillString.replaceAll("\\s", "");
                for (String skill : skillTokens = cleaned.split("[,;]")) {
                    builder.addRequiredSkill(skill.toLowerCase());
                }
            }
            Shipment shipment = builder.build();
            this.shipmentMap.put(shipment.getId(), shipment);
        }
    }

    private static Coordinate getCoord(HierarchicalConfiguration serviceConfig, String prefix) {
        Coordinate pickupCoord = null;
        if (serviceConfig.getString(prefix + "coord[@x]") != null && serviceConfig.getString(prefix + "coord[@y]") != null) {
            double x = Double.parseDouble(serviceConfig.getString(prefix + "coord[@x]"));
            double y = Double.parseDouble(serviceConfig.getString(prefix + "coord[@y]"));
            pickupCoord = Coordinate.newInstance((double)x, (double)y);
        }
        return pickupCoord;
    }

    private void readServices(XMLConfiguration vrpProblem) {
        List serviceConfigs = vrpProblem.configurationsAt("services.service");
        for (HierarchicalConfiguration serviceConfig : serviceConfigs) {
            String skillString;
            List deliveryTWConfigs;
            String locationIndex;
            Coordinate serviceCoord;
            Service.Builder builder;
            String id = serviceConfig.getString("[@id]");
            if (id == null) {
                throw new IllegalArgumentException("service[@id] is missing.");
            }
            String type = serviceConfig.getString("[@type]");
            if (type == null) {
                type = "service";
            }
            String capacityString = serviceConfig.getString("capacity-demand");
            boolean capacityDimensionsExist = serviceConfig.containsKey("capacity-dimensions.dimension(0)");
            if (capacityString == null && !capacityDimensionsExist) {
                throw new IllegalArgumentException("capacity of service is not set. use 'capacity-dimensions'");
            }
            if (capacityString != null && capacityDimensionsExist) {
                throw new IllegalArgumentException("either use capacity or capacity-dimension, not both. prefer the use of 'capacity-dimensions' over 'capacity'.");
            }
            if (capacityString != null) {
                builder = this.serviceBuilderFactory.createBuilder(type, id, Integer.parseInt(capacityString));
            } else {
                builder = this.serviceBuilderFactory.createBuilder(type, id, null);
                List dimensionConfigs = serviceConfig.configurationsAt("capacity-dimensions.dimension");
                for (HierarchicalConfiguration dimension : dimensionConfigs) {
                    Integer index = dimension.getInt("[@index]");
                    Integer value = dimension.getInt("");
                    builder.addSizeDimension(index.intValue(), value.intValue());
                }
            }
            String name = serviceConfig.getString("name");
            if (name != null) {
                builder.setName(name);
            }
            Location.Builder locationBuilder = Location.Builder.newInstance();
            String serviceLocationId = serviceConfig.getString("locationId");
            if (serviceLocationId == null) {
                serviceLocationId = serviceConfig.getString("location.id");
            }
            if (serviceLocationId != null) {
                locationBuilder.setId(serviceLocationId);
            }
            if ((serviceCoord = VrpXMLReader.getCoord(serviceConfig, "")) == null) {
                serviceCoord = VrpXMLReader.getCoord(serviceConfig, "location.");
            }
            if (serviceCoord != null) {
                locationBuilder.setCoordinate(serviceCoord);
            }
            if ((locationIndex = serviceConfig.getString("location.index")) != null) {
                locationBuilder.setIndex(Integer.parseInt(locationIndex));
            }
            builder.setLocation(locationBuilder.build());
            if (serviceConfig.containsKey("duration")) {
                builder.setServiceTime(serviceConfig.getDouble("duration"));
            }
            if (!(deliveryTWConfigs = serviceConfig.configurationsAt("timeWindows.timeWindow")).isEmpty()) {
                for (HierarchicalConfiguration twConfig : deliveryTWConfigs) {
                    builder.addTimeWindow(TimeWindow.newInstance((double)twConfig.getDouble("start"), (double)twConfig.getDouble("end")));
                }
            }
            if ((skillString = serviceConfig.getString("requiredSkills")) != null) {
                String[] skillTokens;
                String cleaned = skillString.replaceAll("\\s", "");
                for (String skill : skillTokens = cleaned.split("[,;]")) {
                    builder.addRequiredSkill(skill.toLowerCase());
                }
            }
            Service service = builder.build();
            this.serviceMap.put(service.getId(), service);
        }
    }

    private void readVehiclesAndTheirTypes(XMLConfiguration vrpProblem) {
        HashMap<String, VehicleTypeImpl> types = new HashMap<String, VehicleTypeImpl>();
        List typeConfigs = vrpProblem.configurationsAt("vehicleTypes.type");
        for (HierarchicalConfiguration typeConfig : typeConfigs) {
            Double waitC;
            Double serviceC;
            VehicleTypeImpl.Builder typeBuilder;
            String typeId = typeConfig.getString("id");
            if (typeId == null) {
                throw new IllegalArgumentException("typeId is missing.");
            }
            String capacityString = typeConfig.getString("capacity");
            boolean capacityDimensionsExist = typeConfig.containsKey("capacity-dimensions.dimension(0)");
            if (capacityString == null && !capacityDimensionsExist) {
                throw new IllegalArgumentException("capacity of type is not set. use 'capacity-dimensions'");
            }
            if (capacityString != null && capacityDimensionsExist) {
                throw new IllegalArgumentException("either use capacity or capacity-dimension, not both. prefer the use of 'capacity-dimensions' over 'capacity'.");
            }
            if (capacityString != null) {
                typeBuilder = VehicleTypeImpl.Builder.newInstance((String)typeId).addCapacityDimension(0, Integer.parseInt(capacityString));
            } else {
                typeBuilder = VehicleTypeImpl.Builder.newInstance((String)typeId);
                List dimensionConfigs = typeConfig.configurationsAt("capacity-dimensions.dimension");
                for (HierarchicalConfiguration dimension : dimensionConfigs) {
                    Integer index = dimension.getInt("[@index]");
                    Integer value = dimension.getInt("");
                    typeBuilder.addCapacityDimension(index.intValue(), value.intValue());
                }
            }
            Double fix = typeConfig.getDouble("costs.fixed");
            Double timeC = typeConfig.getDouble("costs.time");
            Double distC = typeConfig.getDouble("costs.distance");
            if (typeConfig.containsKey("costs.service") && (serviceC = Double.valueOf(typeConfig.getDouble("costs.service"))) != null) {
                typeBuilder.setCostPerServiceTime(serviceC.doubleValue());
            }
            if (typeConfig.containsKey("costs.wait") && (waitC = Double.valueOf(typeConfig.getDouble("costs.wait"))) != null) {
                typeBuilder.setCostPerWaitingTime(waitC.doubleValue());
            }
            if (fix != null) {
                typeBuilder.setFixedCost(fix.doubleValue());
            }
            if (timeC != null) {
                typeBuilder.setCostPerTransportTime(timeC.doubleValue());
            }
            if (distC != null) {
                typeBuilder.setCostPerDistance(distC.doubleValue());
            }
            VehicleTypeImpl type = typeBuilder.build();
            String id = type.getTypeId();
            types.put(id, type);
        }
        List vehicleConfigs = vrpProblem.configurationsAt("vehicles.vehicle");
        boolean doNotWarnAgain = false;
        for (HierarchicalConfiguration vehicleConfig : vehicleConfigs) {
            List breakTWConfigs;
            String skillString;
            String returnToDepot;
            String endLocationIndex;
            String index;
            VehicleType type;
            String vehicleId = vehicleConfig.getString("id");
            if (vehicleId == null) {
                throw new IllegalArgumentException("vehicleId is missing.");
            }
            VehicleImpl.Builder builder = VehicleImpl.Builder.newInstance((String)vehicleId);
            String typeId = vehicleConfig.getString("typeId");
            if (typeId == null) {
                throw new IllegalArgumentException("typeId is missing.");
            }
            String vType = vehicleConfig.getString("[@type]");
            if (vType != null && vType.equals("penalty")) {
                typeId = typeId + "_penalty";
            }
            if ((type = (VehicleType)types.get(typeId)) == null) {
                throw new IllegalArgumentException("vehicleType with typeId " + typeId + " is missing.");
            }
            builder.setType(type);
            Location.Builder startLocationBuilder = Location.Builder.newInstance();
            String locationId = vehicleConfig.getString("location.id");
            if (locationId == null) {
                locationId = vehicleConfig.getString("startLocation.id");
            }
            startLocationBuilder.setId(locationId);
            String coordX = vehicleConfig.getString("location.coord[@x]");
            String coordY = vehicleConfig.getString("location.coord[@y]");
            if (coordX == null || coordY == null) {
                coordX = vehicleConfig.getString("startLocation.coord[@x]");
                coordY = vehicleConfig.getString("startLocation.coord[@y]");
            }
            if (coordX == null || coordY == null) {
                if (!doNotWarnAgain) {
                    logger.debug("location.coord is missing. will not warn you again.");
                    doNotWarnAgain = true;
                }
            } else {
                Coordinate coordinate = Coordinate.newInstance((double)Double.parseDouble(coordX), (double)Double.parseDouble(coordY));
                startLocationBuilder.setCoordinate(coordinate);
            }
            if ((index = vehicleConfig.getString("startLocation.index")) == null) {
                index = vehicleConfig.getString("location.index");
            }
            if (index != null) {
                startLocationBuilder.setIndex(Integer.parseInt(index));
            }
            builder.setStartLocation(startLocationBuilder.build());
            Location.Builder endLocationBuilder = Location.Builder.newInstance();
            boolean hasEndLocation = false;
            String endLocationId = vehicleConfig.getString("endLocation.id");
            if (endLocationId != null) {
                hasEndLocation = true;
                endLocationBuilder.setId(endLocationId);
            }
            String endCoordX = vehicleConfig.getString("endLocation.coord[@x]");
            String endCoordY = vehicleConfig.getString("endLocation.coord[@y]");
            if (endCoordX == null || endCoordY == null) {
                if (!doNotWarnAgain) {
                    logger.debug("endLocation.coord is missing. will not warn you again.");
                    doNotWarnAgain = true;
                }
            } else {
                Coordinate coordinate = Coordinate.newInstance((double)Double.parseDouble(endCoordX), (double)Double.parseDouble(endCoordY));
                hasEndLocation = true;
                endLocationBuilder.setCoordinate(coordinate);
            }
            if ((endLocationIndex = vehicleConfig.getString("endLocation.index")) != null) {
                hasEndLocation = true;
                endLocationBuilder.setIndex(Integer.parseInt(endLocationIndex));
            }
            if (hasEndLocation) {
                builder.setEndLocation(endLocationBuilder.build());
            }
            String start = vehicleConfig.getString("timeSchedule.start");
            String end = vehicleConfig.getString("timeSchedule.end");
            if (start != null) {
                builder.setEarliestStart(Double.parseDouble(start));
            }
            if (end != null) {
                builder.setLatestArrival(Double.parseDouble(end));
            }
            if ((returnToDepot = vehicleConfig.getString("returnToDepot")) != null) {
                builder.setReturnToDepot(vehicleConfig.getBoolean("returnToDepot"));
            }
            if ((skillString = vehicleConfig.getString("skills")) != null) {
                String[] skillTokens;
                String cleaned = skillString.replaceAll("\\s", "");
                for (String skill : skillTokens = cleaned.split("[,;]")) {
                    builder.addSkill(skill.toLowerCase());
                }
            }
            if (!(breakTWConfigs = vehicleConfig.configurationsAt("breaks.timeWindows.timeWindow")).isEmpty()) {
                String breakDurationString = vehicleConfig.getString("breaks.duration");
                String id = vehicleConfig.getString("breaks.id");
                Break.Builder current_break = Break.Builder.newInstance((String)id);
                current_break.setServiceTime(Double.parseDouble(breakDurationString));
                for (HierarchicalConfiguration twConfig : breakTWConfigs) {
                    current_break.addTimeWindow(TimeWindow.newInstance((double)twConfig.getDouble("start"), (double)twConfig.getDouble("end")));
                }
                builder.setBreak(current_break.build());
            }
            VehicleImpl vehicle = builder.build();
            this.vrpBuilder.addVehicle((AbstractVehicle)vehicle);
            this.vehicleMap.put(vehicleId, (Vehicle)vehicle);
        }
    }

    static class DefaultServiceBuilderFactory
    implements ServiceBuilderFactory {
        DefaultServiceBuilderFactory() {
        }

        @Override
        public Service.Builder createBuilder(String serviceType, String id, Integer size) {
            if (serviceType.equals("pickup")) {
                if (size != null) {
                    return Pickup.Builder.newInstance((String)id).addSizeDimension(0, size.intValue());
                }
                return Pickup.Builder.newInstance((String)id);
            }
            if (serviceType.equals("delivery")) {
                if (size != null) {
                    return Delivery.Builder.newInstance((String)id).addSizeDimension(0, size.intValue());
                }
                return Delivery.Builder.newInstance((String)id);
            }
            if (size != null) {
                return Service.Builder.newInstance((String)id).addSizeDimension(0, size.intValue());
            }
            return Service.Builder.newInstance((String)id);
        }
    }

    public static interface ServiceBuilderFactory {
        public Service.Builder createBuilder(String var1, String var2, Integer var3);
    }
}

