/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.io.problem;

import com.graphhopper.jsprit.core.problem.Skills;
import com.graphhopper.jsprit.core.problem.VehicleRoutingProblem;
import com.graphhopper.jsprit.core.problem.job.Break;
import com.graphhopper.jsprit.core.problem.job.Job;
import com.graphhopper.jsprit.core.problem.job.Service;
import com.graphhopper.jsprit.core.problem.job.Shipment;
import com.graphhopper.jsprit.core.problem.solution.VehicleRoutingProblemSolution;
import com.graphhopper.jsprit.core.problem.solution.route.VehicleRoute;
import com.graphhopper.jsprit.core.problem.solution.route.activity.TimeWindow;
import com.graphhopper.jsprit.core.problem.solution.route.activity.TourActivity;
import com.graphhopper.jsprit.core.problem.vehicle.Vehicle;
import com.graphhopper.jsprit.core.problem.vehicle.VehicleType;
import com.graphhopper.jsprit.core.util.Solutions;
import com.graphhopper.jsprit.core.util.VehicleIndexComparator;
import com.graphhopper.jsprit.io.problem.Schema;
import java.io.ByteArrayOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class VrpXMLWriter {
    private Logger log = LoggerFactory.getLogger(VrpXMLWriter.class);
    private VehicleRoutingProblem vrp;
    private Collection<VehicleRoutingProblemSolution> solutions;
    private boolean onlyBestSolution = false;
    private static Logger logger = LoggerFactory.getLogger(VrpXMLWriter.class);

    public VrpXMLWriter(VehicleRoutingProblem vrp, Collection<VehicleRoutingProblemSolution> solutions, boolean onlyBestSolution) {
        this.vrp = vrp;
        this.solutions = new ArrayList<VehicleRoutingProblemSolution>(solutions);
        this.onlyBestSolution = onlyBestSolution;
    }

    public VrpXMLWriter(VehicleRoutingProblem vrp, Collection<VehicleRoutingProblemSolution> solutions) {
        this.vrp = vrp;
        this.solutions = solutions;
    }

    public VrpXMLWriter(VehicleRoutingProblem vrp) {
        this.vrp = vrp;
        this.solutions = null;
    }

    public void write(String filename) {
        if (!filename.endsWith(".xml")) {
            filename = filename + ".xml";
        }
        this.log.info("write vrp: " + filename);
        XMLConf xmlConfig = this.createXMLConfiguration();
        try {
            xmlConfig.setFileName(filename);
            FileWriter out = new FileWriter(filename);
            XMLSerializer serializer = new XMLSerializer((Writer)out, this.createOutputFormat());
            serializer.serialize(xmlConfig.getDocument());
            ((Writer)out).close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public OutputStream write() {
        XMLConf xmlConfig = this.createXMLConfiguration();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            XMLSerializer serializer = new XMLSerializer((OutputStream)out, this.createOutputFormat());
            serializer.serialize(xmlConfig.getDocument());
            ((OutputStream)out).close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return out;
    }

    private XMLConf createXMLConfiguration() {
        XMLConf xmlConfig = new XMLConf();
        xmlConfig.setRootElementName("problem");
        xmlConfig.setAttributeSplittingDisabled(true);
        xmlConfig.setDelimiterParsingDisabled(true);
        this.writeProblemType(xmlConfig);
        this.writeVehiclesAndTheirTypes(xmlConfig);
        ArrayList<Job> jobs = new ArrayList<Job>();
        jobs.addAll(this.vrp.getJobs().values());
        for (VehicleRoute r : this.vrp.getInitialVehicleRoutes()) {
            jobs.addAll(r.getTourActivities().getJobs());
        }
        this.writeServices(xmlConfig, jobs);
        this.writeShipments(xmlConfig, jobs);
        this.writeInitialRoutes(xmlConfig);
        if (this.onlyBestSolution && this.solutions != null) {
            VehicleRoutingProblemSolution solution = Solutions.bestOf(this.solutions);
            this.solutions.clear();
            this.solutions.add(solution);
        }
        this.writeSolutions(xmlConfig);
        try {
            Document document = xmlConfig.createDoc();
            Element element = document.getDocumentElement();
            element.setAttribute("xmlns", "http://www.w3schools.com");
            element.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            element.setAttribute("xsi:schemaLocation", "http://www.w3schools.com vrp_xml_schema.xsd");
        }
        catch (ConfigurationException e) {
            throw new RuntimeException(e);
        }
        return xmlConfig;
    }

    private OutputFormat createOutputFormat() {
        OutputFormat format = new OutputFormat();
        format.setIndenting(true);
        format.setIndent(5);
        return format;
    }

    private void writeInitialRoutes(XMLConf xmlConfig) {
        if (this.vrp.getInitialVehicleRoutes().isEmpty()) {
            return;
        }
        String path = "initialRoutes.route";
        int routeCounter = 0;
        for (VehicleRoute route : this.vrp.getInitialVehicleRoutes()) {
            xmlConfig.setProperty(path + "(" + routeCounter + ").driverId", route.getDriver().getId());
            xmlConfig.setProperty(path + "(" + routeCounter + ").vehicleId", route.getVehicle().getId());
            xmlConfig.setProperty(path + "(" + routeCounter + ").start", route.getStart().getEndTime());
            int actCounter = 0;
            for (TourActivity act : route.getTourActivities().getActivities()) {
                xmlConfig.setProperty(path + "(" + routeCounter + ").act(" + actCounter + ")[@type]", act.getName());
                if (act instanceof TourActivity.JobActivity) {
                    Job job = ((TourActivity.JobActivity)act).getJob();
                    if (job instanceof Service) {
                        xmlConfig.setProperty(path + "(" + routeCounter + ").act(" + actCounter + ").serviceId", job.getId());
                    } else if (job instanceof Shipment) {
                        xmlConfig.setProperty(path + "(" + routeCounter + ").act(" + actCounter + ").shipmentId", job.getId());
                    } else if (job instanceof Break) {
                        xmlConfig.setProperty(path + "(" + routeCounter + ").act(" + actCounter + ").breakId", job.getId());
                    } else {
                        throw new IllegalStateException("cannot write solution correctly since job-type is not know. make sure you use either service or shipment, or another writer");
                    }
                }
                xmlConfig.setProperty(path + "(" + routeCounter + ").act(" + actCounter + ").arrTime", act.getArrTime());
                xmlConfig.setProperty(path + "(" + routeCounter + ").act(" + actCounter + ").endTime", act.getEndTime());
                ++actCounter;
            }
            xmlConfig.setProperty(path + "(" + routeCounter + ").end", route.getEnd().getArrTime());
            ++routeCounter;
        }
    }

    private void writeSolutions(XMLConf xmlConfig) {
        if (this.solutions == null) {
            return;
        }
        String solutionPath = "solutions.solution";
        int counter = 0;
        for (VehicleRoutingProblemSolution solution : this.solutions) {
            xmlConfig.setProperty(solutionPath + "(" + counter + ").cost", solution.getCost());
            int routeCounter = 0;
            ArrayList list = new ArrayList(solution.getRoutes());
            Collections.sort(list, new VehicleIndexComparator());
            for (VehicleRoute route : list) {
                xmlConfig.setProperty(solutionPath + "(" + counter + ").routes.route(" + routeCounter + ").driverId", route.getDriver().getId());
                xmlConfig.setProperty(solutionPath + "(" + counter + ").routes.route(" + routeCounter + ").vehicleId", route.getVehicle().getId());
                xmlConfig.setProperty(solutionPath + "(" + counter + ").routes.route(" + routeCounter + ").start", route.getStart().getEndTime());
                int actCounter = 0;
                for (TourActivity act : route.getTourActivities().getActivities()) {
                    xmlConfig.setProperty(solutionPath + "(" + counter + ").routes.route(" + routeCounter + ").act(" + actCounter + ")[@type]", act.getName());
                    if (act instanceof TourActivity.JobActivity) {
                        Job job = ((TourActivity.JobActivity)act).getJob();
                        if (job instanceof Break) {
                            xmlConfig.setProperty(solutionPath + "(" + counter + ").routes.route(" + routeCounter + ").act(" + actCounter + ").breakId", job.getId());
                        } else if (job instanceof Service) {
                            xmlConfig.setProperty(solutionPath + "(" + counter + ").routes.route(" + routeCounter + ").act(" + actCounter + ").serviceId", job.getId());
                        } else if (job instanceof Shipment) {
                            xmlConfig.setProperty(solutionPath + "(" + counter + ").routes.route(" + routeCounter + ").act(" + actCounter + ").shipmentId", job.getId());
                        } else {
                            throw new IllegalStateException("cannot write solution correctly since job-type is not know. make sure you use either service or shipment, or another writer");
                        }
                    }
                    xmlConfig.setProperty(solutionPath + "(" + counter + ").routes.route(" + routeCounter + ").act(" + actCounter + ").arrTime", act.getArrTime());
                    xmlConfig.setProperty(solutionPath + "(" + counter + ").routes.route(" + routeCounter + ").act(" + actCounter + ").endTime", act.getEndTime());
                    ++actCounter;
                }
                xmlConfig.setProperty(solutionPath + "(" + counter + ").routes.route(" + routeCounter + ").end", route.getEnd().getArrTime());
                ++routeCounter;
            }
            int unassignedJobCounter = 0;
            for (Job unassignedJob : solution.getUnassignedJobs()) {
                xmlConfig.setProperty(solutionPath + "(" + counter + ").unassignedJobs.job(" + unassignedJobCounter + ")[@id]", unassignedJob.getId());
                ++unassignedJobCounter;
            }
            ++counter;
        }
    }

    private void writeServices(XMLConf xmlConfig, List<Job> jobs) {
        String shipmentPathString = "services.service";
        int counter = 0;
        for (Job j : jobs) {
            if (!(j instanceof Service)) continue;
            Service service = (Service)j;
            xmlConfig.setProperty(shipmentPathString + "(" + counter + ")[@id]", service.getId());
            xmlConfig.setProperty(shipmentPathString + "(" + counter + ")[@type]", service.getType());
            if (service.getLocation().getId() != null) {
                xmlConfig.setProperty(shipmentPathString + "(" + counter + ").location.id", service.getLocation().getId());
            }
            if (service.getLocation().getCoordinate() != null) {
                xmlConfig.setProperty(shipmentPathString + "(" + counter + ").location.coord[@x]", service.getLocation().getCoordinate().getX());
                xmlConfig.setProperty(shipmentPathString + "(" + counter + ").location.coord[@y]", service.getLocation().getCoordinate().getY());
            }
            if (service.getLocation().getIndex() != -1) {
                xmlConfig.setProperty(shipmentPathString + "(" + counter + ").location.index", service.getLocation().getIndex());
            }
            for (int i = 0; i < service.getSize().getNuOfDimensions(); ++i) {
                xmlConfig.setProperty(shipmentPathString + "(" + counter + ").capacity-dimensions.dimension(" + i + ")[@index]", i);
                xmlConfig.setProperty(shipmentPathString + "(" + counter + ").capacity-dimensions.dimension(" + i + ")", service.getSize().get(i));
            }
            Collection tws = service.getTimeWindows();
            int index = 0;
            xmlConfig.setProperty(shipmentPathString + "(" + counter + ").duration", service.getServiceDuration());
            for (TimeWindow tw : tws) {
                xmlConfig.setProperty(shipmentPathString + "(" + counter + ").timeWindows.timeWindow(" + index + ").start", tw.getStart());
                xmlConfig.setProperty(shipmentPathString + "(" + counter + ").timeWindows.timeWindow(" + index + ").end", tw.getEnd());
                ++index;
            }
            String skillString = this.getSkillString((Job)service);
            xmlConfig.setProperty(shipmentPathString + "(" + counter + ").requiredSkills", skillString);
            if (service.getName() != null && !service.getName().equals("no-name")) {
                xmlConfig.setProperty(shipmentPathString + "(" + counter + ").name", service.getName());
            }
            ++counter;
        }
    }

    private void writeShipments(XMLConf xmlConfig, List<Job> jobs) {
        String shipmentPathString = "shipments.shipment";
        int counter = 0;
        for (Job j : jobs) {
            Object tw2;
            if (!(j instanceof Shipment)) continue;
            Shipment shipment = (Shipment)j;
            xmlConfig.setProperty(shipmentPathString + "(" + counter + ")[@id]", shipment.getId());
            if (shipment.getPickupLocation().getId() != null) {
                xmlConfig.setProperty(shipmentPathString + "(" + counter + ").pickup.location.id", shipment.getPickupLocation().getId());
            }
            if (shipment.getPickupLocation().getCoordinate() != null) {
                xmlConfig.setProperty(shipmentPathString + "(" + counter + ").pickup.location.coord[@x]", shipment.getPickupLocation().getCoordinate().getX());
                xmlConfig.setProperty(shipmentPathString + "(" + counter + ").pickup.location.coord[@y]", shipment.getPickupLocation().getCoordinate().getY());
            }
            if (shipment.getPickupLocation().getIndex() != -1) {
                xmlConfig.setProperty(shipmentPathString + "(" + counter + ").pickup.location.index", shipment.getPickupLocation().getIndex());
            }
            Collection pu_tws = shipment.getPickupTimeWindows();
            int index = 0;
            xmlConfig.setProperty(shipmentPathString + "(" + counter + ").pickup.duration", shipment.getPickupServiceTime());
            for (Object tw2 : pu_tws) {
                xmlConfig.setProperty(shipmentPathString + "(" + counter + ").pickup.timeWindows.timeWindow(" + index + ").start", tw2.getStart());
                xmlConfig.setProperty(shipmentPathString + "(" + counter + ").pickup.timeWindows.timeWindow(" + index + ").end", tw2.getEnd());
                ++index;
            }
            if (shipment.getDeliveryLocation().getId() != null) {
                xmlConfig.setProperty(shipmentPathString + "(" + counter + ").delivery.location.id", shipment.getDeliveryLocation().getId());
            }
            if (shipment.getDeliveryLocation().getCoordinate() != null) {
                xmlConfig.setProperty(shipmentPathString + "(" + counter + ").delivery.location.coord[@x]", shipment.getDeliveryLocation().getCoordinate().getX());
                xmlConfig.setProperty(shipmentPathString + "(" + counter + ").delivery.location.coord[@y]", shipment.getDeliveryLocation().getCoordinate().getY());
            }
            if (shipment.getDeliveryLocation().getIndex() != -1) {
                xmlConfig.setProperty(shipmentPathString + "(" + counter + ").delivery.location.index", shipment.getDeliveryLocation().getIndex());
            }
            Collection del_tws = shipment.getDeliveryTimeWindows();
            xmlConfig.setProperty(shipmentPathString + "(" + counter + ").delivery.duration", shipment.getDeliveryServiceTime());
            index = 0;
            tw2 = del_tws.iterator();
            while (tw2.hasNext()) {
                TimeWindow tw3 = (TimeWindow)tw2.next();
                xmlConfig.setProperty(shipmentPathString + "(" + counter + ").delivery.timeWindows.timeWindow(" + index + ").start", tw3.getStart());
                xmlConfig.setProperty(shipmentPathString + "(" + counter + ").delivery.timeWindows.timeWindow(" + index + ").end", tw3.getEnd());
                ++index;
            }
            for (int i = 0; i < shipment.getSize().getNuOfDimensions(); ++i) {
                xmlConfig.setProperty(shipmentPathString + "(" + counter + ").capacity-dimensions.dimension(" + i + ")[@index]", i);
                xmlConfig.setProperty(shipmentPathString + "(" + counter + ").capacity-dimensions.dimension(" + i + ")", shipment.getSize().get(i));
            }
            String skillString = this.getSkillString((Job)shipment);
            xmlConfig.setProperty(shipmentPathString + "(" + counter + ").requiredSkills", skillString);
            if (shipment.getName() != null && !shipment.getName().equals("no-name")) {
                xmlConfig.setProperty(shipmentPathString + "(" + counter + ").name", shipment.getName());
            }
            ++counter;
        }
    }

    private void writeProblemType(XMLConfiguration xmlConfig) {
        xmlConfig.setProperty("problemType.fleetSize", (Object)this.vrp.getFleetSize());
    }

    private void writeVehiclesAndTheirTypes(XMLConfiguration xmlConfig) {
        String vehiclePathString = "vehicles.vehicle";
        int counter = 0;
        for (Vehicle vehicle : this.vrp.getVehicles()) {
            xmlConfig.setProperty(vehiclePathString + "(" + counter + ").id", (Object)vehicle.getId());
            xmlConfig.setProperty(vehiclePathString + "(" + counter + ").typeId", (Object)vehicle.getType().getTypeId());
            xmlConfig.setProperty(vehiclePathString + "(" + counter + ").startLocation.id", (Object)vehicle.getStartLocation().getId());
            if (vehicle.getStartLocation().getCoordinate() != null) {
                xmlConfig.setProperty(vehiclePathString + "(" + counter + ").startLocation.coord[@x]", (Object)vehicle.getStartLocation().getCoordinate().getX());
                xmlConfig.setProperty(vehiclePathString + "(" + counter + ").startLocation.coord[@y]", (Object)vehicle.getStartLocation().getCoordinate().getY());
            }
            if (vehicle.getStartLocation().getIndex() != -1) {
                xmlConfig.setProperty(vehiclePathString + "(" + counter + ").startLocation.index", (Object)vehicle.getStartLocation().getIndex());
            }
            xmlConfig.setProperty(vehiclePathString + "(" + counter + ").endLocation.id", (Object)vehicle.getEndLocation().getId());
            if (vehicle.getEndLocation().getCoordinate() != null) {
                xmlConfig.setProperty(vehiclePathString + "(" + counter + ").endLocation.coord[@x]", (Object)vehicle.getEndLocation().getCoordinate().getX());
                xmlConfig.setProperty(vehiclePathString + "(" + counter + ").endLocation.coord[@y]", (Object)vehicle.getEndLocation().getCoordinate().getY());
            }
            if (vehicle.getEndLocation().getIndex() != -1) {
                xmlConfig.setProperty(vehiclePathString + "(" + counter + ").endLocation.index", (Object)vehicle.getEndLocation().getId());
            }
            xmlConfig.setProperty(vehiclePathString + "(" + counter + ").timeSchedule.start", (Object)vehicle.getEarliestDeparture());
            xmlConfig.setProperty(vehiclePathString + "(" + counter + ").timeSchedule.end", (Object)vehicle.getLatestArrival());
            if (vehicle.getBreak() != null) {
                Collection tws = vehicle.getBreak().getTimeWindows();
                int index = 0;
                xmlConfig.setProperty(vehiclePathString + "(" + counter + ").breaks.duration", (Object)vehicle.getBreak().getServiceDuration());
                for (TimeWindow tw : tws) {
                    xmlConfig.setProperty(vehiclePathString + "(" + counter + ").breaks.timeWindows.timeWindow(" + index + ").start", (Object)tw.getStart());
                    xmlConfig.setProperty(vehiclePathString + "(" + counter + ").breaks.timeWindows.timeWindow(" + index + ").end", (Object)tw.getEnd());
                    ++index;
                }
            }
            xmlConfig.setProperty(vehiclePathString + "(" + counter + ").returnToDepot", (Object)vehicle.isReturnToDepot());
            String skillString = this.getSkillString(vehicle);
            xmlConfig.setProperty(vehiclePathString + "(" + counter + ").skills", (Object)skillString);
            ++counter;
        }
        String typePathString = Schema.builder().append("vehicleTypes").dot("type").build();
        int typeCounter = 0;
        for (VehicleType type : this.vrp.getTypes()) {
            xmlConfig.setProperty(typePathString + "(" + typeCounter + ").id", (Object)type.getTypeId());
            for (int i = 0; i < type.getCapacityDimensions().getNuOfDimensions(); ++i) {
                xmlConfig.setProperty(typePathString + "(" + typeCounter + ").capacity-dimensions.dimension(" + i + ")[@index]", (Object)i);
                xmlConfig.setProperty(typePathString + "(" + typeCounter + ").capacity-dimensions.dimension(" + i + ")", (Object)type.getCapacityDimensions().get(i));
            }
            xmlConfig.setProperty(typePathString + "(" + typeCounter + ").costs.fixed", (Object)type.getVehicleCostParams().fix);
            xmlConfig.setProperty(typePathString + "(" + typeCounter + ").costs.distance", (Object)type.getVehicleCostParams().perDistanceUnit);
            xmlConfig.setProperty(typePathString + "(" + typeCounter + ").costs.time", (Object)type.getVehicleCostParams().perTransportTimeUnit);
            xmlConfig.setProperty(typePathString + "(" + typeCounter + ").costs.service", (Object)type.getVehicleCostParams().perServiceTimeUnit);
            xmlConfig.setProperty(typePathString + "(" + typeCounter + ").costs.wait", (Object)type.getVehicleCostParams().perWaitingTimeUnit);
            ++typeCounter;
        }
    }

    private String getSkillString(Vehicle vehicle) {
        return this.createSkillString(vehicle.getSkills());
    }

    private String getSkillString(Job job) {
        return this.createSkillString(job.getRequiredSkills());
    }

    private String createSkillString(Skills skills) {
        if (skills.values().size() == 0) {
            return null;
        }
        String skillString = null;
        for (String skill : skills.values()) {
            if (skillString == null) {
                skillString = skill;
                continue;
            }
            skillString = skillString + ", " + skill;
        }
        return skillString;
    }

    static class XMLConf
    extends XMLConfiguration {
        private static final long serialVersionUID = 1L;

        XMLConf() {
        }

        public Document createDoc() throws ConfigurationException {
            return this.createDocument();
        }
    }
}

