/*
 * Decompiled with CFR 0.152.
 */
package com.graphql_java_generator.customscalars;

import graphql.language.StringValue;
import graphql.schema.Coercing;
import graphql.schema.CoercingParseLiteralException;
import graphql.schema.CoercingParseValueException;
import graphql.schema.CoercingSerializeException;
import graphql.schema.GraphQLScalarType;
import java.util.Base64;

public class GraphQLScalarTypeBase64String {
    public static final GraphQLScalarType GraphQLBase64String = GraphQLScalarType.newScalar().name("Base64String").description("Base64-encoded binary").coercing((Coercing)new Coercing<byte[], String>(){

        public String serialize(Object input) {
            if (input instanceof byte[]) {
                return Base64.getEncoder().encodeToString((byte[])input);
            }
            if (input instanceof String) {
                return (String)input;
            }
            throw new CoercingSerializeException("Can't parse the '" + input.toString() + "' Date to a String (it should be a " + Byte.TYPE.getName() + "[] but is a " + input.getClass().getName() + ")");
        }

        public byte[] parseValue(Object input) {
            if (input instanceof String) {
                try {
                    return Base64.getDecoder().decode((String)input);
                }
                catch (IllegalArgumentException e) {
                    throw new CoercingParseValueException("Input string \"" + input + "\" is not a valid Base64 value", (Throwable)e);
                }
            }
            if (input instanceof byte[]) {
                return (byte[])input;
            }
            throw new CoercingParseValueException("The input object should be either a String or a byte array, but is a " + input.getClass().getName());
        }

        public byte[] parseLiteral(Object input) {
            if (input instanceof StringValue) {
                try {
                    return Base64.getDecoder().decode(((StringValue)input).getValue());
                }
                catch (IllegalArgumentException e) {
                    throw new CoercingParseLiteralException("Input string \"" + input + "\" is not a valid Base64 value", (Throwable)e);
                }
            }
            throw new CoercingParseValueException("Can't parse the '" + input.toString() + "' string to an Base64 string");
        }
    }).build();
}

