/** Generated by the default template from graphql-java-generator */
package ${packageUtilName};

import static java.util.Collections.singletonList;

import java.io.IOException;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicReference;

import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.socket.CloseStatus;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.handler.TextWebSocketHandler;

import com.graphql_java_generator.server.util.JsonKit;
import com.graphql_java_generator.server.util.QueryParameters;

import graphql.ExecutionInput;
import graphql.ExecutionResult;
import graphql.GraphQL;
import graphql.execution.instrumentation.ChainedInstrumentation;
import graphql.execution.instrumentation.Instrumentation;
import graphql.execution.instrumentation.tracing.TracingInstrumentation;
import graphql.schema.GraphQLSchema;

public class WebSocketHandler extends TextWebSocketHandler {

	private static final Logger log = LoggerFactory.getLogger(WebSocketHandler.class);

	GraphQLSchema graphQLSchema;
	GraphQLWiring graphQLWiring;

	// Key (String) is SessionId
	private final HashMap<String, Subscription> subscriptionRef = new HashMap<>();

	public WebSocketHandler(GraphQLWiring graphQLWiring, GraphQLSchema graphQLSchema) {
		this.graphQLWiring = graphQLWiring;
		this.graphQLSchema = graphQLSchema;
	}

	@Override
	public void afterConnectionEstablished(WebSocketSession session) throws Exception {
		log.debug("Websocket connection established: {}", session.getId());
	}

	@Override
	public void afterConnectionClosed(WebSocketSession session, CloseStatus status) throws Exception {
		synchronized (subscriptionRef) {
			Subscription subscription = subscriptionRef.remove(session.getId());
			if (subscription != null) {
				subscription.cancel();
			} else {
				log.warn("Failed to find subscription");
			}
		}
		log.debug("Websocket connection closed: {} / Memorized session: {}", session.getId(), subscriptionRef.size());
	}

	@Override
	protected void handleTextMessage(WebSocketSession webSocketSession, TextMessage message) throws Exception {
		String graphqlQuery = message.getPayload();
		log.trace("Websocket said {}", graphqlQuery);

		QueryParameters parameters = QueryParameters.from(graphqlQuery);

		ExecutionInput executionInput = ExecutionInput.newExecutionInput().query(parameters.getQuery())
				.variables(parameters.getVariables()).operationName(parameters.getOperationName()).build();

		Instrumentation instrumentation = new ChainedInstrumentation(singletonList(new TracingInstrumentation()));

		//
		// In order to have subscriptions in graphql-java you MUST use the
		// SubscriptionExecutionStrategy strategy.
		//
		GraphQL graphQL = GraphQL.newGraphQL(graphQLSchema).instrumentation(instrumentation).build();

		ExecutionResult executionResult = graphQL.execute(executionInput);

		Publisher<ExecutionResult> publisher = executionResult.getData();

		publisher.subscribe(new Subscriber<ExecutionResult>() {

			private final String sessionId = webSocketSession.getId();
			private Subscription subscription;

			@Override
			public void onSubscribe(Subscription s) {
				log.debug("Executing subscription");
				synchronized (subscriptionRef) {
					subscriptionRef.put(sessionId, s);
				}
				subscription = s;
				subscription.request(1);
			}

			@Override
			public void onNext(ExecutionResult er) {
				try {
					Object data = er.getData();
					String json = JsonKit.toJsonString(data);
					log.trace("Sending new notification: {}", json);
					webSocketSession.sendMessage(new TextMessage(json));
				} catch (IOException e) {
					e.printStackTrace();
				}
				subscription.request(1);
			}

			@Override
			public void onError(Throwable t) {
				log.error("Subscription threw an exception", t);
				try {
					webSocketSession.close();
				} catch (IOException e) {
					log.error("Unable to close websocket session", e);
				}
			}

			@Override
			public void onComplete() {
				log.debug("Subscription complete");
				try {
					webSocketSession.close();
				} catch (IOException e) {
					log.error("Unable to close websocket session", e);
				}
			}
		});
	}

}
