/** Generated by the default template from graphql-java-generator */
package ${packageUtilName};

/**
 * @author generated by graphql-java-generator
 * @see <a href="https://github.com/graphql-java-generator/graphql-java-generator">https://github.com/graphql-java-generator/graphql-java-generator</a>
 */
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.concurrent.CompletableFuture;

import javax.annotation.PostConstruct;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.dataloader.DataLoader;
import org.dataloader.DataLoaderRegistry;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import graphql.ExecutionInput;
import graphql.ExecutionResult;
import graphql.GraphQL;
import graphql.TypeResolutionEnvironment;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLSchema;
import graphql.schema.TypeResolver;
import graphql.schema.idl.RuntimeWiring;
import graphql.schema.idl.SchemaGenerator;
import graphql.schema.idl.SchemaParser;
import graphql.schema.idl.TypeDefinitionRegistry;
import graphql.schema.idl.TypeRuntimeWiring;
import graphql.schema.idl.TypeRuntimeWiring.Builder;

#if($configuration.generateBatchLoaderEnvironment)
import com.graphql_java_generator.server.util.BatchLoaderDelegateWithContext;
#else
import com.graphql_java_generator.server.util.BatchLoaderDelegate;
#end

/**
 * This class is responsible for providing all the GraphQL Beans to the graphql-java Spring Boot integration.
 * <BR/><BR/>
 * Based on the https://www.graphql-java.com/tutorials/getting-started-with-spring-boot/ tutorial
 * 
 * @author etienne-sf
 */
@Component
@SuppressWarnings("unused")
public class GraphQLWiring {

	/** The logger for this instance */
	protected Logger logger = LoggerFactory.getLogger(GraphQLWiring.class);

	@Autowired
	protected GraphQLDataFetchers graphQLDataFetchers;

	protected RuntimeWiring buildWiring() {
		return RuntimeWiring.newRuntimeWiring()
				//
				// Wiring every custom scalar definitions
#foreach ($customScalar in $customScalars)
##
## Step 1: wiring the custom scalar definitions
##
#if (${customScalar.customScalarDefinition.graphQLScalarTypeClass})
			.scalar(new ${customScalar.customScalarDefinition.graphQLScalarTypeClass}())
#elseif (${customScalar.customScalarDefinition.graphQLScalarTypeStaticField})
			.scalar(${customScalar.customScalarDefinition.graphQLScalarTypeStaticField})
#elseif (${customScalar.customScalarDefinition.graphQLScalarTypeGetter})
			.scalar(${customScalar.customScalarDefinition.graphQLScalarTypeGetter})
#else
			.scalar(): ${customScalar.javaName} : you must define one of graphQLScalarTypeClass, graphQLScalarTypeStaticField or graphQLScalarTypeGetter (in the POM parameters for CustomScalars)
#end
#end
##
## Step 2: wiring every object type
##
			//
			// Wiring every GraphQL type
#foreach ($dataFetchersDelegate in $dataFetchersDelegates)
			.type("${dataFetchersDelegate.type.javaName}", typeWiring -> addWiringFor${dataFetchersDelegate.type.javaName}(typeWiring))
#end
##
## Step 3: wiring every interface
##
#if ($interfaces.size() > 0)
			//
			// Let's link the interface types to the concrete types
#end
#foreach ($interface in $interfaces)
			.type("${interface.javaName}", typeWiring -> typeWiring.typeResolver(getResolverFor${interface.javaName}()))
#end
##
## Step 4: wiring every union 
##
#if ($unions.size() > 0)
			//
			// Let's link the union types to the concrete types
#end
#foreach ($union in $unions)
			.type("${union.javaName}", typeWiring -> typeWiring.typeResolver(getResolverFor${union.javaName}()))
#end
			//
			// Let's finish the job
			.build();
	} // buildWiring()


#foreach ($dataFetchersDelegate in $dataFetchersDelegates)
	/**
	 * Wiring for the ${dataFetchersDelegate.type.javaName} object type. This method actually calls the 
	 * <I>get${dataFetchersDelegate.type.javaName}_XXXXXDataFetcher()</I> methods. So, when you need to override the default wiring, 
	 * you can either override this method and declare all the field's wiring, or override one of the
	 * <I>get${dataFetchersDelegate.type.javaName}_XXXXXDataFetcher()</I> methods to only redefine the wiring for one field 
	 * 
	 * @param typeWiring The Builder, on which you can for instance call the {@link Builder${sharp}dataFetcher(String, graphql.schema.DataFetcher)} 
	 * 		or {@link Builder${sharp}dataFetchers(java.util.Map)} method.
	 * @return The builder
	 */
	protected TypeRuntimeWiring.Builder addWiringFor${dataFetchersDelegate.type.javaName}(TypeRuntimeWiring.Builder typeWiring) {
#foreach ($dataFetcher in $dataFetchersDelegate.dataFetchers)
		typeWiring.dataFetcher("${dataFetcher.field.javaName}", graphQLDataFetchers.${dataFetchersDelegate.camelCaseName}${dataFetcher.pascalCaseName}#if(${dataFetcher.completableFuture})WithDataLoader#end());
#end
		return typeWiring;
	}

#end
	
#foreach ($interface in $interfaces)
	protected TypeResolver getResolverFor${interface.javaName}() {
		return new TypeResolver() {
			@Override
			public GraphQLObjectType getType(TypeResolutionEnvironment env) {
#if ($interface.implementingTypes.size() == 0)
## No implementing type.
				return null;
#else
				Object javaObject = env.getObject();
				String ret = null;
#foreach ($implementingType in ${interface.implementingTypes})
				if (javaObject instanceof ${implementingType.classFullName}) {
					ret = "${implementingType.javaName}";
				} else
#end
				{
					throw new RuntimeException("Can't resolve javaObject " + javaObject.getClass().getName());
				}
				logger.trace("Resolved type for javaObject {} is {}", javaObject.getClass().getName());
				return env.getSchema().getObjectType(ret);
#end
			}
		};
	}

#end
#foreach ($union in $unions)
	protected TypeResolver getResolverFor${union.javaName}() {
		return new TypeResolver() {
			@Override
			public GraphQLObjectType getType(TypeResolutionEnvironment env) {
				Object javaObject = env.getObject();
				String ret = null;

#foreach ($memberType in ${union.memberTypes})
				if (javaObject instanceof ${memberType.classFullName}) {
					ret = "${memberType.javaName}";
				} else
#end
				{
					throw new RuntimeException("Can't resolve javaObject " + javaObject.getClass().getName());
				}
				logger.trace("Resolved type for javaObject {} is {}", javaObject.getClass().getName());
				return env.getSchema().getObjectType(ret);
			}
		};
	}

#end
}
