##
## Maven ignores the default value for springBeanSuffix, and replaces it by a null value. In this case, we replace the value by an empty String 
#if (!$configuration.springBeanSuffix) #set($springBeanSuffix="") #else #set($springBeanSuffix = ${configuration.springBeanSuffix}) #end
##
/** Generated by the default template from graphql-java-generator */
package ${packageUtilName};

import com.graphql_java_generator.client.directive.Directive;
import com.graphql_java_generator.client.directive.DirectiveLocation;
import com.graphql_java_generator.client.directive.DirectiveRegistry;
import com.graphql_java_generator.client.directive.DirectiveRegistryImpl;
import com.graphql_java_generator.client.request.InputParameter;
import com.graphql_java_generator.client.request.InputParameter.InputParameterType;
import com.graphql_java_generator.customscalars.CustomScalarRegistryImpl;

@SuppressWarnings("unused")
public class DirectiveRegistryInitializer {
	
	/**
	 * Initialization of the {@link DirectiveRegistry} with all known custom scalars, that is with all custom scalars
	 * defined in the project pom
	 */
	public static DirectiveRegistry initDirectiveRegistry() {
		DirectiveRegistry directiveRegistry = new DirectiveRegistryImpl();
		Directive directive;

#foreach ($directive in $directives)
		/////////////////////////////////////////////////////////////////////////////////////////////////////
		// Creating Directive ${directive.name}
		/////////////////////////////////////////////////////////////////////////////////////////////////////
		directive = new Directive();
		directive.setName("${directive.name}");
		directive.setPackageName("${packageUtilName}");
#foreach ($argument in $directive.arguments)
		directive.getArguments().add(
			InputParameter.newHardCodedParameter(
					"$springBeanSuffix", "${argument.name}", null, "${argument.graphQLTypeSimpleName}", ${argument.fieldTypeAST.mandatory}, ${argument.fieldTypeAST.listDepth}, ${argument.fieldTypeAST.itemMandatory}));
#end
#foreach ($location in $directive.directiveLocations)
		directive.getDirectiveLocations().add(DirectiveLocation.${location.name()});
#end
		directiveRegistry.registerDirective(directive);

#end

		DirectiveRegistryImpl.directiveRegistry = directiveRegistry;
		return directiveRegistry;
	}

}
