/** Generated by the default template from graphql-java-generator */
package ${packageUtilName};

import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;

import javax.annotation.Resource;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.dataloader.BatchLoader;
import org.dataloader.DataLoader;
import org.reactivestreams.Publisher;
import org.springframework.stereotype.Component;

import com.graphql_java_generator.util.GraphqlUtils;

import graphql.schema.DataFetcher;
import reactor.core.publisher.Flux;

/**
 * @author generated by graphql-java-generator
 * @see <a href="https://github.com/graphql-java-generator/graphql-java-generator">https://github.com/graphql-java-generator/graphql-java-generator</a>
 */
@Component
@SuppressWarnings("unused")
public class GraphQLDataFetchers {

	/** The logger for this instance */
	protected Logger logger = LoggerFactory.getLogger(GraphQLDataFetchers.class);

#foreach ($dataFetchersDelegate in $dataFetchersDelegates)
	@Resource
	protected ${dataFetchersDelegate.pascalCaseName} ${dataFetchersDelegate.camelCaseName};

#end
	@Resource
	protected GraphqlUtils graphqlUtils;

#foreach ($dataFetchersDelegate in $dataFetchersDelegates)
	////////////////////////////////////////////////////////////////////////////////////////////////
	// Data fetchers for ${dataFetchersDelegate.name}
	////////////////////////////////////////////////////////////////////////////////////////////////
#foreach ($dataFetcher in $dataFetchersDelegate.dataFetchers)
##
## Calculation of the return type: String for enums (to manage the java reserved keyword, enum's value may be different from the item's value in the GraphQL schema), and the type for others
#if ( $dataFetcher.field.type.class.name == "com.graphql_java_generator.plugin.language.impl.EnumType")
#if (${dataFetcher.field.fieldTypeAST.listDepth}>0)
#set ( $returnType = "List<String>" )
#else
#set ( $returnType = "String")
#end
#else
#set ( $returnType = ${dataFetcher.field.javaTypeFullClassname} )
#end

	public DataFetcher<#if(${dataFetcher.completableFuture})CompletableFuture<#end#if(${dataFetcher.dataFetcherDelegate.type.requestType}=="subscription")Publisher<#if($dataFetcher.field.fieldTypeAST.mandatory==false)Optional<#end#end$returnType#if(${dataFetcher.dataFetcherDelegate.type.requestType}=="subscription")#if($dataFetcher.field.fieldTypeAST.mandatory==false)>#end>#end#if(${dataFetcher.completableFuture})>#end> ${dataFetchersDelegate.camelCaseName}${dataFetcher.pascalCaseName}#if(${dataFetcher.completableFuture})WithDataLoader#end() {
		return dataFetchingEnvironment -> {
#foreach ($argument in $dataFetcher.field.inputParameters)          
## $argument is an instance of Field
#if(${argument.fieldTypeAST.listDepth})
			@SuppressWarnings("unchecked")
#end
			${argument.javaTypeFullClassname} ${argument.javaName} = (${argument.javaTypeFullClassname}) graphqlUtils.getArgument(dataFetchingEnvironment.getArgument("${argument.name}"), "${argument.graphQLTypeSimpleName}", "${configuration.javaTypeForIDType}", ${argument.type.classFullName}.class);
#end  ##Foreach
#if($dataFetcher.graphQLOriginType)
			${dataFetcher.graphQLOriginType.classFullName} source = dataFetchingEnvironment.getSource();
#end

####################################################################################################################
#if (${dataFetcher.completableFuture})
			DataLoader<${dataFetcher.field.type.identifier.javaTypeFullClassname}, ${dataFetcher.field.type.classFullName}> dataLoader = dataFetchingEnvironment.getDataLoader("${dataFetcher.field.type.classSimpleName}"); 
			
			// This dataLoader may be null. Let's handle that:
			if (dataLoader != null) { 
				return ${dataFetchersDelegate.camelCaseName}.${dataFetcher.javaName}(dataFetchingEnvironment, dataLoader#if($dataFetcher.graphQLOriginType), source#end#foreach($argument in $dataFetcher.field.inputParameters), ${argument.javaName}#end);
			} else {
				logger.warn("No DataLoader found for key '{}'", "${dataFetcher.field.type.classSimpleName}");
				return CompletableFuture.supplyAsync(
						() -> ${dataFetchersDelegate.camelCaseName}.${dataFetcher.javaName}(dataFetchingEnvironment#if($dataFetcher.graphQLOriginType), source#end#foreach($argument in $dataFetcher.field.inputParameters), ${argument.javaName}#end));
			}
####################################################################################################################
#elseif (${dataFetcher.dataFetcherDelegate.type.requestType}=="subscription" && $dataFetcher.field.type.class.name != "com.graphql_java_generator.plugin.language.impl.EnumType")
			return ${dataFetchersDelegate.camelCaseName}.${dataFetcher.javaName}(dataFetchingEnvironment#if($dataFetcher.graphQLOriginType), source#end#foreach($argument in $dataFetcher.field.inputParameters), ${argument.javaName}#end);
####################################################################################################################
#elseif (${dataFetcher.dataFetcherDelegate.type.requestType}=="subscription" && ${dataFetcher.field.fieldTypeAST.listDepth} == 0)
			// In the GraphQL schema, enum values may be java reserved keywords. To manager this case, this data fetcher returns a String, with
			// the value defined in the GraphQL schema (and not the enum's value which can not be a java reserved keyword)
			return Flux//
					.from(
							${dataFetchersDelegate.camelCaseName}.${dataFetcher.javaName}(dataFetchingEnvironment#if($dataFetcher.graphQLOriginType), source#end#foreach($argument in $dataFetcher.field.inputParameters), ${argument.javaName}#end)
						) //
#if($dataFetcher.field.fieldTypeAST.mandatory==false)
					.map(o -> Optional.of(o.isPresent() ? o.get().graphQlValue() : null));
#else
					.map(o -> o.graphQlValue());
#end
####################################################################################################################
#elseif (${dataFetcher.dataFetcherDelegate.type.requestType}=="subscription" && ${dataFetcher.field.fieldTypeAST.listDepth} > 0)
			// In the GraphQL schema, enum values may be java reserved keywords. To manager this case, this data fetcher returns a String, with
			// the value defined in the GraphQL schema (and not the enum's value which can not be a java reserved keyword)
			return Flux//
					.from(
							${dataFetchersDelegate.camelCaseName}.${dataFetcher.javaName}(dataFetchingEnvironment#if($dataFetcher.graphQLOriginType), source#end#foreach($argument in $dataFetcher.field.inputParameters), ${argument.javaName}#end)
						) //
					.map(l -> {
						if (l.isPresent())
							return Optional.of(l.get().stream()//
									.map(e -> (e == null ? (String) null : e.graphQlValue()))//
									.collect(Collectors.toList()));
						else
							return Optional.empty();
					});
####################################################################################################################
#else
			$returnType ret = ${dataFetchersDelegate.camelCaseName}.${dataFetcher.javaName}(dataFetchingEnvironment#if($dataFetcher.graphQLOriginType), source#end#foreach($argument in $dataFetcher.field.inputParameters), ${argument.javaName}#end)
#if ($dataFetcher.field.type.class.name == "com.graphql_java_generator.plugin.language.impl.EnumType" && ${dataFetcher.field.fieldTypeAST.listDepth}==0)
## enum must be transformed to string, to properly manage enum items that are keywords
				.graphQlValue();

			if (ret != null)
				logger.debug("${dataFetcher.name}: 1 result found");
			else
				logger.debug("${dataFetcher.name}: no result found");
#elseif ($dataFetcher.field.type.class.name == "com.graphql_java_generator.plugin.language.impl.EnumType" && ${dataFetcher.field.fieldTypeAST.listDepth}>0)
## enum must be transformed to string, to properly manage enum items that are keywords
				.stream()
				.map(e -> e.graphQlValue())
				.collect(Collectors.toList());

			if (ret != null)
				logger.debug("${dataFetcher.name}: {} result found", ret.size());
			else
				logger.debug("${dataFetcher.name}: no result found");
#else
				;
#end

			return ret;
#end
		};
	}

#end
#end
}
