#set( $D = '$' )
##
## Maven ignores the default value for springBeanSuffix, and replaces it by a null value. In this case, we replace the value by an empty String 
#if (!$configuration.springBeanSuffix) #set($springBeanSuffix="") #else #set($springBeanSuffix = ${configuration.springBeanSuffix}) #end
##
/** Generated by the default template from graphql-java-generator */
package ${configuration.springAutoConfigurationPackage};

import java.util.Collections;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.client.reactive.ReactorClientHttpConnector;
import org.springframework.security.oauth2.client.web.reactive.function.client.ServerOAuth2AuthorizedClientExchangeFilterFunction;
import org.springframework.web.reactive.function.client.ExchangeFilterFunction;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClient.Builder;
import org.springframework.web.reactive.socket.client.ReactorNettyWebSocketClient;
import org.springframework.web.reactive.socket.client.WebSocketClient;

import com.graphql_java_generator.client.GraphQLConfiguration;
import com.graphql_java_generator.client.OAuthTokenExtractor;
import com.graphql_java_generator.client.RequestExecution;
import com.graphql_java_generator.client.RequestExecutionSpringReactiveImpl;

import reactor.netty.http.client.HttpClient;

/**
 * This Spring {@link Configuration} class defines the Spring Bean for this GraphQL schema.
 * 
 * @author etienne-sf
 */
@Configuration("springConfiguration${springBeanSuffix}") // The name of this bean will be springConfiguration${springBeanSuffix}
@ComponentScan("${packageUtilName}")
public class SpringConfiguration${springBeanSuffix} {

	@Value(value = "${D}{graphql.endpoint${springBeanSuffix}.url}")
	private String graphqlEndpoint${springBeanSuffix}Url;

	@Value("${D}{graphql.endpoint${springBeanSuffix}.subscriptionUrl:${D}{graphql.endpoint${springBeanSuffix}.url}}")
	@Deprecated
	private String graphqlEndpoint${springBeanSuffix}SubscriptionUrl;

	/**
	 * This beans defines the GraphQL endpoint for the current GraphQL schema, as a {@link String}. The <I>application.properties</I> 
	 * must define the GraphQL URL endpoint in the <I>graphql.endpoint${springBeanSuffix}.url</I> property.
	 * 
	 * 
	 * @return Returns the value of the <I>graphql.endpoint${springBeanSuffix}.url</I> application property.
	 * @see https://docs.spring.io/spring-boot/docs/2.3.3.RELEASE/reference/html/spring-boot-features.html#boot-features-external-config
	 */
	@Bean
	@ConditionalOnMissingBean(name = "graphqlEndpoint${springBeanSuffix}")
	String graphqlEndpoint${springBeanSuffix}() {
		return graphqlEndpoint${springBeanSuffix}Url;
	}

	/**
	 * This beans defines the GraphQL endpoint for subscriptions for the ${springBeanSuffix} server, as a {@link String}. If
	 * null, then the {@link #graphqlEndpoint()} url is used, which is the default.
	 * 
	 * @return Returns the value of the <I>graphql.endpoint.subscriptionUrl</I> application property.
	 * @see https://docs.spring.io/spring-boot/docs/2.3.3.RELEASE/reference/html/spring-boot-features.html#boot-features-external-config
	 */
	@Bean
	@ConditionalOnMissingBean(name = "graphqlSubscriptionEndpoint${springBeanSuffix}")
	@Deprecated
	String graphqlSubscriptionEndpoint${springBeanSuffix}() {
		return graphqlEndpoint${springBeanSuffix}SubscriptionUrl;
	}

	/**
	 * The Spring reactive {@link WebClient} that will execute the HTTP requests for GraphQL queries and mutations.<BR/>
	 * This bean is only created if no such bean already exists
	 */
	@Bean
	@ConditionalOnMissingBean(name = "webClient${springBeanSuffix}")
	public WebClient webClient${springBeanSuffix}(String graphqlEndpoint${springBeanSuffix}, //
			@Autowired(required = false) @Qualifier("httpClient${springBeanSuffix}") HttpClient httpClient${springBeanSuffix},
			@Autowired(required = false) @Qualifier("serverOAuth2AuthorizedClientExchangeFilterFunction${springBeanSuffix}") ServerOAuth2AuthorizedClientExchangeFilterFunction serverOAuth2AuthorizedClientExchangeFilterFunction${springBeanSuffix}) {
		return GraphQLConfiguration.getWebClient(graphqlEndpoint${springBeanSuffix}, httpClient${springBeanSuffix}, serverOAuth2AuthorizedClientExchangeFilterFunction${springBeanSuffix});
	}



	/**
	 * The Spring reactive {@link WebSocketClient} web socket client for the ${springBeanSuffix} GraphQL schema, that will
	 * execute HTTP requests to build the web sockets, for GraphQL subscriptions.<BR/>
	 * This is mandatory if the application latter calls subscription. It may be null otherwise.
	 */
	@Bean
	@ConditionalOnMissingBean(name = "webSocketClient${springBeanSuffix}")
	public WebSocketClient webSocketClient${springBeanSuffix}(
			@Autowired(required = false) @Qualifier("httpClient${springBeanSuffix}") HttpClient httpClient${springBeanSuffix}) {
		return GraphQLConfiguration.getWebSocketClient(httpClient${springBeanSuffix});
	}

	@Bean
	@ConditionalOnMissingBean
	OAuthTokenExtractor oAuthTokenExtractor${springBeanSuffix}(
			@Autowired(required = false)
			@Qualifier("serverOAuth2AuthorizedClientExchangeFilterFunction${springBeanSuffix}") 
				ServerOAuth2AuthorizedClientExchangeFilterFunction serverOAuth2AuthorizedClientExchangeFilterFunction${springBeanSuffix}) {
		if (serverOAuth2AuthorizedClientExchangeFilterFunction${springBeanSuffix} == null) 
			return null;
		else
			return new OAuthTokenExtractor(serverOAuth2AuthorizedClientExchangeFilterFunction${springBeanSuffix});
	}

	/**
	 * Creates the {@link RequestExecution} for this schema.
	 * 
	 * @param graphqlEndpoint${springBeanSuffix}
	 * @param graphqlSubscriptionEndpoint${springBeanSuffix}
	 * @param webClient${springBeanSuffix}
	 * @param webSocketClient${springBeanSuffix}
	 * @param serverOAuth2AuthorizedClientExchangeFilterFunction${springBeanSuffix}
	 * @param oAuthTokenExtractor${springBeanSuffix}
	 * @return
	 */
	@Bean
	@ConditionalOnMissingBean(name = "requestExecution${springBeanSuffix}")
	public RequestExecution requestExecution${springBeanSuffix}(String graphqlEndpoint${springBeanSuffix}, //
			@Autowired(required = false) @Qualifier("graphqlSubscriptionEndpoint${springBeanSuffix}") String graphqlSubscriptionEndpoint${springBeanSuffix}, //
			@Autowired(required = false) @Qualifier("webClient${springBeanSuffix}") WebClient webClient${springBeanSuffix}, //
			@Autowired(required = false) @Qualifier("webSocketClient${springBeanSuffix}") WebSocketClient webSocketClient${springBeanSuffix},
			@Autowired(required = false) @Qualifier("serverOAuth2AuthorizedClientExchangeFilterFunction${springBeanSuffix}") ServerOAuth2AuthorizedClientExchangeFilterFunction serverOAuth2AuthorizedClientExchangeFilterFunction${springBeanSuffix},
			@Autowired(required = false) @Qualifier("oAuthTokenExtractor${springBeanSuffix}") OAuthTokenExtractor oAuthTokenExtractor${springBeanSuffix})
	{
		return new RequestExecutionSpringReactiveImpl(graphqlEndpoint${springBeanSuffix}, graphqlSubscriptionEndpoint${springBeanSuffix},
				webClient${springBeanSuffix}, webSocketClient${springBeanSuffix}, serverOAuth2AuthorizedClientExchangeFilterFunction${springBeanSuffix},
				oAuthTokenExtractor${springBeanSuffix});
	}

	/**
	 * Creates the {@link GraphQLConfiguration} for this GraphQL schema
	 * 
	 * @param queryExecutor${springBeanSuffix}
	 * @return
	 */
	@Bean
	@ConditionalOnMissingBean(name = "graphQLConfiguration${springBeanSuffix}")
	GraphQLConfiguration graphQLConfiguration${springBeanSuffix}(RequestExecution requestExecution${springBeanSuffix}) {
		return new GraphQLConfiguration(requestExecution${springBeanSuffix});
	}
}
