##
## Velocity template for the executor of a Query or a Mutation type (client side)
##
## The generated class contains:
## - All the utility classes that allow to prepare and execute the query/mutation
##
##
## This template has these inputs:
## packageUtilName 			The package where this class must be generated
## configuration		The plugin's configuration
## object					The query or mutation type, for which this executor is being generated
##
#################################################################################################################
## Import of common.vm  (commons Velocity macro and definitions)
#################################################################################################################
#parse ("templates/common.vm")
##
##
##
##
##
/** Generated by the default template from graphql-java-generator */
package ${packageUtilName};
##
#################################################################################################################
## The inputParams macto lists the input parameters for a field
#################################################################################################################
#macro(inputParams)
#foreach ($inputParameter in $field.inputParameters)
#appliedDirectives(${inputParameter.appliedDirectives}, "			")
			${inputParameter.javaTypeFullClassname} ${inputParameter.javaName},
#end
#end
##
#################################################################################################################
## The inputValues macro lists the input values for the parameters for a field
#################################################################################################################
#macro(inputValues)#foreach ($inputParameter in $field.inputParameters), ${inputParameter.javaName}#end#end
##
##
##
#if($configuration.generateDeprecatedRequestResponse)
#set ($executionResponse = "${object.name}Response")
#else
#set ($executionResponse = "${configuration.packageName}.${object.classSimpleName}")
#end
##
##

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.graphql.client.GraphQlClient;
import org.springframework.stereotype.Component;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.graphql_java_generator.annotation.GraphQLDirective;
import com.graphql_java_generator.annotation.GraphQLNonScalar;
import com.graphql_java_generator.annotation.GraphQLObjectType;
import com.graphql_java_generator.annotation.GraphQLQuery;
import com.graphql_java_generator.annotation.GraphQLScalar; 
import com.graphql_java_generator.client.GraphqlClientUtils;
import com.graphql_java_generator.client.GraphQLMutationReactiveExecutor;
import com.graphql_java_generator.client.GraphQLObjectMapper;
import com.graphql_java_generator.client.GraphQLQueryReactiveExecutor;
import com.graphql_java_generator.client.request.InputParameter;
import com.graphql_java_generator.client.request.InputParameter.InputParameterType;
import com.graphql_java_generator.client.request.ObjectResponse;
import com.graphql_java_generator.exception.GraphQLRequestExecutionException;
import com.graphql_java_generator.exception.GraphQLRequestPreparationException;
import com.graphql_java_generator.util.GraphqlUtils;

import reactor.core.publisher.Mono;

#foreach($import in ${object.importsForUtilityClasses})
import $import;
#end



/**
#if ($object.description)
#foreach ($line in $object.description.lines)
 * ${line}
#end
 * <BR/>
#end
 * This class contains the methods that allows the execution of the queries or mutations that are defined in the ${object.name} 
 * of the GraphQL schema. All the methods for this executor are in spring reactive, that is: they return a {@link Mono}.<BR/>
 * These methods allows:
 * <UL>
 * <LI>Preparation of full requests</LI>
 * <LI>Execution of prepared full requests</LI>
 * <LI>Execution of direct full direct requests</LI>
 * <LI>Preparation of partial requests</LI>
 * <LI>Execution of prepared partial requests</LI>
 * <LI>Execution of direct partial requests</LI>
 * </UL>
 * You'll find all the documentation on the <A HREF="https://github.com/graphql-java-generator/graphql-maven-plugin-project/wiki/client_spring">client page doc</A>.
 * 
 * @author generated by graphql-java-generator
 */
@Component
@SuppressWarnings("unused")
public class ${object.name}ReactiveExecutor${springBeanSuffix} implements#if($object.requestType=="mutation") GraphQLMutationReactiveExecutor #else GraphQLQueryReactiveExecutor #end{

	/** Logger for this class */
	private static Logger logger = LoggerFactory.getLogger(${object.name}ReactiveExecutor${springBeanSuffix}.class);

	@Autowired
#if ($configuration.queryMutationExecutionProtocol == "http")
	@Qualifier("httpGraphQlClient${springBeanSuffix}")
#else
	@Qualifier("webSocketGraphQlClient${springBeanSuffix}")
#end
	GraphQlClient graphQlClient;
	
	GraphqlUtils graphqlUtils = GraphqlUtils.graphqlUtils; // must be set that way, to be used in the constructor
	
	@Autowired
	GraphqlClientUtils graphqlClientUtils;

	public ${object.name}ReactiveExecutor${springBeanSuffix}() {
## The @..@ is the placeholder for the maven resource filtering
		if (!"2.4".equals(this.graphqlUtils.getRuntimeVersion())) { //$NON-NLS-1$
			throw new RuntimeException("The GraphQL runtime version doesn't match the GraphQL plugin version. The runtime's version is '"  //$NON-NLS-1$
					+ this.graphqlUtils.getRuntimeVersion() 
					+ "' whereas the GraphQL plugin version is '2.4'");  //$NON-NLS-1$
		}
		CustomScalarRegistryInitializer.initCustomScalarRegistry();
		DirectiveRegistryInitializer.initDirectiveRegistry();
	}

	/**
	 * This method takes a <B>full request</B> definition, and executes it against the GraphQL server. As this class is 
	 * a ${object.requestType} executor, the provided request must be a ${object.requestType} full request. This request
	 * will be executed in reactive mode, that is: it returns a {@link Mono}<$executionResponse><BR/>
	 * This method offers a logging of the call (if in debug mode), or of the call and its parameters (if in trace mode).<BR/>
	 * Here is a sample on how to use it:
	 * 
	 * <PRE>
	 * @Component // This class must be a spring component
	 * public class MyClass {
	 * 
	 *     @Autowired
	 *     ${object.name}Executor${springBeanSuffix} executor;
	 * 
	 *     void myMethod() {
	 * 	        Map<String, Object> params = new HashMap<>();
	 *          params.put("param", paramValue);   // param is optional, as it is marked by a "?" in the request
	 *          params.put("skip", Boolean.FALSE); // skip is mandatory, as it is marked by a "&" in the request
	 *          
	 *          Mono<${object.classSimpleName}> mono = executor.execWithBindValues(
	 *              "${object.requestType} { sampleQueryOrMutationField(param: ?param)  {subfield1 @skip(if: &skip) subfield2 {id name}}}",
	 *              callback,
	 *              params);
	 *          ${object.classSimpleName} ${object.requestType} = mono.block();
	 *          FieldType field = ${object.requestType}.getSampleQueryOrMutationField();
	 *
	 *          .... do something with this field's value
	 *     }
	 * }
	 * 
	 * 
	 * 
	 * Map<String, Object> params = new HashMap<>();
	 * params.put("heroParam", heroParamValue);
	 * params.put("skip", Boolean.FALSE);
	 * 
	 * Mono<$executionResponse> mono = myQueryType.execWithBindValues(
	 * 		"{hero(param:?heroParam) @include(if:true) {id name @skip(if: ?skip) appearsIn friends {id name}}}",
	 * 		params);
	 * ...
	 * $executionResponse response = mono.block();
	 * Character c = response.getHero();
	 * </PRE>
	 * 
	 * @param queryResponseDef
	 *            The response definition of the ${object.requestType}, in the native GraphQL format (see here above). It must ommit the
	 *            query/mutation/subscription keyword, and start by the first { that follows.It may contain directives,
	 *            as explained in the GraphQL specs.
	 * @param parameters
	 *            The map of values, for the bind variables defined in the query. If there is no bind variable in the
	 *            defined Query, this argument may be null or an empty {@link Map}. The key is the parameter name, as
	 *            defined in the query (in the above sample: heroParam is an optional parameter and skip is a mandatory
	 *            one). The value is the parameter vale in its Java type (for instance a {@link Date} for the
	 *            {@link GraphQLScalarTypeDate}). The parameters which value is missing in this map will no be
	 *            transmitted toward the GraphQL server.
	 * @throws GraphQLRequestPreparationException
	 *             When an error occurs during the request preparation, typically when building the
	 *             {@link ObjectResponse}
	 * @throws GraphQLRequestExecutionException
	 *             When an error occurs during the request execution, typically a network error, an error from the
	 *             GraphQL server or if the server response can't be parsed
	 */
	public Mono<$executionResponse> execWithBindValues(String queryResponseDef, Map<String, Object> parameters)
			throws GraphQLRequestExecutionException, GraphQLRequestPreparationException {
		logger.debug("Executing ${object.requestType} {} ", queryResponseDef);  //$NON-NLS-1$
		ObjectResponse objectResponse = getResponseBuilder().withQueryResponseDef(queryResponseDef).build();
		return execWithBindValues(objectResponse, parameters);
	}

	/**
	 * This method takes a <B>full request</B> definition, and executes it against the GraphQL server. As this class is 
	 * a ${object.requestType} executor, the provided request must be a ${object.requestType} full request. This request
	 * will be executed in reactive mode, that is: it returns a {@link Mono}<$executionResponse><BR/>
	 * This method offers a logging of the call (if in debug mode), or of the call and its parameters (if in trace mode).<BR/>
	 * Here is a sample on how to use it:
	 * 
	 * <PRE>
	 * @Component // This class must be a spring component
	 * public class MyClass {
	 * 
	 *     @Autowired
	 *     ${object.name}Executor${springBeanSuffix} executor;
	 * 
	 *     void myMethod() {
	 *          Mono<${object.classSimpleName}> mono = executor.exec(
	 *              "${object.requestType} { sampleQueryOrMutationField(param: ?param)  {subfield1 @skip(if: &skip) subfield2 {id name}}}",
	 *              "param", paramValue,   // param is optional, as it is marked by a "?" in the request
	 *              "skip", Boolean.FALSE // skip is mandatory, as it is marked by a "&" in the request
	 *              );
	 *          ${object.classSimpleName} ${object.requestType} = mono.block();
	 *          FieldType field = ${object.requestType}.getSampleQueryOrMutationField();
	 *
	 *          .... do something with this field's value
	 *     }
	 * }
	 * </PRE>
	 * 
	 * @param queryResponseDef
	 *            The response definition of the query, in the native GraphQL format (see here above). It must ommit the
	 *            query/mutation/subscription keyword, and start by the first { that follows.It may contain directives,
	 *            as explained in the GraphQL specs.
	 * @param paramsAndValues
	 *            This parameter contains all the name and values for the Bind Variables defined in the objectResponse
	 *            parameter, that must be sent to the server. Optional parameter may not have a value. They will be
	 *            ignored and not sent to the server. Mandatory parameter must be provided in this argument.<BR/>
	 *            This parameter contains an even number of parameters: it must be a series of name and values :
	 *            (paramName1, paramValue1, paramName2, paramValue2...)
	 * @throws GraphQLRequestPreparationException
	 *             When an error occurs during the request preparation, typically when building the
	 *             {@link ObjectResponse}
	 * @throws GraphQLRequestExecutionException
	 *             When an error occurs during the request execution, typically a network error, an error from the
	 *             GraphQL server or if the server response can't be parsed
	 */
	public Mono<$executionResponse> exec(String queryResponseDef, Object... paramsAndValues)
			throws GraphQLRequestExecutionException, GraphQLRequestPreparationException {
		logger.debug("Executing ${object.requestType} {} ", queryResponseDef);  //$NON-NLS-1$
		ObjectResponse objectResponse = getResponseBuilder().withQueryResponseDef(queryResponseDef).build();
		return execWithBindValues(objectResponse, this.graphqlClientUtils.generatesBindVariableValuesMap(paramsAndValues));
	}

	/**
	 * This method takes a <B>full request</B> definition, and executes it against the GraphQL server. As this class is 
	 * a ${object.requestType} executor, the provided request must be a ${object.requestType} full request. This request
	 * will be executed in reactive mode, that is: it returns a {@link Mono}<$executionResponse><BR/>
	 * This method offers a logging of the call (if in debug mode), or of the call and its parameters (if in trace mode).<BR/>
	 * Here is a sample on how to use it:
	 * 
	 * <PRE>
	 * @Component // This class must be a spring component
	 * public class MyClass {
	 * 
	 *     @Autowired
	 *     ${object.name}Executor${springBeanSuffix} executor;
	 *     
	 *     GraphQLRequest${springBeanSuffix} preparedRequest;
	 *     
	 *     @PostConstruct
	 *     public void setup() {
	 *         // Preparation of the query, so that it is prepared once then executed several times
	 *         preparedRequest = executor
	 *             .getResponseBuilder()
	 *             .withQueryResponseDef("${object.requestType} { sampleQueryOrMutationField(param: ?param)  {subfield1 @skip(if: &skip) subfield2 {id name}}}")
	 *             .build();
	 *     }
	 * 
	 *     void myMethod() {
	 * 	        Map<String, Object> params = new HashMap<>();
	 *          params.put("param", paramValue);   // param is optional, as it is marked by a "?" in the request
	 *          params.put("skip", Boolean.FALSE); // skip is mandatory, as it is marked by a "&" in the request
	 *          
	 *          Mono<${object.classSimpleName}> mono = executor.execWithBindValues(
	 *              preparedRequest,
	 *              params);
	 *          ${object.classSimpleName} ${object.requestType} = mono.block();
	 *          FieldType field = ${object.requestType}.getSampleQueryOrMutationField();
	 *
	 *          .... do something with this field's value
	 *     }
	 * }
	 * </PRE>
	 * 
	 * @param objectResponse
	 *            The definition of the response format, that describes what the GraphQL server is expected to return<br/>
	 *            Note: the <code>ObjectResponse</code> type of this parameter is defined for backward compatibility. In new implementations,
	 *            the expected type is the generated GraphQLRequest${springBeanSuffix} POJO, as returned by the
	 *            {@link getGraphQLRequest(String)} method or one of the <code>getXxxxGraphQLRequest(String)</code> methods.
	 * @param parameters
	 *            The list of values, for the bind variables defined in the query. If there is no bind variable in the
	 *            defined Query, this argument may be null or an empty {@link Map}
	 * @throws GraphQLRequestExecutionException
	 *             When an error occurs during the request execution, typically a network error, an error from the
	 *             GraphQL server or if the server response can't be parsed
	 */
	@SuppressWarnings("static-method")
	public Mono<$executionResponse> execWithBindValues(ObjectResponse objectResponse, Map<String, Object> parameters)
			throws GraphQLRequestExecutionException {
		if (logger.isTraceEnabled()) {
			if (parameters == null) {
				logger.trace("Executing ${object.requestType} without parameters");  //$NON-NLS-1$
			} else {
				StringBuilder sb = new StringBuilder("Executing root ${object.requestType} with parameters: ");  //$NON-NLS-1$
				boolean addComma = false;
				for (String key : parameters.keySet()) {
					sb.append(key).append(":").append(parameters.get(key));  //$NON-NLS-1$
					if (addComma)
						sb.append(", ");  //$NON-NLS-1$
					addComma = true;
				}
				logger.trace(sb.toString());
			}
		} else if (logger.isDebugEnabled()) {
			logger.debug("Executing ${object.requestType} '${object.name}'");  //$NON-NLS-1$
		}

		return objectResponse.execReactive(${executionResponse}.class, (parameters != null) ? parameters : new HashMap<>());
	}

	/**
	 * This method takes a <B>full request</B> definition, and executes it against the GraphQL server. As this class is 
	 * a ${object.requestType} executor, the provided request must be a ${object.requestType} full request. This request
	 * will be executed in reactive mode, that is: it returns a {@link Mono}<$executionResponse><BR/>
	 * This method offers a logging of the call (if in debug mode), or of the call and its parameters (if in trace mode).<BR/>
	 * Here is a sample on how to use it:
	 * 
	 * <PRE>
	 * @Component // This class must be a spring component
	 * public class MyClass {
	 * 
	 *     @Autowired
	 *     ${object.name}Executor${springBeanSuffix} executor;
	 *     
	 *     GraphQLRequest${springBeanSuffix} preparedRequest;
	 *     
	 *     @PostConstruct
	 *     public void setup() {
	 *         // Preparation of the query, so that it is prepared once then executed several times
	 *         preparedRequest = executor
	 *             .getResponseBuilder()
	 *             .withQueryResponseDef("${object.requestType} { sampleQueryOrMutationField(param: ?param)  {subfield1 @skip(if: &skip) subfield2 {id name}}}")
	 *             .build();
	 *     }
	 * 
	 *     void myMethod() {
	 *          Mono<${object.classSimpleName}> mono = executor.exec(
	 *              preparedRequest,
	 *              "param", paramValue,   // param is optional, as it is marked by a "?" in the request
	 *              "skip", Boolean.FALSE // skip is mandatory, as it is marked by a "&" in the request
	 *              );
	 *          ${object.classSimpleName} ${object.requestType} = mono.block();
	 *          FieldType field = ${object.requestType}.getSampleQueryOrMutationField();
	 *
	 *          .... do something with this field's value
	 *     }
	 * }
	 * </PRE>
	 * 
	 * @param objectResponse
	 *            The definition of the response format, that describes what the GraphQL server is expected to return<br/>
	 *            Note: the <code>ObjectResponse</code> type of this parameter is defined for backward compatibility. In new implementations,
	 *            the expected type is the generated GraphQLRequest${springBeanSuffix} POJO, as returned by the
	 *            {@link getGraphQLRequest(String)} method or one of the <code>getXxxxGraphQLRequest(String)</code> methods.
	 * @param paramsAndValues
	 *            This parameter contains all the name and values for the Bind Variables defined in the objectResponse
	 *            parameter, that must be sent to the server. Optional parameter may not have a value. They will be
	 *            ignored and not sent to the server. Mandatory parameter must be provided in this argument.<BR/>
	 *            This parameter contains an even number of parameters: it must be a series of name and values :
	 *            (paramName1, paramValue1, paramName2, paramValue2...)
	 * @throws GraphQLRequestExecutionException
	 *             When an error occurs during the request execution, typically a network error, an error from the
	 *             GraphQL server or if the server response can't be parsed
	 */
	public Mono<$executionResponse> exec(ObjectResponse objectResponse, Object... paramsAndValues)
			throws GraphQLRequestExecutionException {
		return execWithBindValues(objectResponse, this.graphqlClientUtils.generatesBindVariableValuesMap(paramsAndValues));
	}

	/**
	 * Get the {@link com.graphql_java_generator.client.request.Builder} for a <B>full request</B>, as expected by the exec 
	 * and execWithBindValues methods.
	 * 
	 * @return
	 * @throws GraphQLRequestPreparationException
	 */
	public com.graphql_java_generator.client.request.Builder getResponseBuilder() throws GraphQLRequestPreparationException {
		return new com.graphql_java_generator.client.request.Builder(this.graphQlClient, GraphQLReactiveRequest${springBeanSuffix}.class);
	}

	/**
	 * Get the {@link GraphQLReactiveRequest${springBeanSuffix}} for <B>full request</B>. For instance:
	 * <PRE>
	 * GraphQLReactiveRequest${springBeanSuffix} request = new GraphQLRequest(fullRequest);
	 * </PRE>
	 * 
	 * @param fullRequest The full GraphQL Request, as specified in the GraphQL specification
	 * @return
	 * @throws GraphQLRequestPreparationException
	 */
	@SuppressWarnings("static-method")
	public GraphQLReactiveRequest${springBeanSuffix} getGraphQLRequest(String fullRequest) throws GraphQLRequestPreparationException {
		return new GraphQLReactiveRequest${springBeanSuffix}(fullRequest);
	}

#foreach ($field in $object.fields)
##
##
##
##
##
#foreach ($comment in $field.comments)
	// $comment
#end
	/**
#foreach ($line in $field.description.lines)
	  * $line
#end
	 *
	 * This method executes a partial query against the GraphQL server. That is, the query that is one of the queries
	 * defined in the GraphQL query object. The queryResponseDef contains the part of the query that <B><U>is
	 * after</U></B> the query name.<BR/>
	 * For instance, if the query hero has one parameter (as defined in the GraphQL schema):
	 * 
	 * <PRE>
	 * @Component // This class must be a spring component
	 * public class MyClass {
	 * 
	 *     @Autowired
	 *     ${object.name}Executor${springBeanSuffix} executor;
	 * 
	 *     void myMethod() {
#if (! ${object.type.scalar})
	 * 	        Map<String, Object> params = new HashMap<>();
	 *          params.put("param", paramValue);   // param is optional, as it is marked by a "?" in the request
	 *          params.put("skip", Boolean.FALSE); // skip is mandatory, as it is marked by a "&" in the request
	 *          
#end
	 *          Mono<${field.javaType}> mono = executor.${field.javaName}WithBindValues(
#if (${object.type.scalar})
	 *              // The partial query must be empty for scalars
	 *              "",
#foreach ($inputParameter in $field.inputParameters)
	 *              ${inputParameter.name}, // A value for ${field.name}'s ${inputParameter.name} input parameter
#end
	 *              null // There can be no bind variables in the query for scalars
	 *              );
#else
	 *              "{subfield1 @aDirectiveToDemonstrateBindVariables(if: &skip, param: ?param) subfield2 {id name}}",
#foreach ($inputParameter in $field.inputParameters)
	 *              ${inputParameter.name}, // A value for ${field.name}'s ${inputParameter.name} input parameter
#end
	 *              params);
#end
	 *          ${field.javaType} field = mono.block();
	 *     }
	 * }
	 * </PRE>
	 * 
	 * It offers a logging of the call (if in debug mode), or of the call and its parameters (if in trace mode).<BR/>
	 * This method takes care of writing the query/mutation name, and the parameter(s) for the query/mutation. The given queryResponseDef
	 * describes the format of the response of the server response, that is the expected fields of the {@link Character}
	 * GraphQL type. It can be something like "{ id name }", if you want these fields of this type. Please take a look
	 * at the StarWars, Forum and other samples for more complex queries.<BR/>
	 * This method is valid for queries/mutations/subscriptions which don't have bind variables, as there is no
	 * <I>parameters</I> argument to pass the list of values.<BR/>
#if($graphqlUtils.isJavaReservedWords(${field.name}))
	 * This method name is prefixed by ${underscore}, as ${field.name} is a java reserved keyword. 
#end
	 * 
	 * @param queryResponseDef
	 *            The response definition of the query, in the native GraphQL format (see here above)
#foreach ($inputParameter in $field.inputParameters)
#if (${inputParameter.description} && ${inputParameter.description.getContent()} != "")
	* @param ${inputParameter.name} ${inputParameter.description.getContent()}
#else
	* @param ${inputParameter.name} Parameter for the ${field.name} field of ${object.name}, as defined in the GraphQL schema
#end
#end
	 * @param parameters
	 *            The list of values, for the bind variables defined in the query/mutation. If there is no bind variable in the
	 *            defined query/mutation, this argument may be null or an empty {@link Map}
	 * @throws GraphQLRequestPreparationException
	 *             When an error occurs during the request preparation, typically when building the
	 *             {@link ObjectResponse}
	 * @throws GraphQLRequestExecutionException
	 *             When an error occurs during the request execution, typically a network error, an error from the
	 *             GraphQL server or if the server response can't be parsed
	 */
## Note: we must use the ${query.type.classSimpleName}, as when the GraphQL schema uses request that return the query type, and 
## the query type object is in a separate package (plugin parameter separateUtilityClasses), then there is a conflict between 
## the current name and the query type object: they have the same name, but are in different packages 
#if(${field.type.scalar})	@GraphQLScalar#else	@GraphQLNonScalar#end(fieldName = "${field.name}", graphQLTypeSimpleName = "${field.graphQLTypeSimpleName}", javaClass = ${field.type.classFullName}.class)
#appliedDirectives(${field.appliedDirectives}, "	")
	public Mono<Optional<${field.javaTypeFullClassname}>> ${field.javaName}WithBindValues(
			String queryResponseDef,
#inputParams()
			Map<String, Object> parameters)
			throws GraphQLRequestExecutionException, GraphQLRequestPreparationException {
		logger.debug("Executing ${object.requestType} '${field.name}': {} ", queryResponseDef); //$NON-NLS-1$
		ObjectResponse objectResponse = get${field.pascalCaseName}ResponseBuilder().withQueryResponseDef(queryResponseDef).build();
		return ${field.javaName}WithBindValues(objectResponse#inputValues(), parameters);
	}

#foreach ($comment in $field.comments)
	// $comment
#end
	/**
#foreach ($line in $field.description.lines)
	 * $line<br/>
#end
	 *
	 * This method executes a partial query against the GraphQL server. That is, the query that is one of the queries
	 * defined in the GraphQL query object. The queryResponseDef contains the part of the query that <B><U>is
	 * after</U></B> the query name.<BR/>
	 * For instance, if the query hero has one parameter (as defined in the GraphQL schema):
	 * 
	 * <PRE>
	 * @Component // This class must be a spring component
	 * public class MyClass {
	 * 
	 *     @Autowired
	 *     ${object.name}Executor${springBeanSuffix} executor;
	 * 
	 *     void myMethod() {
	 *          Mono<${field.javaType}> mono = executor.${field.javaName}(
#if (${object.type.scalar})
	 *              
	 *              "" // The partial query must be empty for scalars
#foreach ($inputParameter in $field.inputParameters)
	 *              ${inputParameter.name}#if($foreach.hasNext), #end // A value for ${field.name}'s ${inputParameter.name} input parameter
#end
	 *              );
#else
	 *              "{subfield1 @aDirectiveToDemonstrateBindVariables(if: &skip, param: ?param) subfield2 {id name}}",
#foreach ($inputParameter in $field.inputParameters)
	 *              ${inputParameter.name}, // A value for ${field.name}'s ${inputParameter.name} input parameter
#end
	 *             "param", paramValue,   // param is optional, as it is marked by a "?" in the request
	 *             "skip", Boolean.FALSE // skip is mandatory, as it is marked by a "&" in the request
	 *              );
#end
	 *          ${field.javaType} field = mono.block();
	 *     }
	 * }
	 * </PRE>
	 * 
	 * It offers a logging of the call (if in debug mode), or of the call and its parameters (if in trace mode).<BR/>
	 * This method takes care of writing the query/mutation name, and the parameter(s) for the query/mutation	. The given queryResponseDef
	 * describes the format of the response of the server response, that is the expected fields of the {@link Character}
	 * GraphQL type. It can be something like "{ id name }", if you want these fields of this type. Please take a look
	 * at the StarWars, Forum and other samples for more complex queries.<BR/>
	 * This method is valid for queries/mutations/subscriptions which don't have bind variables, as there is no
	 * <I>parameters</I> argument to pass the list of values.<BR/>
#if($graphqlUtils.isJavaReservedWords(${field.name}))
	 * This method name is prefixed by ${underscore}, as ${field.name} is a java reserved keyword. 
#end
	 * 
	 * @param queryResponseDef
	 *            The response definition of the query/mutation, in the native GraphQL format (see here above)
#foreach ($inputParameter in $field.inputParameters)
#if (${inputParameter.description} && ${inputParameter.description.getContent()} != "")
	* @param ${inputParameter.name} ${inputParameter.description.getContent()}
#else
	* @param ${inputParameter.name} Parameter for the ${field.name} field of ${object.name}, as defined in the GraphQL schema
#end
#end
	 * @param parameters
	 *            The list of values, for the bind variables defined in the query/mutation. If there is no bind variable in the
	 *            defined query/mutation, this argument may be null or an empty {@link Map}
	 * @throws GraphQLRequestPreparationException
	 *             When an error occurs during the request preparation, typically when building the
	 *             {@link ObjectResponse}
	 * @throws GraphQLRequestExecutionException
	 *             When an error occurs during the request execution, typically a network error, an error from the
	 *             GraphQL server or if the server response can't be parsed
	 */
## Note: we must use the ${query.type.classSimpleName}, as when the GraphQL schema uses request that return the query type, and 
## the query type object is in a separate package (plugin parameter separateUtilityClasses), then there is a conflict between 
## the current name and the query type object: they have the same name, but are in different packages 	#if(${field.type.scalar}) @GraphQLScalar #else @GraphQLNonScalar #end(fieldName = "${field.name}", graphQLTypeSimpleName = "${field.graphQLTypeSimpleName}", javaClass = ${field.type.classFullName}.class)
#if(${field.type.scalar})	@GraphQLScalar#else	@GraphQLNonScalar#end(fieldName = "${field.name}", graphQLTypeSimpleName = "${field.graphQLTypeSimpleName}", javaClass = ${field.type.classFullName}.class)
#appliedDirectives(${field.appliedDirectives}, "	")
	public Mono<Optional<${field.javaTypeFullClassname}>> ${field.javaName}(
			String queryResponseDef,
#inputParams()
			Object... paramsAndValues)
			throws GraphQLRequestExecutionException, GraphQLRequestPreparationException {
		logger.debug("Executing ${object.requestType} '${field.name}': {} ", queryResponseDef); //$NON-NLS-1$
		ObjectResponse objectResponse = get${field.pascalCaseName}ResponseBuilder().withQueryResponseDef(queryResponseDef).build();
		return ${field.javaName}WithBindValues(objectResponse#inputValues(), this.graphqlClientUtils.generatesBindVariableValuesMap(paramsAndValues));
	}

#foreach ($comment in $field.comments)
	// $comment
#end
	/**
#foreach ($line in $field.description.lines)
	 * $line<br/>
#end
	 *
	 * This method is expected by the graphql-java framework. It will be called when this query is called. It offers a
	 * logging of the call (if in debug mode), or of the call and its parameters (if in trace mode).<BR/>
	 * This method is valid for queries/mutations/subscriptions which don't have bind variables, as there is no
	 * <I>parameters</I> argument to pass the list of values.<BR/>
	 * Here is a sample:
	 * 
	 * <PRE>
	 * @Component // This class must be a spring component
	 * public class MyClass {
	 * 
	 *     @Autowired
	 *     ${object.name}Executor${springBeanSuffix} executor;
	 *     
	 *     GraphQLRequest${springBeanSuffix} preparedRequest;
	 *     
	 *     @PostConstruct
	 *     public void setup() {
	 *         // Preparation of the query, so that it is prepared once then executed several times
	 *         preparedRequest = executor.
#if (${object.type.scalar})
	 *             get${field.pascalCaseName}GraphQLRequest(""); // The request string must be an empty string for scalar fields 
#else
	 *             get${field.pascalCaseName}GraphQLRequest("${object.requestType} { sampleQueryOrMutationField(param: ?param)  {subfield1 @skip(if: &skip) subfield2 {id name}}}");
#end
	 *     }
	 * 
	 *     void myMethod() {
	 *          Mono<${field.javaType}> mono = executor.${field.javaName}WithBindValues(
	 *              preparedRequest,
#foreach ($inputParameter in $field.inputParameters)
	 *              ${inputParameter.name}, // A value for ${field.name}'s ${inputParameter.name} input parameter
#end
#if (${object.type.scalar})
	 *              
	 *              null // A scalar partial request can not have bind variables 
	 *              );
#else
	 *              params);
#end
	 *          ${field.javaType} field = mono.block();
	 *     }
	 * }
	 * </PRE>
#if($graphqlUtils.isJavaReservedWords(${field.name}))
	 * This method name is prefixed by ${underscore}, as ${field.name} is a java reserved keyword. 
#end
	 * 
	 * @param objectResponse
	 *            The definition of the response format, that describes what the GraphQL server is expected to return<br/>
	 *            Note: the <code>ObjectResponse</code> type of this parameter is defined for backward compatibility. In new implementations,
	 *            the expected type is the generated GraphQLRequest${springBeanSuffix} POJO, as returned by the
	 *            {@link get${field.pascalCaseName}GraphQLRequest(String)} method.
#foreach ($inputParameter in $field.inputParameters)
#if (${inputParameter.description} && ${inputParameter.description.getContent()} != "")
	* @param ${inputParameter.name} ${inputParameter.description.getContent()}
#else
	* @param ${inputParameter.name} Parameter for the ${field.name} field of ${object.name}, as defined in the GraphQL schema
#end
#end
	 * @param parameters
	 *            The list of values, for the bind variables defined in the query/mutation. If there is no bind variable in the
	 *            defined query/mutation, this argument may be null or an empty {@link Map}
	 * @throws GraphQLRequestExecutionException
	 *             When an error occurs during the request execution, typically a network error, an error from the
	 *             GraphQL server or if the server response can't be parsed
	 */
## Note: we must use the ${query.type.classSimpleName}, as when the GraphQL schema uses request that return the query type, and 
## the query type object is in a separate package (plugin parameter separateUtilityClasses), then there is a conflict between 
## the current name and the query type object: they have the same name, but are in different packages 	#if(${field.type.scalar}) @GraphQLScalar #else @GraphQLNonScalar #end(fieldName = "${field.name}", graphQLTypeSimpleName = "${field.graphQLTypeSimpleName}", javaClass = ${field.type.classFullName}.class)
#if(${field.type.scalar})	@GraphQLScalar#else	@GraphQLNonScalar#end(fieldName = "${field.name}", graphQLTypeSimpleName = "${field.graphQLTypeSimpleName}", javaClass = ${field.type.classFullName}.class)
#appliedDirectives(${field.appliedDirectives}, "	")
	@SuppressWarnings("static-method")
	public Mono<Optional<${field.javaTypeFullClassname}>> ${field.javaName}WithBindValues(
			ObjectResponse objectResponse,
#inputParams()
			Map<String, Object> parameters)
			throws GraphQLRequestExecutionException  {
		if (logger.isTraceEnabled()) {
			logger.trace("Executing ${object.requestType} '${field.name}' with parameters: #foreach ($inputParameter in $field.inputParameters){}#if($foreach.hasNext),#end #end"#foreach ($inputParameter in $field.inputParameters), ${inputParameter.javaName}#end); //$NON-NLS-1$
		} else if (logger.isDebugEnabled()) {
			logger.debug("Executing ${object.requestType} '${field.name}'"); //$NON-NLS-1$
		}
	
		// Given values for the BindVariables
		Map<String, Object> parametersLocal = (parameters != null) ? parameters : new HashMap<>();
#foreach ($inputParameter in $field.inputParameters)
parametersLocal.put("${object.camelCaseName}${field.pascalCaseName}${inputParameter.pascalCaseName}", ${inputParameter.javaName}); //$NON-NLS-1$
#end

#if(${configuration.separateUtilityClasses})
		return objectResponse //
			.execReactive(#if(${configuration.separateUtilityClasses})${configuration.packageName}.#end${field.owningType.classSimpleName}.class, parametersLocal) //
#else
		return objectResponse//
			.execReactive(${field.owningType.classSimpleName}.class, parametersLocal) //
#end
			.map(t -> (t.get${field.pascalCaseName}() == null) ? Optional.empty() : Optional.of(t.get${field.pascalCaseName}()));
	}

#foreach ($comment in $field.comments)
	// $comment
#end
	/**
#foreach ($line in $field.description.lines)
	 * $line<br/>
#end
	 *
	 * This method is expected by the graphql-java framework. It will be called when this query is called. It offers a
	 * logging of the call (if in debug mode), or of the call and its parameters (if in trace mode).<BR/>
	 * This method is valid for queries/mutations/subscriptions which don't have bind variables, as there is no
	 * <I>parameters</I> argument to pass the list of values.<BR/>
	 * Here is a sample:
	 * 
	 * <PRE>
	 * @Component // This class must be a spring component
	 * public class MyClass {
	 * 
	 *     @Autowired
	 *     ${object.name}Executor${springBeanSuffix} executor;
	 *     
	 *     GraphQLRequest${springBeanSuffix} preparedRequest;
	 *     
	 *     @PostConstruct
	 *     public void setup() {
	 *         // Preparation of the query, so that it is prepared once then executed several times
	 *         preparedRequest = executor.
#if (${object.type.scalar})
	 *             get${field.pascalCaseName}GraphQLRequest(""); // The request string must be an empty string for scalar fields 
#else
	 *             get${field.pascalCaseName}GraphQLRequest("${object.requestType} { sampleQueryOrMutationField(param: ?param)  {subfield1 @skip(if: &skip) subfield2 {id name}}}");
#end
	 *     }
	 * 
	 *     void myMethod() {
	 *          Mono<${field.javaType}> mono = executor.${field.javaName}(
	 *              preparedRequest,
#if (${object.type.scalar})
#foreach ($inputParameter in $field.inputParameters)
	 *              ${inputParameter.name}#if($foreach.hasNext), #end // A value for ${field.name}'s ${inputParameter.name} input parameter
#end
	 *              );
#else
#foreach ($inputParameter in $field.inputParameters)
	 *              ${inputParameter.name}, // A value for ${field.name}'s ${inputParameter.name} input parameter
#end
	 *              "param", paramValue,   // param is optional, as it is marked by a "?" in the request
	 *              "skip", Boolean.FALSE // skip is mandatory, as it is marked by a "&" in the request
	 *              );
#end
	 *          ${field.javaType} field = mono.block();
	 *     }
	 * }
	 * </PRE>
#if($graphqlUtils.isJavaReservedWords(${field.name}))
	 * This method name is prefixed by ${underscore}, as ${field.name} is a java reserved keyword. 
#end
	 * 
	 * @param objectResponse
	 *            The definition of the response format, that describes what the GraphQL server is expected to return<br/>
	 *            Note: the <code>ObjectResponse</code> type of this parameter is defined for backward compatibility. In new implementations,
	 *            the expected type is the generated GraphQLRequest${springBeanSuffix} POJO, as returned by the
	 *            {@link get${field.pascalCaseName}GraphQLRequest(String)} method.
#foreach ($inputParameter in $field.inputParameters)
#if (${inputParameter.description} && ${inputParameter.description.getContent()} != "")
	* @param ${inputParameter.name} ${inputParameter.description.getContent()}
#else
	* @param ${inputParameter.name} Parameter for the ${field.name} field of ${object.name}, as defined in the GraphQL schema
#end
#end
	 * @param paramsAndValues
	 *            This parameter contains all the name and values for the Bind Variables defined in the objectResponse
	 *            parameter, that must be sent to the server. Optional parameter may not have a value. They will be
	 *            ignored and not sent to the server. Mandatory parameter must be provided in this argument.<BR/>
	 *            This parameter contains an even number of parameters: it must be a series of name and values :
	 *            (paramName1, paramValue1, paramName2, paramValue2...)
	 * @throws GraphQLRequestExecutionException
	 *             When an error occurs during the request execution, typically a network error, an error from the
	 *             GraphQL server or if the server response can't be parsed
	 */
## Note: we must use the ${query.type.classSimpleName}, as when the GraphQL schema uses request that return the query type, and 
## the query type object is in a separate package (plugin parameter separateUtilityClasses), then there is a conflict between 
## the current name and the query type object: they have the same name, but are in different packages 	#if(${field.type.scalar}) @GraphQLScalar #else @GraphQLNonScalar #end(fieldName = "${field.name}", graphQLTypeSimpleName = "${field.graphQLTypeSimpleName}", javaClass = ${field.type.classFullName}.class)
#if(${field.type.scalar})	@GraphQLScalar#else	@GraphQLNonScalar#end(fieldName = "${field.name}", graphQLTypeSimpleName = "${field.graphQLTypeSimpleName}", javaClass = ${field.type.classFullName}.class)
#appliedDirectives(${field.appliedDirectives}, "	")
	public Mono<Optional<${field.javaTypeFullClassname}>> ${field.javaName}(
			ObjectResponse objectResponse,
#inputParams()
			Object... paramsAndValues)
			throws GraphQLRequestExecutionException  {
		if (logger.isTraceEnabled()) {
			StringBuilder sb = new StringBuilder();
			sb.append("Executing ${object.requestType} '${field.name}' with bind variables: "); //$NON-NLS-1$
			boolean addComma = false;
			for (Object o : paramsAndValues) {
				if (o != null) {
					sb.append(o.toString());
					if (addComma)
						sb.append(", "); //$NON-NLS-1$
					addComma = true;
				}
			}
			logger.trace(sb.toString());
		} else if (logger.isDebugEnabled()) {
			logger.debug("Executing ${object.requestType} '${field.name}' (with bind variables)"); //$NON-NLS-1$ 
		}

		Map<String, Object> parameters = this.graphqlClientUtils.generatesBindVariableValuesMap(paramsAndValues);
#foreach ($inputParameter in $field.inputParameters)
		parameters.put("${object.camelCaseName}${field.pascalCaseName}${inputParameter.pascalCaseName}", ${inputParameter.javaName}); //$NON-NLS-1$
#end
		
#if (${configuration.separateUtilityClasses})
		return objectResponse //
			.execReactive(#if(${configuration.separateUtilityClasses})${configuration.packageName}.#end${field.owningType.classSimpleName}.class, parameters) // 
#else
		return objectResponse //
			.execReactive(${field.owningType.classSimpleName}.class, parameters) //
#end
			.map(t -> (t.get${field.pascalCaseName}() == null) ? Optional.empty() : Optional.of(t.get${field.pascalCaseName}()));
	}

#foreach ($comment in $field.comments)
	// $comment
#end
	/**
#foreach ($line in $field.description.lines)
	 * $line<br/>
#end
	 *
	 * Get the {@link com.graphql_java_generator.client.request.Builder} for the ${field.type.classSimpleName}, as expected by the ${field.name} query/mutation.
	 * 
	 * @return
	 * @throws GraphQLRequestPreparationException
	 */
	public com.graphql_java_generator.client.request.Builder get${field.pascalCaseName}ResponseBuilder() throws GraphQLRequestPreparationException {
		return new com.graphql_java_generator.client.request.Builder(this.graphQlClient, GraphQLReactiveRequest${springBeanSuffix}.class, "${field.name}", RequestType.${object.requestType} //$NON-NLS-1$
#foreach ($inputParameter in $field.inputParameters)
			, InputParameter.newBindParameter("$springBeanSuffix", "${inputParameter.name}","${object.camelCaseName}${field.pascalCaseName}${inputParameter.pascalCaseName}",#if(${inputParameter.fieldTypeAST.mandatory}) InputParameterType.MANDATORY#else InputParameterType.OPTIONAL#end, "${inputParameter.graphQLTypeSimpleName}", ${inputParameter.fieldTypeAST.mandatory}, ${inputParameter.fieldTypeAST.listDepth}, ${inputParameter.fieldTypeAST.itemMandatory}) //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
#end
			);
	}


#foreach ($comment in $field.comments)
	// $comment
#end
	/**
#foreach ($line in $field.description.lines)
	 * $line<br/>
#end
	 * Get the {@link GraphQLReactiveRequest${springBeanSuffix}} for the ${field.name} $type, created with the given Partial request.
	 * 
	 * @param partialRequest
	 * 				The Partial GraphQL request, as explained in the 
	 * 				<A HREF="https://graphql-maven-plugin-project.graphql-java-generator.com/client.html">plugin client documentation</A> 
	 * @return
	 * @throws GraphQLRequestPreparationException
	 */
	public GraphQLReactiveRequest${springBeanSuffix} get${field.pascalCaseName}GraphQLRequest(String partialRequest) throws GraphQLRequestPreparationException {
		return new GraphQLReactiveRequest${springBeanSuffix}(this.graphQlClient,partialRequest, RequestType.${object.requestType}, "${field.name}" //$NON-NLS-1$
#foreach ($inputParameter in $field.inputParameters)  ## Here, inputParameter is an instance of Field
		, InputParameter.newBindParameter("$springBeanSuffix", "${inputParameter.name}","${object.camelCaseName}${field.pascalCaseName}${inputParameter.pascalCaseName}",#if(${inputParameter.fieldTypeAST.mandatory}) InputParameterType.MANDATORY#else InputParameterType.OPTIONAL#end, "${inputParameter.graphQLTypeSimpleName}", ${inputParameter.fieldTypeAST.mandatory}, ${inputParameter.fieldTypeAST.listDepth}, ${inputParameter.fieldTypeAST.itemMandatory}) //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
#end
		);
	}
	
#end
}
