##
## Velocity template for type GraphQLTypeMapping (client side).
##
## The generated class contains:
## - A map from the graphql type name to the java class
##
##
## This template has these inputs:
## types 	 			A map from graphql name to the java class
##
##
##
##
## Maven ignores the default value for springBeanSuffix, and replaces it by a null value. In this case, we replace the value by an empty String 
#if (!${configuration.springBeanSuffix}) #set($springBeanSuffix="") #else #set($springBeanSuffix = ${configuration.springBeanSuffix}) #end
##
##
/** Generated by the default template from graphql-java-generator */
package ${packageUtilName};

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;

import org.springframework.util.ClassUtils;

public class GraphQLTypeMapping {

	private final static Map<String, Class<?>> map = new HashMap<>();

	static {
		String line;
		Class<?> clazz;
		ClassLoader classLoader = GraphQLTypeMapping.class.getClassLoader();

		final String RESOURCE_PATH = "typeMapping${springBeanSuffix}.csv";

		try (BufferedReader reader = new BufferedReader(
				new InputStreamReader(classLoader.getResourceAsStream(RESOURCE_PATH)))) {
			while ((line = reader.readLine()) != null) {
				String[] keyValue = line.split(",");
				if (keyValue.length != 2) {
					throw new RuntimeException("Invalid line in typeMapping.csv: " + line);
				}
				try {
					clazz = ClassUtils.forName(keyValue[1], classLoader);
				} catch (Exception e) {
					throw new RuntimeException("Error while looking for the class of the type '" + keyValue[0] + "': "
							+ e.getClass().getSimpleName() + "-" + e.getMessage(), e);
				}
				map.put(keyValue[0], clazz);
			} // while
		} catch (NullPointerException e) {
			throw new RuntimeException("NullPointerException while reading type mapping : " + RESOURCE_PATH);
		} catch (IOException e) {
			throw new RuntimeException("Error while reading type mapping (" + RESOURCE_PATH + "): " + e.getMessage(),
					e);
		}
	}

	public static Class<?> getJavaClass(String typeName) {
		return map.get(typeName);
	}
}