/*
 * Decompiled with CFR 0.152.
 */
package com.graphql_java_generator.mavenplugin;

import com.graphql_java_generator.mavenplugin.GraphQLMojo;
import com.graphql_java_generator.mavenplugin.MavenLogger;
import com.graphql_java_generator.plugin.CustomScalarDefinition;
import com.graphql_java_generator.plugin.GraphQLConfiguration;
import com.graphql_java_generator.plugin.Logger;
import com.graphql_java_generator.plugin.Packaging;
import com.graphql_java_generator.plugin.PluginMode;
import java.io.File;
import java.util.List;
import java.util.Map;

public class GraphQLConfigurationImpl
implements GraphQLConfiguration {
    private final GraphQLMojo mojo;
    private final MavenLogger log;

    GraphQLConfigurationImpl(GraphQLMojo mojo) {
        this.mojo = mojo;
        this.log = new MavenLogger(mojo);
        try {
            Packaging.valueOf((String)mojo.project.getPackaging());
        }
        catch (Exception e) {
            throw new RuntimeException("The project packaging is <" + mojo.project.getPackaging() + ">. This is not accepted by this plugin", e);
        }
    }

    public List<CustomScalarDefinition> getCustomScalars() {
        return this.mojo.customScalars;
    }

    public Logger getLog() {
        return this.log;
    }

    public PluginMode getMode() {
        return this.mojo.mode;
    }

    public String getPackageName() {
        return this.mojo.packageName;
    }

    public Packaging getPackaging() {
        return Packaging.valueOf((String)this.mojo.project.getPackaging());
    }

    public File getSchemaFileFolder() {
        return new File(this.mojo.project.getBasedir(), this.mojo.schemaFileFolder);
    }

    public String getSchemaFilePattern() {
        return this.mojo.schemaFilePattern;
    }

    public File getSchemaPersonalizationFile() {
        return "null".equals(this.mojo.schemaPersonalizationFile) ? null : new File(this.mojo.project.getBasedir(), this.mojo.schemaPersonalizationFile);
    }

    public String getSourceEncoding() {
        return this.mojo.sourceEncoding;
    }

    public File getTargetFolder() {
        return new File(this.mojo.project.getBasedir(), "target");
    }

    public File getTargetClassFolder() {
        return new File(this.getTargetFolder(), "classes");
    }

    public File getTargetSourceFolder() {
        return new File(this.getTargetFolder(), this.mojo.targetSourceFolder);
    }

    public boolean isCopyRuntimeSources() {
        return this.mojo.copyRuntimeSources;
    }

    public boolean isGenerateDeprecatedRequestResponse() {
        return this.mojo.generateDeprecatedRequestResponse;
    }

    public boolean isGenerateJPAAnnotation() {
        return this.mojo.generateJPAAnnotation;
    }

    public String getScanBasePackages() {
        return this.mojo.scanBasePackages;
    }

    public boolean isSeparateUtilityClasses() {
        return this.mojo.separateUtilityClasses;
    }

    public Map<String, String> getTemplates() {
        return this.mojo.templates;
    }
}

