/*
 * Decompiled with CFR 0.152.
 */
package com.graphql_java_generator.mavenplugin;

import com.graphql_java_generator.mavenplugin.GraphQLSpringConfiguration;
import com.graphql_java_generator.plugin.CustomScalarDefinition;
import com.graphql_java_generator.plugin.GraphQLCodeGenerator;
import com.graphql_java_generator.plugin.GraphQLConfiguration;
import com.graphql_java_generator.plugin.GraphQLDocumentParser;
import com.graphql_java_generator.plugin.PluginMode;
import graphql.ThreadSafe;
import java.io.File;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;

@ThreadSafe
@Mojo(name="graphql", defaultPhase=LifecyclePhase.GENERATE_SOURCES, requiresProject=true)
public class GraphQLMojo
extends AbstractMojo {
    @Parameter(property="com.graphql_java_generator.mavenplugin.copyRuntimeSources", defaultValue="true")
    boolean copyRuntimeSources;
    @Parameter(property="com.graphql_java_generator.mavenplugin.customScalars")
    List<CustomScalarDefinition> customScalars = null;
    @Parameter(property="com.graphql_java_generator.mavenplugin.generateDeprecatedRequestResponse", defaultValue="true")
    boolean generateDeprecatedRequestResponse;
    @Parameter(property="com.graphql_java_generator.mavenplugin.generateJPAAnnotation", defaultValue="false")
    boolean generateJPAAnnotation;
    @Parameter(property="com.graphql_java_generator.mavenplugin.mode", defaultValue="client")
    PluginMode mode;
    @Parameter(property="com.graphql_java_generator.mavenplugin.packageName", defaultValue="com.generated.graphql")
    String packageName;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    MavenProject project;
    @Parameter(property="com.graphql_java_generator.mavenplugin.scanBasePackages", defaultValue="null")
    String scanBasePackages;
    @Parameter(property="com.graphql_java_generator.mavenplugin.schemaFileFolder", defaultValue="/src/main/resources")
    String schemaFileFolder;
    @Parameter(property="com.graphql_java_generator.mavenplugin.schemaFilePattern", defaultValue="*.graphqls")
    String schemaFilePattern;
    @Parameter(property="com.graphql_java_generator.mavenplugin.schemaPersonalizationFile", defaultValue="null")
    String schemaPersonalizationFile;
    @Parameter(property="com.graphql_java_generator.mavenplugin.separateUtilityClasses", defaultValue="false")
    boolean separateUtilityClasses;
    @Parameter(property="com.graphql_java_generator.mavenplugin.sourceEncoding", defaultValue="UTF-8")
    String sourceEncoding;
    @Parameter(property="com.graphql_java_generator.mavenplugin.targetSourceFolder", defaultValue="/generated-sources/graphql-maven-plugin")
    String targetSourceFolder;
    @Parameter(property="com.graphql_java_generator.mavenplugin.templates")
    Map<String, String> templates;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            Instant start = Instant.now();
            this.getLog().debug((CharSequence)"Starting generation of java classes from graphqls files");
            GraphQLSpringConfiguration.mojo = this;
            AnnotationConfigApplicationContext ctx = new AnnotationConfigApplicationContext(new Class[]{GraphQLSpringConfiguration.class});
            ((GraphQLConfiguration)ctx.getBean(GraphQLConfiguration.class)).logConfiguration();
            GraphQLDocumentParser documentParser = (GraphQLDocumentParser)ctx.getBean(GraphQLDocumentParser.class);
            documentParser.parseDocuments();
            GraphQLCodeGenerator codeGenerator = (GraphQLCodeGenerator)ctx.getBean(GraphQLCodeGenerator.class);
            int nbGeneratedClasses = codeGenerator.generateCode();
            ctx.close();
            File targetDir = new File(this.project.getBasedir(), "target");
            this.project.addCompileSourceRoot(new File(targetDir, this.targetSourceFolder).getAbsolutePath());
            Duration duration = Duration.between(start, Instant.now());
            this.getLog().info((CharSequence)(nbGeneratedClasses + " java classes have been generated from the schema(s) '" + this.schemaFilePattern + "' in the package '" + this.packageName + "' in " + duration.getSeconds() + " seconds"));
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }
}

