/*
 * Decompiled with CFR 0.152.
 */
package com.graphql_java_generator.mavenplugin;

import com.graphql_java_generator.mavenplugin.AbstractCommonMojo;
import com.graphql_java_generator.plugin.conf.GenerateGraphQLSchemaConfiguration;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProjectHelper;

public abstract class AbstractGenerateGraphQLSchemaMojo
extends AbstractCommonMojo
implements GenerateGraphQLSchemaConfiguration {
    @Parameter(property="com.graphql_java_generator.mavenplugin.resourceEncoding", defaultValue="UTF-8")
    String resourceEncoding;
    @Parameter(property="com.graphql_java_generator.mavenplugin.targetFolder", defaultValue="${project.build.directory}/generated-resources/graphql-maven-plugin_generate-relay-schema")
    File targetFolder;
    @Parameter(property="com.graphql_java_generator.mavenplugin.targetSchemaFileName", defaultValue="generated_schema.graphqls")
    String targetSchemaFileName;
    @Component
    protected MavenProjectHelper projectHelper;

    AbstractGenerateGraphQLSchemaMojo(Class<?> springConfigurationClass) {
        super(springConfigurationClass);
    }

    @Override
    public File getSchemaFileFolder() {
        return this.schemaFileFolder;
    }

    @Override
    public String getSchemaFilePattern() {
        return this.schemaFilePattern;
    }

    public String getResourceEncoding() {
        return this.resourceEncoding;
    }

    public File getTargetFolder() {
        return this.targetFolder;
    }

    public String getTargetSchemaFileName() {
        return this.targetSchemaFileName;
    }

    @Override
    public Map<String, String> getTemplates() {
        return this.templates;
    }

    public boolean isAddRelayConnections() {
        return this.addRelayConnections;
    }

    @Override
    protected void executePostExecutionTask() throws IOException {
        String generatedResourceFolder = this.getTargetFolder().getPath();
        this.getLog().debug((CharSequence)("Adding the generated resources folder: " + generatedResourceFolder));
        this.projectHelper.addResource(this.project, generatedResourceFolder, Arrays.asList("**/*"), null);
        this.buildContext.refresh(this.getTargetFolder());
    }
}

