/*
 * Decompiled with CFR 0.152.
 */
package com.oembedler.moon.altair.boot;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.oembedler.moon.altair.boot.PropertyGroupReader;
import com.oembedler.moon.altair.boot.PropsLoader;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.text.StrSubstitutor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Controller;
import org.springframework.util.StreamUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class AltairController {
    private static final String CDN_UNPKG = "//unpkg.com/";
    private static final String ALTAIR = "altair-static";
    @Value(value="${altair.endpoint.graphql:/graphql}")
    private String graphqlEndpoint;
    @Value(value="${altair.endpoint.subscriptions:/subscriptions}")
    private String subscriptionsEndpoint;
    @Value(value="${altair.static.basePath:}")
    private String staticBasePath;
    @Value(value="${altair.pageTitle:Altair}")
    private String pageTitle;
    @Value(value="${altair.cdn.enabled:false}")
    private Boolean altairCdnEnabled;
    @Value(value="${altair.cdn.version:2.1.7}")
    private String altairCdnVersion;
    @Autowired
    private Environment environment;
    private String template;
    private String props;
    private String headers;

    @PostConstruct
    public void onceConstructed() throws IOException {
        this.loadTemplate();
        this.loadProps();
        this.loadHeaders();
    }

    private void loadTemplate() throws IOException {
        try (InputStream inputStream = new ClassPathResource("altair.html").getInputStream();){
            this.template = StreamUtils.copyToString((InputStream)inputStream, (Charset)Charset.defaultCharset());
        }
    }

    private void loadProps() throws IOException {
        this.props = new PropsLoader(this.environment).load();
    }

    private void loadHeaders() throws JsonProcessingException {
        PropertyGroupReader propertyReader = new PropertyGroupReader(this.environment, "graphiql.headers.");
        Properties headerProperties = propertyReader.load();
        this.addIfAbsent(headerProperties, "Accept");
        this.addIfAbsent(headerProperties, "Content-Type");
        this.headers = new ObjectMapper().writeValueAsString((Object)headerProperties);
    }

    private void addIfAbsent(Properties headerProperties, String header) {
        if (!headerProperties.containsKey(header)) {
            headerProperties.setProperty(header, "application/json");
        }
    }

    @RequestMapping(value={"${altair.mapping:/altair}"})
    public void altair(HttpServletRequest request, HttpServletResponse response, @PathVariable Map<String, String> params) throws IOException {
        response.setContentType("text/html; charset=UTF-8");
        Map<String, String> replacements = this.getReplacements(this.constructGraphQlEndpoint(request, params), request.getContextPath() + this.subscriptionsEndpoint);
        String populatedTemplate = StrSubstitutor.replace((Object)this.template, replacements);
        response.getOutputStream().write(populatedTemplate.getBytes(Charset.defaultCharset()));
    }

    private Map<String, String> getReplacements(String graphqlEndpoint, String subscriptionsEndpoint) {
        HashMap<String, String> replacements = new HashMap<String, String>();
        replacements.put("graphqlEndpoint", graphqlEndpoint);
        replacements.put("subscriptionsEndpoint", subscriptionsEndpoint);
        replacements.put("pageTitle", this.pageTitle);
        replacements.put("pageFavicon", this.getResourceUrl("favicon.ico", "favicon.ico"));
        replacements.put("altairBaseUrl", this.getResourceUrl(StringUtils.join((Object[])new String[]{this.staticBasePath, "/vendor/altair/"}), this.joinJsUnpkgPath(ALTAIR, this.altairCdnVersion, "build/dist/")));
        replacements.put("altairLogoUrl", this.getResourceUrl("assets/img/logo_350.svg", "assets/img/logo_350.svg"));
        replacements.put("altairCssUrl", this.getResourceUrl("styles.css", "styles.css"));
        replacements.put("altairMainJsUrl", this.getResourceUrl("main.js", "main.js"));
        replacements.put("altairPolyfillsJsUrl", this.getResourceUrl("polyfills.js", "polyfills.js"));
        replacements.put("altairRuntimeJsUrl", this.getResourceUrl("runtime.js", "runtime.js"));
        replacements.put("props", this.props);
        replacements.put("headers", this.headers);
        return replacements;
    }

    private String getResourceUrl(String staticFileName, String cdnUrl) {
        if (this.altairCdnEnabled.booleanValue() && StringUtils.isNotBlank((CharSequence)cdnUrl)) {
            return cdnUrl;
        }
        return staticFileName;
    }

    private String joinJsUnpkgPath(String library, String cdnVersion, String cdnFileName) {
        return CDN_UNPKG + library + "@" + cdnVersion + "/" + cdnFileName;
    }

    private String constructGraphQlEndpoint(HttpServletRequest request, @RequestParam Map<String, String> params) {
        String endpoint = this.graphqlEndpoint;
        for (Map.Entry<String, String> param : params.entrySet()) {
            endpoint = endpoint.replaceAll("\\{" + param.getKey() + "}", param.getValue());
        }
        if (StringUtils.isNotBlank((CharSequence)request.getContextPath()) && !endpoint.startsWith(request.getContextPath())) {
            return request.getContextPath() + endpoint;
        }
        return endpoint;
    }
}

