/*
 * Decompiled with CFR 0.152.
 */
package graphql.kickstart.graphiql.boot;

import graphql.kickstart.graphiql.boot.GraphiQLProperties;
import graphql.kickstart.graphiql.boot.ReactiveGraphiQLController;
import graphql.kickstart.graphiql.boot.ServletGraphiQLController;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(value={"graphiql.enabled"}, havingValue="true", matchIfMissing=true)
@EnableConfigurationProperties(value={GraphiQLProperties.class})
public class GraphiQLAutoConfiguration {
    @Bean(name={"graphiQLController"})
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
    ServletGraphiQLController servletGraphiQLController() {
        return new ServletGraphiQLController();
    }

    @Bean(name={"graphiQLController"})
    @ConditionalOnMissingBean(value={ServletGraphiQLController.class})
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
    ReactiveGraphiQLController reactiveGraphiQLController() {
        return new ReactiveGraphiQLController();
    }
}

