/*
 * Decompiled with CFR 0.152.
 */
package graphql.kickstart.execution.instrumentation;

import graphql.ExecutionResult;
import graphql.ExecutionResultImpl;
import graphql.execution.AsyncExecutionStrategy;
import graphql.execution.ExecutionContext;
import graphql.execution.ExecutionStrategy;
import graphql.execution.instrumentation.ExecutionStrategyInstrumentationContext;
import graphql.execution.instrumentation.InstrumentationContext;
import graphql.execution.instrumentation.InstrumentationState;
import graphql.execution.instrumentation.SimpleInstrumentationContext;
import graphql.execution.instrumentation.dataloader.DataLoaderDispatcherInstrumentation;
import graphql.execution.instrumentation.dataloader.DataLoaderDispatcherInstrumentationOptions;
import graphql.execution.instrumentation.parameters.InstrumentationCreateStateParameters;
import graphql.execution.instrumentation.parameters.InstrumentationExecuteOperationParameters;
import graphql.execution.instrumentation.parameters.InstrumentationExecutionParameters;
import graphql.execution.instrumentation.parameters.InstrumentationExecutionStrategyParameters;
import graphql.execution.instrumentation.parameters.InstrumentationFieldFetchParameters;
import graphql.kickstart.execution.instrumentation.DataLoaderDispatcherInstrumentationState;
import graphql.kickstart.execution.instrumentation.TrackingApproach;
import graphql.language.OperationDefinition;
import graphql.schema.DataFetcher;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import lombok.Generated;
import org.dataloader.DataLoader;
import org.dataloader.DataLoaderRegistry;
import org.dataloader.stats.Statistics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurableDispatchInstrumentation
extends DataLoaderDispatcherInstrumentation {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConfigurableDispatchInstrumentation.class);
    private final DataLoaderDispatcherInstrumentationOptions options;
    private final Function<DataLoaderRegistry, TrackingApproach> approachFunction;

    public ConfigurableDispatchInstrumentation(Function<DataLoaderRegistry, TrackingApproach> approachFunction) {
        this(DataLoaderDispatcherInstrumentationOptions.newOptions(), approachFunction);
    }

    public ConfigurableDispatchInstrumentation(DataLoaderDispatcherInstrumentationOptions options, Function<DataLoaderRegistry, TrackingApproach> approachFunction) {
        this.options = options;
        this.approachFunction = approachFunction;
    }

    public InstrumentationState createState(InstrumentationCreateStateParameters parameters) {
        DataLoaderRegistry registry = parameters.getExecutionInput().getDataLoaderRegistry();
        return new DataLoaderDispatcherInstrumentationState(registry, this.approachFunction.apply(registry), parameters.getExecutionInput().getExecutionId());
    }

    public DataFetcher<?> instrumentDataFetcher(DataFetcher<?> dataFetcher, InstrumentationFieldFetchParameters parameters, InstrumentationState instrumentationState) {
        DataLoaderDispatcherInstrumentationState state = (DataLoaderDispatcherInstrumentationState)InstrumentationState.ofState((InstrumentationState)instrumentationState);
        if (state.isAggressivelyBatching()) {
            return dataFetcher;
        }
        return environment -> {
            Object obj = dataFetcher.get(environment);
            this.doImmediatelyDispatch(state);
            return obj;
        };
    }

    private void doImmediatelyDispatch(DataLoaderDispatcherInstrumentationState state) {
        state.getApproach().dispatch();
    }

    public InstrumentationContext<ExecutionResult> beginExecuteOperation(InstrumentationExecuteOperationParameters parameters, InstrumentationState instrumentationState) {
        if (!this.isDataLoaderCompatible(parameters.getExecutionContext())) {
            DataLoaderDispatcherInstrumentationState state = (DataLoaderDispatcherInstrumentationState)InstrumentationState.ofState((InstrumentationState)instrumentationState);
            state.setAggressivelyBatching(false);
        }
        return SimpleInstrumentationContext.noOp();
    }

    private boolean isDataLoaderCompatible(ExecutionContext executionContext) {
        if (executionContext.getOperationDefinition().getOperation() == OperationDefinition.Operation.QUERY) {
            ExecutionStrategy queryStrategy = executionContext.getQueryStrategy();
            return queryStrategy instanceof AsyncExecutionStrategy;
        }
        return false;
    }

    public ExecutionStrategyInstrumentationContext beginExecutionStrategy(InstrumentationExecutionStrategyParameters parameters, InstrumentationState instrumentationState) {
        DataLoaderDispatcherInstrumentationState state = (DataLoaderDispatcherInstrumentationState)InstrumentationState.ofState((InstrumentationState)instrumentationState);
        if (state.hasNoDataLoaders()) {
            return new ExecutionStrategyInstrumentationContext(){

                public void onDispatched(CompletableFuture<ExecutionResult> result) {
                }

                public void onCompleted(ExecutionResult result, Throwable t) {
                }
            };
        }
        return state.getApproach().beginExecutionStrategy(parameters);
    }

    public InstrumentationContext<Object> beginFieldFetch(InstrumentationFieldFetchParameters parameters, InstrumentationState instrumentationState) {
        DataLoaderDispatcherInstrumentationState state = (DataLoaderDispatcherInstrumentationState)InstrumentationState.ofState((InstrumentationState)instrumentationState);
        if (state.hasNoDataLoaders()) {
            return SimpleInstrumentationContext.noOp();
        }
        return state.getApproach().beginFieldFetch(parameters);
    }

    public CompletableFuture<ExecutionResult> instrumentExecutionResult(ExecutionResult executionResult, InstrumentationExecutionParameters parameters, InstrumentationState instrumentationState) {
        DataLoaderDispatcherInstrumentationState state = (DataLoaderDispatcherInstrumentationState)InstrumentationState.ofState((InstrumentationState)instrumentationState);
        state.getApproach().removeTracking(parameters.getExecutionInput().getExecutionId());
        if (!this.options.isIncludeStatistics()) {
            return CompletableFuture.completedFuture(executionResult);
        }
        Map currentExt = executionResult.getExtensions();
        LinkedHashMap<String, Map<Object, Object>> statsMap = new LinkedHashMap<String, Map<Object, Object>>(currentExt == null ? Collections.emptyMap() : currentExt);
        Map<Object, Object> dataLoaderStats = this.buildStatisticsMap(state);
        statsMap.put("dataloader", dataLoaderStats);
        log.debug("Data loader stats : {}", dataLoaderStats);
        return CompletableFuture.completedFuture(new ExecutionResultImpl(executionResult.getData(), executionResult.getErrors(), statsMap));
    }

    private Map<Object, Object> buildStatisticsMap(DataLoaderDispatcherInstrumentationState state) {
        DataLoaderRegistry dataLoaderRegistry = state.getDataLoaderRegistry();
        Statistics allStats = dataLoaderRegistry.getStatistics();
        LinkedHashMap<Object, Object> statsMap = new LinkedHashMap<Object, Object>();
        statsMap.put("overall-statistics", allStats.toMap());
        LinkedHashMap<String, Map> individualStatsMap = new LinkedHashMap<String, Map>();
        for (String dlKey : dataLoaderRegistry.getKeys()) {
            DataLoader dl = dataLoaderRegistry.getDataLoader(dlKey);
            Statistics statistics = dl.getStatistics();
            individualStatsMap.put(dlKey, statistics.toMap());
        }
        statsMap.put("individual-statistics", individualStatsMap);
        return statsMap;
    }
}

