/*
 * Decompiled with CFR 0.152.
 */
package graphql.kickstart.execution.subscriptions;

import graphql.ExecutionResult;
import graphql.GraphqlErrorBuilder;
import graphql.execution.NonNullableFieldWasNullException;
import graphql.kickstart.execution.error.GenericGraphQLError;
import graphql.kickstart.execution.subscriptions.AtomicSubscriptionSubscription;
import graphql.kickstart.execution.subscriptions.SubscriptionSession;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import lombok.Generated;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SessionSubscriber
implements Subscriber<ExecutionResult> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SessionSubscriber.class);
    private final SubscriptionSession session;
    private final String id;
    private AtomicSubscriptionSubscription subscriptionReference = new AtomicSubscriptionSubscription();

    public void onSubscribe(Subscription subscription) {
        log.debug("Subscribe to execution result: {}", (Object)subscription);
        this.subscriptionReference.set(subscription);
        this.subscriptionReference.get().request(1L);
        this.session.add(this.id, this.subscriptionReference.get());
    }

    public void onNext(ExecutionResult executionResult) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("data", executionResult.getData());
        this.session.sendDataMessage(this.id, result);
        this.subscriptionReference.get().request(1L);
    }

    public void onError(Throwable throwable) {
        log.error("Subscription error", throwable);
        HashMap<String, List<Object>> payload = new HashMap<String, List<Object>>();
        if (throwable.getCause() instanceof NonNullableFieldWasNullException) {
            NonNullableFieldWasNullException e = (NonNullableFieldWasNullException)throwable.getCause();
            payload.put("errors", Collections.singletonList(GraphqlErrorBuilder.newError().message(e.getMessage(), new Object[0]).path(e.getPath()).build()));
        } else {
            payload.put("errors", Collections.singletonList(new GenericGraphQLError(throwable.getMessage())));
        }
        this.session.unsubscribe(this.id);
        this.session.sendErrorMessage(this.id, payload);
    }

    public void onComplete() {
        this.session.unsubscribe(this.id);
        this.session.sendCompleteMessage(this.id);
    }

    @Generated
    public SessionSubscriber(SubscriptionSession session, String id) {
        this.session = session;
        this.id = id;
    }
}

