/*
 * Decompiled with CFR 0.152.
 */
package graphql.kickstart.servlet;

import graphql.kickstart.servlet.core.GraphQLServletListener;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListenerHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ListenerHandler.class);
    private final List<GraphQLServletListener.RequestCallback> callbacks;
    private final HttpServletRequest request;
    private final HttpServletResponse response;

    static ListenerHandler start(HttpServletRequest request, HttpServletResponse response, List<GraphQLServletListener> listeners) {
        if (listeners != null) {
            return new ListenerHandler(ListenerHandler.runListeners(listeners, it -> it.onRequest(request, response)), request, response);
        }
        return new ListenerHandler(Collections.emptyList(), request, response);
    }

    private static <R> List<R> runListeners(List<GraphQLServletListener> listeners, Function<? super GraphQLServletListener, R> action) {
        return listeners.stream().map(listener -> {
            try {
                return action.apply((GraphQLServletListener)listener);
            }
            catch (Exception t) {
                log.error("Error running listener: {}", listener, (Object)t);
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    void runCallbacks(Consumer<GraphQLServletListener.RequestCallback> action) {
        this.callbacks.forEach(callback -> {
            try {
                action.accept((GraphQLServletListener.RequestCallback)callback);
            }
            catch (Exception t) {
                log.error("Error running callback: {}", callback, (Object)t);
            }
        });
    }

    void onParseError(Throwable throwable) {
        this.runCallbacks(it -> it.onParseError(this.request, this.response, throwable));
    }

    void beforeFlush() {
        this.runCallbacks(it -> it.beforeFlush(this.request, this.response));
    }

    void onSuccess() {
        this.runCallbacks(it -> it.onSuccess(this.request, this.response));
    }

    void onError(Throwable throwable) {
        this.runCallbacks(it -> it.onError(this.request, this.response, throwable));
    }

    void onFinally() {
        this.runCallbacks(it -> it.onFinally(this.request, this.response));
    }

    @Generated
    public ListenerHandler(List<GraphQLServletListener.RequestCallback> callbacks, HttpServletRequest request, HttpServletResponse response) {
        this.callbacks = callbacks;
        this.request = request;
        this.response = response;
    }
}

