/*
 * Decompiled with CFR 0.152.
 */
package graphql.kickstart.servlet;

import graphql.ExecutionResult;
import graphql.kickstart.execution.GraphQLObjectMapper;
import graphql.kickstart.servlet.ExecutionResultSubscriber;
import graphql.kickstart.servlet.QueryResponseWriter;
import graphql.kickstart.servlet.StaticDataPublisher;
import graphql.kickstart.servlet.SubscriptionAsyncListener;
import jakarta.servlet.AsyncContext;
import jakarta.servlet.AsyncListener;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

class SingleAsynchronousQueryResponseWriter
implements QueryResponseWriter {
    private final ExecutionResult result;
    private final GraphQLObjectMapper graphQLObjectMapper;
    private final long subscriptionTimeout;

    @Override
    public void write(HttpServletRequest request, HttpServletResponse response) {
        Objects.requireNonNull(request, "Http servlet request cannot be null");
        response.setContentType("text/event-stream;charset=UTF-8");
        response.setStatus(200);
        boolean isInAsyncThread = request.isAsyncStarted();
        AsyncContext asyncContext = isInAsyncThread ? request.getAsyncContext() : request.startAsync((ServletRequest)request, (ServletResponse)response);
        asyncContext.setTimeout(this.subscriptionTimeout);
        AtomicReference<Subscription> subscriptionRef = new AtomicReference<Subscription>();
        asyncContext.addListener((AsyncListener)new SubscriptionAsyncListener(subscriptionRef));
        ExecutionResultSubscriber subscriber = new ExecutionResultSubscriber(subscriptionRef, asyncContext, this.graphQLObjectMapper);
        ArrayList<Publisher> publishers = new ArrayList<Publisher>();
        if (this.result.getData() instanceof Publisher) {
            publishers.add((Publisher)this.result.getData());
        } else {
            publishers.add(new StaticDataPublisher<ExecutionResult>(this.result));
        }
        publishers.forEach(it -> it.subscribe((Subscriber)subscriber));
        if (isInAsyncThread) {
            try {
                subscriber.await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    @Generated
    public SingleAsynchronousQueryResponseWriter(ExecutionResult result, GraphQLObjectMapper graphQLObjectMapper, long subscriptionTimeout) {
        this.result = result;
        this.graphQLObjectMapper = graphQLObjectMapper;
        this.subscriptionTimeout = subscriptionTimeout;
    }

    @Generated
    public ExecutionResult getResult() {
        return this.result;
    }
}

