/*
 * Decompiled with CFR 0.152.
 */
package graphql.kickstart.servlet;

import graphql.kickstart.execution.GraphQLObjectMapper;
import graphql.kickstart.execution.context.ContextSetting;
import graphql.kickstart.execution.input.GraphQLInvocationInput;
import graphql.kickstart.servlet.GraphQLGetInvocationInputParser;
import graphql.kickstart.servlet.GraphQLMultipartInvocationInputParser;
import graphql.kickstart.servlet.GraphQLPostInvocationInputParser;
import graphql.kickstart.servlet.input.GraphQLInvocationInputFactory;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;

interface GraphQLInvocationInputParser {
    public static GraphQLInvocationInputParser create(HttpServletRequest request, GraphQLInvocationInputFactory invocationInputFactory, GraphQLObjectMapper graphQLObjectMapper, ContextSetting contextSetting) throws IOException {
        if ("GET".equalsIgnoreCase(request.getMethod())) {
            return new GraphQLGetInvocationInputParser(invocationInputFactory, graphQLObjectMapper, contextSetting);
        }
        try {
            boolean notMultipartRequest;
            boolean bl = notMultipartRequest = request.getContentType() == null || !request.getContentType().startsWith("multipart/form-data") || request.getParts().isEmpty();
            if (notMultipartRequest) {
                return new GraphQLPostInvocationInputParser(invocationInputFactory, graphQLObjectMapper, contextSetting);
            }
            return new GraphQLMultipartInvocationInputParser(invocationInputFactory, graphQLObjectMapper, contextSetting);
        }
        catch (ServletException e) {
            throw new IOException("Cannot get parts of request", e);
        }
    }

    public GraphQLInvocationInput getGraphQLInvocationInput(HttpServletRequest var1, HttpServletResponse var2) throws IOException;
}

