/*
 * Decompiled with CFR 0.152.
 */
package graphql.servlet;

import graphql.GraphQLException;
import graphql.kickstart.execution.GraphQLObjectMapper;
import graphql.kickstart.execution.GraphQLRequest;
import graphql.kickstart.execution.context.ContextSetting;
import graphql.kickstart.execution.input.GraphQLInvocationInput;
import graphql.servlet.AbstractGraphQLInvocationInputParser;
import graphql.servlet.input.GraphQLInvocationInputFactory;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GraphQLGetInvocationInputParser
extends AbstractGraphQLInvocationInputParser {
    private static final Logger log = LoggerFactory.getLogger(GraphQLGetInvocationInputParser.class);

    GraphQLGetInvocationInputParser(GraphQLInvocationInputFactory invocationInputFactory, GraphQLObjectMapper graphQLObjectMapper, ContextSetting contextSetting) {
        super(invocationInputFactory, graphQLObjectMapper, contextSetting);
    }

    @Override
    public GraphQLInvocationInput getGraphQLInvocationInput(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (this.isIntrospectionQuery(request)) {
            GraphQLRequest graphqlRequest = GraphQLRequest.createIntrospectionRequest();
            return this.invocationInputFactory.create(graphqlRequest, request, response);
        }
        String query = request.getParameter("query");
        if (query == null) {
            throw new GraphQLException("Query parameter not found in GET request");
        }
        if (this.isSingleQuery(query)) {
            Map<String, Object> variables = this.getVariables(request);
            String operationName = request.getParameter("operationName");
            GraphQLRequest graphqlRequest = new GraphQLRequest(query, variables, operationName);
            return this.invocationInputFactory.createReadOnly(graphqlRequest, request, response);
        }
        List graphqlRequests = this.graphQLObjectMapper.readBatchedGraphQLRequest(query);
        return this.invocationInputFactory.createReadOnly(this.contextSetting, graphqlRequests, request, response);
    }

    private boolean isIntrospectionQuery(HttpServletRequest request) {
        String path = Optional.ofNullable(request.getPathInfo()).orElseGet(() -> ((HttpServletRequest)request).getServletPath()).toLowerCase();
        return path.contentEquals("/schema.json");
    }

    private Map<String, Object> getVariables(HttpServletRequest request) {
        return Optional.ofNullable(request.getParameter("variables")).map(arg_0 -> ((GraphQLObjectMapper)this.graphQLObjectMapper).deserializeVariables(arg_0)).map(HashMap::new).orElseGet(HashMap::new);
    }
}

