/*
 * Decompiled with CFR 0.152.
 */
package graphql.kickstart.execution.instrumentation;

import graphql.ExecutionResult;
import graphql.execution.ExecutionId;
import graphql.execution.ExecutionPath;
import graphql.execution.FieldValueInfo;
import graphql.execution.MergedField;
import graphql.execution.instrumentation.DeferredFieldInstrumentationContext;
import graphql.execution.instrumentation.ExecutionStrategyInstrumentationContext;
import graphql.execution.instrumentation.InstrumentationContext;
import graphql.execution.instrumentation.parameters.InstrumentationDeferredFieldParameters;
import graphql.execution.instrumentation.parameters.InstrumentationExecutionStrategyParameters;
import graphql.execution.instrumentation.parameters.InstrumentationFieldFetchParameters;
import graphql.kickstart.execution.instrumentation.RequestStack;
import graphql.kickstart.execution.instrumentation.TrackingApproach;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.dataloader.DataLoaderRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTrackingApproach
implements TrackingApproach {
    private static final Logger log = LoggerFactory.getLogger(AbstractTrackingApproach.class);
    private final DataLoaderRegistry dataLoaderRegistry;
    private final RequestStack stack = new RequestStack();

    public AbstractTrackingApproach(DataLoaderRegistry dataLoaderRegistry) {
        this.dataLoaderRegistry = dataLoaderRegistry;
    }

    protected RequestStack getStack() {
        return this.stack;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExecutionStrategyInstrumentationContext beginExecutionStrategy(InstrumentationExecutionStrategyParameters parameters) {
        final ExecutionId executionId = parameters.getExecutionContext().getExecutionId();
        ExecutionPath path = parameters.getExecutionStrategyParameters().getPath();
        int parentLevel = path.getLevel();
        final int curLevel = parentLevel + 1;
        int fieldCount = parameters.getExecutionStrategyParameters().getFields().size();
        RequestStack requestStack = this.stack;
        synchronized (requestStack) {
            this.stack.increaseExpectedFetchCount(executionId, curLevel, fieldCount);
            this.stack.increaseHappenedStrategyCalls(executionId, curLevel);
        }
        return new ExecutionStrategyInstrumentationContext(){

            public void onDispatched(CompletableFuture<ExecutionResult> result) {
            }

            public void onCompleted(ExecutionResult result, Throwable t) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onFieldValuesInfo(List<FieldValueInfo> fieldValueInfoList) {
                RequestStack requestStack = AbstractTrackingApproach.this.stack;
                synchronized (requestStack) {
                    AbstractTrackingApproach.this.stack.setStatus(executionId, AbstractTrackingApproach.this.handleOnFieldValuesInfo(fieldValueInfoList, AbstractTrackingApproach.this.stack, executionId, curLevel));
                    if (AbstractTrackingApproach.this.stack.allReady()) {
                        AbstractTrackingApproach.this.dispatchWithoutLocking();
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onDeferredField(MergedField field) {
                RequestStack requestStack = AbstractTrackingApproach.this.stack;
                synchronized (requestStack) {
                    AbstractTrackingApproach.this.stack.increaseFetchCount(executionId, curLevel);
                    AbstractTrackingApproach.this.stack.setStatus(executionId, AbstractTrackingApproach.this.dispatchIfNeeded(AbstractTrackingApproach.this.stack, executionId, curLevel));
                    if (AbstractTrackingApproach.this.stack.allReady()) {
                        AbstractTrackingApproach.this.dispatchWithoutLocking();
                    }
                }
            }
        };
    }

    private boolean handleOnFieldValuesInfo(List<FieldValueInfo> fieldValueInfoList, RequestStack stack, ExecutionId executionId, int curLevel) {
        stack.increaseHappenedOnFieldValueCalls(executionId, curLevel);
        int expectedStrategyCalls = 0;
        for (FieldValueInfo fieldValueInfo : fieldValueInfoList) {
            if (fieldValueInfo.getCompleteValueType() == FieldValueInfo.CompleteValueType.OBJECT) {
                ++expectedStrategyCalls;
                continue;
            }
            if (fieldValueInfo.getCompleteValueType() != FieldValueInfo.CompleteValueType.LIST) continue;
            expectedStrategyCalls += this.getCountForList(fieldValueInfo);
        }
        stack.increaseExpectedStrategyCalls(executionId, curLevel + 1, expectedStrategyCalls);
        return this.dispatchIfNeeded(stack, executionId, curLevel + 1);
    }

    private int getCountForList(FieldValueInfo fieldValueInfo) {
        int result = 0;
        for (FieldValueInfo cvi : fieldValueInfo.getFieldValueInfos()) {
            if (cvi.getCompleteValueType() == FieldValueInfo.CompleteValueType.OBJECT) {
                ++result;
                continue;
            }
            if (cvi.getCompleteValueType() != FieldValueInfo.CompleteValueType.LIST) continue;
            result += this.getCountForList(cvi);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeferredFieldInstrumentationContext beginDeferredField(InstrumentationDeferredFieldParameters parameters) {
        final ExecutionId executionId = parameters.getExecutionContext().getExecutionId();
        final int level = parameters.getExecutionStrategyParameters().getPath().getLevel();
        RequestStack requestStack = this.stack;
        synchronized (requestStack) {
            this.stack.clearAndMarkCurrentLevelAsReady(executionId, level);
        }
        return new DeferredFieldInstrumentationContext(){

            public void onDispatched(CompletableFuture<ExecutionResult> result) {
            }

            public void onCompleted(ExecutionResult result, Throwable t) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onFieldValueInfo(FieldValueInfo fieldValueInfo) {
                RequestStack requestStack = AbstractTrackingApproach.this.stack;
                synchronized (requestStack) {
                    AbstractTrackingApproach.this.stack.setStatus(executionId, AbstractTrackingApproach.this.handleOnFieldValuesInfo(Collections.singletonList(fieldValueInfo), AbstractTrackingApproach.this.stack, executionId, level));
                    if (AbstractTrackingApproach.this.stack.allReady()) {
                        AbstractTrackingApproach.this.dispatchWithoutLocking();
                    }
                }
            }
        };
    }

    @Override
    public InstrumentationContext<Object> beginFieldFetch(InstrumentationFieldFetchParameters parameters) {
        final ExecutionId executionId = parameters.getExecutionContext().getExecutionId();
        ExecutionPath path = parameters.getEnvironment().getExecutionStepInfo().getPath();
        final int level = path.getLevel();
        return new InstrumentationContext<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onDispatched(CompletableFuture result) {
                RequestStack requestStack = AbstractTrackingApproach.this.stack;
                synchronized (requestStack) {
                    AbstractTrackingApproach.this.stack.increaseFetchCount(executionId, level);
                    AbstractTrackingApproach.this.stack.setStatus(executionId, AbstractTrackingApproach.this.dispatchIfNeeded(AbstractTrackingApproach.this.stack, executionId, level));
                    if (AbstractTrackingApproach.this.stack.allReady()) {
                        AbstractTrackingApproach.this.dispatchWithoutLocking();
                    }
                }
            }

            public void onCompleted(Object result, Throwable t) {
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeTracking(ExecutionId executionId) {
        RequestStack requestStack = this.stack;
        synchronized (requestStack) {
            this.stack.removeExecution(executionId);
            if (this.stack.allReady()) {
                this.dispatchWithoutLocking();
            }
        }
    }

    private boolean dispatchIfNeeded(RequestStack stack, ExecutionId executionId, int level) {
        if (this.levelReady(stack, executionId, level)) {
            return stack.dispatchIfNotDispatchedBefore(executionId, level);
        }
        return false;
    }

    private boolean levelReady(RequestStack stack, ExecutionId executionId, int level) {
        if (level == 1) {
            return stack.allFetchesHappened(executionId, 1);
        }
        return this.levelReady(stack, executionId, level - 1) && stack.allOnFieldCallsHappened(executionId, level - 1) && stack.allStrategyCallsHappened(executionId, level) && stack.allFetchesHappened(executionId, level);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispatch() {
        RequestStack requestStack = this.stack;
        synchronized (requestStack) {
            this.dispatchWithoutLocking();
        }
    }

    private void dispatchWithoutLocking() {
        log.debug("Dispatching data loaders ({})", (Object)this.dataLoaderRegistry.getKeys());
        this.dataLoaderRegistry.dispatchAll();
        this.stack.allReset();
    }
}

