/*
 * Decompiled with CFR 0.152.
 */
package graphql.kickstart.execution.subscriptions.apollo;

import com.fasterxml.jackson.core.JsonProcessingException;
import graphql.kickstart.execution.GraphQLObjectMapper;
import graphql.kickstart.execution.subscriptions.SubscriptionSession;
import graphql.kickstart.execution.subscriptions.apollo.ApolloCommandProvider;
import graphql.kickstart.execution.subscriptions.apollo.OperationMessage;
import graphql.kickstart.execution.subscriptions.apollo.SubscriptionCommand;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApolloSubscriptionConsumer
implements Consumer<String> {
    private static final Logger log = LoggerFactory.getLogger(ApolloSubscriptionConsumer.class);
    private final SubscriptionSession session;
    private final GraphQLObjectMapper objectMapper;
    private final ApolloCommandProvider commandProvider;

    @Override
    public void accept(String request) {
        try {
            OperationMessage message = (OperationMessage)this.objectMapper.getJacksonMapper().readValue(request, OperationMessage.class);
            SubscriptionCommand command = this.commandProvider.getByType(message.getType());
            command.apply(this.session, message);
        }
        catch (JsonProcessingException e) {
            log.error("Cannot read subscription command '{}'", (Object)request, (Object)e);
            this.session.sendMessage(new OperationMessage(OperationMessage.Type.GQL_CONNECTION_ERROR, null, e.getMessage()));
        }
    }

    public ApolloSubscriptionConsumer(SubscriptionSession session, GraphQLObjectMapper objectMapper, ApolloCommandProvider commandProvider) {
        this.session = session;
        this.objectMapper = objectMapper;
        this.commandProvider = commandProvider;
    }
}

