/*
 * Decompiled with CFR 0.152.
 */
package graphql.kickstart.servlet;

import graphql.ExecutionResult;
import graphql.kickstart.execution.GraphQLObjectMapper;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.AsyncContext;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

class ExecutionResultSubscriber
implements Subscriber<ExecutionResult> {
    private final AtomicReference<Subscription> subscriptionRef;
    private final AsyncContext asyncContext;
    private final GraphQLObjectMapper graphQLObjectMapper;
    private final CountDownLatch completedLatch = new CountDownLatch(1);

    ExecutionResultSubscriber(AtomicReference<Subscription> subscriptionRef, AsyncContext asyncContext, GraphQLObjectMapper graphQLObjectMapper) {
        this.subscriptionRef = subscriptionRef;
        this.asyncContext = asyncContext;
        this.graphQLObjectMapper = graphQLObjectMapper;
    }

    public void onSubscribe(Subscription subscription) {
        this.subscriptionRef.set(subscription);
        this.subscriptionRef.get().request(1L);
    }

    public void onNext(ExecutionResult executionResult) {
        try {
            PrintWriter writer = this.asyncContext.getResponse().getWriter();
            ((Writer)writer).write("data: ");
            ((Writer)writer).write(this.graphQLObjectMapper.serializeResultAsJson(executionResult));
            ((Writer)writer).write("\n\n");
            ((Writer)writer).flush();
            this.subscriptionRef.get().request(1L);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void onError(Throwable t) {
        this.asyncContext.complete();
        this.completedLatch.countDown();
    }

    public void onComplete() {
        this.asyncContext.complete();
        this.completedLatch.countDown();
    }

    void await() throws InterruptedException {
        this.completedLatch.await();
    }
}

