/*
 * Decompiled with CFR 0.152.
 */
package graphql.kickstart.execution;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.MappingIterator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import graphql.DeferredExecutionResult;
import graphql.DeferredExecutionResultImpl;
import graphql.ExecutionResult;
import graphql.ExecutionResultImpl;
import graphql.GraphQLError;
import graphql.execution.ExecutionPath;
import graphql.kickstart.execution.GraphQLRequest;
import graphql.kickstart.execution.VariablesDeserializer;
import graphql.kickstart.execution.config.ConfiguringObjectMapperProvider;
import graphql.kickstart.execution.config.GraphQLServletObjectMapperConfigurer;
import graphql.kickstart.execution.config.ObjectMapperProvider;
import graphql.kickstart.execution.error.DefaultGraphQLErrorHandler;
import graphql.kickstart.execution.error.GraphQLErrorHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class GraphQLObjectMapper {
    private static final TypeReference<Map<String, List<String>>> MULTIPART_MAP_TYPE_REFERENCE = new TypeReference<Map<String, List<String>>>(){};
    private final ObjectMapperProvider objectMapperProvider;
    private final Supplier<GraphQLErrorHandler> graphQLErrorHandlerSupplier;
    private volatile ObjectMapper mapper;

    protected GraphQLObjectMapper(ObjectMapperProvider objectMapperProvider, Supplier<GraphQLErrorHandler> graphQLErrorHandlerSupplier) {
        this.objectMapperProvider = objectMapperProvider;
        this.graphQLErrorHandlerSupplier = graphQLErrorHandlerSupplier;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectMapper getJacksonMapper() {
        ObjectMapper result = this.mapper;
        if (result == null) {
            GraphQLObjectMapper graphQLObjectMapper = this;
            synchronized (graphQLObjectMapper) {
                result = this.mapper;
                if (result == null) {
                    this.mapper = result = this.objectMapperProvider.provide();
                }
            }
        }
        return result;
    }

    public ObjectReader getGraphQLRequestMapper() {
        return this.getJacksonMapper().reader().forType(GraphQLRequest.class);
    }

    public GraphQLRequest readGraphQLRequest(InputStream inputStream) throws IOException {
        return (GraphQLRequest)this.getGraphQLRequestMapper().readValue(inputStream);
    }

    public GraphQLRequest readGraphQLRequest(String text) throws IOException {
        return (GraphQLRequest)this.getGraphQLRequestMapper().readValue(text);
    }

    public List<GraphQLRequest> readBatchedGraphQLRequest(InputStream inputStream) throws IOException {
        MappingIterator iterator = this.getGraphQLRequestMapper().readValues(inputStream);
        ArrayList<GraphQLRequest> requests = new ArrayList<GraphQLRequest>();
        while (iterator.hasNext()) {
            requests.add((GraphQLRequest)iterator.next());
        }
        return requests;
    }

    public List<GraphQLRequest> readBatchedGraphQLRequest(String query) throws IOException {
        MappingIterator iterator = this.getGraphQLRequestMapper().readValues(query);
        ArrayList<GraphQLRequest> requests = new ArrayList<GraphQLRequest>();
        while (iterator.hasNext()) {
            requests.add((GraphQLRequest)iterator.next());
        }
        return requests;
    }

    public String serializeResultAsJson(ExecutionResult executionResult) {
        try {
            return this.getJacksonMapper().writeValueAsString(this.createResultFromExecutionResult(executionResult));
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public void serializeResultAsJson(Writer writer, ExecutionResult executionResult) throws IOException {
        this.getJacksonMapper().writeValue(writer, this.createResultFromExecutionResult(executionResult));
    }

    public boolean areErrorsPresent(ExecutionResult executionResult) {
        return this.graphQLErrorHandlerSupplier.get().errorsPresent(executionResult.getErrors());
    }

    public ExecutionResult sanitizeErrors(ExecutionResult executionResult) {
        Object data = executionResult.getData();
        Map extensions = executionResult.getExtensions();
        List<Object> errors = executionResult.getErrors();
        GraphQLErrorHandler errorHandler = this.graphQLErrorHandlerSupplier.get();
        errors = errorHandler.errorsPresent(errors) ? errorHandler.processErrors(errors) : null;
        return new ExecutionResultImpl(data, errors, extensions);
    }

    public Map<String, Object> createResultFromExecutionResult(ExecutionResult executionResult) {
        ExecutionResult sanitizedExecutionResult = this.sanitizeErrors(executionResult);
        if (executionResult instanceof DeferredExecutionResult) {
            sanitizedExecutionResult = DeferredExecutionResultImpl.newDeferredExecutionResult().from(executionResult).path(ExecutionPath.fromList((List)((DeferredExecutionResult)executionResult).getPath())).build();
        }
        return this.convertSanitizedExecutionResult(sanitizedExecutionResult);
    }

    public Map<String, Object> convertSanitizedExecutionResult(ExecutionResult executionResult) {
        return this.convertSanitizedExecutionResult(executionResult, true);
    }

    public Map<String, Object> convertSanitizedExecutionResult(ExecutionResult executionResult, boolean includeData) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        if (this.areErrorsPresent(executionResult)) {
            result.put("errors", executionResult.getErrors().stream().map(GraphQLError::toSpecification).collect(Collectors.toList()));
        }
        if (executionResult.getExtensions() != null && !executionResult.getExtensions().isEmpty()) {
            result.put("extensions", executionResult.getExtensions());
        }
        if (includeData) {
            result.put("data", executionResult.getData());
        }
        if (executionResult instanceof DeferredExecutionResult) {
            result.put("path", ((DeferredExecutionResult)executionResult).getPath());
        }
        return result;
    }

    public Map<String, Object> deserializeVariables(String variables) {
        try {
            return VariablesDeserializer.deserializeVariablesObject(this.getJacksonMapper().readValue(variables, Object.class), (ObjectCodec)this.getJacksonMapper());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Map<String, List<String>> deserializeMultipartMap(InputStream inputStream) {
        try {
            return (Map)this.getJacksonMapper().readValue(inputStream, MULTIPART_MAP_TYPE_REFERENCE);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static class Builder {
        private ObjectMapperProvider objectMapperProvider = new ConfiguringObjectMapperProvider();
        private Supplier<GraphQLErrorHandler> graphQLErrorHandler = DefaultGraphQLErrorHandler::new;

        public Builder withObjectMapperConfigurer(GraphQLServletObjectMapperConfigurer objectMapperConfigurer) {
            return this.withObjectMapperConfigurer(() -> objectMapperConfigurer);
        }

        public Builder withObjectMapperConfigurer(Supplier<GraphQLServletObjectMapperConfigurer> objectMapperConfigurer) {
            this.objectMapperProvider = new ConfiguringObjectMapperProvider(objectMapperConfigurer.get());
            return this;
        }

        public Builder withObjectMapperProvider(ObjectMapperProvider objectMapperProvider) {
            this.objectMapperProvider = objectMapperProvider;
            return this;
        }

        public Builder withGraphQLErrorHandler(GraphQLErrorHandler graphQLErrorHandler) {
            return this.withGraphQLErrorHandler(() -> graphQLErrorHandler);
        }

        public Builder withGraphQLErrorHandler(Supplier<GraphQLErrorHandler> graphQLErrorHandler) {
            this.graphQLErrorHandler = graphQLErrorHandler;
            return this;
        }

        public GraphQLObjectMapper build() {
            return new GraphQLObjectMapper(this.objectMapperProvider, this.graphQLErrorHandler);
        }
    }
}

