/*
 * Decompiled with CFR 0.152.
 */
package graphql.kickstart.servlet.subscriptions;

import graphql.ExecutionResult;
import graphql.kickstart.execution.GraphQLInvoker;
import graphql.kickstart.execution.GraphQLRequest;
import graphql.kickstart.execution.input.GraphQLSingleInvocationInput;
import graphql.kickstart.execution.subscriptions.GraphQLSubscriptionInvocationInputFactory;
import graphql.kickstart.execution.subscriptions.GraphQLSubscriptionMapper;
import graphql.kickstart.execution.subscriptions.SubscriptionSession;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.reactivestreams.Publisher;

public class FallbackSubscriptionConsumer
implements Consumer<String> {
    private final SubscriptionSession session;
    private final GraphQLSubscriptionMapper mapper;
    private final GraphQLSubscriptionInvocationInputFactory invocationInputFactory;
    private final GraphQLInvoker graphQLInvoker;

    @Override
    public void accept(String text) {
        CompletableFuture<ExecutionResult> executionResult = this.executeAsync(text, this.session);
        executionResult.thenAccept(result -> this.handleSubscriptionStart(this.session, UUID.randomUUID().toString(), (ExecutionResult)result));
    }

    private CompletableFuture<ExecutionResult> executeAsync(Object payload, SubscriptionSession session) {
        Objects.requireNonNull(payload, "Payload is required");
        GraphQLRequest graphQLRequest = this.mapper.readGraphQLRequest(payload);
        GraphQLSingleInvocationInput invocationInput = this.invocationInputFactory.create(graphQLRequest, session);
        return this.graphQLInvoker.executeAsync(invocationInput);
    }

    private void handleSubscriptionStart(SubscriptionSession session, String id, ExecutionResult executionResult) {
        ExecutionResult sanitizedExecutionResult = this.mapper.sanitizeErrors(executionResult);
        if (!this.mapper.areErrorsPresent(sanitizedExecutionResult)) {
            session.subscribe(id, (Publisher<ExecutionResult>)((Publisher)sanitizedExecutionResult.getData()));
        } else {
            Map<String, Object> payload = this.mapper.convertSanitizedExecutionResult(sanitizedExecutionResult);
            session.sendDataMessage(id, payload);
        }
    }

    public FallbackSubscriptionConsumer(SubscriptionSession session, GraphQLSubscriptionMapper mapper, GraphQLSubscriptionInvocationInputFactory invocationInputFactory, GraphQLInvoker graphQLInvoker) {
        this.session = session;
        this.mapper = mapper;
        this.invocationInputFactory = invocationInputFactory;
        this.graphQLInvoker = graphQLInvoker;
    }
}

