/*
 * Decompiled with CFR 0.152.
 */
package graphql.kickstart.graphql.annotations;

import graphql.annotations.AnnotationsSchemaCreator;
import graphql.annotations.annotationTypes.GraphQLField;
import graphql.annotations.annotationTypes.GraphQLTypeExtension;
import graphql.annotations.annotationTypes.directives.definition.GraphQLDirectiveDefinition;
import graphql.annotations.processor.GraphQLAnnotations;
import graphql.annotations.processor.typeFunctions.TypeFunction;
import graphql.kickstart.graphql.annotations.GraphQLAnnotationsProperties;
import graphql.kickstart.graphql.annotations.GraphQLInterfaceTypeResolver;
import graphql.kickstart.graphql.annotations.GraphQLMutationResolver;
import graphql.kickstart.graphql.annotations.GraphQLQueryResolver;
import graphql.kickstart.graphql.annotations.GraphQLScalarTypeFunction;
import graphql.kickstart.graphql.annotations.GraphQLSubscriptionResolver;
import graphql.kickstart.graphql.annotations.exceptions.MissingQueryResolverException;
import graphql.kickstart.graphql.annotations.exceptions.MultipleMutationResolversException;
import graphql.kickstart.graphql.annotations.exceptions.MultipleQueryResolversException;
import graphql.kickstart.graphql.annotations.exceptions.MultipleSubscriptionResolversException;
import graphql.relay.Relay;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLSchema;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import lombok.Generated;
import org.reflections.Reflections;
import org.reflections.ReflectionsException;
import org.reflections.scanners.MethodAnnotationsScanner;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.scanners.TypeAnnotationsScanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={GraphQLAnnotationsProperties.class})
public class GraphQLAnnotationsAutoConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GraphQLAnnotationsAutoConfiguration.class);
    private final GraphQLAnnotationsProperties graphQLAnnotationsProperties;
    private final Optional<Relay> relay;
    private final List<TypeFunction> typeFunctions;
    private final List<GraphQLScalarType> customScalarTypes;

    @Bean
    public GraphQLInterfaceTypeResolver graphQLInterfaceTypeResolver() {
        return new GraphQLInterfaceTypeResolver();
    }

    @Bean
    @ConditionalOnMissingBean
    public GraphQLAnnotations graphQLAnnotations() {
        GraphQLAnnotations graphQLAnnotations = new GraphQLAnnotations();
        if (Objects.nonNull(this.graphQLAnnotationsProperties.getInputPrefix())) {
            graphQLAnnotations.getContainer().setInputPrefix(this.graphQLAnnotationsProperties.getInputPrefix());
        }
        if (Objects.nonNull(this.graphQLAnnotationsProperties.getInputSuffix())) {
            graphQLAnnotations.getContainer().setInputSuffix(this.graphQLAnnotationsProperties.getInputSuffix());
        }
        return graphQLAnnotations;
    }

    @Bean
    public GraphQLSchema graphQLSchema(GraphQLAnnotations graphQLAnnotations) {
        log.info("Using GraphQL Annotations library to build the schema. Schema definition files will be ignored.");
        log.info("GraphQL classes are searched in the following package (including subpackages): {}", (Object)this.graphQLAnnotationsProperties.getBasePackage());
        AnnotationsSchemaCreator.Builder builder = AnnotationsSchemaCreator.newAnnotationsSchema();
        Reflections reflections = new Reflections(this.graphQLAnnotationsProperties.getBasePackage(), new Scanner[]{new MethodAnnotationsScanner(), new SubTypesScanner(), new TypeAnnotationsScanner()});
        builder.setAlwaysPrettify(Boolean.valueOf(this.graphQLAnnotationsProperties.isAlwaysPrettify()));
        this.setQueryResolverClass(builder, reflections);
        this.setMutationResolverClass(builder, reflections);
        this.setSubscriptionResolverClass(builder, reflections);
        this.getTypesAnnotatedWith(reflections, GraphQLDirectiveDefinition.class).forEach(directive -> {
            log.info("Registering directive {}", directive);
            builder.directive(directive);
        });
        this.getTypesAnnotatedWith(reflections, GraphQLTypeExtension.class).forEach(typeExtension -> {
            log.info("Registering type extension {}", typeExtension);
            builder.typeExtension(typeExtension);
        });
        this.typeFunctions.forEach(typeFunction -> {
            log.info("Registering type function {}", typeFunction.getClass());
            builder.typeFunction(typeFunction);
        });
        if (!this.customScalarTypes.isEmpty()) {
            builder.typeFunction((TypeFunction)new GraphQLScalarTypeFunction(this.customScalarTypes));
        }
        if (graphQLAnnotations.getClass().equals(GraphQLAnnotations.class)) {
            log.info("Using default GraphQL Annotation processor.");
        } else {
            log.info("Using custom annotation process of type {}", graphQLAnnotations.getClass());
        }
        builder.setAnnotationsProcessor(graphQLAnnotations);
        this.relay.ifPresent(r -> {
            log.info("Registering relay {}", r.getClass());
            builder.setRelay(r);
        });
        this.registerGraphQLInterfaceImplementations(reflections, builder);
        return builder.build();
    }

    private void setSubscriptionResolverClass(AnnotationsSchemaCreator.Builder builder, Reflections reflections) {
        Set<Class<?>> subscriptionResolvers = this.getTypesAnnotatedWith(reflections, GraphQLSubscriptionResolver.class);
        if (subscriptionResolvers.size() > 1) {
            throw new MultipleSubscriptionResolversException();
        }
        subscriptionResolvers.stream().findFirst().ifPresent(subscriptionClass -> {
            log.info("Registering subscription resolver class: {}", subscriptionClass);
            builder.subscription(subscriptionClass);
        });
    }

    private void setMutationResolverClass(AnnotationsSchemaCreator.Builder builder, Reflections reflections) {
        Set<Class<?>> mutationResolvers = this.getTypesAnnotatedWith(reflections, GraphQLMutationResolver.class);
        if (mutationResolvers.size() > 1) {
            throw new MultipleMutationResolversException();
        }
        mutationResolvers.stream().findFirst().ifPresent(mutationClass -> {
            log.info("Registering mutation resolver class: {}", mutationClass);
            builder.mutation(mutationClass);
        });
    }

    private void setQueryResolverClass(AnnotationsSchemaCreator.Builder builder, Reflections reflections) {
        Set<Class<?>> queryResolvers = this.getTypesAnnotatedWith(reflections, GraphQLQueryResolver.class);
        if (queryResolvers.isEmpty()) {
            throw new MissingQueryResolverException();
        }
        if (queryResolvers.size() > 1) {
            throw new MultipleQueryResolversException();
        }
        queryResolvers.stream().findFirst().ifPresent(queryClass -> {
            log.info("Registering query resolver class: {}", queryClass);
            builder.query(queryClass);
        });
    }

    private Set<Class<?>> getTypesAnnotatedWith(Reflections reflections, Class<? extends Annotation> annotation) {
        try {
            return reflections.getTypesAnnotatedWith(annotation);
        }
        catch (ReflectionsException e) {
            return Collections.emptySet();
        }
    }

    private void registerGraphQLInterfaceImplementations(Reflections reflections, AnnotationsSchemaCreator.Builder builder) {
        Predicate<Class> implementationQualifiesForInclusion = type -> !this.graphQLAnnotationsProperties.isIgnoreAbstractInterfaceImplementations() || !Modifier.isAbstract(type.getModifiers());
        reflections.getMethodsAnnotatedWith(GraphQLField.class).stream().map(Method::getDeclaringClass).filter(Class::isInterface).forEach(graphQLInterface -> reflections.getSubTypesOf(graphQLInterface).stream().filter(implementationQualifiesForInclusion).forEach(implementation -> {
            log.info("Registering {} as an implementation of GraphQL interface {}", implementation, graphQLInterface);
            builder.additionalType(implementation);
        }));
    }

    @Generated
    public GraphQLAnnotationsAutoConfiguration(GraphQLAnnotationsProperties graphQLAnnotationsProperties, Optional<Relay> relay, List<TypeFunction> typeFunctions, List<GraphQLScalarType> customScalarTypes) {
        this.graphQLAnnotationsProperties = graphQLAnnotationsProperties;
        this.relay = relay;
        this.typeFunctions = typeFunctions;
        this.customScalarTypes = customScalarTypes;
    }
}

