/*
 * Decompiled with CFR 0.152.
 */
package graphql.kickstart.spring;

import graphql.ExecutionResult;
import graphql.ExecutionResultImpl;
import graphql.GraphQLError;
import graphql.kickstart.execution.GraphQLObjectMapper;
import graphql.kickstart.execution.GraphQLRequest;
import graphql.kickstart.execution.error.GenericGraphQLError;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.lang.Nullable;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.server.ResponseStatusException;
import org.springframework.web.server.ServerWebExchange;

public abstract class AbstractGraphQLController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractGraphQLController.class);
    private static final String INVALID_REQUEST_BODY_MESSAGE = "Bad request - invalid request body.";
    private final GraphQLObjectMapper objectMapper;

    @PostMapping(value={"${graphql.url:graphql}"}, consumes={"*/*"}, produces={"application/json"})
    public Object graphqlPOST(@RequestHeader(value="Content-Type") MediaType contentType, @Nullable @RequestParam(value="query", required=false) String query, @Nullable @RequestParam(value="operationName", required=false) String operationName, @Nullable @RequestParam(value="variables", required=false) String variablesJson, @Nullable @RequestParam(value="extensions", required=false) String extensionsJson, @Nullable @RequestBody(required=false) String body, ServerWebExchange serverWebExchange) {
        body = Optional.ofNullable(body).orElse("");
        if (MediaType.APPLICATION_JSON.isCompatibleWith(contentType)) {
            GraphQLRequest request;
            try {
                request = this.objectMapper.readGraphQLRequest(body);
            }
            catch (IOException e) {
                return this.handleBodyParsingException(e);
            }
            if (request.getQuery() == null) {
                request.setQuery("");
            }
            return this.executeRequest(request.getQuery(), request.getOperationName(), request.getVariables(), request.getExtensions(), serverWebExchange);
        }
        if (query != null) {
            return this.executeRequest(query, operationName, this.convertVariablesJson(variablesJson), this.convertExtensionsJson(extensionsJson), serverWebExchange);
        }
        if ("application/graphql".equals(contentType.toString()) || "application/graphql; charset=utf-8".equals(contentType.toString())) {
            return this.executeRequest(body, null, Collections.emptyMap(), Collections.emptyMap(), serverWebExchange);
        }
        throw new ResponseStatusException(HttpStatus.UNPROCESSABLE_ENTITY, "Could not process GraphQL request");
    }

    @GetMapping(value={"${graphql.url:graphql}"}, produces={"application/json"})
    public Object graphqlGET(@Nullable @RequestParam(value="query") String query, @Nullable @RequestParam(value="operationName", required=false) String operationName, @Nullable @RequestParam(value="variables", required=false) String variablesJson, @Nullable @RequestParam(value="extensions", required=false) String extensionsJson, ServerWebExchange serverWebExchange) {
        return this.executeRequest(query == null ? "" : query, operationName, this.convertVariablesJson(variablesJson), this.convertExtensionsJson(extensionsJson), serverWebExchange);
    }

    private Map<String, Object> convertVariablesJson(String jsonMap) {
        return Optional.ofNullable(jsonMap).map(arg_0 -> ((GraphQLObjectMapper)this.objectMapper).deserializeVariables(arg_0)).orElseGet(Collections::emptyMap);
    }

    private Map<String, Object> convertExtensionsJson(String jsonMap) {
        return Optional.ofNullable(jsonMap).map(arg_0 -> ((GraphQLObjectMapper)this.objectMapper).deserializeExtensions(arg_0)).orElseGet(Collections::emptyMap);
    }

    protected abstract Object executeRequest(String var1, String var2, Map<String, Object> var3, Map<String, Object> var4, ServerWebExchange var5);

    protected Object handleBodyParsingException(Exception exception) {
        log.error("{} {}", (Object)INVALID_REQUEST_BODY_MESSAGE, (Object)exception.getMessage());
        return this.objectMapper.createResultFromExecutionResult((ExecutionResult)new ExecutionResultImpl((GraphQLError)new GenericGraphQLError(INVALID_REQUEST_BODY_MESSAGE)));
    }

    @Generated
    public AbstractGraphQLController(GraphQLObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }
}

