/*
 * Decompiled with CFR 0.152.
 */
package graphql.kickstart.spring.cache;

import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import lombok.Generated;
import org.dataloader.ValueCache;
import org.springframework.cache.Cache;

public class SpringValueCache<K, V>
implements ValueCache<K, V> {
    private final Cache cache;
    private Function<K, ?> keyTransformer;

    public CompletableFuture<V> get(K key) {
        return CompletableFuture.supplyAsync(() -> {
            Object finalKey = this.getKey(key);
            Cache.ValueWrapper valueWrapper = this.cache.get(finalKey);
            if (valueWrapper == null) {
                throw new CacheEntryNotFoundException(this.cache.getName(), finalKey);
            }
            return valueWrapper.get();
        });
    }

    public CompletableFuture<V> set(K key, V value) {
        return CompletableFuture.supplyAsync(() -> {
            this.cache.put(this.getKey(key), value);
            return value;
        });
    }

    public CompletableFuture<Void> delete(K key) {
        return CompletableFuture.runAsync(() -> this.cache.evictIfPresent(this.getKey(key)));
    }

    public CompletableFuture<Void> clear() {
        return CompletableFuture.runAsync(() -> ((Cache)this.cache).invalidate());
    }

    public <KFinal> SpringValueCache<K, V> setKeyTransformer(Function<K, KFinal> transformer) {
        this.keyTransformer = transformer;
        return this;
    }

    private Object getKey(K key) {
        return this.keyTransformer == null ? key : this.keyTransformer.apply(key);
    }

    @Generated
    public SpringValueCache(Cache cache) {
        this.cache = cache;
    }

    public static class CacheEntryNotFoundException
    extends RuntimeException {
        public CacheEntryNotFoundException(String cacheName, Object key) {
            super("Entry could not be found in cache named \"" + cacheName + "\" for key: " + key);
        }
    }
}

