/*
 * Decompiled with CFR 0.152.
 */
package graphql.kickstart.spring.error;

import graphql.ExceptionWhileDataFetching;
import graphql.GraphQLError;
import graphql.GraphQLException;
import graphql.SerializationError;
import graphql.kickstart.execution.error.DefaultGraphQLErrorHandler;
import graphql.kickstart.execution.error.GenericGraphQLError;
import graphql.kickstart.spring.error.GraphQLErrorFactory;
import graphql.kickstart.spring.error.ThrowableComparator;
import graphql.kickstart.spring.error.ThrowableGraphQLError;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GraphQLErrorFromExceptionHandler
extends DefaultGraphQLErrorHandler {
    private static final Logger log = LoggerFactory.getLogger(GraphQLErrorFromExceptionHandler.class);
    private List<GraphQLErrorFactory> factories;

    GraphQLErrorFromExceptionHandler(List<GraphQLErrorFactory> factories) {
        this.factories = factories;
    }

    protected List<GraphQLError> filterGraphQLErrors(List<GraphQLError> errors) {
        return errors.stream().map(this::transform).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private Collection<GraphQLError> transform(GraphQLError error) {
        return this.extractException(error).map(this::transform).orElse(Collections.singletonList(new GenericGraphQLError(error.getMessage())));
    }

    private Optional<Throwable> extractException(GraphQLError error) {
        if (error instanceof ExceptionWhileDataFetching) {
            return Optional.of(((ExceptionWhileDataFetching)error).getException());
        }
        if (error instanceof SerializationError) {
            return Optional.of(((SerializationError)error).getException());
        }
        if (error instanceof GraphQLException) {
            return Optional.of((GraphQLException)error);
        }
        return Optional.empty();
    }

    private Collection<GraphQLError> transform(Throwable throwable) {
        HashMap applicables = new HashMap();
        this.factories.forEach(factory -> factory.mostConcrete(throwable).ifPresent(t -> applicables.put(t, factory)));
        return applicables.keySet().stream().min(new ThrowableComparator()).map(applicables::get).map(factory -> factory.create(throwable)).orElse(Collections.singletonList(new ThrowableGraphQLError(throwable)));
    }

    public List<GraphQLErrorFactory> getFactories() {
        return this.factories;
    }
}

