/*
 * Decompiled with CFR 0.152.
 */
package graphql.kickstart.spring;

import graphql.kickstart.execution.GraphQLObjectMapper;
import graphql.kickstart.execution.GraphQLRequest;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.server.ResponseStatusException;
import org.springframework.web.server.ServerWebExchange;

public abstract class AbstractGraphQLController {
    private final GraphQLObjectMapper objectMapper;

    @RequestMapping(value={"${graphql.url:graphql}"}, method={RequestMethod.POST}, produces={"application/json"})
    public Object graphqlPOST(@RequestHeader(value="Content-Type", required=false) String contentType, @RequestParam(value="query", required=false) String query, @RequestParam(value="operationName", required=false) String operationName, @RequestParam(value="variables", required=false) String variablesJson, @RequestBody(required=false) String body, ServerWebExchange serverWebExchange) throws IOException {
        if (body == null) {
            body = "";
        }
        if ("application/json".equals(contentType)) {
            GraphQLRequest request = this.objectMapper.readGraphQLRequest(body);
            if (request.getQuery() == null) {
                request.setQuery("");
            }
            return this.executeRequest(request.getQuery(), request.getOperationName(), request.getVariables(), serverWebExchange);
        }
        if (query != null) {
            return this.executeRequest(query, operationName, this.convertVariablesJson(variablesJson), serverWebExchange);
        }
        if ("application/graphql".equals(contentType)) {
            return this.executeRequest(body, null, null, serverWebExchange);
        }
        throw new ResponseStatusException(HttpStatus.UNPROCESSABLE_ENTITY, "Could not process GraphQL request");
    }

    @RequestMapping(value={"${graphql.url:graphql}"}, method={RequestMethod.GET}, produces={"application/json"})
    public Object graphqlGET(@RequestParam(value="query") String query, @RequestParam(value="operationName", required=false) String operationName, @RequestParam(value="variables", required=false) String variablesJson, ServerWebExchange serverWebExchange) {
        return this.executeRequest(query, operationName, this.convertVariablesJson(variablesJson), serverWebExchange);
    }

    private Map<String, Object> convertVariablesJson(String jsonMap) {
        if (jsonMap == null) {
            return Collections.emptyMap();
        }
        return this.objectMapper.deserializeVariables(jsonMap);
    }

    protected abstract Object executeRequest(String var1, String var2, Map<String, Object> var3, ServerWebExchange var4);

    public AbstractGraphQLController(GraphQLObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }
}

