/*
 * Decompiled with CFR 0.152.
 */
package graphql.kickstart.spring.error;

import graphql.kickstart.execution.error.GraphQLErrorHandler;
import graphql.kickstart.spring.error.ErrorHandlerSupplier;
import graphql.kickstart.spring.error.GraphQLErrorHandlerFactory;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.lang.NonNull;

public class GraphQLErrorStartupListener
implements ApplicationListener<ApplicationReadyEvent> {
    private final ErrorHandlerSupplier errorHandlerSupplier;
    private final boolean exceptionHandlersEnabled;

    public GraphQLErrorStartupListener(ErrorHandlerSupplier errorHandlerSupplier, boolean exceptionHandlersEnabled) {
        this.errorHandlerSupplier = errorHandlerSupplier;
        this.exceptionHandlersEnabled = exceptionHandlersEnabled;
    }

    public void onApplicationEvent(@NonNull ApplicationReadyEvent event) {
        ConfigurableApplicationContext context = event.getApplicationContext();
        GraphQLErrorHandler errorHandler = new GraphQLErrorHandlerFactory().create(context, this.exceptionHandlersEnabled);
        context.getBeanFactory().registerSingleton(errorHandler.getClass().getCanonicalName(), (Object)errorHandler);
        this.errorHandlerSupplier.setErrorHandler(errorHandler);
    }
}

