/*
 * Decompiled with CFR 0.152.
 */
package graphql.kickstart.spring.webflux;

import graphql.kickstart.execution.GraphQLInvoker;
import graphql.kickstart.execution.GraphQLObjectMapper;
import graphql.kickstart.execution.GraphQLRequest;
import graphql.kickstart.execution.input.GraphQLSingleInvocationInput;
import graphql.kickstart.spring.AbstractGraphQLController;
import graphql.kickstart.spring.GraphQLSpringInvocationInputFactory;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

@RestController
public class GraphQLController
extends AbstractGraphQLController {
    private final GraphQLObjectMapper objectMapper;
    private final GraphQLInvoker graphQLInvoker;
    private final GraphQLSpringInvocationInputFactory invocationInputFactory;

    public GraphQLController(GraphQLObjectMapper objectMapper, GraphQLInvoker graphQLInvoker, GraphQLSpringInvocationInputFactory invocationInputFactory) {
        super(objectMapper);
        this.objectMapper = objectMapper;
        this.graphQLInvoker = graphQLInvoker;
        this.invocationInputFactory = invocationInputFactory;
    }

    protected Object executeRequest(String query, String operationName, Map<String, Object> variables, Map<String, Object> extensions, ServerWebExchange serverWebExchange) {
        GraphQLSingleInvocationInput invocationInput = this.invocationInputFactory.create(new GraphQLRequest(query, variables, extensions, operationName), serverWebExchange);
        Mono executionResult = Mono.fromCompletionStage((CompletionStage)this.graphQLInvoker.executeAsync(invocationInput));
        return executionResult.map(arg_0 -> ((GraphQLObjectMapper)this.objectMapper).createResultFromExecutionResult(arg_0));
    }
}

