/*
Viz.js 2.0.0 (Graphviz 2.40.1, Expat 2.2.5, Emscripten 1.37.36)
*/
(function(global) {
  var Module = function(Module) {
    Module = Module || {}
    var Module = typeof Module !== "undefined" ? Module : {}
    var moduleOverrides = {}
    var key
    for (key in Module) {
      if (Module.hasOwnProperty(key)) {
        moduleOverrides[key] = Module[key]
      }
    }
    Module["arguments"] = []
    Module["thisProgram"] = "./this.program"
    Module["quit"] = (function(status, toThrow) {
      throw toThrow
    })
    Module["preRun"] = []
    Module["postRun"] = []
    var ENVIRONMENT_IS_WEB = false
    var ENVIRONMENT_IS_WORKER = false
    var ENVIRONMENT_IS_NODE = false
    var ENVIRONMENT_IS_SHELL = false
    if (Module["ENVIRONMENT"]) {
      if (Module["ENVIRONMENT"] === "WEB") {
        ENVIRONMENT_IS_WEB = true
      } else if (Module["ENVIRONMENT"] === "WORKER") {
        ENVIRONMENT_IS_WORKER = true
      } else if (Module["ENVIRONMENT"] === "NODE") {
        ENVIRONMENT_IS_NODE = true
      } else if (Module["ENVIRONMENT"] === "SHELL") {
        ENVIRONMENT_IS_SHELL = true
      } else {
        throw new Error("Module['ENVIRONMENT'] value is not valid. must be one of: WEB|WORKER|NODE|SHELL.")
      }
    } else {
      ENVIRONMENT_IS_WEB = typeof window === "object"
      ENVIRONMENT_IS_WORKER = typeof importScripts === "function"
      ENVIRONMENT_IS_NODE = typeof process === "object" && typeof require === "function" && !ENVIRONMENT_IS_WEB
          && !ENVIRONMENT_IS_WORKER
      ENVIRONMENT_IS_SHELL = !ENVIRONMENT_IS_WEB && !ENVIRONMENT_IS_NODE && !ENVIRONMENT_IS_WORKER
    }
    if (ENVIRONMENT_IS_NODE) {
      var nodeFS
      var nodePath
      Module["read"] = function shell_read(filename, binary) {
        var ret
        ret = tryParseAsDataURI(filename)
        if (!ret) {
          if (!nodeFS) {
            nodeFS = require("fs")
          }
          if (!nodePath) {
            nodePath = require("path")
          }
          filename = nodePath["normalize"](filename)
          ret = nodeFS["readFileSync"](filename)
        }
        return binary ? ret : ret.toString()
      }
      Module["readBinary"] = function readBinary(filename) {
        var ret = Module["read"](filename, true)
        if (!ret.buffer) {
          ret = new Uint8Array(ret)
        }
        assert(ret.buffer)
        return ret
      }
      if (process["argv"].length > 1) {
        Module["thisProgram"] = process["argv"][1].replace(/\\/g, "/")
      }
      Module["arguments"] = process["argv"].slice(2)
      if (typeof module !== "undefined") {
        module["exports"] = Module
      }
      process["on"]("uncaughtException", (function(ex) {
        if (!(ex instanceof ExitStatus)) {
          throw ex
        }
      }))
      process["on"]("unhandledRejection", (function(reason, p) {
        process["exit"](1)
      }))
      Module["inspect"] = (function() {
        return "[Emscripten Module object]"
      })
    } else if (ENVIRONMENT_IS_SHELL) {
      if (typeof read != "undefined") {
        Module["read"] = function shell_read(f) {
          var data = tryParseAsDataURI(f)
          if (data) {
            return intArrayToString(data)
          }
          return read(f)
        }
      }
      Module["readBinary"] = function readBinary(f) {
        var data
        data = tryParseAsDataURI(f)
        if (data) {
          return data
        }
        if (typeof readbuffer === "function") {
          return new Uint8Array(readbuffer(f))
        }
        data = read(f, "binary")
        assert(typeof data === "object")
        return data
      }
      if (typeof scriptArgs != "undefined") {
        Module["arguments"] = scriptArgs
      } else if (typeof arguments != "undefined") {
        Module["arguments"] = arguments
      }
      if (typeof quit === "function") {
        Module["quit"] = (function(status, toThrow) {
          quit(status)
        })
      }
    } else if (ENVIRONMENT_IS_WEB || ENVIRONMENT_IS_WORKER) {
      Module["read"] = function shell_read(url) {
        try {
          var xhr = new XMLHttpRequest
          xhr.open("GET", url, false)
          xhr.send(null)
          return xhr.responseText
        } catch (err) {
          var data = tryParseAsDataURI(url)
          if (data) {
            return intArrayToString(data)
          }
          throw err
        }
      }
      if (ENVIRONMENT_IS_WORKER) {
        Module["readBinary"] = function readBinary(url) {
          try {
            var xhr = new XMLHttpRequest
            xhr.open("GET", url, false)
            xhr.responseType = "arraybuffer"
            xhr.send(null)
            return new Uint8Array(xhr.response)
          } catch (err) {
            var data = tryParseAsDataURI(url)
            if (data) {
              return data
            }
            throw err
          }
        }
      }
      Module["readAsync"] = function readAsync(url, onload, onerror) {
        var xhr = new XMLHttpRequest
        xhr.open("GET", url, true)
        xhr.responseType = "arraybuffer"
        xhr.onload = function xhr_onload() {
          if (xhr.status == 200 || xhr.status == 0 && xhr.response) {
            onload(xhr.response)
            return
          }
          var data = tryParseAsDataURI(url)
          if (data) {
            onload(data.buffer)
            return
          }
          onerror()
        }
        xhr.onerror = onerror
        xhr.send(null)
      }
      if (typeof arguments != "undefined") {
        Module["arguments"] = arguments
      }
      Module["setWindowTitle"] = (function(title) {
        document.title = title
      })
    }
    Module["print"] = typeof console !== "undefined" ? console.log.bind(console) : typeof print !== "undefined" ? print
        : null
    Module["printErr"] = typeof printErr !== "undefined" ? printErr : typeof console !== "undefined"
        && console.warn.bind(console) || Module["print"]
    Module.print = Module["print"]
    Module.printErr = Module["printErr"]
    for (key in moduleOverrides) {
      if (moduleOverrides.hasOwnProperty(key)) {
        Module[key] = moduleOverrides[key]
      }
    }
    moduleOverrides = undefined
    var STACK_ALIGN = 16

    function staticAlloc(size) {
      assert(!staticSealed)
      var ret = STATICTOP
      STATICTOP = STATICTOP + size + 15 & -16
      return ret
    }

    function dynamicAlloc(size) {
      assert(DYNAMICTOP_PTR)
      var ret = HEAP32[DYNAMICTOP_PTR >> 2]
      var end = ret + size + 15 & -16
      HEAP32[DYNAMICTOP_PTR >> 2] = end
      if (end >= TOTAL_MEMORY) {
        var success = enlargeMemory()
        if (!success) {
          HEAP32[DYNAMICTOP_PTR >> 2] = ret
          return 0
        }
      }
      return ret
    }

    function alignMemory(size, factor) {
      if (!factor) {
        factor = STACK_ALIGN
      }
      var ret = size = Math.ceil(size / factor) * factor
      return ret
    }

    function getNativeTypeSize(type) {
      switch (type) {
        case"i1":
        case"i8":
          return 1
        case"i16":
          return 2
        case"i32":
          return 4
        case"i64":
          return 8
        case"float":
          return 4
        case"double":
          return 8
        default: {
          if (type[type.length - 1] === "*") {
            return 4
          } else if (type[0] === "i") {
            var bits = parseInt(type.substr(1))
            assert(bits % 8 === 0)
            return bits / 8
          } else {
            return 0
          }
        }
      }
    }

    function warnOnce(text) {
      if (!warnOnce.shown) {
        warnOnce.shown = {}
      }
      if (!warnOnce.shown[text]) {
        warnOnce.shown[text] = 1
        Module.printErr(text)
      }
    }

    var jsCallStartIndex = 1
    var functionPointers = new Array(0)
    var funcWrappers = {}

    function dynCall(sig, ptr, args) {
      if (args && args.length) {
        return Module["dynCall_" + sig].apply(null, [ptr].concat(args))
      } else {
        return Module["dynCall_" + sig].call(null, ptr)
      }
    }

    var GLOBAL_BASE = 8
    var ABORT = 0
    var EXITSTATUS = 0

    function assert(condition, text) {
      if (!condition) {
        abort("Assertion failed: " + text)
      }
    }

    function getCFunc(ident) {
      var func = Module["_" + ident]
      assert(func, "Cannot call unknown function " + ident + ", make sure it is exported")
      return func
    }

    var JSfuncs = {
      "stackSave": (function() {
        stackSave()
      }), "stackRestore": (function() {
        stackRestore()
      }), "arrayToC": (function(arr) {
        var ret = stackAlloc(arr.length)
        writeArrayToMemory(arr, ret)
        return ret
      }), "stringToC": (function(str) {
        var ret = 0
        if (str !== null && str !== undefined && str !== 0) {
          var len = (str.length << 2) + 1
          ret = stackAlloc(len)
          stringToUTF8(str, ret, len)
        }
        return ret
      })
    }
    var toC = { "string": JSfuncs["stringToC"], "array": JSfuncs["arrayToC"] }

    function ccall(ident, returnType, argTypes, args, opts) {
      var func = getCFunc(ident)
      var cArgs = []
      var stack = 0
      if (args) {
        for (var i = 0; i < args.length; i++) {
          var converter = toC[argTypes[i]]
          if (converter) {
            if (stack === 0) {
              stack = stackSave()
            }
            cArgs[i] = converter(args[i])
          } else {
            cArgs[i] = args[i]
          }
        }
      }
      var ret = func.apply(null, cArgs)
      if (returnType === "string") {
        ret = Pointer_stringify(ret)
      }
      if (stack !== 0) {
        stackRestore(stack)
      }
      return ret
    }

    function setValue(ptr, value, type, noSafe) {
      type = type || "i8"
      if (type.charAt(type.length - 1) === "*") {
        type = "i32"
      }
      switch (type) {
        case"i1":
          HEAP8[ptr >> 0] = value
          break
        case"i8":
          HEAP8[ptr >> 0] = value
          break
        case"i16":
          HEAP16[ptr >> 1] = value
          break
        case"i32":
          HEAP32[ptr >> 2] = value
          break
        case"i64":
          tempI64 = [value >>> 0, (tempDouble = value, +Math_abs(tempDouble) >= +1 ? tempDouble > +0 ? (Math_min(
              +Math_floor(tempDouble / +4294967296), +4294967295) | 0) >>> 0 : ~~+Math_ceil(
              (tempDouble - +(~~tempDouble >>> 0)) / +4294967296) >>> 0 : 0)], HEAP32[ptr >> 2] = tempI64[0], HEAP32[ptr
          + 4 >> 2] = tempI64[1]
          break
        case"float":
          HEAPF32[ptr >> 2] = value
          break
        case"double":
          HEAPF64[ptr >> 3] = value
          break
        default:
          abort("invalid type for setValue: " + type)
      }
    }

    var ALLOC_STATIC = 2
    var ALLOC_NONE = 4

    function allocate(slab, types, allocator, ptr) {
      var zeroinit, size
      if (typeof slab === "number") {
        zeroinit = true
        size = slab
      } else {
        zeroinit = false
        size = slab.length
      }
      var singleType = typeof types === "string" ? types : null
      var ret
      if (allocator == ALLOC_NONE) {
        ret = ptr
      } else {
        ret = [typeof _malloc === "function" ? _malloc : staticAlloc, stackAlloc, staticAlloc, dynamicAlloc][allocator
        === undefined ? ALLOC_STATIC : allocator](Math.max(size, singleType ? 1 : types.length))
      }
      if (zeroinit) {
        var stop
        ptr = ret
        assert((ret & 3) == 0)
        stop = ret + (size & ~3)
        for (; ptr < stop; ptr += 4) {
          HEAP32[ptr >> 2] = 0
        }
        stop = ret + size
        while (ptr < stop) {
          HEAP8[ptr++ >> 0] = 0
        }
        return ret
      }
      if (singleType === "i8") {
        if (slab.subarray || slab.slice) {
          HEAPU8.set(slab, ret)
        } else {
          HEAPU8.set(new Uint8Array(slab), ret)
        }
        return ret
      }
      var i = 0, type, typeSize, previousType
      while (i < size) {
        var curr = slab[i]
        type = singleType || types[i]
        if (type === 0) {
          i++
          continue
        }
        if (type == "i64") {
          type = "i32"
        }
        setValue(ret + i, curr, type)
        if (previousType !== type) {
          typeSize = getNativeTypeSize(type)
          previousType = type
        }
        i += typeSize
      }
      return ret
    }

    function Pointer_stringify(ptr, length) {
      if (length === 0 || !ptr) {
        return ""
      }
      var hasUtf = 0
      var t
      var i = 0
      while (1) {
        t = HEAPU8[ptr + i >> 0]
        hasUtf |= t
        if (t == 0 && !length) {
          break
        }
        i++
        if (length && i == length) {
          break
        }
      }
      if (!length) {
        length = i
      }
      var ret = ""
      if (hasUtf < 128) {
        var MAX_CHUNK = 1024
        var curr
        while (length > 0) {
          curr = String.fromCharCode.apply(String, HEAPU8.subarray(ptr, ptr + Math.min(length, MAX_CHUNK)))
          ret = ret ? ret + curr : curr
          ptr += MAX_CHUNK
          length -= MAX_CHUNK
        }
        return ret
      }
      return UTF8ToString(ptr)
    }

    var UTF8Decoder = typeof TextDecoder !== "undefined" ? new TextDecoder("utf8") : undefined

    function UTF8ArrayToString(u8Array, idx) {
      var endPtr = idx
      while (u8Array[endPtr]) {
        ++endPtr
      }
      if (endPtr - idx > 16 && u8Array.subarray && UTF8Decoder) {
        return UTF8Decoder.decode(u8Array.subarray(idx, endPtr))
      } else {
        var u0, u1, u2, u3, u4, u5
        var str = ""
        while (1) {
          u0 = u8Array[idx++]
          if (!u0) {
            return str
          }
          if (!(u0 & 128)) {
            str += String.fromCharCode(u0)
            continue
          }
          u1 = u8Array[idx++] & 63
          if ((u0 & 224) == 192) {
            str += String.fromCharCode((u0 & 31) << 6 | u1)
            continue
          }
          u2 = u8Array[idx++] & 63
          if ((u0 & 240) == 224) {
            u0 = (u0 & 15) << 12 | u1 << 6 | u2
          } else {
            u3 = u8Array[idx++] & 63
            if ((u0 & 248) == 240) {
              u0 = (u0 & 7) << 18 | u1 << 12 | u2 << 6 | u3
            } else {
              u4 = u8Array[idx++] & 63
              if ((u0 & 252) == 248) {
                u0 = (u0 & 3) << 24 | u1 << 18 | u2 << 12 | u3 << 6 | u4
              } else {
                u5 = u8Array[idx++] & 63
                u0 = (u0 & 1) << 30 | u1 << 24 | u2 << 18 | u3 << 12 | u4 << 6 | u5
              }
            }
          }
          if (u0 < 65536) {
            str += String.fromCharCode(u0)
          } else {
            var ch = u0 - 65536
            str += String.fromCharCode(55296 | ch >> 10, 56320 | ch & 1023)
          }
        }
      }
    }

    function UTF8ToString(ptr) {
      return UTF8ArrayToString(HEAPU8, ptr)
    }

    function stringToUTF8Array(str, outU8Array, outIdx, maxBytesToWrite) {
      if (!(maxBytesToWrite > 0)) {
        return 0
      }
      var startIdx = outIdx
      var endIdx = outIdx + maxBytesToWrite - 1
      for (var i = 0; i < str.length; ++i) {
        var u = str.charCodeAt(i)
        if (u >= 55296 && u <= 57343) {
          u = 65536 + ((u & 1023) << 10) | str.charCodeAt(++i) & 1023
        }
        if (u <= 127) {
          if (outIdx >= endIdx) {
            break
          }
          outU8Array[outIdx++] = u
        } else if (u <= 2047) {
          if (outIdx + 1 >= endIdx) {
            break
          }
          outU8Array[outIdx++] = 192 | u >> 6
          outU8Array[outIdx++] = 128 | u & 63
        } else if (u <= 65535) {
          if (outIdx + 2 >= endIdx) {
            break
          }
          outU8Array[outIdx++] = 224 | u >> 12
          outU8Array[outIdx++] = 128 | u >> 6 & 63
          outU8Array[outIdx++] = 128 | u & 63
        } else if (u <= 2097151) {
          if (outIdx + 3 >= endIdx) {
            break
          }
          outU8Array[outIdx++] = 240 | u >> 18
          outU8Array[outIdx++] = 128 | u >> 12 & 63
          outU8Array[outIdx++] = 128 | u >> 6 & 63
          outU8Array[outIdx++] = 128 | u & 63
        } else if (u <= 67108863) {
          if (outIdx + 4 >= endIdx) {
            break
          }
          outU8Array[outIdx++] = 248 | u >> 24
          outU8Array[outIdx++] = 128 | u >> 18 & 63
          outU8Array[outIdx++] = 128 | u >> 12 & 63
          outU8Array[outIdx++] = 128 | u >> 6 & 63
          outU8Array[outIdx++] = 128 | u & 63
        } else {
          if (outIdx + 5 >= endIdx) {
            break
          }
          outU8Array[outIdx++] = 252 | u >> 30
          outU8Array[outIdx++] = 128 | u >> 24 & 63
          outU8Array[outIdx++] = 128 | u >> 18 & 63
          outU8Array[outIdx++] = 128 | u >> 12 & 63
          outU8Array[outIdx++] = 128 | u >> 6 & 63
          outU8Array[outIdx++] = 128 | u & 63
        }
      }
      outU8Array[outIdx] = 0
      return outIdx - startIdx
    }

    function stringToUTF8(str, outPtr, maxBytesToWrite) {
      return stringToUTF8Array(str, HEAPU8, outPtr, maxBytesToWrite)
    }

    function lengthBytesUTF8(str) {
      var len = 0
      for (var i = 0; i < str.length; ++i) {
        var u = str.charCodeAt(i)
        if (u >= 55296 && u <= 57343) {
          u = 65536 + ((u & 1023) << 10) | str.charCodeAt(++i) & 1023
        }
        if (u <= 127) {
          ++len
        } else if (u <= 2047) {
          len += 2
        } else if (u <= 65535) {
          len += 3
        } else if (u <= 2097151) {
          len += 4
        } else if (u <= 67108863) {
          len += 5
        } else {
          len += 6
        }
      }
      return len
    }

    var UTF16Decoder = typeof TextDecoder !== "undefined" ? new TextDecoder("utf-16le") : undefined

    function allocateUTF8(str) {
      var size = lengthBytesUTF8(str) + 1
      var ret = _malloc(size)
      if (ret) {
        stringToUTF8Array(str, HEAP8, ret, size)
      }
      return ret
    }

    function demangle(func) {
      return func
    }

    function demangleAll(text) {
      var regex = /__Z[\w\d_]+/g
      return text.replace(regex, (function(x) {
        var y = demangle(x)
        return x === y ? x : x + " [" + y + "]"
      }))
    }

    function jsStackTrace() {
      var err = new Error
      if (!err.stack) {
        try {
          throw new Error(0)
        } catch (e) {
          err = e
        }
        if (!err.stack) {
          return "(no stack trace available)"
        }
      }
      return err.stack.toString()
    }

    function stackTrace() {
      var js = jsStackTrace()
      if (Module["extraStackTrace"]) {
        js += "\n" + Module["extraStackTrace"]()
      }
      return demangleAll(js)
    }

    var PAGE_SIZE = 16384
    var buffer, HEAP8, HEAPU8, HEAP16, HEAPU16, HEAP32, HEAPU32, HEAPF32, HEAPF64

    function updateGlobalBufferViews() {
      Module["HEAP8"] = HEAP8 = new Int8Array(buffer)
      Module["HEAP16"] = HEAP16 = new Int16Array(buffer)
      Module["HEAP32"] = HEAP32 = new Int32Array(buffer)
      Module["HEAPU8"] = HEAPU8 = new Uint8Array(buffer)
      Module["HEAPU16"] = HEAPU16 = new Uint16Array(buffer)
      Module["HEAPU32"] = HEAPU32 = new Uint32Array(buffer)
      Module["HEAPF32"] = HEAPF32 = new Float32Array(buffer)
      Module["HEAPF64"] = HEAPF64 = new Float64Array(buffer)
    }

    var STATIC_BASE, STATICTOP, staticSealed
    var STACK_BASE, STACKTOP, STACK_MAX
    var DYNAMIC_BASE, DYNAMICTOP_PTR
    STATIC_BASE = STATICTOP = STACK_BASE = STACKTOP = STACK_MAX = DYNAMIC_BASE = DYNAMICTOP_PTR = 0
    staticSealed = false

    function abortOnCannotGrowMemory() {
      abort(
          "Cannot enlarge memory arrays. Either (1) compile with  -s TOTAL_MEMORY=X  with X higher than the current value "
          + TOTAL_MEMORY
          + ", (2) compile with  -s ALLOW_MEMORY_GROWTH=1  which allows increasing the size at runtime but prevents some optimizations, (3) set Module.TOTAL_MEMORY to a higher value before the program runs, or (4) if you want malloc to return NULL (0) instead of this abort, compile with  -s ABORTING_MALLOC=0 ")
    }

    function enlargeMemory() {
      abortOnCannotGrowMemory()
    }

    var TOTAL_STACK = Module["TOTAL_STACK"] || 5242880
    var TOTAL_MEMORY = Module["TOTAL_MEMORY"] || 16777216
    if (TOTAL_MEMORY < TOTAL_STACK) {
      Module.printErr(
          "TOTAL_MEMORY should be larger than TOTAL_STACK, was " + TOTAL_MEMORY + "! (TOTAL_STACK=" + TOTAL_STACK
          + ")")
    }
    if (Module["buffer"]) {
      buffer = Module["buffer"]
    } else {
      {
        buffer = new ArrayBuffer(TOTAL_MEMORY)
      }
      Module["buffer"] = buffer
    }
    updateGlobalBufferViews()

    function getTotalMemory() {
      return TOTAL_MEMORY
    }

    HEAP32[0] = 1668509029
    HEAP16[1] = 25459
    if (HEAPU8[2] !== 115 || HEAPU8[3] !== 99) {
      throw"Runtime error: expected the system to be little-endian!"
    }

    function callRuntimeCallbacks(callbacks) {
      while (callbacks.length > 0) {
        var callback = callbacks.shift()
        if (typeof callback == "function") {
          callback()
          continue
        }
        var func = callback.func
        if (typeof func === "number") {
          if (callback.arg === undefined) {
            Module["dynCall_v"](func)
          } else {
            Module["dynCall_vi"](func, callback.arg)
          }
        } else {
          func(callback.arg === undefined ? null : callback.arg)
        }
      }
    }

    var __ATPRERUN__ = []
    var __ATINIT__ = []
    var __ATMAIN__ = []
    var __ATEXIT__ = []
    var __ATPOSTRUN__ = []
    var runtimeInitialized = false
    var runtimeExited = false

    function preRun() {
      if (Module["preRun"]) {
        if (typeof Module["preRun"] == "function") {
          Module["preRun"] = [Module["preRun"]]
        }
        while (Module["preRun"].length) {
          addOnPreRun(Module["preRun"].shift())
        }
      }
      callRuntimeCallbacks(__ATPRERUN__)
    }

    function ensureInitRuntime() {
      if (runtimeInitialized) {
        return
      }
      runtimeInitialized = true
      callRuntimeCallbacks(__ATINIT__)
    }

    function preMain() {
      callRuntimeCallbacks(__ATMAIN__)
    }

    function exitRuntime() {
      callRuntimeCallbacks(__ATEXIT__)
      runtimeExited = true
    }

    function postRun() {
      if (Module["postRun"]) {
        if (typeof Module["postRun"] == "function") {
          Module["postRun"] = [Module["postRun"]]
        }
        while (Module["postRun"].length) {
          addOnPostRun(Module["postRun"].shift())
        }
      }
      callRuntimeCallbacks(__ATPOSTRUN__)
    }

    function addOnPreRun(cb) {
      __ATPRERUN__.unshift(cb)
    }

    function addOnPostRun(cb) {
      __ATPOSTRUN__.unshift(cb)
    }

    function writeArrayToMemory(array, buffer) {
      HEAP8.set(array, buffer)
    }

    function writeAsciiToMemory(str, buffer, dontAddNull) {
      for (var i = 0; i < str.length; ++i) {
        HEAP8[buffer++ >> 0] = str.charCodeAt(i)
      }
      if (!dontAddNull) {
        HEAP8[buffer >> 0] = 0
      }
    }

    if (!Math["imul"] || Math["imul"](4294967295, 5) !== -5) {
      Math["imul"] = function imul(a, b) {
        var ah = a >>> 16
        var al = a & 65535
        var bh = b >>> 16
        var bl = b & 65535
        return al * bl + (ah * bl + al * bh << 16) | 0
      }
    }
    Math.imul = Math["imul"]
    if (!Math["clz32"]) {
      Math["clz32"] = (function(x) {
        x = x >>> 0
        for (var i = 0; i < 32; i++) {
          if (x & 1 << 31 - i) {
            return i
          }
        }
        return 32
      })
    }
    Math.clz32 = Math["clz32"]
    if (!Math["trunc"]) {
      Math["trunc"] = (function(x) {
        return x < 0 ? Math.ceil(x) : Math.floor(x)
      })
    }
    Math.trunc = Math["trunc"]
    var Math_abs = Math.abs
    var Math_cos = Math.cos
    var Math_sin = Math.sin
    var Math_tan = Math.tan
    var Math_acos = Math.acos
    var Math_asin = Math.asin
    var Math_atan = Math.atan
    var Math_atan2 = Math.atan2
    var Math_exp = Math.exp
    var Math_log = Math.log
    var Math_sqrt = Math.sqrt
    var Math_ceil = Math.ceil
    var Math_floor = Math.floor
    var Math_pow = Math.pow
    var Math_imul = Math.imul
    var Math_fround = Math.fround
    var Math_round = Math.round
    var Math_min = Math.min
    var Math_max = Math.max
    var Math_clz32 = Math.clz32
    var Math_trunc = Math.trunc
    var runDependencies = 0
    var runDependencyWatcher = null
    var dependenciesFulfilled = null

    function getUniqueRunDependency(id) {
      return id
    }

    function addRunDependency(id) {
      runDependencies++
      if (Module["monitorRunDependencies"]) {
        Module["monitorRunDependencies"](runDependencies)
      }
    }

    function removeRunDependency(id) {
      runDependencies--
      if (Module["monitorRunDependencies"]) {
        Module["monitorRunDependencies"](runDependencies)
      }
      if (runDependencies == 0) {
        if (runDependencyWatcher !== null) {
          clearInterval(runDependencyWatcher)
          runDependencyWatcher = null
        }
        if (dependenciesFulfilled) {
          var callback = dependenciesFulfilled
          dependenciesFulfilled = null
          callback()
        }
      }
    }

    Module["preloadedImages"] = {}
    Module["preloadedAudios"] = {}
    var memoryInitializer = null
    var dataURIPrefix = "data:application/octet-stream;base64,"

    function isDataURI(filename) {
      return String.prototype.startsWith ? filename.startsWith(dataURIPrefix) : filename.indexOf(dataURIPrefix) === 0
    }

    var ASM_CONSTS = [(function($0, $1) {
      var path = Pointer_stringify($0)
      var data = Pointer_stringify($1)
      FS.createPath("/", PATH.dirname(path))
      FS.writeFile(PATH.join("/", path), data)
    })]

    function _emscripten_asm_const_iii(code, a0, a1) {
      return ASM_CONSTS[code](a0, a1)
    }

    STATIC_BASE = GLOBAL_BASE
    STATICTOP = STATIC_BASE + 194160
    __ATINIT__.push()
    memoryInitializer = "data:application/octet-stream;base64,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"
    var tempDoublePtr = STATICTOP
    STATICTOP += 16

    function ___assert_fail(condition, filename, line, func) {
      abort("Assertion failed: " + Pointer_stringify(condition) + ", at: " + [filename ? Pointer_stringify(filename)
          : "unknown filename", line, func ? Pointer_stringify(func) : "unknown function"])
    }

    function _emscripten_get_now() {
      abort()
    }

    function _emscripten_get_now_is_monotonic() {
      return ENVIRONMENT_IS_NODE || typeof dateNow !== "undefined" || (ENVIRONMENT_IS_WEB || ENVIRONMENT_IS_WORKER)
          && self["performance"] && self["performance"]["now"]
    }

    var ERRNO_CODES = {
      EPERM: 1,
      ENOENT: 2,
      ESRCH: 3,
      EINTR: 4,
      EIO: 5,
      ENXIO: 6,
      E2BIG: 7,
      ENOEXEC: 8,
      EBADF: 9,
      ECHILD: 10,
      EAGAIN: 11,
      EWOULDBLOCK: 11,
      ENOMEM: 12,
      EACCES: 13,
      EFAULT: 14,
      ENOTBLK: 15,
      EBUSY: 16,
      EEXIST: 17,
      EXDEV: 18,
      ENODEV: 19,
      ENOTDIR: 20,
      EISDIR: 21,
      EINVAL: 22,
      ENFILE: 23,
      EMFILE: 24,
      ENOTTY: 25,
      ETXTBSY: 26,
      EFBIG: 27,
      ENOSPC: 28,
      ESPIPE: 29,
      EROFS: 30,
      EMLINK: 31,
      EPIPE: 32,
      EDOM: 33,
      ERANGE: 34,
      ENOMSG: 42,
      EIDRM: 43,
      ECHRNG: 44,
      EL2NSYNC: 45,
      EL3HLT: 46,
      EL3RST: 47,
      ELNRNG: 48,
      EUNATCH: 49,
      ENOCSI: 50,
      EL2HLT: 51,
      EDEADLK: 35,
      ENOLCK: 37,
      EBADE: 52,
      EBADR: 53,
      EXFULL: 54,
      ENOANO: 55,
      EBADRQC: 56,
      EBADSLT: 57,
      EDEADLOCK: 35,
      EBFONT: 59,
      ENOSTR: 60,
      ENODATA: 61,
      ETIME: 62,
      ENOSR: 63,
      ENONET: 64,
      ENOPKG: 65,
      EREMOTE: 66,
      ENOLINK: 67,
      EADV: 68,
      ESRMNT: 69,
      ECOMM: 70,
      EPROTO: 71,
      EMULTIHOP: 72,
      EDOTDOT: 73,
      EBADMSG: 74,
      ENOTUNIQ: 76,
      EBADFD: 77,
      EREMCHG: 78,
      ELIBACC: 79,
      ELIBBAD: 80,
      ELIBSCN: 81,
      ELIBMAX: 82,
      ELIBEXEC: 83,
      ENOSYS: 38,
      ENOTEMPTY: 39,
      ENAMETOOLONG: 36,
      ELOOP: 40,
      EOPNOTSUPP: 95,
      EPFNOSUPPORT: 96,
      ECONNRESET: 104,
      ENOBUFS: 105,
      EAFNOSUPPORT: 97,
      EPROTOTYPE: 91,
      ENOTSOCK: 88,
      ENOPROTOOPT: 92,
      ESHUTDOWN: 108,
      ECONNREFUSED: 111,
      EADDRINUSE: 98,
      ECONNABORTED: 103,
      ENETUNREACH: 101,
      ENETDOWN: 100,
      ETIMEDOUT: 110,
      EHOSTDOWN: 112,
      EHOSTUNREACH: 113,
      EINPROGRESS: 115,
      EALREADY: 114,
      EDESTADDRREQ: 89,
      EMSGSIZE: 90,
      EPROTONOSUPPORT: 93,
      ESOCKTNOSUPPORT: 94,
      EADDRNOTAVAIL: 99,
      ENETRESET: 102,
      EISCONN: 106,
      ENOTCONN: 107,
      ETOOMANYREFS: 109,
      EUSERS: 87,
      EDQUOT: 122,
      ESTALE: 116,
      ENOTSUP: 95,
      ENOMEDIUM: 123,
      EILSEQ: 84,
      EOVERFLOW: 75,
      ECANCELED: 125,
      ENOTRECOVERABLE: 131,
      EOWNERDEAD: 130,
      ESTRPIPE: 86
    }

    function ___setErrNo(value) {
      if (Module["___errno_location"]) {
        HEAP32[Module["___errno_location"]() >> 2] = value
      }
      return value
    }

    function _clock_gettime(clk_id, tp) {
      var now
      if (clk_id === 0) {
        now = Date.now()
      } else if (clk_id === 1 && _emscripten_get_now_is_monotonic()) {
        now = _emscripten_get_now()
      } else {
        ___setErrNo(ERRNO_CODES.EINVAL)
        return -1
      }
      HEAP32[tp >> 2] = now / 1e3 | 0
      HEAP32[tp + 4 >> 2] = now % 1e3 * 1e3 * 1e3 | 0
      return 0
    }

    function ___clock_gettime() {
      return _clock_gettime.apply(null, arguments)
    }

    function ___lock() {
    }

    function ___map_file(pathname, size) {
      ___setErrNo(ERRNO_CODES.EPERM)
      return -1
    }

    var ERRNO_MESSAGES = {
      0: "Success",
      1: "Not super-user",
      2: "No such file or directory",
      3: "No such process",
      4: "Interrupted system call",
      5: "I/O error",
      6: "No such device or address",
      7: "Arg list too long",
      8: "Exec format error",
      9: "Bad file number",
      10: "No children",
      11: "No more processes",
      12: "Not enough core",
      13: "Permission denied",
      14: "Bad address",
      15: "Block device required",
      16: "Mount device busy",
      17: "File exists",
      18: "Cross-device link",
      19: "No such device",
      20: "Not a directory",
      21: "Is a directory",
      22: "Invalid argument",
      23: "Too many open files in system",
      24: "Too many open files",
      25: "Not a typewriter",
      26: "Text file busy",
      27: "File too large",
      28: "No space left on device",
      29: "Illegal seek",
      30: "Read only file system",
      31: "Too many links",
      32: "Broken pipe",
      33: "Math arg out of domain of func",
      34: "Math result not representable",
      35: "File locking deadlock error",
      36: "File or path name too long",
      37: "No record locks available",
      38: "Function not implemented",
      39: "Directory not empty",
      40: "Too many symbolic links",
      42: "No message of desired type",
      43: "Identifier removed",
      44: "Channel number out of range",
      45: "Level 2 not synchronized",
      46: "Level 3 halted",
      47: "Level 3 reset",
      48: "Link number out of range",
      49: "Protocol driver not attached",
      50: "No CSI structure available",
      51: "Level 2 halted",
      52: "Invalid exchange",
      53: "Invalid request descriptor",
      54: "Exchange full",
      55: "No anode",
      56: "Invalid request code",
      57: "Invalid slot",
      59: "Bad font file fmt",
      60: "Device not a stream",
      61: "No data (for no delay io)",
      62: "Timer expired",
      63: "Out of streams resources",
      64: "Machine is not on the network",
      65: "Package not installed",
      66: "The object is remote",
      67: "The link has been severed",
      68: "Advertise error",
      69: "Srmount error",
      70: "Communication error on send",
      71: "Protocol error",
      72: "Multihop attempted",
      73: "Cross mount point (not really error)",
      74: "Trying to read unreadable message",
      75: "Value too large for defined data type",
      76: "Given log. name not unique",
      77: "f.d. invalid for this operation",
      78: "Remote address changed",
      79: "Can   access a needed shared lib",
      80: "Accessing a corrupted shared lib",
      81: ".lib section in a.out corrupted",
      82: "Attempting to link in too many libs",
      83: "Attempting to exec a shared library",
      84: "Illegal byte sequence",
      86: "Streams pipe error",
      87: "Too many users",
      88: "Socket operation on non-socket",
      89: "Destination address required",
      90: "Message too long",
      91: "Protocol wrong type for socket",
      92: "Protocol not available",
      93: "Unknown protocol",
      94: "Socket type not supported",
      95: "Not supported",
      96: "Protocol family not supported",
      97: "Address family not supported by protocol family",
      98: "Address already in use",
      99: "Address not available",
      100: "Network interface is not configured",
      101: "Network is unreachable",
      102: "Connection reset by network",
      103: "Connection aborted",
      104: "Connection reset by peer",
      105: "No buffer space available",
      106: "Socket is already connected",
      107: "Socket is not connected",
      108: "Can't send after socket shutdown",
      109: "Too many references",
      110: "Connection timed out",
      111: "Connection refused",
      112: "Host is down",
      113: "Host is unreachable",
      114: "Socket already connected",
      115: "Connection already in progress",
      116: "Stale file handle",
      122: "Quota exceeded",
      123: "No medium (in tape drive)",
      125: "Operation canceled",
      130: "Previous owner died",
      131: "State not recoverable"
    }
    var PATH = {
      splitPath: (function(filename) {
        var splitPathRe = /^(\/?|)([\s\S]*?)((?:\.{1,2}|[^\/]+?|)(\.[^.\/]*|))(?:[\/]*)$/
        return splitPathRe.exec(filename).slice(1)
      }), normalizeArray: (function(parts, allowAboveRoot) {
        var up = 0
        for (var i = parts.length - 1; i >= 0; i--) {
          var last = parts[i]
          if (last === ".") {
            parts.splice(i, 1)
          } else if (last === "..") {
            parts.splice(i, 1)
            up++
          } else if (up) {
            parts.splice(i, 1)
            up--
          }
        }
        if (allowAboveRoot) {
          for (; up; up--) {
            parts.unshift("..")
          }
        }
        return parts
      }), normalize: (function(path) {
        var isAbsolute = path.charAt(0) === "/", trailingSlash = path.substr(-1) === "/"
        path = PATH.normalizeArray(path.split("/").filter((function(p) {
          return !!p
        })), !isAbsolute).join("/")
        if (!path && !isAbsolute) {
          path = "."
        }
        if (path && trailingSlash) {
          path += "/"
        }
        return (isAbsolute ? "/" : "") + path
      }), dirname: (function(path) {
        var result = PATH.splitPath(path), root = result[0], dir = result[1]
        if (!root && !dir) {
          return "."
        }
        if (dir) {
          dir = dir.substr(0, dir.length - 1)
        }
        return root + dir
      }), basename: (function(path) {
        if (path === "/") {
          return "/"
        }
        var lastSlash = path.lastIndexOf("/")
        if (lastSlash === -1) {
          return path
        }
        return path.substr(lastSlash + 1)
      }), extname: (function(path) {
        return PATH.splitPath(path)[3]
      }), join: (function() {
        var paths = Array.prototype.slice.call(arguments, 0)
        return PATH.normalize(paths.join("/"))
      }), join2: (function(l, r) {
        return PATH.normalize(l + "/" + r)
      }), resolve: (function() {
        var resolvedPath = "", resolvedAbsolute = false
        for (var i = arguments.length - 1; i >= -1 && !resolvedAbsolute; i--) {
          var path = i >= 0 ? arguments[i] : FS.cwd()
          if (typeof path !== "string") {
            throw new TypeError("Arguments to path.resolve must be strings")
          } else if (!path) {
            return ""
          }
          resolvedPath = path + "/" + resolvedPath
          resolvedAbsolute = path.charAt(0) === "/"
        }
        resolvedPath = PATH.normalizeArray(resolvedPath.split("/").filter((function(p) {
          return !!p
        })), !resolvedAbsolute).join("/")
        return (resolvedAbsolute ? "/" : "") + resolvedPath || "."
      }), relative: (function(from, to) {
        from = PATH.resolve(from).substr(1)
        to = PATH.resolve(to).substr(1)

        function trim(arr) {
          var start = 0
          for (; start < arr.length; start++) {
            if (arr[start] !== "") {
              break
            }
          }
          var end = arr.length - 1
          for (; end >= 0; end--) {
            if (arr[end] !== "") {
              break
            }
          }
          if (start > end) {
            return []
          }
          return arr.slice(start, end - start + 1)
        }

        var fromParts = trim(from.split("/"))
        var toParts = trim(to.split("/"))
        var length = Math.min(fromParts.length, toParts.length)
        var samePartsLength = length
        for (var i = 0; i < length; i++) {
          if (fromParts[i] !== toParts[i]) {
            samePartsLength = i
            break
          }
        }
        var outputParts = []
        for (var i = samePartsLength; i < fromParts.length; i++) {
          outputParts.push("..")
        }
        outputParts = outputParts.concat(toParts.slice(samePartsLength))
        return outputParts.join("/")
      })
    }
    var TTY = {
      ttys: [], init: (function() {
      }), shutdown: (function() {
      }), register: (function(dev, ops) {
        TTY.ttys[dev] = { input: [], output: [], ops: ops }
        FS.registerDevice(dev, TTY.stream_ops)
      }), stream_ops: {
        open: (function(stream) {
          var tty = TTY.ttys[stream.node.rdev]
          if (!tty) {
            throw new FS.ErrnoError(ERRNO_CODES.ENODEV)
          }
          stream.tty = tty
          stream.seekable = false
        }), close: (function(stream) {
          stream.tty.ops.flush(stream.tty)
        }), flush: (function(stream) {
          stream.tty.ops.flush(stream.tty)
        }), read: (function(stream, buffer, offset, length, pos) {
          if (!stream.tty || !stream.tty.ops.get_char) {
            throw new FS.ErrnoError(ERRNO_CODES.ENXIO)
          }
          var bytesRead = 0
          for (var i = 0; i < length; i++) {
            var result
            try {
              result = stream.tty.ops.get_char(stream.tty)
            } catch (e) {
              throw new FS.ErrnoError(ERRNO_CODES.EIO)
            }
            if (result === undefined && bytesRead === 0) {
              throw new FS.ErrnoError(ERRNO_CODES.EAGAIN)
            }
            if (result === null || result === undefined) {
              break
            }
            bytesRead++
            buffer[offset + i] = result
          }
          if (bytesRead) {
            stream.node.timestamp = Date.now()
          }
          return bytesRead
        }), write: (function(stream, buffer, offset, length, pos) {
          if (!stream.tty || !stream.tty.ops.put_char) {
            throw new FS.ErrnoError(ERRNO_CODES.ENXIO)
          }
          for (var i = 0; i < length; i++) {
            try {
              stream.tty.ops.put_char(stream.tty, buffer[offset + i])
            } catch (e) {
              throw new FS.ErrnoError(ERRNO_CODES.EIO)
            }
          }
          if (length) {
            stream.node.timestamp = Date.now()
          }
          return i
        })
      }, default_tty_ops: {
        get_char: (function(tty) {
          if (!tty.input.length) {
            var result = null
            if (ENVIRONMENT_IS_NODE) {
              var BUFSIZE = 256
              var buf = new Buffer(BUFSIZE)
              var bytesRead = 0
              var isPosixPlatform = process.platform != "win32"
              var fd = process.stdin.fd
              if (isPosixPlatform) {
                var usingDevice = false
                try {
                  fd = fs.openSync("/dev/stdin", "r")
                  usingDevice = true
                } catch (e) {
                }
              }
              try {
                bytesRead = fs.readSync(fd, buf, 0, BUFSIZE, null)
              } catch (e) {
                if (e.toString().indexOf("EOF") != -1) {
                  bytesRead = 0
                } else {
                  throw e
                }
              }
              if (usingDevice) {
                fs.closeSync(fd)
              }
              if (bytesRead > 0) {
                result = buf.slice(0, bytesRead).toString("utf-8")
              } else {
                result = null
              }
            } else if (typeof window != "undefined" && typeof window.prompt == "function") {
              result = window.prompt("Input: ")
              if (result !== null) {
                result += "\n"
              }
            } else if (typeof readline == "function") {
              result = readline()
              if (result !== null) {
                result += "\n"
              }
            }
            if (!result) {
              return null
            }
            tty.input = intArrayFromString(result, true)
          }
          return tty.input.shift()
        }), put_char: (function(tty, val) {
          if (val === null || val === 10) {
            Module["print"](UTF8ArrayToString(tty.output, 0))
            tty.output = []
          } else {
            if (val != 0) {
              tty.output.push(val)
            }
          }
        }), flush: (function(tty) {
          if (tty.output && tty.output.length > 0) {
            Module["print"](UTF8ArrayToString(tty.output, 0))
            tty.output = []
          }
        })
      }, default_tty1_ops: {
        put_char: (function(tty, val) {
          if (val === null || val === 10) {
            Module["printErr"](UTF8ArrayToString(tty.output, 0))
            tty.output = []
          } else {
            if (val != 0) {
              tty.output.push(val)
            }
          }
        }), flush: (function(tty) {
          if (tty.output && tty.output.length > 0) {
            Module["printErr"](UTF8ArrayToString(tty.output, 0))
            tty.output = []
          }
        })
      }
    }
    var MEMFS = {
      ops_table: null, mount: (function(mount) {
        return MEMFS.createNode(null, "/", 16384 | 511, 0)
      }), createNode: (function(parent, name, mode, dev) {
        if (FS.isBlkdev(mode) || FS.isFIFO(mode)) {
          throw new FS.ErrnoError(ERRNO_CODES.EPERM)
        }
        if (!MEMFS.ops_table) {
          MEMFS.ops_table = {
            dir: {
              node: {
                getattr: MEMFS.node_ops.getattr,
                setattr: MEMFS.node_ops.setattr,
                lookup: MEMFS.node_ops.lookup,
                mknod: MEMFS.node_ops.mknod,
                rename: MEMFS.node_ops.rename,
                unlink: MEMFS.node_ops.unlink,
                rmdir: MEMFS.node_ops.rmdir,
                readdir: MEMFS.node_ops.readdir,
                symlink: MEMFS.node_ops.symlink
              }, stream: { llseek: MEMFS.stream_ops.llseek }
            },
            file: {
              node: { getattr: MEMFS.node_ops.getattr, setattr: MEMFS.node_ops.setattr },
              stream: {
                llseek: MEMFS.stream_ops.llseek,
                read: MEMFS.stream_ops.read,
                write: MEMFS.stream_ops.write,
                allocate: MEMFS.stream_ops.allocate,
                mmap: MEMFS.stream_ops.mmap,
                msync: MEMFS.stream_ops.msync
              }
            },
            link: {
              node: {
                getattr: MEMFS.node_ops.getattr,
                setattr: MEMFS.node_ops.setattr,
                readlink: MEMFS.node_ops.readlink
              }, stream: {}
            },
            chrdev: {
              node: { getattr: MEMFS.node_ops.getattr, setattr: MEMFS.node_ops.setattr },
              stream: FS.chrdev_stream_ops
            }
          }
        }
        var node = FS.createNode(parent, name, mode, dev)
        if (FS.isDir(node.mode)) {
          node.node_ops = MEMFS.ops_table.dir.node
          node.stream_ops = MEMFS.ops_table.dir.stream
          node.contents = {}
        } else if (FS.isFile(node.mode)) {
          node.node_ops = MEMFS.ops_table.file.node
          node.stream_ops = MEMFS.ops_table.file.stream
          node.usedBytes = 0
          node.contents = null
        } else if (FS.isLink(node.mode)) {
          node.node_ops = MEMFS.ops_table.link.node
          node.stream_ops = MEMFS.ops_table.link.stream
        } else if (FS.isChrdev(node.mode)) {
          node.node_ops = MEMFS.ops_table.chrdev.node
          node.stream_ops = MEMFS.ops_table.chrdev.stream
        }
        node.timestamp = Date.now()
        if (parent) {
          parent.contents[name] = node
        }
        return node
      }), getFileDataAsRegularArray: (function(node) {
        if (node.contents && node.contents.subarray) {
          var arr = []
          for (var i = 0; i < node.usedBytes; ++i) {
            arr.push(node.contents[i])
          }
          return arr
        }
        return node.contents
      }), getFileDataAsTypedArray: (function(node) {
        if (!node.contents) {
          return new Uint8Array
        }
        if (node.contents.subarray) {
          return node.contents.subarray(0, node.usedBytes)
        }
        return new Uint8Array(node.contents)
      }), expandFileStorage: (function(node, newCapacity) {
        if (node.contents && node.contents.subarray && newCapacity > node.contents.length) {
          node.contents = MEMFS.getFileDataAsRegularArray(node)
          node.usedBytes = node.contents.length
        }
        if (!node.contents || node.contents.subarray) {
          var prevCapacity = node.contents ? node.contents.length : 0
          if (prevCapacity >= newCapacity) {
            return
          }
          var CAPACITY_DOUBLING_MAX = 1024 * 1024
          newCapacity = Math.max(newCapacity, prevCapacity * (prevCapacity < CAPACITY_DOUBLING_MAX ? 2 : 1.125) | 0)
          if (prevCapacity != 0) {
            newCapacity = Math.max(newCapacity, 256)
          }
          var oldContents = node.contents
          node.contents = new Uint8Array(newCapacity)
          if (node.usedBytes > 0) {
            node.contents.set(oldContents.subarray(0, node.usedBytes), 0)
          }
          return
        }
        if (!node.contents && newCapacity > 0) {
          node.contents = []
        }
        while (node.contents.length < newCapacity) {
          node.contents.push(0)
        }
      }), resizeFileStorage: (function(node, newSize) {
        if (node.usedBytes == newSize) {
          return
        }
        if (newSize == 0) {
          node.contents = null
          node.usedBytes = 0
          return
        }
        if (!node.contents || node.contents.subarray) {
          var oldContents = node.contents
          node.contents = new Uint8Array(new ArrayBuffer(newSize))
          if (oldContents) {
            node.contents.set(oldContents.subarray(0, Math.min(newSize, node.usedBytes)))
          }
          node.usedBytes = newSize
          return
        }
        if (!node.contents) {
          node.contents = []
        }
        if (node.contents.length > newSize) {
          node.contents.length = newSize
        } else {
          while (node.contents.length
          < newSize) {
            node.contents.push(0)
          }
        }
        node.usedBytes = newSize
      }), node_ops: {
        getattr: (function(node) {
          var attr = {}
          attr.dev = FS.isChrdev(node.mode) ? node.id : 1
          attr.ino = node.id
          attr.mode = node.mode
          attr.nlink = 1
          attr.uid = 0
          attr.gid = 0
          attr.rdev = node.rdev
          if (FS.isDir(node.mode)) {
            attr.size = 4096
          } else if (FS.isFile(node.mode)) {
            attr.size = node.usedBytes
          } else if (FS.isLink(node.mode)) {
            attr.size = node.link.length
          } else {
            attr.size = 0
          }
          attr.atime = new Date(node.timestamp)
          attr.mtime = new Date(node.timestamp)
          attr.ctime = new Date(node.timestamp)
          attr.blksize = 4096
          attr.blocks = Math.ceil(attr.size / attr.blksize)
          return attr
        }), setattr: (function(node, attr) {
          if (attr.mode !== undefined) {
            node.mode = attr.mode
          }
          if (attr.timestamp !== undefined) {
            node.timestamp = attr.timestamp
          }
          if (attr.size !== undefined) {
            MEMFS.resizeFileStorage(node, attr.size)
          }
        }), lookup: (function(parent, name) {
          throw FS.genericErrors[ERRNO_CODES.ENOENT]
        }), mknod: (function(parent, name, mode, dev) {
          return MEMFS.createNode(parent, name, mode, dev)
        }), rename: (function(old_node, new_dir, new_name) {
          if (FS.isDir(old_node.mode)) {
            var new_node
            try {
              new_node = FS.lookupNode(new_dir, new_name)
            } catch (e) {
            }
            if (new_node) {
              for (var i in new_node.contents) {
                throw new FS.ErrnoError(ERRNO_CODES.ENOTEMPTY)
              }
            }
          }
          delete old_node.parent.contents[old_node.name]
          old_node.name = new_name
          new_dir.contents[new_name] = old_node
          old_node.parent = new_dir
        }), unlink: (function(parent, name) {
          delete parent.contents[name]
        }), rmdir: (function(parent, name) {
          var node = FS.lookupNode(parent, name)
          for (var i in node.contents) {
            throw new FS.ErrnoError(ERRNO_CODES.ENOTEMPTY)
          }
          delete parent.contents[name]
        }), readdir: (function(node) {
          var entries = [".", ".."]
          for (var key in node.contents) {
            if (!node.contents.hasOwnProperty(key)) {
              continue
            }
            entries.push(key)
          }
          return entries
        }), symlink: (function(parent, newname, oldpath) {
          var node = MEMFS.createNode(parent, newname, 511 | 40960, 0)
          node.link = oldpath
          return node
        }), readlink: (function(node) {
          if (!FS.isLink(node.mode)) {
            throw new FS.ErrnoError(ERRNO_CODES.EINVAL)
          }
          return node.link
        })
      }, stream_ops: {
        read: (function(stream, buffer, offset, length, position) {
          var contents = stream.node.contents
          if (position >= stream.node.usedBytes) {
            return 0
          }
          var size = Math.min(stream.node.usedBytes - position, length)
          assert(size >= 0)
          if (size > 8 && contents.subarray) {
            buffer.set(contents.subarray(position, position + size), offset)
          } else {
            for (var i = 0; i < size; i++) {
              buffer[offset + i] = contents[position + i]
            }
          }
          return size
        }), write: (function(stream, buffer, offset, length, position, canOwn) {
          if (!length) {
            return 0
          }
          var node = stream.node
          node.timestamp = Date.now()
          if (buffer.subarray && (!node.contents || node.contents.subarray)) {
            if (canOwn) {
              node.contents = buffer.subarray(offset, offset + length)
              node.usedBytes = length
              return length
            } else if (node.usedBytes === 0 && position === 0) {
              node.contents = new Uint8Array(buffer.subarray(offset, offset + length))
              node.usedBytes = length
              return length
            } else if (position + length <= node.usedBytes) {
              node.contents.set(buffer.subarray(offset, offset + length), position)
              return length
            }
          }
          MEMFS.expandFileStorage(node, position + length)
          if (node.contents.subarray && buffer.subarray) {
            node.contents.set(buffer.subarray(offset, offset + length),
                position)
          } else {
            for (var i = 0; i < length; i++) {
              node.contents[position + i] = buffer[offset + i]
            }
          }
          node.usedBytes = Math.max(node.usedBytes, position + length)
          return length
        }), llseek: (function(stream, offset, whence) {
          var position = offset
          if (whence === 1) {
            position += stream.position
          } else if (whence === 2) {
            if (FS.isFile(stream.node.mode)) {
              position += stream.node.usedBytes
            }
          }
          if (position < 0) {
            throw new FS.ErrnoError(ERRNO_CODES.EINVAL)
          }
          return position
        }), allocate: (function(stream, offset, length) {
          MEMFS.expandFileStorage(stream.node, offset + length)
          stream.node.usedBytes = Math.max(stream.node.usedBytes, offset + length)
        }), mmap: (function(stream, buffer, offset, length, position, prot, flags) {
          if (!FS.isFile(stream.node.mode)) {
            throw new FS.ErrnoError(ERRNO_CODES.ENODEV)
          }
          var ptr
          var allocated
          var contents = stream.node.contents
          if (!(flags & 2) && (contents.buffer === buffer || contents.buffer === buffer.buffer)) {
            allocated = false
            ptr = contents.byteOffset
          } else {
            if (position > 0 || position + length < stream.node.usedBytes) {
              if (contents.subarray) {
                contents = contents.subarray(position, position + length)
              } else {
                contents = Array.prototype.slice.call(contents, position, position + length)
              }
            }
            allocated = true
            ptr = _malloc(length)
            if (!ptr) {
              throw new FS.ErrnoError(ERRNO_CODES.ENOMEM)
            }
            buffer.set(contents, ptr)
          }
          return { ptr: ptr, allocated: allocated }
        }), msync: (function(stream, buffer, offset, length, mmapFlags) {
          if (!FS.isFile(stream.node.mode)) {
            throw new FS.ErrnoError(ERRNO_CODES.ENODEV)
          }
          if (mmapFlags & 2) {
            return 0
          }
          var bytesWritten = MEMFS.stream_ops.write(stream, buffer, 0, length, offset, false)
          return 0
        })
      }
    }
    var IDBFS = {
      dbs: {}, indexedDB: (function() {
        if (typeof indexedDB !== "undefined") {
          return indexedDB
        }
        var ret = null
        if (typeof window === "object") {
          ret = window.indexedDB || window.mozIndexedDB || window.webkitIndexedDB
              || window.msIndexedDB
        }
        assert(ret, "IDBFS used, but indexedDB not supported")
        return ret
      }), DB_VERSION: 21, DB_STORE_NAME: "FILE_DATA", mount: (function(mount) {
        return MEMFS.mount.apply(null, arguments)
      }), syncfs: (function(mount, populate, callback) {
        IDBFS.getLocalSet(mount, (function(err, local) {
          if (err) {
            return callback(err)
          }
          IDBFS.getRemoteSet(mount, (function(err, remote) {
            if (err) {
              return callback(err)
            }
            var src = populate ? remote : local
            var dst = populate ? local : remote
            IDBFS.reconcile(src, dst, callback)
          }))
        }))
      }), getDB: (function(name, callback) {
        var db = IDBFS.dbs[name]
        if (db) {
          return callback(null, db)
        }
        var req
        try {
          req = IDBFS.indexedDB().open(name, IDBFS.DB_VERSION)
        } catch (e) {
          return callback(e)
        }
        if (!req) {
          return callback("Unable to connect to IndexedDB")
        }
        req.onupgradeneeded = (function(e) {
          var db = e.target.result
          var transaction = e.target.transaction
          var fileStore
          if (db.objectStoreNames.contains(IDBFS.DB_STORE_NAME)) {
            fileStore = transaction.objectStore(IDBFS.DB_STORE_NAME)
          } else {
            fileStore = db.createObjectStore(IDBFS.DB_STORE_NAME)
          }
          if (!fileStore.indexNames.contains("timestamp")) {
            fileStore.createIndex("timestamp", "timestamp", { unique: false })
          }
        })
        req.onsuccess = (function() {
          db = req.result
          IDBFS.dbs[name] = db
          callback(null, db)
        })
        req.onerror = (function(e) {
          callback(this.error)
          e.preventDefault()
        })
      }), getLocalSet: (function(mount, callback) {
        var entries = {}

        function isRealDir(p) {
          return p !== "." && p !== ".."
        }

        function toAbsolute(root) {
          return (function(p) {
            return PATH.join2(root, p)
          })
        }

        var check = FS.readdir(mount.mountpoint).filter(isRealDir).map(toAbsolute(mount.mountpoint))
        while (check.length) {
          var path = check.pop()
          var stat
          try {
            stat = FS.stat(path)
          } catch (e) {
            return callback(e)
          }
          if (FS.isDir(stat.mode)) {
            check.push.apply(check, FS.readdir(path).filter(isRealDir).map(toAbsolute(path)))
          }
          entries[path] = { timestamp: stat.mtime }
        }
        return callback(null, { type: "local", entries: entries })
      }), getRemoteSet: (function(mount, callback) {
        var entries = {}
        IDBFS.getDB(mount.mountpoint, (function(err, db) {
          if (err) {
            return callback(err)
          }
          try {
            var transaction = db.transaction([IDBFS.DB_STORE_NAME], "readonly")
            transaction.onerror = (function(e) {
              callback(this.error)
              e.preventDefault()
            })
            var store = transaction.objectStore(IDBFS.DB_STORE_NAME)
            var index = store.index("timestamp")
            index.openKeyCursor().onsuccess = (function(event) {
              var cursor = event.target.result
              if (!cursor) {
                return callback(null, { type: "remote", db: db, entries: entries })
              }
              entries[cursor.primaryKey] = { timestamp: cursor.key }
              cursor.continue()
            })
          } catch (e) {
            return callback(e)
          }
        }))
      }), loadLocalEntry: (function(path, callback) {
        var stat, node
        try {
          var lookup = FS.lookupPath(path)
          node = lookup.node
          stat = FS.stat(path)
        } catch (e) {
          return callback(e)
        }
        if (FS.isDir(stat.mode)) {
          return callback(null, { timestamp: stat.mtime, mode: stat.mode })
        } else if (FS.isFile(stat.mode)) {
          node.contents = MEMFS.getFileDataAsTypedArray(node)
          return callback(null, { timestamp: stat.mtime, mode: stat.mode, contents: node.contents })
        } else {
          return callback(new Error("node type not supported"))
        }
      }), storeLocalEntry: (function(path, entry, callback) {
        try {
          if (FS.isDir(entry.mode)) {
            FS.mkdir(path, entry.mode)
          } else if (FS.isFile(entry.mode)) {
            FS.writeFile(path, entry.contents, { canOwn: true })
          } else {
            return callback(new Error("node type not supported"))
          }
          FS.chmod(path, entry.mode)
          FS.utime(path, entry.timestamp, entry.timestamp)
        } catch (e) {
          return callback(e)
        }
        callback(null)
      }), removeLocalEntry: (function(path, callback) {
        try {
          var lookup = FS.lookupPath(path)
          var stat = FS.stat(path)
          if (FS.isDir(stat.mode)) {
            FS.rmdir(path)
          } else if (FS.isFile(stat.mode)) {
            FS.unlink(path)
          }
        } catch (e) {
          return callback(e)
        }
        callback(null)
      }), loadRemoteEntry: (function(store, path, callback) {
        var req = store.get(path)
        req.onsuccess = (function(event) {
          callback(null, event.target.result)
        })
        req.onerror = (function(e) {
          callback(this.error)
          e.preventDefault()
        })
      }), storeRemoteEntry: (function(store, path, entry, callback) {
        var req = store.put(entry, path)
        req.onsuccess = (function() {
          callback(null)
        })
        req.onerror = (function(e) {
          callback(this.error)
          e.preventDefault()
        })
      }), removeRemoteEntry: (function(store, path, callback) {
        var req = store.delete(path)
        req.onsuccess = (function() {
          callback(null)
        })
        req.onerror = (function(e) {
          callback(this.error)
          e.preventDefault()
        })
      }), reconcile: (function(src, dst, callback) {
        var total = 0
        var create = []
        Object.keys(src.entries).forEach((function(key) {
          var e = src.entries[key]
          var e2 = dst.entries[key]
          if (!e2 || e.timestamp > e2.timestamp) {
            create.push(key)
            total++
          }
        }))
        var remove = []
        Object.keys(dst.entries).forEach((function(key) {
          var e = dst.entries[key]
          var e2 = src.entries[key]
          if (!e2) {
            remove.push(key)
            total++
          }
        }))
        if (!total) {
          return callback(null)
        }
        var completed = 0
        var db = src.type === "remote" ? src.db : dst.db
        var transaction = db.transaction([IDBFS.DB_STORE_NAME], "readwrite")
        var store = transaction.objectStore(IDBFS.DB_STORE_NAME)

        function done(err) {
          if (err) {
            if (!done.errored) {
              done.errored = true
              return callback(err)
            }
            return
          }
          if (++completed >= total) {
            return callback(null)
          }
        }

        transaction.onerror = (function(e) {
          done(this.error)
          e.preventDefault()
        })
        create.sort().forEach((function(path) {
          if (dst.type === "local") {
            IDBFS.loadRemoteEntry(store, path, (function(err, entry) {
              if (err) {
                return done(err)
              }
              IDBFS.storeLocalEntry(path, entry, done)
            }))
          } else {
            IDBFS.loadLocalEntry(path, (function(err, entry) {
              if (err) {
                return done(err)
              }
              IDBFS.storeRemoteEntry(store, path, entry, done)
            }))
          }
        }))
        remove.sort().reverse().forEach((function(path) {
          if (dst.type === "local") {
            IDBFS.removeLocalEntry(path, done)
          } else {
            IDBFS.removeRemoteEntry(store, path, done)
          }
        }))
      })
    }
    var NODEFS = {
      isWindows: false, staticInit: (function() {
        NODEFS.isWindows = !!process.platform.match(/^win/)
        var flags = process["binding"]("constants")
        if (flags["fs"]) {
          flags = flags["fs"]
        }
        NODEFS.flagsForNodeMap = {
          "1024": flags["O_APPEND"],
          "64": flags["O_CREAT"],
          "128": flags["O_EXCL"],
          "0": flags["O_RDONLY"],
          "2": flags["O_RDWR"],
          "4096": flags["O_SYNC"],
          "512": flags["O_TRUNC"],
          "1": flags["O_WRONLY"]
        }
      }), bufferFrom: (function(arrayBuffer) {
        return Buffer.alloc ? Buffer.from(arrayBuffer) : new Buffer(arrayBuffer)
      }), mount: (function(mount) {
        assert(ENVIRONMENT_IS_NODE)
        return NODEFS.createNode(null, "/", NODEFS.getMode(mount.opts.root), 0)
      }), createNode: (function(parent, name, mode, dev) {
        if (!FS.isDir(mode) && !FS.isFile(mode) && !FS.isLink(mode)) {
          throw new FS.ErrnoError(ERRNO_CODES.EINVAL)
        }
        var node = FS.createNode(parent, name, mode)
        node.node_ops = NODEFS.node_ops
        node.stream_ops = NODEFS.stream_ops
        return node
      }), getMode: (function(path) {
        var stat
        try {
          stat = fs.lstatSync(path)
          if (NODEFS.isWindows) {
            stat.mode = stat.mode | (stat.mode & 292) >> 2
          }
        } catch (e) {
          if (!e.code) {
            throw e
          }
          throw new FS.ErrnoError(ERRNO_CODES[e.code])
        }
        return stat.mode
      }), realPath: (function(node) {
        var parts = []
        while (node.parent !== node) {
          parts.push(node.name)
          node = node.parent
        }
        parts.push(node.mount.opts.root)
        parts.reverse()
        return PATH.join.apply(null, parts)
      }), flagsForNode: (function(flags) {
        flags &= ~2097152
        flags &= ~2048
        flags &= ~32768
        flags &= ~524288
        var newFlags = 0
        for (var k in NODEFS.flagsForNodeMap) {
          if (flags & k) {
            newFlags |= NODEFS.flagsForNodeMap[k]
            flags ^= k
          }
        }
        if (!flags) {
          return newFlags
        } else {
          throw new FS.ErrnoError(ERRNO_CODES.EINVAL)
        }
      }), node_ops: {
        getattr: (function(node) {
          var path = NODEFS.realPath(node)
          var stat
          try {
            stat = fs.lstatSync(path)
          } catch (e) {
            if (!e.code) {
              throw e
            }
            throw new FS.ErrnoError(ERRNO_CODES[e.code])
          }
          if (NODEFS.isWindows && !stat.blksize) {
            stat.blksize = 4096
          }
          if (NODEFS.isWindows && !stat.blocks) {
            stat.blocks = (stat.size + stat.blksize - 1) / stat.blksize | 0
          }
          return {
            dev: stat.dev,
            ino: stat.ino,
            mode: stat.mode,
            nlink: stat.nlink,
            uid: stat.uid,
            gid: stat.gid,
            rdev: stat.rdev,
            size: stat.size,
            atime: stat.atime,
            mtime: stat.mtime,
            ctime: stat.ctime,
            blksize: stat.blksize,
            blocks: stat.blocks
          }
        }), setattr: (function(node, attr) {
          var path = NODEFS.realPath(node)
          try {
            if (attr.mode !== undefined) {
              fs.chmodSync(path, attr.mode)
              node.mode = attr.mode
            }
            if (attr.timestamp !== undefined) {
              var date = new Date(attr.timestamp)
              fs.utimesSync(path, date, date)
            }
            if (attr.size !== undefined) {
              fs.truncateSync(path, attr.size)
            }
          } catch (e) {
            if (!e.code) {
              throw e
            }
            throw new FS.ErrnoError(ERRNO_CODES[e.code])
          }
        }), lookup: (function(parent, name) {
          var path = PATH.join2(NODEFS.realPath(parent), name)
          var mode = NODEFS.getMode(path)
          return NODEFS.createNode(parent, name, mode)
        }), mknod: (function(parent, name, mode, dev) {
          var node = NODEFS.createNode(parent, name, mode, dev)
          var path = NODEFS.realPath(node)
          try {
            if (FS.isDir(node.mode)) {
              fs.mkdirSync(path, node.mode)
            } else {
              fs.writeFileSync(path, "", { mode: node.mode })
            }
          } catch (e) {
            if (!e.code) {
              throw e
            }
            throw new FS.ErrnoError(ERRNO_CODES[e.code])
          }
          return node
        }), rename: (function(oldNode, newDir, newName) {
          var oldPath = NODEFS.realPath(oldNode)
          var newPath = PATH.join2(NODEFS.realPath(newDir), newName)
          try {
            fs.renameSync(oldPath, newPath)
          } catch (e) {
            if (!e.code) {
              throw e
            }
            throw new FS.ErrnoError(ERRNO_CODES[e.code])
          }
        }), unlink: (function(parent, name) {
          var path = PATH.join2(NODEFS.realPath(parent), name)
          try {
            fs.unlinkSync(path)
          } catch (e) {
            if (!e.code) {
              throw e
            }
            throw new FS.ErrnoError(ERRNO_CODES[e.code])
          }
        }), rmdir: (function(parent, name) {
          var path = PATH.join2(NODEFS.realPath(parent), name)
          try {
            fs.rmdirSync(path)
          } catch (e) {
            if (!e.code) {
              throw e
            }
            throw new FS.ErrnoError(ERRNO_CODES[e.code])
          }
        }), readdir: (function(node) {
          var path = NODEFS.realPath(node)
          try {
            return fs.readdirSync(path)
          } catch (e) {
            if (!e.code) {
              throw e
            }
            throw new FS.ErrnoError(ERRNO_CODES[e.code])
          }
        }), symlink: (function(parent, newName, oldPath) {
          var newPath = PATH.join2(NODEFS.realPath(parent), newName)
          try {
            fs.symlinkSync(oldPath, newPath)
          } catch (e) {
            if (!e.code) {
              throw e
            }
            throw new FS.ErrnoError(ERRNO_CODES[e.code])
          }
        }), readlink: (function(node) {
          var path = NODEFS.realPath(node)
          try {
            path = fs.readlinkSync(path)
            path = NODEJS_PATH.relative(NODEJS_PATH.resolve(node.mount.opts.root), path)
            return path
          } catch (e) {
            if (!e.code) {
              throw e
            }
            throw new FS.ErrnoError(ERRNO_CODES[e.code])
          }
        })
      }, stream_ops: {
        open: (function(stream) {
          var path = NODEFS.realPath(stream.node)
          try {
            if (FS.isFile(stream.node.mode)) {
              stream.nfd = fs.openSync(path, NODEFS.flagsForNode(stream.flags))
            }
          } catch (e) {
            if (!e.code) {
              throw e
            }
            throw new FS.ErrnoError(ERRNO_CODES[e.code])
          }
        }), close: (function(stream) {
          try {
            if (FS.isFile(stream.node.mode) && stream.nfd) {
              fs.closeSync(stream.nfd)
            }
          } catch (e) {
            if (!e.code) {
              throw e
            }
            throw new FS.ErrnoError(ERRNO_CODES[e.code])
          }
        }), read: (function(stream, buffer, offset, length, position) {
          if (length === 0) {
            return 0
          }
          try {
            return fs.readSync(stream.nfd, NODEFS.bufferFrom(buffer.buffer), offset, length, position)
          } catch (e) {
            throw new FS.ErrnoError(ERRNO_CODES[e.code])
          }
        }), write: (function(stream, buffer, offset, length, position) {
          try {
            return fs.writeSync(stream.nfd, NODEFS.bufferFrom(buffer.buffer), offset, length, position)
          } catch (e) {
            throw new FS.ErrnoError(ERRNO_CODES[e.code])
          }
        }), llseek: (function(stream, offset, whence) {
          var position = offset
          if (whence === 1) {
            position += stream.position
          } else if (whence === 2) {
            if (FS.isFile(stream.node.mode)) {
              try {
                var stat = fs.fstatSync(stream.nfd)
                position += stat.size
              } catch (e) {
                throw new FS.ErrnoError(ERRNO_CODES[e.code])
              }
            }
          }
          if (position < 0) {
            throw new FS.ErrnoError(ERRNO_CODES.EINVAL)
          }
          return position
        })
      }
    }
    var WORKERFS = {
      DIR_MODE: 16895, FILE_MODE: 33279, reader: null, mount: (function(mount) {
        assert(ENVIRONMENT_IS_WORKER)
        if (!WORKERFS.reader) {
          WORKERFS.reader = new FileReaderSync
        }
        var root = WORKERFS.createNode(null, "/", WORKERFS.DIR_MODE, 0)
        var createdParents = {}

        function ensureParent(path) {
          var parts = path.split("/")
          var parent = root
          for (var i = 0; i < parts.length - 1; i++) {
            var curr = parts.slice(0, i + 1).join("/")
            if (!createdParents[curr]) {
              createdParents[curr] = WORKERFS.createNode(parent, parts[i], WORKERFS.DIR_MODE, 0)
            }
            parent = createdParents[curr]
          }
          return parent
        }

        function base(path) {
          var parts = path.split("/")
          return parts[parts.length - 1]
        }

        Array.prototype.forEach.call(mount.opts["files"] || [], (function(file) {
          WORKERFS.createNode(ensureParent(file.name), base(file.name), WORKERFS.FILE_MODE, 0, file,
              file.lastModifiedDate)
        }));
        (mount.opts["blobs"] || []).forEach((function(obj) {
          WORKERFS.createNode(ensureParent(obj["name"]), base(obj["name"]), WORKERFS.FILE_MODE, 0, obj["data"])
        }));
        (mount.opts["packages"] || []).forEach((function(pack) {
          pack["metadata"].files.forEach((function(file) {
            var name = file.filename.substr(1)
            WORKERFS.createNode(ensureParent(name), base(name), WORKERFS.FILE_MODE, 0,
                pack["blob"].slice(file.start, file.end))
          }))
        }))
        return root
      }), createNode: (function(parent, name, mode, dev, contents, mtime) {
        var node = FS.createNode(parent, name, mode)
        node.mode = mode
        node.node_ops = WORKERFS.node_ops
        node.stream_ops = WORKERFS.stream_ops
        node.timestamp = (mtime || new Date).getTime()
        assert(WORKERFS.FILE_MODE !== WORKERFS.DIR_MODE)
        if (mode === WORKERFS.FILE_MODE) {
          node.size = contents.size
          node.contents = contents
        } else {
          node.size = 4096
          node.contents = {}
        }
        if (parent) {
          parent.contents[name] = node
        }
        return node
      }), node_ops: {
        getattr: (function(node) {
          return {
            dev: 1,
            ino: undefined,
            mode: node.mode,
            nlink: 1,
            uid: 0,
            gid: 0,
            rdev: undefined,
            size: node.size,
            atime: new Date(node.timestamp),
            mtime: new Date(node.timestamp),
            ctime: new Date(node.timestamp),
            blksize: 4096,
            blocks: Math.ceil(node.size / 4096)
          }
        }), setattr: (function(node, attr) {
          if (attr.mode !== undefined) {
            node.mode = attr.mode
          }
          if (attr.timestamp !== undefined) {
            node.timestamp = attr.timestamp
          }
        }), lookup: (function(parent, name) {
          throw new FS.ErrnoError(ERRNO_CODES.ENOENT)
        }), mknod: (function(parent, name, mode, dev) {
          throw new FS.ErrnoError(ERRNO_CODES.EPERM)
        }), rename: (function(oldNode, newDir, newName) {
          throw new FS.ErrnoError(ERRNO_CODES.EPERM)
        }), unlink: (function(parent, name) {
          throw new FS.ErrnoError(ERRNO_CODES.EPERM)
        }), rmdir: (function(parent, name) {
          throw new FS.ErrnoError(ERRNO_CODES.EPERM)
        }), readdir: (function(node) {
          var entries = [".", ".."]
          for (var key in node.contents) {
            if (!node.contents.hasOwnProperty(key)) {
              continue
            }
            entries.push(key)
          }
          return entries
        }), symlink: (function(parent, newName, oldPath) {
          throw new FS.ErrnoError(ERRNO_CODES.EPERM)
        }), readlink: (function(node) {
          throw new FS.ErrnoError(ERRNO_CODES.EPERM)
        })
      }, stream_ops: {
        read: (function(stream, buffer, offset, length, position) {
          if (position >= stream.node.size) {
            return 0
          }
          var chunk = stream.node.contents.slice(position, position + length)
          var ab = WORKERFS.reader.readAsArrayBuffer(chunk)
          buffer.set(new Uint8Array(ab), offset)
          return chunk.size
        }), write: (function(stream, buffer, offset, length, position) {
          throw new FS.ErrnoError(ERRNO_CODES.EIO)
        }), llseek: (function(stream, offset, whence) {
          var position = offset
          if (whence === 1) {
            position += stream.position
          } else if (whence === 2) {
            if (FS.isFile(stream.node.mode)) {
              position += stream.node.size
            }
          }
          if (position < 0) {
            throw new FS.ErrnoError(ERRNO_CODES.EINVAL)
          }
          return position
        })
      }
    }
    STATICTOP += 16
    STATICTOP += 16
    STATICTOP += 16
    var FS = {
      root: null,
      mounts: [],
      devices: {},
      streams: [],
      nextInode: 1,
      nameTable: null,
      currentPath: "/",
      initialized: false,
      ignorePermissions: true,
      trackingDelegate: {},
      tracking: { openFlags: { READ: 1, WRITE: 2 } },
      ErrnoError: null,
      genericErrors: {},
      filesystems: null,
      syncFSRequests: 0,
      handleFSError: (function(e) {
        if (!(e instanceof FS.ErrnoError)) {
          throw e + " : " + stackTrace()
        }
        return ___setErrNo(e.errno)
      }),
      lookupPath: (function(path, opts) {
        path = PATH.resolve(FS.cwd(), path)
        opts = opts || {}
        if (!path) {
          return { path: "", node: null }
        }
        var defaults = { follow_mount: true, recurse_count: 0 }
        for (var key in defaults) {
          if (opts[key] === undefined) {
            opts[key] = defaults[key]
          }
        }
        if (opts.recurse_count > 8) {
          throw new FS.ErrnoError(ERRNO_CODES.ELOOP)
        }
        var parts = PATH.normalizeArray(path.split("/").filter((function(p) {
          return !!p
        })), false)
        var current = FS.root
        var current_path = "/"
        for (var i = 0; i < parts.length; i++) {
          var islast = i === parts.length - 1
          if (islast && opts.parent) {
            break
          }
          current = FS.lookupNode(current, parts[i])
          current_path = PATH.join2(current_path, parts[i])
          if (FS.isMountpoint(current)) {
            if (!islast || islast && opts.follow_mount) {
              current = current.mounted.root
            }
          }
          if (!islast || opts.follow) {
            var count = 0
            while (FS.isLink(current.mode)) {
              var link = FS.readlink(current_path)
              current_path = PATH.resolve(PATH.dirname(current_path), link)
              var lookup = FS.lookupPath(current_path, { recurse_count: opts.recurse_count })
              current = lookup.node
              if (count++ > 40) {
                throw new FS.ErrnoError(ERRNO_CODES.ELOOP)
              }
            }
          }
        }
        return { path: current_path, node: current }
      }),
      getPath: (function(node) {
        var path
        while (true) {
          if (FS.isRoot(node)) {
            var mount = node.mount.mountpoint
            if (!path) {
              return mount
            }
            return mount[mount.length - 1] !== "/" ? mount + "/" + path : mount + path
          }
          path = path ? node.name + "/" + path : node.name
          node = node.parent
        }
      }),
      hashName: (function(parentid, name) {
        var hash = 0
        for (var i = 0; i < name.length; i++) {
          hash = (hash << 5) - hash + name.charCodeAt(i) | 0
        }
        return (parentid + hash >>> 0) % FS.nameTable.length
      }),
      hashAddNode: (function(node) {
        var hash = FS.hashName(node.parent.id, node.name)
        node.name_next = FS.nameTable[hash]
        FS.nameTable[hash] = node
      }),
      hashRemoveNode: (function(node) {
        var hash = FS.hashName(node.parent.id, node.name)
        if (FS.nameTable[hash] === node) {
          FS.nameTable[hash] = node.name_next
        } else {
          var current = FS.nameTable[hash]
          while (current) {
            if (current.name_next === node) {
              current.name_next = node.name_next
              break
            }
            current = current.name_next
          }
        }
      }),
      lookupNode: (function(parent, name) {
        var err = FS.mayLookup(parent)
        if (err) {
          throw new FS.ErrnoError(err, parent)
        }
        var hash = FS.hashName(parent.id, name)
        for (var node = FS.nameTable[hash]; node; node = node.name_next) {
          var nodeName = node.name
          if (node.parent.id === parent.id && nodeName === name) {
            return node
          }
        }
        return FS.lookup(parent, name)
      }),
      createNode: (function(parent, name, mode, rdev) {
        if (!FS.FSNode) {
          FS.FSNode = (function(parent, name, mode, rdev) {
            if (!parent) {
              parent = this
            }
            this.parent = parent
            this.mount = parent.mount
            this.mounted = null
            this.id = FS.nextInode++
            this.name = name
            this.mode = mode
            this.node_ops = {}
            this.stream_ops = {}
            this.rdev = rdev
          })
          FS.FSNode.prototype = {}
          var readMode = 292 | 73
          var writeMode = 146
          Object.defineProperties(FS.FSNode.prototype, {
            read: {
              get: (function() {
                return (this.mode & readMode) === readMode
              }), set: (function(val) {
                val ? this.mode |= readMode : this.mode &= ~readMode
              })
            }, write: {
              get: (function() {
                return (this.mode & writeMode) === writeMode
              }), set: (function(val) {
                val ? this.mode |= writeMode : this.mode &= ~writeMode
              })
            }, isFolder: {
              get: (function() {
                return FS.isDir(this.mode)
              })
            }, isDevice: {
              get: (function() {
                return FS.isChrdev(this.mode)
              })
            }
          })
        }
        var node = new FS.FSNode(parent, name, mode, rdev)
        FS.hashAddNode(node)
        return node
      }),
      destroyNode: (function(node) {
        FS.hashRemoveNode(node)
      }),
      isRoot: (function(node) {
        return node === node.parent
      }),
      isMountpoint: (function(node) {
        return !!node.mounted
      }),
      isFile: (function(mode) {
        return (mode & 61440) === 32768
      }),
      isDir: (function(mode) {
        return (mode & 61440) === 16384
      }),
      isLink: (function(mode) {
        return (mode & 61440) === 40960
      }),
      isChrdev: (function(mode) {
        return (mode & 61440) === 8192
      }),
      isBlkdev: (function(mode) {
        return (mode & 61440) === 24576
      }),
      isFIFO: (function(mode) {
        return (mode & 61440) === 4096
      }),
      isSocket: (function(mode) {
        return (mode & 49152) === 49152
      }),
      flagModes: {
        "r": 0,
        "rs": 1052672,
        "r+": 2,
        "w": 577,
        "wx": 705,
        "xw": 705,
        "w+": 578,
        "wx+": 706,
        "xw+": 706,
        "a": 1089,
        "ax": 1217,
        "xa": 1217,
        "a+": 1090,
        "ax+": 1218,
        "xa+": 1218
      },
      modeStringToFlags: (function(str) {
        var flags = FS.flagModes[str]
        if (typeof flags === "undefined") {
          throw new Error("Unknown file open mode: " + str)
        }
        return flags
      }),
      flagsToPermissionString: (function(flag) {
        var perms = ["r", "w", "rw"][flag & 3]
        if (flag & 512) {
          perms += "w"
        }
        return perms
      }),
      nodePermissions: (function(node, perms) {
        if (FS.ignorePermissions) {
          return 0
        }
        if (perms.indexOf("r") !== -1 && !(node.mode & 292)) {
          return ERRNO_CODES.EACCES
        } else if (perms.indexOf("w") !== -1 && !(node.mode & 146)) {
          return ERRNO_CODES.EACCES
        } else if (perms.indexOf("x") !== -1 && !(node.mode & 73)) {
          return ERRNO_CODES.EACCES
        }
        return 0
      }),
      mayLookup: (function(dir) {
        var err = FS.nodePermissions(dir, "x")
        if (err) {
          return err
        }
        if (!dir.node_ops.lookup) {
          return ERRNO_CODES.EACCES
        }
        return 0
      }),
      mayCreate: (function(dir, name) {
        try {
          var node = FS.lookupNode(dir, name)
          return ERRNO_CODES.EEXIST
        } catch (e) {
        }
        return FS.nodePermissions(dir, "wx")
      }),
      mayDelete: (function(dir, name, isdir) {
        var node
        try {
          node = FS.lookupNode(dir, name)
        } catch (e) {
          return e.errno
        }
        var err = FS.nodePermissions(dir, "wx")
        if (err) {
          return err
        }
        if (isdir) {
          if (!FS.isDir(node.mode)) {
            return ERRNO_CODES.ENOTDIR
          }
          if (FS.isRoot(node) || FS.getPath(node) === FS.cwd()) {
            return ERRNO_CODES.EBUSY
          }
        } else {
          if (FS.isDir(node.mode)) {
            return ERRNO_CODES.EISDIR
          }
        }
        return 0
      }),
      mayOpen: (function(node, flags) {
        if (!node) {
          return ERRNO_CODES.ENOENT
        }
        if (FS.isLink(node.mode)) {
          return ERRNO_CODES.ELOOP
        } else if (FS.isDir(node.mode)) {
          if (FS.flagsToPermissionString(flags) !== "r" || flags & 512) {
            return ERRNO_CODES.EISDIR
          }
        }
        return FS.nodePermissions(node, FS.flagsToPermissionString(flags))
      }),
      MAX_OPEN_FDS: 4096,
      nextfd: (function(fd_start, fd_end) {
        fd_start = fd_start || 0
        fd_end = fd_end || FS.MAX_OPEN_FDS
        for (var fd = fd_start; fd <= fd_end; fd++) {
          if (!FS.streams[fd]) {
            return fd
          }
        }
        throw new FS.ErrnoError(ERRNO_CODES.EMFILE)
      }),
      getStream: (function(fd) {
        return FS.streams[fd]
      }),
      createStream: (function(stream, fd_start, fd_end) {
        if (!FS.FSStream) {
          FS.FSStream = (function() {
          })
          FS.FSStream.prototype = {}
          Object.defineProperties(FS.FSStream.prototype, {
            object: {
              get: (function() {
                return this.node
              }), set: (function(val) {
                this.node = val
              })
            }, isRead: {
              get: (function() {
                return (this.flags & 2097155) !== 1
              })
            }, isWrite: {
              get: (function() {
                return (this.flags & 2097155) !== 0
              })
            }, isAppend: {
              get: (function() {
                return this.flags & 1024
              })
            }
          })
        }
        var newStream = new FS.FSStream
        for (var p in stream) {
          newStream[p] = stream[p]
        }
        stream = newStream
        var fd = FS.nextfd(fd_start, fd_end)
        stream.fd = fd
        FS.streams[fd] = stream
        return stream
      }),
      closeStream: (function(fd) {
        FS.streams[fd] = null
      }),
      chrdev_stream_ops: {
        open: (function(stream) {
          var device = FS.getDevice(stream.node.rdev)
          stream.stream_ops = device.stream_ops
          if (stream.stream_ops.open) {
            stream.stream_ops.open(stream)
          }
        }), llseek: (function() {
          throw new FS.ErrnoError(ERRNO_CODES.ESPIPE)
        })
      },
      major: (function(dev) {
        return dev >> 8
      }),
      minor: (function(dev) {
        return dev & 255
      }),
      makedev: (function(ma, mi) {
        return ma << 8 | mi
      }),
      registerDevice: (function(dev, ops) {
        FS.devices[dev] = { stream_ops: ops }
      }),
      getDevice: (function(dev) {
        return FS.devices[dev]
      }),
      getMounts: (function(mount) {
        var mounts = []
        var check = [mount]
        while (check.length) {
          var m = check.pop()
          mounts.push(m)
          check.push.apply(check, m.mounts)
        }
        return mounts
      }),
      syncfs: (function(populate, callback) {
        if (typeof populate === "function") {
          callback = populate
          populate = false
        }
        FS.syncFSRequests++
        if (FS.syncFSRequests > 1) {
          console.log("warning: " + FS.syncFSRequests
              + " FS.syncfs operations in flight at once, probably just doing extra work")
        }
        var mounts = FS.getMounts(FS.root.mount)
        var completed = 0

        function doCallback(err) {
          assert(FS.syncFSRequests > 0)
          FS.syncFSRequests--
          return callback(err)
        }

        function done(err) {
          if (err) {
            if (!done.errored) {
              done.errored = true
              return doCallback(err)
            }
            return
          }
          if (++completed >= mounts.length) {
            doCallback(null)
          }
        }

        mounts.forEach((function(mount) {
          if (!mount.type.syncfs) {
            return done(null)
          }
          mount.type.syncfs(mount, populate, done)
        }))
      }),
      mount: (function(type, opts, mountpoint) {
        var root = mountpoint === "/"
        var pseudo = !mountpoint
        var node
        if (root && FS.root) {
          throw new FS.ErrnoError(ERRNO_CODES.EBUSY)
        } else if (!root && !pseudo) {
          var lookup = FS.lookupPath(mountpoint, { follow_mount: false })
          mountpoint = lookup.path
          node = lookup.node
          if (FS.isMountpoint(node)) {
            throw new FS.ErrnoError(ERRNO_CODES.EBUSY)
          }
          if (!FS.isDir(node.mode)) {
            throw new FS.ErrnoError(ERRNO_CODES.ENOTDIR)
          }
        }
        var mount = { type: type, opts: opts, mountpoint: mountpoint, mounts: [] }
        var mountRoot = type.mount(mount)
        mountRoot.mount = mount
        mount.root = mountRoot
        if (root) {
          FS.root = mountRoot
        } else if (node) {
          node.mounted = mount
          if (node.mount) {
            node.mount.mounts.push(mount)
          }
        }
        return mountRoot
      }),
      unmount: (function(mountpoint) {
        var lookup = FS.lookupPath(mountpoint, { follow_mount: false })
        if (!FS.isMountpoint(lookup.node)) {
          throw new FS.ErrnoError(ERRNO_CODES.EINVAL)
        }
        var node = lookup.node
        var mount = node.mounted
        var mounts = FS.getMounts(mount)
        Object.keys(FS.nameTable).forEach((function(hash) {
          var current = FS.nameTable[hash]
          while (current) {
            var next = current.name_next
            if (mounts.indexOf(current.mount) !== -1) {
              FS.destroyNode(current)
            }
            current = next
          }
        }))
        node.mounted = null
        var idx = node.mount.mounts.indexOf(mount)
        assert(idx !== -1)
        node.mount.mounts.splice(idx, 1)
      }),
      lookup: (function(parent, name) {
        return parent.node_ops.lookup(parent, name)
      }),
      mknod: (function(path, mode, dev) {
        var lookup = FS.lookupPath(path, { parent: true })
        var parent = lookup.node
        var name = PATH.basename(path)
        if (!name || name === "." || name === "..") {
          throw new FS.ErrnoError(ERRNO_CODES.EINVAL)
        }
        var err = FS.mayCreate(parent, name)
        if (err) {
          throw new FS.ErrnoError(err)
        }
        if (!parent.node_ops.mknod) {
          throw new FS.ErrnoError(ERRNO_CODES.EPERM)
        }
        return parent.node_ops.mknod(parent, name, mode, dev)
      }),
      create: (function(path, mode) {
        mode = mode !== undefined ? mode : 438
        mode &= 4095
        mode |= 32768
        return FS.mknod(path, mode, 0)
      }),
      mkdir: (function(path, mode) {
        mode = mode !== undefined ? mode : 511
        mode &= 511 | 512
        mode |= 16384
        return FS.mknod(path, mode, 0)
      }),
      mkdirTree: (function(path, mode) {
        var dirs = path.split("/")
        var d = ""
        for (var i = 0; i < dirs.length; ++i) {
          if (!dirs[i]) {
            continue
          }
          d += "/" + dirs[i]
          try {
            FS.mkdir(d, mode)
          } catch (e) {
            if (e.errno != ERRNO_CODES.EEXIST) {
              throw e
            }
          }
        }
      }),
      mkdev: (function(path, mode, dev) {
        if (typeof dev === "undefined") {
          dev = mode
          mode = 438
        }
        mode |= 8192
        return FS.mknod(path, mode, dev)
      }),
      symlink: (function(oldpath, newpath) {
        if (!PATH.resolve(oldpath)) {
          throw new FS.ErrnoError(ERRNO_CODES.ENOENT)
        }
        var lookup = FS.lookupPath(newpath, { parent: true })
        var parent = lookup.node
        if (!parent) {
          throw new FS.ErrnoError(ERRNO_CODES.ENOENT)
        }
        var newname = PATH.basename(newpath)
        var err = FS.mayCreate(parent, newname)
        if (err) {
          throw new FS.ErrnoError(err)
        }
        if (!parent.node_ops.symlink) {
          throw new FS.ErrnoError(ERRNO_CODES.EPERM)
        }
        return parent.node_ops.symlink(parent, newname, oldpath)
      }),
      rename: (function(old_path, new_path) {
        var old_dirname = PATH.dirname(old_path)
        var new_dirname = PATH.dirname(new_path)
        var old_name = PATH.basename(old_path)
        var new_name = PATH.basename(new_path)
        var lookup, old_dir, new_dir
        try {
          lookup = FS.lookupPath(old_path, { parent: true })
          old_dir = lookup.node
          lookup = FS.lookupPath(new_path, { parent: true })
          new_dir = lookup.node
        } catch (e) {
          throw new FS.ErrnoError(ERRNO_CODES.EBUSY)
        }
        if (!old_dir || !new_dir) {
          throw new FS.ErrnoError(ERRNO_CODES.ENOENT)
        }
        if (old_dir.mount !== new_dir.mount) {
          throw new FS.ErrnoError(ERRNO_CODES.EXDEV)
        }
        var old_node = FS.lookupNode(old_dir, old_name)
        var relative = PATH.relative(old_path, new_dirname)
        if (relative.charAt(0) !== ".") {
          throw new FS.ErrnoError(ERRNO_CODES.EINVAL)
        }
        relative = PATH.relative(new_path, old_dirname)
        if (relative.charAt(0) !== ".") {
          throw new FS.ErrnoError(ERRNO_CODES.ENOTEMPTY)
        }
        var new_node
        try {
          new_node = FS.lookupNode(new_dir, new_name)
        } catch (e) {
        }
        if (old_node === new_node) {
          return
        }
        var isdir = FS.isDir(old_node.mode)
        var err = FS.mayDelete(old_dir, old_name, isdir)
        if (err) {
          throw new FS.ErrnoError(err)
        }
        err = new_node ? FS.mayDelete(new_dir, new_name, isdir) : FS.mayCreate(new_dir, new_name)
        if (err) {
          throw new FS.ErrnoError(err)
        }
        if (!old_dir.node_ops.rename) {
          throw new FS.ErrnoError(ERRNO_CODES.EPERM)
        }
        if (FS.isMountpoint(old_node) || new_node && FS.isMountpoint(new_node)) {
          throw new FS.ErrnoError(ERRNO_CODES.EBUSY)
        }
        if (new_dir !== old_dir) {
          err = FS.nodePermissions(old_dir, "w")
          if (err) {
            throw new FS.ErrnoError(err)
          }
        }
        try {
          if (FS.trackingDelegate["willMovePath"]) {
            FS.trackingDelegate["willMovePath"](old_path, new_path)
          }
        } catch (e) {
          console.log("FS.trackingDelegate['willMovePath']('" + old_path + "', '" + new_path + "') threw an exception: "
              + e.message)
        }
        FS.hashRemoveNode(old_node)
        try {
          old_dir.node_ops.rename(old_node, new_dir, new_name)
        } catch (e) {
          throw e
        } finally {
          FS.hashAddNode(old_node)
        }
        try {
          if (FS.trackingDelegate["onMovePath"]) {
            FS.trackingDelegate["onMovePath"](old_path, new_path)
          }
        } catch (e) {
          console.log("FS.trackingDelegate['onMovePath']('" + old_path + "', '" + new_path + "') threw an exception: "
              + e.message)
        }
      }),
      rmdir: (function(path) {
        var lookup = FS.lookupPath(path, { parent: true })
        var parent = lookup.node
        var name = PATH.basename(path)
        var node = FS.lookupNode(parent, name)
        var err = FS.mayDelete(parent, name, true)
        if (err) {
          throw new FS.ErrnoError(err)
        }
        if (!parent.node_ops.rmdir) {
          throw new FS.ErrnoError(ERRNO_CODES.EPERM)
        }
        if (FS.isMountpoint(node)) {
          throw new FS.ErrnoError(ERRNO_CODES.EBUSY)
        }
        try {
          if (FS.trackingDelegate["willDeletePath"]) {
            FS.trackingDelegate["willDeletePath"](path)
          }
        } catch (e) {
          console.log("FS.trackingDelegate['willDeletePath']('" + path + "') threw an exception: " + e.message)
        }
        parent.node_ops.rmdir(parent, name)
        FS.destroyNode(node)
        try {
          if (FS.trackingDelegate["onDeletePath"]) {
            FS.trackingDelegate["onDeletePath"](path)
          }
        } catch (e) {
          console.log("FS.trackingDelegate['onDeletePath']('" + path + "') threw an exception: " + e.message)
        }
      }),
      readdir: (function(path) {
        var lookup = FS.lookupPath(path, { follow: true })
        var node = lookup.node
        if (!node.node_ops.readdir) {
          throw new FS.ErrnoError(ERRNO_CODES.ENOTDIR)
        }
        return node.node_ops.readdir(node)
      }),
      unlink: (function(path) {
        var lookup = FS.lookupPath(path, { parent: true })
        var parent = lookup.node
        var name = PATH.basename(path)
        var node = FS.lookupNode(parent, name)
        var err = FS.mayDelete(parent, name, false)
        if (err) {
          throw new FS.ErrnoError(err)
        }
        if (!parent.node_ops.unlink) {
          throw new FS.ErrnoError(ERRNO_CODES.EPERM)
        }
        if (FS.isMountpoint(node)) {
          throw new FS.ErrnoError(ERRNO_CODES.EBUSY)
        }
        try {
          if (FS.trackingDelegate["willDeletePath"]) {
            FS.trackingDelegate["willDeletePath"](path)
          }
        } catch (e) {
          console.log("FS.trackingDelegate['willDeletePath']('" + path + "') threw an exception: " + e.message)
        }
        parent.node_ops.unlink(parent, name)
        FS.destroyNode(node)
        try {
          if (FS.trackingDelegate["onDeletePath"]) {
            FS.trackingDelegate["onDeletePath"](path)
          }
        } catch (e) {
          console.log("FS.trackingDelegate['onDeletePath']('" + path + "') threw an exception: " + e.message)
        }
      }),
      readlink: (function(path) {
        var lookup = FS.lookupPath(path)
        var link = lookup.node
        if (!link) {
          throw new FS.ErrnoError(ERRNO_CODES.ENOENT)
        }
        if (!link.node_ops.readlink) {
          throw new FS.ErrnoError(ERRNO_CODES.EINVAL)
        }
        return PATH.resolve(FS.getPath(link.parent), link.node_ops.readlink(link))
      }),
      stat: (function(path, dontFollow) {
        var lookup = FS.lookupPath(path, { follow: !dontFollow })
        var node = lookup.node
        if (!node) {
          throw new FS.ErrnoError(ERRNO_CODES.ENOENT)
        }
        if (!node.node_ops.getattr) {
          throw new FS.ErrnoError(ERRNO_CODES.EPERM)
        }
        return node.node_ops.getattr(node)
      }),
      lstat: (function(path) {
        return FS.stat(path, true)
      }),
      chmod: (function(path, mode, dontFollow) {
        var node
        if (typeof path === "string") {
          var lookup = FS.lookupPath(path, { follow: !dontFollow })
          node = lookup.node
        } else {
          node = path
        }
        if (!node.node_ops.setattr) {
          throw new FS.ErrnoError(ERRNO_CODES.EPERM)
        }
        node.node_ops.setattr(node, { mode: mode & 4095 | node.mode & ~4095, timestamp: Date.now() })
      }),
      lchmod: (function(path, mode) {
        FS.chmod(path, mode, true)
      }),
      fchmod: (function(fd, mode) {
        var stream = FS.getStream(fd)
        if (!stream) {
          throw new FS.ErrnoError(ERRNO_CODES.EBADF)
        }
        FS.chmod(stream.node, mode)
      }),
      chown: (function(path, uid, gid, dontFollow) {
        var node
        if (typeof path === "string") {
          var lookup = FS.lookupPath(path, { follow: !dontFollow })
          node = lookup.node
        } else {
          node = path
        }
        if (!node.node_ops.setattr) {
          throw new FS.ErrnoError(ERRNO_CODES.EPERM)
        }
        node.node_ops.setattr(node, { timestamp: Date.now() })
      }),
      lchown: (function(path, uid, gid) {
        FS.chown(path, uid, gid, true)
      }),
      fchown: (function(fd, uid, gid) {
        var stream = FS.getStream(fd)
        if (!stream) {
          throw new FS.ErrnoError(ERRNO_CODES.EBADF)
        }
        FS.chown(stream.node, uid, gid)
      }),
      truncate: (function(path, len) {
        if (len < 0) {
          throw new FS.ErrnoError(ERRNO_CODES.EINVAL)
        }
        var node
        if (typeof path === "string") {
          var lookup = FS.lookupPath(path, { follow: true })
          node = lookup.node
        } else {
          node = path
        }
        if (!node.node_ops.setattr) {
          throw new FS.ErrnoError(ERRNO_CODES.EPERM)
        }
        if (FS.isDir(node.mode)) {
          throw new FS.ErrnoError(ERRNO_CODES.EISDIR)
        }
        if (!FS.isFile(node.mode)) {
          throw new FS.ErrnoError(ERRNO_CODES.EINVAL)
        }
        var err = FS.nodePermissions(node, "w")
        if (err) {
          throw new FS.ErrnoError(err)
        }
        node.node_ops.setattr(node, { size: len, timestamp: Date.now() })
      }),
      ftruncate: (function(fd, len) {
        var stream = FS.getStream(fd)
        if (!stream) {
          throw new FS.ErrnoError(ERRNO_CODES.EBADF)
        }
        if ((stream.flags & 2097155) === 0) {
          throw new FS.ErrnoError(ERRNO_CODES.EINVAL)
        }
        FS.truncate(stream.node, len)
      }),
      utime: (function(path, atime, mtime) {
        var lookup = FS.lookupPath(path, { follow: true })
        var node = lookup.node
        node.node_ops.setattr(node, { timestamp: Math.max(atime, mtime) })
      }),
      open: (function(path, flags, mode, fd_start, fd_end) {
        if (path === "") {
          throw new FS.ErrnoError(ERRNO_CODES.ENOENT)
        }
        flags = typeof flags === "string" ? FS.modeStringToFlags(flags) : flags
        mode = typeof mode === "undefined" ? 438 : mode
        if (flags & 64) {
          mode = mode & 4095 | 32768
        } else {
          mode = 0
        }
        var node
        if (typeof path === "object") {
          node = path
        } else {
          path = PATH.normalize(path)
          try {
            var lookup = FS.lookupPath(path, { follow: !(flags & 131072) })
            node = lookup.node
          } catch (e) {
          }
        }
        var created = false
        if (flags & 64) {
          if (node) {
            if (flags & 128) {
              throw new FS.ErrnoError(ERRNO_CODES.EEXIST)
            }
          } else {
            node = FS.mknod(path, mode, 0)
            created = true
          }
        }
        if (!node) {
          throw new FS.ErrnoError(ERRNO_CODES.ENOENT)
        }
        if (FS.isChrdev(node.mode)) {
          flags &= ~512
        }
        if (flags & 65536 && !FS.isDir(node.mode)) {
          throw new FS.ErrnoError(ERRNO_CODES.ENOTDIR)
        }
        if (!created) {
          var err = FS.mayOpen(node, flags)
          if (err) {
            throw new FS.ErrnoError(err)
          }
        }
        if (flags & 512) {
          FS.truncate(node, 0)
        }
        flags &= ~(128 | 512)
        var stream = FS.createStream({
          node: node,
          path: FS.getPath(node),
          flags: flags,
          seekable: true,
          position: 0,
          stream_ops: node.stream_ops,
          ungotten: [],
          error: false
        }, fd_start, fd_end)
        if (stream.stream_ops.open) {
          stream.stream_ops.open(stream)
        }
        if (Module["logReadFiles"] && !(flags & 1)) {
          if (!FS.readFiles) {
            FS.readFiles = {}
          }
          if (!(path in FS.readFiles)) {
            FS.readFiles[path] = 1
            Module["printErr"]("read file: " + path)
          }
        }
        try {
          if (FS.trackingDelegate["onOpenFile"]) {
            var trackingFlags = 0
            if ((flags & 2097155) !== 1) {
              trackingFlags |= FS.tracking.openFlags.READ
            }
            if ((flags & 2097155) !== 0) {
              trackingFlags |= FS.tracking.openFlags.WRITE
            }
            FS.trackingDelegate["onOpenFile"](path, trackingFlags)
          }
        } catch (e) {
          console.log("FS.trackingDelegate['onOpenFile']('" + path + "', flags) threw an exception: " + e.message)
        }
        return stream
      }),
      close: (function(stream) {
        if (stream.getdents) {
          stream.getdents = null
        }
        try {
          if (stream.stream_ops.close) {
            stream.stream_ops.close(stream)
          }
        } catch (e) {
          throw e
        } finally {
          FS.closeStream(stream.fd)
        }
      }),
      llseek: (function(stream, offset, whence) {
        if (!stream.seekable || !stream.stream_ops.llseek) {
          throw new FS.ErrnoError(ERRNO_CODES.ESPIPE)
        }
        stream.position = stream.stream_ops.llseek(stream, offset, whence)
        stream.ungotten = []
        return stream.position
      }),
      read: (function(stream, buffer, offset, length, position) {
        if (length < 0 || position < 0) {
          throw new FS.ErrnoError(ERRNO_CODES.EINVAL)
        }
        if ((stream.flags & 2097155) === 1) {
          throw new FS.ErrnoError(ERRNO_CODES.EBADF)
        }
        if (FS.isDir(stream.node.mode)) {
          throw new FS.ErrnoError(ERRNO_CODES.EISDIR)
        }
        if (!stream.stream_ops.read) {
          throw new FS.ErrnoError(ERRNO_CODES.EINVAL)
        }
        var seeking = typeof position !== "undefined"
        if (!seeking) {
          position = stream.position
        } else if (!stream.seekable) {
          throw new FS.ErrnoError(ERRNO_CODES.ESPIPE)
        }
        var bytesRead = stream.stream_ops.read(stream, buffer, offset, length, position)
        if (!seeking) {
          stream.position += bytesRead
        }
        return bytesRead
      }),
      write: (function(stream, buffer, offset, length, position, canOwn) {
        if (length < 0 || position < 0) {
          throw new FS.ErrnoError(ERRNO_CODES.EINVAL)
        }
        if ((stream.flags & 2097155) === 0) {
          throw new FS.ErrnoError(ERRNO_CODES.EBADF)
        }
        if (FS.isDir(stream.node.mode)) {
          throw new FS.ErrnoError(ERRNO_CODES.EISDIR)
        }
        if (!stream.stream_ops.write) {
          throw new FS.ErrnoError(ERRNO_CODES.EINVAL)
        }
        if (stream.flags & 1024) {
          FS.llseek(stream, 0, 2)
        }
        var seeking = typeof position !== "undefined"
        if (!seeking) {
          position = stream.position
        } else if (!stream.seekable) {
          throw new FS.ErrnoError(ERRNO_CODES.ESPIPE)
        }
        var bytesWritten = stream.stream_ops.write(stream, buffer, offset, length, position, canOwn)
        if (!seeking) {
          stream.position += bytesWritten
        }
        try {
          if (stream.path && FS.trackingDelegate["onWriteToFile"]) {
            FS.trackingDelegate["onWriteToFile"](stream.path)
          }
        } catch (e) {
          console.log("FS.trackingDelegate['onWriteToFile']('" + path + "') threw an exception: " + e.message)
        }
        return bytesWritten
      }),
      allocate: (function(stream, offset, length) {
        if (offset < 0 || length <= 0) {
          throw new FS.ErrnoError(ERRNO_CODES.EINVAL)
        }
        if ((stream.flags & 2097155) === 0) {
          throw new FS.ErrnoError(ERRNO_CODES.EBADF)
        }
        if (!FS.isFile(stream.node.mode) && !FS.isDir(stream.node.mode)) {
          throw new FS.ErrnoError(ERRNO_CODES.ENODEV)
        }
        if (!stream.stream_ops.allocate) {
          throw new FS.ErrnoError(ERRNO_CODES.EOPNOTSUPP)
        }
        stream.stream_ops.allocate(stream, offset, length)
      }),
      mmap: (function(stream, buffer, offset, length, position, prot, flags) {
        if ((stream.flags & 2097155) === 1) {
          throw new FS.ErrnoError(ERRNO_CODES.EACCES)
        }
        if (!stream.stream_ops.mmap) {
          throw new FS.ErrnoError(ERRNO_CODES.ENODEV)
        }
        return stream.stream_ops.mmap(stream, buffer, offset, length, position, prot, flags)
      }),
      msync: (function(stream, buffer, offset, length, mmapFlags) {
        if (!stream || !stream.stream_ops.msync) {
          return 0
        }
        return stream.stream_ops.msync(stream, buffer, offset, length, mmapFlags)
      }),
      munmap: (function(stream) {
        return 0
      }),
      ioctl: (function(stream, cmd, arg) {
        if (!stream.stream_ops.ioctl) {
          throw new FS.ErrnoError(ERRNO_CODES.ENOTTY)
        }
        return stream.stream_ops.ioctl(stream, cmd, arg)
      }),
      readFile: (function(path, opts) {
        opts = opts || {}
        opts.flags = opts.flags || "r"
        opts.encoding = opts.encoding || "binary"
        if (opts.encoding !== "utf8" && opts.encoding !== "binary") {
          throw new Error('Invalid encoding type "' + opts.encoding + '"')
        }
        var ret
        var stream = FS.open(path, opts.flags)
        var stat = FS.stat(path)
        var length = stat.size
        var buf = new Uint8Array(length)
        FS.read(stream, buf, 0, length, 0)
        if (opts.encoding === "utf8") {
          ret = UTF8ArrayToString(buf, 0)
        } else if (opts.encoding === "binary") {
          ret = buf
        }
        FS.close(stream)
        return ret
      }),
      writeFile: (function(path, data, opts) {
        opts = opts || {}
        opts.flags = opts.flags || "w"
        var stream = FS.open(path, opts.flags, opts.mode)
        if (typeof data === "string") {
          var buf = new Uint8Array(lengthBytesUTF8(data) + 1)
          var actualNumBytes = stringToUTF8Array(data, buf, 0, buf.length)
          FS.write(stream, buf, 0, actualNumBytes, undefined, opts.canOwn)
        } else if (ArrayBuffer.isView(data)) {
          FS.write(stream, data, 0, data.byteLength, undefined, opts.canOwn)
        } else {
          throw new Error("Unsupported data type")
        }
        FS.close(stream)
      }),
      cwd: (function() {
        return FS.currentPath
      }),
      chdir: (function(path) {
        var lookup = FS.lookupPath(path, { follow: true })
        if (lookup.node === null) {
          throw new FS.ErrnoError(ERRNO_CODES.ENOENT)
        }
        if (!FS.isDir(lookup.node.mode)) {
          throw new FS.ErrnoError(ERRNO_CODES.ENOTDIR)
        }
        var err = FS.nodePermissions(lookup.node, "x")
        if (err) {
          throw new FS.ErrnoError(err)
        }
        FS.currentPath = lookup.path
      }),
      createDefaultDirectories: (function() {
        FS.mkdir("/tmp")
        FS.mkdir("/home")
        FS.mkdir("/home/web_user")
      }),
      createDefaultDevices: (function() {
        FS.mkdir("/dev")
        FS.registerDevice(FS.makedev(1, 3), {
          read: (function() {
            return 0
          }), write: (function(stream, buffer, offset, length, pos) {
            return length
          })
        })
        FS.mkdev("/dev/null", FS.makedev(1, 3))
        TTY.register(FS.makedev(5, 0), TTY.default_tty_ops)
        TTY.register(FS.makedev(6, 0), TTY.default_tty1_ops)
        FS.mkdev("/dev/tty", FS.makedev(5, 0))
        FS.mkdev("/dev/tty1", FS.makedev(6, 0))
        var random_device
        if (typeof crypto !== "undefined") {
          var randomBuffer = new Uint8Array(1)
          random_device = (function() {
            crypto.getRandomValues(randomBuffer)
            return randomBuffer[0]
          })
        } else if (ENVIRONMENT_IS_NODE) {
          random_device = (function() {
            return require("crypto")["randomBytes"](1)[0]
          })
        } else {
          random_device = (function() {
            return Math.random() * 256 | 0
          })
        }
        FS.createDevice("/dev", "random", random_device)
        FS.createDevice("/dev", "urandom", random_device)
        FS.mkdir("/dev/shm")
        FS.mkdir("/dev/shm/tmp")
      }),
      createSpecialDirectories: (function() {
        FS.mkdir("/proc")
        FS.mkdir("/proc/self")
        FS.mkdir("/proc/self/fd")
        FS.mount({
          mount: (function() {
            var node = FS.createNode("/proc/self", "fd", 16384 | 511, 73)
            node.node_ops = {
              lookup: (function(parent, name) {
                var fd = +name
                var stream = FS.getStream(fd)
                if (!stream) {
                  throw new FS.ErrnoError(ERRNO_CODES.EBADF)
                }
                var ret = {
                  parent: null, mount: { mountpoint: "fake" }, node_ops: {
                    readlink: (function() {
                      return stream.path
                    })
                  }
                }
                ret.parent = ret
                return ret
              })
            }
            return node
          })
        }, {}, "/proc/self/fd")
      }),
      createStandardStreams: (function() {
        if (Module["stdin"]) {
          FS.createDevice("/dev", "stdin", Module["stdin"])
        } else {
          FS.symlink("/dev/tty", "/dev/stdin")
        }
        if (Module["stdout"]) {
          FS.createDevice("/dev", "stdout", null, Module["stdout"])
        } else {
          FS.symlink("/dev/tty", "/dev/stdout")
        }
        if (Module["stderr"]) {
          FS.createDevice("/dev", "stderr", null, Module["stderr"])
        } else {
          FS.symlink("/dev/tty1", "/dev/stderr")
        }
        var stdin = FS.open("/dev/stdin", "r")
        assert(stdin.fd === 0, "invalid handle for stdin (" + stdin.fd + ")")
        var stdout = FS.open("/dev/stdout", "w")
        assert(stdout.fd === 1, "invalid handle for stdout (" + stdout.fd + ")")
        var stderr = FS.open("/dev/stderr", "w")
        assert(stderr.fd === 2, "invalid handle for stderr (" + stderr.fd + ")")
      }),
      ensureErrnoError: (function() {
        if (FS.ErrnoError) {
          return
        }
        FS.ErrnoError = function ErrnoError(errno, node) {
          this.node = node
          this.setErrno = (function(errno) {
            this.errno = errno
            for (var key in ERRNO_CODES) {
              if (ERRNO_CODES[key] === errno) {
                this.code = key
                break
              }
            }
          })
          this.setErrno(errno)
          this.message = ERRNO_MESSAGES[errno]
          if (this.stack) {
            Object.defineProperty(this, "stack", { value: (new Error).stack, writable: true })
          }
        }
        FS.ErrnoError.prototype = new Error
        FS.ErrnoError.prototype.constructor = FS.ErrnoError;
        [ERRNO_CODES.ENOENT].forEach((function(code) {
          FS.genericErrors[code] = new FS.ErrnoError(code)
          FS.genericErrors[code].stack = "<generic error, no stack>"
        }))
      }),
      staticInit: (function() {
        FS.ensureErrnoError()
        FS.nameTable = new Array(4096)
        FS.mount(MEMFS, {}, "/")
        FS.createDefaultDirectories()
        FS.createDefaultDevices()
        FS.createSpecialDirectories()
        FS.filesystems = { "MEMFS": MEMFS, "IDBFS": IDBFS, "NODEFS": NODEFS, "WORKERFS": WORKERFS }
      }),
      init: (function(input, output, error) {
        assert(!FS.init.initialized,
            "FS.init was previously called. If you want to initialize later with custom parameters, remove any earlier calls (note that one is automatically added to the generated code)")
        FS.init.initialized = true
        FS.ensureErrnoError()
        Module["stdin"] = input || Module["stdin"]
        Module["stdout"] = output || Module["stdout"]
        Module["stderr"] = error || Module["stderr"]
        FS.createStandardStreams()
      }),
      quit: (function() {
        FS.init.initialized = false
        var fflush = Module["_fflush"]
        if (fflush) {
          fflush(0)
        }
        for (var i = 0; i < FS.streams.length; i++) {
          var stream = FS.streams[i]
          if (!stream) {
            continue
          }
          FS.close(stream)
        }
      }),
      getMode: (function(canRead, canWrite) {
        var mode = 0
        if (canRead) {
          mode |= 292 | 73
        }
        if (canWrite) {
          mode |= 146
        }
        return mode
      }),
      joinPath: (function(parts, forceRelative) {
        var path = PATH.join.apply(null, parts)
        if (forceRelative && path[0] == "/") {
          path = path.substr(1)
        }
        return path
      }),
      absolutePath: (function(relative, base) {
        return PATH.resolve(base, relative)
      }),
      standardizePath: (function(path) {
        return PATH.normalize(path)
      }),
      findObject: (function(path, dontResolveLastLink) {
        var ret = FS.analyzePath(path, dontResolveLastLink)
        if (ret.exists) {
          return ret.object
        } else {
          ___setErrNo(ret.error)
          return null
        }
      }),
      analyzePath: (function(path, dontResolveLastLink) {
        try {
          var lookup = FS.lookupPath(path, { follow: !dontResolveLastLink })
          path = lookup.path
        } catch (e) {
        }
        var ret = {
          isRoot: false,
          exists: false,
          error: 0,
          name: null,
          path: null,
          object: null,
          parentExists: false,
          parentPath: null,
          parentObject: null
        }
        try {
          var lookup = FS.lookupPath(path, { parent: true })
          ret.parentExists = true
          ret.parentPath = lookup.path
          ret.parentObject = lookup.node
          ret.name = PATH.basename(path)
          lookup = FS.lookupPath(path, { follow: !dontResolveLastLink })
          ret.exists = true
          ret.path = lookup.path
          ret.object = lookup.node
          ret.name = lookup.node.name
          ret.isRoot = lookup.path === "/"
        } catch (e) {
          ret.error = e.errno
        }
        return ret
      }),
      createFolder: (function(parent, name, canRead, canWrite) {
        var path = PATH.join2(typeof parent === "string" ? parent : FS.getPath(parent), name)
        var mode = FS.getMode(canRead, canWrite)
        return FS.mkdir(path, mode)
      }),
      createPath: (function(parent, path, canRead, canWrite) {
        parent = typeof parent === "string" ? parent : FS.getPath(parent)
        var parts = path.split("/").reverse()
        while (parts.length) {
          var part = parts.pop()
          if (!part) {
            continue
          }
          var current = PATH.join2(parent, part)
          try {
            FS.mkdir(current)
          } catch (e) {
          }
          parent = current
        }
        return current
      }),
      createFile: (function(parent, name, properties, canRead, canWrite) {
        var path = PATH.join2(typeof parent === "string" ? parent : FS.getPath(parent), name)
        var mode = FS.getMode(canRead, canWrite)
        return FS.create(path, mode)
      }),
      createDataFile: (function(parent, name, data, canRead, canWrite, canOwn) {
        var path = name ? PATH.join2(typeof parent === "string" ? parent : FS.getPath(parent), name) : parent
        var mode = FS.getMode(canRead, canWrite)
        var node = FS.create(path, mode)
        if (data) {
          if (typeof data === "string") {
            var arr = new Array(data.length)
            for (var i = 0, len = data.length; i < len; ++i) {
              arr[i] = data.charCodeAt(i)
            }
            data = arr
          }
          FS.chmod(node, mode | 146)
          var stream = FS.open(node, "w")
          FS.write(stream, data, 0, data.length, 0, canOwn)
          FS.close(stream)
          FS.chmod(node, mode)
        }
        return node
      }),
      createDevice: (function(parent, name, input, output) {
        var path = PATH.join2(typeof parent === "string" ? parent : FS.getPath(parent), name)
        var mode = FS.getMode(!!input, !!output)
        if (!FS.createDevice.major) {
          FS.createDevice.major = 64
        }
        var dev = FS.makedev(FS.createDevice.major++, 0)
        FS.registerDevice(dev, {
          open: (function(stream) {
            stream.seekable = false
          }), close: (function(stream) {
            if (output && output.buffer && output.buffer.length) {
              output(10)
            }
          }), read: (function(stream, buffer, offset, length, pos) {
            var bytesRead = 0
            for (var i = 0; i < length; i++) {
              var result
              try {
                result = input()
              } catch (e) {
                throw new FS.ErrnoError(ERRNO_CODES.EIO)
              }
              if (result === undefined && bytesRead === 0) {
                throw new FS.ErrnoError(ERRNO_CODES.EAGAIN)
              }
              if (result === null || result === undefined) {
                break
              }
              bytesRead++
              buffer[offset + i] = result
            }
            if (bytesRead) {
              stream.node.timestamp = Date.now()
            }
            return bytesRead
          }), write: (function(stream, buffer, offset, length, pos) {
            for (var i = 0; i < length; i++) {
              try {
                output(buffer[offset + i])
              } catch (e) {
                throw new FS.ErrnoError(ERRNO_CODES.EIO)
              }
            }
            if (length) {
              stream.node.timestamp = Date.now()
            }
            return i
          })
        })
        return FS.mkdev(path, mode, dev)
      }),
      createLink: (function(parent, name, target, canRead, canWrite) {
        var path = PATH.join2(typeof parent === "string" ? parent : FS.getPath(parent), name)
        return FS.symlink(target, path)
      }),
      forceLoadFile: (function(obj) {
        if (obj.isDevice || obj.isFolder || obj.link || obj.contents) {
          return true
        }
        var success = true
        if (typeof XMLHttpRequest !== "undefined") {
          throw new Error(
              "Lazy loading should have been performed (contents set) in createLazyFile, but it was not. Lazy loading only works in web workers. Use --embed-file or --preload-file in emcc on the main thread.")
        } else if (Module["read"]) {
          try {
            obj.contents = intArrayFromString(Module["read"](obj.url), true)
            obj.usedBytes = obj.contents.length
          } catch (e) {
            success = false
          }
        } else {
          throw new Error("Cannot load without read() or XMLHttpRequest.")
        }
        if (!success) {
          ___setErrNo(ERRNO_CODES.EIO)
        }
        return success
      }),
      createLazyFile: (function(parent, name, url, canRead, canWrite) {
        function LazyUint8Array() {
          this.lengthKnown = false
          this.chunks = []
        }

        LazyUint8Array.prototype.get = function LazyUint8Array_get(idx) {
          if (idx > this.length - 1 || idx < 0) {
            return undefined
          }
          var chunkOffset = idx % this.chunkSize
          var chunkNum = idx / this.chunkSize | 0
          return this.getter(chunkNum)[chunkOffset]
        }
        LazyUint8Array.prototype.setDataGetter = function LazyUint8Array_setDataGetter(getter) {
          this.getter = getter
        }
        LazyUint8Array.prototype.cacheLength = function LazyUint8Array_cacheLength() {
          var xhr = new XMLHttpRequest
          xhr.open("HEAD", url, false)
          xhr.send(null)
          if (!(xhr.status >= 200 && xhr.status < 300 || xhr.status === 304)) {
            throw new Error(
                "Couldn't load " + url + ". Status: " + xhr.status)
          }
          var datalength = Number(xhr.getResponseHeader("Content-length"))
          var header
          var hasByteServing = (header = xhr.getResponseHeader("Accept-Ranges")) && header === "bytes"
          var usesGzip = (header = xhr.getResponseHeader("Content-Encoding")) && header === "gzip"
          var chunkSize = 1024 * 1024
          if (!hasByteServing) {
            chunkSize = datalength
          }
          var doXHR = (function(from, to) {
            if (from > to) {
              throw new Error("invalid range (" + from + ", " + to + ") or no bytes requested!")
            }
            if (to > datalength - 1) {
              throw new Error("only " + datalength + " bytes available! programmer error!")
            }
            var xhr = new XMLHttpRequest
            xhr.open("GET", url, false)
            if (datalength !== chunkSize) {
              xhr.setRequestHeader("Range", "bytes=" + from + "-" + to)
            }
            if (typeof Uint8Array != "undefined") {
              xhr.responseType = "arraybuffer"
            }
            if (xhr.overrideMimeType) {
              xhr.overrideMimeType("text/plain; charset=x-user-defined")
            }
            xhr.send(null)
            if (!(xhr.status >= 200 && xhr.status < 300 || xhr.status === 304)) {
              throw new Error(
                  "Couldn't load " + url + ". Status: " + xhr.status)
            }
            if (xhr.response !== undefined) {
              return new Uint8Array(xhr.response || [])
            } else {
              return intArrayFromString(xhr.responseText || "", true)
            }
          })
          var lazyArray = this
          lazyArray.setDataGetter((function(chunkNum) {
            var start = chunkNum * chunkSize
            var end = (chunkNum + 1) * chunkSize - 1
            end = Math.min(end, datalength - 1)
            if (typeof lazyArray.chunks[chunkNum] === "undefined") {
              lazyArray.chunks[chunkNum] = doXHR(start, end)
            }
            if (typeof lazyArray.chunks[chunkNum] === "undefined") {
              throw new Error("doXHR failed!")
            }
            return lazyArray.chunks[chunkNum]
          }))
          if (usesGzip || !datalength) {
            chunkSize = datalength = 1
            datalength = this.getter(0).length
            chunkSize = datalength
            console.log("LazyFiles on gzip forces download of the whole file when length is accessed")
          }
          this._length = datalength
          this._chunkSize = chunkSize
          this.lengthKnown = true
        }
        if (typeof XMLHttpRequest !== "undefined") {
          if (!ENVIRONMENT_IS_WORKER) {
            throw"Cannot do synchronous binary XHRs outside webworkers in modern browsers. Use --embed-file or --preload-file in emcc"
          }
          var lazyArray = new LazyUint8Array
          Object.defineProperties(lazyArray, {
            length: {
              get: (function() {
                if (!this.lengthKnown) {
                  this.cacheLength()
                }
                return this._length
              })
            }, chunkSize: {
              get: (function() {
                if (!this.lengthKnown) {
                  this.cacheLength()
                }
                return this._chunkSize
              })
            }
          })
          var properties = { isDevice: false, contents: lazyArray }
        } else {
          var properties = { isDevice: false, url: url }
        }
        var node = FS.createFile(parent, name, properties, canRead, canWrite)
        if (properties.contents) {
          node.contents = properties.contents
        } else if (properties.url) {
          node.contents = null
          node.url = properties.url
        }
        Object.defineProperties(node, {
          usedBytes: {
            get: (function() {
              return this.contents.length
            })
          }
        })
        var stream_ops = {}
        var keys = Object.keys(node.stream_ops)
        keys.forEach((function(key) {
          var fn = node.stream_ops[key]
          stream_ops[key] = function forceLoadLazyFile() {
            if (!FS.forceLoadFile(node)) {
              throw new FS.ErrnoError(ERRNO_CODES.EIO)
            }
            return fn.apply(null, arguments)
          }
        }))
        stream_ops.read = function stream_ops_read(stream, buffer, offset, length, position) {
          if (!FS.forceLoadFile(node)) {
            throw new FS.ErrnoError(ERRNO_CODES.EIO)
          }
          var contents = stream.node.contents
          if (position >= contents.length) {
            return 0
          }
          var size = Math.min(contents.length - position, length)
          assert(size >= 0)
          if (contents.slice) {
            for (var i = 0; i < size; i++) {
              buffer[offset + i] = contents[position + i]
            }
          } else {
            for (var i = 0; i < size; i++) {
              buffer[offset + i] = contents.get(position + i)
            }
          }
          return size
        }
        node.stream_ops = stream_ops
        return node
      }),
      createPreloadedFile: (function(parent, name, url, canRead, canWrite, onload, onerror, dontCreateFile, canOwn,
          preFinish) {
        Browser.init()
        var fullname = name ? PATH.resolve(PATH.join2(parent, name)) : parent
        var dep = getUniqueRunDependency("cp " + fullname)

        function processData(byteArray) {
          function finish(byteArray) {
            if (preFinish) {
              preFinish()
            }
            if (!dontCreateFile) {
              FS.createDataFile(parent, name, byteArray, canRead, canWrite, canOwn)
            }
            if (onload) {
              onload()
            }
            removeRunDependency(dep)
          }

          var handled = false
          Module["preloadPlugins"].forEach((function(plugin) {
            if (handled) {
              return
            }
            if (plugin["canHandle"](fullname)) {
              plugin["handle"](byteArray, fullname, finish, (function() {
                if (onerror) {
                  onerror()
                }
                removeRunDependency(dep)
              }))
              handled = true
            }
          }))
          if (!handled) {
            finish(byteArray)
          }
        }

        addRunDependency(dep)
        if (typeof url == "string") {
          Browser.asyncLoad(url, (function(byteArray) {
            processData(byteArray)
          }), onerror)
        } else {
          processData(url)
        }
      }),
      indexedDB: (function() {
        return window.indexedDB || window.mozIndexedDB || window.webkitIndexedDB || window.msIndexedDB
      }),
      DB_NAME: (function() {
        return "EM_FS_" + window.location.pathname
      }),
      DB_VERSION: 20,
      DB_STORE_NAME: "FILE_DATA",
      saveFilesToDB: (function(paths, onload, onerror) {
        onload = onload || (function() {
        })
        onerror = onerror || (function() {
        })
        var indexedDB = FS.indexedDB()
        try {
          var openRequest = indexedDB.open(FS.DB_NAME(), FS.DB_VERSION)
        } catch (e) {
          return onerror(e)
        }
        openRequest.onupgradeneeded = function openRequest_onupgradeneeded() {
          console.log("creating db")
          var db = openRequest.result
          db.createObjectStore(FS.DB_STORE_NAME)
        }
        openRequest.onsuccess = function openRequest_onsuccess() {
          var db = openRequest.result
          var transaction = db.transaction([FS.DB_STORE_NAME], "readwrite")
          var files = transaction.objectStore(FS.DB_STORE_NAME)
          var ok = 0, fail = 0, total = paths.length

          function finish() {
            if (fail == 0) {
              onload()
            } else {
              onerror()
            }
          }

          paths.forEach((function(path) {
            var putRequest = files.put(FS.analyzePath(path).object.contents, path)
            putRequest.onsuccess = function putRequest_onsuccess() {
              ok++
              if (ok + fail == total) {
                finish()
              }
            }
            putRequest.onerror = function putRequest_onerror() {
              fail++
              if (ok + fail == total) {
                finish()
              }
            }
          }))
          transaction.onerror = onerror
        }
        openRequest.onerror = onerror
      }),
      loadFilesFromDB: (function(paths, onload, onerror) {
        onload = onload || (function() {
        })
        onerror = onerror || (function() {
        })
        var indexedDB = FS.indexedDB()
        try {
          var openRequest = indexedDB.open(FS.DB_NAME(), FS.DB_VERSION)
        } catch (e) {
          return onerror(e)
        }
        openRequest.onupgradeneeded = onerror
        openRequest.onsuccess = function openRequest_onsuccess() {
          var db = openRequest.result
          try {
            var transaction = db.transaction([FS.DB_STORE_NAME], "readonly")
          } catch (e) {
            onerror(e)
            return
          }
          var files = transaction.objectStore(FS.DB_STORE_NAME)
          var ok = 0, fail = 0, total = paths.length

          function finish() {
            if (fail == 0) {
              onload()
            } else {
              onerror()
            }
          }

          paths.forEach((function(path) {
            var getRequest = files.get(path)
            getRequest.onsuccess = function getRequest_onsuccess() {
              if (FS.analyzePath(path).exists) {
                FS.unlink(path)
              }
              FS.createDataFile(PATH.dirname(path), PATH.basename(path), getRequest.result, true, true, true)
              ok++
              if (ok + fail == total) {
                finish()
              }
            }
            getRequest.onerror = function getRequest_onerror() {
              fail++
              if (ok + fail == total) {
                finish()
              }
            }
          }))
          transaction.onerror = onerror
        }
        openRequest.onerror = onerror
      })
    }
    var SYSCALLS = {
      DEFAULT_POLLMASK: 5, mappings: {}, umask: 511, calculateAt: (function(dirfd, path) {
        if (path[0] !== "/") {
          var dir
          if (dirfd === -100) {
            dir = FS.cwd()
          } else {
            var dirstream = FS.getStream(dirfd)
            if (!dirstream) {
              throw new FS.ErrnoError(ERRNO_CODES.EBADF)
            }
            dir = dirstream.path
          }
          path = PATH.join2(dir, path)
        }
        return path
      }), doStat: (function(func, path, buf) {
        try {
          var stat = func(path)
        } catch (e) {
          if (e && e.node && PATH.normalize(path) !== PATH.normalize(FS.getPath(e.node))) {
            return -ERRNO_CODES.ENOTDIR
          }
          throw e
        }
        HEAP32[buf >> 2] = stat.dev
        HEAP32[buf + 4 >> 2] = 0
        HEAP32[buf + 8 >> 2] = stat.ino
        HEAP32[buf + 12 >> 2] = stat.mode
        HEAP32[buf + 16 >> 2] = stat.nlink
        HEAP32[buf + 20 >> 2] = stat.uid
        HEAP32[buf + 24 >> 2] = stat.gid
        HEAP32[buf + 28 >> 2] = stat.rdev
        HEAP32[buf + 32 >> 2] = 0
        HEAP32[buf + 36 >> 2] = stat.size
        HEAP32[buf + 40 >> 2] = 4096
        HEAP32[buf + 44 >> 2] = stat.blocks
        HEAP32[buf + 48 >> 2] = stat.atime.getTime() / 1e3 | 0
        HEAP32[buf + 52 >> 2] = 0
        HEAP32[buf + 56 >> 2] = stat.mtime.getTime() / 1e3 | 0
        HEAP32[buf + 60 >> 2] = 0
        HEAP32[buf + 64 >> 2] = stat.ctime.getTime() / 1e3 | 0
        HEAP32[buf + 68 >> 2] = 0
        HEAP32[buf + 72 >> 2] = stat.ino
        return 0
      }), doMsync: (function(addr, stream, len, flags) {
        var buffer = new Uint8Array(HEAPU8.subarray(addr, addr + len))
        FS.msync(stream, buffer, 0, len, flags)
      }), doMkdir: (function(path, mode) {
        path = PATH.normalize(path)
        if (path[path.length - 1] === "/") {
          path = path.substr(0, path.length - 1)
        }
        FS.mkdir(path, mode, 0)
        return 0
      }), doMknod: (function(path, mode, dev) {
        switch (mode & 61440) {
          case 32768:
          case 8192:
          case 24576:
          case 4096:
          case 49152:
            break
          default:
            return -ERRNO_CODES.EINVAL
        }
        FS.mknod(path, mode, dev)
        return 0
      }), doReadlink: (function(path, buf, bufsize) {
        if (bufsize <= 0) {
          return -ERRNO_CODES.EINVAL
        }
        var ret = FS.readlink(path)
        var len = Math.min(bufsize, lengthBytesUTF8(ret))
        var endChar = HEAP8[buf + len]
        stringToUTF8(ret, buf, bufsize + 1)
        HEAP8[buf + len] = endChar
        return len
      }), doAccess: (function(path, amode) {
        if (amode & ~7) {
          return -ERRNO_CODES.EINVAL
        }
        var node
        var lookup = FS.lookupPath(path, { follow: true })
        node = lookup.node
        var perms = ""
        if (amode & 4) {
          perms += "r"
        }
        if (amode & 2) {
          perms += "w"
        }
        if (amode & 1) {
          perms += "x"
        }
        if (perms && FS.nodePermissions(node, perms)) {
          return -ERRNO_CODES.EACCES
        }
        return 0
      }), doDup: (function(path, flags, suggestFD) {
        var suggest = FS.getStream(suggestFD)
        if (suggest) {
          FS.close(suggest)
        }
        return FS.open(path, flags, 0, suggestFD, suggestFD).fd
      }), doReadv: (function(stream, iov, iovcnt, offset) {
        var ret = 0
        for (var i = 0; i < iovcnt; i++) {
          var ptr = HEAP32[iov + i * 8 >> 2]
          var len = HEAP32[iov + (i * 8 + 4) >> 2]
          var curr = FS.read(stream, HEAP8, ptr, len, offset)
          if (curr < 0) {
            return -1
          }
          ret += curr
          if (curr < len) {
            break
          }
        }
        return ret
      }), doWritev: (function(stream, iov, iovcnt, offset) {
        var ret = 0
        for (var i = 0; i < iovcnt; i++) {
          var ptr = HEAP32[iov + i * 8 >> 2]
          var len = HEAP32[iov + (i * 8 + 4) >> 2]
          var curr = FS.write(stream, HEAP8, ptr, len, offset)
          if (curr < 0) {
            return -1
          }
          ret += curr
        }
        return ret
      }), varargs: 0, get: (function(varargs) {
        SYSCALLS.varargs += 4
        var ret = HEAP32[SYSCALLS.varargs - 4 >> 2]
        return ret
      }), getStr: (function() {
        var ret = Pointer_stringify(SYSCALLS.get())
        return ret
      }), getStreamFromFD: (function() {
        var stream = FS.getStream(SYSCALLS.get())
        if (!stream) {
          throw new FS.ErrnoError(ERRNO_CODES.EBADF)
        }
        return stream
      }), getSocketFromFD: (function() {
        var socket = SOCKFS.getSocket(SYSCALLS.get())
        if (!socket) {
          throw new FS.ErrnoError(ERRNO_CODES.EBADF)
        }
        return socket
      }), getSocketAddress: (function(allowNull) {
        var addrp = SYSCALLS.get(), addrlen = SYSCALLS.get()
        if (allowNull && addrp === 0) {
          return null
        }
        var info = __read_sockaddr(addrp, addrlen)
        if (info.errno) {
          throw new FS.ErrnoError(info.errno)
        }
        info.addr = DNS.lookup_addr(info.addr) || info.addr
        return info
      }), get64: (function() {
        var low = SYSCALLS.get(), high = SYSCALLS.get()
        if (low >= 0) {
          assert(high === 0)
        } else {
          assert(high === -1)
        }
        return low
      }), getZero: (function() {
        assert(SYSCALLS.get() === 0)
      })
    }

    function ___syscall10(which, varargs) {
      SYSCALLS.varargs = varargs
      try {
        var path = SYSCALLS.getStr()
        FS.unlink(path)
        return 0
      } catch (e) {
        if (typeof FS === "undefined" || !(e instanceof FS.ErrnoError)) {
          abort(e)
        }
        return -e.errno
      }
    }

    function ___syscall140(which, varargs) {
      SYSCALLS.varargs = varargs
      try {
        var stream = SYSCALLS.getStreamFromFD(), offset_high = SYSCALLS.get(), offset_low = SYSCALLS.get(),
            result = SYSCALLS.get(), whence = SYSCALLS.get()
        var offset = offset_low
        FS.llseek(stream, offset, whence)
        HEAP32[result >> 2] = stream.position
        if (stream.getdents && offset === 0 && whence === 0) {
          stream.getdents = null
        }
        return 0
      } catch (e) {
        if (typeof FS === "undefined" || !(e instanceof FS.ErrnoError)) {
          abort(e)
        }
        return -e.errno
      }
    }

    function ___syscall145(which, varargs) {
      SYSCALLS.varargs = varargs
      try {
        var stream = SYSCALLS.getStreamFromFD(), iov = SYSCALLS.get(), iovcnt = SYSCALLS.get()
        return SYSCALLS.doReadv(stream, iov, iovcnt)
      } catch (e) {
        if (typeof FS === "undefined" || !(e instanceof FS.ErrnoError)) {
          abort(e)
        }
        return -e.errno
      }
    }

    function ___syscall146(which, varargs) {
      SYSCALLS.varargs = varargs
      try {
        var stream = SYSCALLS.getStreamFromFD(), iov = SYSCALLS.get(), iovcnt = SYSCALLS.get()
        return SYSCALLS.doWritev(stream, iov, iovcnt)
      } catch (e) {
        if (typeof FS === "undefined" || !(e instanceof FS.ErrnoError)) {
          abort(e)
        }
        return -e.errno
      }
    }

    function ___syscall192(which, varargs) {
      SYSCALLS.varargs = varargs
      try {
        var addr = SYSCALLS.get(), len = SYSCALLS.get(), prot = SYSCALLS.get(), flags = SYSCALLS.get(),
            fd = SYSCALLS.get(), off = SYSCALLS.get()
        off <<= 12
        var ptr
        var allocated = false
        if (fd === -1) {
          ptr = _memalign(PAGE_SIZE, len)
          if (!ptr) {
            return -ERRNO_CODES.ENOMEM
          }
          _memset(ptr, 0, len)
          allocated = true
        } else {
          var info = FS.getStream(fd)
          if (!info) {
            return -ERRNO_CODES.EBADF
          }
          var res = FS.mmap(info, HEAPU8, addr, len, off, prot, flags)
          ptr = res.ptr
          allocated = res.allocated
        }
        SYSCALLS.mappings[ptr] = { malloc: ptr, len: len, allocated: allocated, fd: fd, flags: flags }
        return ptr
      } catch (e) {
        if (typeof FS === "undefined" || !(e instanceof FS.ErrnoError)) {
          abort(e)
        }
        return -e.errno
      }
    }

    function ___syscall195(which, varargs) {
      SYSCALLS.varargs = varargs
      try {
        var path = SYSCALLS.getStr(), buf = SYSCALLS.get()
        return SYSCALLS.doStat(FS.stat, path, buf)
      } catch (e) {
        if (typeof FS === "undefined" || !(e instanceof FS.ErrnoError)) {
          abort(e)
        }
        return -e.errno
      }
    }

    function ___syscall197(which, varargs) {
      SYSCALLS.varargs = varargs
      try {
        var stream = SYSCALLS.getStreamFromFD(), buf = SYSCALLS.get()
        return SYSCALLS.doStat(FS.stat, stream.path, buf)
      } catch (e) {
        if (typeof FS === "undefined" || !(e instanceof FS.ErrnoError)) {
          abort(e)
        }
        return -e.errno
      }
    }

    var PROCINFO = { ppid: 1, pid: 42, sid: 42, pgid: 42 }

    function ___syscall20(which, varargs) {
      SYSCALLS.varargs = varargs
      try {
        return PROCINFO.pid
      } catch (e) {
        if (typeof FS === "undefined" || !(e instanceof FS.ErrnoError)) {
          abort(e)
        }
        return -e.errno
      }
    }

    function ___syscall221(which, varargs) {
      SYSCALLS.varargs = varargs
      try {
        var stream = SYSCALLS.getStreamFromFD(), cmd = SYSCALLS.get()
        switch (cmd) {
          case 0: {
            var arg = SYSCALLS.get()
            if (arg < 0) {
              return -ERRNO_CODES.EINVAL
            }
            var newStream
            newStream = FS.open(stream.path, stream.flags, 0, arg)
            return newStream.fd
          }

          case 1:
          case 2:
            return 0
          case 3:
            return stream.flags
          case 4: {
            var arg = SYSCALLS.get()
            stream.flags |= arg
            return 0
          }

          case 12:
          case 12: {
            var arg = SYSCALLS.get()
            var offset = 0
            HEAP16[arg + offset >> 1] = 2
            return 0
          }

          case 13:
          case 14:
          case 13:
          case 14:
            return 0
          case 16:
          case 8:
            return -ERRNO_CODES.EINVAL
          case 9:
            ___setErrNo(ERRNO_CODES.EINVAL)
            return -1
          default: {
            return -ERRNO_CODES.EINVAL
          }
        }
      } catch (e) {
        if (typeof FS === "undefined" || !(e instanceof FS.ErrnoError)) {
          abort(e)
        }
        return -e.errno
      }
    }

    function ___syscall3(which, varargs) {
      SYSCALLS.varargs = varargs
      try {
        var stream = SYSCALLS.getStreamFromFD(), buf = SYSCALLS.get(), count = SYSCALLS.get()
        return FS.read(stream, HEAP8, buf, count)
      } catch (e) {
        if (typeof FS === "undefined" || !(e instanceof FS.ErrnoError)) {
          abort(e)
        }
        return -e.errno
      }
    }

    function ___syscall33(which, varargs) {
      SYSCALLS.varargs = varargs
      try {
        var path = SYSCALLS.getStr(), amode = SYSCALLS.get()
        return SYSCALLS.doAccess(path, amode)
      } catch (e) {
        if (typeof FS === "undefined" || !(e instanceof FS.ErrnoError)) {
          abort(e)
        }
        return -e.errno
      }
    }

    function ___syscall5(which, varargs) {
      SYSCALLS.varargs = varargs
      try {
        var pathname = SYSCALLS.getStr(), flags = SYSCALLS.get(), mode = SYSCALLS.get()
        var stream = FS.open(pathname, flags, mode)
        return stream.fd
      } catch (e) {
        if (typeof FS === "undefined" || !(e instanceof FS.ErrnoError)) {
          abort(e)
        }
        return -e.errno
      }
    }

    function ___syscall54(which, varargs) {
      SYSCALLS.varargs = varargs
      try {
        var stream = SYSCALLS.getStreamFromFD(), op = SYSCALLS.get()
        switch (op) {
          case 21509:
          case 21505: {
            if (!stream.tty) {
              return -ERRNO_CODES.ENOTTY
            }
            return 0
          }

          case 21510:
          case 21511:
          case 21512:
          case 21506:
          case 21507:
          case 21508: {
            if (!stream.tty) {
              return -ERRNO_CODES.ENOTTY
            }
            return 0
          }

          case 21519: {
            if (!stream.tty) {
              return -ERRNO_CODES.ENOTTY
            }
            var argp = SYSCALLS.get()
            HEAP32[argp >> 2] = 0
            return 0
          }

          case 21520: {
            if (!stream.tty) {
              return -ERRNO_CODES.ENOTTY
            }
            return -ERRNO_CODES.EINVAL
          }

          case 21531: {
            var argp = SYSCALLS.get()
            return FS.ioctl(stream, op, argp)
          }

          case 21523: {
            if (!stream.tty) {
              return -ERRNO_CODES.ENOTTY
            }
            return 0
          }

          default:
            abort("bad ioctl syscall " + op)
        }
      } catch (e) {
        if (typeof FS === "undefined" || !(e instanceof FS.ErrnoError)) {
          abort(e)
        }
        return -e.errno
      }
    }

    function ___syscall6(which, varargs) {
      SYSCALLS.varargs = varargs
      try {
        var stream = SYSCALLS.getStreamFromFD()
        FS.close(stream)
        return 0
      } catch (e) {
        if (typeof FS === "undefined" || !(e instanceof FS.ErrnoError)) {
          abort(e)
        }
        return -e.errno
      }
    }

    function ___syscall91(which, varargs) {
      SYSCALLS.varargs = varargs
      try {
        var addr = SYSCALLS.get(), len = SYSCALLS.get()
        var info = SYSCALLS.mappings[addr]
        if (!info) {
          return 0
        }
        if (len === info.len) {
          var stream = FS.getStream(info.fd)
          SYSCALLS.doMsync(addr, stream, len, info.flags)
          FS.munmap(stream)
          SYSCALLS.mappings[addr] = null
          if (info.allocated) {
            _free(info.malloc)
          }
        }
        return 0
      } catch (e) {
        if (typeof FS === "undefined" || !(e instanceof FS.ErrnoError)) {
          abort(e)
        }
        return -e.errno
      }
    }

    var cttz_i8 = allocate(
        [8, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 5, 0, 1, 0, 2,
          0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 6, 0, 1, 0, 2, 0, 1, 0, 3, 0,
          1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 5, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1,
          0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 7, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0,
          2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 5, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3,
          0, 1, 0, 2, 0, 1, 0, 6, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0,
          1, 0, 5, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0], "i8",
        ALLOC_STATIC)

    function ___unlock() {
    }

    function __exit(status) {
      Module["exit"](status)
    }

    function _exit(status) {
      __exit(status)
    }

    var _environ = STATICTOP
    STATICTOP += 16

    function ___buildEnvironment(env) {
      var MAX_ENV_VALUES = 64
      var TOTAL_ENV_SIZE = 1024
      var poolPtr
      var envPtr
      if (!___buildEnvironment.called) {
        ___buildEnvironment.called = true
        ENV["USER"] = ENV["LOGNAME"] = "web_user"
        ENV["PATH"] = "/"
        ENV["PWD"] = "/"
        ENV["HOME"] = "/home/web_user"
        ENV["LANG"] = "C.UTF-8"
        ENV["_"] = Module["thisProgram"]
        poolPtr = staticAlloc(TOTAL_ENV_SIZE)
        envPtr = staticAlloc(MAX_ENV_VALUES * 4)
        HEAP32[envPtr >> 2] = poolPtr
        HEAP32[_environ >> 2] = envPtr
      } else {
        envPtr = HEAP32[_environ >> 2]
        poolPtr = HEAP32[envPtr >> 2]
      }
      var strings = []
      var totalSize = 0
      for (var key in env) {
        if (typeof env[key] === "string") {
          var line = key + "=" + env[key]
          strings.push(line)
          totalSize += line.length
        }
      }
      if (totalSize > TOTAL_ENV_SIZE) {
        throw new Error("Environment size exceeded TOTAL_ENV_SIZE!")
      }
      var ptrSize = 4
      for (var i = 0; i < strings.length; i++) {
        var line = strings[i]
        writeAsciiToMemory(line, poolPtr)
        HEAP32[envPtr + i * ptrSize >> 2] = poolPtr
        poolPtr += line.length + 1
      }
      HEAP32[envPtr + strings.length * ptrSize >> 2] = 0
    }

    var ENV = {}

    function _getenv(name) {
      if (name === 0) {
        return 0
      }
      name = Pointer_stringify(name)
      if (!ENV.hasOwnProperty(name)) {
        return 0
      }
      if (_getenv.ret) {
        _free(_getenv.ret)
      }
      _getenv.ret = allocateUTF8(ENV[name])
      return _getenv.ret
    }

    function _gettimeofday(ptr) {
      var now = Date.now()
      HEAP32[ptr >> 2] = now / 1e3 | 0
      HEAP32[ptr + 4 >> 2] = now % 1e3 * 1e3 | 0
      return 0
    }

    var _llvm_ceil_f64 = Math_ceil
    var _llvm_fabs_f32 = Math_abs
    var _llvm_fabs_f64 = Math_abs
    var _llvm_floor_f64 = Math_floor
    var _llvm_pow_f64 = Math_pow
    var _llvm_sqrt_f32 = Math_sqrt
    var _llvm_sqrt_f64 = Math_sqrt

    function _llvm_trap() {
      abort("trap!")
    }

    function _longjmp(env, value) {
      Module["setThrew"](env, value || 1)
      throw"longjmp"
    }

    function _emscripten_memcpy_big(dest, src, num) {
      HEAPU8.set(HEAPU8.subarray(src, src + num), dest)
      return dest
    }

    function _setenv(envname, envval, overwrite) {
      if (envname === 0) {
        ___setErrNo(ERRNO_CODES.EINVAL)
        return -1
      }
      var name = Pointer_stringify(envname)
      var val = Pointer_stringify(envval)
      if (name === "" || name.indexOf("=") !== -1) {
        ___setErrNo(ERRNO_CODES.EINVAL)
        return -1
      }
      if (ENV.hasOwnProperty(name) && !overwrite) {
        return 0
      }
      ENV[name] = val
      ___buildEnvironment(ENV)
      return 0
    }

    function _time(ptr) {
      var ret = Date.now() / 1e3 | 0
      if (ptr) {
        HEAP32[ptr >> 2] = ret
      }
      return ret
    }

    function _times(buffer) {
      if (buffer !== 0) {
        _memset(buffer, 0, 16)
      }
      return 0
    }

    if (ENVIRONMENT_IS_NODE) {
      _emscripten_get_now = function _emscripten_get_now_actual() {
        var t = process["hrtime"]()
        return t[0] * 1e3 + t[1] / 1e6
      }
    } else if (typeof dateNow !== "undefined") {
      _emscripten_get_now = dateNow
    } else if (typeof self === "object" && self["performance"] && typeof self["performance"]["now"] === "function") {
      _emscripten_get_now = (function() {
        return self["performance"]["now"]()
      })
    } else if (typeof performance === "object" && typeof performance["now"] === "function") {
      _emscripten_get_now = (function() {
        return performance["now"]()
      })
    } else {
      _emscripten_get_now = Date.now
    }
    FS.staticInit()
    __ATINIT__.unshift((function() {
      if (!Module["noFSInit"] && !FS.init.initialized) {
        FS.init()
      }
    }))
    __ATMAIN__.push((function() {
      FS.ignorePermissions = false
    }))
    __ATEXIT__.push((function() {
      FS.quit()
    }))
    __ATINIT__.unshift((function() {
      TTY.init()
    }))
    __ATEXIT__.push((function() {
      TTY.shutdown()
    }))
    if (ENVIRONMENT_IS_NODE) {
      var fs = require("fs")
      var NODEJS_PATH = require("path")
      NODEFS.staticInit()
    }
    ___buildEnvironment(ENV)
    DYNAMICTOP_PTR = staticAlloc(4)
    STACK_BASE = STACKTOP = alignMemory(STATICTOP)
    STACK_MAX = STACK_BASE + TOTAL_STACK
    DYNAMIC_BASE = alignMemory(STACK_MAX)
    HEAP32[DYNAMICTOP_PTR >> 2] = DYNAMIC_BASE
    staticSealed = true
    var ASSERTIONS = false

    function intArrayFromString(stringy, dontAddNull, length) {
      var len = length > 0 ? length : lengthBytesUTF8(stringy) + 1
      var u8array = new Array(len)
      var numBytesWritten = stringToUTF8Array(stringy, u8array, 0, u8array.length)
      if (dontAddNull) {
        u8array.length = numBytesWritten
      }
      return u8array
    }

    function intArrayToString(array) {
      var ret = []
      for (var i = 0; i < array.length; i++) {
        var chr = array[i]
        if (chr > 255) {
          if (ASSERTIONS) {
            assert(false,
                "Character code " + chr + " (" + String.fromCharCode(chr) + ")  at offset " + i + " not in 0x00-0xFF.")
          }
          chr &= 255
        }
        ret.push(String.fromCharCode(chr))
      }
      return ret.join("")
    }

    var decodeBase64 = typeof atob === "function" ? atob : (function(input) {
      var keyStr = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/="
      var output = ""
      var chr1, chr2, chr3
      var enc1, enc2, enc3, enc4
      var i = 0
      input = input.replace(/[^A-Za-z0-9\+\/\=]/g, "")
      do {
        enc1 = keyStr.indexOf(input.charAt(i++))
        enc2 = keyStr.indexOf(input.charAt(i++))
        enc3 = keyStr.indexOf(input.charAt(i++))
        enc4 = keyStr.indexOf(input.charAt(i++))
        chr1 = enc1 << 2 | enc2 >> 4
        chr2 = (enc2 & 15) << 4 | enc3 >> 2
        chr3 = (enc3 & 3) << 6 | enc4
        output = output + String.fromCharCode(chr1)
        if (enc3 !== 64) {
          output = output + String.fromCharCode(chr2)
        }
        if (enc4 !== 64) {
          output = output + String.fromCharCode(chr3)
        }
      } while (i < input.length)
      return output
    })

    function intArrayFromBase64(s) {
      if (typeof ENVIRONMENT_IS_NODE === "boolean" && ENVIRONMENT_IS_NODE) {
        var buf
        try {
          buf = Buffer.from(s, "base64")
        } catch (_) {
          buf = new Buffer(s, "base64")
        }
        return new Uint8Array(buf.buffer, buf.byteOffset, buf.byteLength)
      }
      try {
        var decoded = decodeBase64(s)
        var bytes = new Uint8Array(decoded.length)
        for (var i = 0; i < decoded.length; ++i) {
          bytes[i] = decoded.charCodeAt(i)
        }
        return bytes
      } catch (_) {
        throw new Error("Converting base64 string to bytes failed.")
      }
    }

    function tryParseAsDataURI(filename) {
      if (!isDataURI(filename)) {
        return
      }
      return intArrayFromBase64(filename.slice(dataURIPrefix.length))
    }

    function invoke_d(index) {
      try {
        return Module["dynCall_d"](index)
      } catch (e) {
        if (typeof e !== "number" && e !== "longjmp") {
          throw e
        }
        Module["setThrew"](1, 0)
      }
    }

    function invoke_dddd(index, a1, a2, a3) {
      try {
        return Module["dynCall_dddd"](index, a1, a2, a3)
      } catch (e) {
        if (typeof e !== "number" && e !== "longjmp") {
          throw e
        }
        Module["setThrew"](1, 0)
      }
    }

    function invoke_di(index, a1) {
      try {
        return Module["dynCall_di"](index, a1)
      } catch (e) {
        if (typeof e !== "number" && e !== "longjmp") {
          throw e
        }
        Module["setThrew"](1, 0)
      }
    }

    function invoke_i(index) {
      try {
        return Module["dynCall_i"](index)
      } catch (e) {
        if (typeof e !== "number" && e !== "longjmp") {
          throw e
        }
        Module["setThrew"](1, 0)
      }
    }

    function invoke_ii(index, a1) {
      try {
        return Module["dynCall_ii"](index, a1)
      } catch (e) {
        if (typeof e !== "number" && e !== "longjmp") {
          throw e
        }
        Module["setThrew"](1, 0)
      }
    }

    function invoke_iii(index, a1, a2) {
      try {
        return Module["dynCall_iii"](index, a1, a2)
      } catch (e) {
        if (typeof e !== "number" && e !== "longjmp") {
          throw e
        }
        Module["setThrew"](1, 0)
      }
    }

    function invoke_iiidd(index, a1, a2, a3, a4) {
      try {
        return Module["dynCall_iiidd"](index, a1, a2, a3, a4)
      } catch (e) {
        if (typeof e !== "number" && e !== "longjmp") {
          throw e
        }
        Module["setThrew"](1, 0)
      }
    }

    function invoke_iiii(index, a1, a2, a3) {
      try {
        return Module["dynCall_iiii"](index, a1, a2, a3)
      } catch (e) {
        if (typeof e !== "number" && e !== "longjmp") {
          throw e
        }
        Module["setThrew"](1, 0)
      }
    }

    function invoke_iiiii(index, a1, a2, a3, a4) {
      try {
        return Module["dynCall_iiiii"](index, a1, a2, a3, a4)
      } catch (e) {
        if (typeof e !== "number" && e !== "longjmp") {
          throw e
        }
        Module["setThrew"](1, 0)
      }
    }

    function invoke_iiiiii(index, a1, a2, a3, a4, a5) {
      try {
        return Module["dynCall_iiiiii"](index, a1, a2, a3, a4, a5)
      } catch (e) {
        if (typeof e !== "number" && e !== "longjmp") {
          throw e
        }
        Module["setThrew"](1, 0)
      }
    }

    function invoke_iiiiiii(index, a1, a2, a3, a4, a5, a6) {
      try {
        return Module["dynCall_iiiiiii"](index, a1, a2, a3, a4, a5, a6)
      } catch (e) {
        if (typeof e !== "number" && e !== "longjmp") {
          throw e
        }
        Module["setThrew"](1, 0)
      }
    }

    function invoke_iiiiiiiiiii(index, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10) {
      try {
        return Module["dynCall_iiiiiiiiiii"](index, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10)
      } catch (e) {
        if (typeof e !== "number" && e !== "longjmp") {
          throw e
        }
        Module["setThrew"](1, 0)
      }
    }

    function invoke_v(index) {
      try {
        Module["dynCall_v"](index)
      } catch (e) {
        if (typeof e !== "number" && e !== "longjmp") {
          throw e
        }
        Module["setThrew"](1, 0)
      }
    }

    function invoke_vi(index, a1) {
      try {
        Module["dynCall_vi"](index, a1)
      } catch (e) {
        if (typeof e !== "number" && e !== "longjmp") {
          throw e
        }
        Module["setThrew"](1, 0)
      }
    }

    function invoke_vii(index, a1, a2) {
      try {
        Module["dynCall_vii"](index, a1, a2)
      } catch (e) {
        if (typeof e !== "number" && e !== "longjmp") {
          throw e
        }
        Module["setThrew"](1, 0)
      }
    }

    function invoke_viii(index, a1, a2, a3) {
      try {
        Module["dynCall_viii"](index, a1, a2, a3)
      } catch (e) {
        if (typeof e !== "number" && e !== "longjmp") {
          throw e
        }
        Module["setThrew"](1, 0)
      }
    }

    function invoke_viiiddi(index, a1, a2, a3, a4, a5, a6) {
      try {
        Module["dynCall_viiiddi"](index, a1, a2, a3, a4, a5, a6)
      } catch (e) {
        if (typeof e !== "number" && e !== "longjmp") {
          throw e
        }
        Module["setThrew"](1, 0)
      }
    }

    function invoke_viiii(index, a1, a2, a3, a4) {
      try {
        Module["dynCall_viiii"](index, a1, a2, a3, a4)
      } catch (e) {
        if (typeof e !== "number" && e !== "longjmp") {
          throw e
        }
        Module["setThrew"](1, 0)
      }
    }

    function invoke_viiiii(index, a1, a2, a3, a4, a5) {
      try {
        Module["dynCall_viiiii"](index, a1, a2, a3, a4, a5)
      } catch (e) {
        if (typeof e !== "number" && e !== "longjmp") {
          throw e
        }
        Module["setThrew"](1, 0)
      }
    }

    function invoke_viiiiii(index, a1, a2, a3, a4, a5, a6) {
      try {
        Module["dynCall_viiiiii"](index, a1, a2, a3, a4, a5, a6)
      } catch (e) {
        if (typeof e !== "number" && e !== "longjmp") {
          throw e
        }
        Module["setThrew"](1, 0)
      }
    }

    function invoke_viiiiiiiii(index, a1, a2, a3, a4, a5, a6, a7, a8, a9) {
      try {
        Module["dynCall_viiiiiiiii"](index, a1, a2, a3, a4, a5, a6, a7, a8, a9)
      } catch (e) {
        if (typeof e !== "number" && e !== "longjmp") {
          throw e
        }
        Module["setThrew"](1, 0)
      }
    }

    Module.asmGlobalArg = {
      "Math": Math,
      "Int8Array": Int8Array,
      "Int16Array": Int16Array,
      "Int32Array": Int32Array,
      "Uint8Array": Uint8Array,
      "Uint16Array": Uint16Array,
      "Uint32Array": Uint32Array,
      "Float32Array": Float32Array,
      "Float64Array": Float64Array,
      "NaN": NaN,
      "Infinity": Infinity
    }
    Module.asmLibraryArg = {
      "abort": abort,
      "assert": assert,
      "enlargeMemory": enlargeMemory,
      "getTotalMemory": getTotalMemory,
      "abortOnCannotGrowMemory": abortOnCannotGrowMemory,
      "invoke_d": invoke_d,
      "invoke_dddd": invoke_dddd,
      "invoke_di": invoke_di,
      "invoke_i": invoke_i,
      "invoke_ii": invoke_ii,
      "invoke_iii": invoke_iii,
      "invoke_iiidd": invoke_iiidd,
      "invoke_iiii": invoke_iiii,
      "invoke_iiiii": invoke_iiiii,
      "invoke_iiiiii": invoke_iiiiii,
      "invoke_iiiiiii": invoke_iiiiiii,
      "invoke_iiiiiiiiiii": invoke_iiiiiiiiiii,
      "invoke_v": invoke_v,
      "invoke_vi": invoke_vi,
      "invoke_vii": invoke_vii,
      "invoke_viii": invoke_viii,
      "invoke_viiiddi": invoke_viiiddi,
      "invoke_viiii": invoke_viiii,
      "invoke_viiiii": invoke_viiiii,
      "invoke_viiiiii": invoke_viiiiii,
      "invoke_viiiiiiiii": invoke_viiiiiiiii,
      "___assert_fail": ___assert_fail,
      "___buildEnvironment": ___buildEnvironment,
      "___clock_gettime": ___clock_gettime,
      "___lock": ___lock,
      "___map_file": ___map_file,
      "___setErrNo": ___setErrNo,
      "___syscall10": ___syscall10,
      "___syscall140": ___syscall140,
      "___syscall145": ___syscall145,
      "___syscall146": ___syscall146,
      "___syscall192": ___syscall192,
      "___syscall195": ___syscall195,
      "___syscall197": ___syscall197,
      "___syscall20": ___syscall20,
      "___syscall221": ___syscall221,
      "___syscall3": ___syscall3,
      "___syscall33": ___syscall33,
      "___syscall5": ___syscall5,
      "___syscall54": ___syscall54,
      "___syscall6": ___syscall6,
      "___syscall91": ___syscall91,
      "___unlock": ___unlock,
      "__exit": __exit,
      "_clock_gettime": _clock_gettime,
      "_emscripten_asm_const_iii": _emscripten_asm_const_iii,
      "_emscripten_get_now": _emscripten_get_now,
      "_emscripten_get_now_is_monotonic": _emscripten_get_now_is_monotonic,
      "_emscripten_memcpy_big": _emscripten_memcpy_big,
      "_exit": _exit,
      "_getenv": _getenv,
      "_gettimeofday": _gettimeofday,
      "_llvm_ceil_f64": _llvm_ceil_f64,
      "_llvm_fabs_f32": _llvm_fabs_f32,
      "_llvm_fabs_f64": _llvm_fabs_f64,
      "_llvm_floor_f64": _llvm_floor_f64,
      "_llvm_pow_f64": _llvm_pow_f64,
      "_llvm_sqrt_f32": _llvm_sqrt_f32,
      "_llvm_sqrt_f64": _llvm_sqrt_f64,
      "_llvm_trap": _llvm_trap,
      "_longjmp": _longjmp,
      "_setenv": _setenv,
      "_time": _time,
      "_times": _times,
      "DYNAMICTOP_PTR": DYNAMICTOP_PTR,
      "tempDoublePtr": tempDoublePtr,
      "ABORT": ABORT,
      "STACKTOP": STACKTOP,
      "STACK_MAX": STACK_MAX,
      "cttz_i8": cttz_i8
    }// EMSCRIPTEN_START_ASM
    var asm = (/** @suppress {uselessCode} */ function(global, env, buffer) {
      "use asm"
      var a = new global.Int8Array(buffer)
      var b = new global.Int16Array(buffer)
      var c = new global.Int32Array(buffer)
      var d = new global.Uint8Array(buffer)
      var e = new global.Uint16Array(buffer)
      var f = new global.Uint32Array(buffer)
      var g = new global.Float32Array(buffer)
      var h = new global.Float64Array(buffer)
      var i = env.DYNAMICTOP_PTR | 0
      var j = env.tempDoublePtr | 0
      var k = env.ABORT | 0
      var l = env.STACKTOP | 0
      var m = env.STACK_MAX | 0
      var n = env.cttz_i8 | 0
      var o = 0
      var p = 0
      var q = 0
      var r = 0
      var s = global.NaN, t = global.Infinity
      var u = 0, v = 0, w = 0, x = 0, y = 0.0
      var z = 0
      var A = global.Math.floor
      var B = global.Math.abs
      var C = global.Math.sqrt
      var D = global.Math.pow
      var E = global.Math.cos
      var F = global.Math.sin
      var G = global.Math.tan
      var H = global.Math.acos
      var I = global.Math.asin
      var J = global.Math.atan
      var K = global.Math.atan2
      var L = global.Math.exp
      var M = global.Math.log
      var N = global.Math.ceil
      var O = global.Math.imul
      var P = global.Math.min
      var Q = global.Math.max
      var R = global.Math.clz32
      var S = env.abort
      var T = env.assert
      var U = env.enlargeMemory
      var V = env.getTotalMemory
      var W = env.abortOnCannotGrowMemory
      var X = env.invoke_d
      var Y = env.invoke_dddd
      var Z = env.invoke_di
      var _ = env.invoke_i
      var $ = env.invoke_ii
      var aa = env.invoke_iii
      var ba = env.invoke_iiidd
      var ca = env.invoke_iiii
      var da = env.invoke_iiiii
      var ea = env.invoke_iiiiii
      var fa = env.invoke_iiiiiii
      var ga = env.invoke_iiiiiiiiiii
      var ha = env.invoke_v
      var ia = env.invoke_vi
      var ja = env.invoke_vii
      var ka = env.invoke_viii
      var la = env.invoke_viiiddi
      var ma = env.invoke_viiii
      var na = env.invoke_viiiii
      var oa = env.invoke_viiiiii
      var pa = env.invoke_viiiiiiiii
      var qa = env.___assert_fail
      var ra = env.___buildEnvironment
      var sa = env.___clock_gettime
      var ta = env.___lock
      var ua = env.___map_file
      var va = env.___setErrNo
      var wa = env.___syscall10
      var xa = env.___syscall140
      var ya = env.___syscall145
      var za = env.___syscall146
      var Aa = env.___syscall192
      var Ba = env.___syscall195
      var Ca = env.___syscall197
      var Da = env.___syscall20
      var Ea = env.___syscall221
      var Fa = env.___syscall3
      var Ga = env.___syscall33
      var Ha = env.___syscall5
      var Ia = env.___syscall54
      var Ja = env.___syscall6
      var Ka = env.___syscall91
      var La = env.___unlock
      var Ma = env.__exit
      var Na = env._clock_gettime
      var Oa = env._emscripten_asm_const_iii
      var Pa = env._emscripten_get_now
      var Qa = env._emscripten_get_now_is_monotonic
      var Ra = env._emscripten_memcpy_big
      var Sa = env._exit
      var Ta = env._getenv
      var Ua = env._gettimeofday
      var Va = env._llvm_ceil_f64
      var Wa = env._llvm_fabs_f32
      var Xa = env._llvm_fabs_f64
      var Ya = env._llvm_floor_f64
      var Za = env._llvm_pow_f64
      var _a = env._llvm_sqrt_f32
      var $a = env._llvm_sqrt_f64
      var ab = env._llvm_trap
      var bb = env._longjmp
      var cb = env._setenv
      var db = env._time
      var eb = env._times
      var fb = 0.0

// EMSCRIPTEN_START_FUNCS
      function fP(b, d, e, f, g) {
        b = b | 0
        d = d | 0
        e = e | 0
        f = f | 0
        g = g | 0
        var h = 0, i = 0, j = 0, k = 0, m = 0, n = 0
        n = l
        l = l + 176 | 0
        k = n + 8 | 0
        j = n
        h = n + 40 | 0
        if (!b) {
          qa(108200, 108204, 52, 108218)
        }
        if (!d) {
          qa(108230, 108204, 53, 108218)
        }
        i = c[d + 8 >> 2] | 0
        if (!i) {
          qa(108233, 108204, 54, 108218)
        }
        if (!(a[i >> 0] | 0)) {
          qa(108242, 108204, 55, 108218)
        }
        a0(h, c[d + 28 >> 2] | 0) | 0
        i = h + (V_(h) | 0) | 0
        a[i >> 0] = 58
        a[i + 1 >> 0] = 0
        o1(h, g) | 0
        if ((gP(b, h) | 0) == 999) {
          c[j >> 2] = h
          Ow(0, 108254, j) | 0
        }
        g = c[b + 92 >> 2] | 0
        if (g | 0 ? (m = c[g >> 2] | 0, m | 0) : 0) {
          c[k >> 2] = c[e >> 2]
          c[k + 4 >> 2] = c[e + 4 >> 2]
          c[k + 8 >> 2] = c[e + 8 >> 2]
          c[k + 12 >> 2] = c[e + 12 >> 2]
          c[k + 16 >> 2] = c[e + 16 >> 2]
          c[k + 20 >> 2] = c[e + 20 >> 2]
          c[k + 24 >> 2] = c[e + 24 >> 2]
          c[k + 28 >> 2] = c[e + 28 >> 2]
          xb[m & 31](b, d, k, f)
        }
        l = n
        return
      }

      function gP(a, b) {
        a = a | 0
        b = b | 0
        b = vC(c[a >> 2] | 0, 4, b) | 0
        if (!b) {
          b = 999
        } else {
          b = c[b + 16 >> 2] | 0
          c[a + 92 >> 2] = c[b + 12 >> 2]
          c[a + 96 >> 2] = c[b >> 2]
          b = 300
        }
        return b | 0
      }

      function hP(a) {
        a = a | 0
        return 1
      }

      function iP(b) {
        b = b | 0
        var c = 0
        a[b + 536 >> 0] = 0
        c = b + 336 | 0
        h[c >> 3] = +h[c >> 3] + 10.0 / +h[b + 352 >> 3]
        a[b + 537 >> 0] = 1
        return 0
      }

      function jP(b) {
        b = b | 0
        var c = 0
        a[b + 536 >> 0] = 0
        c = b + 336 | 0
        h[c >> 3] = +h[c >> 3] - 10.0 / +h[b + 352 >> 3]
        a[b + 537 >> 0] = 1
        return 0
      }

      function kP(b) {
        b = b | 0
        var c = 0
        a[b + 536 >> 0] = 0
        c = b + 344 | 0
        h[c >> 3] = +h[c >> 3] - 10.0 / +h[b + 352 >> 3]
        a[b + 537 >> 0] = 1
        return 0
      }

      function lP(b) {
        b = b | 0
        var c = 0
        a[b + 536 >> 0] = 0
        c = b + 344 | 0
        h[c >> 3] = +h[c >> 3] + 10.0 / +h[b + 352 >> 3]
        a[b + 537 >> 0] = 1
        return 0
      }

      function mP(b) {
        b = b | 0
        var c = 0
        a[b + 536 >> 0] = 0
        c = b + 352 | 0
        h[c >> 3] = +h[c >> 3] * 1.1
        a[b + 537 >> 0] = 1
        return 0
      }

      function nP(b) {
        b = b | 0
        var c = 0
        a[b + 536 >> 0] = 0
        c = b + 352 | 0
        h[c >> 3] = +h[c >> 3] * .9090909090909091
        a[b + 537 >> 0] = 1
        return 0
      }

      function oP(b) {
        b = b | 0
        var d = 0, e = 0, f = 0, g = 0.0, i = 0.0
        e = b + 536 | 0
        d = (a[e >> 0] | 0) == 0
        a[e >> 0] = d & 1
        if (d) {
          d = c[b + 448 >> 2] | 0
          e = c[b + 452 >> 2] | 0
          i = +(d >>> 0)
          g = +(e >>> 0)
          f = i / +(d | 0) < g / +(e | 0)
          h[b + 352 >> 3] = (f ? i : g) / +((f ? d : e) | 0)
          e = b + 336 | 0
          c[e >> 2] = 0
          c[e + 4 >> 2] = 0
          c[e + 8 >> 2] = 0
          c[e + 12 >> 2] = 0
          a[b + 537 >> 0] = 1
        }
        return 0
      }

      function pP(b) {
        b = b | 0
        var d = 0, e = 0
        d = c[(c[b >> 2] | 0) + 168 >> 2] | 0
        e = b + 580 | 0
        if (!(c[e >> 2] | 0)) {
          c[e >> 2] = d
          e = (c[d + 16 >> 2] | 0) + 112 | 0
          a[e >> 0] = a[e >> 0] | 2
          FP(b, d)
        }
        cF(b, d)
        a[b + 540 >> 0] = 1
        return
      }

      function qP(b, d, e) {
        b = b | 0
        d = d | 0
        e = e | 0
        var f = 0, g = 0.0, i = 0.0, j = 0, k = 0
        k = l
        l = l + 16 | 0
        f = k
        switch (d | 0) {
          case 1: {
            c[f >> 2] = c[e >> 2]
            c[f + 4 >> 2] = c[e + 4 >> 2]
            c[f + 8 >> 2] = c[e + 8 >> 2]
            c[f + 12 >> 2] = c[e + 12 >> 2]
            yP(b, f)
            EP(b)
            a[b + 538 >> 0] = 1
            a[b + 541 >> 0] = 1
            j = 13
            break
          }
          case 2: {
            a[b + 538 >> 0] = 1
            a[b + 541 >> 0] = 2
            j = 13
            break
          }
          case 3: {
            c[f >> 2] = c[e >> 2]
            c[f + 4 >> 2] = c[e + 4 >> 2]
            c[f + 8 >> 2] = c[e + 8 >> 2]
            c[f + 12 >> 2] = c[e + 12 >> 2]
            yP(b, f)
            a[b + 538 >> 0] = 1
            a[b + 541 >> 0] = 3
            j = 13
            break
          }
          case 4: {
            a[b + 536 >> 0] = 0
            if (!(c[b + 360 >> 2] | 0)) {
              f = b + 352 | 0
              i = +h[f >> 3]
              d = b + 336 | 0
              h[d >> 3] = (+h[e >> 3] - +((c[b + 448 >> 2] | 0) >>> 0) * .5) * .10000000000000009 / (+h[b + 520 >> 3]
                  * i) + +h[d >> 3]
              g = +h[e + 8 >> 3] - +((c[b + 452 >> 2] | 0) >>> 0) * .5
              d = b + 528 | 0
            } else {
              f = b + 352 | 0
              i = +h[f >> 3]
              d = b + 336 | 0
              h[d >> 3] = +h[d >> 3] - (+h[e + 8 >> 3] - +((c[b + 452 >> 2] | 0) >>> 0) * .5) * .10000000000000009
                  / (+h[b + 528 >> 3] * i)
              g = +h[e >> 3] - +((c[b + 448 >> 2] | 0) >>> 0) * .5
              d = b + 520 | 0
            }
            j = b + 344 | 0
            h[j >> 3] = g * .10000000000000009 / (+h[d >> 3] * i) + +h[j >> 3]
            h[f >> 3] = i * 1.1
            j = 13
            break
          }
          case 5: {
            a[b + 536 >> 0] = 0
            j = b + 352 | 0
            i = +h[j >> 3] * .9090909090909091
            h[j >> 3] = i
            if (!(c[b + 360 >> 2] | 0)) {
              f = b + 336 | 0
              h[f >> 3] = +h[f >> 3] - (+h[e >> 3] - +((c[b + 448 >> 2] | 0) >>> 0) * .5) * .10000000000000009 / (+h[b
              + 520 >> 3] * i)
              g = +h[e + 8 >> 3] - +((c[b + 452 >> 2] | 0) >>> 0) * .5
              f = b + 528 | 0
            } else {
              f = b + 336 | 0
              h[f >> 3] = (+h[e + 8 >> 3] - +((c[b + 452 >> 2] | 0) >>> 0) * .5) * .10000000000000009 / (+h[b + 528
              >> 3] * i) + +h[f >> 3]
              g = +h[e >> 3] - +((c[b + 448 >> 2] | 0) >>> 0) * .5
              f = b + 520 | 0
            }
            j = b + 344 | 0
            h[j >> 3] = +h[j >> 3] - g * .10000000000000009 / (+h[f >> 3] * i)
            j = 13
            break
          }
          default: {
          }
        }
        if ((j | 0) == 13) {
          a[b + 537 >> 0] = 1
        }
        b = b + 560 | 0
        c[b >> 2] = c[e >> 2]
        c[b + 4 >> 2] = c[e + 4 >> 2]
        c[b + 8 >> 2] = c[e + 8 >> 2]
        c[b + 12 >> 2] = c[e + 12 >> 2]
        l = k
        return
      }

      function rP(b, c, d) {
        b = b | 0
        c = c | 0
        d = d | 0
        a[b + 538 >> 0] = 0
        a[b + 541 >> 0] = 0
        return
      }

      function sP(b, d) {
        b = b | 0
        d = d | 0
        var e = 0, f = 0.0, g = 0.0, i = 0, j = 0.0, k = 0
        k = l
        l = l + 16 | 0
        e = k
        i = b + 560 | 0
        j = (+h[d >> 3] - +h[i >> 3]) / +h[b + 520 >> 3]
        g = (+h[d + 8 >> 3] - +h[b + 568 >> 3]) / +h[b + 528 >> 3]
        if (!(+B(+j) < .0001 & +B(+g) < .0001)) {
          switch (a[b + 541 >> 0] | 0) {
            case 0: {
              c[e >> 2] = c[d >> 2]
              c[e + 4 >> 2] = c[d + 4 >> 2]
              c[e + 8 >> 2] = c[d + 8 >> 2]
              c[e + 12 >> 2] = c[d + 12 >> 2]
              yP(b, e)
              break
            }
            case 2: {
              f = +h[b + 352 >> 3]
              if (!(c[b + 360 >> 2] | 0)) {
                e = b + 336 | 0
                h[e >> 3] = +h[e >> 3] - j / f
                e = b + 344 | 0
                h[e >> 3] = +h[e >> 3] - g / f
              } else {
                e = b + 336 | 0
                h[e >> 3] = +h[e >> 3] - g / f
                e = b + 344 | 0
                h[e >> 3] = +h[e >> 3] + j / f
              }
              a[b + 537 >> 0] = 1
              break
            }
            default: {
            }
          }
          c[i >> 2] = c[d >> 2]
          c[i + 4 >> 2] = c[d + 4 >> 2]
          c[i + 8 >> 2] = c[d + 8 >> 2]
          c[i + 12 >> 2] = c[d + 12 >> 2]
        }
        l = k
        return
      }

      function tP(a, b, c) {
        a = a | 0
        b = b | 0
        c = c | 0
        return
      }

      function uP(a) {
        a = a | 0
        return
      }

      function vP(b, d, e) {
        b = b | 0
        d = d | 0
        e = e | 0
        var f = 0, g = 0, h = 0, i = 0, j = 0
        j = c[b >> 2] | 0
        if (d) {
          d = K1(d, 135739) | 0
          if (d | 0) {
            i = SB(d, 0) | 0
            r1(d) | 0
            f = 5
          }
        } else {
          i = SB(c[15621] | 0, 0) | 0
          f = 5
        }
        if ((f | 0) == 5 ? i | 0 : 0) {
          g = j + 168 | 0
          d = c[g >> 2] | 0
          if (d | 0) {
            f = c[j + 172 >> 2] | 0
            if ((f | 0) != 0 ? (h = c[f + 4 >> 2] | 0, (h | 0) != 0) : 0) {
              tb[h & 127](d)
              d = c[g >> 2] | 0
            }
            fH(d)
            _x(c[g >> 2] | 0) | 0
          }
          Ez(i, 0, 134401, 280, 1)
          Ez(i, 1, 134365, 304, 1)
          Ez(i, 2, 134378, 176, 1)
          c[g >> 2] = i
          c[(c[i + 16 >> 2] | 0) + 144 >> 2] = j
          if ((ZC(j, i, e) | 0) != -1) {
            c[b + 580 >> 2] = 0
            c[b + 576 >> 2] = 0
            a[b + 537 >> 0] = 1
          }
        }
        return
      }

      function wP(a, b) {
        a = a | 0
        b = b | 0
        a = c[a >> 2] | 0
        ZC(a, c[a + 168 >> 2] | 0, b) | 0
        return
      }

      function xP(a, b, d) {
        a = a | 0
        b = b | 0
        d = d | 0
        var e = 0, f = 0, g = 0, h = 0, i = 0
        g = c[a >> 2] | 0
        f = g + 160 | 0
        e = c[f >> 2] | 0
        if ((e | 0) != 0 ? (c[g + 164 >> 2] | 0) == 0 : 0) {
          i = g + 192 | 0
          h = c[i >> 2] | 0
          c[f >> 2] = 0
          c[i >> 2] = 0
          f = h
        } else {
          f = 0
          e = 0
        }
        $C(g, c[g + 168 >> 2] | 0, b, d) | 0
        if (e | 0) {
          i = c[a >> 2] | 0
          c[i + 160 >> 2] = e
          c[i + 192 >> 2] = f
        }
        return
      }

      function yP(b, d) {
        b = b | 0
        d = d | 0
        var e = 0, f = 0, g = 0, i = 0.0, j = 0.0, k = 0.0, m = 0
        f = l
        l = l + 80 | 0
        e = f + 48 | 0
        g = f
        m = f + 32 | 0
        c[e >> 2] = c[d >> 2]
        c[e + 4 >> 2] = c[d + 4 >> 2]
        c[e + 8 >> 2] = c[d + 8 >> 2]
        c[e + 12 >> 2] = c[d + 12 >> 2]
        zP(m, b, e)
        k = +h[m >> 3]
        j = +h[m + 8 >> 3]
        i = 1.0 / +h[b + 352 >> 3]
        h[g + 16 >> 3] = i + k
        h[g + 24 >> 3] = i + j
        h[g >> 3] = k - i
        h[g + 8 >> 3] = j - i
        d = c[(c[b >> 2] | 0) + 168 >> 2] | 0
        c[e >> 2] = c[g >> 2]
        c[e + 4 >> 2] = c[g + 4 >> 2]
        c[e + 8 >> 2] = c[g + 8 >> 2]
        c[e + 12 >> 2] = c[g + 12 >> 2]
        c[e + 16 >> 2] = c[g + 16 >> 2]
        c[e + 20 >> 2] = c[g + 20 >> 2]
        c[e + 24 >> 2] = c[g + 24 >> 2]
        c[e + 28 >> 2] = c[g + 28 >> 2]
        d = AP(d, e) | 0
        e = b + 576 | 0
        if ((d | 0) != (c[e >> 2] | 0)) {
          BP(b)
          c[e >> 2] = d
          CP(b)
          a[b + 537 >> 0] = 1
        }
        l = f
        return
      }

      function zP(a, b, d) {
        a = a | 0
        b = b | 0
        d = d | 0
        var e = 0.0, f = 0.0, g = 0.0, i = 0
        if (!(c[b + 360 >> 2] | 0)) {
          e = +h[b + 352 >> 3]
          f = +h[d + 8 >> 3]
          g = e
          i = b + 528 | 0
          e = +h[d >> 3] / (+h[b + 520 >> 3] * e) - +h[b + 504 >> 3]
        } else {
          e = +h[b + 352 >> 3]
          f = -+h[d >> 3]
          g = e
          i = b + 520 | 0
          e = +h[d + 8 >> 3] / (+h[b + 528 >> 3] * e) - +h[b + 504 >> 3]
        }
        g = f / (+h[i >> 3] * g) - +h[b + 512 >> 3]
        h[a >> 3] = e
        h[a + 8 >> 3] = g
        return
      }

      function AP(a, b) {
        a = a | 0
        b = b | 0
        var d = 0, e = 0, f = 0, g = 0
        g = l
        l = l + 32 | 0
        f = g
        e = Ry(a) | 0
        a:while (1) {
          if (!e) {
            e = 9
            break
          }
          d = Dx(a, e) | 0
          while (1) {
            if (!d) {
              break
            }
            c[f >> 2] = c[b >> 2]
            c[f + 4 >> 2] = c[b + 4 >> 2]
            c[f + 8 >> 2] = c[b + 8 >> 2]
            c[f + 12 >> 2] = c[b + 12 >> 2]
            c[f + 16 >> 2] = c[b + 16 >> 2]
            c[f + 20 >> 2] = c[b + 20 >> 2]
            c[f + 24 >> 2] = c[b + 24 >> 2]
            c[f + 28 >> 2] = c[b + 28 >> 2]
            if ((VM(d, f) | 0) << 24 >> 24) {
              e = 6
              break a
            }
            d = Fx(a, d) | 0
          }
          e = Sy(a, e) | 0
        }
        do {
          if ((e | 0) != 6) {
            if ((e | 0) == 9) {
              d = Ty(a) | 0
              while (1) {
                if (!d) {
                  break
                }
                c[f >> 2] = c[b >> 2]
                c[f + 4 >> 2] = c[b + 4 >> 2]
                c[f + 8 >> 2] = c[b + 8 >> 2]
                c[f + 12 >> 2] = c[b + 12 >> 2]
                c[f + 16 >> 2] = c[b + 16 >> 2]
                c[f + 20 >> 2] = c[b + 20 >> 2]
                c[f + 24 >> 2] = c[b + 24 >> 2]
                c[f + 28 >> 2] = c[b + 28 >> 2]
                if ((SM(d, f) | 0) << 24 >> 24) {
                  e = 12
                  break
                }
                d = Uy(a, d) | 0
              }
              if ((e | 0) == 12) {
                break
              }
              c[f >> 2] = c[b >> 2]
              c[f + 4 >> 2] = c[b + 4 >> 2]
              c[f + 8 >> 2] = c[b + 8 >> 2]
              c[f + 12 >> 2] = c[b + 12 >> 2]
              c[f + 16 >> 2] = c[b + 16 >> 2]
              c[f + 20 >> 2] = c[b + 20 >> 2]
              c[f + 24 >> 2] = c[b + 24 >> 2]
              c[f + 28 >> 2] = c[b + 28 >> 2]
              d = DP(a, f) | 0
              if (!d) {
                d = a
                break
              } else {
                break
              }
            }
          }
        } while (0)
        l = g
        return d | 0
      }

      function BP(b) {
        b = b | 0
        var d = 0
        d = c[b + 576 >> 2] | 0
        a:do {
          if (d | 0) {
            switch (oz(d) | 0) {
              case 0: {
                d = (c[d + 16 >> 2] | 0) + 112 | 0
                a[d >> 0] = a[d >> 0] & -2
                break a
              }
              case 1: {
                d = (c[d + 16 >> 2] | 0) + 117 | 0
                a[d >> 0] = a[d >> 0] & -2
                break a
              }
              case 2: {
                d = (c[d + 16 >> 2] | 0) + 115 | 0
                a[d >> 0] = a[d >> 0] & -2
                break a
              }
              default:
                break a
            }
          }
        } while (0)
        c[b + 584 >> 2] = 0
        return
      }

      function CP(b) {
        b = b | 0
        var d = 0, e = 0
        e = b + 584 | 0
        d = c[e >> 2] | 0
        if (d | 0) {
          C_(d)
          c[e >> 2] = 0
        }
        d = c[b + 576 >> 2] | 0
        a:do {
          if (d | 0) {
            switch (oz(d) | 0) {
              case 0: {
                b = (c[d + 16 >> 2] | 0) + 112 | 0
                a[b >> 0] = a[b >> 0] | 1
                b = mx(d, 0, 138019, 0) | 0
                if (!b) {
                  break a
                }
                c[e >> 2] = oH(xx(d, b) | 0, d) | 0
                break a
              }
              case 1: {
                b = (c[d + 16 >> 2] | 0) + 117 | 0
                a[b >> 0] = a[b >> 0] | 1
                b = mx(dz(d) | 0, 1, 138019, 0) | 0
                if (!b) {
                  break a
                }
                c[e >> 2] = oH(xx(d, b) | 0, d) | 0
                break a
              }
              case 2: {
                b = (c[d + 16 >> 2] | 0) + 115 | 0
                a[b >> 0] = a[b >> 0] | 1
                b = mx(dz(c[((c[d >> 2] & 3 | 0) == 2 ? d : d + -48 | 0) + 40 >> 2] | 0) | 0, 2, 138019, 0) | 0
                if (!b) {
                  break a
                }
                c[e >> 2] = oH(xx(d, b) | 0, d) | 0
                break a
              }
              default:
                break a
            }
          }
        } while (0)
        return
      }

      function DP(a, b) {
        a = a | 0
        b = b | 0
        var d = 0, e = 0, f = 0, g = 0, i = 0, j = 0, k = 0, m = 0, n = 0.0, o = 0.0
        m = l
        l = l + 32 | 0
        e = m
        g = c[a + 16 >> 2] | 0
        i = c[g + 180 >> 2] | 0
        j = g + 184 | 0
        d = 1
        while (1) {
          if ((d | 0) > (i | 0)) {
            k = 4
            break
          }
          f = c[(c[j >> 2] | 0) + (d << 2) >> 2] | 0
          c[e >> 2] = c[b >> 2]
          c[e + 4 >> 2] = c[b + 4 >> 2]
          c[e + 8 >> 2] = c[b + 8 >> 2]
          c[e + 12 >> 2] = c[b + 12 >> 2]
          c[e + 16 >> 2] = c[b + 16 >> 2]
          c[e + 20 >> 2] = c[b + 20 >> 2]
          c[e + 24 >> 2] = c[b + 24 >> 2]
          c[e + 28 >> 2] = c[b + 28 >> 2]
          f = DP(f, e) | 0
          if (!f) {
            d = d + 1 | 0
          } else {
            a = f
            break
          }
        }
        do {
          if ((k | 0) == 4) {
            o = +h[g + 24 >> 3]
            n = +h[g + 40 >> 3]
            if (((+h[b + 16 >> 3] >= +h[g + 16 >> 3] ? +h[g + 32 >> 3] >= +h[b >> 3] : 0) ? +h[b + 24 >> 3] >= o : 0)
                ? n
                >= +h[b + 8 >> 3] : 0) {
              break
            }
            a = 0
          }
        } while (0)
        l = m
        return a | 0
      }

      function EP(b) {
        b = b | 0
        var d = 0, e = 0, f = 0
        f = b + 580 | 0
        d = c[f >> 2] | 0
        a:do {
          if (d | 0) {
            switch (oz(d) | 0) {
              case 0: {
                e = (c[d + 16 >> 2] | 0) + 112 | 0
                a[e >> 0] = a[e >> 0] & -7 | 4
                break a
              }
              case 1: {
                e = (c[d + 16 >> 2] | 0) + 117 | 0
                a[e >> 0] = a[e >> 0] & -7 | 4
                break a
              }
              case 2: {
                e = (c[d + 16 >> 2] | 0) + 115 | 0
                a[e >> 0] = a[e >> 0] & -7 | 4
                break a
              }
              default:
                break a
            }
          }
        } while (0)
        d = b + 588 | 0
        e = c[d >> 2] | 0
        if (e | 0) {
          C_(e)
          c[d >> 2] = 0
        }
        d = c[b + 576 >> 2] | 0
        c[f >> 2] = d
        b:do {
          if (d | 0) {
            switch (oz(d) | 0) {
              case 0: {
                f = (c[d + 16 >> 2] | 0) + 112 | 0
                a[f >> 0] = a[f >> 0] | 2
                FP(b, d)
                break b
              }
              case 1: {
                f = (c[d + 16 >> 2] | 0) + 117 | 0
                a[f >> 0] = a[f >> 0] | 2
                GP(b, d)
                break b
              }
              case 2: {
                f = (c[d + 16 >> 2] | 0) + 115 | 0
                a[f >> 0] = a[f >> 0] | 2
                HP(b, d)
                break b
              }
              default:
                break b
            }
          }
        } while (0)
        return
      }

      function FP(a, b) {
        a = a | 0
        b = b | 0
        var d = 0, e = 0, f = 0, g = 0
        d = a + 592 | 0
        do {
          if ((ez(b) | 0) == (b | 0)) {
            if (!(dy(b) | 0)) {
              qC(d, 0, 108412)
              break
            } else {
              qC(d, 0, 108404)
              break
            }
          } else {
            qC(d, 0, 108418)
          }
        } while (0)
        qC(d, 1, qy(b) | 0)
        c[a + 596 >> 2] = 2
        f = a + 604 | 0
        d = 0
        e = 2
        while (1) {
          d = rx(b, 0, d) | 0
          if (!d) {
            break
          }
          qC(f, e, c[d + 8 >> 2] | 0)
          qC(f, e + 1 | 0, xx(b, d) | 0)
          qC(f, e + 2 | 0, 0)
          e = e + 3 | 0
        }
        c[a + 608 >> 2] = e
        d = mx(b, 0, 137973, 0) | 0
        if (!d) {
          d = mx(b, 0, 108395, 0) | 0
          if (d | 0) {
            g = 11
          }
        } else {
          g = 11
        }
        if ((g | 0) == 11) {
          c[a + 588 >> 2] = oH(xx(b, d) | 0, b) | 0
        }
        return
      }

      function GP(a, b) {
        a = a | 0
        b = b | 0
        var d = 0, e = 0, f = 0, g = 0, h = 0
        f = a + 592 | 0
        qC(f, 0, 108399)
        qC(f, 1, qy(b) | 0)
        c[a + 596 >> 2] = 2
        f = a + 604 | 0
        g = ez(dz(b) | 0) | 0
        e = 2
        d = 0
        while (1) {
          d = rx(g, 1, d) | 0
          if (!d) {
            break
          }
          qC(f, e, c[d + 8 >> 2] | 0)
          qC(f, e | 1, xx(b, d) | 0)
          e = e + 2 | 0
        }
        c[a + 608 >> 2] = e
        d = mx(dz(b) | 0, 1, 137973, 0) | 0
        if (!d) {
          d = mx(dz(b) | 0, 1, 108395, 0) | 0
          if (d | 0) {
            h = 6
          }
        } else {
          h = 6
        }
        if ((h | 0) == 6) {
          c[a + 588 >> 2] = oH(xx(b, d) | 0, b) | 0
        }
        return
      }

      function HP(a, b) {
        a = a | 0
        b = b | 0
        var d = 0, e = 0, f = 0, g = 0, h = 0, i = 0, j = 0, k = 0, l = 0
        h = a + 592 | 0
        qC(h, 0, 108368)
        k = b + 48 | 0
        qC(h, 1, qy(c[((c[b >> 2] & 3 | 0) == 3 ? b : k) + 40 >> 2] | 0) | 0)
        k = (dy(dz(c[((c[b >> 2] & 3 | 0) == 3 ? b : k) + 40 >> 2] | 0) | 0) | 0) != 0
        qC(h, 3, k ? 134656 : 138665)
        k = b + -48 | 0
        qC(h, 4, qy(c[((c[b >> 2] & 3 | 0) == 2 ? b : k) + 40 >> 2] | 0) | 0)
        c[a + 596 >> 2] = 7
        i = a + 604 | 0
        j = ez(dz(c[((c[b >> 2] & 3 | 0) == 2 ? b : k) + 40 >> 2] | 0) | 0) | 0
        g = 7
        d = 0
        a:while (1) {
          while (1) {
            d = rx(j, 2, d) | 0
            if (!d) {
              break a
            }
            e = d + 8 | 0
            f = c[e >> 2] | 0
            if (!(a$(f, 108373) | 0)) {
              l = 5
              break
            }
            if (!(a$(f, 108382) | 0)) {
              l = 7
              break
            }
            if (a$(f, 108391) | 0) {
              break
            }
            qC(h, 6, xx(b, d) | 0)
          }
          if ((l | 0) == 5) {
            l = 0
            qC(h, 2, xx(b, d) | 0)
          } else if ((l | 0) == 7) {
            l = 0
            qC(h, 5, xx(b, d) | 0)
          }
          qC(i, g, c[e >> 2] | 0)
          qC(i, g + 1 | 0, xx(b, d) | 0)
          g = g + 2 | 0
        }
        c[a + 608 >> 2] = g
        d = mx(dz(c[((c[b >> 2] & 3 | 0) == 2 ? b : k) + 40 >> 2] | 0) | 0, 2, 137973, 0) | 0
        if (!d) {
          d = mx(dz(c[((c[b >> 2] & 3 | 0) == 2 ? b : k) + 40 >> 2] | 0) | 0, 2, 108395, 0) | 0
          if (d | 0) {
            l = 13
          }
        } else {
          l = 13
        }
        if ((l | 0) == 13) {
          c[a + 588 >> 2] = oH(xx(b, d) | 0, b) | 0
        }
        return
      }

      function IP(a, b, d) {
        a = a | 0
        b = b | 0
        d = d | 0
        var e = 0, f = 0, g = 0
        g = JP(a, b, c[d >> 2] | 0) | 0
        d = c[d + 4 >> 2] | 0
        while (1) {
          f = c[d + 4 >> 2] | 0
          if (!f) {
            break
          }
          b = 0
          while (1) {
            e = c[f + (b * 20 | 0) + 4 >> 2] | 0
            if (!e) {
              break
            }
            tC(a, c[d >> 2] | 0, e, c[f + (b * 20 | 0) + 8 >> 2] | 0, g, f + (b * 20 | 0) | 0) | 0
            b = b + 1 | 0
          }
          d = d + 8 | 0
        }
        return
      }

      function JP(a, b, d) {
        a = a | 0
        b = b | 0
        d = d | 0
        var e = 0
        e = uH(12) | 0
        if (!b) {
          b = 0
        } else {
          b = m1(b) | 0
        }
        c[e + 4 >> 2] = b
        c[e + 8 >> 2] = m1(d) | 0
        d = a + 100 | 0
        c[e >> 2] = c[d >> 2]
        c[d >> 2] = e
        return e | 0
      }

      function KP(b, c) {
        b = b | 0
        c = c | 0
        LP(b)
        a[b + 44 >> 0] = 0
        MP(b) | 0
        zL(b) | 0
        return
      }

      function LP(b) {
        b = b | 0
        var d = 0, e = 0
        d = c[b + 32 >> 2] | 0
        a:do {
          if (d | 0) {
            while (1) {
              e = c[d >> 2] | 0
              if (!e) {
                break a
              }
              if ((a[e >> 0] | 0) == 103 ? O0(e, 108427) | 0 : 0) {
                IP(b, 0, c[d + 4 >> 2] | 0)
              }
              d = d + 8 | 0
            }
          }
        } while (0)
        return
      }

      function MP(a) {
        a = a | 0
        var b = 0
        b = vC(a, 2, 108440) | 0
        if (!b) {
          a = 999
        } else {
          c[a + 148 >> 2] = c[(c[b + 16 >> 2] | 0) + 12 >> 2]
          a = 300
        }
        return a | 0
      }

      function NP(a, b, d) {
        a = a | 0
        b = b | 0
        d = d | 0
        var e = 0
        a = c[a + 148 >> 2] | 0
        if ((a | 0) != 0 ? (e = c[a >> 2] | 0, (e | 0) != 0) : 0) {
          a = lb[e & 127](b, d) | 0
        } else {
          a = 0
        }
        return a | 0
      }

      function OP(a, b, d, e) {
        a = a | 0
        b = b | 0
        d = d | 0
        e = e | 0
        return (c[b >> 2] | 0) - (c[d >> 2] | 0) | 0
      }

      function PP(a) {
        a = a | 0
        var b = 0.0, d = 0.0
        a = c[a + 16 >> 2] | 0
        d = +h[a + 16 >> 3]
        b = +h[a + 24 >> 3]
        return (QP(~~(d > b ? d : b) >>> 0) | 0) + 1 | 0
      }

      function QP(a) {
        a = a | 0
        var b = 0, c = 0
        if (!a) {
          a = -1
        } else {
          c = a >>> 0 > 65535
          a = c ? a >>> 16 : a
          c = c ? 16 : 0
          b = a >>> 0 > 255
          a = b ? a >>> 8 : a
          c = b ? c | 8 : c
          b = a >>> 0 > 15
          a = b ? a >>> 4 : a
          c = b ? c | 4 : c
          b = a >>> 0 > 3
          a = (b ? c | 2 : c) + ((b ? a >>> 2 : a) >>> 0 > 1 & 1) | 0
        }
        return a | 0
      }

      function RP(b, d, e, f, g) {
        b = b | 0
        d = d | 0
        e = e | 0
        f = f | 0
        g = g | 0
        var i = 0.0, j = 0.0, k = 0, m = 0, n = 0, o = 0, p = 0, q = 0, r = 0
        r = l
        l = l + 32 | 0
        q = r
        p = SP(b, d, e, f, g) | 0
        e = TP(p) | 0
        if ((e | 0) >= 0) {
          n = q + 16 | 0
          o = q + 24 | 0
          m = q + 8 | 0
          k = g + 32 | 0
          e = 0
          g = 0
          while (1) {
            if ((g | 0) >= (d | 0)) {
              break
            }
            f = b + (g * 40 | 0) + 32 | 0
            do {
              if (c[f >> 2] | 0) {
                UP(q, p, b + (g * 40 | 0) | 0)
                i = +h[n >> 3]
                j = +h[o >> 3]
                if (!(c[q >> 2] | 0)) {
                  a[(c[f >> 2] | 0) + 36 >> 0] = 1
                  break
                }
                if (+h[m >> 3] == 0.0) {
                  f = c[f >> 2] | 0
                  h[f + 16 >> 3] = i
                  h[f + 24 >> 3] = j
                  a[f + 36 >> 0] = 1
                  break
                }
                if ((a[k >> 0] | 0) == 1) {
                  f = c[f >> 2] | 0
                  h[f + 16 >> 3] = i
                  h[f + 24 >> 3] = j
                  a[f + 36 >> 0] = 1
                } else {
                  e = 1
                }
              }
            } while (0)
            g = g + 1 | 0
          }
          VP(p)
        }
        l = r
        return e | 0
      }

      function SP(a, b, d, e, f) {
        a = a | 0
        b = b | 0
        d = d | 0
        e = e | 0
        f = f | 0
        var g = 0, h = 0, i = 0, j = 0
        g = tH(28) | 0
        j = Bw(25808, c[4558] | 0) | 0
        h = g + 20 | 0
        c[h >> 2] = j
        do {
          if (j) {
            j = BS() | 0
            c[g + 24 >> 2] = j
            if (!j) {
              D1(108658, 14, 1, c[15686] | 0) | 0
              i = 6
              break
            } else {
              c[g >> 2] = a
              c[g + 4 >> 2] = b
              c[g + 8 >> 2] = d
              c[g + 12 >> 2] = e
              c[g + 16 >> 2] = f
              break
            }
          } else {
            D1(108658, 14, 1, c[15686] | 0) | 0
            i = 6
          }
        } while (0)
        if ((i | 0) == 6) {
          a = c[h >> 2] | 0
          if (a | 0) {
            xw(a) | 0
          }
          a = c[g + 24 >> 2] | 0
          if (a | 0) {
            DS(a) | 0
          }
          C_(g)
          g = 0
        }
        return g | 0
      }

      function TP(a) {
        a = a | 0
        var b = 0
        b = cQ(a) | 0
        if ((b | 0) >= 0) {
          dQ(a)
          eQ(a)
          b = xw(c[a + 20 >> 2] | 0) | 0
        }
        return b | 0
      }

      function UP(a, b, d) {
        a = a | 0
        b = b | 0
        d = d | 0
        var e = 0.0, f = 0, g = 0, i = 0.0, j = 0, k = 0.0, m = 0, n = 0, o = 0, p = 0, q = 0.0, r = 0, s = 0, t = 0,
            u = 0, v = 0, w = 0, x = 0, y = 0, z = 0, A = 0.0, B = 0, C = 0, D = 0, E = 0, F = 0, G = 0, H = 0, I = 0,
            J = 0, K = 0.0, L = 0, M = 0
        M = l
        l = l + 464 | 0
        J = M + 416 | 0
        L = M + 400 | 0
        G = M + 384 | 0
        m = M + 352 | 0
        n = M + 320 | 0
        o = M + 288 | 0
        p = M + 256 | 0
        r = M + 224 | 0
        s = M + 192 | 0
        t = M + 160 | 0
        u = M + 128 | 0
        v = M + 96 | 0
        x = M + 64 | 0
        y = M + 32 | 0
        H = M
        z = c[d + 32 >> 2] | 0
        e = +h[z >> 3]
        C = d + 16 | 0
        A = (e * 2.0 + +h[C >> 3]) * .125
        D = z + 8 | 0
        I = d + 24 | 0
        i = +h[I >> 3]
        K = (+h[D >> 3] * 2.0 + i) * .5
        if (!z) {
          qa(108451, 108461, 445, 108471)
        }
        f = J
        g = f + 36 | 0
        do {
          c[f >> 2] = 0
          f = f + 4 | 0
        } while ((f | 0) < (g | 0))
        B = z + 16 | 0
        h[B >> 3] = +h[d >> 3] - e
        E = d + 8 | 0
        F = z + 24 | 0
        h[F >> 3] = i + +h[E >> 3]
        WP(m, b, d, J)
        j = c[m >> 2] | 0
        f = c[m + 4 >> 2] | 0
        e = +h[m + 8 >> 3]
        m = m + 16 | 0
        c[L >> 2] = c[m >> 2]
        c[L + 4 >> 2] = c[m + 4 >> 2]
        c[L + 8 >> 2] = c[m + 8 >> 2]
        c[L + 12 >> 2] = c[m + 12 >> 2]
        a:do {
          if (!j) {
            c[a >> 2] = 0
            c[a + 4 >> 2] = f
            h[a + 8 >> 3] = e
            a = a + 16 | 0
            c[a >> 2] = c[L >> 2]
            c[a + 4 >> 2] = c[L + 4 >> 2]
            c[a + 8 >> 2] = c[L + 8 >> 2]
            c[a + 12 >> 2] = c[L + 12 >> 2]
          } else {
            h[F >> 3] = +h[E >> 3]
            WP(n, b, d, J)
            g = c[n >> 2] | 0
            m = c[n + 4 >> 2] | 0
            i = +h[n + 8 >> 3]
            n = n + 16 | 0
            c[G >> 2] = c[n >> 2]
            c[G + 4 >> 2] = c[n + 4 >> 2]
            c[G + 8 >> 2] = c[n + 8 >> 2]
            c[G + 12 >> 2] = c[n + 12 >> 2]
            if (!g) {
              c[a >> 2] = 0
              c[a + 4 >> 2] = m
              h[a + 8 >> 3] = i
              a = a + 16 | 0
              c[a >> 2] = c[G >> 2]
              c[a + 4 >> 2] = c[G + 4 >> 2]
              c[a + 8 >> 2] = c[G + 8 >> 2]
              c[a + 12 >> 2] = c[G + 12 >> 2]
              break
            }
            if (i < e) {
              c[L >> 2] = c[G >> 2]
              c[L + 4 >> 2] = c[G + 4 >> 2]
              c[L + 8 >> 2] = c[G + 8 >> 2]
              c[L + 12 >> 2] = c[G + 12 >> 2]
              f = m
              e = i
            } else {
              g = j
            }
            h[F >> 3] = +h[E >> 3] - +h[D >> 3]
            WP(o, b, d, J)
            m = c[o >> 2] | 0
            j = c[o + 4 >> 2] | 0
            i = +h[o + 8 >> 3]
            o = o + 16 | 0
            c[G >> 2] = c[o >> 2]
            c[G + 4 >> 2] = c[o + 4 >> 2]
            c[G + 8 >> 2] = c[o + 8 >> 2]
            c[G + 12 >> 2] = c[o + 12 >> 2]
            if (!m) {
              c[a >> 2] = 0
              c[a + 4 >> 2] = j
              h[a + 8 >> 3] = i
              a = a + 16 | 0
              c[a >> 2] = c[G >> 2]
              c[a + 4 >> 2] = c[G + 4 >> 2]
              c[a + 8 >> 2] = c[G + 8 >> 2]
              c[a + 12 >> 2] = c[G + 12 >> 2]
              break
            }
            if (i < e) {
              c[L >> 2] = c[G >> 2]
              c[L + 4 >> 2] = c[G + 4 >> 2]
              c[L + 8 >> 2] = c[G + 8 >> 2]
              c[L + 12 >> 2] = c[G + 12 >> 2]
              f = j
              e = i
            } else {
              m = g
            }
            h[B >> 3] = +h[d >> 3]
            h[F >> 3] = +h[I >> 3] + +h[E >> 3]
            WP(p, b, d, J)
            g = c[p >> 2] | 0
            j = c[p + 4 >> 2] | 0
            i = +h[p + 8 >> 3]
            p = p + 16 | 0
            c[G >> 2] = c[p >> 2]
            c[G + 4 >> 2] = c[p + 4 >> 2]
            c[G + 8 >> 2] = c[p + 8 >> 2]
            c[G + 12 >> 2] = c[p + 12 >> 2]
            if (!g) {
              c[a >> 2] = 0
              c[a + 4 >> 2] = j
              h[a + 8 >> 3] = i
              a = a + 16 | 0
              c[a >> 2] = c[G >> 2]
              c[a + 4 >> 2] = c[G + 4 >> 2]
              c[a + 8 >> 2] = c[G + 8 >> 2]
              c[a + 12 >> 2] = c[G + 12 >> 2]
              break
            }
            if (i < e) {
              c[L >> 2] = c[G >> 2]
              c[L + 4 >> 2] = c[G + 4 >> 2]
              c[L + 8 >> 2] = c[G + 8 >> 2]
              c[L + 12 >> 2] = c[G + 12 >> 2]
              m = g
              f = j
              e = i
            }
            h[F >> 3] = +h[E >> 3] - +h[D >> 3]
            WP(r, b, d, J)
            g = c[r >> 2] | 0
            j = c[r + 4 >> 2] | 0
            i = +h[r + 8 >> 3]
            r = r + 16 | 0
            c[G >> 2] = c[r >> 2]
            c[G + 4 >> 2] = c[r + 4 >> 2]
            c[G + 8 >> 2] = c[r + 8 >> 2]
            c[G + 12 >> 2] = c[r + 12 >> 2]
            if (!g) {
              c[a >> 2] = 0
              c[a + 4 >> 2] = j
              h[a + 8 >> 3] = i
              a = a + 16 | 0
              c[a >> 2] = c[G >> 2]
              c[a + 4 >> 2] = c[G + 4 >> 2]
              c[a + 8 >> 2] = c[G + 8 >> 2]
              c[a + 12 >> 2] = c[G + 12 >> 2]
              break
            }
            if (i < e) {
              c[L >> 2] = c[G >> 2]
              c[L + 4 >> 2] = c[G + 4 >> 2]
              c[L + 8 >> 2] = c[G + 8 >> 2]
              c[L + 12 >> 2] = c[G + 12 >> 2]
              m = g
              f = j
              e = i
            }
            h[B >> 3] = +h[C >> 3] + +h[d >> 3]
            h[F >> 3] = +h[I >> 3] + +h[E >> 3]
            WP(s, b, d, J)
            g = c[s >> 2] | 0
            j = c[s + 4 >> 2] | 0
            i = +h[s + 8 >> 3]
            s = s + 16 | 0
            c[G >> 2] = c[s >> 2]
            c[G + 4 >> 2] = c[s + 4 >> 2]
            c[G + 8 >> 2] = c[s + 8 >> 2]
            c[G + 12 >> 2] = c[s + 12 >> 2]
            if (!g) {
              c[a >> 2] = 0
              c[a + 4 >> 2] = j
              h[a + 8 >> 3] = i
              a = a + 16 | 0
              c[a >> 2] = c[G >> 2]
              c[a + 4 >> 2] = c[G + 4 >> 2]
              c[a + 8 >> 2] = c[G + 8 >> 2]
              c[a + 12 >> 2] = c[G + 12 >> 2]
              break
            }
            if (i < e) {
              c[L >> 2] = c[G >> 2]
              c[L + 4 >> 2] = c[G + 4 >> 2]
              c[L + 8 >> 2] = c[G + 8 >> 2]
              c[L + 12 >> 2] = c[G + 12 >> 2]
              m = g
              f = j
              e = i
            }
            h[F >> 3] = +h[E >> 3]
            WP(t, b, d, J)
            g = c[t >> 2] | 0
            j = c[t + 4 >> 2] | 0
            i = +h[t + 8 >> 3]
            t = t + 16 | 0
            c[G >> 2] = c[t >> 2]
            c[G + 4 >> 2] = c[t + 4 >> 2]
            c[G + 8 >> 2] = c[t + 8 >> 2]
            c[G + 12 >> 2] = c[t + 12 >> 2]
            if (!g) {
              c[a >> 2] = 0
              c[a + 4 >> 2] = j
              h[a + 8 >> 3] = i
              a = a + 16 | 0
              c[a >> 2] = c[G >> 2]
              c[a + 4 >> 2] = c[G + 4 >> 2]
              c[a + 8 >> 2] = c[G + 8 >> 2]
              c[a + 12 >> 2] = c[G + 12 >> 2]
              break
            }
            if (i < e) {
              c[L >> 2] = c[G >> 2]
              c[L + 4 >> 2] = c[G + 4 >> 2]
              c[L + 8 >> 2] = c[G + 8 >> 2]
              c[L + 12 >> 2] = c[G + 12 >> 2]
              m = g
              f = j
              e = i
            }
            h[F >> 3] = +h[E >> 3] - +h[D >> 3]
            WP(u, b, d, J)
            g = c[u >> 2] | 0
            j = c[u + 4 >> 2] | 0
            i = +h[u + 8 >> 3]
            u = u + 16 | 0
            c[G >> 2] = c[u >> 2]
            c[G + 4 >> 2] = c[u + 4 >> 2]
            c[G + 8 >> 2] = c[u + 8 >> 2]
            c[G + 12 >> 2] = c[u + 12 >> 2]
            if (!g) {
              c[a >> 2] = 0
              c[a + 4 >> 2] = j
              h[a + 8 >> 3] = i
              a = a + 16 | 0
              c[a >> 2] = c[G >> 2]
              c[a + 4 >> 2] = c[G + 4 >> 2]
              c[a + 8 >> 2] = c[G + 8 >> 2]
              c[a + 12 >> 2] = c[G + 12 >> 2]
              break
            }
            if (i < e) {
              c[L >> 2] = c[G >> 2]
              c[L + 4 >> 2] = c[G + 4 >> 2]
              c[L + 8 >> 2] = c[G + 8 >> 2]
              c[L + 12 >> 2] = c[G + 12 >> 2]
              f = j
              e = i
            } else {
              g = m
            }
            j = (c[J + 28 >> 2] | 0) == 0
            do {
              if (!(c[J + 24 >> 2] | 0)) {
                if (j) {
                  if (c[J + 32 >> 2] | 0) {
                    w = 38
                    break
                  }
                  if (!((c[J + 12 >> 2] | 0) == 0 & (c[J >> 2] | 0) == 0)) {
                    w = 38
                  }
                } else {
                  w = 46
                }
              } else if (j) {
                w = 38
              } else {
                w = 46
              }
            } while (0)
            b:do {
              if ((w | 0) == 38) {
                if (!(c[J + 32 >> 2] | 0)) {
                  h[B >> 3] = +h[d >> 3] - +h[z >> 3]
                  p = v + 4 | 0
                  r = v + 8 | 0
                  s = v + 16 | 0
                  m = F
                  j = E
                  i = +h[I >> 3]
                  c:while (1) {
                    while (1) {
                      h[m >> 3] = +h[j >> 3] + i
                      if (!(+h[B >> 3] <= +h[C >> 3] + +h[d >> 3])) {
                        w = 46
                        break b
                      }
                      WP(v, b, d, J)
                      n = c[v >> 2] | 0
                      o = c[p >> 2] | 0
                      k = +h[r >> 3]
                      c[G >> 2] = c[s >> 2]
                      c[G + 4 >> 2] = c[s + 4 >> 2]
                      c[G + 8 >> 2] = c[s + 8 >> 2]
                      c[G + 12 >> 2] = c[s + 12 >> 2]
                      if (!n) {
                        break c
                      }
                      if (k < e) {
                        break
                      } else {
                        m = B
                        j = B
                        i = A
                      }
                    }
                    c[L >> 2] = c[G >> 2]
                    c[L + 4 >> 2] = c[G + 4 >> 2]
                    c[L + 8 >> 2] = c[G + 8 >> 2]
                    c[L + 12 >> 2] = c[G + 12 >> 2]
                    m = B
                    j = B
                    i = A
                    g = n
                    f = o
                    e = k
                  }
                  c[a >> 2] = 0
                  c[a + 4 >> 2] = o
                  h[a + 8 >> 3] = k
                  a = a + 16 | 0
                  c[a >> 2] = c[G >> 2]
                  c[a + 4 >> 2] = c[G + 4 >> 2]
                  c[a + 8 >> 2] = c[G + 8 >> 2]
                  c[a + 12 >> 2] = c[G + 12 >> 2]
                  break a
                } else {
                  w = 46
                }
              }
            } while (0)
            d:do {
              if ((w | 0) == 46) {
                if ((c[J + 12 >> 2] | 0) == 0 & (c[J >> 2] | 0) == 0) {
                  h[B >> 3] = +h[d >> 3] - +h[z >> 3]
                  k = +h[E >> 3]
                  n = x + 4 | 0
                  o = x + 8 | 0
                  p = x + 16 | 0
                  i = k
                  k = +h[I >> 3] + k
                  while (1) {
                    h[F >> 3] = k
                    if (!(k >= i - +h[D >> 3])) {
                      break d
                    }
                    WP(x, b, d, J)
                    j = c[x >> 2] | 0
                    m = c[n >> 2] | 0
                    i = +h[o >> 3]
                    c[G >> 2] = c[p >> 2]
                    c[G + 4 >> 2] = c[p + 4 >> 2]
                    c[G + 8 >> 2] = c[p + 8 >> 2]
                    c[G + 12 >> 2] = c[p + 12 >> 2]
                    if (!j) {
                      break
                    }
                    if (i < e) {
                      c[L >> 2] = c[G >> 2]
                      c[L + 4 >> 2] = c[G + 4 >> 2]
                      c[L + 8 >> 2] = c[G + 8 >> 2]
                      c[L + 12 >> 2] = c[G + 12 >> 2]
                      g = j
                      f = m
                      e = i
                    }
                    i = +h[E >> 3]
                    k = +h[F >> 3] - K
                  }
                  c[a >> 2] = 0
                  c[a + 4 >> 2] = m
                  h[a + 8 >> 3] = i
                  a = a + 16 | 0
                  c[a >> 2] = c[G >> 2]
                  c[a + 4 >> 2] = c[G + 4 >> 2]
                  c[a + 8 >> 2] = c[G + 8 >> 2]
                  c[a + 12 >> 2] = c[G + 12 >> 2]
                  break a
                }
              }
            } while (0)
            i = +h[d >> 3]
            k = +h[C >> 3] + i
            h[B >> 3] = k
            q = +h[D >> 3]
            h[F >> 3] = +h[E >> 3] - q
            j = c[J + 4 >> 2] | 0
            do {
              if (!(c[J + 8 >> 2] | 0)) {
                m = c[J >> 2] | 0
                if (!((j | 0) == 0 & (m | 0) == 0)) {
                  w = 59
                  break
                }
                if (c[J + 20 >> 2] | 0) {
                  j = 0
                  m = 0
                  w = 59
                  break
                }
                if (c[J + 32 >> 2] | 0) {
                  j = 0
                  m = 0
                  w = 59
                }
              } else {
                m = c[J >> 2] | 0
                w = 59
              }
            } while (0)
            e:do {
              if ((w | 0) == 59) {
                f:do {
                  if ((j | 0) == 0 & (m | 0) == 0) {
                    h[B >> 3] = k
                    p = y + 4 | 0
                    r = y + 8 | 0
                    s = y + 16 | 0
                    m = F
                    j = E
                    i = q
                    g:while (1) {
                      while (1) {
                        h[m >> 3] = +h[j >> 3] - i
                        i = +h[d >> 3]
                        if (!(+h[B >> 3] >= i - +h[z >> 3])) {
                          break f
                        }
                        WP(y, b, d, J)
                        n = c[y >> 2] | 0
                        o = c[p >> 2] | 0
                        k = +h[r >> 3]
                        c[G >> 2] = c[s >> 2]
                        c[G + 4 >> 2] = c[s + 4 >> 2]
                        c[G + 8 >> 2] = c[s + 8 >> 2]
                        c[G + 12 >> 2] = c[s + 12 >> 2]
                        if (!n) {
                          break g
                        }
                        if (k < e) {
                          break
                        } else {
                          m = B
                          j = B
                          i = A
                        }
                      }
                      c[L >> 2] = c[G >> 2]
                      c[L + 4 >> 2] = c[G + 4 >> 2]
                      c[L + 8 >> 2] = c[G + 8 >> 2]
                      c[L + 12 >> 2] = c[G + 12 >> 2]
                      m = B
                      j = B
                      i = A
                      g = n
                      f = o
                      e = k
                    }
                    c[a >> 2] = 0
                    c[a + 4 >> 2] = o
                    h[a + 8 >> 3] = k
                    a = a + 16 | 0
                    c[a >> 2] = c[G >> 2]
                    c[a + 4 >> 2] = c[G + 4 >> 2]
                    c[a + 8 >> 2] = c[G + 8 >> 2]
                    c[a + 12 >> 2] = c[G + 12 >> 2]
                    break a
                  }
                } while (0)
                if (c[J + 20 >> 2] | 0) {
                  break
                }
                if (c[J + 32 >> 2] | 0) {
                  break
                }
                h[B >> 3] = +h[C >> 3] + i
                i = +h[E >> 3]
                n = H + 4 | 0
                o = H + 8 | 0
                p = H + 16 | 0
                k = i
                i = i - +h[D >> 3]
                while (1) {
                  h[F >> 3] = i
                  if (!(i <= +h[I >> 3] + k)) {
                    break e
                  }
                  WP(H, b, d, J)
                  j = c[H >> 2] | 0
                  m = c[n >> 2] | 0
                  i = +h[o >> 3]
                  c[G >> 2] = c[p >> 2]
                  c[G + 4 >> 2] = c[p + 4 >> 2]
                  c[G + 8 >> 2] = c[p + 8 >> 2]
                  c[G + 12 >> 2] = c[p + 12 >> 2]
                  if (!j) {
                    break
                  }
                  if (i < e) {
                    c[L >> 2] = c[G >> 2]
                    c[L + 4 >> 2] = c[G + 4 >> 2]
                    c[L + 8 >> 2] = c[G + 8 >> 2]
                    c[L + 12 >> 2] = c[G + 12 >> 2]
                    g = j
                    f = m
                    e = i
                  }
                  k = +h[E >> 3]
                  i = +h[F >> 3] + K
                }
                c[a >> 2] = 0
                c[a + 4 >> 2] = m
                h[a + 8 >> 3] = i
                a = a + 16 | 0
                c[a >> 2] = c[G >> 2]
                c[a + 4 >> 2] = c[G + 4 >> 2]
                c[a + 8 >> 2] = c[G + 8 >> 2]
                c[a + 12 >> 2] = c[G + 12 >> 2]
                break a
              }
            } while (0)
            c[a >> 2] = g
            c[a + 4 >> 2] = f
            h[a + 8 >> 3] = e
            a = a + 16 | 0
            c[a >> 2] = c[L >> 2]
            c[a + 4 >> 2] = c[L + 4 >> 2]
            c[a + 8 >> 2] = c[L + 8 >> 2]
            c[a + 12 >> 2] = c[L + 12 >> 2]
          }
        } while (0)
        l = M
        return
      }

      function VP(a) {
        a = a | 0
        DS(c[a + 24 >> 2] | 0) | 0
        C_(a)
        return
      }

      function WP(b, d, e, f) {
        b = b | 0
        d = d | 0
        e = e | 0
        f = f | 0
        var g = 0, i = 0.0, j = 0, k = 0, m = 0, n = 0.0, o = 0, p = 0, q = 0, r = 0.0, s = 0, t = 0
        t = l
        l = l + 48 | 0
        q = t + 32 | 0
        s = t + 16 | 0
        p = t
        g = c[e + 32 >> 2] | 0
        if (!g) {
          qa(108451, 108461, 382, 108480)
        }
        o = g + 16 | 0
        c[p >> 2] = c[o >> 2]
        c[p + 4 >> 2] = c[o + 4 >> 2]
        c[p + 8 >> 2] = c[o + 8 >> 2]
        c[p + 12 >> 2] = c[o + 12 >> 2]
        o = d + 4 | 0
        m = 0
        g = 0
        while (1) {
          if ((m | 0) >= (c[o >> 2] | 0)) {
            break
          }
          j = c[d >> 2] | 0
          k = j + (m * 40 | 0) | 0
          do {
            if ((k | 0) != (e | 0)) {
              if (+h[j + (m * 40 | 0) + 16 >> 3] > 0.0 ? +h[j + (m * 40 | 0) + 24 >> 3] > 0.0 : 0) {
                break
              }
              g = g + ((XP(e, k) | 0) != 0 & 1) | 0
            }
          } while (0)
          m = m + 1 | 0
        }
        YP(e, q)
        m = c[d + 24 >> 2] | 0
        m = FS(m, c[m >> 2] | 0, q) | 0
        if (!m) {
          c[b >> 2] = g
          h[b + 8 >> 3] = 0.0
          s = b + 16 | 0
          c[s >> 2] = c[p >> 2]
          c[s + 4 >> 2] = c[p + 4 >> 2]
          c[s + 8 >> 2] = c[p + 8 >> 2]
          c[s + 12 >> 2] = c[p + 12 >> 2]
        } else {
          k = m
          i = 0.0
          while (1) {
            if (!k) {
              break
            }
            j = c[(c[k + 4 >> 2] | 0) + 16 >> 2] | 0
            if ((j | 0) != (e | 0)) {
              ZP(j, s)
              n = +_P(q, s)
              if (n > 0.0) {
                g = g + 1 | 0
                i = +$P(e, j, q, n, f) + i
              }
              d = c[j + 32 >> 2] | 0
              if (((d | 0) != 0 ? (a[d + 36 >> 0] | 0) != 0 : 0) ? (YP(j, s), r = +_P(q, s), r > 0.0) : 0) {
                g = g + 1 | 0
                i = +aQ(e, j, q, r, f) + i
              }
            }
            k = c[k >> 2] | 0
          }
          AS(m)
          c[b >> 2] = g
          h[b + 8 >> 3] = i
          s = b + 16 | 0
          c[s >> 2] = c[p >> 2]
          c[s + 4 >> 2] = c[p + 4 >> 2]
          c[s + 8 >> 2] = c[p + 8 >> 2]
          c[s + 12 >> 2] = c[p + 12 >> 2]
        }
        l = t
        return
      }

      function XP(a, b) {
        a = a | 0
        b = b | 0
        var d = 0.0, e = 0.0, f = 0.0, g = 0.0
        a = c[a + 32 >> 2] | 0
        if (+h[b + 16 >> 3] == 0.0 ? +h[b + 24 >> 3] == 0.0 : 0) {
          if ((((a | 0) != 0 ? (d = +h[b >> 3], e = +h[a + 16 >> 3], d > e) : 0) ? d < +h[a >> 3] + e : 0) ? (f = +h[b
          + 8 >> 3], g = +h[a + 24 >> 3], f > g) : 0) {
            a = f < +h[a + 8 >> 3] + g & 1
          } else {
            a = 0
          }
          return a | 0
        }
        qa(108517, 108461, 219, 108554)
        return 0
      }

      function YP(a, b) {
        a = a | 0
        b = b | 0
        var d = 0.0, e = 0.0
        a = c[a + 32 >> 2] | 0
        e = +h[a + 16 >> 3]
        c[b >> 2] = ~~e
        d = +h[a + 24 >> 3]
        c[b + 4 >> 2] = ~~d
        c[b + 8 >> 2] = ~~(+h[a >> 3] + e)
        c[b + 12 >> 2] = ~~(+h[a + 8 >> 3] + d)
        return
      }

      function ZP(a, b) {
        a = a | 0
        b = b | 0
        var d = 0.0, e = 0.0
        e = +h[a >> 3]
        c[b >> 2] = ~~e
        d = +h[a + 8 >> 3]
        c[b + 4 >> 2] = ~~d
        c[b + 8 >> 2] = ~~(+h[a + 16 >> 3] + e)
        c[b + 12 >> 2] = ~~(+h[a + 24 >> 3] + d)
        return
      }

      function _P(a, b) {
        a = a | 0
        b = b | 0
        var d = 0.0, e = 0, f = 0, g = 0, h = 0, i = 0, j = 0, k = 0, l = 0
        i = c[a + 8 >> 2] | 0
        j = c[b >> 2] | 0
        if ((((i | 0) >= (j | 0) ? (k = c[a >> 2] | 0, l = c[b + 8 >> 2] | 0, (k | 0) <= (l | 0)) : 0) ? (e = c[a + 12
        >> 2] | 0, f = c[b + 4 >> 2] | 0, (e | 0) >= (f | 0)) : 0) ? (g = c[a + 4 >> 2] | 0, h = c[b + 12 >> 2] | 0, (g
            | 0) <= (h | 0)) : 0) {
          d = (+(c[((e | 0) < (h | 0) ? a : b) + 12 >> 2] | 0) - +(c[((g | 0) > (f | 0) ? a : b)
          + 4 >> 2] | 0)) * (+(c[((i | 0) < (l | 0) ? a : b) + 8 >> 2] | 0) - +(c[((k | 0) > (j | 0) ? a : b) >> 2]
              | 0))
        } else {
          d = 0.0
        }
        return +d
      }

      function $P(a, b, d, e, f) {
        a = a | 0
        b = b | 0
        d = d | 0
        e = +e
        f = f | 0
        var g = 0.0, h = 0.0, i = 0, j = 0
        j = l
        l = l + 16 | 0
        i = j
        a = bQ(a, b) | 0
        f = f + (((a | 0) < 0 ? 5 : a) << 2) | 0
        a = c[f >> 2] | 0
        if (!a) {
          c[f >> 2] = b
          g = e
        } else {
          ZP(a, i)
          g = +_P(d, i)
          g = g > e ? g : 0.0
          a = c[f >> 2] | 0
          if ((c[a + 32 >> 2] | 0) != 0 ? (YP(a, i), h = +_P(d, i), h > e) : 0) {
            g = h > g ? h : g
          }
          if (!(g > 0.0)) {
            c[f >> 2] = b
            g = e
          }
        }
        l = j
        return +g
      }

      function aQ(a, b, d, e, f) {
        a = a | 0
        b = b | 0
        d = d | 0
        e = +e
        f = f | 0
        var g = 0.0, h = 0.0, i = 0, j = 0
        j = l
        l = l + 16 | 0
        i = j
        a = bQ(a, b) | 0
        f = f + (((a | 0) < 0 ? 5 : a) << 2) | 0
        a = c[f >> 2] | 0
        if (!a) {
          c[f >> 2] = b
          g = e
        } else {
          ZP(a, i)
          g = +_P(d, i)
          g = g > e ? g : 0.0
          a = c[f >> 2] | 0
          if ((c[a + 32 >> 2] | 0) != 0 ? (YP(a, i), h = +_P(d, i), h > e) : 0) {
            g = h > g ? h : g
          }
          if (!(g > 0.0)) {
            c[f >> 2] = b
            g = e
          }
        }
        l = j
        return +g
      }

      function bQ(b, d) {
        b = b | 0
        d = d | 0
        var e = 0, f = 0, g = 0.0, i = 0.0, j = 0.0, k = 0.0
        e = c[b + 32 >> 2] | 0
        f = c[d + 32 >> 2] | 0
        if ((e | 0) == (f | 0)) {
          qa(108496, 108461, 276, 108506)
        }
        do {
          if ((a[e + 36 >> 0] | 0) != 0 ? (a[f + 36 >> 0] | 0) != 0 : 0) {
            j = +h[b >> 3]
            if (j == 0.0 ? +h[b + 8 >> 3] == 0.0 : 0) {
              e = -1
              break
            }
            k = +h[d >> 3]
            i = +h[d + 8 >> 3]
            if (!(k == 0.0 & i == 0.0)) {
              g = +h[b + 8 >> 3]
              if (i < g) {
                if (k < j) {
                  e = 0
                  break
                }
                e = k > j ? 2 : 1
                break
              }
              e = k < j
              if (i > g) {
                if (e) {
                  e = 6
                  break
                }
                e = k > j ? 8 : 7
                break
              }
              if (!e) {
                if (k > j) {
                  e = 5
                } else {
                  e = -1
                }
              } else {
                e = 3
              }
            } else {
              e = -1
            }
          } else {
            e = -1
          }
        } while (0)
        return e | 0
      }

      function cQ(a) {
        a = a | 0
        var b = 0, d = 0, e = 0, f = 0, g = 0, h = 0, i = 0, j = 0, k = 0, m = 0, n = 0, o = 0
        k = l
        l = l + 32 | 0
        d = k + 24 | 0
        e = k + 16 | 0
        f = k
        g = PP(a) | 0
        h = a + 4 | 0
        i = e + 4 | 0
        j = a + 20 | 0
        b = 0
        while (1) {
          if ((b | 0) >= (c[h >> 2] | 0)) {
            b = 0
            break
          }
          m = tH(32) | 0
          o = (c[a >> 2] | 0) + (b * 40 | 0) | 0
          n = m + 12 | 0
          c[m + 28 >> 2] = o
          fQ(f, o)
          c[n >> 2] = c[f >> 2]
          c[n + 4 >> 2] = c[f + 4 >> 2]
          c[n + 8 >> 2] = c[f + 8 >> 2]
          c[n + 12 >> 2] = c[f + 12 >> 2]
          n = c[n >> 2] | 0
          c[e >> 2] = (((c[m + 20 >> 2] | 0) - n | 0) / 2 | 0) + n
          n = c[m + 16 >> 2] | 0
          c[i >> 2] = (((c[m + 24 >> 2] | 0) - n | 0) / 2 | 0) + n
          c[d >> 2] = c[e >> 2]
          c[d + 4 >> 2] = c[e + 4 >> 2]
          c[m + 8 >> 2] = gQ(d, g) | 0
          n = c[j >> 2] | 0
          if (!(nb[c[n >> 2] & 63](n, m, 1) | 0)) {
            b = -1
            break
          } else {
            b = b + 1 | 0
          }
        }
        l = k
        return b | 0
      }

      function dQ(a) {
        a = a | 0
        var b = 0, d = 0, e = 0
        d = a + 20 | 0
        e = c[d >> 2] | 0
        b = a + 24 | 0
        a = nb[c[e >> 2] & 63](e, 0, 128) | 0
        while (1) {
          if (!a) {
            break
          }
          e = c[b >> 2] | 0
          GS(e, a + 12 | 0, c[a + 28 >> 2] | 0, e, 0) | 0
          e = c[d >> 2] | 0
          a = nb[c[e >> 2] & 63](e, a, 8) | 0
        }
        return
      }

      function eQ(a) {
        a = a | 0
        var b = 0, d = 0, e = 0, f = 0, g = 0, h = 0
        e = a + 20 | 0
        f = Dw(c[e >> 2] | 0) | 0
        d = 0
        while (1) {
          if (!(Dw(c[e >> 2] | 0) | 0)) {
            break
          }
          g = c[e >> 2] | 0
          a = c[(c[g + 8 >> 2] | 0) + 4 >> 2] | 0
          if (!a) {
            h = 8
            break
          }
          b = c[(c[g + 4 >> 2] | 0) + 8 >> 2] | 0
          if ((b | 0) < 0) {
            a = c[a + 8 >> 2] | 0
          } else {
            a = a + (0 - b) | 0
          }
          if (!a) {
            h = 8
            break
          }
          nb[c[g >> 2] & 63](g, a, 4096) | 0
          C_(a)
          d = d + 1 | 0
        }
        if ((h | 0) == 8) {
          qa(108567, 108461, 616, 108570)
        }
        if ((f | 0) == (d | 0)) {
          return
        } else {
          qa(108582, 108461, 623, 108570)
        }
      }

      function fQ(a, b) {
        a = a | 0
        b = b | 0
        var d = 0, e = 0.0, f = 0.0, g = 0.0, i = 0, j = 0, k = 0, l = 0.0
        d = c[b + 32 >> 2] | 0
        if (!d) {
          e = 0.0
          f = 0.0
        } else {
          e = +h[d >> 3]
          f = +h[d + 8 >> 3]
        }
        l = +h[b >> 3]
        k = ~~+A(+(l - e))
        g = +h[b + 8 >> 3]
        j = ~~+A(+(g - f))
        i = ~~+N(+(l + e + +h[b + 16 >> 3]))
        if ((i | 0) == 2147483647) {
          qa(108594, 108461, 264, 108621)
        }
        d = ~~+N(+(g + f + +h[b + 24 >> 3]))
        if ((d | 0) == 2147483647) {
          qa(108631, 108461, 266, 108621)
        } else {
          c[a >> 2] = k
          c[a + 4 >> 2] = j
          c[a + 8 >> 2] = i
          c[a + 12 >> 2] = d
          return
        }
      }

      function gQ(a, b) {
        a = a | 0
        b = b | 0
        var d = 0, e = 0, f = 0, g = 0, h = 0, i = 0
        f = 0
        e = c[a >> 2] | 0
        d = c[a + 4 >> 2] | 0
        while (1) {
          a = b + -1 | 0
          if ((b | 0) <= 0) {
            break
          }
          i = e >>> a & 1
          b = d >>> a & 1
          g = b + -1 | 0
          h = g & (e ^ d)
          g = g & 0 - i
          f = i << 1 | f << 2 | i ^ b
          b = a
          e = h ^ e ^ g
          d = h ^ d ^ g
        }
        return f | 0
      }

      function hQ(b) {
        b = b | 0
        var d = 0, e = 0, f = 0, g = 0
        d = V_(b) | 0
        if (d >>> 0 >= (c[46595] | 0) >>> 0) {
          d = d + 11 | 0
          c[46595] = d
          d = wH(c[46596] | 0, d) | 0
          c[46596] = d
          if (!d) {
            d = 0
          } else {
            e = 4
          }
        } else {
          d = c[46596] | 0
          e = 4
        }
        if ((e | 0) == 4) {
          g = d
          while (1) {
            e = a[b >> 0] | 0
            if (!(e << 24 >> 24)) {
              break
            }
            f = e & 255
            if (P$(f) | 0) {
              e = (O$(f) | 0) & 255
            }
            a[g >> 0] = e
            g = g + 1 | 0
            b = b + 1 | 0
          }
          a[g >> 0] = 0
        }
        return d | 0
      }

      function iQ(b, e, f) {
        b = b | 0
        e = e | 0
        f = f | 0
        var g = 0.0, i = 0, j = 0.0, k = 0.0, m = 0, n = 0, o = 0, p = 0, q = 0, r = 0, s = 0, t = 0, u = 0, v = 0,
            w = 0, x = 0, y = 0, z = 0, A = 0, B = 0, C = 0, D = 0, E = 0, F = 0, G = 0.0
        F = l
        l = l + 144 | 0
        s = F + 96 | 0
        p = F + 80 | 0
        v = F + 124 | 0
        t = F + 72 | 0
        w = F + 64 | 0
        x = F + 56 | 0
        C = F + 48 | 0
        D = F + 40 | 0
        E = F + 32 | 0
        y = F + 24 | 0
        z = F + 16 | 0
        A = F + 8 | 0
        B = F
        i = F + 120 | 0
        m = F + 116 | 0
        n = F + 112 | 0
        o = F + 108 | 0
        c[e + 32 >> 2] = f
        r = b
        while (1) {
          if ((a[r >> 0] | 0) == 32) {
            r = r + 1 | 0
          } else {
            break
          }
        }
        c[o >> 2] = 255
        b = a[r >> 0] | 0
        a:do {
          if (b << 24 >> 24 == 35) {
            c[p >> 2] = i
            c[p + 4 >> 2] = m
            c[p + 8 >> 2] = n
            c[p + 12 >> 2] = o
            if ((M1(r, 108673, p) | 0) <= 2) {
              b = a[r >> 0] | 0
              q = 12
              break
            }
            switch (f | 0) {
              case 0: {
                G = +((c[i >> 2] | 0) >>> 0) * .00392156862745098
                h[C >> 3] = G
                g = +((c[m >> 2] | 0) >>> 0) * .00392156862745098
                h[D >> 3] = g
                j = +((c[n >> 2] | 0) >>> 0) * .00392156862745098
                h[E >> 3] = j
                k = +((c[o >> 2] | 0) >>> 0) * .00392156862745098
                jQ(G, g, j, t, w, x)
                h[e >> 3] = +h[t >> 3]
                h[e + 8 >> 3] = +h[w >> 3]
                h[e + 16 >> 3] = +h[x >> 3]
                h[e + 24 >> 3] = k
                b = 0
                break a
              }
              case 1: {
                a[e >> 0] = c[i >> 2]
                a[e + 1 >> 0] = c[m >> 2]
                a[e + 2 >> 0] = c[n >> 2]
                a[e + 3 >> 0] = c[o >> 2]
                b = 0
                break a
              }
              case 3: {
                j = +((c[i >> 2] | 0) >>> 0) * .00392156862745098
                h[C >> 3] = j
                k = +((c[m >> 2] | 0) >>> 0) * .00392156862745098
                h[D >> 3] = k
                G = +((c[n >> 2] | 0) >>> 0) * .00392156862745098
                h[E >> 3] = G
                kQ(j, k, G, y, z, A, B)
                a[e >> 0] = ~~+h[y >> 3] * 255
                a[e + 1 >> 0] = ~~+h[z >> 3] * 255
                a[e + 2 >> 0] = ~~+h[A >> 3] * 255
                a[e + 3 >> 0] = ~~+h[B >> 3] * 255
                b = 0
                break a
              }
              case 2: {
                c[e >> 2] = (((c[i >> 2] | 0) * 65535 | 0) >>> 0) / 255 | 0
                c[e + 4 >> 2] = (((c[m >> 2] | 0) * 65535 | 0) >>> 0) / 255 | 0
                c[e + 8 >> 2] = (((c[n >> 2] | 0) * 65535 | 0) >>> 0) / 255 | 0
                c[e + 12 >> 2] = (((c[o >> 2] | 0) * 65535 | 0) >>> 0) / 255 | 0
                b = 0
                break a
              }
              case 4: {
                h[e >> 3] = +((c[i >> 2] | 0) >>> 0) * .00392156862745098
                h[e + 8 >> 3] = +((c[m >> 2] | 0) >>> 0) * .00392156862745098
                h[e + 16 >> 3] = +((c[n >> 2] | 0) >>> 0) * .00392156862745098
                h[e + 24 >> 3] = +((c[o >> 2] | 0) >>> 0) * .00392156862745098
                b = 0
                break a
              }
              default: {
                b = 0
                break a
              }
            }
          } else {
            q = 12
          }
        } while (0)
        b:do {
          if ((q | 0) == 12) {
            if (!(b << 24 >> 24 != 46 ? ((b & 255) + -48 | 0) >>> 0 >= 10 : 0)) {
              b = V_(r) | 0
              if (b >>> 0 >= (c[46597] | 0) >>> 0) {
                b = b + 11 | 0
                c[46597] = b
                b = wH(c[46598] | 0, b) | 0
                c[46598] = b
                if (!b) {
                  b = -1
                  break
                }
              } else {
                b = c[46598] | 0
              }
              m = b
              i = r
              c:while (1) {
                n = i + 1 | 0
                i = a[i >> 0] | 0
                switch (i << 24 >> 24) {
                  case 0:
                    break c
                  case 44: {
                    i = 32
                    break
                  }
                  default: {
                  }
                }
                a[m >> 0] = i
                m = m + 1 | 0
                i = n
              }
              a[m >> 0] = 0
              c[s >> 2] = t
              c[s + 4 >> 2] = w
              c[s + 8 >> 2] = x
              if ((M1(b, 108687, s) | 0) == 3) {
                k = +h[t >> 3]
                k = k < 1.0 ? k : 1.0
                k = k > 0.0 ? k : 0.0
                h[t >> 3] = k
                j = +h[w >> 3]
                j = j < 1.0 ? j : 1.0
                j = j > 0.0 ? j : 0.0
                h[w >> 3] = j
                g = +h[x >> 3]
                g = g < 1.0 ? g : 1.0
                g = g > 0.0 ? g : 0.0
                h[x >> 3] = g
                switch (f | 0) {
                  case 0: {
                    h[e >> 3] = k
                    h[e + 8 >> 3] = j
                    h[e + 16 >> 3] = g
                    h[e + 24 >> 3] = 1.0
                    b = 0
                    break b
                  }
                  case 1: {
                    lQ(k, j, g, C, D, E)
                    a[e >> 0] = ~~(+h[C >> 3] * 255.0)
                    a[e + 1 >> 0] = ~~(+h[D >> 3] * 255.0)
                    a[e + 2 >> 0] = ~~(+h[E >> 3] * 255.0)
                    a[e + 3 >> 0] = -1
                    b = 0
                    break b
                  }
                  case 3: {
                    lQ(k, j, g, C, D, E)
                    kQ(+h[C >> 3], +h[D >> 3], +h[E >> 3], y, z, A, B)
                    a[e >> 0] = ~~+h[y >> 3] * 255
                    a[e + 1 >> 0] = ~~+h[z >> 3] * 255
                    a[e + 2 >> 0] = ~~+h[A >> 3] * 255
                    a[e + 3 >> 0] = ~~+h[B >> 3] * 255
                    b = 0
                    break b
                  }
                  case 2: {
                    lQ(k, j, g, C, D, E)
                    c[e >> 2] = ~~(+h[C >> 3] * 65535.0)
                    c[e + 4 >> 2] = ~~(+h[D >> 3] * 65535.0)
                    c[e + 8 >> 2] = ~~(+h[E >> 3] * 65535.0)
                    c[e + 12 >> 2] = 65535
                    b = 0
                    break b
                  }
                  case 4: {
                    lQ(k, j, g, C, D, E)
                    h[e >> 3] = +h[C >> 3]
                    h[e + 8 >> 3] = +h[D >> 3]
                    h[e + 16 >> 3] = +h[E >> 3]
                    h[e + 24 >> 3] = 1.0
                    b = 0
                    break b
                  }
                  default: {
                    b = 0
                    break b
                  }
                }
              }
            }
            i = mQ(r) | 0
            c[v >> 2] = i
            if (!i) {
              b = -1
            } else {
              b = c[46599] | 0
              if (!(((b | 0) != 0 ? (u = c[b >> 2] | 0, (a[u >> 0] | 0) == (a[i >> 0] | 0)) : 0) ? (a$(u, i) | 0) == 0
                  : 0)) {
                b = d2(v, 25844, 2491, 12, 101) | 0
                c[46599] = b
                if (!b) {
                  switch (f | 0) {
                    case 0: {
                      c[e >> 2] = 0
                      c[e + 4 >> 2] = 0
                      c[e + 8 >> 2] = 0
                      c[e + 12 >> 2] = 0
                      c[e + 16 >> 2] = 0
                      c[e + 20 >> 2] = 0
                      h[e + 24 >> 3] = 1.0
                      b = 1
                      break b
                    }
                    case 1: {
                      a[e + 2 >> 0] = 0
                      a[e + 1 >> 0] = 0
                      a[e >> 0] = 0
                      a[e + 3 >> 0] = -1
                      b = 1
                      break b
                    }
                    case 3: {
                      c[e >> 2] = 0
                      b = 1
                      break b
                    }
                    case 2: {
                      c[e + 8 >> 2] = 0
                      c[e + 4 >> 2] = 0
                      c[e >> 2] = 0
                      c[e + 12 >> 2] = 65535
                      b = 1
                      break b
                    }
                    case 4: {
                      c[e >> 2] = 0
                      c[e + 4 >> 2] = 0
                      c[e + 8 >> 2] = 0
                      c[e + 12 >> 2] = 0
                      c[e + 16 >> 2] = 0
                      c[e + 20 >> 2] = 0
                      h[e + 24 >> 3] = 1.0
                      b = 1
                      break b
                    }
                    default: {
                      b = 1
                      break b
                    }
                  }
                }
              }
              switch (f | 0) {
                case 0: {
                  h[e >> 3] = +(d[b + 4 >> 0] | 0) * .00392156862745098
                  h[e + 8 >> 3] = +(d[b + 5 >> 0] | 0) * .00392156862745098
                  h[e + 16 >> 3] = +(d[b + 6 >> 0] | 0) * .00392156862745098
                  h[e + 24 >> 3] = +(d[b + 10 >> 0] | 0) * .00392156862745098
                  b = 0
                  break b
                }
                case 1: {
                  a[e >> 0] = a[b + 7 >> 0] | 0
                  a[e + 1 >> 0] = a[b + 8 >> 0] | 0
                  a[e + 2 >> 0] = a[b + 9 >> 0] | 0
                  a[e + 3 >> 0] = a[b + 10 >> 0] | 0
                  b = 0
                  break b
                }
                case 3: {
                  j = +(d[b + 7 >> 0] | 0) * .00392156862745098
                  h[C >> 3] = j
                  k = +(d[b + 8 >> 0] | 0) * .00392156862745098
                  h[D >> 3] = k
                  G = +(d[b + 9 >> 0] | 0) * .00392156862745098
                  h[E >> 3] = G
                  kQ(j, k, G, y, z, A, B)
                  a[e >> 0] = ~~+h[y >> 3] * 255
                  a[e + 1 >> 0] = ~~+h[z >> 3] * 255
                  a[e + 2 >> 0] = ~~+h[A >> 3] * 255
                  a[e + 3 >> 0] = ~~+h[B >> 3] * 255
                  b = 0
                  break b
                }
                case 2: {
                  c[e >> 2] = (d[b + 7 >> 0] | 0) * 257
                  c[e + 4 >> 2] = (d[b + 8 >> 0] | 0) * 257
                  c[e + 8 >> 2] = (d[b + 9 >> 0] | 0) * 257
                  c[e + 12 >> 2] = (d[b + 10 >> 0] | 0) * 257
                  b = 0
                  break b
                }
                case 4: {
                  h[e >> 3] = +(d[b + 7 >> 0] | 0) * .00392156862745098
                  h[e + 8 >> 3] = +(d[b + 8 >> 0] | 0) * .00392156862745098
                  h[e + 16 >> 3] = +(d[b + 9 >> 0] | 0) * .00392156862745098
                  h[e + 24 >> 3] = +(d[b + 10 >> 0] | 0) * .00392156862745098
                  b = 0
                  break b
                }
                default: {
                  b = 0
                  break b
                }
              }
            }
          }
        } while (0)
        l = F
        return b | 0
      }

      function jQ(a, b, c, d, e, f) {
        a = +a
        b = +b
        c = +c
        d = d | 0
        e = e | 0
        f = f | 0
        var g = 0.0, i = 0.0, j = 0.0, k = 0.0, l = 0.0, m = 0.0
        i = b < c ? b : c
        m = b > c ? b : c
        m = m < a ? a : m
        i = m - (i > a ? a : i)
        g = i / m
        if (m > 0.0) {
          if (g > 0.0) {
            j = (m - a) / i
            k = (m - b) / i
            l = (m - c) / i
            do {
              if (!(m == a)) {
                if (m == b) {
                  a = j + 2.0 - l
                  break
                }
                if (m == c) {
                  a = k + 4.0 - j
                } else {
                  a = 0.0
                }
              } else {
                a = (b - c) / i
              }
            } while (0)
            a = a * 60.0
            if (a < 0.0) {
              a = a + 360.0
            }
          } else {
            a = 0.0
          }
        } else {
          g = 0.0
          a = 0.0
        }
        h[d >> 3] = a * .002777777777777778
        h[f >> 3] = m
        h[e >> 3] = g
        return
      }

      function kQ(a, b, c, d, e, f, g) {
        a = +a
        b = +b
        c = +c
        d = d | 0
        e = e | 0
        f = f | 0
        g = g | 0
        h[d >> 3] = 1.0 - a
        h[e >> 3] = 1.0 - b
        h[f >> 3] = 1.0 - c
        b = +h[d >> 3]
        c = +h[e >> 3]
        c = b < c ? b : c
        h[g >> 3] = c
        b = +h[f >> 3]
        c = b < c ? b : c
        h[g >> 3] = c
        h[d >> 3] = +h[d >> 3] - c
        h[e >> 3] = +h[e >> 3] - +h[g >> 3]
        h[f >> 3] = +h[f >> 3] - +h[g >> 3]
        return
      }

      function lQ(a, b, c, d, e, f) {
        a = +a
        b = +b
        c = +c
        d = d | 0
        e = e | 0
        f = f | 0
        var g = 0.0, i = 0.0, j = 0.0, k = 0, l = 0
        a:do {
          if (!(b <= 0.0)) {
            i = !(a >= 1.0) ? a * 6.0 : 0.0
            l = ~~i
            i = i - +(l | 0)
            a = (1.0 - b) * c
            j = (1.0 - i * b) * c
            b = (1.0 - (1.0 - i) * b) * c
            switch (l | 0) {
              case 0: {
                g = a
                i = b
                a = c
                k = 8
                break a
              }
              case 1: {
                g = a
                i = c
                a = j
                k = 8
                break a
              }
              case 2: {
                g = b
                i = c
                k = 8
                break a
              }
              case 3: {
                g = c
                i = j
                k = 8
                break a
              }
              case 4: {
                g = c
                i = a
                a = b
                k = 8
                break a
              }
              case 5: {
                g = j
                i = a
                a = c
                k = 8
                break a
              }
              default:
                break a
            }
          } else {
            g = c
            i = c
            a = c
            k = 8
          }
        } while (0)
        if ((k | 0) == 8) {
          h[d >> 3] = a
          h[e >> 3] = i
          h[f >> 3] = g
        }
        return
      }

      function mQ(b) {
        b = b | 0
        var d = 0, e = 0
        d = a[b >> 0] | 0
        if (((d << 24 >> 24 != 98 ? (e = b + 1 | 0, !(d << 24 >> 24 == 119 | (y$(e, 134184, 4) | 0) == 0)) : 0) ? !(d
            << 24 >> 24 == 108 | (y$(e, 134189, 4) | 0) == 0) : 0) ? (y$(e, 134194, 8) | 0) != 0 : 0) {
          do {
            if (d << 24 >> 24 == 47) {
              d = z$(e, 47) | 0
              if (!d) {
                b = e
              } else {
                if ((a[e >> 0] | 0) != 47) {
                  e = (U$(134203, e, 4) | 0) == 0
                  b = e ? d + 1 | 0 : b
                  break
                }
                d = c[46600] | 0
                if ((d | 0 ? a[d >> 0] | 0 : 0) ? U$(134203, d, 3) | 0 : 0) {
                  b = oQ(d, b + 2 | 0) | 0
                  break
                }
                b = b + 2 | 0
              }
            } else {
              d = c[46600] | 0
              if (((d | 0) != 0 ? (a[d >> 0] | 0) != 0 : 0) ? (U$(134203, d, 3) | 0) != 0 : 0) {
                b = oQ(d, b) | 0
              }
            }
          } while (0)
          b = hQ(b) | 0
        }
        return b | 0
      }

      function nQ(a, b) {
        a = a | 0
        b = b | 0
        return N$(c[a >> 2] | 0, c[b >> 2] | 0) | 0
      }

      function oQ(a, b) {
        a = a | 0
        b = b | 0
        var d = 0, e = 0, f = 0, g = 0
        f = l
        l = l + 16 | 0
        e = f
        g = V_(a) | 0
        g = (V_(b) | 0) + g | 0
        d = g + 13 | 0
        if ((g + 3 | 0) >>> 0 < (c[46601] | 0) >>> 0) {
          d = c[46602] | 0
        } else {
          c[46601] = d
          d = wH(c[46602] | 0, d) | 0
          c[46602] = d
        }
        c[e >> 2] = a
        c[e + 4 >> 2] = b
        X0(d, 134208, e) | 0
        l = f
        return c[46602] | 0
      }

      function pQ(a) {
        a = a | 0
        c[46600] = a
        return
      }

      function qQ(a, b, c, d, e) {
        a = a | 0
        b = +b
        c = +c
        d = +d
        e = +e
        var f = 0, g = 0
        f = l
        l = l + 208 | 0
        g = f
        rQ(g, +h[a >> 3], +h[a + 8 >> 3], b, c, d, e)
        a = sQ(g) | 0
        l = f
        return a | 0
      }

      function rQ(a, b, c, d, e, f, g) {
        a = a | 0
        b = +b
        c = +c
        d = +d
        e = +e
        f = +f
        g = +g
        var i = 0, j = 0
        h[a >> 3] = b
        h[a + 8 >> 3] = c
        j = a + 16 | 0
        h[j >> 3] = d
        i = a + 24 | 0
        h[i >> 3] = e
        h[a + 32 >> 3] = 0.0
        c = +K(+(+F(+f) / e), +(+E(+f) / d))
        h[a + 56 >> 3] = c
        e = +K(+(+F(+g) / e), +(+E(+g) / d))
        h[a + 40 >> 3] = 1.0
        h[a + 48 >> 3] = 0.0
        e = e - +A(+((e - c) * .15915494309189535)) * 6.283185307179586
        h[a + 64 >> 3] = g - f > 3.141592653589793 & e - c < 3.141592653589793 ? e + 6.283185307179586 : e
        yQ(a)
        zQ(a)
        AQ(a)
        g = +h[j >> 3]
        g = (g - +h[i >> 3]) / g
        h[a + 168 >> 3] = g
        h[a + 176 >> 3] = (2.0 - g) * g
        g = 1.0 - g
        h[a + 184 >> 3] = g
        h[a + 192 >> 3] = g * g
        return
      }

      function sQ(a) {
        a = a | 0
        var b = 0, c = 0.0, d = 0, e = 0.0, f = 0.0, g = 0.0, i = 0.0, j = 0, k = 0, l = 0, m = 0, n = 0.0, o = 0.0,
            p = 0, q = 0, r = 0.0, s = 0.0, t = 0.0, u = 0.0, v = 0.0, w = 0.0, x = 0.0, y = 0.0, z = 0.0
        q = tH(8) | 0
        f = +h[a + 56 >> 3]
        e = +h[a + 64 >> 3] - f
        p = 1
        b = 0
        while (1) {
          o = e / +(p | 0)
          if (!(b << 24 >> 24 == 0 & (p | 0) < 1024)) {
            break
          }
          a:do {
            if (!(o <= 1.5707963267948966)) {
              b = 0
            } else {
              c = f
              d = 0
              b = 1
              while (1) {
                if (!(b << 24 >> 24 != 0 & (d | 0) < (p | 0))) {
                  break a
                }
                n = c + o
                b = +tQ(a, c, n) <= 1.0e-05 & 1
                c = n
                d = d + 1 | 0
              }
            }
          } while (0)
          p = p << 1
        }
        i = +E(+f)
        u = +F(+f)
        d = a + 16 | 0
        s = +h[d >> 3]
        v = s * i
        j = a + 24 | 0
        c = +h[j >> 3]
        g = c * u
        i = c * i
        c = +h[a >> 3]
        k = a + 40 | 0
        t = +h[k >> 3]
        l = a + 48 | 0
        r = +h[l >> 3]
        e = t * v + c - r * g
        m = a + 8 | 0
        n = +h[m >> 3]
        g = r * v + t * g + n
        s = -(u * s)
        uQ(q, c, n)
        vQ(q, e, g)
        n = +G(+(o * .5))
        n = +F(+o) * .3333333333333333 * (+C(+(n * n * 3.0 + 4.0)) + -1.0)
        c = f
        f = g
        g = r * s + t * i
        i = t * s - r * i
        b = 0
        while (1) {
          if ((b | 0) >= (p | 0)) {
            break
          }
          r = c + o
          u = +E(+r)
          v = +F(+r)
          x = +h[d >> 3]
          z = x * u
          w = +h[j >> 3]
          t = w * v
          u = w * u
          w = +h[k >> 3]
          y = +h[l >> 3]
          s = w * z + +h[a >> 3] - y * t
          t = y * z + w * t + +h[m >> 3]
          x = -(v * x)
          v = w * x - y * u
          u = y * x + w * u
          wQ(q, e + i * n, f + g * n, s - v * n, t - u * n, s, t)
          c = r
          e = s
          f = t
          g = u
          i = v
          b = b + 1 | 0
        }
        xQ(q)
        return q | 0
      }

      function tQ(a, b, c) {
        a = a | 0
        b = +b
        c = +c
        var d = 0.0, e = 0.0, f = 0.0, g = 0.0, i = 0.0
        d = c + b
        i = +h[a + 16 >> 3]
        e = +h[a + 24 >> 3] / i
        g = +E(+d)
        f = +E(+(d * 2.0))
        d = +E(+(d * 3.0))
        a = e < .25 ? 10392 : 10648
        return +(((e * .001 + 4.98) * e + .207) / (e + .0067) * i * +L(
            +(((+h[a + 32 >> 3] * e + +h[a + 40 >> 3]) * e + +h[a + 48 >> 3]) / (+h[a + 56 >> 3] + e) * g + ((+h[a >> 3]
                * e + +h[a + 8 >> 3]) * e + +h[a + 16 >> 3]) / (+h[a + 24 >> 3] + e) + ((+h[a + 64 >> 3] * e + +h[a + 72
            >> 3]) * e + +h[a + 80 >> 3]) / (+h[a + 88 >> 3] + e) * f + ((+h[a + 96 >> 3] * e + +h[a + 104 >> 3]) * e
                + +h[a + 112 >> 3]) / (+h[a + 120 >> 3] + e) * d + (((+h[a + 160 >> 3] * e + +h[a + 168 >> 3]) * e
                + +h[a + 176 >> 3]) / (+h[a + 184 >> 3] + e) * g + ((+h[a + 128 >> 3] * e + +h[a + 136 >> 3]) * e + +h[a
                + 144 >> 3]) / (+h[a + 152 >> 3] + e) + ((+h[a + 192 >> 3] * e + +h[a + 200 >> 3]) * e + +h[a + 208 >> 3])
                / (+h[a + 216 >> 3] + e) * f + ((+h[a + 224 >> 3] * e + +h[a + 232 >> 3]) * e + +h[a + 240 >> 3])
                / (+h[a + 248 >> 3] + e) * d) * (c - b))))
      }

      function uQ(a, b, d) {
        a = a | 0
        b = +b
        d = +d
        var e = 0
        c[46603] = 100
        e = tH(1600) | 0
        c[a >> 2] = e
        h[e >> 3] = b
        h[e + 8 >> 3] = d
        c[a + 4 >> 2] = 1
        return
      }

      function vQ(a, b, d) {
        a = a | 0
        b = +b
        d = +d
        var e = 0, f = 0
        f = c[a >> 2] | 0
        e = (c[a + 4 >> 2] | 0) + -1 | 0
        wQ(a, +h[f + (e << 4) >> 3], +h[f + (e << 4) + 8 >> 3], b, d, b, d)
        return
      }

      function wQ(a, b, d, e, f, g, i) {
        a = a | 0
        b = +b
        d = +d
        e = +e
        f = +f
        g = +g
        i = +i
        var j = 0, k = 0, l = 0, m = 0
        l = a + 4 | 0
        j = c[l >> 2] | 0
        k = c[46603] | 0
        if ((j + 3 | 0) < (k | 0)) {
          a = c[a >> 2] | 0
        } else {
          c[46603] = k << 1
          j = E_(c[a >> 2] | 0, k << 5) | 0
          c[a >> 2] = j
          a = j
          j = c[l >> 2] | 0
        }
        h[a + (j << 4) >> 3] = b
        m = j + 1 | 0
        h[a + (j << 4) + 8 >> 3] = d
        h[a + (m << 4) >> 3] = e
        k = j + 2 | 0
        h[a + (m << 4) + 8 >> 3] = f
        h[a + (k << 4) >> 3] = g
        c[l >> 2] = j + 3
        h[a + (k << 4) + 8 >> 3] = i
        return
      }

      function xQ(a) {
        a = a | 0
        var b = 0
        b = c[a >> 2] | 0
        vQ(a, +h[b >> 3], +h[b + 8 >> 3])
        c[a >> 2] = E_(c[a >> 2] | 0, c[a + 4 >> 2] << 4) | 0
        c[46603] = 0
        return
      }

      function yQ(a) {
        a = a | 0
        var b = 0.0, c = 0.0, d = 0.0, e = 0.0
        d = +h[a + 16 >> 3]
        b = +h[a + 24 >> 3]
        b = +C(+(d * d - b * b))
        d = b * +h[a + 40 >> 3]
        b = b * +h[a + 48 >> 3]
        e = +h[a >> 3]
        h[a + 104 >> 3] = e - d
        c = +h[a + 8 >> 3]
        h[a + 112 >> 3] = c - b
        h[a + 120 >> 3] = e + d
        h[a + 128 >> 3] = c + b
        return
      }

      function zQ(a) {
        a = a | 0
        var b = 0.0, c = 0.0, d = 0.0, e = 0.0, f = 0.0, g = 0.0, i = 0.0, j = 0.0
        d = +h[a + 16 >> 3]
        i = +h[a + 56 >> 3]
        j = +E(+i) * d
        b = +h[a + 24 >> 3]
        i = +F(+i) * b
        g = +h[a + 64 >> 3]
        d = +E(+g) * d
        b = +F(+g) * b
        g = +h[a >> 3]
        c = +h[a + 40 >> 3]
        e = +h[a + 48 >> 3]
        h[a + 72 >> 3] = c * j + g - e * i
        f = +h[a + 8 >> 3]
        h[a + 80 >> 3] = e * j + f + c * i
        h[a + 88 >> 3] = g + c * d - e * b
        h[a + 96 >> 3] = f + e * d + c * b
        return
      }

      function AQ(a) {
        a = a | 0
        var b = 0.0, c = 0.0, d = 0.0, e = 0.0, f = 0.0, g = 0.0, i = 0.0, j = 0.0, k = 0.0, l = 0.0, m = 0.0, n = 0
        k = +h[a + 24 >> 3]
        l = +h[a + 16 >> 3]
        e = k / l
        m = +h[a + 48 >> 3]
        n = +B(+m) < .1
        j = +h[a + 40 >> 3]
        do {
          if (n) {
            b = m / j
            c = +J(+(b * e))
            d = -c
            if (j < 0.0) {
              b = +J(+(b / e))
              e = d
              d = 3.141592653589793 - c
              c = 4.71238898038469 - b
              b = 1.5707963267948966 - b
              break
            } else {
              b = +J(+(b / e))
              e = -3.141592653589793 - c
              c = 1.5707963267948966 - b
              b = -1.5707963267948966 - b
              break
            }
          } else {
            b = j / m
            c = +J(+(b / e))
            d = c + 1.5707963267948966
            if (m < 0.0) {
              b = +J(+(b * e))
              e = c + -1.5707963267948966
              c = b + 3.141592653589793
              break
            } else {
              b = +J(+(b * e))
              e = d
              d = c + 4.71238898038469
              c = b
              b = b + -3.141592653589793
              break
            }
          }
        } while (0)
        g = +h[a + 56 >> 3]
        e = e - +A(+((e - g) * .15915494309189535)) * 6.283185307179586
        b = b - +A(+((b - g) * .15915494309189535)) * 6.283185307179586
        f = d - +A(+((d - g) * .15915494309189535)) * 6.283185307179586
        g = c - +A(+((c - g) * .15915494309189535)) * 6.283185307179586
        i = +h[a + 64 >> 3]
        if (!(e <= i)) {
          e = +h[a + 72 >> 3]
          c = +h[a + 88 >> 3]
          c = e < c ? e : c
        } else {
          c = +E(+e) * l * j + +h[a >> 3] - k * +F(+e) * m
        }
        h[a + 136 >> 3] = c
        if (!(b <= i)) {
          e = +h[a + 80 >> 3]
          d = +h[a + 96 >> 3]
          d = e < d ? e : d
        } else {
          d = +E(+b) * l * m + +h[a + 8 >> 3] + +F(+b) * k * j
        }
        h[a + 144 >> 3] = d
        if (!(f <= i)) {
          f = +h[a + 72 >> 3]
          b = +h[a + 88 >> 3]
          b = f > b ? f : b
        } else {
          b = +E(+f) * l * j + +h[a >> 3] - k * +F(+f) * m
        }
        h[a + 152 >> 3] = b - c
        if (!(g <= i)) {
          m = +h[a + 80 >> 3]
          b = +h[a + 96 >> 3]
          b = m > b ? m : b
        } else {
          b = +E(+g) * l * m + +h[a + 8 >> 3] + +F(+g) * k * j
        }
        h[a + 160 >> 3] = b - d
        return
      }

      function BQ(b, d, e) {
        b = b | 0
        d = d | 0
        e = e | 0
        var f = 0, g = 0.0, i = 0, j = 0, k = 0.0, m = 0, n = 0
        n = l
        l = l + 80 | 0
        m = n
        CQ(b)
        k = +h[e + 56 >> 3]
        g = +h[e + 64 >> 3]
        switch (a[e + 80 >> 0] | 0) {
          case 116: {
            g = (+h[e + 48 >> 3] - +DQ(d)) * .5 + g
            f = 4
            break
          }
          case 98: {
            g = g - (+h[e + 48 >> 3] - +DQ(d)) * .5
            f = 4
            break
          }
          default: {
          }
        }
        if ((f | 0) == 4) {
          g = g + -1.0
        }
        h[m >> 3] = k
        h[m + 8 >> 3] = g
        c[m + 20 >> 2] = c[e + 8 >> 2]
        c[m + 16 >> 2] = c[e + 4 >> 2]
        h[m + 32 >> 3] = +h[e + 16 >> 3]
        j = b + 16 | 0
        f = wx(c[(c[j >> 2] | 0) + 8 >> 2] | 0, 134215) | 0
        e = m + 56 | 0
        c[e >> 2] = f
        i = m + 60 | 0
        c[i >> 2] = c[(c[j >> 2] | 0) + 212 >> 2]
        j = m + 64 | 0
        a[j >> 0] = 0
        if (!((f | 0) != 0 ? (a[f >> 0] | 0) != 0 : 0)) {
          c[e >> 2] = 134226
        }
        if ((a[d + 4 >> 0] | 0) == 1) {
          e = c[d >> 2] | 0
          XO(b, c[(c[b >> 2] | 0) + 336 >> 2] | 0)
          f = c[e + 24 >> 2] | 0
          if (!f) {
            TO(b, 134232)
          } else {
            TO(b, f)
          }
          FQ(b, e, m)
          if (a[j >> 0] | 0) {
            C_(c[i >> 2] | 0)
          }
        } else {
          EQ(b, c[d >> 2] | 0, m)
        }
        GQ(b)
        l = n
        return
      }

      function CQ(a) {
        a = a | 0
        var d = 0, e = 0, f = 0
        d = ME(a) | 0
        e = c[d >> 2] | 0
        a = c[e + 4 >> 2] | 0
        c[d + 4 >> 2] = a
        c[d + 12 >> 2] = c[e + 12 >> 2]
        switch (a | 0) {
          case 2: {
            a = e + 8 | 0
            f = 6
            break
          }
          case 0: {
            a = e + 8 | 0
            f = 6
            break
          }
          case 1: {
            a = e + 8 | 0
            f = 6
            break
          }
          case 3: {
            a = e + 8 | 0
            f = 6
            break
          }
          default: {
          }
        }
        if ((f | 0) == 6) {
          c[d + 8 >> 2] = c[a >> 2]
        }
        c[d + 208 >> 2] = c[e + 208 >> 2]
        c[d + 228 >> 2] = c[e + 228 >> 2]
        c[d + 244 >> 2] = c[e + 244 >> 2]
        f = d + 260 | 0
        b[f >> 1] = b[f >> 1] & -2 | b[e + 260 >> 1] & 1
        return
      }

      function DQ(b) {
        b = b | 0
        var d = 0.0, e = 0, f = 0
        switch (a[b + 4 >> 0] | 0) {
          case 1: {
            e = c[b >> 2] | 0
            b = e + 72 | 0
            e = e + 56 | 0
            f = 5
            break
          }
          case 3: {
            e = c[b >> 2] | 0
            b = e + 24 | 0
            e = e + 8 | 0
            f = 5
            break
          }
          case 2: {
            e = c[b >> 2] | 0
            b = e + 32 | 0
            e = e + 16 | 0
            f = 5
            break
          }
          default:
            d = 0.0
        }
        if ((f | 0) == 5) {
          d = +h[b >> 3] - +h[e >> 3]
        }
        return +d
      }

      function EQ(d, e, f) {
        d = d | 0
        e = e | 0
        f = f | 0
        var g = 0, i = 0, j = 0, k = 0, m = 0, n = 0, o = 0.0, p = 0.0, q = 0, r = 0, s = 0
        n = l
        l = l + 96 | 0
        j = n + 64 | 0
        i = n + 32 | 0
        g = n + 16 | 0
        k = n
        m = b[e + 4 >> 1] | 0
        if (m << 16 >> 16 >= 1) {
          r = e + 8 | 0
          p = +h[e + 24 >> 3]
          o = +h[r >> 3]
          h[k >> 3] = (o + p) * .5 + +h[f >> 3]
          h[k + 8 >> 3] = (+h[e + 16 >> 3] + +h[e + 32 >> 3]) * .5 + +h[f + 8 >> 3]
          q = c[e >> 2] | 0
          s = f + 16 | 0
          f = a[e + 6 >> 0] | 0
          c[g >> 2] = c[k >> 2]
          c[g + 4 >> 2] = c[k + 4 >> 2]
          c[g + 8 >> 2] = c[k + 8 >> 2]
          c[g + 12 >> 2] = c[k + 12 >> 2]
          c[i >> 2] = c[s >> 2]
          c[i + 4 >> 2] = c[s + 4 >> 2]
          c[i + 8 >> 2] = c[s + 8 >> 2]
          c[i + 12 >> 2] = c[s + 12 >> 2]
          c[i + 16 >> 2] = c[s + 16 >> 2]
          c[i + 20 >> 2] = c[s + 20 >> 2]
          c[i + 24 >> 2] = c[s + 24 >> 2]
          c[i + 28 >> 2] = c[s + 28 >> 2]
          c[j >> 2] = c[r >> 2]
          c[j + 4 >> 2] = c[r + 4 >> 2]
          c[j + 8 >> 2] = c[r + 8 >> 2]
          c[j + 12 >> 2] = c[r + 12 >> 2]
          c[j + 16 >> 2] = c[r + 16 >> 2]
          c[j + 20 >> 2] = c[r + 20 >> 2]
          c[j + 24 >> 2] = c[r + 24 >> 2]
          c[j + 28 >> 2] = c[r + 28 >> 2]
          SQ(d, m << 16 >> 16, q, g, (p - o) * .5, i, j, f)
        }
        l = n
        return
      }

      function FQ(e, f, g) {
        e = e | 0
        f = f | 0
        g = g | 0
        var i = 0, j = 0, k = 0, m = 0.0, n = 0.0, o = 0, p = 0, q = 0, r = 0, s = 0, t = 0, u = 0, v = 0, w = 0, x = 0,
            y = 0
        y = l
        l = l + 176 | 0
        t = y + 96 | 0
        v = y + 64 | 0
        w = y + 136 | 0
        p = y
        q = y + 128 | 0
        r = f + 48 | 0
        c[v >> 2] = c[r >> 2]
        c[v + 4 >> 2] = c[r + 4 >> 2]
        c[v + 8 >> 2] = c[r + 8 >> 2]
        c[v + 12 >> 2] = c[r + 12 >> 2]
        c[v + 16 >> 2] = c[r + 16 >> 2]
        c[v + 20 >> 2] = c[r + 20 >> 2]
        c[v + 24 >> 2] = c[r + 24 >> 2]
        c[v + 28 >> 2] = c[r + 28 >> 2]
        m = +h[g >> 3]
        n = +h[g + 8 >> 3]
        r = f + 84 | 0
        i = c[r >> 2] | 0
        if (!(c[f >> 2] | 0)) {
          x = (c[f + 8 >> 2] | 0) != 0
        } else {
          x = 1
        }
        u = f + 108 | 0
        j = c[u >> 2] | 0
        if (j | 0) {
          HQ(g, j, 183464)
        }
        h[v >> 3] = +h[v >> 3] + m
        s = v + 16 | 0
        h[s >> 3] = +h[s >> 3] + m
        s = v + 8 | 0
        h[s >> 3] = +h[s >> 3] + n
        s = v + 24 | 0
        h[s >> 3] = +h[s >> 3] + n
        if (x ? (c[e + 152 >> 2] & 4 | 0) == 0 : 0) {
          c[t >> 2] = c[v >> 2]
          c[t + 4 >> 2] = c[v + 4 >> 2]
          c[t + 8 >> 2] = c[v + 8 >> 2]
          c[t + 12 >> 2] = c[v + 12 >> 2]
          c[t + 16 >> 2] = c[v + 16 >> 2]
          c[t + 20 >> 2] = c[v + 20 >> 2]
          c[t + 24 >> 2] = c[v + 24 >> 2]
          c[t + 28 >> 2] = c[v + 28 >> 2]
          s = IQ(e, g, f, t, w) | 0
        } else {
          s = 0
        }
        o = f + 42 | 0
        j = b[o >> 1] | 0
        if (!(j & 32)) {
          k = c[f + 20 >> 2] | 0
          if (k) {
            j = JQ(e, k, c[f + 28 >> 2] | 0, j & 65535, q) | 0
            if (!(b[o >> 1] & 4)) {
              c[t >> 2] = c[v >> 2]
              c[t + 4 >> 2] = c[v + 4 >> 2]
              c[t + 8 >> 2] = c[v + 8 >> 2]
              c[t + 12 >> 2] = c[v + 12 >> 2]
              c[t + 16 >> 2] = c[v + 16 >> 2]
              c[t + 20 >> 2] = c[v + 20 >> 2]
              c[t + 24 >> 2] = c[v + 24 >> 2]
              c[t + 28 >> 2] = c[v + 28 >> 2]
              _O(e, t, j)
            } else {
              o = d[f + 33 >> 0] | 0
              c[t >> 2] = c[v >> 2]
              c[t + 4 >> 2] = c[v + 4 >> 2]
              c[t + 8 >> 2] = c[v + 8 >> 2]
              c[t + 12 >> 2] = c[v + 12 >> 2]
              c[t + 16 >> 2] = c[v + 16 >> 2]
              c[t + 20 >> 2] = c[v + 20 >> 2]
              c[t + 24 >> 2] = c[v + 24 >> 2]
              c[t + 28 >> 2] = c[v + 28 >> 2]
              DJ(e, KQ(p, t, o) | 0, 4, 4, j)
            }
            C_(c[q >> 2] | 0)
          }
          while (1) {
            j = c[i >> 2] | 0
            if (!j) {
              break
            }
            LQ(e, j, g)
            i = i + 4 | 0
          }
          i = c[r >> 2] | 0
          eP(e, 1.0)
          j = f + 24 | 0
          while (1) {
            k = i + 4 | 0
            i = c[i >> 2] | 0
            if (!i) {
              break
            }
            if (!(a[i + 100 >> 0] | 0)) {
              i = k
              continue
            }
            MQ(e, i, g, c[j >> 2] | 0, c[k >> 2] | 0)
            i = k
          }
          if (a[f + 33 >> 0] | 0) {
            c[t >> 2] = c[v >> 2]
            c[t + 4 >> 2] = c[v + 4 >> 2]
            c[t + 8 >> 2] = c[v + 8 >> 2]
            c[t + 12 >> 2] = c[v + 12 >> 2]
            c[t + 16 >> 2] = c[v + 16 >> 2]
            c[t + 20 >> 2] = c[v + 20 >> 2]
            c[t + 24 >> 2] = c[v + 24 >> 2]
            c[t + 28 >> 2] = c[v + 28 >> 2]
            NQ(e, f, t)
          }
        }
        if (s | 0) {
          OQ(e, w)
        }
        if ((x ? c[e + 152 >> 2] & 4 | 0 : 0) ? (c[t >> 2] = c[v >> 2], c[t + 4 >> 2] = c[v + 4 >> 2], c[t + 8
        >> 2] = c[v + 8 >> 2], c[t + 12 >> 2] = c[v + 12 >> 2], c[t + 16 >> 2] = c[v + 16 >> 2], c[t + 20 >> 2] = c[v
        + 20 >> 2], c[t + 24 >> 2] = c[v + 24 >> 2], c[t + 28 >> 2] = c[v + 28 >> 2], IQ(e, g, f, t, w) | 0) : 0) {
          OQ(e,
              w)
        }
        if (c[u >> 2] | 0) {
          PQ(g, 183464)
        }
        l = y
        return
      }

      function GQ(a) {
        a = a | 0
        var b = 0
        b = c[a + 16 >> 2] | 0
        c[b + 208 >> 2] = 0
        c[b + 228 >> 2] = 0
        c[b + 244 >> 2] = 0
        c[b + 212 >> 2] = 0
        NE(a)
        return
      }

      function HQ(a, b, d) {
        a = a | 0
        b = b | 0
        d = d | 0
        var e = 0.0, f = 0, g = 0, i = 0
        i = a + 16 | 0
        f = c[i >> 2] | 0
        if (f | 0) {
          if (!(c[b >> 2] | 0)) {
            f = 0
            g = d
          } else {
            c[d >> 2] = f
            f = c[b >> 2] | 0
            g = i
          }
          c[g >> 2] = f
        }
        f = c[a + 20 >> 2] | 0
        if (f | 0) {
          g = b + 4 | 0
          if (!(c[g >> 2] | 0)) {
            f = 0
            g = d
          } else {
            c[d + 4 >> 2] = f
            f = c[g >> 2] | 0
            g = i
          }
          c[g + 4 >> 2] = f
        }
        e = +h[a + 32 >> 3]
        if (e >= 0.0) {
          f = b + 16 | 0
          if (!(+h[f >> 3] >= 0.0)) {
            e = -1.0
          } else {
            h[d + 16 >> 3] = e
            e = +h[f >> 3]
            d = i
          }
          h[d + 16 >> 3] = e
        }
        return
      }

      function IQ(d, e, f, g, h) {
        d = d | 0
        e = e | 0
        f = f | 0
        g = g | 0
        h = h | 0
        var i = 0, j = 0, k = 0, m = 0, n = 0, o = 0, p = 0, q = 0, r = 0, s = 0, t = 0, u = 0
        u = l
        l = l + 224 | 0
        n = u + 8 | 0
        k = u
        t = u + 40 | 0
        j = u + 184 | 0
        i = u + 56 | 0
        m = c[d + 16 >> 2] | 0
        o = m + 208 | 0
        c[h >> 2] = c[o >> 2]
        p = m + 228 | 0
        c[h + 4 >> 2] = c[p >> 2]
        q = m + 244 | 0
        c[h + 8 >> 2] = c[q >> 2]
        r = m + 212 | 0
        c[h + 12 >> 2] = c[r >> 2]
        s = m + 260 | 0
        a[h + 16 >> 0] = (b[s >> 1] << 15 & 65535) << 16 >> 16 >> 15
        h = c[f + 16 >> 2] | 0
        if ((h | 0) != 0 ? (a[h >> 0] | 0) != 0 : 0) {
          i = 0
        } else {
          Sw(t, 128, i)
          i = e + 60 | 0
          h = c[i >> 2] | 0
          if (!h) {
            h = m1(PE(d, c[m + 8 >> 2] | 0, t) | 0) | 0
            c[i >> 2] = h
            a[e + 64 >> 0] = 1
          }
          Vw(t, h) | 0
          i = c[46604] | 0
          c[46604] = i + 1
          c[k >> 2] = i
          X0(j, 134309, k) | 0
          Vw(t, j) | 0
          i = t + 4 | 0
          h = c[i >> 2] | 0
          if (h >>> 0 >= (c[t + 8 >> 2] | 0) >>> 0) {
            Tw(t, 1) | 0
            h = c[i >> 2] | 0
          }
          a[h >> 0] = 0
          h = c[t >> 2] | 0
          c[i >> 2] = h
          i = 1
        }
        h = OE(d, 0, c[f >> 2] | 0, c[f + 12 >> 2] | 0, c[f + 8 >> 2] | 0, h, c[m + 8 >> 2] | 0) | 0
        if (i) {
          Ww(t)
        }
        do {
          if (h | 0) {
            if ((c[o >> 2] | 0) == 0 ? (b[s >> 1] & 1) == 0 : 0) {
              break
            }
            c[n >> 2] = c[g >> 2]
            c[n + 4 >> 2] = c[g + 4 >> 2]
            c[n + 8 >> 2] = c[g + 8 >> 2]
            c[n + 12 >> 2] = c[g + 12 >> 2]
            c[n + 16 >> 2] = c[g + 16 >> 2]
            c[n + 20 >> 2] = c[g + 20 >> 2]
            c[n + 24 >> 2] = c[g + 24 >> 2]
            c[n + 28 >> 2] = c[g + 28 >> 2]
            WE(d, n)
            OO(d, c[o >> 2] | 0, c[p >> 2] | 0, c[q >> 2] | 0, c[r >> 2] | 0)
          }
        } while (0)
        l = u
        return h | 0
      }

      function JQ(a, b, d, e, f) {
        a = a | 0
        b = b | 0
        d = d | 0
        e = e | 0
        f = f | 0
        var h = 0.0, i = 0, j = 0
        j = l
        l = l + 16 | 0
        i = j
        if (!((tG(b, f, i) | 0) << 24 >> 24)) {
          VO(a, b)
          b = 1
        } else {
          VO(a, c[f >> 2] | 0)
          b = c[f + 4 >> 2] | 0
          h = +g[i >> 2]
          if (!b) {
            WO(a, 134232, d, h)
          } else {
            WO(a, b, d, h)
          }
          b = e >>> 1 & 1 | 2
        }
        TO(a, 134297)
        l = j
        return b | 0
      }

      function KQ(a, b, d) {
        a = a | 0
        b = b | 0
        d = d | 0
        var e = 0, f = 0.0, g = 0.0, i = 0.0, j = 0.0
        c[a >> 2] = c[b >> 2]
        c[a + 4 >> 2] = c[b + 4 >> 2]
        c[a + 8 >> 2] = c[b + 8 >> 2]
        c[a + 12 >> 2] = c[b + 12 >> 2]
        e = a + 32 | 0
        b = b + 16 | 0
        c[e >> 2] = c[b >> 2]
        c[e + 4 >> 2] = c[b + 4 >> 2]
        c[e + 8 >> 2] = c[b + 8 >> 2]
        c[e + 12 >> 2] = c[b + 12 >> 2]
        if ((d | 0) > 1) {
          j = +(d | 0) * .5
          i = +h[a >> 3] + j
          h[a >> 3] = i
          d = a + 8 | 0
          g = +h[d >> 3] + j
          h[d >> 3] = g
          f = +h[e >> 3] - j
          h[e >> 3] = f
          e = a + 40 | 0
          j = +h[e >> 3] - j
          h[e >> 3] = j
        } else {
          f = +h[e >> 3]
          g = +h[a + 8 >> 3]
          i = +h[a >> 3]
          j = +h[a + 40 >> 3]
        }
        h[a + 16 >> 3] = f
        h[a + 24 >> 3] = g
        h[a + 48 >> 3] = i
        h[a + 56 >> 3] = j
        return a | 0
      }

      function LQ(e, f, g) {
        e = e | 0
        f = f | 0
        g = g | 0
        var i = 0, j = 0.0, k = 0.0, m = 0, n = 0, o = 0, p = 0, q = 0, r = 0, s = 0, t = 0, u = 0, v = 0
        v = l
        l = l + 176 | 0
        r = v + 96 | 0
        s = v + 136 | 0
        t = v + 64 | 0
        p = v
        q = v + 128 | 0
        u = f + 48 | 0
        c[t >> 2] = c[u >> 2]
        c[t + 4 >> 2] = c[u + 4 >> 2]
        c[t + 8 >> 2] = c[u + 8 >> 2]
        c[t + 12 >> 2] = c[u + 12 >> 2]
        c[t + 16 >> 2] = c[u + 16 >> 2]
        c[t + 20 >> 2] = c[u + 20 >> 2]
        c[t + 24 >> 2] = c[u + 24 >> 2]
        c[t + 28 >> 2] = c[u + 28 >> 2]
        j = +h[g >> 3]
        k = +h[g + 8 >> 3]
        if (!(c[f >> 2] | 0)) {
          u = (c[f + 8 >> 2] | 0) != 0
        } else {
          u = 1
        }
        h[t >> 3] = +h[t >> 3] + j
        o = t + 16 | 0
        h[o >> 3] = +h[o >> 3] + j
        o = t + 8 | 0
        h[o >> 3] = +h[o >> 3] + k
        o = t + 24 | 0
        h[o >> 3] = +h[o >> 3] + k
        if (u ? (c[e + 152 >> 2] & 4 | 0) == 0 : 0) {
          c[r >> 2] = c[t >> 2]
          c[r + 4 >> 2] = c[t + 4 >> 2]
          c[r + 8 >> 2] = c[t + 8 >> 2]
          c[r + 12 >> 2] = c[t + 12 >> 2]
          c[r + 16 >> 2] = c[t + 16 >> 2]
          c[r + 20 >> 2] = c[t + 20 >> 2]
          c[r + 24 >> 2] = c[t + 24 >> 2]
          c[r + 28 >> 2] = c[t + 28 >> 2]
          o = IQ(e, g, f, r, s) | 0
        } else {
          o = 0
        }
        n = f + 42 | 0
        i = b[n >> 1] | 0
        a:do {
          if (!(i & 32)) {
            m = c[f + 20 >> 2] | 0
            if (m | 0) {
              i = JQ(e, m, c[f + 28 >> 2] | 0, i & 65535, q) | 0
              if (!(b[n >> 1] & 4)) {
                c[r >> 2] = c[t >> 2]
                c[r + 4 >> 2] = c[t + 4 >> 2]
                c[r + 8 >> 2] = c[t + 8 >> 2]
                c[r + 12 >> 2] = c[t + 12 >> 2]
                c[r + 16 >> 2] = c[t + 16 >> 2]
                c[r + 20 >> 2] = c[t + 20 >> 2]
                c[r + 24 >> 2] = c[t + 24 >> 2]
                c[r + 28 >> 2] = c[t + 28 >> 2]
                _O(e, r, i)
              } else {
                n = d[f + 33 >> 0] | 0
                c[r >> 2] = c[t >> 2]
                c[r + 4 >> 2] = c[t + 4 >> 2]
                c[r + 8 >> 2] = c[t + 8 >> 2]
                c[r + 12 >> 2] = c[t + 12 >> 2]
                c[r + 16 >> 2] = c[t + 16 >> 2]
                c[r + 20 >> 2] = c[t + 20 >> 2]
                c[r + 24 >> 2] = c[t + 24 >> 2]
                c[r + 28 >> 2] = c[t + 28 >> 2]
                DJ(e, KQ(p, r, n) | 0, 4, 4, i)
              }
              C_(c[q >> 2] | 0)
            }
            if (a[f + 33 >> 0] | 0) {
              c[r >> 2] = c[t >> 2]
              c[r + 4 >> 2] = c[t + 4 >> 2]
              c[r + 8 >> 2] = c[t + 8 >> 2]
              c[r + 12 >> 2] = c[t + 12 >> 2]
              c[r + 16 >> 2] = c[t + 16 >> 2]
              c[r + 20 >> 2] = c[t + 20 >> 2]
              c[r + 24 >> 2] = c[t + 24 >> 2]
              c[r + 28 >> 2] = c[t + 28 >> 2]
              NQ(e, f, r)
            }
            i = f + 88 | 0
            switch (a[f + 92 >> 0] | 0) {
              case 1: {
                FQ(e, c[i >> 2] | 0, g)
                break a
              }
              case 3: {
                RQ(e, c[i >> 2] | 0, g)
                break a
              }
              default: {
                EQ(e, c[i >> 2] | 0, g)
                break a
              }
            }
          }
        } while (0)
        if (o | 0) {
          OQ(e, s)
        }
        if ((u ? c[e + 152 >> 2] & 4 | 0 : 0) ? (c[r >> 2] = c[t >> 2], c[r + 4 >> 2] = c[t + 4 >> 2], c[r + 8
        >> 2] = c[t + 8 >> 2], c[r + 12 >> 2] = c[t + 12 >> 2], c[r + 16 >> 2] = c[t + 16 >> 2], c[r + 20 >> 2] = c[t
        + 20 >> 2], c[r + 24 >> 2] = c[t + 24 >> 2], c[r + 28 >> 2] = c[t + 28 >> 2], IQ(e, g, f, r, s) | 0) : 0) {
          OQ(e,
              s)
        }
        l = v
        return
      }

      function MQ(f, g, i, j, k) {
        f = f | 0
        g = g | 0
        i = i | 0
        j = j | 0
        k = k | 0
        var m = 0.0, n = 0, o = 0.0, p = 0.0, q = 0, r = 0.0, s = 0.0, t = 0.0, u = 0.0, v = 0, w = 0, x = 0.0, y = 0,
            z = 0, A = 0, B = 0, C = 0
        A = l
        l = l + 32 | 0
        y = A + 16 | 0
        z = A
        r = +h[i >> 3]
        x = +h[i + 8 >> 3]
        q = (j | 0) == 0 ? 134232 : j
        VO(f, q)
        TO(f, q)
        t = +h[g + 48 >> 3]
        o = +h[g + 56 >> 3]
        u = +h[g + 64 >> 3]
        p = +h[g + 72 >> 3]
        s = t + r
        r = u + r
        x = o + x
        q = g + 100 | 0
        i = a[q >> 0] | 0
        if ((i & 1) != 0 ? (n = c[g + 96 >> 2] | 0, ((e[g + 80 >> 1] | 0) + (e[g + 84 >> 1] | 0) | 0) < (c[n + 104 >> 2]
            | 0)) : 0) {
          i = b[g + 86 >> 1] | 0
          do {
            if (i << 16 >> 16) {
              if (((e[g + 82 >> 1] | 0) + (i & 65535) | 0) == (c[n + 100 >> 2] | 0)) {
                B = a[n + 32 >> 0] | 0
                C = (B << 24 >> 24) / 2 | 0
                j = (C << 24 >> 24) + (d[n + 33 >> 0] | 0) | 0
                i = j
                j = j & 255
                m = x - +(C << 24 >> 24)
                n = B
                break
              } else {
                n = a[n + 32 >> 0] | 0
                i = 0
                j = ((n << 24 >> 24) / 2 | 0) << 24 >> 24
                m = x
                break
              }
            } else {
              C = a[n + 32 >> 0] | 0
              j = ((C << 24 >> 24) / 2 | 0) << 24 >> 24
              i = j + (d[n + 33 >> 0] | 0) | 0
              m = x
              n = C
            }
          } while (0)
          h[z + 8 >> 3] = m - +(j | 0)
          h[z >> 3] = r + +(((n << 24 >> 24) / 2 | 0) << 24 >> 24)
          c[y >> 2] = c[z >> 2]
          c[y + 4 >> 2] = c[z + 4 >> 2]
          c[y + 8 >> 2] = c[z + 8 >> 2]
          c[y + 12 >> 2] = c[z + 12 >> 2]
          QQ(f, y, 0.0, p - o + +(i & 255 | 0) + +(n << 24 >> 24))
          i = a[q >> 0] | 0
        }
        if (i & 2 ? (v = b[g + 86 >> 1] | 0, w = c[g + 96 >> 2] | 0, ((e[g + 82 >> 1] | 0) + (v & 65535) | 0) < (c[w
        + 100 >> 2] | 0)) : 0) {
          i = b[g + 84 >> 1] | 0
          do {
            if (!(i << 16 >> 16)) {
              i = a[w + 32 >> 0] | 0
              C = (i << 24 >> 24) / 2 | 0
              n = (C << 24 >> 24) + (d[w + 33 >> 0] | 0) | 0
              j = n & 255
              n = n & 255
              m = +(C << 24 >> 24)
              h[z >> 3] = s - m - +(n | 0)
              if ((c[w + 104 >> 2] | 0) == (e[g + 80 >> 1] | 0)) {
                j = n << 1 & 255
                break
              }
              if ((k | 0) != 0 ? (b[k + 86 >> 1] | 0) != v << 16 >> 16 : 0) {
                j = ~~(+(j & 255) - u + +h[w + 64 >> 3] - m)
                    & 255
              }
            } else {
              if (((e[g + 80 >> 1] | 0) + (i & 65535) | 0) == (c[w + 104 >> 2] | 0)) {
                i = a[w + 32 >> 0] | 0
                C = (i << 24 >> 24) / 2 | 0
                j = (C & 255) + (d[w + 33 >> 0] | 0) & 255
                h[z >> 3] = s - +(C << 24 >> 24)
                break
              }
              i = a[w + 32 >> 0] | 0
              m = +(((i << 24 >> 24) / 2 | 0) << 24 >> 24)
              h[z >> 3] = s - m
              if ((k | 0) != 0 ? (b[k + 86 >> 1] | 0) != v << 16 >> 16 : 0) {
                j = ~~(+h[w + 64 >> 3] - u - m)
                    & 255
              } else {
                j = 0
              }
            }
          } while (0)
          h[z + 8 >> 3] = x - +(((i << 24 >> 24) / 2 | 0) << 24 >> 24)
          c[y >> 2] = c[z >> 2]
          c[y + 4 >> 2] = c[z + 4 >> 2]
          c[y + 8 >> 2] = c[z + 8 >> 2]
          c[y + 12 >> 2] = c[z + 12 >> 2]
          QQ(f, y, u - t + +(j & 255) + +(i << 24 >> 24), 0.0)
        }
        l = A
        return
      }

      function NQ(e, f, g) {
        e = e | 0
        f = f | 0
        g = g | 0
        var i = 0, j = 0, k = 0, m = 0, n = 0, o = 0, p = 0, q = 0.0
        p = l
        l = l + 160 | 0
        o = p + 112 | 0
        n = p
        j = p + 144 | 0
        m = c[f + 24 >> 2] | 0
        TO(e, (m | 0) == 0 ? 134232 : m)
        m = f + 42 | 0
        i = b[m >> 1] | 0
        if (!(i & 384)) {
          XO(e, c[(c[e >> 2] | 0) + 336 >> 2] | 0)
        } else {
          c[j + 4 >> 2] = 0
          c[j >> 2] = 0
          i = i & 65535
          if (!(i & 256)) {
            if (i & 128 | 0) {
              i = 134238
              k = 4
            }
          } else {
            i = 134245
            k = 4
          }
          if ((k | 0) == 4) {
            c[j >> 2] = i
          }
          XO(e, j)
        }
        k = f + 33 | 0
        eP(e, +(d[k >> 0] | 0))
        a:do {
          if (!(b[m >> 1] & 4)) {
            i = b[f + 36 >> 1] & 15360
            if (!(i << 16 >> 16)) {
              i = a[k >> 0] | 0
              if ((i & 255) > 1) {
                q = +(i & 255) * .5
                h[g >> 3] = +h[g >> 3] + q
                n = g + 8 | 0
                h[n >> 3] = +h[n >> 3] + q
                n = g + 16 | 0
                h[n >> 3] = +h[n >> 3] - q
                n = g + 24 | 0
                h[n >> 3] = +h[n >> 3] - q
              }
              c[o >> 2] = c[g >> 2]
              c[o + 4 >> 2] = c[g + 4 >> 2]
              c[o + 8 >> 2] = c[g + 8 >> 2]
              c[o + 12 >> 2] = c[g + 12 >> 2]
              c[o + 16 >> 2] = c[g + 16 >> 2]
              c[o + 20 >> 2] = c[g + 20 >> 2]
              c[o + 24 >> 2] = c[g + 24 >> 2]
              c[o + 28 >> 2] = c[g + 28 >> 2]
              _O(e, o, 0)
              break
            }
            j = n + 16 | 0
            m = d[k >> 0] | 0
            c[o >> 2] = c[g >> 2]
            c[o + 4 >> 2] = c[g + 4 >> 2]
            c[o + 8 >> 2] = c[g + 8 >> 2]
            c[o + 12 >> 2] = c[g + 12 >> 2]
            c[o + 16 >> 2] = c[g + 16 >> 2]
            c[o + 20 >> 2] = c[g + 20 >> 2]
            c[o + 24 >> 2] = c[g + 24 >> 2]
            c[o + 28 >> 2] = c[g + 28 >> 2]
            KQ(j, o, m) | 0
            do {
              switch (((i & 65535) + -1024 | 0) >>> 10 & 4194303 | 0) {
                case 7: {
                  aP(e, j, 2)
                  break a
                }
                case 3: {
                  aP(e, n + 32 | 0, 2)
                  break a
                }
                case 1: {
                  aP(e, n + 48 | 0, 2)
                  break a
                }
                case 0: {
                  g = n + 64 | 0
                  c[n >> 2] = c[g >> 2]
                  c[n + 4 >> 2] = c[g + 4 >> 2]
                  c[n + 8 >> 2] = c[g + 8 >> 2]
                  c[n + 12 >> 2] = c[g + 12 >> 2]
                  aP(e, n, 2)
                  break a
                }
                case 11: {
                  aP(e, j, 3)
                  break a
                }
                case 5: {
                  aP(e, n + 32 | 0, 3)
                  break a
                }
                case 2: {
                  g = n + 80 | 0
                  c[g >> 2] = c[j >> 2]
                  c[g + 4 >> 2] = c[j + 4 >> 2]
                  c[g + 8 >> 2] = c[j + 8 >> 2]
                  c[g + 12 >> 2] = c[j + 12 >> 2]
                  aP(e, n + 48 | 0, 3)
                  break a
                }
                case 8: {
                  g = n + 64 | 0
                  c[n >> 2] = c[g >> 2]
                  c[n + 4 >> 2] = c[g + 4 >> 2]
                  c[n + 8 >> 2] = c[g + 8 >> 2]
                  c[n + 12 >> 2] = c[g + 12 >> 2]
                  aP(e, n, 3)
                  break a
                }
                case 13: {
                  aP(e, j, 4)
                  break a
                }
                case 6: {
                  g = n + 80 | 0
                  c[g >> 2] = c[j >> 2]
                  c[g + 4 >> 2] = c[j + 4 >> 2]
                  c[g + 8 >> 2] = c[j + 8 >> 2]
                  c[g + 12 >> 2] = c[j + 12 >> 2]
                  aP(e, n + 32 | 0, 4)
                  break a
                }
                case 10: {
                  g = n + 80 | 0
                  c[g >> 2] = c[j >> 2]
                  c[g + 4 >> 2] = c[j + 4 >> 2]
                  c[g + 8 >> 2] = c[j + 8 >> 2]
                  c[g + 12 >> 2] = c[j + 12 >> 2]
                  g = n + 96 | 0
                  o = n + 32 | 0
                  c[g >> 2] = c[o >> 2]
                  c[g + 4 >> 2] = c[o + 4 >> 2]
                  c[g + 8 >> 2] = c[o + 8 >> 2]
                  c[g + 12 >> 2] = c[o + 12 >> 2]
                  aP(e, n + 48 | 0, 4)
                  break a
                }
                case 12: {
                  g = n + 64 | 0
                  c[n >> 2] = c[g >> 2]
                  c[n + 4 >> 2] = c[g + 4 >> 2]
                  c[n + 8 >> 2] = c[g + 8 >> 2]
                  c[n + 12 >> 2] = c[g + 12 >> 2]
                  aP(e, n, 4)
                  break a
                }
                case 9: {
                  aP(e, j, 2)
                  aP(e, n + 48 | 0, 2)
                  break a
                }
                case 4: {
                  g = n + 64 | 0
                  c[n >> 2] = c[g >> 2]
                  c[n + 4 >> 2] = c[g + 4 >> 2]
                  c[n + 8 >> 2] = c[g + 8 >> 2]
                  c[n + 12 >> 2] = c[g + 12 >> 2]
                  aP(e, n, 2)
                  aP(e, n + 32 | 0, 2)
                  break a
                }
                default:
                  break a
              }
            } while (0)
          } else {
            m = d[k >> 0] | 0
            c[o >> 2] = c[g >> 2]
            c[o + 4 >> 2] = c[g + 4 >> 2]
            c[o + 8 >> 2] = c[g + 8 >> 2]
            c[o + 12 >> 2] = c[g + 12 >> 2]
            c[o + 16 >> 2] = c[g + 16 >> 2]
            c[o + 20 >> 2] = c[g + 20 >> 2]
            c[o + 24 >> 2] = c[g + 24 >> 2]
            c[o + 28 >> 2] = c[g + 28 >> 2]
            DJ(e, KQ(n, o, m) | 0, 4, 4, 0)
          }
        } while (0)
        l = p
        return
      }

      function OQ(d, e) {
        d = d | 0
        e = e | 0
        var f = 0, g = 0, h = 0
        h = c[d + 16 >> 2] | 0
        f = h + 208 | 0
        if ((c[f >> 2] | 0) == 0 ? (b[h + 260 >> 1] & 1) == 0 : 0) {
          d = 0
        } else {
          PO(d)
          d = c[f >> 2] | 0
        }
        if ((d | 0) != (c[e >> 2] | 0)) {
          C_(d)
          c[f >> 2] = c[e >> 2]
        }
        d = h + 228 | 0
        f = c[d >> 2] | 0
        g = e + 4 | 0
        if ((f | 0) != (c[g >> 2] | 0)) {
          C_(f)
          c[d >> 2] = c[g >> 2]
        }
        d = h + 244 | 0
        f = c[d >> 2] | 0
        g = e + 8 | 0
        if ((f | 0) != (c[g >> 2] | 0)) {
          C_(f)
          c[d >> 2] = c[g >> 2]
        }
        d = h + 212 | 0
        f = c[d >> 2] | 0
        g = e + 12 | 0
        if ((f | 0) != (c[g >> 2] | 0)) {
          C_(f)
          c[d >> 2] = c[g >> 2]
        }
        h = h + 260 | 0
        b[h >> 1] = b[h >> 1] & -2 | a[e + 16 >> 0] & 1
        return
      }

      function PQ(a, b) {
        a = a | 0
        b = b | 0
        var d = 0.0, e = 0
        e = c[b >> 2] | 0
        if (e | 0) {
          c[a + 16 >> 2] = e
        }
        e = c[b + 4 >> 2] | 0
        if (e | 0) {
          c[a + 20 >> 2] = e
        }
        d = +h[b + 16 >> 3]
        if (d >= 0.0) {
          h[a + 32 >> 3] = d
        }
        return
      }

      function QQ(a, b, d, e) {
        a = a | 0
        b = b | 0
        d = +d
        e = +e
        var f = 0, g = 0, i = 0
        f = l
        l = l + 64 | 0
        g = f + 32 | 0
        i = f
        c[i >> 2] = c[b >> 2]
        c[i + 4 >> 2] = c[b + 4 >> 2]
        c[i + 8 >> 2] = c[b + 8 >> 2]
        c[i + 12 >> 2] = c[b + 12 >> 2]
        h[i + 16 >> 3] = +h[b >> 3] + d
        h[i + 24 >> 3] = +h[b + 8 >> 3] + e
        c[g >> 2] = c[i >> 2]
        c[g + 4 >> 2] = c[i + 4 >> 2]
        c[g + 8 >> 2] = c[i + 8 >> 2]
        c[g + 12 >> 2] = c[i + 12 >> 2]
        c[g + 16 >> 2] = c[i + 16 >> 2]
        c[g + 20 >> 2] = c[i + 20 >> 2]
        c[g + 24 >> 2] = c[i + 24 >> 2]
        c[g + 28 >> 2] = c[i + 28 >> 2]
        _O(a, g, 1)
        l = f
        return
      }

      function RQ(b, d, e) {
        b = b | 0
        d = d | 0
        e = e | 0
        var f = 0, g = 0, i = 0, j = 0.0, k = 0.0, m = 0.0, n = 0.0
        i = l
        l = l + 64 | 0
        g = i
        k = +h[e >> 3]
        n = k + +h[d >> 3]
        m = +h[e + 8 >> 3]
        j = m + +h[d + 8 >> 3]
        k = k + +h[d + 16 >> 3]
        m = m + +h[d + 24 >> 3]
        h[g >> 3] = k
        h[g + 8 >> 3] = m
        h[g + 32 >> 3] = n
        h[g + 40 >> 3] = j
        h[g + 16 >> 3] = n
        h[g + 24 >> 3] = m
        h[g + 48 >> 3] = k
        h[g + 56 >> 3] = j
        f = c[d + 36 >> 2] | 0
        if (!f) {
          f = c[e + 56 >> 2] | 0
        }
        e = c[d + 32 >> 2] | 0
        if (!e) {
          qa(134252, 134260, 623, 134272)
        }
        if (!(a[e >> 0] | 0)) {
          qa(134286, 134260, 624, 134272)
        } else {
          cP(b, e, g, 4, 1, f)
          l = i
          return
        }
      }

      function SQ(d, e, f, g, i, j, k, m) {
        d = d | 0
        e = e | 0
        f = f | 0
        g = g | 0
        i = +i
        j = j | 0
        k = k | 0
        m = m | 0
        var n = 0.0, o = 0, p = 0, q = 0, r = 0, s = 0, t = 0, u = 0, v = 0, w = 0, x = 0, y = 0, z = 0, A = 0, B = 0,
            C = 0, D = 0, E = 0, F = 0, G = 0, H = 0, I = 0.0, J = 0, K = 0, L = 0, M = 0.0, N = 0.0, O = 0, P = 0,
            Q = 0, R = 0
        R = l
        l = l + 128 | 0
        K = R + 104 | 0
        O = R + 48 | 0
        P = R + 16 | 0
        L = R
        J = L
        c[J >> 2] = 0
        c[J + 4 >> 2] = 0
        M = +h[g >> 3]
        N = M - i
        I = M + i
        J = L + 8 | 0
        h[J >> 3] = (+h[k + 24 >> 3] - +h[k + 8 >> 3]) * .5 + +h[g + 8 >> 3]
        QO(d, 1)
        D = P + 16 | 0
        E = P + 4 | 0
        F = P + 24 | 0
        G = O + 4 | 0
        H = O + 16 | 0
        s = (m | 0) == 0
        t = O + 24 | 0
        u = O + 8 | 0
        v = O + 32 | 0
        w = O + 40 | 0
        x = O + 48 | 0
        y = j + 16 | 0
        z = j + 4 | 0
        A = P + 8 | 0
        q = 0
        while (1) {
          if ((q | 0) >= (e | 0)) {
            break
          }
          switch (a[f + (q * 24 | 0) + 6 >> 0] | 0) {
            case 108: {
              i = N
              break
            }
            case 114: {
              i = I - +h[f + (q * 24 | 0) + 8 >> 3]
              break
            }
            default:
              i = M - +h[f + (q * 24 | 0) + 8 >> 3] * .5
          }
          h[g >> 3] = i
          B = f + (q * 24 | 0) + 16 | 0
          h[J >> 3] = +h[J >> 3] - +h[B >> 3]
          C = f + (q * 24 | 0) + 4 | 0
          p = c[f + (q * 24 | 0) >> 2] | 0
          r = 0
          while (1) {
            if ((r | 0) >= (b[C >> 1] | 0)) {
              break
            }
            o = p + 4 | 0
            m = c[o >> 2] | 0
            if (m) {
              h[D >> 3] = +h[(+h[m + 16 >> 3] > 0.0 ? m : j) + 16 >> 3]
              c[P >> 2] = c[((c[m >> 2] | 0) == 0 ? j : m) >> 2]
              k = c[((c[m + 4 >> 2] | 0) == 0 ? j : m) + 4 >> 2] | 0
              c[E >> 2] = k
              m = c[m + 24 >> 2] & 127
              if (!m) {
                Q = 12
              } else {
                m = c[F >> 2] & -128 | m
              }
            } else {
              h[D >> 3] = +h[y >> 3]
              c[P >> 2] = c[j >> 2]
              k = c[z >> 2] | 0
              c[E >> 2] = k
              Q = 12
            }
            if ((Q | 0) == 12) {
              Q = 0
              m = c[F >> 2] & -128
            }
            c[F >> 2] = m
            TO(d, k)
            c[O >> 2] = c[p >> 2]
            c[G >> 2] = P
            h[H >> 3] = +h[p + 16 >> 3]
            if (s) {
              n = 1.0
            } else {
              n = +h[p + 24 >> 3]
            }
            h[t >> 3] = n
            c[A >> 2] = c[(c[o >> 2] | 0) + 8 >> 2]
            c[u >> 2] = c[p + 8 >> 2]
            o = p + 32 | 0
            h[v >> 3] = +h[o >> 3]
            h[w >> 3] = +h[B >> 3]
            a[x >> 0] = 108
            h[L >> 3] = i
            c[K >> 2] = c[L >> 2]
            c[K + 4 >> 2] = c[L + 4 >> 2]
            c[K + 8 >> 2] = c[L + 8 >> 2]
            c[K + 12 >> 2] = c[L + 12 >> 2]
            SO(d, K, O)
            n = +h[o >> 3] + i
            h[g >> 3] = n
            p = p + 56 | 0
            r = r + 1 | 0
            i = n
          }
          q = q + 1 | 0
        }
        RO(d)
        l = R
        return
      }

      function TQ(a) {
        a = a | 0
        C_(c[a >> 2] | 0)
        C_(c[a + 4 >> 2] | 0)
        C_(c[a + 8 >> 2] | 0)
        C_(c[a + 16 >> 2] | 0)
        C_(c[a + 12 >> 2] | 0)
        C_(c[a + 20 >> 2] | 0)
        C_(c[a + 24 >> 2] | 0)
        return
      }

      function UQ(a) {
        a = a | 0
        var d = 0, e = 0, f = 0, g = 0, h = 0, i = 0, j = 0, k = 0
        if (a | 0) {
          j = a + 4 | 0
          e = 0
          g = c[a >> 2] | 0
          while (1) {
            if ((e | 0) >= (b[j >> 1] | 0)) {
              break
            }
            k = g + 4 | 0
            d = 0
            f = c[g >> 2] | 0
            while (1) {
              if ((d | 0) >= (b[k >> 1] | 0)) {
                break
              }
              C_(c[f >> 2] | 0)
              h = c[f + 8 >> 2] | 0
              if (h | 0 ? (i = c[f + 12 >> 2] | 0, i | 0) : 0) {
                tb[i & 127](h)
              }
              d = d + 1 | 0
              f = f + 56 | 0
            }
            e = e + 1 | 0
            g = g + 24 | 0
          }
          d = c[a >> 2] | 0
          if (d | 0) {
            C_(d)
          }
          C_(a)
        }
        return
      }

      function VQ(a) {
        a = a | 0
        C_(c[a + 32 >> 2] | 0)
        C_(a)
        return
      }

      function WQ(b, d) {
        b = b | 0
        d = d | 0
        switch (a[b + 4 >> 0] | 0) {
          case 1: {
            XQ(c[b >> 2] | 0)
            break
          }
          case 3: {
            VQ(c[b >> 2] | 0)
            break
          }
          default:
            UQ(c[b >> 2] | 0)
        }
        if (d | 0) {
          C_(b)
        }
        return
      }

      function XQ(a) {
        a = a | 0
        var b = 0, d = 0, e = 0
        e = a + 84 | 0
        if ((c[a + 100 >> 2] | 0) == -1) {
          xw(c[e >> 2] | 0) | 0
        } else {
          b = c[e >> 2] | 0
          C_(c[a + 92 >> 2] | 0)
          C_(c[a + 96 >> 2] | 0)
          while (1) {
            d = c[b >> 2] | 0
            if (!d) {
              break
            }
            YQ(d)
            b = b + 4 | 0
          }
          C_(c[e >> 2] | 0)
        }
        TQ(a)
        C_(a)
        return
      }

      function YQ(a) {
        a = a | 0
        WQ(a + 88 | 0, 0)
        TQ(a)
        C_(a)
        return
      }

      function ZQ(b, e, f) {
        b = b | 0
        e = e | 0
        f = f | 0
        var g = 0
        b = c[(c[(c[b + 16 >> 2] | 0) + 104 >> 2] | 0) + 72 >> 2] | 0
        if ((a[b + 4 >> 0] | 0) != 2 ? (g = _Q(c[b >> 2] | 0, e) | 0, (g | 0) != 0) : 0) {
          c[f >> 2] = d[g + 35 >> 0]
          b = g + 48 | 0
        } else {
          b = 0
        }
        return b | 0
      }

      function _Q(a, b) {
        a = a | 0
        b = b | 0
        var d = 0, e = 0
        d = c[a + 4 >> 2] | 0
        if (!((d | 0) != 0 ? (N$(d, b) | 0) == 0 : 0)) {
          e = 3
        }
        a:do {
          if ((e | 0) == 3) {
            d = c[a + 84 >> 2] | 0
            while (1) {
              a = c[d >> 2] | 0
              if (!a) {
                a = 0
                break a
              }
              a = $Q(a, b) | 0
              if (!a) {
                d = d + 4 | 0
              } else {
                break
              }
            }
          }
        } while (0)
        return a | 0
      }

      function $Q(b, d) {
        b = b | 0
        d = d | 0
        var e = 0
        e = c[b + 4 >> 2] | 0
        if (!((e | 0) != 0 ? (N$(e, d) | 0) == 0 : 0)) {
          if ((a[b + 92 >> 0] | 0) == 1) {
            b = _Q(c[b + 88 >> 2] | 0, d)
                | 0
          } else {
            b = 0
          }
        }
        return b | 0
      }

      function aR(a, b, c, d, e) {
        a = a | 0
        b = b | 0
        c = c | 0
        d = d | 0
        e = e | 0
        return 0
      }

      function bR(d) {
        d = d | 0
        var f = 0.0, g = 0, i = 0, j = 0, k = 0, l = 0, m = 0, n = 0, o = 0, p = 0, q = 0, r = 0
        p = d + 92 | 0
        c[p >> 2] = tH((c[d + 100 >> 2] << 2) + 4 | 0) | 0
        n = tH((c[d + 104 >> 2] << 2) + 4 | 0) | 0
        c[d + 96 >> 2] = n
        o = d + 32 | 0
        m = c[d + 84 >> 2] | 0
        while (1) {
          l = c[m >> 2] | 0
          if (!l) {
            break
          }
          d = b[l + 82 >> 1] | 0
          f = +h[l + 72 >> 3]
          if (d << 16 >> 16 == 1) {
            i = ~~f
          } else {
            i = ~~((f - +(O((a[o >> 0] | 0) + -1 | 0, (d & 65535) + -1 | 0) | 0)) / +(d & 65535))
            i = (i | 0) > 1 ? i : 1
          }
          j = b[l + 80 >> 1] | 0
          f = +h[l + 64 >> 3]
          if (j << 16 >> 16 == 1) {
            k = ~~f
          } else {
            k = ~~((f - +(O((a[o >> 0] | 0) + -1 | 0, (j & 65535) + -1 | 0) | 0)) / +(j & 65535))
            k = (k | 0) > 1 ? k : 1
          }
          q = e[l + 86 >> 1] | 0
          g = (d & 65535) + q | 0
          d = q
          while (1) {
            if ((d | 0) >= (g | 0)) {
              break
            }
            q = (c[p >> 2] | 0) + (d << 2) | 0
            r = c[q >> 2] | 0
            c[q >> 2] = (r | 0) > (i | 0) ? r : i
            d = d + 1 | 0
          }
          d = e[l + 84 >> 1] | 0
          g = (j & 65535) + d | 0
          while (1) {
            if ((d | 0) >= (g | 0)) {
              break
            }
            r = n + (d << 2) | 0
            q = c[r >> 2] | 0
            c[r >> 2] = (q | 0) > (k | 0) ? q : k
            d = d + 1 | 0
          }
          m = m + 4 | 0
        }
        return
      }

      function cR(a) {
        a = a | 0
        var b = 0, d = 0
        d = l
        l = l + 16 | 0
        b = d
        if (a >>> 0 < 21) {
          a = c[55736 + (a << 2) >> 2] | 0
        } else {
          c[b >> 2] = a
          X0(191879, 134313, b) | 0
          a = 191879
        }
        l = d
        return a | 0
      }

      function dR(a, b, d) {
        a = a | 0
        b = b | 0
        d = d | 0
        var f = 0, g = 0, i = 0, j = 0, k = 0, l = 0, m = 0, n = 0, o = 0
        k = a + 104 | 0
        l = a + 100 | 0
        j = d + 16 | 0
        f = 0
        g = 0
        while (1) {
          if ((f | 0) > (c[k >> 2] | 0)) {
            break
          }
          i = $y(d, cR(f) | 0, 1) | 0
          zz(i, 134365, 304, 1) | 0
          m = i + 16 | 0
          c[(c[m >> 2] | 0) + 176 >> 2] = 0
          o = tH((c[l >> 2] << 2) + 4 | 0) | 0
          n = c[m >> 2] | 0
          c[n + 172 >> 2] = o
          c[n + 184 >> 2] = 0
          n = tH((c[l >> 2] << 2) + 4 | 0) | 0
          c[(c[m >> 2] | 0) + 180 >> 2] = n
          if (!g) {
            c[(c[j >> 2] | 0) + 192 >> 2] = i
          } else {
            c[(c[g + 16 >> 2] | 0) + 164 >> 2] = i
          }
          f = f + 1 | 0
          g = i
        }
        j = b + 16 | 0
        f = 0
        g = 0
        while (1) {
          if ((f | 0) > (c[l >> 2] | 0)) {
            break
          }
          i = $y(b, cR(f) | 0, 1) | 0
          zz(i, 134365, 304, 1) | 0
          o = i + 16 | 0
          c[(c[o >> 2] | 0) + 176 >> 2] = 0
          m = tH((c[k >> 2] << 2) + 4 | 0) | 0
          n = c[o >> 2] | 0
          c[n + 172 >> 2] = m
          c[n + 184 >> 2] = 0
          n = tH((c[k >> 2] << 2) + 4 | 0) | 0
          c[(c[o >> 2] | 0) + 180 >> 2] = n
          if (!g) {
            c[(c[j >> 2] | 0) + 192 >> 2] = i
          } else {
            c[(c[g + 16 >> 2] | 0) + 164 >> 2] = i
          }
          f = f + 1 | 0
          g = i
        }
        f = c[a + 84 >> 2] | 0
        while (1) {
          g = c[f >> 2] | 0
          if (!g) {
            break
          }
          o = g + 84 | 0
          n = $y(d, cR(e[o >> 1] | 0) | 0, 0) | 0
          o = $y(d, cR((e[g + 80 >> 1] | 0) + (e[o >> 1] | 0) | 0) | 0, 0) | 0
          eR(d, n, o, ~~+h[g + 64 >> 3])
          o = g + 86 | 0
          n = $y(b, cR(e[o >> 1] | 0) | 0, 0) | 0
          o = $y(b, cR((e[g + 82 >> 1] | 0) + (e[o >> 1] | 0) | 0) | 0, 0) | 0
          eR(b, n, o, ~~+h[g + 72 >> 3])
          f = f + 4 | 0
        }
        fR(d)
        fR(b)
        return
      }

      function eR(a, d, f, g) {
        a = a | 0
        d = d | 0
        f = f | 0
        g = g | 0
        var h = 0, i = 0
        h = Qx(a, d, f, 0, 0) | 0
        if (!h) {
          i = Qx(a, d, f, 0, 1) | 0
          zz(i, 134378, 176, 1) | 0
          b[(c[i + 16 >> 2] | 0) + 170 >> 1] = g
          d = d + 16 | 0
          a = c[d >> 2] | 0
          h = c[a + 180 >> 2] | 0
          if (!h) {
            a = uH((c[a + 184 >> 2] << 2) + 8 | 0) | 0
          } else {
            a = wH(h, (c[a + 184 >> 2] << 2) + 8 | 0) | 0
          }
          g = c[d >> 2] | 0
          c[g + 180 >> 2] = a
          g = g + 184 | 0
          h = c[g >> 2] | 0
          c[g >> 2] = h + 1
          c[a + (h << 2) >> 2] = i
          d = c[d >> 2] | 0
          c[(c[d + 180 >> 2] | 0) + (c[d + 184 >> 2] << 2) >> 2] = 0
          d = f + 16 | 0
          a = c[d >> 2] | 0
          h = c[a + 172 >> 2] | 0
          if (!h) {
            a = uH((c[a + 176 >> 2] << 2) + 8 | 0) | 0
          } else {
            a = wH(h, (c[a + 176 >> 2] << 2) + 8 | 0) | 0
          }
          g = c[d >> 2] | 0
          c[g + 172 >> 2] = a
          g = g + 176 | 0
          f = c[g >> 2] | 0
          c[g >> 2] = f + 1
          c[a + (f << 2) >> 2] = i
          i = c[d >> 2] | 0
          c[(c[i + 172 >> 2] | 0) + (c[i + 176 >> 2] << 2) >> 2] = 0
        } else {
          i = (c[h + 16 >> 2] | 0) + 170 | 0
          f = e[i >> 1] | 0
          b[i >> 1] = (f | 0) > (g | 0) ? f : g
        }
        return
      }

      function fR(a) {
        a = a | 0
        var d = 0, e = 0, f = 0, g = 0, h = 0, i = 0
        d = c[(c[a + 16 >> 2] | 0) + 192 >> 2] | 0
        while (1) {
          f = d + 16 | 0
          h = c[(c[f >> 2] | 0) + 164 >> 2] | 0
          if (!h) {
            break
          }
          if (Qx(a, d, h, 0, 0) | 0) {
            d = h
            continue
          }
          g = Qx(a, d, h, 0, 1) | 0
          zz(g, 134378, 176, 1) | 0
          b[(c[g + 16 >> 2] | 0) + 170 >> 1] = 0
          d = c[f >> 2] | 0
          e = c[d + 180 >> 2] | 0
          if (!e) {
            d = uH((c[d + 184 >> 2] << 2) + 8 | 0) | 0
          } else {
            d = wH(e, (c[d + 184 >> 2] << 2) + 8 | 0) | 0
          }
          i = c[f >> 2] | 0
          c[i + 180 >> 2] = d
          i = i + 184 | 0
          e = c[i >> 2] | 0
          c[i >> 2] = e + 1
          c[d + (e << 2) >> 2] = g
          f = c[f >> 2] | 0
          c[(c[f + 180 >> 2] | 0) + (c[f + 184 >> 2] << 2) >> 2] = 0
          f = h + 16 | 0
          d = c[f >> 2] | 0
          e = c[d + 172 >> 2] | 0
          if (!e) {
            d = uH((c[d + 176 >> 2] << 2) + 8 | 0) | 0
          } else {
            d = wH(e, (c[d + 176 >> 2] << 2) + 8 | 0) | 0
          }
          e = c[f >> 2] | 0
          c[e + 172 >> 2] = d
          e = e + 176 | 0
          i = c[e >> 2] | 0
          c[e >> 2] = i + 1
          c[d + (i << 2) >> 2] = g
          d = c[f >> 2] | 0
          c[(c[d + 172 >> 2] | 0) + (c[d + 176 >> 2] << 2) >> 2] = 0
          d = h
        }
        return
      }

      function gR(a, b, d) {
        a = a | 0
        b = b | 0
        d = d | 0
        var e = 0, f = 0, g = 0, h = 0
        g = a + 92 | 0
        e = 0
        f = 0
        b = c[(c[(c[b + 16 >> 2] | 0) + 192 >> 2] | 0) + 16 >> 2] | 0
        while (1) {
          b = c[b + 164 >> 2] | 0
          if (!b) {
            break
          }
          b = c[b + 16 >> 2] | 0
          h = b + 232 | 0
          c[(c[g >> 2] | 0) + (f << 2) >> 2] = (c[h >> 2] | 0) - e
          e = c[h >> 2] | 0
          f = f + 1 | 0
        }
        a = a + 96 | 0
        e = 0
        f = 0
        b = c[(c[(c[d + 16 >> 2] | 0) + 192 >> 2] | 0) + 16 >> 2] | 0
        while (1) {
          b = c[b + 164 >> 2] | 0
          if (!b) {
            break
          }
          b = c[b + 16 >> 2] | 0
          h = b + 232 | 0
          c[(c[a >> 2] | 0) + (f << 2) >> 2] = (c[h >> 2] | 0) - e
          e = c[h >> 2] | 0
          f = f + 1 | 0
        }
        return
      }

      function hR(b) {
        b = b | 0
        var d = 0, e = 0, f = 0, g = 0, h = 0
        h = l
        l = l + 16 | 0
        g = h + 4 | 0
        d = h
        c[d >> 2] = c[4621]
        e = c[b + 100 >> 2] | 0
        if ((e | 0) != 1 ? (f = b + 104 | 0, (c[f >> 2] | 0) != 1) : 0) {
          c[b + 92 >> 2] = tH((e << 2) + 4 | 0) | 0
          c[b + 96 >> 2] = tH((c[f >> 2] << 2) + 4 | 0) | 0
          a[g >> 0] = a[d >> 0] | 0
          a[g + 1 >> 0] = a[d + 1 >> 0] | 0
          a[g + 2 >> 0] = a[d + 2 >> 0] | 0
          a[g + 3 >> 0] = a[d + 3 >> 0] | 0
          f = Wx(134391, g, 0) | 0
          a[g >> 0] = a[d >> 0] | 0
          a[g + 1 >> 0] = a[d + 1 >> 0] | 0
          a[g + 2 >> 0] = a[d + 2 >> 0] | 0
          a[g + 3 >> 0] = a[d + 3 >> 0] | 0
          g = Wx(134396, g, 0) | 0
          zz(f, 134401, 280, 1) | 0
          zz(g, 134401, 280, 1) | 0
          dR(b, f, g)
          eI(f, 2, 2147483647) | 0
          eI(g, 2, 2147483647) | 0
          gR(b, f, g)
          iR(f, g)
        } else {
          bR(b)
        }
        l = h
        return
      }

      function iR(a, b) {
        a = a | 0
        b = b | 0
        var d = 0, e = 0, f = 0
        d = (c[b + 16 >> 2] | 0) + 192 | 0
        while (1) {
          d = c[d >> 2] | 0
          if (!d) {
            break
          }
          f = d + 16 | 0
          d = c[f >> 2] | 0
          e = c[d + 172 >> 2] | 0
          if (e) {
            C_(e)
            d = c[f >> 2] | 0
          }
          e = c[d + 180 >> 2] | 0
          if (e) {
            C_(e)
            d = c[f >> 2] | 0
          }
          d = d + 164 | 0
        }
        _x(a) | 0
        _x(b) | 0
        return
      }

      function jR(b, d) {
        b = b | 0
        d = d | 0
        var e = 0, f = 0, g = 0, i = 0, j = 0, k = 0, m = 0, n = 0, o = 0, p = 0, q = 0.0, r = 0.0
        p = l
        l = l + 272 | 0
        n = p + 104 | 0
        o = p + 136 | 0
        j = p + 72 | 0
        k = p
        g = p + 144 | 0
        c[k + 48 >> 2] = b
        switch (oz(b) | 0) {
          case 0: {
            e = c[b + 60 >> 2] | 0
            break
          }
          case 1: {
            e = dz(b) | 0
            break
          }
          case 2: {
            e = dz(c[((c[b >> 2] & 3 | 0) == 2 ? b : b + -48 | 0) + 40 >> 2] | 0) | 0
            break
          }
          default: {
          }
        }
        i = k + 52 | 0
        c[i >> 2] = e
        m = c[e + 60 >> 2] | 0
        h[k + 32 >> 3] = +h[d + 16 >> 3]
        c[k + 16 >> 2] = c[d + 4 >> 2]
        c[k + 20 >> 2] = c[d + 8 >> 2]
        c[k + 40 >> 2] = 0
        f = tT(c[d >> 2] | 0, o, k) | 0
        if (!f) {
          Sw(n, 128, g)
          a[d + 82 >> 0] = 0
          e = m1(kR(b, n) | 0) | 0
          c[d >> 2] = e
          if ((c[d + 12 >> 2] | 0) == 1) {
            e = QM(e) | 0
          } else {
            e = NM(e, c[i >> 2] | 0) | 0
          }
          C_(c[d >> 2] | 0)
          c[d >> 2] = e
          hH(c[(c[m + 16 >> 2] | 0) + 144 >> 2] | 0, d)
          Ww(n)
          e = c[o >> 2] | 0
        } else {
          e = f + 4 | 0
          if ((a[e >> 0] | 0) == 1) {
            if ((c[(c[f >> 2] | 0) + 24 >> 2] | 0) == 0 ? lR(b) | 0 : 0) {
              i = m1(lR(b) | 0) | 0
              c[(c[f >> 2] | 0) + 24 >> 2] = i
            }
            m = mR(m, c[f >> 2] | 0, 0, k) | 0
            c[o >> 2] = c[o >> 2] | m
            m = c[f >> 2] | 0
            r = +h[m + 64 >> 3] * .5
            q = +h[m + 72 >> 3] * .5
            nR(j, -r, -q, r, q)
            m = c[f >> 2] | 0
            c[n >> 2] = c[j >> 2]
            c[n + 4 >> 2] = c[j + 4 >> 2]
            c[n + 8 >> 2] = c[j + 8 >> 2]
            c[n + 12 >> 2] = c[j + 12 >> 2]
            c[n + 16 >> 2] = c[j + 16 >> 2]
            c[n + 20 >> 2] = c[j + 20 >> 2]
            c[n + 24 >> 2] = c[j + 24 >> 2]
            c[n + 28 >> 2] = c[j + 28 >> 2]
            oR(m, n, 15)
          } else {
            pR(c[(c[m + 16 >> 2] | 0) + 144 >> 2] | 0, c[f >> 2] | 0, k)
            n = c[f >> 2] | 0
            q = +h[n + 24 >> 3] * .5
            r = +h[n + 32 >> 3] * .5
            nR(j, -q, -r, q, r)
            n = (c[f >> 2] | 0) + 8 | 0
            c[n >> 2] = c[j >> 2]
            c[n + 4 >> 2] = c[j + 4 >> 2]
            c[n + 8 >> 2] = c[j + 8 >> 2]
            c[n + 12 >> 2] = c[j + 12 >> 2]
            c[n + 16 >> 2] = c[j + 16 >> 2]
            c[n + 20 >> 2] = c[j + 20 >> 2]
            c[n + 24 >> 2] = c[j + 24 >> 2]
            c[n + 28 >> 2] = c[j + 28 >> 2]
          }
          h[d + 24 >> 3] = +h[j + 16 >> 3] - +h[j >> 3]
          h[d + 32 >> 3] = +h[j + 24 >> 3] - +h[j + 8 >> 3]
          c[d + 72 >> 2] = f
          if ((a[e >> 0] | 0) == 1) {
            C_(c[d >> 2] | 0)
            c[d >> 2] = m1(138529) | 0
          }
          e = c[o >> 2] | 0
        }
        l = p
        return e | 0
      }

      function kR(b, d) {
        b = b | 0
        d = d | 0
        var e = 0
        a:do {
          switch (oz(b) | 0) {
            case 0: {
              Vw(d, qy(b) | 0) | 0
              break
            }
            case 1: {
              Vw(d, qy(b) | 0) | 0
              break
            }
            case 2: {
              Vw(d, qy(c[((c[b >> 2] & 3 | 0) == 3 ? b : b + 48 | 0) + 40 >> 2] | 0) | 0) | 0
              e = b + -48 | 0
              Vw(d, qy(c[((c[b >> 2] & 3 | 0) == 2 ? b : e) + 40 >> 2] | 0) | 0) | 0
              if (!(dy(dz(c[((c[b >> 2] & 3 | 0) == 2 ? b : e) + 40 >> 2] | 0) | 0) | 0)) {
                Vw(d, 138665) | 0
                break a
              } else {
                Vw(d, 134656) | 0
                break a
              }
            }
            default: {
            }
          }
        } while (0)
        e = d + 4 | 0
        b = c[e >> 2] | 0
        if (b >>> 0 >= (c[d + 8 >> 2] | 0) >>> 0) {
          Tw(d, 1) | 0
          b = c[e >> 2] | 0
        }
        a[b >> 0] = 0
        d = c[d >> 2] | 0
        c[e >> 2] = d
        return d | 0
      }

      function lR(b) {
        b = b | 0
        var c = 0, d = 0
        c = wx(b, 134647) | 0
        if (!((c | 0) != 0 ? (a[c >> 0] | 0) != 0 : 0)) {
          d = 3
        }
        do {
          if ((d | 0) == 3) {
            c = wx(b, 137741) | 0
            if (c | 0 ? a[c >> 0] | 0 : 0) {
              break
            }
            c = 0
          }
        } while (0)
        return c | 0
      }

      function mR(f, g, i, j) {
        f = f | 0
        g = g | 0
        i = i | 0
        j = j | 0
        var k = 0, m = 0, n = 0, o = 0, p = 0, q = 0, r = 0, s = 0, t = 0, u = 0, v = 0, w = 0
        w = l
        l = l + 16 | 0
        u = w + 8 | 0
        t = w
        v = g + 108 | 0
        k = c[v >> 2] | 0
        if (k | 0) {
          HQ(j, k, 183496)
        }
        c[g + 80 >> 2] = i
        k = tR(f, g, j) | 0
        r = g + 36 | 0
        f = b[r >> 1] | 0
        if (!(f & 128)) {
          a[g + 32 >> 0] = 2
        }
        i = g + 33 | 0
        if (!(f & 32)) {
          a[i >> 0] = 1
        }
        hR(g)
        n = c[g + 104 >> 2] | 0
        p = a[g + 32 >> 0] | 0
        f = O(n + 1 | 0, p) | 0
        o = d[i >> 0] << 1
        q = c[g + 100 >> 2] | 0
        p = O(q + 1 | 0, p) | 0
        m = g + 96 | 0
        f = o + f | 0
        i = 0
        while (1) {
          if ((i | 0) >= (n | 0)) {
            break
          }
          f = (c[(c[m >> 2] | 0) + (i << 2) >> 2] | 0) + f | 0
          i = i + 1 | 0
        }
        n = g + 92 | 0
        i = p + o | 0
        m = 0
        while (1) {
          if ((m | 0) >= (q | 0)) {
            break
          }
          i = (c[(c[n >> 2] | 0) + (m << 2) >> 2] | 0) + i | 0
          m = m + 1 | 0
        }
        n = g + 38 | 0
        do {
          if (b[r >> 1] & 1) {
            r = b[n >> 1] | 0
            m = r & 65535
            if (r << 16 >> 16 ? (s = b[g + 40 >> 1] | 0, s << 16 >> 16) : 0) {
              if (!((f | 0) > (m | 0) | (i | 0) > (s & 65535 | 0))) {
                i = 0
                f = 0
                break
              }
              Ow(0, 134447, t) | 0
              k = 1
              i = 0
              f = 0
              break
            }
            Ow(0, 134481, u) | 0
            k = 1
          }
        } while (0)
        u = e[n >> 1] | 0
        h[g + 64 >> 3] = +(((f | 0) > (u | 0) ? f : u) | 0)
        u = e[g + 40 >> 1] | 0
        h[g + 72 >> 3] = +(((i | 0) > (u | 0) ? i : u) | 0)
        if (c[v >> 2] | 0) {
          PQ(j, 183496)
        }
        l = w
        return k | 0
      }

      function nR(a, b, c, d, e) {
        a = a | 0
        b = +b
        c = +c
        d = +d
        e = +e
        h[a >> 3] = b
        h[a + 8 >> 3] = c
        h[a + 16 >> 3] = d
        h[a + 24 >> 3] = e
        return
      }

      function oR(e, f, g) {
        e = e | 0
        f = f | 0
        g = g | 0
        var i = 0, j = 0, k = 0, m = 0.0, n = 0.0, o = 0, p = 0, q = 0.0, r = 0.0, s = 0, t = 0, u = 0, v = 0, w = 0,
            x = 0, y = 0.0, z = 0, A = 0, B = 0, C = 0, D = 0, E = 0, F = 0, G = 0, H = 0, I = 0, J = 0.0, K = 0
        I = l
        l = l + 64 | 0
        G = I + 32 | 0
        H = I
        E = c[e + 84 >> 2] | 0
        k = c[e + 80 >> 2] | 0
        if ((k | 0 ? (i = c[k + 24 >> 2] | 0, i | 0) : 0) ? (j = e + 24 | 0, (c[j >> 2] | 0) == 0) : 0) {
          c[j >> 2] = m1(
              i) | 0
        }
        F = e + 48 | 0
        i = f + 16 | 0
        n = +h[i >> 3]
        m = +h[f >> 3]
        k = ~~(n - m - +(~~+h[e + 64 >> 3] | 0))
        if ((k | 0) <= -1) {
          qa(134414, 134260, 1761, 134424)
        }
        o = f + 24 | 0
        y = +h[o >> 3]
        p = f + 8 | 0
        q = +h[p >> 3]
        r = +(~~+h[e + 72 >> 3] | 0)
        s = ~~(y - q - r)
        if ((s | 0) <= -1) {
          qa(134437, 134260, 1764, 134424)
        }
        t = b[e + 36 >> 1] | 0
        j = t & 65535
        a:do {
          if (j & 1) {
            b:do {
              if ((k | 0) > 0) {
                switch (j & 6) {
                  case 4: {
                    h[i >> 3] = m + r
                    break b
                  }
                  case 2: {
                    J = +(k | 0)
                    h[i >> 3] = n + J
                    m = m + J
                    h[f >> 3] = m
                    break b
                  }
                  default: {
                    J = +(k >>> 1 | 0)
                    m = m + J
                    h[f >> 3] = m
                    h[i >> 3] = n - J
                    break b
                  }
                }
              }
            } while (0)
            if ((s | 0) > 0) {
              switch (t & 24) {
                case 16: {
                  y = q + r
                  h[o >> 3] = y
                  s = 0
                  i = 0
                  break a
                }
                case 8: {
                  J = +(s | 0)
                  y = y + J
                  h[o >> 3] = y
                  h[p >> 3] = q + J
                  s = 0
                  i = 0
                  break a
                }
                default: {
                  J = +(s >>> 1 | 0)
                  h[p >> 3] = q + J
                  y = y - J
                  h[o >> 3] = y
                  s = 0
                  i = 0
                  break a
                }
              }
            } else {
              s = 0
              i = 0
            }
          } else {
            i = k
          }
        } while (0)
        n = +(d[e + 33 >> 0] | 0)
        C = e + 32 | 0
        u = a[C >> 0] | 0
        q = +(u << 24 >> 24)
        D = e + 104 | 0
        k = c[D >> 2] | 0
        t = (i | 0) / (k | 0) | 0
        o = i - (O(t, k) | 0) | 0
        o = ~~(((o | 0) > -1 ? .5 : -.5) + +(o | 0))
        B = e + 96 | 0
        p = u << 24 >> 24
        i = ~~(m + n + q)
        j = 0
        while (1) {
          if ((j | 0) > (k | 0)) {
            break
          }
          A = (c[B >> 2] | 0) + (j << 2) | 0
          k = c[A >> 2] | 0
          c[A >> 2] = i
          i = i + t + ((j | 0) < (o | 0) & 1) + k + p | 0
          j = j + 1 | 0
          k = c[D >> 2] | 0
        }
        A = e + 100 | 0
        k = c[A >> 2] | 0
        t = (s | 0) / (k | 0) | 0
        p = s - (O(t, k) | 0) | 0
        p = ~~(((p | 0) > -1 ? .5 : -.5) + +(p | 0))
        z = e + 92 | 0
        o = u << 24 >> 24
        i = ~~(y - n - q)
        j = 0
        while (1) {
          if ((j | 0) > (k | 0)) {
            break
          }
          x = (c[z >> 2] | 0) + (j << 2) | 0
          k = c[x >> 2] | 0
          c[x >> 2] = i
          i = i - t + (((j | 0) < (p | 0)) << 31 >> 31) - k - o | 0
          j = j + 1 | 0
          k = c[A >> 2] | 0
        }
        u = (g | 0) == 0
        v = H + 16 | 0
        w = H + 24 | 0
        x = H + 8 | 0
        i = E
        while (1) {
          o = c[i >> 2] | 0
          if (!o) {
            break
          }
          k = b[o + 84 >> 1] | 0
          if (u) {
            j = 0
            p = b[o + 80 >> 1] | 0
            s = b[o + 86 >> 1] | 0
            t = b[o + 82 >> 1] | 0
          } else {
            j = k << 16 >> 16 == 0 ? 8 : 0
            s = b[o + 86 >> 1] | 0
            j = s << 16 >> 16 == 0 ? j | 4 : j
            p = b[o + 80 >> 1] | 0
            t = b[o + 82 >> 1] | 0
            j = (((p & 65535) + (k & 65535) | 0) == (c[D >> 2] | 0) ? j | 2 : j) | ((t & 65535) + (s & 65535) | 0)
                == (c[A >> 2] | 0)
          }
          K = c[B >> 2] | 0
          k = k & 65535
          h[H >> 3] = +(c[K + (k << 2) >> 2] | 0)
          E = a[C >> 0] | 0
          h[v >> 3] = +((c[K + ((p & 65535) + k << 2) >> 2] | 0) - E | 0)
          p = c[z >> 2] | 0
          h[w >> 3] = +(c[p + ((s & 65535) << 2) >> 2] | 0)
          h[x >> 3] = +((c[p + ((t & 65535) + (s & 65535) << 2) >> 2] | 0) + E | 0)
          c[G >> 2] = c[H >> 2]
          c[G + 4 >> 2] = c[H + 4 >> 2]
          c[G + 8 >> 2] = c[H + 8 >> 2]
          c[G + 12 >> 2] = c[H + 12 >> 2]
          c[G + 16 >> 2] = c[H + 16 >> 2]
          c[G + 20 >> 2] = c[H + 20 >> 2]
          c[G + 24 >> 2] = c[H + 24 >> 2]
          c[G + 28 >> 2] = c[H + 28 >> 2]
          qR(o, G, j & g)
          i = i + 4 | 0
        }
        a[e + 35 >> 0] = g
        c[F >> 2] = c[f >> 2]
        c[F + 4 >> 2] = c[f + 4 >> 2]
        c[F + 8 >> 2] = c[f + 8 >> 2]
        c[F + 12 >> 2] = c[f + 12 >> 2]
        c[F + 16 >> 2] = c[f + 16 >> 2]
        c[F + 20 >> 2] = c[f + 20 >> 2]
        c[F + 24 >> 2] = c[f + 24 >> 2]
        c[F + 28 >> 2] = c[f + 28 >> 2]
        l = I
        return
      }

      function pR(d, e, f) {
        d = d | 0
        e = e | 0
        f = f | 0
        var g = 0, i = 0, j = 0.0, k = 0.0, m = 0, n = 0, o = 0.0, p = 0.0, q = 0.0, r = 0, s = 0.0, t = 0.0, u = 0.0,
            v = 0, w = 0, x = 0, y = 0, z = 0, A = 0, B = 0, C = 0, D = 0, E = 0, F = 0, G = 0, H = 0, I = 0, J = 0,
            K = 0, L = 0, M = 0, N = 0, O = 0, P = 0.0, Q = 0.0, R = 0.0
        O = l
        l = l + 112 | 0
        H = O + 48 | 0
        I = O + 16 | 0
        J = O
        c[I >> 2] = 0
        c[I + 4 >> 2] = 0
        c[I + 8 >> 2] = 0
        c[I + 12 >> 2] = 0
        c[I + 16 >> 2] = 0
        c[I + 20 >> 2] = 0
        c[I + 24 >> 2] = 0
        c[I + 28 >> 2] = 0
        K = e + 4 | 0
        L = f + 16 | 0
        M = f + 32 | 0
        N = I + 16 | 0
        r = b[K >> 1] | 0
        n = r << 16 >> 16
        g = 0
        j = -1.0
        m = 0
        while (1) {
          if ((m | 0) >= (n | 0)) {
            g = 1
            break
          }
          i = c[e >> 2] | 0
          if ((b[i + (m * 24 | 0) + 4 >> 1] | 0) > 1) {
            g = 0
            break
          }
          i = c[(c[i + (m * 24 | 0) >> 2] | 0) + 4 >> 2] | 0
          if (!i) {
            k = +h[M >> 3]
            h[N >> 3] = k
            i = L
          } else {
            if (c[i + 24 >> 2] & 127 | 0) {
              g = 0
              break
            }
            k = +h[(+h[i + 16 >> 3] > 0.0 ? i : L) + 16 >> 3]
            h[N >> 3] = k
            i = (c[i >> 2] | 0) == 0 ? L : i
          }
          i = c[i >> 2] | 0
          c[I >> 2] = i
          if (!(j == -1.0)) {
            if (k != j) {
              g = 0
              break
            }
          } else {
            j = k
          }
          if (g) {
            if (a$(i, g) | 0) {
              g = 0
              break
            }
          } else {
            g = i
          }
          m = m + 1 | 0
        }
        a[e + 6 >> 0] = g
        E = f + 48 | 0
        F = f + 20 | 0
        G = I + 4 | 0
        w = f + 40 | 0
        x = I + 24 | 0
        y = d + 144 | 0
        z = H + 4 | 0
        v = J + 8 | 0
        A = H + 16 | 0
        B = H + 24 | 0
        C = H + 8 | 0
        D = H + 12 | 0
        f = (g | 0) == 0
        j = 0.0
        s = 0.0
        t = 0.0
        u = 0.0
        n = 0
        g = r
        while (1) {
          if ((n | 0) >= (g << 16 >> 16 | 0)) {
            break
          }
          k = 0.0
          q = 0.0
          m = 0
          p = 0.0
          j = 0.0
          i = c[e >> 2] | 0
          while (1) {
            if ((m | 0) >= (b[i + (n * 24 | 0) + 4 >> 1] | 0)) {
              break
            }
            c[H >> 2] = oH(c[(c[i + (n * 24 | 0) >> 2] | 0) + (m * 56 | 0) >> 2] | 0, c[E >> 2] | 0) | 0
            i = (c[e >> 2] | 0) + (n * 24 | 0) | 0
            g = c[(c[i >> 2] | 0) + (m * 56 | 0) + 4 >> 2] | 0
            if (!g) {
              h[N >> 3] = +h[M >> 3]
              c[I >> 2] = c[L >> 2]
              c[G >> 2] = c[F >> 2]
              c[x >> 2] = c[x >> 2] & -128 | c[w >> 2] & 127
            } else {
              g = c[g + 24 >> 2] & 127
              if (!g) {
                g = c[w >> 2] & 127
              }
              c[x >> 2] = c[x >> 2] & -128 | g
              r = c[(c[i >> 2] | 0) + (m * 56 | 0) + 4 >> 2] | 0
              h[N >> 3] = +h[(+h[r + 16 >> 3] > 0.0 ? r : L) + 16 >> 3]
              c[I >> 2] = c[((c[r >> 2] | 0) == 0 ? L : r) >> 2]
              c[G >> 2] = c[((c[r + 4 >> 2] | 0) == 0 ? L : r) + 4 >> 2]
            }
            i = c[y >> 2] | 0
            c[z >> 2] = nb[c[i >> 2] & 63](i, I, 1) | 0
            vL(J, d, H)
            Q = +h[J >> 3]
            o = +h[v >> 3]
            C_(c[(c[(c[e >> 2] | 0) + (n * 24 | 0) >> 2] | 0) + (m * 56 | 0) >> 2] | 0)
            i = c[e >> 2] | 0
            r = c[i + (n * 24 | 0) >> 2] | 0
            c[r + (m * 56 | 0) >> 2] = c[H >> 2]
            h[r + (m * 56 | 0) + 32 >> 3] = Q
            h[r + (m * 56 | 0) + 16 >> 3] = +h[A >> 3]
            h[r + (m * 56 | 0) + 24 >> 3] = +h[B >> 3]
            c[r + (m * 56 | 0) + 4 >> 2] = c[z >> 2]
            c[r + (m * 56 | 0) + 8 >> 2] = c[C >> 2]
            c[r + (m * 56 | 0) + 12 >> 2] = c[D >> 2]
            P = +h[N >> 3]
            R = +h[B >> 3]
            k = R > k ? R : k
            q = Q + q
            m = m + 1 | 0
            p = P > p ? P : p
            j = o > j ? o : j
          }
          h[i + (n * 24 | 0) + 8 >> 3] = q
          g = (n | 0) == 0
          do {
            if (f) {
              if (g) {
                o = p
                k = p - k
                g = i
                break
              } else {
                o = p
                k = t - u + p - k
                g = i + (n * 24 | 0) | 0
                break
              }
            } else {
              o = j
              k = g ? p : j
              g = i + (n * 24 | 0) | 0
            }
          } while (0)
          h[g + 16 >> 3] = k
          s = q > s ? q : s
          t = o + t
          u = +h[i + (n * 24 | 0) + 16 >> 3] + u
          n = n + 1 | 0
          g = b[K >> 1] | 0
        }
        h[e + 24 >> 3] = s
        h[e + 32 >> 3] = g << 16 >> 16 == 1 ? j : t
        l = O
        return
      }

      function qR(e, f, g) {
        e = e | 0
        f = f | 0
        g = g | 0
        var i = 0, j = 0, k = 0.0, m = 0.0, n = 0.0, o = 0.0, p = 0.0, q = 0.0, r = 0, s = 0, t = 0, u = 0, v = 0,
            w = 0, x = 0, y = 0, z = 0.0, A = 0.0
        y = l
        l = l + 64 | 0
        v = y + 32 | 0
        x = y
        j = e + 24 | 0
        if ((c[j >> 2] | 0) == 0 ? (i = c[(c[e + 96 >> 2] | 0) + 24 >> 2] | 0, i | 0) : 0) {
          c[j >> 2] = m1(i) | 0
        }
        t = e + 36 | 0
        w = b[t >> 1] | 0
        i = w & 65535
        a:do {
          if (i & 1) {
            k = +h[e + 64 >> 3]
            q = +h[e + 72 >> 3]
            j = f + 16 | 0
            m = +h[j >> 3]
            o = +h[f >> 3]
            n = m - o - k
            b:do {
              if (n > 0.0) {
                switch (i & 6) {
                  case 4: {
                    m = o + k
                    h[j >> 3] = m
                    k = o
                    break b
                  }
                  case 2: {
                    m = n + m
                    h[j >> 3] = m
                    k = o + n
                    h[f >> 3] = k
                    break b
                  }
                  default: {
                    p = n * .5
                    k = p + o
                    h[f >> 3] = k
                    m = m - p
                    h[j >> 3] = m
                    break b
                  }
                }
              } else {
                k = o
              }
            } while (0)
            i = f + 24 | 0
            p = +h[i >> 3]
            j = f + 8 | 0
            n = +h[j >> 3]
            o = p - n - q
            if (o > 0.0) {
              switch (w & 24) {
                case 16: {
                  o = n + q
                  h[i >> 3] = o
                  break a
                }
                case 8: {
                  q = o + p
                  h[i >> 3] = q
                  n = n + o
                  h[j >> 3] = n
                  o = q
                  break a
                }
                default: {
                  o = o * .5
                  n = o + n
                  h[j >> 3] = n
                  o = p - o
                  h[i >> 3] = o
                  break a
                }
              }
            } else {
              o = p
            }
          } else {
            k = +h[f >> 3]
            n = +h[f + 8 >> 3]
            m = +h[f + 16 >> 3]
            o = +h[f + 24 >> 3]
          }
        } while (0)
        s = e + 48 | 0
        c[s >> 2] = c[f >> 2]
        c[s + 4 >> 2] = c[f + 4 >> 2]
        c[s + 8 >> 2] = c[f + 8 >> 2]
        c[s + 12 >> 2] = c[f + 12 >> 2]
        c[s + 16 >> 2] = c[f + 16 >> 2]
        c[s + 20 >> 2] = c[f + 20 >> 2]
        c[s + 24 >> 2] = c[f + 24 >> 2]
        c[s + 28 >> 2] = c[f + 28 >> 2]
        a[e + 35 >> 0] = g
        A = +(d[e + 33 >> 0] | 0)
        z = +(d[e + 34 >> 0] | 0)
        p = k + A + z
        h[x >> 3] = p
        q = n + A + z
        s = x + 8 | 0
        h[s >> 3] = q
        n = m - A - z
        f = x + 16 | 0
        h[f >> 3] = n
        o = o - A - z
        r = x + 24 | 0
        h[r >> 3] = o
        j = e + 88 | 0
        switch (a[e + 92 >> 0] | 0) {
          case 1: {
            w = c[j >> 2] | 0
            c[v >> 2] = c[x >> 2]
            c[v + 4 >> 2] = c[x + 4 >> 2]
            c[v + 8 >> 2] = c[x + 8 >> 2]
            c[v + 12 >> 2] = c[x + 12 >> 2]
            c[v + 16 >> 2] = c[x + 16 >> 2]
            c[v + 20 >> 2] = c[x + 20 >> 2]
            c[v + 24 >> 2] = c[x + 24 >> 2]
            c[v + 28 >> 2] = c[x + 28 >> 2]
            oR(w, v, g)
            break
          }
          case 3: {
            i = c[j >> 2] | 0
            k = +h[i + 24 >> 3]
            m = n - p - +h[i + 16 >> 3]
            c:do {
              if (m > 0.0) {
                switch (w & 6) {
                  case 4: {
                    h[f >> 3] = n - m
                    break c
                  }
                  case 2: {
                    h[x >> 3] = m + p
                    break c
                  }
                  default:
                    break c
                }
              }
            } while (0)
            k = o - q - k
            d:do {
              if (k > 0.0) {
                switch (w & 24) {
                  case 16: {
                    h[r >> 3] = o - k
                    break d
                  }
                  case 8: {
                    h[s >> 3] = k + q
                    break d
                  }
                  default:
                    break d
                }
              }
            } while (0)
            c[v >> 2] = c[x >> 2]
            c[v + 4 >> 2] = c[x + 4 >> 2]
            c[v + 8 >> 2] = c[x + 8 >> 2]
            c[v + 12 >> 2] = c[x + 12 >> 2]
            c[v + 16 >> 2] = c[x + 16 >> 2]
            c[v + 20 >> 2] = c[x + 20 >> 2]
            c[v + 24 >> 2] = c[x + 24 >> 2]
            c[v + 28 >> 2] = c[x + 28 >> 2]
            rR(i, v)
            break
          }
          default: {
            i = c[j >> 2] | 0
            k = +h[i + 32 >> 3]
            m = n - p - +h[i + 24 >> 3]
            e:do {
              if (m > 0.0 ? (u = w & 6, u << 16 >> 16 != 6) : 0) {
                switch (u & 7) {
                  case 4: {
                    h[f >> 3] = n - m
                    break e
                  }
                  case 2: {
                    h[x >> 3] = m + p
                    break e
                  }
                  default: {
                    A = m * .5
                    h[x >> 3] = A + p
                    h[f >> 3] = n - A
                    break e
                  }
                }
              }
            } while (0)
            k = o - q - k
            f:do {
              if (k > 0.0) {
                switch (w & 24) {
                  case 16: {
                    h[r >> 3] = o - k
                    break f
                  }
                  case 8: {
                    h[s >> 3] = k + q
                    break f
                  }
                  default: {
                    A = k * .5
                    h[s >> 3] = A + q
                    h[r >> 3] = o - A
                    break f
                  }
                }
              }
            } while (0)
            w = i + 8 | 0
            c[w >> 2] = c[x >> 2]
            c[w + 4 >> 2] = c[x + 4 >> 2]
            c[w + 8 >> 2] = c[x + 8 >> 2]
            c[w + 12 >> 2] = c[x + 12 >> 2]
            c[w + 16 >> 2] = c[x + 16 >> 2]
            c[w + 20 >> 2] = c[x + 20 >> 2]
            c[w + 24 >> 2] = c[x + 24 >> 2]
            c[w + 28 >> 2] = c[x + 28 >> 2]
            x = b[t >> 1] & 768
            sR(c[j >> 2] | 0, (x & 1023) == 512 ? 108 : (x & 1023) == 256 ? 114 : 110)
          }
        }
        l = y
        return
      }

      function rR(a, b) {
        a = a | 0
        b = b | 0
        c[a >> 2] = c[b >> 2]
        c[a + 4 >> 2] = c[b + 4 >> 2]
        c[a + 8 >> 2] = c[b + 8 >> 2]
        c[a + 12 >> 2] = c[b + 12 >> 2]
        c[a + 16 >> 2] = c[b + 16 >> 2]
        c[a + 20 >> 2] = c[b + 20 >> 2]
        c[a + 24 >> 2] = c[b + 24 >> 2]
        c[a + 28 >> 2] = c[b + 28 >> 2]
        return
      }

      function sR(d, e) {
        d = d | 0
        e = e | 0
        var f = 0, g = 0, h = 0
        g = b[d + 4 >> 1] | 0
        f = 0
        while (1) {
          if ((f | 0) >= (g | 0)) {
            break
          }
          h = (c[d >> 2] | 0) + (f * 24 | 0) + 6 | 0
          if (!(a[h >> 0] | 0)) {
            a[h >> 0] = e
          }
          f = f + 1 | 0
        }
        return
      }

      function tR(d, f, g) {
        d = d | 0
        f = f | 0
        g = g | 0
        var h = 0, i = 0, j = 0, k = 0, l = 0, m = 0, n = 0, o = 0, p = 0, q = 0, r = 0, s = 0, t = 0, u = 0, v = 0
        l = f + 84 | 0
        t = c[l >> 2] | 0
        u = uI() | 0
        v = xR() | 0
        i = 0
        h = 0
        k = zw(t) | 0
        while (1) {
          if (!k) {
            break
          }
          j = zw(c[k + 8 >> 2] | 0) | 0
          while (1) {
            if (!j) {
              break
            }
            j = c[j >> 2] | 0
            i = i + 1 | 0
          }
          h = h + 1 | 0
          if (a[k + 12 >> 0] | 0) {
            BR(v, h)
          }
          k = c[k >> 2] | 0
        }
        h = tH((i << 2) + 4 | 0) | 0
        c[l >> 2] = h
        i = 0
        j = 0
        k = 0
        q = 0
        r = zw(t) | 0
        while (1) {
          if (!r) {
            break
          }
          s = q & 65535
          p = 0
          o = zw(c[r + 8 >> 2] | 0) | 0
          while (1) {
            if (!o) {
              break
            }
            n = c[o + 8 >> 2] | 0
            c[h >> 2] = n
            k = uR(d, n, f, g) | 0 | k
            l = vR(u, q, p, n) | 0
            b[n + 86 >> 1] = s
            b[n + 84 >> 1] = l
            l = l + (e[n + 80 >> 1] | 0) | 0
            m = q + (e[n + 82 >> 1] | 0) | 0
            if (CR(v, m) | 0) {
              p = n + 100 | 0
              a[p >> 0] = a[p >> 0] | 2
            }
            p = l
            h = h + 4 | 0
            o = c[o >> 2] | 0
            i = (l | 0) > (i | 0) ? l : i
            j = (m | 0) > (j | 0) ? m : j
          }
          q = q + 1 | 0
          r = c[r >> 2] | 0
        }
        c[f + 100 >> 2] = j
        c[f + 104 >> 2] = i
        xw(t) | 0
        xw(v) | 0
        xI(u)
        return k | 0
      }

      function uR(f, g, i, j) {
        f = f | 0
        g = g | 0
        i = i | 0
        j = j | 0
        var k = 0.0, m = 0.0, n = 0, o = 0, p = 0, q = 0, r = 0, s = 0, t = 0, u = 0, v = 0.0
        u = l
        l = l + 16 | 0
        t = u + 8 | 0
        s = u
        c[g + 96 >> 2] = i
        q = g + 36 | 0
        o = b[q >> 1] | 0
        if (!(o & 64)) {
          if (!(b[i + 36 >> 1] & 64)) {
            n = 2
          } else {
            n = a[i + 34 >> 0] | 0
          }
          a[g + 34 >> 0] = n
        }
        if (!(o & 32)) {
          n = a[i + 88 >> 0] | 0
          if (n << 24 >> 24 <= -1) {
            if (!(b[i + 36 >> 1] & 32)) {
              n = 1
            } else {
              n = a[i + 33 >> 0] | 0
            }
          }
          a[g + 33 >> 0] = n
        }
        n = g + 88 | 0
        p = g + 92 | 0
        switch (a[p >> 0] | 0) {
          case 1: {
            o = mR(f, c[n >> 2] | 0, g, j) | 0
            i = c[n >> 2] | 0
            n = o
            o = i + 64 | 0
            i = i + 72 | 0
            break
          }
          case 3: {
            o = wR(c[n >> 2] | 0, j) | 0
            i = c[n >> 2] | 0
            n = o
            o = i + 16 | 0
            i = i + 24 | 0
            break
          }
          default: {
            pR(c[(c[f + 16 >> 2] | 0) + 144 >> 2] | 0, c[n >> 2] | 0, j)
            i = c[n >> 2] | 0
            n = 0
            o = i + 24 | 0
            i = i + 32 | 0
          }
        }
        k = +((d[g + 33 >> 0] | 0) + (d[g + 34 >> 0] | 0) << 1 | 0)
        m = +h[o >> 3] + k
        k = +h[i >> 3] + k
        i = g + 38 | 0
        do {
          if (b[q >> 1] & 1) {
            o = b[i >> 1] | 0
            if (o << 16 >> 16 ? (r = b[g + 40 >> 1] | 0, r << 16 >> 16) : 0) {
              if (!(m > +(o & 65535) | k > +(r & 65535))) {
                m = 0.0
                k = 0.0
                break
              }
              if ((a[p >> 0] | 0) == 3) {
                m = 0.0
                k = 0.0
                break
              }
              Ow(0, 134532, s) | 0
              n = 1
              m = 0.0
              k = 0.0
              break
            }
            Ow(0, 134565, t) | 0
            n = 1
          }
        } while (0)
        v = +(e[i >> 1] | 0)
        h[g + 64 >> 3] = m > v ? m : v
        m = +(e[g + 40 >> 1] | 0)
        h[g + 72 >> 3] = k > m ? k : m
        l = u
        return n | 0
      }

      function vR(a, b, c, d) {
        a = a | 0
        b = b | 0
        c = c | 0
        d = d | 0
        var f = 0, g = 0, h = 0, i = 0, j = 0
        j = d + 80 | 0
        i = (e[j >> 1] | 0) + -1 | 0
        h = 0
        a:while (1) {
          f = c
          while (1) {
            if (h) {
              break a
            }
            g = i + f | 0
            while (1) {
              if ((g | 0) < (f | 0)) {
                c = f
                h = 1
                continue a
              }
              if (CI(a, g, b) | 0) {
                break
              }
              g = g + -1 | 0
            }
            f = g + 1 | 0
          }
        }
        h = d + 82 | 0
        f = c
        while (1) {
          if ((f | 0) < (c + (e[j >> 1] | 0) | 0)) {
            g = b
          } else {
            break
          }
          while (1) {
            if ((g | 0) >= ((e[h >> 1] | 0) + b | 0)) {
              break
            }
            AI(a, f, g)
            g = g + 1 | 0
          }
          f = f + 1 | 0
        }
        return c | 0
      }

      function wR(b, d) {
        b = b | 0
        d = d | 0
        var e = 0.0, f = 0.0, g = 0, i = 0, j = 0, k = 0, m = 0
        m = l
        l = l + 16 | 0
        j = m
        i = m + 8 | 0
        d = d + 52 | 0
        g = b + 32 | 0
        BC(i, c[d >> 2] | 0, c[g >> 2] | 0)
        k = c[i >> 2] | 0
        i = c[i + 4 >> 2] | 0
        if ((i & k | 0) == -1) {
          c[j >> 2] = c[g >> 2]
          Ow(1, 134615, j) | 0
          d = 1
          f = 0.0
          e = 0.0
        } else {
          a[(c[(c[d >> 2] | 0) + 16 >> 2] | 0) + 114 >> 0] = 1
          d = 0
          f = +(i | 0)
          e = +(k | 0)
        }
        c[b >> 2] = 0
        c[b + 4 >> 2] = 0
        c[b + 8 >> 2] = 0
        c[b + 12 >> 2] = 0
        h[b + 16 >> 3] = e
        h[b + 24 >> 3] = f
        l = m
        return d | 0
      }

      function xR() {
        return Bw(55820, c[4555] | 0) | 0
      }

      function yR(a, b, d) {
        a = a | 0
        b = b | 0
        d = d | 0
        d = tH(12) | 0
        c[d >> 2] = c[b >> 2]
        return d | 0
      }

      function zR(a, b, c) {
        a = a | 0
        b = b | 0
        c = c | 0
        C_(b)
        return
      }

      function AR(a, b, d, e) {
        a = a | 0
        b = b | 0
        d = d | 0
        e = e | 0
        b = c[b >> 2] | 0
        e = c[d >> 2] | 0
        return ((b | 0) > (e | 0) ? 1 : ((b | 0) < (e | 0)) << 31 >> 31) | 0
      }

      function BR(a, b) {
        a = a | 0
        b = b | 0
        var d = 0, e = 0
        d = l
        l = l + 16 | 0
        e = d
        c[e >> 2] = b
        nb[c[a >> 2] & 63](a, e, 1) | 0
        l = d
        return
      }

      function CR(a, b) {
        a = a | 0
        b = b | 0
        var d = 0, e = 0
        d = l
        l = l + 16 | 0
        e = d
        c[e >> 2] = b
        b = (nb[c[a >> 2] & 63](a, e, 512) | 0) != 0 & 1
        l = d
        return b | 0
      }

      function DR(a) {
        a = a | 0
        var b = 0
        if (!(c[46605] | 0)) {
          b = tH((a << 2) + 4 | 0) | 0
          c[46605] = b
          c[b >> 2] = 186424
          c[46616] = a
        }
        c[46617] = 0
        return
      }

      function ER() {
        C_(c[46605] | 0)
        c[46605] = 0
        c[46617] = 0
        return
      }

      function FR() {
        c[46617] = 0
        return
      }

      function GR() {
        var a = 0, b = 0, d = 0
        b = c[46617] | 0
        d = c[46605] | 0
        a = 1
        while (1) {
          if ((a | 0) > (b | 0)) {
            a = 5
            break
          }
          if ((c[(c[d + (a << 2) >> 2] | 0) + 4 >> 2] | 0) == (a | 0)) {
            a = a + 1 | 0
          } else {
            a = 4
            break
          }
        }
        if ((a | 0) == 4) {
          qa(135312, 134659, 59, 134665)
        } else if ((a | 0) == 5) {
          return
        }
      }

      function HR(a) {
        a = a | 0
        var b = 0, d = 0, e = 0, f = 0, g = 0, h = 0
        f = c[46605] | 0
        g = c[f + (a << 2) >> 2] | 0
        h = c[g >> 2] | 0
        while (1) {
          b = (a | 0) / 2 | 0
          d = c[f + (b << 2) >> 2] | 0
          e = f + (a << 2) | 0
          if ((c[d >> 2] | 0) >= (h | 0)) {
            break
          }
          c[e >> 2] = d
          c[d + 4 >> 2] = a
          a = b
        }
        c[e >> 2] = g
        c[g + 4 >> 2] = a
        return
      }

      function IR(a) {
        a = a | 0
        var b = 0, d = 0
        d = l
        l = l + 16 | 0
        b = c[46617] | 0
        if ((b | 0) == (c[46616] | 0)) {
          Ow(1, 134673, d) | 0
          a = 1
        } else {
          b = b + 1 | 0
          c[46617] = b
          c[(c[46605] | 0) + (b << 2) >> 2] = a
          HR(b)
          GR()
          a = 0
        }
        l = d
        return a | 0
      }

      function JR(a) {
        a = a | 0
        var b = 0, d = 0, e = 0, f = 0, g = 0, h = 0, i = 0, j = 0, k = 0, l = 0
        e = c[46605] | 0
        f = c[e + (a << 2) >> 2] | 0
        g = c[f >> 2] | 0
        h = c[46617] | 0
        i = (h | 0) / 2 | 0
        while (1) {
          if ((a | 0) > (i | 0)) {
            break
          }
          d = a << 1
          b = c[e + (d << 2) >> 2] | 0
          if ((d | 0) < (h | 0)) {
            l = d | 1
            j = c[e + (l << 2) >> 2] | 0
            k = (c[b >> 2] | 0) < (c[j >> 2] | 0)
            d = k ? l : d
            b = k ? j : b
          }
          if ((g | 0) >= (c[b >> 2] | 0)) {
            break
          }
          c[e + (a << 2) >> 2] = b
          c[b + 4 >> 2] = a
          a = d
        }
        c[e + (a << 2) >> 2] = f
        c[f + 4 >> 2] = a
        return
      }

      function KR() {
        var a = 0, b = 0, d = 0, e = 0
        b = c[46617] | 0
        if (!b) {
          a = 0
        } else {
          e = c[46605] | 0
          d = e + 4 | 0
          a = c[d >> 2] | 0
          c[d >> 2] = c[e + (b << 2) >> 2]
          b = b + -1 | 0
          c[46617] = b
          if (b | 0) {
            JR(1)
          }
          GR()
        }
        return a | 0
      }

      function LR(a, b) {
        a = a | 0
        b = b | 0
        c[a >> 2] = b
        HR(c[a + 4 >> 2] | 0)
        GR()
        return
      }

      function MR(b, d, e) {
        b = b | 0
        d = d | 0
        e = e | 0
        var f = 0, g = 0, i = 0, j = 0, k = 0, l = 0, m = 0, n = 0, o = 0
        m = b + 16 | 0
        j = c[m >> 2] | 0
        j = (a[j + ((c[e + 12 >> 2] | 0) * 40 | 0) + 36 >> 0] | 0) != (a[j + ((c[e + 16 >> 2] | 0) * 40 | 0) + 36 >> 0]
            | 0)
        k = ~~((+h[d + 64 >> 3] + -3.0 - +h[d + 48 >> 3]) * .5)
        l = ~~((+h[d + 56 >> 3] + -3.0 - +h[d + 40 >> 3]) * .5)
        g = (k | 0) < (l | 0) ? k : l
        n = d + 4 | 0
        f = 0
        while (1) {
          b = c[n >> 2] | 0
          if ((f | 0) >= (b | 0)) {
            g = f
            break
          }
          i = c[d + 8 + (f << 2) >> 2] | 0
          o = c[m >> 2] | 0
          if ((a[o + ((c[i + 12 >> 2] | 0) * 40 | 0) + 36 >> 0] | 0) == (a[o + ((c[i + 16 >> 2] | 0) * 40 | 0) + 36
          >> 0] | 0)) {
            g = f
            break
          }
          NR(i, g)
          f = f + 1 | 0
        }
        while (1) {
          if ((g | 0) >= (b | 0)) {
            break
          }
          f = c[d + 8 + (g << 2) >> 2] | 0
          if (j | (f | 0) == (e | 0)) {
            NR(f, a[(c[m >> 2] | 0) + ((c[f + 12 >> 2] | 0) * 40 | 0) + 36 >> 0] | 0 ? k : l)
            b = c[n >> 2] | 0
          }
          g = g + 1 | 0
        }
        return
      }

      function NR(a, b) {
        a = a | 0
        b = b | 0
        var d = 0, e = 0
        d = a + 8 | 0
        e = c[d >> 2] | 0
        c[d >> 2] = e + 1
        if ((e | 0) >= (b | 0)) {
          c[d >> 2] = 0
          h[a >> 3] = +h[a >> 3] + 16384.0
        }
        return
      }

      function OR(a, b) {
        a = a | 0
        b = b | 0
        var d = 0, e = 0, f = 0, g = 0, i = 0, j = 0, k = 0, m = 0, n = 0.0, o = 0.0, p = 0.0, q = 0.0, r = 0, s = 0,
            t = 0, u = 0, v = 0, w = 0, x = 0, y = 0.0, z = 0.0, A = 0.0, B = 0.0, C = 0, D = 0, E = 0.0
        x = l
        l = l + 112 | 0
        u = x + 64 | 0
        t = x + 96 | 0
        m = x + 32 | 0
        v = x
        w = tH(28) | 0
        b = $x(a) | 0
        s = w + 4 | 0
        c[s >> 2] = b
        b = tH(b * 72 | 0) | 0
        r = w + 12 | 0
        c[r >> 2] = b
        e = v + 8 | 0
        h[e >> 3] = 1797693134862315708145274.0e284
        h[v >> 3] = 1797693134862315708145274.0e284
        f = v + 24 | 0
        h[f >> 3] = -1797693134862315708145274.0e284
        g = v + 16 | 0
        h[g >> 3] = -1797693134862315708145274.0e284
        i = m + 16 | 0
        j = m + 8 | 0
        k = m + 24 | 0
        d = Ry(a) | 0
        n = 1797693134862315708145274.0e284
        o = 1797693134862315708145274.0e284
        p = -1797693134862315708145274.0e284
        q = -1797693134862315708145274.0e284
        while (1) {
          if (!d) {
            break
          }
          C = d + 16 | 0
          D = c[C >> 2] | 0
          z = (+h[D + 96 >> 3] + +h[D + 88 >> 3]) * .5
          z = z < 1.0 ? 1.0 : z
          y = +h[D + 80 >> 3] * .5
          y = y < 1.0 ? 1.0 : y
          E = +h[D + 16 >> 3]
          B = E - z
          h[m >> 3] = B
          z = E + z
          h[i >> 3] = z
          E = +h[D + 24 >> 3]
          A = E - y
          h[j >> 3] = A
          y = E + y
          h[k >> 3] = y
          B = +h[(n < B ? v : m) >> 3]
          h[v >> 3] = B
          A = +h[(o < A ? v : m) + 8 >> 3]
          h[e >> 3] = A
          z = +h[(p > z ? v : m) + 16 >> 3]
          h[g >> 3] = z
          y = +h[(q > y ? v : m) + 24 >> 3]
          h[f >> 3] = y
          D = b + 40 | 0
          c[D >> 2] = c[m >> 2]
          c[D + 4 >> 2] = c[m + 4 >> 2]
          c[D + 8 >> 2] = c[m + 8 >> 2]
          c[D + 12 >> 2] = c[m + 12 >> 2]
          c[D + 16 >> 2] = c[m + 16 >> 2]
          c[D + 20 >> 2] = c[m + 20 >> 2]
          c[D + 24 >> 2] = c[m + 24 >> 2]
          c[D + 28 >> 2] = c[m + 28 >> 2]
          c[b >> 2] = c[b >> 2] | 1
          c[(c[C >> 2] | 0) + 112 >> 2] = b
          b = b + 72 | 0
          d = Sy(a, d) | 0
          n = B
          o = A
          p = z
          q = y
        }
        h[v >> 3] = n + -36.0
        h[e >> 3] = o + -36.0
        h[g >> 3] = p + 36.0
        h[f >> 3] = q + 36.0
        D = c[r >> 2] | 0
        f = c[s >> 2] | 0
        c[u >> 2] = c[v >> 2]
        c[u + 4 >> 2] = c[v + 4 >> 2]
        c[u + 8 >> 2] = c[v + 8 >> 2]
        c[u + 12 >> 2] = c[v + 12 >> 2]
        c[u + 16 >> 2] = c[v + 16 >> 2]
        c[u + 20 >> 2] = c[v + 20 >> 2]
        c[u + 24 >> 2] = c[v + 24 >> 2]
        c[u + 28 >> 2] = c[v + 28 >> 2]
        f = YR(D, f, t, u) | 0
        if (c[46553] & 1 | 0) {
          r = c[r >> 2] | 0
          C = c[s >> 2] | 0
          D = c[t >> 2] | 0
          c[u >> 2] = c[v >> 2]
          c[u + 4 >> 2] = c[v + 4 >> 2]
          c[u + 8 >> 2] = c[v + 8 >> 2]
          c[u + 12 >> 2] = c[v + 12 >> 2]
          c[u + 16 >> 2] = c[v + 16 >> 2]
          c[u + 20 >> 2] = c[v + 20 >> 2]
          c[u + 24 >> 2] = c[v + 24 >> 2]
          c[u + 28 >> 2] = c[v + 28 >> 2]
          PR(r, C, u, f, D)
        }
        e = w + 8 | 0
        c[e >> 2] = tH((c[t >> 2] | 0) * 72 | 0) | 0
        c[w >> 2] = c[t >> 2]
        d = c[t >> 2] | 0
        b = 0
        while (1) {
          if ((b | 0) >= (d | 0)) {
            break
          }
          D = (c[e >> 2] | 0) + (b * 72 | 0) + 40 | 0
          C = f + (b << 5) | 0
          c[D >> 2] = c[C >> 2]
          c[D + 4 >> 2] = c[C + 4 >> 2]
          c[D + 8 >> 2] = c[C + 8 >> 2]
          c[D + 12 >> 2] = c[C + 12 >> 2]
          c[D + 16 >> 2] = c[C + 16 >> 2]
          c[D + 20 >> 2] = c[C + 20 >> 2]
          c[D + 24 >> 2] = c[C + 24 >> 2]
          c[D + 28 >> 2] = c[C + 28 >> 2]
          b = b + 1 | 0
        }
        C_(f)
        c[u >> 2] = c[v >> 2]
        c[u + 4 >> 2] = c[v + 4 >> 2]
        c[u + 8 >> 2] = c[v + 8 >> 2]
        c[u + 12 >> 2] = c[v + 12 >> 2]
        c[u + 16 >> 2] = c[v + 16 >> 2]
        c[u + 20 >> 2] = c[v + 20 >> 2]
        c[u + 24 >> 2] = c[v + 24 >> 2]
        c[u + 28 >> 2] = c[v + 28 >> 2]
        c[w + 16 >> 2] = QR(w, u) | 0
        l = x
        return w | 0
      }

      function PR(a, b, d, e, f) {
        a = a | 0
        b = b | 0
        d = d | 0
        e = e | 0
        f = f | 0
        var g = 0.0, i = 0, j = 0, k = 0.0, m = 0.0, n = 0.0, o = 0, p = 0, q = 0, r = 0, s = 0, t = 0.0, u = 0.0,
            v = 0.0
        q = l
        l = l + 128 | 0
        p = q + 96 | 0
        o = q + 64 | 0
        j = q + 32 | 0
        r = q + 16 | 0
        s = q
        m = +h[d + 16 >> 3]
        n = +h[d >> 3]
        k = +h[d + 24 >> 3]
        g = +h[d + 8 >> 3]
        i = c[15686] | 0
        C1(134688, i) | 0
        c[s >> 2] = 10
        c[s + 4 >> 2] = 10
        c[s + 8 >> 2] = ~~(m + 10.0 - n)
        c[s + 12 >> 2] = ~~(k + 10.0 - g)
        f1(i, 135118, s) | 0
        h[r >> 3] = 10.0 - n
        h[r + 8 >> 3] = 10.0 - g
        f1(i, 135166, r) | 0
        C1(135183, i) | 0
        d = 0
        while (1) {
          if ((d | 0) >= (b | 0)) {
            break
          }
          v = +h[a + (d * 72 | 0) + 48 >> 3]
          u = +h[a + (d * 72 | 0) + 56 >> 3]
          t = +h[a + (d * 72 | 0) + 64 >> 3]
          h[j >> 3] = +h[a + (d * 72 | 0) + 40 >> 3]
          h[j + 8 >> 3] = v
          h[j + 16 >> 3] = u
          h[j + 24 >> 3] = t
          f1(i, 135202, j) | 0
          d = d + 1 | 0
        }
        C1(135220, i) | 0
        d = 0
        while (1) {
          if ((d | 0) >= (f | 0)) {
            break
          }
          t = +h[e + (d << 5) + 8 >> 3]
          u = +h[e + (d << 5) + 16 >> 3]
          v = +h[e + (d << 5) + 24 >> 3]
          h[o >> 3] = +h[e + (d << 5) >> 3]
          h[o + 8 >> 3] = t
          h[o + 16 >> 3] = u
          h[o + 24 >> 3] = v
          f1(i, 135239, o) | 0
          d = d + 1 | 0
        }
        C1(135257, i) | 0
        h[p >> 3] = n
        h[p + 8 >> 3] = g
        h[p + 16 >> 3] = m
        h[p + 24 >> 3] = k
        f1(i, 135239, p) | 0
        C1(135004, i) | 0
        l = q
        return
      }

      function QR(a, b) {
        a = a | 0
        b = b | 0
        var d = 0, e = 0.0, f = 0, g = 0, i = 0, j = 0, k = 0, m = 0, n = 0, o = 0, p = 0, q = 0, r = 0, s = 0, t = 0,
            u = 0, v = 0, w = 0, x = 0, y = 0, z = 0, A = 0, B = 0, C = 0, D = 0
        A = l
        l = l + 32 | 0
        t = A + 16 | 0
        k = A
        w = c[a >> 2] | 0
        y = mO(w << 2 | 2) | 0
        z = Bw(55856, c[4555] | 0) | 0
        v = Bw(55892, c[4555] | 0) | 0
        w = tH(w << 7) | 0
        f = tH(c[a >> 2] << 4) | 0
        x = a + 8 | 0
        g = b + 16 | 0
        i = k + 8 | 0
        j = b + 24 | 0
        m = b + 8 | 0
        d = 0
        while (1) {
          if ((d | 0) >= (c[a >> 2] | 0)) {
            break
          }
          n = c[x >> 2] | 0
          o = n + (d * 72 | 0) | 0
          c[n + (d * 72 | 0) + 32 >> 2] = 4
          p = n + (d * 72 | 0) + 36 | 0
          c[p >> 2] = f + (d << 2 << 2)
          q = n + (d * 72 | 0) + 40 | 0
          e = +h[n + (d * 72 | 0) + 56 >> 3]
          if (e < +h[g >> 3]) {
            h[k >> 3] = e
            h[i >> 3] = +h[n + (d * 72 | 0) + 48 >> 3]
            c[t >> 2] = c[k >> 2]
            c[t + 4 >> 2] = c[k + 4 >> 2]
            c[t + 8 >> 2] = c[k + 8 >> 2]
            c[t + 12 >> 2] = c[k + 12 >> 2]
            s = RR(y, z, t, w, 1) | 0
            c[s + 20 >> 2] = o
            c[c[p >> 2] >> 2] = s
          }
          e = +h[n + (d * 72 | 0) + 64 >> 3]
          if (e < +h[j >> 3]) {
            h[k >> 3] = +h[q >> 3]
            h[i >> 3] = e
            c[t >> 2] = c[k >> 2]
            c[t + 4 >> 2] = c[k + 4 >> 2]
            c[t + 8 >> 2] = c[k + 8 >> 2]
            c[t + 12 >> 2] = c[k + 12 >> 2]
            s = RR(y, v, t, w, 0) | 0
            c[s + 20 >> 2] = o
            c[(c[p >> 2] | 0) + 4 >> 2] = s
          }
          if (+h[q >> 3] > +h[b >> 3]) {
            c[t >> 2] = c[q >> 2]
            c[t + 4 >> 2] = c[q + 4 >> 2]
            c[t + 8 >> 2] = c[q + 8 >> 2]
            c[t + 12 >> 2] = c[q + 12 >> 2]
            s = RR(y, z, t, w, 1) | 0
            c[s + 24 >> 2] = o
            c[(c[p >> 2] | 0) + 8 >> 2] = s
          }
          if (+h[n + (d * 72 | 0) + 48 >> 3] > +h[m >> 3]) {
            c[t >> 2] = c[q >> 2]
            c[t + 4 >> 2] = c[q + 4 >> 2]
            c[t + 8 >> 2] = c[q + 8 >> 2]
            c[t + 12 >> 2] = c[q + 12 >> 2]
            s = RR(y, v, t, w, 0) | 0
            c[s + 24 >> 2] = o
            c[(c[p >> 2] | 0) + 12 >> 2] = s
          }
          d = d + 1 | 0
        }
        o = tH(c[y >> 2] << 2) | 0
        r = a + 4 | 0
        s = a + 12 | 0
        p = t + 8 | 0
        m = 0
        q = 0
        n = 0
        while (1) {
          d = c[r >> 2] | 0
          if ((n | 0) >= (d | 0)) {
            b = 0
            break
          }
          g = c[s >> 2] | 0
          i = g + (n * 72 | 0) | 0
          j = g + (n * 72 | 0) + 36 | 0
          c[j >> 2] = o + (m << 2)
          b = g + (n * 72 | 0) + 40 | 0
          c[t >> 2] = c[b >> 2]
          c[t + 4 >> 2] = c[b + 4 >> 2]
          c[t + 8 >> 2] = c[b + 8 >> 2]
          c[t + 12 >> 2] = c[b + 12 >> 2]
          b = g + (n * 72 | 0) + 56 | 0
          k = g + (n * 72 | 0) + 32 | 0
          d = nb[c[v >> 2] & 63](v, t, 512) | 0
          while (1) {
            if (!d) {
              break
            }
            if (!(+h[d + 8 >> 3] < +h[b >> 3])) {
              break
            }
            C = c[d >> 2] | 0
            B = c[j >> 2] | 0
            f = c[k >> 2] | 0
            c[k >> 2] = f + 1
            c[B + (f << 2) >> 2] = C
            c[(c[d >> 2] | 0) + 24 >> 2] = i
            d = nb[c[v >> 2] & 63](v, d, 8) | 0
          }
          f = g + (n * 72 | 0) + 64 | 0
          d = nb[c[z >> 2] & 63](z, t, 512) | 0
          while (1) {
            if (!d) {
              u = 20
              break
            }
            e = +h[f >> 3]
            if (!(+h[d + 16 >> 3] < e)) {
              break
            }
            b = c[d >> 2] | 0
            B = c[j >> 2] | 0
            C = c[k >> 2] | 0
            c[k >> 2] = C + 1
            c[B + (C << 2) >> 2] = b
            c[(c[d >> 2] | 0) + 24 >> 2] = i
            d = nb[c[z >> 2] & 63](z, d, 8) | 0
          }
          if ((u | 0) == 20) {
            u = 0
            e = +h[f >> 3]
          }
          h[p >> 3] = e
          b = g + (n * 72 | 0) + 56 | 0
          d = nb[c[v >> 2] & 63](v, t, 512) | 0
          while (1) {
            if (!d) {
              u = 25
              break
            }
            e = +h[b >> 3]
            if (!(+h[d + 8 >> 3] < e)) {
              break
            }
            D = c[d >> 2] | 0
            B = c[j >> 2] | 0
            C = c[k >> 2] | 0
            c[k >> 2] = C + 1
            c[B + (C << 2) >> 2] = D
            c[(c[d >> 2] | 0) + 20 >> 2] = i
            d = nb[c[v >> 2] & 63](v, d, 8) | 0
          }
          if ((u | 0) == 25) {
            u = 0
            e = +h[b >> 3]
          }
          h[t >> 3] = e
          h[p >> 3] = +h[g + (n * 72 | 0) + 48 >> 3]
          d = nb[c[z >> 2] & 63](z, t, 512) | 0
          while (1) {
            if (!d) {
              break
            }
            if (!(+h[d + 16 >> 3] < +h[f >> 3])) {
              break
            }
            B = c[d >> 2] | 0
            C = c[j >> 2] | 0
            D = c[k >> 2] | 0
            c[k >> 2] = D + 1
            c[C + (D << 2) >> 2] = B
            c[(c[d >> 2] | 0) + 20 >> 2] = i
            d = nb[c[z >> 2] & 63](z, d, 8) | 0
          }
          D = c[k >> 2] | 0
          m = D + m | 0
          q = (D | 0) > (q | 0) ? D : q
          n = n + 1 | 0
        }
        while (1) {
          if ((b | 0) >= (d | 0)) {
            break
          }
          SR((c[s >> 2] | 0) + (b * 72 | 0) | 0)
          b = b + 1 | 0
          d = c[r >> 2] | 0
        }
        d = c[y >> 2] | 0
        D = c[y + 16 >> 2] | 0
        c[D + (d * 40 | 0) + 32 >> 2] = d
        d = d + 1 | 0
        c[D + (d * 40 | 0) + 32 >> 2] = d
        lO(y, q)
        d = 0
        while (1) {
          if ((d | 0) >= (c[a >> 2] | 0)) {
            break
          }
          TR((c[x >> 2] | 0) + (d * 72 | 0) | 0, y)
          d = d + 1 | 0
        }
        xw(z) | 0
        xw(v) | 0
        C_(w)
        UR(y)
        jO(y)
        l = A
        return y | 0
      }

      function RR(b, d, e, f, g) {
        b = b | 0
        d = d | 0
        e = e | 0
        f = f | 0
        g = g | 0
        var h = 0, i = 0
        h = nb[c[d >> 2] & 63](d, e, 512) | 0
        do {
          if (!h) {
            b = nO(b) | 0
            if (!f) {
              qa(135101, 135049, 291, 135108)
            } else {
              h = c[b + 32 >> 2] | 0
              i = f + (h << 5) | 0
              f = f + (h << 5) + 8 | 0
              c[f >> 2] = c[e >> 2]
              c[f + 4 >> 2] = c[e + 4 >> 2]
              c[f + 8 >> 2] = c[e + 8 >> 2]
              c[f + 12 >> 2] = c[e + 12 >> 2]
              c[i >> 2] = b
              a[b + 36 >> 0] = g
              nb[c[d >> 2] & 63](d, i, 1) | 0
              break
            }
          } else {
            i = h
          }
        } while (0)
        return c[i >> 2] | 0
      }

      function SR(b) {
        b = b | 0
        var d = 0, e = 0, f = 0, g = 0, i = 0, j = 0
        a:do {
          if ((+h[b + 64 >> 3] + -3.0 - +h[b + 48 >> 3]) * .5 < 2.0) {
            i = c[b + 32 >> 2] | 0
            j = b + 36 | 0
            g = 0
            while (1) {
              if ((g | 0) >= (i | 0)) {
                break a
              }
              d = c[(c[j >> 2] | 0) + (g << 2) >> 2] | 0
              b:do {
                if (a[d + 36 >> 0] | 0) {
                  f = c[d + 20 >> 2] | 0
                  if ((f | 0) == (b | 0)) {
                    e = c[d + 24 >> 2] | 0
                    d = e
                    e = c[e >> 2] | 0
                    do {
                      c[d >> 2] = e | 8
                      d = c[c[d + 36 >> 2] >> 2] | 0
                      if (!d) {
                        break b
                      }
                      d = c[d + 24 >> 2] | 0
                      e = c[d >> 2] | 0
                    } while (!(e & 1 | 0))
                  } else {
                    e = f
                    d = c[f >> 2] | 0
                    do {
                      c[e >> 2] = d | 8
                      d = c[(c[e + 36 >> 2] | 0) + 8 >> 2] | 0
                      if (!d) {
                        break b
                      }
                      e = c[d + 20 >> 2] | 0
                      d = c[e >> 2] | 0
                    } while (!(d & 1 | 0))
                  }
                }
              } while (0)
              g = g + 1 | 0
            }
          }
        } while (0)
        c:do {
          if ((+h[b + 56 >> 3] + -3.0 - +h[b + 40 >> 3]) * .5 < 2.0) {
            i = c[b + 32 >> 2] | 0
            j = b + 36 | 0
            g = 0
            while (1) {
              if ((g | 0) >= (i | 0)) {
                break c
              }
              d = c[(c[j >> 2] | 0) + (g << 2) >> 2] | 0
              d:do {
                if (!(a[d + 36 >> 0] | 0)) {
                  f = c[d + 20 >> 2] | 0
                  if ((f | 0) == (b | 0)) {
                    e = c[d + 24 >> 2] | 0
                    d = e
                    e = c[e >> 2] | 0
                    do {
                      c[d >> 2] = e | 16
                      d = c[(c[d + 36 >> 2] | 0) + 4 >> 2] | 0
                      if (!d) {
                        break d
                      }
                      d = c[d + 24 >> 2] | 0
                      e = c[d >> 2] | 0
                    } while (!(e & 1 | 0))
                  } else {
                    e = f
                    d = c[f >> 2] | 0
                    do {
                      c[e >> 2] = d | 16
                      d = c[(c[e + 36 >> 2] | 0) + 12 >> 2] | 0
                      if (!d) {
                        break d
                      }
                      e = c[d + 20 >> 2] | 0
                      d = c[e >> 2] | 0
                    } while (!(d & 1 | 0))
                  }
                }
              } while (0)
              g = g + 1 | 0
            }
          }
        } while (0)
        return
      }

      function TR(a, b) {
        a = a | 0
        b = b | 0
        var d = 0, e = 0, f = 0.0, g = 0.0, i = 0.0, j = 0, k = 0, l = 0, m = 0, n = 0, o = 0, p = 0.0, q = 0
        g = +h[a + 56 >> 3] - +h[a + 40 >> 3]
        i = +h[a + 64 >> 3] - +h[a + 48 >> 3]
        f = (i + g) * .5 + 500.0
        if ((i + -3.0) * .5 < 2.0) {
          l = (c[a >> 2] & 8 | 0) == 0
          f = l ? 16384.0 : f
          p = l ? 16384.0 : g
        } else {
          p = g
        }
        if ((g + -3.0) * .5 < 2.0) {
          l = (c[a >> 2] & 16 | 0) == 0
          i = l ? 16384.0 : i
          f = l ? 16384.0 : f
        }
        l = a + 36 | 0
        d = c[l >> 2] | 0
        e = c[d + 8 >> 2] | 0
        if ((e | 0) != 0 ? (j = c[d + 4 >> 2] | 0, (j | 0) != 0) : 0) {
          j = oO(b, e, j, f) | 0
          e = a + 4 | 0
          d = c[e >> 2] | 0
          c[e >> 2] = d + 1
          c[a + 8 + (d << 2) >> 2] = j
          d = c[l >> 2] | 0
        }
        e = c[d + 4 >> 2] | 0
        if ((e | 0) != 0 ? (k = c[d >> 2] | 0, (k | 0) != 0) : 0) {
          k = oO(b, e, k, f) | 0
          j = a + 4 | 0
          d = c[j >> 2] | 0
          c[j >> 2] = d + 1
          c[a + 8 + (d << 2) >> 2] = k
          d = c[l >> 2] | 0
        }
        e = c[d + 8 >> 2] | 0
        if ((e | 0) != 0 ? (m = c[d + 12 >> 2] | 0, (m | 0) != 0) : 0) {
          m = oO(b, e, m, f) | 0
          k = a + 4 | 0
          d = c[k >> 2] | 0
          c[k >> 2] = d + 1
          c[a + 8 + (d << 2) >> 2] = m
          d = c[l >> 2] | 0
        }
        e = c[d + 12 >> 2] | 0
        if ((e | 0) != 0 ? (n = c[d >> 2] | 0, (n | 0) != 0) : 0) {
          n = oO(b, e, n, f) | 0
          m = a + 4 | 0
          d = c[m >> 2] | 0
          c[m >> 2] = d + 1
          c[a + 8 + (d << 2) >> 2] = n
          d = c[l >> 2] | 0
        }
        e = c[d + 4 >> 2] | 0
        if ((e | 0) != 0 ? (o = c[d + 12 >> 2] | 0, (o | 0) != 0) : 0) {
          o = oO(b, e, o, i) | 0
          n = a + 4 | 0
          d = c[n >> 2] | 0
          c[n >> 2] = d + 1
          c[a + 8 + (d << 2) >> 2] = o
          d = c[l >> 2] | 0
        }
        e = c[d + 8 >> 2] | 0
        if (e | 0 ? (q = c[d >> 2] | 0, q | 0) : 0) {
          b = oO(b, e, q, p) | 0
          o = a + 4 | 0
          q = c[o >> 2] | 0
          c[o >> 2] = q + 1
          c[a + 8 + (q << 2) >> 2] = b
        }
        return
      }

      function UR(a) {
        a = a | 0
        var b = 0, d = 0, e = 0, f = 0, g = 0, h = 0, i = 0, j = 0
        j = l
        l = l + 16 | 0
        i = j + 8 | 0
        h = j
        f = a + 16 | 0
        g = c[15686] | 0
        e = 0
        while (1) {
          if ((e | 0) >= (c[a >> 2] | 0)) {
            b = 10
            break
          }
          b = c[f >> 2] | 0
          d = b + (e * 40 | 0) + 20 | 0
          if ((c[d >> 2] | 0) == 0 ? (c[h >> 2] = e, f1(g, 135014, h) | 0, (c[d >> 2] | 0) == 0) : 0) {
            b = 5
            break
          }
          b = b + (e * 40 | 0) + 24 | 0
          if ((c[b >> 2] | 0) == 0 ? (c[i >> 2] = e, f1(g, 135066, i) | 0, (c[b >> 2] | 0) == 0) : 0) {
            b = 8
            break
          }
          e = e + 1 | 0
        }
        if ((b | 0) == 5) {
          qa(135036, 135049, 311, 135056)
        } else if ((b | 0) == 8) {
          qa(135088, 135049, 313,
              135056)
        } else if ((b | 0) == 10) {
          l = j
          return
        }
      }

      function VR(a, b, c, d) {
        a = a | 0
        b = b | 0
        c = c | 0
        d = d | 0
        var e = 0.0, f = 0.0
        e = +h[b + 8 >> 3]
        f = +h[c + 8 >> 3]
        if (!(e > f)) {
          if (!(e < f)) {
            f = +h[b >> 3]
            e = +h[c >> 3]
            if (f > e) {
              a = 1
            } else {
              a = (f < e) << 31 >> 31
            }
          } else {
            a = -1
          }
        } else {
          a = 1
        }
        return a | 0
      }

      function WR(a, b, c, d) {
        a = a | 0
        b = b | 0
        c = c | 0
        d = d | 0
        var e = 0.0, f = 0.0
        e = +h[b >> 3]
        f = +h[c >> 3]
        if (!(e > f)) {
          if (!(e < f)) {
            f = +h[b + 8 >> 3]
            e = +h[c + 8 >> 3]
            if (f > e) {
              a = 1
            } else {
              a = (f < e) << 31 >> 31
            }
          } else {
            a = -1
          }
        } else {
          a = 1
        }
        return a | 0
      }

      function XR(a) {
        a = a | 0
        var b = 0, d = 0
        d = a + 8 | 0
        C_(c[(c[d >> 2] | 0) + 36 >> 2] | 0)
        b = a + 12 | 0
        C_(c[(c[b >> 2] | 0) + 36 >> 2] | 0)
        C_(c[d >> 2] | 0)
        C_(c[b >> 2] | 0)
        qO(c[a + 16 >> 2] | 0)
        xw(c[a + 20 >> 2] | 0) | 0
        xw(c[a + 24 >> 2] | 0) | 0
        C_(a)
        return
      }

      function YR(a, b, d, e) {
        a = a | 0
        b = b | 0
        d = d | 0
        e = e | 0
        var f = 0, g = 0, h = 0, i = 0, j = 0, k = 0, m = 0, n = 0, o = 0, p = 0, q = 0
        p = l
        l = l + 32 | 0
        h = p
        i = b << 2
        f = i + 4 | 0
        i = i + 5 | 0
        o = uH(i * 56 | 0) | 0
        i = tH(i << 2) | 0
        g = f * 5 | 1
        j = uH(g * 72 | 0) | 0
        m = g << 5
        k = tH(m) | 0
        m = tH(m) | 0
        c[h >> 2] = c[e >> 2]
        c[h + 4 >> 2] = c[e + 4 >> 2]
        c[h + 8 >> 2] = c[e + 8 >> 2]
        c[h + 12 >> 2] = c[e + 12 >> 2]
        c[h + 16 >> 2] = c[e + 16 >> 2]
        c[h + 20 >> 2] = c[e + 20 >> 2]
        c[h + 24 >> 2] = c[e + 24 >> 2]
        c[h + 28 >> 2] = c[e + 28 >> 2]
        ZR(a, b, h, o, 0)
        h2(173)
        _R(f, i)
        iS(f, o, i, g, j) | 0
        n = $R(f, o, j, 0, k) | 0
        c[h >> 2] = c[e >> 2]
        c[h + 4 >> 2] = c[e + 4 >> 2]
        c[h + 8 >> 2] = c[e + 8 >> 2]
        c[h + 12 >> 2] = c[e + 12 >> 2]
        c[h + 16 >> 2] = c[e + 16 >> 2]
        c[h + 20 >> 2] = c[e + 20 >> 2]
        c[h + 24 >> 2] = c[e + 24 >> 2]
        c[h + 28 >> 2] = c[e + 28 >> 2]
        ZR(a, b, h, o, 1)
        _R(f, i)
        iS(f, o, i, g, j) | 0
        f = $R(f, o, j, 1, m) | 0
        g = tH(O(n << 5, f) | 0) | 0
        b = 0
        a = 0
        while (1) {
          if ((b | 0) >= (f | 0)) {
            break
          }
          h = m + (b << 5) | 0
          e = 0
          while (1) {
            if ((e | 0) >= (n | 0)) {
              break
            }
            q = a + ((aS(g + (a << 5) | 0, h, k + (e << 5) | 0) | 0) != 0 & 1) | 0
            e = e + 1 | 0
            a = q
          }
          b = b + 1 | 0
        }
        q = wH(g, a << 5) | 0
        C_(o)
        C_(i)
        C_(j)
        C_(k)
        C_(m)
        c[d >> 2] = a
        l = p
        return q | 0
      }

      function ZR(a, b, d, e, f) {
        a = a | 0
        b = b | 0
        d = d | 0
        e = e | 0
        f = f | 0
        var g = 0, h = 0, i = 0, j = 0, k = 0
        j = l
        l = l + 96 | 0
        h = j + 64 | 0
        i = j
        c[h >> 2] = c[d >> 2]
        c[h + 4 >> 2] = c[d + 4 >> 2]
        c[h + 8 >> 2] = c[d + 8 >> 2]
        c[h + 12 >> 2] = c[d + 12 >> 2]
        c[h + 16 >> 2] = c[d + 16 >> 2]
        c[h + 20 >> 2] = c[d + 20 >> 2]
        c[h + 24 >> 2] = c[d + 24 >> 2]
        c[h + 28 >> 2] = c[d + 28 >> 2]
        gS(h, f, 1, i)
        d = hS(e, 1, i) | 0
        g = 0
        while (1) {
          if ((g | 0) >= (b | 0)) {
            break
          }
          k = a + (g * 72 | 0) + 40 | 0
          c[h >> 2] = c[k >> 2]
          c[h + 4 >> 2] = c[k + 4 >> 2]
          c[h + 8 >> 2] = c[k + 8 >> 2]
          c[h + 12 >> 2] = c[k + 12 >> 2]
          c[h + 16 >> 2] = c[k + 16 >> 2]
          c[h + 20 >> 2] = c[k + 20 >> 2]
          c[h + 24 >> 2] = c[k + 24 >> 2]
          c[h + 28 >> 2] = c[k + 28 >> 2]
          gS(h, f, 0, i)
          d = hS(e, d, i) | 0
          g = g + 1 | 0
        }
        l = j
        return
      }

      function _R(a, b) {
        a = a | 0
        b = b | 0
        var d = 0, e = 0, f = 0, g = 0, h = 0
        d = 0
        while (1) {
          if ((d | 0) > (a | 0)) {
            break
          }
          c[b + (d << 2) >> 2] = d
          d = d + 1 | 0
        }
        g = a + 1 | 0
        d = 1
        while (1) {
          if ((d | 0) > (a | 0)) {
            break
          }
          h = ~~(+j2() * +(g - d | 0) + +(d | 0))
          e = b + (d << 2) | 0
          f = b + (h << 2) | 0
          if ((d | 0) != (h | 0)) {
            h = c[e >> 2] | 0
            c[e >> 2] = c[f >> 2]
            c[f >> 2] = h
          }
          d = d + 1 | 0
        }
        return
      }

      function $R(a, b, d, e, f) {
        a = a | 0
        b = b | 0
        d = d | 0
        e = e | 0
        f = f | 0
        var g = 0, h = 0, i = 0, j = 0, k = 0, l = 0, m = 0, n = 0, o = 0
        g = a * 5 | 0
        j = g + 1 | 0
        l = tH(j << 2) | 0
        c[46618] = tH(j << 4) | 0
        c[46619] = tH((a * 56 | 0) + 56 | 0) | 0
        j = tH(a << 2) | 0
        c[46620] = j
        k = 0
        while (1) {
          if ((k | 0) > (g | 0)) {
            break
          }
          if (bS(d + (k * 72 | 0) | 0, b) | 0) {
            break
          }
          k = k + 1 | 0
        }
        h = c[46618] | 0
        i = c[46619] | 0
        g = 1
        while (1) {
          if ((g | 0) > (a | 0)) {
            break
          }
          c[h + (g << 4) + 8 >> 2] = c[b + (g * 56 | 0) + 48 >> 2]
          m = b + (g * 56 | 0) + 44 | 0
          c[h + (g << 4) + 4 >> 2] = c[m >> 2]
          c[h + (g << 4) >> 2] = g
          n = i + (g * 56 | 0) | 0
          o = b + (g * 56 | 0) | 0
          c[n >> 2] = c[o >> 2]
          c[n + 4 >> 2] = c[o + 4 >> 2]
          c[n + 8 >> 2] = c[o + 8 >> 2]
          c[n + 12 >> 2] = c[o + 12 >> 2]
          c[i + (g * 56 | 0) + 16 >> 2] = c[m >> 2]
          c[i + (g * 56 | 0) + 32 >> 2] = g
          c[i + (g * 56 | 0) + 48 >> 2] = 1
          g = g + 1 | 0
        }
        c[46621] = a
        c[46622] = 0
        c[j >> 2] = 1
        g = c[d + (k * 72 | 0) + 40 >> 2] | 0
        if ((g | 0) <= 0) {
          g = c[d + (k * 72 | 0) + 48 >> 2] | 0
          if ((g | 0) > 0) {
            g = cS(l, f, 0, b, d, 0, k, g, e, 2) | 0
          } else {
            g = 0
          }
        } else {
          g = cS(l, f, 0, b, d, 0, k, g, e, 1) | 0
        }
        C_(l)
        C_(c[46618] | 0)
        C_(c[46619] | 0)
        C_(c[46620] | 0)
        return g | 0
      }

      function aS(a, b, c) {
        a = a | 0
        b = b | 0
        c = c | 0
        var d = 0.0, e = 0.0, f = 0.0, g = 0.0
        g = +h[(+h[b >> 3] > +h[c >> 3] ? b : c) >> 3]
        f = +h[(+h[b + 16 >> 3] < +h[c + 16 >> 3] ? b : c) + 16 >> 3]
        h[a + 16 >> 3] = f
        h[a >> 3] = g
        e = +h[(+h[b + 8 >> 3] > +h[c + 8 >> 3] ? b : c) + 8 >> 3]
        d = +h[(+h[b + 24 >> 3] < +h[c + 24 >> 3] ? b : c) + 24 >> 3]
        h[a + 24 >> 3] = d
        h[a + 8 >> 3] = e
        return !(g >= f) & !(e >= d) & 1 | 0
      }

      function bS(a, b) {
        a = a | 0
        b = b | 0
        var d = 0.0, e = 0.0, f = 0
        f = c[a + 4 >> 2] | 0
        do {
          if ((c[a + 68 >> 2] | 0) != 2 ? !((f | 0) < 1 | (c[a >> 2] | 0) < 1) : 0) {
            if (!((c[a + 40 >> 2] | 0) < 1 ? (c[a + 44 >> 2] | 0) < 1 : 0)) {
              if ((c[a + 48 >> 2] | 0) >= 1) {
                a = 0
                break
              }
              if ((c[a + 52 >> 2] | 0) >= 1) {
                a = 0
                break
              }
            }
            d = +h[b + (f * 56 | 0) + 24 >> 3]
            e = +h[b + (f * 56 | 0) + 8 >> 3]
            if (!(d > e + 1.0e-07)) {
              if (d < e + -1.0e-07) {
                a = 0
              } else {
                a = +h[b + (f * 56 | 0) + 16 >> 3] > +h[b + (f * 56
                    | 0) >> 3] & 1
              }
            } else {
              a = 1
            }
          } else {
            a = 0
          }
        } while (0)
        return a | 0
      }

      function cS(a, b, d, e, f, g, i, j, k, l) {
        a = a | 0
        b = b | 0
        d = d | 0
        e = e | 0
        f = f | 0
        g = g | 0
        i = i | 0
        j = j | 0
        k = k | 0
        l = l | 0
        var m = 0, n = 0, o = 0.0, p = 0.0, q = 0.0, r = 0, s = 0, t = 0, u = 0, v = 0, w = 0, x = 0, y = 0, z = 0,
            A = 0, C = 0, D = 0, E = 0, F = 0, G = 0, H = 0, I = 0.0, J = 0, K = 0.0, L = 0, M = 0, N = 0, O = 0, P = 0
        D = (k | 0) == 0
        C = i
        a:while (1) {
          y = f + (C * 72 | 0) | 0
          if ((C | 0) < 1) {
            break
          }
          i = a + (C << 2) | 0
          if (c[i >> 2] | 0) {
            break
          }
          c[i >> 2] = 1
          v = f + (C * 72 | 0) + 8 | 0
          t = f + (C * 72 | 0) + 16 | 0
          p = +h[t >> 3]
          w = f + (C * 72 | 0) + 24 | 0
          x = f + (C * 72 | 0) + 32 | 0
          o = +h[x >> 3]
          if ((p > o ? (A = c[y >> 2] | 0, I = +h[e + (A * 56 | 0) >> 3], I == +h[e + (A * 56 | 0) + 16 >> 3]) : 0)
              ? (A = c[f + (C * 72 | 0) + 4 >> 2] | 0, K = +h[e + (A * 56 | 0) >> 3], K == +h[e + (A * 56 | 0) + 16
              >> 3]) : 0) {
            i = b + (d << 5) | 0
            if (D) {
              h[i >> 3] = I
              q = p
              p = K
            } else {
              h[i >> 3] = o
              q = -I
              o = -K
            }
            h[b + (d << 5) + 8 >> 3] = o
            h[b + (d << 5) + 16 >> 3] = p
            h[b + (d << 5) + 24 >> 3] = q
            d = d + 1 | 0
          }
          i = f + (C * 72 | 0) + 40 | 0
          z = c[i >> 2] | 0
          do {
            if ((z | 0) < 1 ? (L = f + (C * 72 | 0) + 44 | 0, (c[L >> 2] | 0) < 1) : 0) {
              i = f + (C * 72 | 0) + 48 | 0
              n = f + (C * 72 | 0) + 52 | 0
              if ((c[i >> 2] | 0) > 0 ? (M = c[n >> 2] | 0, (M | 0) > 0) : 0) {
                m = c[f + (M * 72 | 0) >> 2] | 0
                l = c[y >> 2] | 0
                if ((M | 0) == (j | 0)) {
                  l = dS(g, l, m) | 0
                  d = cS(a, b, d, e, f, g, c[n >> 2] | 0, C, k, 1) | 0
                  g = l
                  l = 1
                  break
                } else {
                  l = dS(g, m, l) | 0
                  d = cS(a, b, d, e, f, g, c[i >> 2] | 0, C, k, 1) | 0
                  g = l
                  i = n
                  l = 1
                  break
                }
              }
              d = cS(a, b, d, e, f, g, z, C, k, 2) | 0
              d = cS(a, b, d, e, f, g, c[L >> 2] | 0, C, k, 2) | 0
              d = cS(a, b, d, e, f, g, c[i >> 2] | 0, C, k, 1) | 0
              i = n
              l = 1
            } else {
              P = 19
            }
          } while (0)
          do {
            if ((P | 0) == 19) {
              P = 0
              A = f + (C * 72 | 0) + 48 | 0
              r = c[A >> 2] | 0
              if ((r | 0) < 1 ? (N = f + (C * 72 | 0) + 52 | 0, (c[N >> 2] | 0) < 1) : 0) {
                n = f + (C * 72 | 0) + 44 | 0
                if ((z | 0) > 0 ? (O = c[n >> 2] | 0, (O | 0) > 0) : 0) {
                  m = c[f + (C * 72 | 0) + 4 >> 2] | 0
                  l = c[f + (z * 72 | 0) + 4 >> 2] | 0
                  if ((O | 0) == (j | 0)) {
                    l = dS(g, l, m) | 0
                    d = cS(a, b, d, e, f, g, c[n >> 2] | 0, C, k, 2) | 0
                    g = l
                    l = 2
                    break
                  } else {
                    l = dS(g, m, l) | 0
                    d = cS(a, b, d, e, f, g, c[i >> 2] | 0, C, k, 2) | 0
                    g = l
                    i = n
                    l = 2
                    break
                  }
                }
                d = cS(a, b, d, e, f, g, z, C, k, 2) | 0
                d = cS(a, b, d, e, f, g, c[n >> 2] | 0, C, k, 2) | 0
                d = cS(a, b, d, e, f, g, c[A >> 2] | 0, C, k, 1) | 0
                i = N
                l = 1
                break
              }
              u = f + (C * 72 | 0) + 44 | 0
              s = c[u >> 2] | 0
              m = (s | 0) > 0
              if ((z | 0) > 0) {
                if (m) {
                  if ((r | 0) > 0 ? (E = f + (C * 72 | 0) + 52 | 0, F = c[E >> 2] | 0, (F | 0) > 0) : 0) {
                    n = c[f + (F * 72 | 0) >> 2] | 0
                    m = c[f + (z * 72 | 0) + 4 >> 2] | 0
                    if (!((l | 0) == 2 & (F | 0) == (j | 0)) ? !((l | 0) == 1 & (s | 0) == (j | 0)) : 0) {
                      l = dS(g, n, m) | 0
                      d = cS(a, b, d, e, f, g, c[i >> 2] | 0, C, k, 2) | 0
                      d = cS(a, b, d, e, f, g, c[A >> 2] | 0, C, k, 1) | 0
                      d = cS(a, b, d, e, f, l, c[u >> 2] | 0, C, k, 2) | 0
                      g = l
                      i = E
                      l = 1
                      break
                    }
                    l = dS(g, m, n) | 0
                    d = cS(a, b, d, e, f, g, c[u >> 2] | 0, C, k, 2) | 0
                    d = cS(a, b, d, e, f, g, c[E >> 2] | 0, C, k, 1) | 0
                    d = cS(a, b, d, e, f, l, c[i >> 2] | 0, C, k, 2) | 0
                    g = l
                    i = A
                    l = 1
                    break
                  }
                  m = c[y >> 2] | 0
                  if (+B(+(+h[x >> 3] - +h[e + (m * 56 | 0) + 24 >> 3])) <= 1.0e-07 ? +B(
                      +(+h[w >> 3] - +h[e + (m * 56 | 0) + 16 >> 3])) <= 1.0e-07 : 0) {
                    n = c[f + (z * 72 | 0) + 4 >> 2] | 0
                    m = c[e + (m * 56 | 0) + 44 >> 2] | 0
                    if ((l | 0) == 1 & (z | 0) == (j | 0)) {
                      l = dS(g, m, n) | 0
                      d = cS(a, b, d, e, f, g, c[i >> 2] | 0, C, k, 2) | 0
                      d = cS(a, b, d, e, f, l, c[A >> 2] | 0, C, k, 1) | 0
                      d = cS(a, b, d, e, f, l, c[u >> 2] | 0, C, k, 2) | 0
                      g = l
                      i = f + (C * 72 | 0) + 52 | 0
                      l = 1
                      break
                    } else {
                      l = dS(g, n, m) | 0
                      d = cS(a, b, d, e, f, g, c[u >> 2] | 0, C, k, 2) | 0
                      d = cS(a, b, d, e, f, g, c[A >> 2] | 0, C, k, 1) | 0
                      d = cS(a, b, d, e, f, g, c[f + (C * 72 | 0) + 52 >> 2] | 0, C, k, 1) | 0
                      g = l
                      l = 2
                      break
                    }
                  }
                  n = c[f + (C * 72 | 0) + 4 >> 2] | 0
                  m = c[f + (z * 72 | 0) + 4 >> 2] | 0
                  if ((l | 0) == 1 & (s | 0) == (j | 0)) {
                    l = dS(g, m, n) | 0
                    d = cS(a, b, d, e, f, g, c[u >> 2] | 0, C, k, 2) | 0
                    d = cS(a, b, d, e, f, l, c[f + (C * 72 | 0) + 52 >> 2] | 0, C, k, 1) | 0
                    d = cS(a, b, d, e, f, l, c[A >> 2] | 0, C, k, 1) | 0
                    g = l
                    l = 2
                    break
                  } else {
                    l = dS(g, n, m) | 0
                    d = cS(a, b, d, e, f, g, c[i >> 2] | 0, C, k, 2) | 0
                    d = cS(a, b, d, e, f, g, c[A >> 2] | 0, C, k, 1) | 0
                    d = cS(a, b, d, e, f, g, c[f + (C * 72 | 0) + 52 >> 2] | 0, C, k, 1) | 0
                    g = l
                    i = u
                    l = 2
                    break
                  }
                }
              } else if (!m) {
                break a
              }
              if ((r | 0) > 0 ? (G = f + (C * 72 | 0) + 52 | 0, H = c[G >> 2] | 0, (H | 0) > 0) : 0) {
                n = c[y >> 2] | 0
                if (+B(+(+h[t >> 3] - +h[e + (n * 56 | 0) + 8 >> 3])) <= 1.0e-07 ? +B(
                    +(+h[v >> 3] - +h[e + (n * 56 | 0) >> 3])) <= 1.0e-07 : 0) {
                  m = c[f + (H * 72 | 0) >> 2] | 0
                  if ((l | 0) == 2 & (r | 0) == (j | 0)) {
                    l = dS(g, m, n) | 0
                    d = cS(a, b, d, e, f, g, c[A >> 2] | 0, C, k, 1) | 0
                    d = cS(a, b, d, e, f, l, c[i >> 2] | 0, C, k, 2) | 0
                    d = cS(a, b, d, e, f, l, c[f + (C * 72 | 0) + 44 >> 2] | 0, C, k, 2) | 0
                    g = l
                    i = G
                    l = 1
                    break
                  } else {
                    l = dS(g, n, m) | 0
                    d = cS(a, b, d, e, f, g, c[f + (C * 72 | 0) + 44 >> 2] | 0, C, k, 2) | 0
                    d = cS(a, b, d, e, f, g, c[G >> 2] | 0, C, k, 1) | 0
                    d = cS(a, b, d, e, f, g, c[i >> 2] | 0, C, k, 2) | 0
                    g = l
                    i = A
                    l = 1
                    break
                  }
                }
                m = c[f + (H * 72 | 0) >> 2] | 0
                n = c[e + ((c[f + (C * 72 | 0) + 4 >> 2] | 0) * 56 | 0) + 44 >> 2] | 0
                if ((l | 0) == 2 & (H | 0) == (j | 0)) {
                  l = dS(g, n, m) | 0
                  d = cS(a, b, d, e, f, g, c[G >> 2] | 0, C, k, 1) | 0
                  d = cS(a, b, d, e, f, l, c[f + (C * 72 | 0) + 44 >> 2] | 0, C, k, 2) | 0
                  d = cS(a, b, d, e, f, l, c[i >> 2] | 0, C, k, 2) | 0
                  g = l
                  i = A
                  l = 1
                  break
                } else {
                  l = dS(g, m, n) | 0
                  d = cS(a, b, d, e, f, g, c[i >> 2] | 0, C, k, 2) | 0
                  d = cS(a, b, d, e, f, g, c[A >> 2] | 0, C, k, 1) | 0
                  d = cS(a, b, d, e, f, g, c[f + (C * 72 | 0) + 44 >> 2] | 0, C, k, 2) | 0
                  g = l
                  i = G
                  l = 1
                  break
                }
              }
              o = +h[t >> 3]
              n = c[y >> 2] | 0
              if (((+B(+(o - +h[e + (n * 56 | 0) + 8 >> 3])) <= 1.0e-07 ? +B(+(+h[v >> 3] - +h[e + (n * 56 | 0) >> 3]))
                  <= 1.0e-07 : 0) ? (J = c[f + (C * 72 | 0) + 4 >> 2] | 0, +B(
                  +(+h[x >> 3] - +h[e + (J * 56 | 0) + 8 >> 3])) <= 1.0e-07) : 0) ? +B(
                  +(+h[w >> 3] - +h[e + (J * 56 | 0) >> 3])) <= 1.0e-07 : 0) {
                if ((l | 0) == 1) {
                  l = dS(g, n, J) | 0
                  d = cS(a, b, d, e, f, g, c[i >> 2] | 0, C, k, 2) | 0
                  d = cS(a, b, d, e, f, g, c[f + (C * 72 | 0) + 44 >> 2] | 0, C, k, 2) | 0
                  d = cS(a, b, d, e, f, l, c[f + (C * 72 | 0) + 52 >> 2] | 0, C, k, 1) | 0
                  g = l
                  i = A
                  l = 1
                  break
                } else {
                  l = dS(g, J, n) | 0
                  d = cS(a, b, d, e, f, g, c[f + (C * 72 | 0) + 52 >> 2] | 0, C, k, 1) | 0
                  d = cS(a, b, d, e, f, g, c[A >> 2] | 0, C, k, 1) | 0
                  d = cS(a, b, d, e, f, l, c[i >> 2] | 0, C, k, 2) | 0
                  g = l
                  i = f + (C * 72 | 0) + 44 | 0
                  l = 2
                  break
                }
              }
              j = c[f + (C * 72 | 0) + 4 >> 2] | 0
              if (((+B(+(o - +h[e + (j * 56 | 0) + 24 >> 3])) <= 1.0e-07 ? +B(
                  +(+h[v >> 3] - +h[e + (j * 56 | 0) + 16 >> 3])) <= 1.0e-07 : 0) ? +B(
                  +(+h[x >> 3] - +h[e + (n * 56 | 0) + 24 >> 3])) <= 1.0e-07 : 0) ? +B(
                  +(+h[w >> 3] - +h[e + (n * 56 | 0) + 16 >> 3])) <= 1.0e-07 : 0) {
                m = c[e + (j * 56 | 0) + 44 >> 2] | 0
                j = c[e + (n * 56 | 0) + 44 >> 2] | 0
                if ((l | 0) == 1) {
                  l = dS(g, j, m) | 0
                  d = cS(a, b, d, e, f, g, c[i >> 2] | 0, C, k, 2) | 0
                  d = cS(a, b, d, e, f, g, c[f + (C * 72 | 0) + 44 >> 2] | 0, C, k, 2) | 0
                  d = cS(a, b, d, e, f, l, c[f + (C * 72 | 0) + 52 >> 2] | 0, C, k, 1) | 0
                  g = l
                  i = A
                  l = 1
                  break
                } else {
                  l = dS(g, m, j) | 0
                  d = cS(a, b, d, e, f, g, c[f + (C * 72 | 0) + 52 >> 2] | 0, C, k, 1) | 0
                  d = cS(a, b, d, e, f, g, c[A >> 2] | 0, C, k, 1) | 0
                  d = cS(a, b, d, e, f, l, c[i >> 2] | 0, C, k, 2) | 0
                  g = l
                  i = f + (C * 72 | 0) + 44 | 0
                  l = 2
                  break
                }
              }
              d = cS(a, b, d, e, f, g, z, C, k, 2) | 0
              d = cS(a, b, d, e, f, g, c[A >> 2] | 0, C, k, 1) | 0
              d = cS(a, b, d, e, f, g, c[f + (C * 72 | 0) + 44 >> 2] | 0, C, k, 2) | 0
              i = f + (C * 72 | 0) + 52 | 0
              l = 1
            }
          } while (0)
          j = C
          C = c[i >> 2] | 0
        }
        return d | 0
      }

      function dS(a, b, d) {
        a = a | 0
        b = b | 0
        d = d | 0
        var e = 0, f = 0, g = 0, h = 0, i = 0, j = 0, k = 0, m = 0, n = 0, o = 0, p = 0, q = 0, r = 0
        f = l
        l = l + 16 | 0
        r = f + 4 | 0
        i = f
        e = (c[46622] | 0) + 1 | 0
        c[46622] = e
        m = c[46619] | 0
        eS(b, d, r, i)
        r = c[r >> 2] | 0
        h = c[m + (b * 56 | 0) + 32 + (r << 2) >> 2] | 0
        i = c[m + (d * 56 | 0) + 32 + (c[i >> 2] << 2) >> 2] | 0
        n = c[46621] | 0
        g = n + 1 | 0
        n = n + 2 | 0
        c[46621] = n
        q = c[46618] | 0
        c[q + (g << 4) >> 2] = b
        c[q + (n << 4) >> 2] = d
        o = q + (h << 4) + 4 | 0
        p = q + (g << 4) + 4 | 0
        c[p >> 2] = c[o >> 2]
        c[q + (c[o >> 2] << 4) + 8 >> 2] = g
        c[q + (g << 4) + 8 >> 2] = n
        c[q + (n << 4) + 4 >> 2] = g
        j = q + (i << 4) + 8 | 0
        c[q + (n << 4) + 8 >> 2] = c[j >> 2]
        c[q + (c[j >> 2] << 4) + 4 >> 2] = n
        c[o >> 2] = i
        c[j >> 2] = h
        j = m + (b * 56 | 0) + 48 | 0
        o = c[j >> 2] | 0
        i = m + (d * 56 | 0) + 48 | 0
        k = c[i >> 2] | 0
        c[m + (b * 56 | 0) + 16 + (r << 2) >> 2] = d
        c[m + (b * 56 | 0) + 32 + (o << 2) >> 2] = g
        c[m + (b * 56 | 0) + 16 + (o << 2) >> 2] = c[q + (c[p >> 2] << 4) >> 2]
        c[m + (d * 56 | 0) + 32 + (k << 2) >> 2] = n
        c[m + (d * 56 | 0) + 16 + (k << 2) >> 2] = b
        c[j >> 2] = (c[j >> 2] | 0) + 1
        c[i >> 2] = (c[i >> 2] | 0) + 1
        d = c[46620] | 0
        c[d + (a << 2) >> 2] = h
        c[d + (e << 2) >> 2] = g
        l = f
        return e | 0
      }

      function eS(a, b, d, e) {
        a = a | 0
        b = b | 0
        d = d | 0
        e = e | 0
        var f = 0, g = 0.0, h = 0, i = 0, j = 0.0, k = 0.0, l = 0, m = 0, n = 0
        l = c[46619] | 0
        m = l + (a * 56 | 0) | 0
        n = l + (b * 56 | 0) | 0
        f = 0
        g = -4.0
        i = 0
        while (1) {
          if ((i | 0) == 4) {
            break
          }
          h = c[l + (a * 56 | 0) + 16 + (i << 2) >> 2] | 0
          if ((h | 0) >= 1 ? (j = +fS(m, l + (h * 56 | 0) | 0, n), j > g) : 0) {
            f = i
            g = j
          }
          i = i + 1 | 0
        }
        c[d >> 2] = f
        f = 0
        i = 0
        g = -4.0
        while (1) {
          if ((i | 0) == 4) {
            break
          }
          h = c[l + (b * 56 | 0) + 16 + (i << 2) >> 2] | 0
          if ((h | 0) >= 1 ? (k = +fS(n, l + (h * 56 | 0) | 0, m), k > g) : 0) {
            f = i
            g = k
          }
          i = i + 1 | 0
        }
        c[e >> 2] = f
        return
      }

      function fS(a, b, c) {
        a = a | 0
        b = b | 0
        c = c | 0
        var d = 0.0, e = 0.0, f = 0.0, g = 0.0, i = 0.0
        g = +h[a >> 3]
        i = +h[b >> 3] - g
        d = +h[a + 8 >> 3]
        f = +h[b + 8 >> 3] - d
        g = +h[c >> 3] - g
        d = +h[c + 8 >> 3] - d
        e = d * f + g * i
        if (!(d * i - g * f >= 0.0)) {
          d = -e / (+C(+(d * d + g * g)) * +C(+(f * f + i * i))) + -2.0
        } else {
          d = e / (+C(
              +(d * d + g * g)) * +C(+(f * f + i * i)))
        }
        return +d
      }

      function gS(a, b, d, e) {
        a = a | 0
        b = b | 0
        d = d | 0
        e = e | 0
        var f = 0, g = 0, i = 0, j = 0, k = 0.0, l = 0.0
        c[e >> 2] = c[a >> 2]
        c[e + 4 >> 2] = c[a + 4 >> 2]
        c[e + 8 >> 2] = c[a + 8 >> 2]
        c[e + 12 >> 2] = c[a + 12 >> 2]
        i = e + 32 | 0
        j = a + 16 | 0
        c[i >> 2] = c[j >> 2]
        c[i + 4 >> 2] = c[j + 4 >> 2]
        c[i + 8 >> 2] = c[j + 8 >> 2]
        c[i + 12 >> 2] = c[j + 12 >> 2]
        if (!d) {
          f = a + 8 | 0
          g = j
          i = a + 24 | 0
          d = a
        } else {
          f = a + 24 | 0
          g = a
          i = a + 8 | 0
          d = j
        }
        k = +h[g >> 3]
        l = +h[i >> 3]
        h[e + 16 >> 3] = +h[d >> 3]
        h[e + 24 >> 3] = l
        h[e + 48 >> 3] = k
        h[e + 56 >> 3] = +h[f >> 3]
        a:do {
          if (b | 0) {
            d = 0
            while (1) {
              if ((d | 0) == 4) {
                break a
              }
              j = e + (d << 4) + 8 | 0
              l = +h[j >> 3]
              b = e + (d << 4) | 0
              h[j >> 3] = +h[b >> 3]
              h[b >> 3] = -l
              d = d + 1 | 0
            }
          }
        } while (0)
        return
      }

      function hS(a, b, d) {
        a = a | 0
        b = b | 0
        d = d | 0
        var e = 0, f = 0, g = 0, h = 0, i = 0, j = 0, k = 0, l = 0, m = 0, n = 0
        h = b + 3 | 0
        i = b + 1 | 0
        j = b + 2 | 0
        k = a + (b * 56 | 0) + 44 | 0
        l = a + (h * 56 | 0) + 44 | 0
        e = 0
        f = b
        while (1) {
          if ((f | 0) > (h | 0)) {
            break
          }
          do {
            if ((f | 0) != (b | 0)) {
              if ((f | 0) == (h | 0)) {
                c[l >> 2] = b
                g = j
                break
              } else {
                c[a + (f * 56 | 0) + 44 >> 2] = f + 1
                g = f + -1 | 0
                break
              }
            } else {
              c[k >> 2] = i
              g = h
            }
          } while (0)
          c[a + (f * 56 | 0) + 48 >> 2] = g
          c[a + (f * 56 | 0) + 32 >> 2] = 0
          n = a + (f * 56 | 0) | 0
          m = d + (e << 4) | 0
          c[n >> 2] = c[m >> 2]
          c[n + 4 >> 2] = c[m + 4 >> 2]
          c[n + 8 >> 2] = c[m + 8 >> 2]
          c[n + 12 >> 2] = c[m + 12 >> 2]
          F3(a + (g * 56 | 0) + 16 | 0, m | 0, 16) | 0
          e = e + 1 | 0
          f = f + 1 | 0
        }
        return b + 4 | 0
      }

      function iS(a, b, d, e, f) {
        a = a | 0
        b = b | 0
        d = d | 0
        e = e | 0
        f = f | 0
        var g = 0, h = 0, i = 0, j = 0, k = 0
        c[46623] = e << 1
        c[46624] = e
        k = tH(e * 80 | 0) | 0
        c[46625] = 1
        c[46626] = 1
        G3(f | 0, 0, e * 72 | 0) | 0
        g = jS(c[d + 4 >> 2] | 0, b, f, k) | 0
        e = 1
        while (1) {
          if ((e | 0) > (a | 0)) {
            break
          }
          c[b + (e * 56 | 0) + 40 >> 2] = g
          c[b + (e * 56 | 0) + 36 >> 2] = g
          e = e + 1 | 0
        }
        j = kS(a) | 0
        g = 2
        i = 1
        while (1) {
          if ((i | 0) > (j | 0)) {
            break
          }
          e = lS(a, i + -1 | 0) | 0
          h = lS(a, i) | 0
          while (1) {
            if ((e | 0) >= (h | 0)) {
              e = 1
              break
            }
            mS(c[d + (g << 2) >> 2] | 0, b, f, k)
            e = e + 1 | 0
            g = g + 1 | 0
          }
          while (1) {
            if ((e | 0) > (a | 0)) {
              break
            }
            nS(e, b, f, k)
            e = e + 1 | 0
          }
          i = i + 1 | 0
        }
        e = lS(a, j) | 0
        while (1) {
          if ((e | 0) >= (a | 0)) {
            break
          }
          mS(c[d + (g << 2) >> 2] | 0, b, f, k)
          g = g + 1 | 0
          e = e + 1 | 0
        }
        C_(k)
        return c[46625] | 0
      }

      function jS(a, b, d, e) {
        a = a | 0
        b = b | 0
        d = d | 0
        e = e | 0
        var f = 0, g = 0, i = 0, j = 0, k = 0, l = 0, m = 0, n = 0, o = 0, p = 0, q = 0, r = 0, s = 0, t = 0
        f = sS() | 0
        c[e + (f * 40 | 0) >> 2] = 2
        s = e + (f * 40 | 0) + 8 | 0
        k = b + (a * 56 | 0) | 0
        l = b + (a * 56 | 0) + 16 | 0
        wS(s, k, l)
        n = sS() | 0
        c[e + (f * 40 | 0) + 36 >> 2] = n
        c[e + (n * 40 | 0) >> 2] = 3
        c[e + (n * 40 | 0) + 28 >> 2] = f
        j = sS() | 0
        c[e + (f * 40 | 0) + 32 >> 2] = j
        c[e + (j * 40 | 0) >> 2] = 2
        r = e + (j * 40 | 0) + 8 | 0
        xS(r, k, l)
        c[e + (j * 40 | 0) + 28 >> 2] = f
        l = sS() | 0
        c[e + (j * 40 | 0) + 32 >> 2] = l
        c[e + (l * 40 | 0) >> 2] = 3
        c[e + (l * 40 | 0) + 28 >> 2] = j
        k = sS() | 0
        c[e + (j * 40 | 0) + 36 >> 2] = k
        c[e + (k * 40 | 0) >> 2] = 1
        c[e + (k * 40 | 0) + 4 >> 2] = a
        c[e + (k * 40 | 0) + 28 >> 2] = j
        j = sS() | 0
        c[e + (k * 40 | 0) + 32 >> 2] = j
        c[e + (j * 40 | 0) >> 2] = 3
        c[e + (j * 40 | 0) + 28 >> 2] = k
        g = sS() | 0
        c[e + (k * 40 | 0) + 36 >> 2] = g
        c[e + (g * 40 | 0) >> 2] = 3
        c[e + (g * 40 | 0) + 28 >> 2] = k
        k = rS(d) | 0
        i = rS(d) | 0
        m = rS(d) | 0
        o = rS(d) | 0
        p = d + (k * 72 | 0) + 8 | 0
        q = d + (i * 72 | 0) + 8 | 0
        t = d + (o * 72 | 0) + 24 | 0
        c[t >> 2] = c[s >> 2]
        c[t + 4 >> 2] = c[s + 4 >> 2]
        c[t + 8 >> 2] = c[s + 8 >> 2]
        c[t + 12 >> 2] = c[s + 12 >> 2]
        F3(q | 0, s | 0, 16) | 0
        c[p >> 2] = c[q >> 2]
        c[p + 4 >> 2] = c[q + 4 >> 2]
        c[p + 8 >> 2] = c[q + 8 >> 2]
        c[p + 12 >> 2] = c[q + 12 >> 2]
        p = d + (k * 72 | 0) + 24 | 0
        q = d + (i * 72 | 0) + 24 | 0
        s = d + (m * 72 | 0) + 8 | 0
        c[s >> 2] = c[r >> 2]
        c[s + 4 >> 2] = c[r + 4 >> 2]
        c[s + 8 >> 2] = c[r + 8 >> 2]
        c[s + 12 >> 2] = c[r + 12 >> 2]
        F3(q | 0, r | 0, 16) | 0
        c[p >> 2] = c[q >> 2]
        c[p + 4 >> 2] = c[q + 4 >> 2]
        c[p + 8 >> 2] = c[q + 8 >> 2]
        c[p + 12 >> 2] = c[q + 12 >> 2]
        h[d + (o * 72 | 0) + 16 >> 3] = 1073741824.0
        h[d + (o * 72 | 0) + 8 >> 3] = 1073741824.0
        h[d + (m * 72 | 0) + 32 >> 3] = -1073741824.0
        h[d + (m * 72 | 0) + 24 >> 3] = -1073741824.0
        c[d + (i * 72 | 0) >> 2] = a
        c[d + (k * 72 | 0) + 4 >> 2] = a
        c[d + (i * 72 | 0) + 40 >> 2] = o
        c[d + (k * 72 | 0) + 40 >> 2] = o
        c[d + (i * 72 | 0) + 48 >> 2] = m
        c[d + (k * 72 | 0) + 48 >> 2] = m
        c[d + (m * 72 | 0) + 40 >> 2] = k
        c[d + (o * 72 | 0) + 48 >> 2] = k
        c[d + (m * 72 | 0) + 44 >> 2] = i
        c[d + (o * 72 | 0) + 52 >> 2] = i
        c[d + (k * 72 | 0) + 56 >> 2] = j
        c[d + (i * 72 | 0) + 56 >> 2] = g
        c[d + (m * 72 | 0) + 56 >> 2] = l
        c[d + (o * 72 | 0) + 56 >> 2] = n
        c[d + (i * 72 | 0) + 68 >> 2] = 1
        c[d + (k * 72 | 0) + 68 >> 2] = 1
        c[d + (o * 72 | 0) + 68 >> 2] = 1
        c[d + (m * 72 | 0) + 68 >> 2] = 1
        c[e + (n * 40 | 0) + 24 >> 2] = o
        c[e + (l * 40 | 0) + 24 >> 2] = m
        c[e + (j * 40 | 0) + 24 >> 2] = k
        c[e + (g * 40 | 0) + 24 >> 2] = i
        c[b + (a * 56 | 0) + 32 >> 2] = 1
        return f | 0
      }

      function kS(a) {
        a = a | 0
        var b = 0.0
        b = +(a | 0)
        a = 0
        while (1) {
          if (!(b >= 1.0)) {
            break
          }
          b = +f$(b)
          a = a + 1 | 0
        }
        return a + -1 | 0
      }

      function lS(a, b) {
        a = a | 0
        b = b | 0
        var c = 0.0, d = 0.0
        d = +(a | 0)
        c = d
        a = 0
        while (1) {
          if ((a | 0) >= (b | 0)) {
            break
          }
          c = +f$(c)
          a = a + 1 | 0
        }
        return ~~+N(+(d / c)) | 0
      }

      function mS(a, b, d, e) {
        a = a | 0
        b = b | 0
        d = d | 0
        e = e | 0
        var f = 0, g = 0, i = 0.0, j = 0.0, k = 0, m = 0, n = 0, o = 0, p = 0, q = 0.0, r = 0, s = 0, t = 0, u = 0,
            v = 0, w = 0, x = 0, y = 0, z = 0, A = 0, C = 0, D = 0, E = 0, F = 0, G = 0, H = 0, I = 0, J = 0, K = 0,
            L = 0, M = 0, N = 0, O = 0, P = 0, Q = 0, R = 0, S = 0, T = 0, U = 0, V = 0, W = 0, X = 0
        W = l
        l = l + 96 | 0
        S = W + 32 | 0
        f = W + 16 | 0
        T = W
        s = S
        k = b + (a * 56 | 0) | 0
        r = s + 56 | 0
        do {
          c[s >> 2] = c[k >> 2]
          s = s + 4 | 0
          k = k + 4 | 0
        } while ((s | 0) < (r | 0))
        U = S + 16 | 0
        V = S + 24 | 0
        i = +h[V >> 3]
        H = S + 8 | 0
        j = +h[H >> 3]
        do {
          if (!(i > j + 1.0e-07)) {
            if (!(i < j + -1.0e-07) ? +h[U >> 3] > +h[S >> 3] : 0) {
              G = 4
              break
            }
            G = (qS(a, b, 1) | 0) == 0
            f = c[S + 36 >> 2] | 0
            if (G) {
              n = 0
              G = 7
            } else {
              f = oS(S, U, f, b, e) | 0
              G = 20
            }
          } else {
            G = 4
          }
        } while (0)
        if ((G | 0) == 4) {
          c[f >> 2] = c[S >> 2]
          c[f + 4 >> 2] = c[S + 4 >> 2]
          c[f + 8 >> 2] = c[S + 8 >> 2]
          c[f + 12 >> 2] = c[S + 12 >> 2]
          c[S >> 2] = c[U >> 2]
          c[S + 4 >> 2] = c[U + 4 >> 2]
          c[S + 8 >> 2] = c[U + 8 >> 2]
          c[S + 12 >> 2] = c[U + 12 >> 2]
          c[U >> 2] = c[f >> 2]
          c[U + 4 >> 2] = c[f + 4 >> 2]
          c[U + 8 >> 2] = c[f + 8 >> 2]
          c[U + 12 >> 2] = c[f + 12 >> 2]
          E = S + 36 | 0
          F = c[E >> 2] | 0
          G = S + 40 | 0
          f = c[G >> 2] | 0
          c[E >> 2] = f
          c[G >> 2] = F
          if (!(qS(a, b, 2) | 0)) {
            n = 1
            G = 7
          } else {
            f = oS(S, U, f, b, e) | 0
            G = 19
          }
        }
        if ((G | 0) == 7) {
          m = oS(S, U, f, b, e) | 0
          f = rS(d) | 0
          c[d + (f * 72 | 0) + 68 >> 2] = 1
          s = d + (f * 72 | 0) | 0
          k = d + (m * 72 | 0) | 0
          r = s + 72 | 0
          do {
            c[s >> 2] = c[k >> 2]
            s = s + 4 | 0
            k = k + 4 | 0
          } while ((s | 0) < (r | 0))
          q = +h[H >> 3]
          h[d + (f * 72 | 0) + 16 >> 3] = q
          h[d + (m * 72 | 0) + 32 >> 3] = q
          q = +h[S >> 3]
          h[d + (f * 72 | 0) + 8 >> 3] = q
          h[d + (m * 72 | 0) + 24 >> 3] = q
          c[d + (m * 72 | 0) + 48 >> 2] = f
          c[d + (m * 72 | 0) + 52 >> 2] = 0
          c[d + (f * 72 | 0) + 40 >> 2] = m
          c[d + (f * 72 | 0) + 44 >> 2] = 0
          g = c[d + (f * 72 | 0) + 48 >> 2] | 0
          if ((g | 0) > 0) {
            k = d + (g * 72 | 0) + 40 | 0
            if ((c[k >> 2] | 0) == (m | 0)) {
              c[k >> 2] = f
            }
            g = d + (g * 72 | 0) + 44 | 0
            if ((c[g >> 2] | 0) == (m | 0)) {
              c[g >> 2] = f
            }
          }
          g = c[d + (f * 72 | 0) + 52 >> 2] | 0
          if ((g | 0) > 0) {
            k = d + (g * 72 | 0) + 40 | 0
            if ((c[k >> 2] | 0) == (m | 0)) {
              c[k >> 2] = f
            }
            g = d + (g * 72 | 0) + 44 | 0
            if ((c[g >> 2] | 0) == (m | 0)) {
              c[g >> 2] = f
            }
          }
          E = sS() | 0
          G = sS() | 0
          F = d + (m * 72 | 0) + 56 | 0
          D = c[F >> 2] | 0
          c[e + (D * 40 | 0) >> 2] = 2
          C = e + (D * 40 | 0) + 8 | 0
          c[C >> 2] = c[S >> 2]
          c[C + 4 >> 2] = c[S + 4 >> 2]
          c[C + 8 >> 2] = c[S + 8 >> 2]
          c[C + 12 >> 2] = c[S + 12 >> 2]
          c[e + (D * 40 | 0) + 4 >> 2] = a
          c[e + (D * 40 | 0) + 32 >> 2] = G
          c[e + (D * 40 | 0) + 36 >> 2] = E
          c[e + (E * 40 | 0) >> 2] = 3
          c[e + (E * 40 | 0) + 24 >> 2] = m
          c[e + (E * 40 | 0) + 28 >> 2] = D
          c[e + (G * 40 | 0) >> 2] = 3
          c[e + (G * 40 | 0) + 24 >> 2] = f
          c[e + (G * 40 | 0) + 28 >> 2] = D
          c[F >> 2] = E
          c[d + (f * 72 | 0) + 56 >> 2] = G
          if (n) {
            G = 19
          } else {
            G = 20
          }
        }
        if ((G | 0) == 19) {
          if (!(qS(a, b, 1) | 0)) {
            g = 1
            G = 21
          } else {
            g = 1
            G = 32
          }
        } else if ((G | 0) == 20) {
          if (!(qS(a, b, 2) | 0)) {
            g = 0
            G = 21
          } else {
            g = 0
            G = 32
          }
        }
        if ((G | 0) == 21) {
          o = oS(U, S, c[S + 40 >> 2] | 0, b, e) | 0
          n = rS(d) | 0
          c[d + (n * 72 | 0) + 68 >> 2] = 1
          s = d + (n * 72 | 0) | 0
          k = d + (o * 72 | 0) | 0
          r = s + 72 | 0
          do {
            c[s >> 2] = c[k >> 2]
            s = s + 4 | 0
            k = k + 4 | 0
          } while ((s | 0) < (r | 0))
          q = +h[V >> 3]
          h[d + (n * 72 | 0) + 16 >> 3] = q
          h[d + (o * 72 | 0) + 32 >> 3] = q
          q = +h[U >> 3]
          h[d + (n * 72 | 0) + 8 >> 3] = q
          h[d + (o * 72 | 0) + 24 >> 3] = q
          c[d + (o * 72 | 0) + 48 >> 2] = n
          c[d + (o * 72 | 0) + 52 >> 2] = 0
          c[d + (n * 72 | 0) + 40 >> 2] = o
          c[d + (n * 72 | 0) + 44 >> 2] = 0
          k = c[d + (n * 72 | 0) + 48 >> 2] | 0
          if ((k | 0) > 0) {
            m = d + (k * 72 | 0) + 40 | 0
            if ((c[m >> 2] | 0) == (o | 0)) {
              c[m >> 2] = n
            }
            k = d + (k * 72 | 0) + 44 | 0
            if ((c[k >> 2] | 0) == (o | 0)) {
              c[k >> 2] = n
            }
          }
          k = c[d + (n * 72 | 0) + 52 >> 2] | 0
          if ((k | 0) > 0) {
            m = d + (k * 72 | 0) + 40 | 0
            if ((c[m >> 2] | 0) == (o | 0)) {
              c[m >> 2] = n
            }
            k = d + (k * 72 | 0) + 44 | 0
            if ((c[k >> 2] | 0) == (o | 0)) {
              c[k >> 2] = n
            }
          }
          D = sS() | 0
          F = sS() | 0
          E = d + (o * 72 | 0) + 56 | 0
          C = c[E >> 2] | 0
          c[e + (C * 40 | 0) >> 2] = 2
          A = e + (C * 40 | 0) + 8 | 0
          c[A >> 2] = c[U >> 2]
          c[A + 4 >> 2] = c[U + 4 >> 2]
          c[A + 8 >> 2] = c[U + 8 >> 2]
          c[A + 12 >> 2] = c[U + 12 >> 2]
          c[e + (C * 40 | 0) + 4 >> 2] = a
          c[e + (C * 40 | 0) + 32 >> 2] = F
          c[e + (C * 40 | 0) + 36 >> 2] = D
          c[e + (D * 40 | 0) >> 2] = 3
          c[e + (D * 40 | 0) + 24 >> 2] = o
          c[e + (D * 40 | 0) + 28 >> 2] = C
          c[e + (F * 40 | 0) >> 2] = 3
          c[e + (F * 40 | 0) + 24 >> 2] = n
          c[e + (F * 40 | 0) + 28 >> 2] = C
          c[E >> 2] = D
          c[d + (n * 72 | 0) + 56 >> 2] = F
          F = f
          f = 0
        } else if ((G | 0) == 32) {
          F = f
          o = oS(U, S, c[S + 40 >> 2] | 0, b, e) | 0
          f = 1
        }
        a:do {
          if ((F | 0) > 0) {
            D = d + (o * 72 | 0) + 24 | 0
            E = d + (o * 72 | 0) + 32 | 0
            C = (f | 0) != 0
            y = g ? b + (a * 56 | 0) + 48 | 0 : b + (a * 56 | 0) + 44 | 0
            z = T + 8 | 0
            g = 0
            f = 0
            x = F
            b:while (1) {
              k = d + (x * 72 | 0) | 0
              v = d + (x * 72 | 0) + 24 | 0
              if (!(tS(v, D) | 0)) {
                break a
              }
              m = d + (x * 72 | 0) + 56 | 0
              u = c[m >> 2] | 0
              n = sS() | 0
              p = sS() | 0
              c[e + (u * 40 | 0) >> 2] = 1
              c[e + (u * 40 | 0) + 4 >> 2] = a
              c[e + (u * 40 | 0) + 32 >> 2] = n
              c[e + (u * 40 | 0) + 36 >> 2] = p
              c[e + (n * 40 | 0) >> 2] = 3
              c[e + (n * 40 | 0) + 24 >> 2] = x
              c[e + (n * 40 | 0) + 28 >> 2] = u
              c[e + (p * 40 | 0) >> 2] = 3
              w = rS(d) | 0
              c[e + (p * 40 | 0) + 24 >> 2] = w
              A = d + (w * 72 | 0) | 0
              c[d + (w * 72 | 0) + 68 >> 2] = 1
              c[e + (p * 40 | 0) + 28 >> 2] = u
              g = (x | 0) == (F | 0) ? w : g
              u = d + (x * 72 | 0) + 32 | 0
              if (+B(+(+h[u >> 3] - +h[E >> 3])) <= 1.0e-07 ? +B(+(+h[v >> 3] - +h[D >> 3])) <= 1.0e-07 : 0) {
                f = w
              }
              s = A
              r = s + 72 | 0
              do {
                c[s >> 2] = c[k >> 2]
                s = s + 4 | 0
                k = k + 4 | 0
              } while ((s | 0) < (r | 0))
              c[m >> 2] = n
              c[d + (w * 72 | 0) + 56 >> 2] = p
              t = d + (x * 72 | 0) + 48 | 0
              m = d + (x * 72 | 0) + 52 | 0
              k = (c[m >> 2] | 0) < 1
              do {
                if ((c[t >> 2] | 0) < 1) {
                  if (k) {
                    break b
                  }
                  s = d + (x * 72 | 0) + 40 | 0
                  k = c[s >> 2] | 0
                  do {
                    if ((k | 0) > 0 ? (M = d + (x * 72 | 0) + 44 | 0, N = c[M >> 2] | 0, (N | 0) > 0) : 0) {
                      r = d + (x * 72 | 0) + 60 | 0
                      k = c[r >> 2] | 0
                      if ((k | 0) <= 0) {
                        c[d + (w * 72 | 0) + 40 >> 2] = N
                        c[d + (w * 72 | 0) + 44 >> 2] = -1
                        c[M >> 2] = -1
                        c[d + (N * 72 | 0) + 48 >> 2] = w
                        break
                      }
                      if ((c[d + (x * 72 | 0) + 64 >> 2] | 0) == 1) {
                        c[d + (w * 72 | 0) + 40 >> 2] = N
                        c[M >> 2] = -1
                        c[d + (w * 72 | 0) + 44 >> 2] = k
                        c[d + ((c[s >> 2] | 0) * 72 | 0) + 48 >> 2] = x
                        p = w
                        n = N
                      } else {
                        c[d + (w * 72 | 0) + 44 >> 2] = -1
                        t = d + (w * 72 | 0) + 40 | 0
                        c[t >> 2] = c[M >> 2]
                        n = c[s >> 2] | 0
                        c[M >> 2] = n
                        c[s >> 2] = k
                        c[d + (k * 72 | 0) + 48 >> 2] = x
                        p = x
                        k = c[t >> 2] | 0
                      }
                      c[d + (n * 72 | 0) + 48 >> 2] = p
                      c[d + (k * 72 | 0) + 48 >> 2] = w
                      c[d + (w * 72 | 0) + 60 >> 2] = 0
                      c[r >> 2] = 0
                    } else {
                      G = 77
                    }
                  } while (0)
                  do {
                    if ((G | 0) == 77) {
                      G = 0
                      n = d + (k * 72 | 0) + 48 | 0
                      p = c[n >> 2] | 0
                      k = d + (k * 72 | 0) + 52 | 0
                      if ((p | 0) > 0 ? (c[k >> 2] | 0) > 0 : 0) {
                        k = c[d + (p * 72 | 0) + 4 >> 2] | 0
                        if ((k | 0) > 0 ? (pS(k, b, U) | 0) == 0 : 0) {
                          c[d + (w * 72 | 0) + 44 >> 2] = -1
                          c[d + (x * 72 | 0) + 44 >> 2] = -1
                          c[s >> 2] = -1
                          c[d + ((c[d + (w * 72 | 0) + 40 >> 2] | 0) * 72 | 0) + 52 >> 2] = w
                          break
                        }
                        c[d + (x * 72 | 0) + 44 >> 2] = -1
                        c[d + (w * 72 | 0) + 44 >> 2] = -1
                        c[d + (w * 72 | 0) + 40 >> 2] = -1
                        c[d + ((c[s >> 2] | 0) * 72 | 0) + 48 >> 2] = x
                        break
                      }
                      c[n >> 2] = x
                      c[k >> 2] = w
                    }
                  } while (0)
                  if (+B(+(+h[u >> 3] - +h[E >> 3])) <= 1.0e-07 ? C & +B(+(+h[v >> 3] - +h[D >> 3])) <= 1.0e-07 : 0) {
                    k = c[y >> 2] | 0
                    if ((k | 0) > 0 ? (pS(k, b, S) | 0) != 0 : 0) {
                      c[d + ((c[m >> 2] | 0) * 72 | 0) + 40 >> 2] = x
                      n = d + (w * 72 | 0) + 52 | 0
                      k = w
                    } else {
                      c[d + ((c[d + (w * 72 | 0) + 52 >> 2] | 0) * 72 | 0) + 44 >> 2] = w
                      n = m
                      k = x
                    }
                    c[n >> 2] = -1
                    c[d + (k * 72 | 0) + 48 >> 2] = -1
                    k = c[m >> 2] | 0
                    break
                  }
                  k = c[m >> 2] | 0
                  m = d + (k * 72 | 0) + 40 | 0
                  n = c[m >> 2] | 0
                  p = d + (k * 72 | 0) + 44 | 0
                  if ((n | 0) > 0 ? (O = c[p >> 2] | 0, P = (n | 0) == (x | 0), (O | 0) > 0) : 0) {
                    c[d + (k * 72 | 0) + 60 >> 2] = P ? O : n
                    c[d + (k * 72 | 0) + 64 >> 2] = P ? 1 : 2
                  }
                  c[m >> 2] = x
                  c[p >> 2] = w
                } else {
                  if (!k) {
                    i = +h[u >> 3]
                    j = +h[H >> 3]
                    q = i - j
                    if (!(+B(+q) <= 1.0e-07)) {
                      h[z >> 3] = i
                      i = +h[S >> 3]
                      h[T >> 3] = (+h[U >> 3] - i) * (q / (+h[V >> 3] - j)) + i
                      s = (uS(T, v) | 0) != 0
                    } else {
                      s = +h[v >> 3] > +h[S >> 3]
                    }
                    r = d + (x * 72 | 0) + 40 | 0
                    k = c[r >> 2] | 0
                    do {
                      if ((k | 0) > 0 ? (Q = d + (x * 72 | 0) + 44 | 0, R = c[Q >> 2] | 0, (R | 0) > 0) : 0) {
                        p = d + (x * 72 | 0) + 60 | 0
                        k = c[p >> 2] | 0
                        if ((k | 0) <= 0) {
                          c[d + (w * 72 | 0) + 40 >> 2] = R
                          c[d + (w * 72 | 0) + 44 >> 2] = -1
                          c[Q >> 2] = -1
                          c[d + (R * 72 | 0) + 48 >> 2] = w
                          break
                        }
                        if ((c[d + (x * 72 | 0) + 64 >> 2] | 0) == 1) {
                          c[d + (w * 72 | 0) + 40 >> 2] = R
                          c[Q >> 2] = -1
                          c[d + (w * 72 | 0) + 44 >> 2] = k
                          c[d + ((c[r >> 2] | 0) * 72 | 0) + 48 >> 2] = x
                          n = w
                          m = R
                        } else {
                          c[d + (w * 72 | 0) + 44 >> 2] = -1
                          X = d + (w * 72 | 0) + 40 | 0
                          c[X >> 2] = c[Q >> 2]
                          m = c[r >> 2] | 0
                          c[Q >> 2] = m
                          c[r >> 2] = k
                          c[d + (k * 72 | 0) + 48 >> 2] = x
                          n = x
                          k = c[X >> 2] | 0
                        }
                        c[d + (m * 72 | 0) + 48 >> 2] = n
                        c[d + (k * 72 | 0) + 48 >> 2] = w
                        c[d + (w * 72 | 0) + 60 >> 2] = 0
                        c[p >> 2] = 0
                      } else {
                        G = 106
                      }
                    } while (0)
                    do {
                      if ((G | 0) == 106) {
                        G = 0
                        m = d + (k * 72 | 0) + 48 | 0
                        n = c[m >> 2] | 0
                        k = d + (k * 72 | 0) + 52 | 0
                        if ((n | 0) > 0 ? (c[k >> 2] | 0) > 0 : 0) {
                          k = c[d + (n * 72 | 0) + 4 >> 2] | 0
                          if ((k | 0) > 0 ? (pS(k, b, U) | 0) == 0 : 0) {
                            c[d + (w * 72 | 0) + 44 >> 2] = -1
                            c[d + (x * 72 | 0) + 44 >> 2] = -1
                            c[r >> 2] = -1
                            c[d + ((c[d + (w * 72 | 0) + 40 >> 2] | 0) * 72 | 0) + 52 >> 2] = w
                            break
                          }
                          c[d + (x * 72 | 0) + 44 >> 2] = -1
                          c[d + (w * 72 | 0) + 44 >> 2] = -1
                          c[d + (w * 72 | 0) + 40 >> 2] = -1
                          c[d + ((c[r >> 2] | 0) * 72 | 0) + 48 >> 2] = x
                          break
                        }
                        c[m >> 2] = x
                        c[k >> 2] = w
                      }
                    } while (0)
                    if (+B(+(+h[u >> 3] - +h[E >> 3])) <= 1.0e-07 ? C & +B(+(+h[v >> 3] - +h[D >> 3])) <= 1.0e-07 : 0) {
                      k = c[t >> 2] | 0
                      c[d + (k * 72 | 0) + 40 >> 2] = x
                      c[d + (k * 72 | 0) + 44 >> 2] = -1
                      k = d + (x * 72 | 0) + 52 | 0
                      X = c[k >> 2] | 0
                      c[d + (X * 72 | 0) + 40 >> 2] = w
                      c[d + (X * 72 | 0) + 44 >> 2] = -1
                      c[d + (w * 72 | 0) + 48 >> 2] = X
                      c[d + (w * 72 | 0) + 52 >> 2] = -1
                      c[k >> 2] = -1
                      k = -1
                    } else {
                      G = 116
                    }
                    do {
                      if ((G | 0) == 116) {
                        G = 0
                        k = c[t >> 2] | 0
                        c[d + (k * 72 | 0) + 40 >> 2] = x
                        m = d + (k * 72 | 0) + 44 | 0
                        if (s) {
                          c[m >> 2] = w
                          X = d + (x * 72 | 0) + 52 | 0
                          v = c[X >> 2] | 0
                          c[d + (v * 72 | 0) + 40 >> 2] = w
                          c[d + (v * 72 | 0) + 44 >> 2] = -1
                          c[X >> 2] = -1
                          break
                        } else {
                          c[m >> 2] = -1
                          k = d + (x * 72 | 0) + 52 | 0
                          X = c[k >> 2] | 0
                          c[d + (X * 72 | 0) + 40 >> 2] = x
                          c[d + (X * 72 | 0) + 44 >> 2] = w
                          c[d + (w * 72 | 0) + 48 >> 2] = X
                          c[d + (w * 72 | 0) + 52 >> 2] = -1
                          k = c[k >> 2] | 0
                          break
                        }
                      }
                    } while (0)
                    break
                  }
                  s = d + (x * 72 | 0) + 40 | 0
                  k = c[s >> 2] | 0
                  do {
                    if ((k | 0) > 0 ? (I = d + (x * 72 | 0) + 44 | 0, J = c[I >> 2] | 0, (J | 0) > 0) : 0) {
                      r = d + (x * 72 | 0) + 60 | 0
                      k = c[r >> 2] | 0
                      if ((k | 0) <= 0) {
                        c[d + (w * 72 | 0) + 40 >> 2] = J
                        c[d + (w * 72 | 0) + 44 >> 2] = -1
                        c[I >> 2] = -1
                        c[d + (J * 72 | 0) + 48 >> 2] = w
                        break
                      }
                      if ((c[d + (x * 72 | 0) + 64 >> 2] | 0) == 1) {
                        c[d + (w * 72 | 0) + 40 >> 2] = J
                        c[I >> 2] = -1
                        c[d + (w * 72 | 0) + 44 >> 2] = k
                        c[d + ((c[s >> 2] | 0) * 72 | 0) + 48 >> 2] = x
                        p = w
                        n = J
                      } else {
                        c[d + (w * 72 | 0) + 44 >> 2] = -1
                        X = d + (w * 72 | 0) + 40 | 0
                        c[X >> 2] = c[I >> 2]
                        n = c[s >> 2] | 0
                        c[I >> 2] = n
                        c[s >> 2] = k
                        c[d + (k * 72 | 0) + 48 >> 2] = x
                        p = x
                        k = c[X >> 2] | 0
                      }
                      c[d + (n * 72 | 0) + 48 >> 2] = p
                      c[d + (k * 72 | 0) + 48 >> 2] = w
                      c[d + (w * 72 | 0) + 60 >> 2] = 0
                      c[r >> 2] = 0
                    } else {
                      G = 51
                    }
                  } while (0)
                  do {
                    if ((G | 0) == 51) {
                      G = 0
                      n = d + (k * 72 | 0) + 48 | 0
                      p = c[n >> 2] | 0
                      k = d + (k * 72 | 0) + 52 | 0
                      if ((p | 0) > 0 ? (c[k >> 2] | 0) > 0 : 0) {
                        k = c[d + (p * 72 | 0) + 4 >> 2] | 0
                        if ((k | 0) > 0 ? (pS(k, b, U) | 0) == 0 : 0) {
                          c[d + (w * 72 | 0) + 44 >> 2] = -1
                          c[d + (x * 72 | 0) + 44 >> 2] = -1
                          c[s >> 2] = -1
                          c[d + ((c[d + (w * 72 | 0) + 40 >> 2] | 0) * 72 | 0) + 52 >> 2] = w
                          break
                        }
                        c[d + (x * 72 | 0) + 44 >> 2] = -1
                        c[d + (w * 72 | 0) + 44 >> 2] = -1
                        c[d + (w * 72 | 0) + 40 >> 2] = -1
                        c[d + ((c[s >> 2] | 0) * 72 | 0) + 48 >> 2] = x
                        break
                      }
                      c[n >> 2] = x
                      c[k >> 2] = w
                    }
                  } while (0)
                  if (+B(+(+h[u >> 3] - +h[E >> 3])) <= 1.0e-07 ? C & +B(+(+h[v >> 3] - +h[D >> 3])) <= 1.0e-07 : 0) {
                    k = c[y >> 2] | 0
                    if ((k | 0) > 0 ? (pS(k, b, S) | 0) != 0 : 0) {
                      c[d + ((c[t >> 2] | 0) * 72 | 0) + 40 >> 2] = x
                      m = d + (w * 72 | 0) + 52 | 0
                      k = w
                    } else {
                      c[d + ((c[d + (w * 72 | 0) + 48 >> 2] | 0) * 72 | 0) + 44 >> 2] = w
                      k = x
                    }
                    c[m >> 2] = -1
                    c[d + (k * 72 | 0) + 48 >> 2] = -1
                    k = c[t >> 2] | 0
                    break
                  }
                  k = c[t >> 2] | 0
                  m = d + (k * 72 | 0) + 40 | 0
                  n = c[m >> 2] | 0
                  p = d + (k * 72 | 0) + 44 | 0
                  if ((n | 0) > 0 ? (K = c[p >> 2] | 0, L = (n | 0) == (x | 0), (K | 0) > 0) : 0) {
                    c[d + (k * 72 | 0) + 60 >> 2] = L ? K : n
                    c[d + (k * 72 | 0) + 64 >> 2] = L ? 1 : 2
                  }
                  c[m >> 2] = x
                  c[p >> 2] = w
                }
              } while (0)
              c[A >> 2] = a
              c[d + (x * 72 | 0) + 4 >> 2] = a
              if ((k | 0) > 0) {
                x = k
              } else {
                break a
              }
            }
            D1(135342, 19, 1, c[15686] | 0) | 0
          } else {
            g = 0
            f = 0
          }
        } while (0)
        vS(a, F, o, 1, d, e)
        vS(a, g, f, 2, d, e)
        c[b + (a * 56 | 0) + 32 >> 2] = 1
        l = W
        return
      }

      function nS(a, b, d, e) {
        a = a | 0
        b = b | 0
        d = d | 0
        e = e | 0
        var f = 0, g = 0, h = 0
        if (!(c[b + (a * 56 | 0) + 32 >> 2] | 0)) {
          f = b + (a * 56 | 0) | 0
          g = b + (a * 56 | 0) + 16 | 0
          h = b + (a * 56 | 0) + 36 | 0
          c[h >> 2] = c[d + ((oS(f, g, c[h >> 2] | 0, b, e) | 0) * 72 | 0) + 56 >> 2]
          a = b + (a * 56 | 0) + 40 | 0
          c[a >> 2] = c[d + ((oS(g, f, c[a >> 2] | 0, b, e) | 0) * 72 | 0) + 56 >> 2]
        }
        return
      }

      function oS(a, b, d, e, f) {
        a = a | 0
        b = b | 0
        d = d | 0
        e = e | 0
        f = f | 0
        var g = 0.0, i = 0, j = 0.0, k = 0.0, l = 0.0, m = 0.0, n = 0.0, o = 0, p = 0.0, q = 0, r = 0
        o = a + 8 | 0
        q = b + 8 | 0
        a:while (1) {
          b:do {
            switch (c[f + (d * 40 | 0) >> 2] | 0) {
              case 3: {
                r = 3
                break a
              }
              case 2: {
                g = +h[o >> 3]
                i = f + (d * 40 | 0) + 8 | 0
                j = +h[f + (d * 40 | 0) + 16 >> 3]
                k = j + 1.0e-07
                do {
                  if (!(g > k)) {
                    l = j + -1.0e-07
                    if (!(g < l) ? +h[a >> 3] > +h[i >> 3] : 0) {
                      break
                    }
                    if (+B(+(g - j)) <= 1.0e-07 ? (m = +h[i >> 3], +B(+(+h[a >> 3] - m)) <= 1.0e-07) : 0) {
                      g = +h[q >> 3]
                      do {
                        if (!(g > k)) {
                          if (!(g < l) ? +h[b >> 3] > m : 0) {
                            break
                          }
                          d = f + (d * 40 | 0) + 32 | 0
                          break b
                        }
                      } while (0)
                      d = f + (d * 40 | 0) + 36 | 0
                      break b
                    }
                    d = f + (d * 40 | 0) + 32 | 0
                    break b
                  }
                } while (0)
                d = f + (d * 40 | 0) + 36 | 0
                break
              }
              case 1: {
                g = +h[o >> 3]
                i = c[f + (d * 40 | 0) + 4 >> 2] | 0
                if (+B(+(g - +h[e + (i * 56 | 0) + 8 >> 3])) <= 1.0e-07 ? (n = +h[a >> 3], +B(
                    +(n - +h[e + (i * 56 | 0) >> 3])) <= 1.0e-07) : 0) {
                  j = n
                } else {
                  r = 19
                }
                do {
                  if ((r | 0) == 19) {
                    r = 0
                    if (+B(+(g - +h[e + (i * 56 | 0) + 24 >> 3])) <= 1.0e-07 ? (p = +h[a >> 3], +B(
                        +(p - +h[e + (i * 56 | 0) + 16 >> 3])) <= 1.0e-07) : 0) {
                      j = p
                      break
                    }
                    if (!(pS(i, e, a) | 0)) {
                      d = f + (d * 40 | 0) + 36 | 0
                      break b
                    } else {
                      d = f + (d * 40 | 0) + 32 | 0
                      break b
                    }
                  }
                } while (0)
                if (!(+B(+(g - +h[q >> 3])) <= 1.0e-07)) {
                  if (!(pS(i, e, b) | 0)) {
                    d = f + (d * 40 | 0) + 36 | 0
                    break b
                  } else {
                    d = f + (d * 40 | 0) + 32 | 0
                    break b
                  }
                } else if (+h[b >> 3] < j) {
                  d = f + (d * 40 | 0) + 32 | 0
                  break b
                } else {
                  d = f + (d * 40 | 0) + 36 | 0
                  break b
                }
              }
              default: {
                r = 31
                break a
              }
            }
          } while (0)
          d = c[d >> 2] | 0
        }
        if ((r | 0) == 3) {
          return c[f + (d * 40 | 0) + 24 >> 2] | 0
        } else if ((r | 0) == 31) {
          D1(135276, 35, 1, c[15686] | 0) | 0
          qa(135312, 135314, 349, 135326)
        }
        return 0
      }

      function pS(a, b, c) {
        a = a | 0
        b = b | 0
        c = c | 0
        var d = 0.0, e = 0.0, f = 0, g = 0.0, i = 0, j = 0, k = 0.0
        f = b + (a * 56 | 0) + 16 | 0
        g = +h[b + (a * 56 | 0) + 24 >> 3]
        i = b + (a * 56 | 0) | 0
        e = +h[b + (a * 56 | 0) + 8 >> 3]
        do {
          if (!(g > e + 1.0e-07)) {
            if (!(g < e + -1.0e-07) ? +h[f >> 3] > +h[i >> 3] : 0) {
              j = 4
              break
            }
            d = +h[c + 8 >> 3]
            if (+B(+(g - d)) <= 1.0e-07) {
              d = +h[c >> 3] < +h[f >> 3] ? 1.0 : -1.0
              break
            }
            if (!(+B(+(e - d)) <= 1.0e-07)) {
              k = +h[f >> 3]
              d = (+h[i >> 3] - k) * (d - g) - (+h[c >> 3] - k) * (e - g)
              break
            } else {
              d = +h[c >> 3] < +h[i >> 3] ? 1.0 : -1.0
              break
            }
          } else {
            j = 4
          }
        } while (0)
        do {
          if ((j | 0) == 4) {
            d = +h[c + 8 >> 3]
            if (+B(+(g - d)) <= 1.0e-07) {
              d = +h[c >> 3] < +h[f >> 3] ? 1.0 : -1.0
              break
            }
            if (!(+B(+(e - d)) <= 1.0e-07)) {
              k = +h[i >> 3]
              d = (+h[f >> 3] - k) * (d - e) - (+h[c >> 3] - k) * (g - e)
              break
            } else {
              d = +h[c >> 3] < +h[i >> 3] ? 1.0 : -1.0
              break
            }
          }
        } while (0)
        return d > 0.0 | 0
      }

      function qS(a, b, d) {
        a = a | 0
        b = b | 0
        d = d | 0
        return c[b + ((c[((d | 0) == 1 ? b + (a * 56 | 0) + 48 | 0 : b + (a * 56 | 0) + 44 | 0) >> 2] | 0) * 56 | 0)
        + 32 >> 2] | 0
      }

      function rS(a) {
        a = a | 0
        var b = 0, d = 0, e = 0
        e = l
        l = l + 16 | 0
        d = e
        b = c[46625] | 0
        if ((b | 0) < (c[46624] | 0)) {
          c[a + (b * 72 | 0) >> 2] = -1
          c[a + (b * 72 | 0) + 4 >> 2] = -1
          c[a + (b * 72 | 0) + 68 >> 2] = 1
          c[46625] = b + 1
          l = e
          return b | 0
        } else {
          e = c[15686] | 0
          c[d >> 2] = b
          f1(e, 135401, d) | 0
          qa(135312, 135314, 88, 135439)
        }
        return 0
      }

      function sS() {
        var a = 0
        a = c[46626] | 0
        if ((a | 0) < (c[46623] | 0)) {
          c[46626] = a + 1
          return a | 0
        } else {
          D1(135362, 30, 1, c[15686] | 0) | 0
          qa(135312, 135314, 72, 135393)
        }
        return 0
      }

      function tS(a, b) {
        a = a | 0
        b = b | 0
        var c = 0.0, d = 0.0
        c = +h[a + 8 >> 3]
        d = +h[b + 8 >> 3]
        if (!(c > d + 1.0e-07)) {
          if (c < d + -1.0e-07) {
            a = 0
          } else {
            a = +h[a >> 3] >= +h[b >> 3] & 1
          }
        } else {
          a = 1
        }
        return a | 0
      }

      function uS(a, b) {
        a = a | 0
        b = b | 0
        var c = 0.0, d = 0.0
        c = +h[a + 8 >> 3]
        d = +h[b + 8 >> 3]
        if (!(c < d + -1.0e-07)) {
          if (c > d + 1.0e-07) {
            a = 0
          } else {
            a = +h[a >> 3] < +h[b >> 3] & 1
          }
        } else {
          a = 1
        }
        return a | 0
      }

      function vS(a, b, d, e, f, g) {
        a = a | 0
        b = b | 0
        d = d | 0
        e = e | 0
        f = f | 0
        g = g | 0
        var h = 0, i = 0, j = 0, k = 0, l = 0, m = 0, n = 0, o = 0, p = 0, q = 0, r = 0
        q = f + (d * 72 | 0) + 24 | 0
        p = (e | 0) == 1
        a:while (1) {
          o = f + (b * 72 | 0) + 24 | 0
          j = f + (b * 72 | 0) + 48 | 0
          k = f + (b * 72 | 0) + 52 | 0
          l = f + (b * 72 | 0) | 0
          m = f + (b * 72 | 0) + 4 | 0
          n = f + (b * 72 | 0) + 56 | 0
          if ((b | 0) <= 0) {
            break
          }
          while (1) {
            if (!(tS(o, q) | 0)) {
              break a
            }
            d = c[j >> 2] | 0
            e = (d | 0) > 0
            do {
              if (p) {
                if (e ? (c[f + (d * 72 | 0) + 4 >> 2] | 0) == (a | 0) : 0) {
                  break
                }
                d = c[k >> 2] | 0
                if ((d | 0) <= 0) {
                  b = d
                  continue a
                }
                if ((c[f + (d * 72 | 0) + 4 >> 2] | 0) != (a | 0)) {
                  b = d
                  continue a
                }
              } else {
                if (e ? (c[f + (d * 72 | 0) >> 2] | 0) == (a | 0) : 0) {
                  break
                }
                d = c[k >> 2] | 0
                if ((d | 0) <= 0) {
                  b = d
                  continue a
                }
                if ((c[f + (d * 72 | 0) >> 2] | 0) != (a | 0)) {
                  b = d
                  continue a
                }
              }
            } while (0)
            if ((c[l >> 2] | 0) != (c[f + (d * 72 | 0) >> 2] | 0)) {
              b = d
              continue a
            }
            if ((c[m >> 2] | 0) != (c[f + (d * 72 | 0) + 4 >> 2] | 0)) {
              b = d
              continue a
            }
            r = c[f + (d * 72 | 0) + 56 >> 2] | 0
            e = c[g + (r * 40 | 0) + 28 >> 2] | 0
            h = g + (e * 40 | 0) + 32 | 0
            i = c[n >> 2] | 0
            if ((c[h >> 2] | 0) == (r | 0)) {
              c[h >> 2] = i
            } else {
              c[g + (e * 40 | 0) + 36 >> 2] = i
            }
            e = c[f + (d * 72 | 0) + 48 >> 2] | 0
            c[j >> 2] = e
            do {
              if ((e | 0) > 0) {
                h = f + (e * 72 | 0) + 40 | 0
                if ((c[h >> 2] | 0) == (d | 0)) {
                  c[h >> 2] = b
                  break
                }
                e = f + (e * 72 | 0) + 44 | 0
                if ((c[e >> 2] | 0) == (d | 0)) {
                  c[e >> 2] = b
                }
              }
            } while (0)
            e = c[f + (d * 72 | 0) + 52 >> 2] | 0
            c[k >> 2] = e
            do {
              if ((e | 0) > 0) {
                h = f + (e * 72 | 0) + 40 | 0
                if ((c[h >> 2] | 0) == (d | 0)) {
                  c[h >> 2] = b
                  break
                }
                e = f + (e * 72 | 0) + 44 | 0
                if ((c[e >> 2] | 0) == (d | 0)) {
                  c[e >> 2] = b
                }
              }
            } while (0)
            r = f + (d * 72 | 0) + 24 | 0
            c[o >> 2] = c[r >> 2]
            c[o + 4 >> 2] = c[r + 4 >> 2]
            c[o + 8 >> 2] = c[r + 8 >> 2]
            c[o + 12 >> 2] = c[r + 12 >> 2]
            c[f + (d * 72 | 0) + 68 >> 2] = 2
          }
        }
        return
      }

      function wS(a, b, d) {
        a = a | 0
        b = b | 0
        d = d | 0
        var e = 0.0, f = 0.0
        e = +h[b + 8 >> 3]
        f = +h[d + 8 >> 3]
        do {
          if (!(e > f + 1.0e-07)) {
            if (!(+B(+(e - f)) <= 1.0e-07)) {
              c[a >> 2] = c[d >> 2]
              c[a + 4 >> 2] = c[d + 4 >> 2]
              c[a + 8 >> 2] = c[d + 8 >> 2]
              c[a + 12 >> 2] = c[d + 12 >> 2]
              break
            }
            if (+h[b >> 3] > +h[d >> 3] + 1.0e-07) {
              c[a >> 2] = c[b >> 2]
              c[a + 4 >> 2] = c[b + 4 >> 2]
              c[a + 8 >> 2] = c[b + 8 >> 2]
              c[a + 12 >> 2] = c[b + 12 >> 2]
              break
            } else {
              c[a >> 2] = c[d >> 2]
              c[a + 4 >> 2] = c[d + 4 >> 2]
              c[a + 8 >> 2] = c[d + 8 >> 2]
              c[a + 12 >> 2] = c[d + 12 >> 2]
              break
            }
          } else {
            c[a >> 2] = c[b >> 2]
            c[a + 4 >> 2] = c[b + 4 >> 2]
            c[a + 8 >> 2] = c[b + 8 >> 2]
            c[a + 12 >> 2] = c[b + 12 >> 2]
          }
        } while (0)
        return
      }

      function xS(a, b, d) {
        a = a | 0
        b = b | 0
        d = d | 0
        var e = 0.0, f = 0.0
        e = +h[b + 8 >> 3]
        f = +h[d + 8 >> 3]
        do {
          if (!(e < f + -1.0e-07)) {
            if (!(+B(+(e - f)) <= 1.0e-07)) {
              c[a >> 2] = c[d >> 2]
              c[a + 4 >> 2] = c[d + 4 >> 2]
              c[a + 8 >> 2] = c[d + 8 >> 2]
              c[a + 12 >> 2] = c[d + 12 >> 2]
              break
            }
            if (+h[b >> 3] < +h[d >> 3]) {
              c[a >> 2] = c[b >> 2]
              c[a + 4 >> 2] = c[b + 4 >> 2]
              c[a + 8 >> 2] = c[b + 8 >> 2]
              c[a + 12 >> 2] = c[b + 12 >> 2]
              break
            } else {
              c[a >> 2] = c[d >> 2]
              c[a + 4 >> 2] = c[d + 4 >> 2]
              c[a + 8 >> 2] = c[d + 8 >> 2]
              c[a + 12 >> 2] = c[d + 12 >> 2]
              break
            }
          } else {
            c[a >> 2] = c[b >> 2]
            c[a + 4 >> 2] = c[b + 4 >> 2]
            c[a + 8 >> 2] = c[b + 8 >> 2]
            c[a + 12 >> 2] = c[b + 12 >> 2]
          }
        } while (0)
        return
      }

      function yS(a) {
        a = a | 0
        var b = 0
        b = tH(8) | 0
        if (b | 0) {
          c[b + 4 >> 2] = a
          c[b >> 2] = 0
        }
        return b | 0
      }

      function zS(a, b) {
        a = a | 0
        b = b | 0
        if (b) {
          b = yS(b) | 0
          c[b >> 2] = a
          a = b
        }
        return a | 0
      }

      function AS(a) {
        a = a | 0
        var b = 0
        do {
          b = a
          a = c[a >> 2] | 0
          C_(b)
        } while ((a | 0) != 0)
        return
      }

      function BS() {
        var a = 0
        a = tH(1992) | 0
        if (a | 0) {
          c[a >> 2] = CS(a) | 0
        }
        return a | 0
      }

      function CS(a) {
        a = a | 0
        var b = 0
        b = IS(a) | 0
        c[b + 4 >> 2] = 0
        a = a + 1972 | 0
        c[a >> 2] = (c[a >> 2] | 0) + 1
        return b | 0
      }

      function DS(a) {
        a = a | 0
        ES(a, c[a >> 2] | 0)
        C_(c[a >> 2] | 0)
        C_(a)
        return 0
      }

      function ES(a, b) {
        a = a | 0
        b = b | 0
        var d = 0, e = 0, f = 0, g = 0, h = 0, i = 0
        g = a + 1980 | 0
        h = a + 1912 | 0
        i = a + 1936 | 0
        a:do {
          if ((c[b + 4 >> 2] | 0) > 0) {
            d = 0
            while (1) {
              if ((d | 0) == 64) {
                break a
              }
              e = b + 8 + (d * 20 | 0) + 16 | 0
              f = c[e >> 2] | 0
              if (f | 0 ? (ES(a, f), C_(c[e >> 2] | 0), OS(b, d), c[g >> 2] = (c[g >> 2] | 0) + -1, c[h >> 2] | 0)
                  : 0) {
                c[i >> 2] = (c[i >> 2] | 0) + 1
              }
              d = d + 1 | 0
            }
          } else {
            d = 0
            while (1) {
              if ((d | 0) == 64) {
                break a
              }
              if (c[b + 8 + (d * 20 | 0) + 16 >> 2] | 0 ? (OS(b, d), c[g >> 2] = (c[g >> 2] | 0) + -1, c[h >> 2] | 0)
                  : 0) {
                c[i >> 2] = (c[i >> 2] | 0) + 1
              }
              d = d + 1 | 0
            }
          }
        } while (0)
        return
      }

      function FS(a, b, d) {
        a = a | 0
        b = b | 0
        d = d | 0
        var e = 0, f = 0, g = 0, h = 0, i = 0
        if (!b) {
          qa(135797, 135447, 194, 135455)
        }
        e = c[b + 4 >> 2] | 0
        if ((e | 0) <= -1) {
          qa(135467, 135447, 195, 135455)
        }
        if (!d) {
          qa(135739, 135447, 196, 135455)
        }
        i = a + 1952 | 0
        c[i >> 2] = (c[i >> 2] | 0) + 1
        a:do {
          if ((e | 0) > 0) {
            i = 0
            e = 0
            while (1) {
              if ((i | 0) == 64) {
                break a
              }
              f = b + 8 + (i * 20 | 0) + 16 | 0
              if ((c[f >> 2] | 0) != 0 ? (TS(d, b + 8 + (i * 20 | 0) | 0) | 0) != 0 : 0) {
                g = FS(a, c[f >> 2] | 0, d) | 0
                if (!e) {
                  e = g
                } else {
                  f = e
                  while (1) {
                    h = c[f >> 2] | 0
                    if (!h) {
                      break
                    } else {
                      f = h
                    }
                  }
                  c[f >> 2] = g
                }
              }
              i = i + 1 | 0
            }
          } else {
            g = 0
            e = 0
            while (1) {
              if ((g | 0) == 64) {
                break a
              }
              f = b + 8 + (g * 20 | 0) | 0
              if ((c[b + 8 + (g * 20 | 0) + 16 >> 2] | 0) != 0 ? (TS(d, f) | 0) != 0 : 0) {
                e = zS(e, f) | 0
              }
              g = g + 1 | 0
            }
          }
        } while (0)
        return e | 0
      }

      function GS(a, b, d, e, f) {
        a = a | 0
        b = b | 0
        d = d | 0
        e = e | 0
        f = f | 0
        var g = 0, h = 0, i = 0, j = 0, k = 0, m = 0, n = 0, o = 0, p = 0, q = 0
        p = l
        l = l + 64 | 0
        k = p + 52 | 0
        m = p + 32 | 0
        n = p + 16 | 0
        o = p
        c[k >> 2] = 0
        if (!((b | 0) != 0 & (e | 0) != 0)) {
          qa(135653, 135447, 247, 135481)
        }
        if ((f | 0) > -1 ? (j = c[e >> 2] | 0, (c[j + 4 >> 2] | 0) >= (f | 0)) : 0) {
          g = 0
          while (1) {
            if ((g | 0) >= 2) {
              break
            }
            if ((c[b + (g << 2) >> 2] | 0) > (c[b + (g + 2 << 2) >> 2] | 0)) {
              h = 8
              break
            } else {
              g = g + 1 | 0
            }
          }
          if ((h | 0) == 8) {
            qa(135528, 135447, 250, 135481)
          }
          i = a + 1912 | 0
          g = a + 1908 | 0
          h = c[g >> 2] | 0
          if (c[i >> 2] | 0) {
            q = h | 0 ? a + 1924 | 0 : a + 1916 | 0
            c[q >> 2] = (c[q >> 2] | 0) + 1
          }
          if (!h) {
            q = a + 1964 | 0
            c[q >> 2] = (c[q >> 2] | 0) + 1
          }
          if (!(HS(a, b, d, j, k, f) | 0)) {
            g = 0
          } else {
            if (c[i >> 2] | 0) {
              q = c[g >> 2] | 0 ? a + 1948 | 0 : a + 1944 | 0
              c[q >> 2] = (c[q >> 2] | 0) + 1
            }
            g = IS(a) | 0
            q = a + 1976 | 0
            c[q >> 2] = (c[q >> 2] | 0) + 1
            q = c[e >> 2] | 0
            c[g + 4 >> 2] = (c[q + 4 >> 2] | 0) + 1
            LS(n, q)
            c[m >> 2] = c[n >> 2]
            c[m + 4 >> 2] = c[n + 4 >> 2]
            c[m + 8 >> 2] = c[n + 8 >> 2]
            c[m + 12 >> 2] = c[n + 12 >> 2]
            q = m + 16 | 0
            c[q >> 2] = c[e >> 2]
            NS(a, m, g, 0) | 0
            LS(o, c[k >> 2] | 0)
            c[m >> 2] = c[o >> 2]
            c[m + 4 >> 2] = c[o + 4 >> 2]
            c[m + 8 >> 2] = c[o + 8 >> 2]
            c[m + 12 >> 2] = c[o + 12 >> 2]
            c[q >> 2] = c[k >> 2]
            NS(a, m, g, 0) | 0
            c[e >> 2] = g
            g = a + 1980 | 0
            c[g >> 2] = (c[g >> 2] | 0) + 2
            g = 1
          }
          l = p
          return g | 0
        }
        qa(135493, 135447, 248, 135481)
        return 0
      }

      function HS(a, b, d, e, f, g) {
        a = a | 0
        b = b | 0
        d = d | 0
        e = e | 0
        f = f | 0
        g = g | 0
        var h = 0, i = 0, j = 0, k = 0, m = 0, n = 0, o = 0, p = 0, q = 0
        q = l
        l = l + 80 | 0
        m = q + 52 | 0
        n = q + 48 | 0
        o = q + 32 | 0
        p = q + 16 | 0
        k = q
        c[n >> 2] = 0
        if (!((b | 0) != 0 & (e | 0) != 0 & (f | 0) != 0)) {
          qa(135571, 135447, 311, 135585)
        }
        if ((g | 0) > -1 ? (i = e + 4 | 0, h = c[i >> 2] | 0, (h | 0) >= (g | 0)) : 0) {
          if (c[a + 1912 >> 2] | 0) {
            h = c[a + 1908 >> 2] | 0 ? a + 1948 | 0 : a + 1944 | 0
            c[h >> 2] = (c[h >> 2] | 0) + 1
            h = c[i >> 2] | 0
          }
          do {
            if ((h | 0) > (g | 0)) {
              i = MS(b, e) | 0
              h = e + 8 + (i * 20 | 0) + 16 | 0
              i = e + 8 + (i * 20 | 0) | 0
              if (!(HS(a, b, d, c[h >> 2] | 0, n, g) | 0)) {
                SS(o, b, i)
                c[i >> 2] = c[o >> 2]
                c[i + 4 >> 2] = c[o + 4 >> 2]
                c[i + 8 >> 2] = c[o + 8 >> 2]
                c[i + 12 >> 2] = c[o + 12 >> 2]
                j = 0
                break
              } else {
                LS(p, c[h >> 2] | 0)
                c[i >> 2] = c[p >> 2]
                c[i + 4 >> 2] = c[p + 4 >> 2]
                c[i + 8 >> 2] = c[p + 8 >> 2]
                c[i + 12 >> 2] = c[p + 12 >> 2]
                j = c[n >> 2] | 0
                c[m + 16 >> 2] = j
                LS(k, j)
                c[m >> 2] = c[k >> 2]
                c[m + 4 >> 2] = c[k + 4 >> 2]
                c[m + 8 >> 2] = c[k + 8 >> 2]
                c[m + 12 >> 2] = c[k + 12 >> 2]
                j = a + 1980 | 0
                c[j >> 2] = (c[j >> 2] | 0) + 1
                j = NS(a, m, e, f) | 0
                break
              }
            } else if ((h | 0) == (g | 0)) {
              c[m >> 2] = c[b >> 2]
              c[m + 4 >> 2] = c[b + 4 >> 2]
              c[m + 8 >> 2] = c[b + 8 >> 2]
              c[m + 12 >> 2] = c[b + 12 >> 2]
              c[m + 16 >> 2] = d
              j = a + 1980 | 0
              c[j >> 2] = (c[j >> 2] | 0) + 1
              j = NS(a, m, e, f) | 0
              break
            } else {
              qa(135630, 135447, 341, 135585)
            }
          } while (0)
          l = q
          return j | 0
        }
        qa(135598, 135447, 312, 135585)
        return 0
      }

      function IS(a) {
        a = a | 0
        a = a + 1968 | 0
        c[a >> 2] = (c[a >> 2] | 0) + 1
        a = B_(1288) | 0
        JS(a)
        return a | 0
      }

      function JS(a) {
        a = a | 0
        var b = 0
        c[a >> 2] = 0
        c[a + 4 >> 2] = -1
        b = 0
        while (1) {
          if ((b | 0) == 64) {
            break
          }
          KS(a + 8 + (b * 20 | 0) | 0)
          b = b + 1 | 0
        }
        return
      }

      function KS(a) {
        a = a | 0
        PS(a)
        c[a + 16 >> 2] = 0
        return
      }

      function LS(a, b) {
        a = a | 0
        b = b | 0
        var d = 0, e = 0, f = 0, g = 0, h = 0, i = 0
        i = l
        l = l + 32 | 0
        g = i + 16 | 0
        h = i
        if (!b) {
          qa(135797, 135636, 99, 135643)
        }
        PS(g)
        d = 1
        f = 0
        while (1) {
          if ((f | 0) == 64) {
            break
          }
          do {
            if (c[b + 8 + (f * 20 | 0) + 16 >> 2] | 0) {
              e = b + 8 + (f * 20 | 0) | 0
              if (!d) {
                SS(h, g, e)
                c[g >> 2] = c[h >> 2]
                c[g + 4 >> 2] = c[h + 4 >> 2]
                c[g + 8 >> 2] = c[h + 8 >> 2]
                c[g + 12 >> 2] = c[h + 12 >> 2]
                d = 0
                break
              } else {
                c[g >> 2] = c[e >> 2]
                c[g + 4 >> 2] = c[e + 4 >> 2]
                c[g + 8 >> 2] = c[e + 8 >> 2]
                c[g + 12 >> 2] = c[e + 12 >> 2]
                d = 0
                break
              }
            }
          } while (0)
          f = f + 1 | 0
        }
        c[a >> 2] = c[g >> 2]
        c[a + 4 >> 2] = c[g + 4 >> 2]
        c[a + 8 >> 2] = c[g + 8 >> 2]
        c[a + 12 >> 2] = c[g + 12 >> 2]
        l = i
        return
      }

      function MS(a, b) {
        a = a | 0
        b = b | 0
        var d = 0, e = 0, f = 0, g = 0, h = 0, i = 0, j = 0, k = 0, m = 0, n = 0, o = 0, p = 0
        k = l
        l = l + 32 | 0
        i = k + 16 | 0
        j = k
        if (!((a | 0) != 0 & (b | 0) != 0)) {
          qa(135653, 135636, 125, 135660)
        }
        d = 0
        e = 0
        f = 0
        g = 1
        h = 0
        while (1) {
          if ((h | 0) == 64) {
            break
          }
          if (c[b + 8 + (h * 20 | 0) + 16 >> 2] | 0) {
            n = b + 8 + (h * 20 | 0) | 0
            p = RS(n) | 0
            SS(j, a, n)
            c[i >> 2] = c[j >> 2]
            c[i + 4 >> 2] = c[j + 4 >> 2]
            c[i + 8 >> 2] = c[j + 8 >> 2]
            c[i + 12 >> 2] = c[j + 12 >> 2]
            n = (RS(i) | 0) - p | 0
            m = (g | 0) != 0 | (n | 0) < (f | 0)
            o = m | (p | 0) < (e | 0) & (n | 0) == (f | 0)
            d = o ? h : d
            e = o ? p : e
            f = o ? n : f
            g = m ? 0 : g
          }
          h = h + 1 | 0
        }
        l = k
        return d | 0
      }

      function NS(a, b, d, e) {
        a = a | 0
        b = b | 0
        d = d | 0
        e = e | 0
        var f = 0, g = 0, h = 0
        if (!b) {
          qa(135819, 135636, 167, 135671)
        }
        if (!d) {
          qa(135797, 135636, 168, 135671)
        }
        do {
          if ((c[d >> 2] | 0) < 64) {
            a = 0
            while (1) {
              if ((a | 0) >= 64) {
                e = 10
                break
              }
              if (!(c[d + 8 + (a * 20 | 0) + 16 >> 2] | 0)) {
                e = 8
                break
              }
              a = a + 1 | 0
            }
            if ((e | 0) == 8) {
              f = d + 8 + (a * 20 | 0) | 0
              c[f >> 2] = c[b >> 2]
              c[f + 4 >> 2] = c[b + 4 >> 2]
              c[f + 8 >> 2] = c[b + 8 >> 2]
              c[f + 12 >> 2] = c[b + 12 >> 2]
              c[f + 16 >> 2] = c[b + 16 >> 2]
              f = 0
              g = d
              break
            } else if ((e | 0) == 10) {
              qa(135681, 135636, 178, 135671)
            }
          } else {
            if (c[a + 1912 >> 2] | 0) {
              h = c[a + 1908 >> 2] | 0 ? a + 1948 | 0 : a + 1944 | 0
              c[h >> 2] = (c[h >> 2] | 0) + 1
            }
            if (!e) {
              qa(135694, 135636, 187, 135671)
            } else {
              US(a, d, b, e)
              f = 1
              g = (c[d + 4 >> 2] | 0) == 0 ? a + 1972 | 0 : a + 1976 | 0
              break
            }
          }
        } while (0)
        c[g >> 2] = (c[g >> 2] | 0) + 1
        return f | 0
      }

      function OS(a, b) {
        a = a | 0
        b = b | 0
        if (!((a | 0) != 0 & b >>> 0 < 64)) {
          qa(135698, 135636, 201, 135726)
        }
        if (!(c[a + 8 + (b * 20 | 0) + 16 >> 2] | 0)) {
          qa(136220, 135636, 202, 135726)
        } else {
          KS(a + 8 + (b * 20 | 0) | 0)
          c[a >> 2] = (c[a >> 2] | 0) + -1
          return
        }
      }

      function PS(a) {
        a = a | 0
        var b = 0
        b = 0
        while (1) {
          if ((b | 0) == 4) {
            break
          }
          c[a + (b << 2) >> 2] = 0
          b = b + 1 | 0
        }
        return
      }

      function QS(a) {
        a = a | 0
        var b = 0, d = 0, e = 0
        e = l
        l = l + 16 | 0
        d = e
        c[d >> 2] = 1
        c[d + 8 >> 2] = -1
        b = 1
        while (1) {
          if ((b | 0) == 2) {
            break
          }
          c[d + (b + 2 << 2) >> 2] = 0
          c[d + (b << 2) >> 2] = 0
          b = b + 1 | 0
        }
        c[a >> 2] = c[d >> 2]
        c[a + 4 >> 2] = c[d + 4 >> 2]
        c[a + 8 >> 2] = c[d + 8 >> 2]
        c[a + 12 >> 2] = c[d + 12 >> 2]
        l = e
        return
      }

      function RS(a) {
        a = a | 0
        var b = 0, d = 0, e = 0
        if (!a) {
          qa(135739, 135741, 128, 135753)
        }
        a:do {
          if ((c[a >> 2] | 0) > (c[a + 8 >> 2] | 0)) {
            b = 0
          } else {
            b = 1
            d = 0
            while (1) {
              if ((d | 0) == 2) {
                break a
              }
              e = O(c[a + (d + 2 << 2) >> 2] | 0, b) | 0
              b = e - (c[a + (d << 2) >> 2] | 0) | 0
              d = d + 1 | 0
            }
          }
        } while (0)
        return b | 0
      }

      function SS(a, b, d) {
        a = a | 0
        b = b | 0
        d = d | 0
        var e = 0, f = 0, g = 0, h = 0, i = 0, j = 0
        g = l
        l = l + 16 | 0
        f = g
        if (!((b | 0) != 0 & (d | 0) != 0)) {
          qa(135762, 135741, 195, 135770)
        }
        do {
          if ((c[b >> 2] | 0) > (c[b + 8 >> 2] | 0)) {
            c[a >> 2] = c[d >> 2]
            c[a + 4 >> 2] = c[d + 4 >> 2]
            c[a + 8 >> 2] = c[d + 8 >> 2]
            c[a + 12 >> 2] = c[d + 12 >> 2]
          } else {
            if ((c[d >> 2] | 0) > (c[d + 8 >> 2] | 0)) {
              c[a >> 2] = c[b >> 2]
              c[a + 4 >> 2] = c[b + 4 >> 2]
              c[a + 8 >> 2] = c[b + 8 >> 2]
              c[a + 12 >> 2] = c[b + 12 >> 2]
              break
            } else {
              e = 0
            }
            while (1) {
              if ((e | 0) == 2) {
                break
              }
              j = c[b + (e << 2) >> 2] | 0
              h = c[d + (e << 2) >> 2] | 0
              c[f + (e << 2) >> 2] = (j | 0) < (h | 0) ? j : h
              h = e + 2 | 0
              j = c[b + (h << 2) >> 2] | 0
              i = c[d + (h << 2) >> 2] | 0
              c[f + (h << 2) >> 2] = (j | 0) > (i | 0) ? j : i
              e = e + 1 | 0
            }
            c[a >> 2] = c[f >> 2]
            c[a + 4 >> 2] = c[f + 4 >> 2]
            c[a + 8 >> 2] = c[f + 8 >> 2]
            c[a + 12 >> 2] = c[f + 12 >> 2]
          }
        } while (0)
        l = g
        return
      }

      function TS(a, b) {
        a = a | 0
        b = b | 0
        var d = 0, e = 0
        if ((a | 0) != 0 & (b | 0) != 0) {
          d = 0
        } else {
          qa(135782, 135741, 216, 135789)
        }
        while (1) {
          if ((d | 0) >= 2) {
            d = 1
            break
          }
          e = d + 2 | 0
          if ((c[a + (d << 2) >> 2] | 0) > (c[b + (e << 2) >> 2] | 0)) {
            d = 0
            break
          }
          if ((c[b + (d << 2) >> 2] | 0) > (c[a + (e << 2) >> 2] | 0)) {
            d = 0
            break
          } else {
            d = d + 1 | 0
          }
        }
        return d | 0
      }

      function US(a, b, d, e) {
        a = a | 0
        b = b | 0
        d = d | 0
        e = e | 0
        var f = 0, h = 0, i = 0, j = 0
        if (!b) {
          qa(135797, 135799, 40, 135809)
        }
        if (!d) {
          qa(135819, 135799, 41, 135809)
        }
        j = a + 1912 | 0
        if (c[j >> 2] | 0) {
          i = c[a + 1908 >> 2] | 0 ? a + 1932 | 0 : a + 1928 | 0
          c[i >> 2] = (c[i >> 2] | 0) + 1
        }
        h = b + 4 | 0
        i = c[h >> 2] | 0
        VS(a, b, d)
        d = a + 1324 | 0
        WS(a)
        f = RS(a + 1852 | 0) | 0
        f = (RS(a + 1868 | 0) | 0) + f | 0
        if (c[j >> 2] | 0 ? (f | 0) != 0 & (c[a + 1908 >> 2] | 0) == 0 : 0) {
          j = a + 1960 | 0
          g[j >> 2] = +((c[a + 1320 >> 2] | 0) >>> 0) / +(f | 0) + +g[j >> 2]
        }
        j = IS(a) | 0
        c[e >> 2] = j
        c[h >> 2] = i
        c[j + 4 >> 2] = i
        XS(a, b, j, d)
        if (((c[c[e >> 2] >> 2] | 0) + (c[b >> 2] | 0) | 0) == 65) {
          return
        } else {
          qa(135821, 135799, 86, 135809)
        }
      }

      function VS(a, b, d) {
        a = a | 0
        b = b | 0
        d = d | 0
        var e = 0, f = 0, g = 0, h = 0, i = 0, j = 0
        h = l
        l = l + 16 | 0
        g = h
        if (!b) {
          qa(135797, 135799, 106, 136208)
        }
        if (!d) {
          qa(135819, 135799, 107, 136208)
        } else {
          e = 0
        }
        while (1) {
          if ((e | 0) >= 64) {
            break
          }
          if (!(c[b + 8 + (e * 20 | 0) + 16 >> 2] | 0)) {
            f = 7
            break
          }
          j = b + 8 + (e * 20 | 0) | 0
          i = a + 4 + (e * 20 | 0) | 0
          c[i >> 2] = c[j >> 2]
          c[i + 4 >> 2] = c[j + 4 >> 2]
          c[i + 8 >> 2] = c[j + 8 >> 2]
          c[i + 12 >> 2] = c[j + 12 >> 2]
          c[i + 16 >> 2] = c[j + 16 >> 2]
          e = e + 1 | 0
        }
        if ((f | 0) == 7) {
          qa(136220, 135799, 111, 136208)
        }
        e = a + 4 | 0
        j = a + 1284 | 0
        c[j >> 2] = c[d >> 2]
        c[j + 4 >> 2] = c[d + 4 >> 2]
        c[j + 8 >> 2] = c[d + 8 >> 2]
        c[j + 12 >> 2] = c[d + 12 >> 2]
        c[j + 16 >> 2] = c[d + 16 >> 2]
        d = a + 1304 | 0
        c[d >> 2] = c[e >> 2]
        c[d + 4 >> 2] = c[e + 4 >> 2]
        c[d + 8 >> 2] = c[e + 8 >> 2]
        c[d + 12 >> 2] = c[e + 12 >> 2]
        e = 1
        while (1) {
          if ((e | 0) == 65) {
            break
          }
          SS(g, d, a + 4 + (e * 20 | 0) | 0)
          c[d >> 2] = c[g >> 2]
          c[d + 4 >> 2] = c[g + 4 >> 2]
          c[d + 8 >> 2] = c[g + 8 >> 2]
          c[d + 12 >> 2] = c[g + 12 >> 2]
          e = e + 1 | 0
        }
        c[a + 1320 >> 2] = RS(d) | 0
        JS(b)
        l = h
        return
      }

      function WS(a) {
        a = a | 0
        var b = 0, d = 0, e = 0, f = 0, g = 0, h = 0, i = 0, j = 0, k = 0, m = 0, n = 0, o = 0, p = 0, q = 0, r = 0,
            s = 0, t = 0, u = 0, v = 0
        u = l
        l = l + 48 | 0
        i = u + 32 | 0
        k = u + 16 | 0
        m = u
        YS(a)
        ZS(a)
        q = a + 1844 | 0
        s = a + 1848 | 0
        t = a + 1892 | 0
        n = a + 1852 | 0
        o = a + 1884 | 0
        p = a + 1868 | 0
        j = a + 1888 | 0
        f = 0
        e = 0
        while (1) {
          d = c[q >> 2] | 0
          b = c[s >> 2] | 0
          if ((b + d | 0) >= 65) {
            break
          }
          h = 65 - (c[t >> 2] | 0) | 0
          if ((d | 0) < (h | 0) & (b | 0) < (h | 0)) {
            g = -1
            h = 0
          } else {
            r = 12
            break
          }
          while (1) {
            if ((h | 0) == 65) {
              break
            }
            if (!(c[a + 1584 + (h << 2) >> 2] | 0)) {
              v = a + 4 + (h * 20 | 0) | 0
              SS(k, v, n)
              c[i >> 2] = c[k >> 2]
              c[i + 4 >> 2] = c[k + 4 >> 2]
              c[i + 8 >> 2] = c[k + 8 >> 2]
              c[i + 12 >> 2] = c[k + 12 >> 2]
              b = RS(i) | 0
              d = c[o >> 2] | 0
              SS(m, v, p)
              c[i >> 2] = c[m >> 2]
              c[i + 4 >> 2] = c[m + 4 >> 2]
              c[i + 8 >> 2] = c[m + 8 >> 2]
              c[i + 12 >> 2] = c[m + 12 >> 2]
              v = RS(i) | 0
              b = v - (c[j >> 2] | 0) + (d - b) | 0
              d = (b | 0) > -1
              b = d ? b : 0 - b | 0
              d = (d ^ 1) & 1
              if ((b | 0) <= (g | 0)) {
                if ((b | 0) == (g | 0)) {
                  v = (c[a + 1844 + (d << 2) >> 2] | 0) < (c[a + 1844 + (f << 2) >> 2] | 0)
                  b = g
                  d = v ? d : f
                  e = v ? h : e
                } else {
                  b = g
                  d = f
                }
              } else {
                e = h
              }
            } else {
              b = g
              d = f
            }
            g = b
            h = h + 1 | 0
            f = d
          }
          _S(a, e, f)
        }
        if ((r | 0) == 12) {
          b = (d | 0) >= (65 - (c[t >> 2] | 0) | 0) & 1
          d = 0
          while (1) {
            if ((d | 0) == 65) {
              break
            }
            if (!(c[a + 1584 + (d << 2) >> 2] | 0)) {
              _S(a, d, b)
            }
            d = d + 1 | 0
          }
          d = c[q >> 2] | 0
          b = c[s >> 2] | 0
        }
        if ((b + d | 0) != 65) {
          qa(135964, 135799, 210, 136050)
        }
        v = c[t >> 2] | 0
        if ((d | 0) < (v | 0) | (b | 0) < (v | 0)) {
          qa(136061, 135799, 212, 136050)
        } else {
          l = u
          return
        }
      }

      function XS(a, b, d, e) {
        a = a | 0
        b = b | 0
        d = d | 0
        e = e | 0
        var f = 0
        if (!b) {
          qa(135797, 135799, 297, 135861)
        }
        if (!d) {
          qa(135871, 135799, 298, 135861)
        }
        if (!e) {
          qa(135873, 135799, 299, 135861)
        } else {
          f = 0
        }
        while (1) {
          if ((f | 0) >= 65) {
            e = 14
            break
          }
          e = c[a + 1324 + (f << 2) >> 2] | 0
          if (e >>> 0 >= 2) {
            e = 9
            break
          }
          switch (e | 0) {
            case 0: {
              NS(a, a + 4 + (f * 20 | 0) | 0, b, 0) | 0
              break
            }
            case 1: {
              NS(a, a + 4 + (f * 20 | 0) | 0, d, 0) | 0
              break
            }
            default: {
            }
          }
          f = f + 1 | 0
        }
        if ((e | 0) == 9) {
          qa(135875, 135799, 303, 135861)
        } else if ((e | 0) == 14) {
          return
        }
      }

      function YS(a) {
        a = a | 0
        var b = 0, d = 0, e = 0, f = 0
        d = l
        l = l + 16 | 0
        e = d
        c[a + 1848 >> 2] = 0
        c[a + 1844 >> 2] = 0
        b = a + 1852 | 0
        f = a + 1868 | 0
        QS(e)
        c[f >> 2] = c[e >> 2]
        c[f + 4 >> 2] = c[e + 4 >> 2]
        c[f + 8 >> 2] = c[e + 8 >> 2]
        c[f + 12 >> 2] = c[e + 12 >> 2]
        c[b >> 2] = c[e >> 2]
        c[b + 4 >> 2] = c[e + 4 >> 2]
        c[b + 8 >> 2] = c[e + 8 >> 2]
        c[b + 12 >> 2] = c[e + 12 >> 2]
        c[a + 1888 >> 2] = 0
        c[a + 1884 >> 2] = 0
        b = 0
        while (1) {
          if ((b | 0) == 65) {
            break
          }
          c[a + 1584 + (b << 2) >> 2] = 0
          c[a + 1324 + (b << 2) >> 2] = -1
          b = b + 1 | 0
        }
        l = d
        return
      }

      function ZS(a) {
        a = a | 0
        var b = 0, d = 0, e = 0, f = 0, g = 0, h = 0, i = 0, j = 0, k = 0, m = 0, n = 0, o = 0, p = 0, q = 0, r = 0
        o = l
        l = l + 304 | 0
        k = o + 32 | 0
        m = o + 16 | 0
        n = o
        b = 0
        while (1) {
          if ((b | 0) == 65) {
            break
          }
          c[k + (b << 2) >> 2] = RS(a + 4 + (b * 20 | 0) | 0) | 0
          b = b + 1 | 0
        }
        b = 0
        d = 0
        e = 0
        g = 0
        a:while (1) {
          if ((g | 0) == 64) {
            break
          }
          i = g + 1 | 0
          j = a + 4 + (g * 20 | 0) | 0
          h = k + (g << 2) | 0
          f = i
          while (1) {
            if ((f | 0) == 65) {
              g = i
              continue a
            }
            SS(n, j, a + 4 + (f * 20 | 0) | 0)
            c[m >> 2] = c[n >> 2]
            c[m + 4 >> 2] = c[n + 4 >> 2]
            c[m + 8 >> 2] = c[n + 8 >> 2]
            c[m + 12 >> 2] = c[n + 12 >> 2]
            p = RS(m) | 0
            p = p - (c[h >> 2] | 0) - (c[k + (f << 2) >> 2] | 0) | 0
            q = p >>> 0 > e >>> 0
            r = q ? f : b
            f = f + 1 | 0
            b = r
            d = q ? g : d
            e = q ? p : e
          }
        }
        _S(a, d, 0)
        _S(a, b, 1)
        l = o
        return
      }

      function _S(a, b, d) {
        a = a | 0
        b = b | 0
        d = d | 0
        var e = 0, f = 0, g = 0, h = 0, i = 0
        i = l
        l = l + 16 | 0
        h = i
        e = a + 1584 + (b << 2) | 0
        if (c[e >> 2] | 0) {
          qa(136164, 135799, 257, 136199)
        }
        c[a + 1324 + (b << 2) >> 2] = d
        c[e >> 2] = 1
        g = a + 1844 + (d << 2) | 0
        f = a + 1852 + (d << 4) | 0
        e = a + 4 + (b * 20 | 0) | 0
        if (!(c[g >> 2] | 0)) {
          c[f >> 2] = c[e >> 2]
          c[f + 4 >> 2] = c[e + 4 >> 2]
          c[f + 8 >> 2] = c[e + 8 >> 2]
          c[f + 12 >> 2] = c[e + 12 >> 2]
        } else {
          SS(h, e, f)
          c[f >> 2] = c[h >> 2]
          c[f + 4 >> 2] = c[h + 4 >> 2]
          c[f + 8 >> 2] = c[h + 8 >> 2]
          c[f + 12 >> 2] = c[h + 12 >> 2]
        }
        c[a + 1884 + (d << 2) >> 2] = RS(f) | 0
        c[g >> 2] = (c[g >> 2] | 0) + 1
        l = i
        return
      }

      function $S() {
        var e = 0, f = 0, g = 0, h = 0, i = 0, j = 0, k = 0, m = 0, n = 0, o = 0, p = 0, q = 0, r = 0, s = 0, t = 0
        t = l
        l = l + 1200 | 0
        r = t + 800 | 0
        g = t
        c[46627] = 0
        c[46628] = -2
        f = r
        i = 200
        n = g
        p = 0
        q = 0
        o = r
        a:while (1) {
          b[o >> 1] = p
          if ((f + (i << 1) + -2 | 0) >>> 0 > o >>> 0) {
            k = i
          } else {
            m = o - f >> 1
            e = m + 1 | 0
            if (i >>> 0 > 9999) {
              s = 95
              break
            }
            k = i << 1
            k = k >>> 0 < 1e4 ? k : 1e4
            h = B_(k * 6 | 3) | 0
            if (h) {
              E3(h | 0, f | 0, e << 1 | 0) | 0
              i = h + (k >>> 1 << 2) | 0
              E3(i | 0, n | 0, e << 2 | 0) | 0
              if ((f | 0) == (r | 0)) {
                e = 0
                f = h
              } else {
                C_(f)
                e = 0
                f = h
              }
            } else {
              e = 4
              i = n
            }
            j = (e | 0) == 0
            h = f + (m << 1) | 0
            switch ((j ? ((f + (k << 1) + -2 | 0) >>> 0 > h >>> 0 ? 0 : 9) : e) & 15) {
              case 9: {
                e = 1
                s = 96
                break a
              }
              case 4: {
                s = 95
                break a
              }
              case 0: {
                g = j ? i + (m << 2) | 0 : g
                n = i
                o = j ? h : o
                break
              }
              default: {
                e = 0
                break a
              }
            }
          }
          if ((p | 0) == 31) {
            e = 0
            s = 96
            break
          }
          e = b[65430 + (p << 1) >> 1] | 0
          j = e << 16 >> 16
          do {
            if (e << 16 >> 16 != -82) {
              h = c[46628] | 0
              if ((h | 0) == -2) {
                h = oU() | 0
                c[46628] = h
              }
              if ((h | 0) >= 1) {
                if (h >>> 0 < 296) {
                  i = d[136239 + h >> 0] | 0
                } else {
                  i = 2
                }
              } else {
                c[46628] = 0
                i = 0
              }
              h = i + j | 0
              if (h >>> 0 <= 271 ? (i | 0) == (a[136535 + h >> 0] | 0) : 0) {
                p = a[136807 + h >> 0] | 0
                e = p << 24 >> 24
                if (p << 24 >> 24 < 1) {
                  h = 0 - e | 0
                  s = 23
                  break
                } else {
                  c[46628] = -2
                  g = g + 4 | 0
                  c[g >> 2] = c[46629]
                  j = (q | 0) == 0 ? 0 : q + -1 | 0
                  h = o
                  break
                }
              } else {
                s = 22
              }
            } else {
              s = 22
            }
          } while (0)
          if ((s | 0) == 22) {
            s = 0
            p = a[137079 + p >> 0] | 0
            h = p & 255
            if (!(p << 24 >> 24)) {
              h = c[46628] | 0
              b:do {
                switch (q | 0) {
                  case 0: {
                    c[46627] = (c[46627] | 0) + 1
                    uT(140679)
                    h = o
                    break
                  }
                  case 3:
                    if ((h | 0) < 1) {
                      if (!h) {
                        e = 1
                        s = 96
                        break a
                      } else {
                        h = o
                        break b
                      }
                    } else {
                      c[46628] = -2
                      h = o
                      break b
                    }
                  default:
                    h = o
                }
              } while (0)
              while (1) {
                if (e << 16 >> 16 == 8) {
                  break
                }
                if ((h | 0) == (f | 0)) {
                  e = 1
                  s = 96
                  break a
                }
                e = h + -2 | 0
                g = g + -4 | 0
                h = e
                e = b[65430 + (b[e >> 1] << 1) >> 1] | 0
              }
              g = g + 4 | 0
              c[g >> 2] = c[46629]
              e = 1
              j = 3
            } else {
              s = 23
            }
          }
          do {
            if ((s | 0) == 23) {
              s = 0
              j = d[137195 + h >> 0] | 0
              e = c[g + (1 - j << 2) >> 2] | 0
              do {
                switch (h | 0) {
                  case 4: {
                    s = 26
                    break a
                  }
                  case 2: {
                    c[46630] = aT(c[g + -4 >> 2] | 0, 2) | 0
                    break
                  }
                  case 3: {
                    c[46630] = aT(c[g + -4 >> 2] | 0, 1) | 0
                    break
                  }
                  case 5: {
                    e = cT() | 0
                    break
                  }
                  case 8: {
                    dT(c[46631] | 0)
                    break
                  }
                  case 9: {
                    eT(c[g >> 2] | 0)
                    break
                  }
                  case 18: {
                    fT(c[g >> 2] | 0)
                    break
                  }
                  case 19: {
                    gT()
                    break
                  }
                  case 20: {
                    fT(c[g >> 2] | 0)
                    break
                  }
                  case 21: {
                    gT()
                    break
                  }
                  case 22: {
                    fT(c[g >> 2] | 0)
                    break
                  }
                  case 23: {
                    gT()
                    break
                  }
                  case 24: {
                    fT(c[g >> 2] | 0)
                    break
                  }
                  case 25: {
                    gT()
                    break
                  }
                  case 26: {
                    fT(c[g >> 2] | 0)
                    break
                  }
                  case 27: {
                    gT()
                    break
                  }
                  case 28: {
                    fT(c[g >> 2] | 0)
                    break
                  }
                  case 29: {
                    gT()
                    break
                  }
                  case 30: {
                    fT(c[g >> 2] | 0)
                    break
                  }
                  case 31: {
                    gT()
                    break
                  }
                  case 32: {
                    fT(c[g >> 2] | 0)
                    break
                  }
                  case 33: {
                    gT()
                    break
                  }
                  case 34: {
                    e = c[g + -4 >> 2] | 0
                    break
                  }
                  case 35: {
                    e = c[g >> 2] | 0
                    break
                  }
                  case 38: {
                    e = c[46631] | 0
                    i = c[e + 4 >> 2] | 0
                    if (i >>> 0 >= (c[e + 8 >> 2] | 0) >>> 0) {
                      Tw(e, 1) | 0
                      i = c[46631] | 0
                      e = i
                      i = c[i + 4 >> 2] | 0
                    }
                    a[i >> 0] = 0
                    p = c[e >> 2] | 0
                    c[e + 4 >> 2] = p
                    if (hT(p) | 0) {
                      s = 51
                      break a
                    }
                    c[(c[g >> 2] | 0) + 80 >> 2] = c[46632]
                    e = Bw(55928, c[4554] | 0) | 0
                    c[(c[g >> 2] | 0) + 84 >> 2] = e
                    c[46632] = c[g >> 2]
                    c[(c[g >> 2] | 0) + 108 >> 2] = c[c[46633] >> 2]
                    e = c[g >> 2] | 0
                    break
                  }
                  case 39: {
                    e = c[46631] | 0
                    i = c[e + 4 >> 2] | 0
                    if (i >>> 0 >= (c[e + 8 >> 2] | 0) >>> 0) {
                      Tw(e, 1) | 0
                      i = c[46631] | 0
                      e = i
                      i = c[i + 4 >> 2] | 0
                    }
                    a[i >> 0] = 0
                    p = c[e >> 2] | 0
                    c[e + 4 >> 2] = p
                    if (hT(p) | 0) {
                      s = 56
                      break a
                    }
                    e = c[46632] | 0
                    c[46632] = c[e + 80 >> 2]
                    break
                  }
                  case 40: {
                    e = c[g >> 2] | 0
                    break
                  }
                  case 41: {
                    e = c[g + -4 >> 2] | 0
                    break
                  }
                  case 42: {
                    e = c[g + -4 >> 2] | 0
                    break
                  }
                  case 43: {
                    e = c[g + -4 >> 2] | 0
                    break
                  }
                  case 44: {
                    e = c[g + -4 >> 2] | 0
                    break
                  }
                  case 45: {
                    e = c[g + -4 >> 2] | 0
                    break
                  }
                  case 48: {
                    e = c[g >> 2] | 0
                    break
                  }
                  case 49: {
                    e = c[g >> 2] | 0
                    break
                  }
                  case 50: {
                    a[(c[g + -8 >> 2] | 0) + 12 >> 0] = 1
                    e = c[g >> 2] | 0
                    break
                  }
                  case 51: {
                    iT()
                    break
                  }
                  case 52: {
                    e = jT() | 0
                    break
                  }
                  case 53: {
                    e = c[g >> 2] | 0
                    break
                  }
                  case 54: {
                    e = c[g >> 2] | 0
                    break
                  }
                  case 55: {
                    e = (c[g + -8 >> 2] | 0) + 100 | 0
                    a[e >> 0] = a[e >> 0] | 1
                    e = c[g >> 2] | 0
                    break
                  }
                  case 56: {
                    kT(c[g + -4 >> 2] | 0, c[g >> 2] | 0, 1)
                    break
                  }
                  case 57: {
                    e = c[g + -12 >> 2] | 0
                    break
                  }
                  case 58: {
                    kT(c[g + -4 >> 2] | 0, c[g >> 2] | 0, 2)
                    break
                  }
                  case 59: {
                    e = c[g + -12 >> 2] | 0
                    break
                  }
                  case 60: {
                    kT(c[g + -4 >> 2] | 0, c[g >> 2] | 0, 3)
                    break
                  }
                  case 61: {
                    e = c[g + -12 >> 2] | 0
                    break
                  }
                  case 62: {
                    kT(c[g >> 2] | 0, cT() | 0, 2)
                    break
                  }
                  case 63: {
                    e = c[g + -8 >> 2] | 0
                    break
                  }
                  case 64: {
                    e = c[g + -4 >> 2] | 0
                    break
                  }
                  case 65: {
                    e = c[g >> 2] | 0
                    break
                  }
                  default: {
                  }
                }
              } while (0)
              i = 0 - j | 0
              p = g + (i << 2) | 0
              i = o + (i << 1) | 0
              g = p + 4 | 0
              c[p + 4 >> 2] = e
              e = (d[137367 + h >> 0] | 0) + -41 | 0
              p = b[i >> 1] | 0
              h = p + (b[65662 + (e << 1) >> 1] | 0) | 0
              if (h >>> 0 < 272 ? (a[136535 + h >> 0] | 0) == (p | 0) : 0) {
                e = a[136807 + h >> 0] | 0
                j = q
                h = i
                break
              }
              e = a[137437 + e >> 0] | 0
              j = q
              h = i
            }
          } while (0)
          i = k
          p = e
          q = j
          o = h + 2 | 0
        }
        if ((s | 0) == 26) {
          bT()
          e = 1
          s = 96
        } else if ((s | 0) == 51) {
          uT(137265)
          bT()
          e = 1
          s = 96
        } else if ((s | 0) == 56) {
          uT(137316)
          bT()
          e = 1
          s = 96
        } else if ((s | 0) == 95) {
          uT(137476)
          e = 2
          s = 96
        }
        if ((s | 0) == 96) {
          if ((f | 0) != (r | 0)) {
            C_(f)
          }
        }
        l = t
        return e | 0
      }

      function aT(b, d) {
        b = b | 0
        d = d | 0
        var e = 0
        e = tH(8) | 0
        a[e + 4 >> 0] = d
        c[e >> 2] = b
        return e | 0
      }

      function bT() {
        var a = 0, b = 0
        a = c[46632] | 0
        b = c[46630] | 0
        if (b | 0) {
          WQ(b, 1)
          c[46630] = 0
        }
        c[13995] = 67
        while (1) {
          if (!a) {
            break
          }
          b = c[a + 80 >> 2] | 0
          oT(a)
          a = b
        }
        c[13995] = 56
        c[14004] = 68
        b = c[46635] | 0
        nb[c[b >> 2] & 63](b, 0, 64) | 0
        c[14004] = 56
        c[14013] = 69
        b = c[46636] | 0
        nb[c[b >> 2] & 63](b, 0, 64) | 0
        c[14013] = 56
        rT()
        return
      }

      function cT() {
        var a = 0, d = 0, e = 0, f = 0, g = 0, h = 0
        e = c[46636] | 0
        f = tH(40) | 0
        if (Dw(c[46635] | 0) | 0) {
          eT(0)
        }
        a = Dw(e) | 0
        b[f + 4 >> 1] = a
        a:do {
          if (!a) {
            a = e
          } else {
            c[f >> 2] = tH(a * 24 | 0) | 0
            a = 0
            d = nb[c[e >> 2] & 63](e, 0, 128) | 0
            while (1) {
              if (!d) {
                a = e
                break a
              }
              g = (c[f >> 2] | 0) + (a * 24 | 0) | 0
              h = d + 8 | 0
              c[g >> 2] = c[h >> 2]
              c[g + 4 >> 2] = c[h + 4 >> 2]
              c[g + 8 >> 2] = c[h + 8 >> 2]
              c[g + 12 >> 2] = c[h + 12 >> 2]
              c[g + 16 >> 2] = c[h + 16 >> 2]
              c[g + 20 >> 2] = c[h + 20 >> 2]
              a = a + 1 | 0
              d = nb[c[e >> 2] & 63](e, d, 8) | 0
            }
          }
        } while (0)
        nb[c[a >> 2] & 63](e, 0, 64) | 0
        return f | 0
      }

      function dT(b) {
        b = b | 0
        var d = 0, e = 0, f = 0
        e = tH(64) | 0
        f = b + 4 | 0
        d = c[f >> 2] | 0
        if (d >>> 0 >= (c[b + 8 >> 2] | 0) >>> 0) {
          Tw(b, 1) | 0
          d = c[f >> 2] | 0
        }
        a[d >> 0] = 0
        b = c[b >> 2] | 0
        c[f >> 2] = b
        c[e + 8 >> 2] = m1(b) | 0
        c[e + 12 >> 2] = c[c[46633] >> 2]
        f = c[46635] | 0
        nb[c[f >> 2] & 63](f, e, 1) | 0
        return
      }

      function eT(d) {
        d = d | 0
        var e = 0, f = 0, g = 0, h = 0, i = 0, j = 0, k = 0
        i = tH(32) | 0
        j = c[46635] | 0
        e = Dw(j) | 0
        k = i + 8 | 0
        a[i + 14 >> 0] = d
        a:do {
          if (!e) {
            c[k >> 2] = tH(56) | 0
            b[i + 12 >> 1] = 1
            h = m1(191979) | 0
            k = c[k >> 2] | 0
            c[k >> 2] = h
            c[k + 4 >> 2] = c[c[46633] >> 2]
          } else {
            b[i + 12 >> 1] = e
            c[k >> 2] = tH(e * 56 | 0) | 0
            d = 0
            e = zw(j) | 0
            while (1) {
              if (!e) {
                break a
              }
              f = (c[k >> 2] | 0) + (d * 56 | 0) | 0
              g = e + 8 | 0
              h = f + 56 | 0
              do {
                c[f >> 2] = c[g >> 2]
                f = f + 4 | 0
                g = g + 4 | 0
              } while ((f | 0) < (h | 0))
              d = d + 1 | 0
              e = c[e >> 2] | 0
            }
          }
        } while (0)
        nb[c[j >> 2] & 63](j, 0, 64) | 0
        k = c[46636] | 0
        nb[c[k >> 2] & 63](k, i, 1) | 0
        return
      }

      function fT(a) {
        a = a | 0
        var b = 0, d = 0.0, e = 0, f = 0, g = 0, i = 0, j = 0
        j = l
        l = l + 32 | 0
        g = j
        i = tH(8) | 0
        f = c[c[46633] >> 2] | 0
        c[g >> 2] = c[a >> 2]
        c[g + 4 >> 2] = c[a + 4 >> 2]
        c[g + 8 >> 2] = c[a + 8 >> 2]
        c[g + 12 >> 2] = c[a + 12 >> 2]
        c[g + 16 >> 2] = c[a + 16 >> 2]
        c[g + 20 >> 2] = c[a + 20 >> 2]
        c[g + 24 >> 2] = c[a + 24 >> 2]
        c[g + 28 >> 2] = c[a + 28 >> 2]
        if (f | 0) {
          a = g + 4 | 0
          if ((c[a >> 2] | 0) == 0 ? (b = c[f + 4 >> 2] | 0, b | 0) : 0) {
            c[a >> 2] = b
          }
          a = g + 16 | 0
          if (+h[a >> 3] < 0.0 ? (d = +h[f + 16 >> 3], d >= 0.0) : 0) {
            h[a >> 3] = d
          }
          if ((c[g >> 2] | 0) == 0 ? (e = c[f >> 2] | 0, e | 0) : 0) {
            c[g >> 2] = e
          }
          a = c[f + 24 >> 2] & 127
          if (a | 0) {
            f = g + 24 | 0
            e = c[f >> 2] | 0
            c[f >> 2] = e & 127 | a | e & -128
          }
        }
        f = c[(c[46634] | 0) + 144 >> 2] | 0
        c[i >> 2] = nb[c[f >> 2] & 63](f, g, 1) | 0
        c[i + 4 >> 2] = c[46633]
        c[46633] = i
        l = j
        return
      }

      function gT() {
        var a = 0, b = 0
        b = c[46633] | 0
        a = c[b + 4 >> 2] | 0
        C_(b)
        c[46633] = a
        return
      }

      function hT(b) {
        b = b | 0
        var c = 0
        while (1) {
          c = a[b >> 0] | 0
          if (!(c << 24 >> 24)) {
            b = 0
            break
          }
          if (c << 24 >> 24 == 32) {
            b = b + 1 | 0
          } else {
            b = 1
            break
          }
        }
        return b | 0
      }

      function iT() {
        var b = 0, d = 0, e = 0
        e = Bw(55964, c[4554] | 0) | 0
        b = c[46632] | 0
        d = tH(16) | 0
        c[d + 8 >> 2] = e
        if (a[b + 112 >> 0] & 2) {
          a[d + 12 >> 0] = 1
        }
        e = c[b + 84 >> 2] | 0
        nb[c[e >> 2] & 63](e, d, 1) | 0
        return
      }

      function jT() {
        var a = 0
        a = c[(c[46632] | 0) + 84 >> 2] | 0
        return nb[c[a >> 2] & 63](a, 0, 256) | 0
      }

      function kT(b, d, e) {
        b = b | 0
        d = d | 0
        e = e | 0
        var f = 0, g = 0, h = 0
        g = tH(16) | 0
        f = c[46632] | 0
        h = c[f + 84 >> 2] | 0
        h = c[(nb[c[h >> 2] & 63](h, 0, 256) | 0) + 8 >> 2] | 0
        c[g + 8 >> 2] = b
        nb[c[h >> 2] & 63](h, g, 1) | 0
        a[b + 92 >> 0] = e
        if (a[f + 112 >> 0] & 1) {
          a[b + 100 >> 0] = 1
        }
        c[b + 88 >> 2] = d
        return
      }

      function lT(a, b, c) {
        a = a | 0
        b = b | 0
        c = c | 0
        C_(b)
        return
      }

      function mT(a, b, d) {
        a = a | 0
        b = b | 0
        d = d | 0
        xw(c[b + 8 >> 2] | 0) | 0
        C_(b)
        return
      }

      function nT(a, b, d) {
        a = a | 0
        b = b | 0
        d = d | 0
        sT(c[b + 8 >> 2] | 0)
        C_(b)
        return
      }

      function oT(a) {
        a = a | 0
        xw(c[a + 84 >> 2] | 0) | 0
        TQ(a)
        C_(a)
        return
      }

      function pT(a, b, d) {
        a = a | 0
        b = b | 0
        d = d | 0
        C_(c[b + 8 >> 2] | 0)
        C_(b)
        return
      }

      function qT(a, d, e) {
        a = a | 0
        d = d | 0
        e = e | 0
        var f = 0, g = 0, h = 0
        g = d + 12 | 0
        a = b[g >> 1] | 0
        if (a << 16 >> 16) {
          h = d + 8 | 0
          e = 0
          f = c[h >> 2] | 0
          while (1) {
            if ((e | 0) >= (a << 16 >> 16 | 0)) {
              break
            }
            C_(c[f >> 2] | 0)
            e = e + 1 | 0
            f = f + 56 | 0
            a = b[g >> 1] | 0
          }
          C_(c[h >> 2] | 0)
        }
        C_(d)
        return
      }

      function rT() {
        var a = 0, b = 0
        a = c[46633] | 0
        while (1) {
          b = c[a + 4 >> 2] | 0
          if (!b) {
            break
          }
          C_(a)
          a = b
        }
        return
      }

      function sT(b) {
        b = b | 0
        var d = 0
        d = b + 88 | 0
        switch (a[b + 92 >> 0] | 0) {
          case 1: {
            oT(c[d >> 2] | 0)
            break
          }
          case 2: {
            UQ(c[d >> 2] | 0)
            break
          }
          default: {
          }
        }
        TQ(b)
        C_(b)
        return
      }

      function tT(a, b, d) {
        a = a | 0
        b = b | 0
        d = d | 0
        var e = 0, f = 0, g = 0
        f = l
        l = l + 160 | 0
        e = f + 8 | 0
        g = f
        c[g >> 2] = 0
        c[g + 4 >> 2] = 0
        c[46633] = g
        c[46632] = 0
        c[46630] = 0
        c[46634] = c[(c[(c[d + 52 >> 2] | 0) + 16 >> 2] | 0) + 144 >> 2]
        c[46635] = Bw(56e3, c[4554] | 0) | 0
        c[46636] = Bw(56036, c[4554] | 0) | 0
        Sw(e, 128, f + 24 | 0)
        c[46631] = e
        if (!(xT(a, e, d) | 0)) {
          $S() | 0
          c[b >> 2] = nU() | 0
          a = c[46630] | 0
        } else {
          c[b >> 2] = 2
          a = 0
        }
        xw(c[46635] | 0) | 0
        xw(c[46636] | 0) | 0
        c[46635] = 0
        c[46636] = 0
        c[46633] = 0
        Ww(e)
        l = f
        return a | 0
      }

      function uT(b) {
        b = b | 0
        var d = 0, e = 0, f = 0
        e = l
        l = l + 16 | 0
        d = e
        if (!(a[186581] | 0)) {
          a[186581] = 1
          f = vT() | 0
          c[d >> 2] = b
          c[d + 4 >> 2] = f
          Ow(1, 137493, d) | 0
          wT()
        }
        l = e
        return
      }

      function vT() {
        return cX(c[46637] | 0) | 0
      }

      function wT() {
        var b = 0, d = 0, e = 0, f = 0
        f = l
        l = l + 16 | 0
        e = f
        b = c[46640] | 0
        c[b + 4 >> 2] = c[b >> 2]
        d = c[46649] | 0
        if ((d | 0) > 0) {
          Uw(b, c[46647] | 0, d) | 0
          b = c[46640] | 0
        }
        Uw(b, c[46646] | 0, c[46648] | 0) | 0
        d = c[46640] | 0
        b = c[d + 4 >> 2] | 0
        if (b >>> 0 >= (c[d + 8 >> 2] | 0) >>> 0) {
          Tw(d, 1) | 0
          b = c[46640] | 0
          d = b
          b = c[b + 4 >> 2] | 0
        }
        c[d + 4 >> 2] = b + 1
        a[b >> 0] = 0
        b = c[46640] | 0
        d = c[b >> 2] | 0
        c[b + 4 >> 2] = d
        c[e >> 2] = d
        Ow(3, 137509, e) | 0
        l = f
        return
      }

      function xT(b, e, f) {
        b = b | 0
        e = e | 0
        f = f | 0
        c[46640] = e
        Sw(186564, 128, 0)
        c[46638] = b
        a[186583] = 0
        a[186580] = 0
        a[186581] = 0
        c[46648] = 0
        c[46649] = 0
        a[186582] = 1
        f = f + 52 | 0
        e = CV(gH(d[(c[(c[f >> 2] | 0) + 16 >> 2] | 0) + 115 >> 0] | 0) | 0) | 0
        c[46637] = e
        RW(e, c[(c[(c[f >> 2] | 0) + 16 >> 2] | 0) + 144 >> 2] | 0)
        SW(c[46637] | 0, 70, 27)
        TW(c[46637] | 0, 71)
        return 0
      }

      function yT(b, d, e) {
        b = b | 0
        d = d | 0
        e = e | 0
        do {
          if (!(N$(d, 137521) | 0)) {
            c[46629] = CT(e) | 0
            a[186582] = 0
            c[46639] = 286
          } else {
            if (N$(d, 137527) | 0 ? N$(d, 137530) | 0 : 0) {
              if (!(N$(d, 137533) | 0)) {
                a[186582] = 1
                c[46629] = DT(e) | 0
                c[46639] = 287
                break
              }
              if (!(N$(d, 137541) | 0)) {
                c[46629] = ET(b, e, 0) | 0
                c[46639] = 288
                break
              }
              if (!(N$(d, 137546) | 0)) {
                c[46629] = ET(b, 0, 1) | 0
                c[46639] = 290
                break
              }
              if (!(N$(d, 137562) | 0)) {
                c[46629] = ET(b, 0, 32) | 0
                c[46639] = 295
                break
              }
              if (!(N$(d, 137548) | 0)) {
                c[46629] = ET(b, 0, 4) | 0
                c[46639] = 291
                break
              }
              if (!(N$(d, 137550) | 0)) {
                c[46629] = ET(b, 0, 64) | 0
                c[46639] = 292
                break
              }
              if (!(N$(d, 137552) | 0)) {
                c[46629] = ET(b, 0, 2) | 0
                c[46639] = 289
                break
              }
              if (!(N$(d, 137554) | 0)) {
                c[46629] = ET(b, 0, 8) | 0
                c[46639] = 293
                break
              }
              if (!(N$(d, 137558) | 0)) {
                c[46629] = ET(b, 0, 16) | 0
                c[46639] = 294
                break
              }
              if (!(N$(d, 137564) | 0)) {
                FT(e)
                c[46639] = 283
                break
              }
              if (!(N$(d, 137567) | 0)) {
                c[46639] = 277
                break
              }
              if (!(N$(d, 137570) | 0)) {
                c[46639] = 280
                break
              }
              if (!(N$(d, 137573) | 0)) {
                c[46629] = GT(e) | 0
                c[46639] = 285
                break
              }
              if (!(N$(d, 137536) | 0)) {
                c[46639] = 262
                break
              } else {
                BT(d)
                break
              }
            }
            a[186582] = 0
            c[46639] = 260
          }
        } while (0)
        return
      }

      function zT(b, d) {
        b = b | 0
        d = d | 0
        do {
          if (!(N$(d, 137521) | 0)) {
            c[46639] = 264
            a[186582] = 1
          } else {
            if (N$(d, 137527) | 0 ? N$(d, 137530) | 0 : 0) {
              if (!(N$(d, 137533) | 0)) {
                c[46639] = 265
                a[186582] = 0
                break
              }
              if (!(N$(d, 137536) | 0)) {
                c[46639] = 263
                break
              }
              if (!(N$(d, 137541) | 0)) {
                c[46639] = 266
                break
              }
              if (!(N$(d, 137546) | 0)) {
                c[46639] = 270
                break
              }
              if (!(N$(d, 137548) | 0)) {
                c[46639] = 271
                break
              }
              if (!(N$(d, 137550) | 0)) {
                c[46639] = 272
                break
              }
              if (!(N$(d, 137552) | 0)) {
                c[46639] = 269
                break
              }
              if (!(N$(d, 137554) | 0)) {
                c[46639] = 273
                break
              }
              if (!(N$(d, 137558) | 0)) {
                c[46639] = 274
                break
              }
              if (!(N$(d, 137562) | 0)) {
                c[46639] = 275
                break
              }
              if (!(N$(d, 137564) | 0)) {
                c[46639] = (c[46639] | 0) == 283 ? 282 : 258
                break
              }
              if (!(N$(d, 137567) | 0)) {
                c[46639] = (c[46639] | 0) == 277 ? 276 : 278
                break
              }
              if (!(N$(d, 137570) | 0)) {
                c[46639] = (c[46639] | 0) == 280 ? 279 : 281
                break
              }
              if (!(N$(d, 137573) | 0)) {
                c[46639] = (c[46639] | 0) == 285 ? 284 : 259
                break
              } else {
                BT(d)
                break
              }
            }
            c[46639] = 261
          }
        } while (0)
        return
      }

      function AT(b, d, e) {
        b = b | 0
        d = d | 0
        e = e | 0
        var f = 0, g = 0, h = 0
        if (a[186582] | 0) {
          b = 0
          while (1) {
            if (!e) {
              break
            }
            h = d + 1 | 0
            g = a[d >> 0] | 0
            if ((g & 255) > 31) {
              d = c[46640] | 0
              f = c[d + 4 >> 2] | 0
              if (f >>> 0 >= (c[d + 8 >> 2] | 0) >>> 0) {
                Tw(d, 1) | 0
                f = c[46640] | 0
                d = f
                f = c[f + 4 >> 2] | 0
              }
              c[d + 4 >> 2] = f + 1
              a[f >> 0] = g
              b = b + 1 | 0
            }
            d = h
            e = e + -1 | 0
          }
          if (b | 0) {
            c[46639] = 267
          }
        }
        return
      }

      function BT(b) {
        b = b | 0
        var d = 0, e = 0, f = 0
        d = l
        l = l + 16 | 0
        e = d
        c[46639] = 268
        a[186581] = 1
        f = vT() | 0
        c[e >> 2] = b
        c[e + 4 >> 2] = f
        Ow(1, 137577, e) | 0
        l = d
        return
      }

      function CT(b) {
        b = b | 0
        var d = 0
        d = tH(120) | 0
        c[d + 100 >> 2] = -1
        a[d + 88 >> 0] = -1
        HT(d, 56296, 22, b, 138529)
        return d | 0
      }

      function DT(a) {
        a = a | 0
        var c = 0
        c = tH(104) | 0
        b[c + 80 >> 1] = 1
        b[c + 82 >> 1] = 1
        HT(c, 56120, 22, a, 137883)
        return c | 0
      }

      function ET(a, b, d) {
        a = a | 0
        b = b | 0
        d = d | 0
        var e = 0, f = 0
        f = l
        l = l + 32 | 0
        e = f
        c[e >> 2] = 0
        c[e + 4 >> 2] = 0
        c[e + 8 >> 2] = 0
        c[e + 12 >> 2] = 0
        c[e + 16 >> 2] = 0
        c[e + 20 >> 2] = 0
        c[e + 24 >> 2] = 0
        c[e + 28 >> 2] = 0
        h[e + 16 >> 3] = -1.0
        c[e + 24 >> 2] = d & 127
        if (b | 0) {
          HT(e, 56096, 3, b, 137734)
        }
        d = c[a + 144 >> 2] | 0
        e = nb[c[d >> 2] & 63](d, e, 1) | 0
        l = f
        return e | 0
      }

      function FT(a) {
        a = a | 0
        c[46629] = 0
        HT(186516, 56088, 1, a, 137670)
        return
      }

      function GT(a) {
        a = a | 0
        var b = 0
        b = tH(40) | 0
        HT(b, 56072, 2, a, 137616)
        return b | 0
      }

      function HT(b, e, f, g, h) {
        b = b | 0
        e = e | 0
        f = f | 0
        g = g | 0
        h = h | 0
        var i = 0, j = 0, k = 0, m = 0, n = 0, o = 0
        o = l
        l = l + 16 | 0
        n = o
        m = o + 8 | 0
        while (1) {
          k = c[g >> 2] | 0
          if (!k) {
            break
          }
          i = c[g + 4 >> 2] | 0
          c[m >> 2] = k
          j = d2(m, e, f, 8, 102) | 0
          if (!j) {
            c[n >> 2] = k
            c[n + 4 >> 2] = h
            Ow(0, 137622, n) | 0
            i = 1
          } else {
            i = lb[c[j + 4 >> 2] & 127](b, i) | 0
            i = (i | (d[186580] | 0)) & 255
          }
          a[186580] = i
          g = g + 8 | 0
        }
        l = o
        return
      }

      function IT(a, b) {
        a = a | 0
        b = b | 0
        return N$(c[a >> 2] | 0, c[b >> 2] | 0) | 0
      }

      function JT(a, b) {
        a = a | 0
        b = b | 0
        c[a + 36 >> 2] = m1(b) | 0
        return 0
      }

      function KT(a, b) {
        a = a | 0
        b = b | 0
        c[a + 32 >> 2] = m1(b) | 0
        return 0
      }

      function LT(b, d) {
        b = b | 0
        d = d | 0
        var e = 0, f = 0, g = 0, h = 0, i = 0
        i = l
        l = l + 16 | 0
        g = i
        f = (H0(a[d >> 0] | 0) | 0) << 24 >> 24
        switch (f | 0) {
          case 82: {
            e = d + 1 | 0
            if (!(N$(e, 137681) | 0)) {
              c[b >> 2] = 114
              e = 0
            } else {
              h = 5
            }
            break
          }
          case 76: {
            h = 6
            break
          }
          default: {
            e = d + 1 | 0
            h = 5
          }
        }
        do {
          if ((h | 0) == 5) {
            if (!(N$(e, 137686) | 0)) {
              h = 6
            } else {
              if ((f | 0) != 67 ? (N$(e, 137690) | 0) == 0 : 0) {
                c[g >> 2] = d
                Ow(0, 137696, g) | 0
                e = 1
                break
              }
              c[b >> 2] = 110
              e = 0
            }
          }
        } while (0)
        if ((h | 0) == 6) {
          c[b >> 2] = 108
          e = 0
        }
        l = i
        return e | 0
      }

      function MT(a, b) {
        a = a | 0
        b = b | 0
        c[a + 4 >> 2] = b
        return 0
      }

      function NT(a, b) {
        a = a | 0
        b = b | 0
        c[a >> 2] = b
        return 0
      }

      function OT(a, b) {
        a = a | 0
        b = b | 0
        var d = 0, e = 0
        e = l
        l = l + 16 | 0
        d = e
        if (!(PT(b, 137763, 0, 255, d) | 0)) {
          h[a + 16 >> 3] = +(c[d >> 2] | 0)
          a = 0
        } else {
          a = 1
        }
        l = e
        return a | 0
      }

      function PT(a, b, d, e, f) {
        a = a | 0
        b = b | 0
        d = d | 0
        e = e | 0
        f = f | 0
        var g = 0, h = 0, i = 0, j = 0, k = 0, m = 0
        k = l
        l = l + 48 | 0
        j = k + 24 | 0
        i = k + 8 | 0
        h = k
        m = k + 36 | 0
        g = h1(a, m, 10) | 0
        do {
          if ((c[m >> 2] | 0) != (a | 0)) {
            if ((g | 0) > (e | 0)) {
              c[i >> 2] = b
              c[i + 4 >> 2] = a
              c[i + 8 >> 2] = e
              Ow(0, 137805, i) | 0
              a = 1
              break
            }
            if ((g | 0) < (d | 0)) {
              c[j >> 2] = b
              c[j + 4 >> 2] = a
              c[j + 8 >> 2] = d
              Ow(0, 137844, j) | 0
              a = 1
              break
            } else {
              c[f >> 2] = g
              a = 0
              break
            }
          } else {
            c[h >> 2] = b
            c[h + 4 >> 2] = a
            Ow(0, 137774, h) | 0
            a = 1
          }
        } while (0)
        l = k
        return a | 0
      }

      function QT(d, e) {
        d = d | 0
        e = e | 0
        var f = 0, g = 0, h = 0
        h = l
        l = l + 16 | 0
        f = h
        switch ((H0(a[e >> 0] | 0) | 0) << 24 >> 24 | 0) {
          case 76: {
            if (!(N$(e + 1 | 0, 137686) | 0)) {
              d = d + 36 | 0
              b[d >> 1] = b[d >> 1] | 4
              d = 0
            } else {
              g = 9
            }
            break
          }
          case 82: {
            if (!(N$(e + 1 | 0, 137681) | 0)) {
              d = d + 36 | 0
              b[d >> 1] = b[d >> 1] | 2
              d = 0
            } else {
              g = 9
            }
            break
          }
          case 84: {
            if (!(N$(e + 1 | 0, 138481) | 0)) {
              d = d + 36 | 0
              b[d >> 1] = b[d >> 1] | 6
              d = 0
            } else {
              g = 9
            }
            break
          }
          case 67: {
            if (!(N$(e + 1 | 0, 137690) | 0)) {
              d = 0
            } else {
              g = 9
            }
            break
          }
          default:
            g = 9
        }
        if ((g | 0) == 9) {
          c[f >> 2] = e
          Ow(0, 138485, f) | 0
          d = 1
        }
        l = h
        return d | 0
      }

      function RT(d, e) {
        d = d | 0
        e = e | 0
        var f = 0, g = 0, h = 0
        h = l
        l = l + 16 | 0
        f = h
        switch ((H0(a[e >> 0] | 0) | 0) << 24 >> 24 | 0) {
          case 76: {
            if (!(N$(e + 1 | 0, 137686) | 0)) {
              d = d + 36 | 0
              b[d >> 1] = b[d >> 1] | 512
              d = 0
            } else {
              g = 7
            }
            break
          }
          case 82: {
            if (!(N$(e + 1 | 0, 137681) | 0)) {
              d = d + 36 | 0
              b[d >> 1] = b[d >> 1] | 256
              d = 0
            } else {
              g = 7
            }
            break
          }
          case 67: {
            if (!(N$(e + 1 | 0, 137690) | 0)) {
              d = 0
            } else {
              g = 7
            }
            break
          }
          default:
            g = 7
        }
        if ((g | 0) == 7) {
          c[f >> 2] = e
          Ow(0, 138436, f) | 0
          d = 1
        }
        l = h
        return d | 0
      }

      function ST(a, b) {
        a = a | 0
        b = b | 0
        c[a + 20 >> 2] = m1(b) | 0
        return 0
      }

      function TT(d, e) {
        d = d | 0
        e = e | 0
        var f = 0, g = 0
        g = l
        l = l + 16 | 0
        f = g
        if (!(PT(e, 138429, 0, 255, f) | 0)) {
          a[d + 33 >> 0] = c[f >> 2]
          d = d + 36 | 0
          b[d >> 1] = b[d >> 1] | 32
          d = 0
        } else {
          d = 1
        }
        l = g
        return d | 0
      }

      function UT(d, e) {
        d = d | 0
        e = e | 0
        var f = 0, g = 0
        g = l
        l = l + 16 | 0
        f = g
        if (!(PT(e, 138417, 0, 255, f) | 0)) {
          a[d + 34 >> 0] = c[f >> 2]
          d = d + 36 | 0
          b[d >> 1] = b[d >> 1] | 64
          d = 0
        } else {
          d = 1
        }
        l = g
        return d | 0
      }

      function VT(d, e) {
        d = d | 0
        e = e | 0
        var f = 0, g = 0
        g = l
        l = l + 16 | 0
        f = g
        if (!(PT(e, 138405, -128, 127, f) | 0)) {
          a[d + 32 >> 0] = c[f >> 2]
          d = d + 36 | 0
          b[d >> 1] = b[d >> 1] | 128
          d = 0
        } else {
          d = 1
        }
        l = g
        return d | 0
      }

      function WT(a, b) {
        a = a | 0
        b = b | 0
        c[a + 24 >> 2] = m1(b) | 0
        return 0
      }

      function XT(a, d) {
        a = a | 0
        d = d | 0
        var e = 0, f = 0, g = 0
        g = l
        l = l + 16 | 0
        f = g
        e = g + 4 | 0
        do {
          if (!(PT(d, 138360, 0, 65535, e) | 0)) {
            d = c[e >> 2] | 0
            if (!d) {
              Ow(0, 138368, f) | 0
              d = 1
              break
            } else {
              b[a + 80 >> 1] = d
              d = 0
              break
            }
          } else {
            d = 1
          }
        } while (0)
        l = g
        return d | 0
      }

      function YT(a, e) {
        a = a | 0
        e = e | 0
        var f = 0, g = 0, h = 0
        h = l
        l = l + 16 | 0
        f = h
        switch ((H0(d[e >> 0] | 0) | 0) << 24 >> 24 | 0) {
          case 84: {
            if (!(N$(e + 1 | 0, 138309) | 0)) {
              a = a + 36 | 0
              b[a >> 1] = b[a >> 1] | 1
              a = 0
            } else {
              g = 5
            }
            break
          }
          case 70: {
            if (!(N$(e + 1 | 0, 138313) | 0)) {
              a = 0
            } else {
              g = 5
            }
            break
          }
          default:
            g = 5
        }
        if ((g | 0) == 5) {
          c[f >> 2] = e
          Ow(0, 138318, f) | 0
          a = 1
        }
        l = h
        return a | 0
      }

      function ZT(a, b) {
        a = a | 0
        b = b | 0
        var d = 0, e = 0
        e = l
        l = l + 16 | 0
        d = e
        if (!(PT(b, 138295, 0, 360, d) | 0)) {
          c[a + 28 >> 2] = c[d >> 2] & 65535
          a = 0
        } else {
          a = 1
        }
        l = e
        return a | 0
      }

      function _T(a, d) {
        a = a | 0
        d = d | 0
        var e = 0, f = 0
        f = l
        l = l + 16 | 0
        e = f
        if (!(PT(d, 138288, 0, 65535, e) | 0)) {
          b[a + 40 >> 1] = c[e >> 2]
          a = 0
        } else {
          a = 1
        }
        l = f
        return a | 0
      }

      function $T(a, b) {
        a = a | 0
        b = b | 0
        c[a >> 2] = m1(b) | 0
        return 0
      }

      function aU(a, b) {
        a = a | 0
        b = b | 0
        c[a + 16 >> 2] = m1(b) | 0
        return 0
      }

      function bU(a, b) {
        a = a | 0
        b = b | 0
        c[a + 4 >> 2] = m1(b) | 0
        return 0
      }

      function cU(a, d) {
        a = a | 0
        d = d | 0
        var e = 0, f = 0, g = 0
        g = l
        l = l + 16 | 0
        f = g
        e = g + 4 | 0
        do {
          if (!(PT(d, 138243, 0, 65535, e) | 0)) {
            d = c[e >> 2] | 0
            if (!d) {
              Ow(0, 138251, f) | 0
              d = 1
              break
            } else {
              b[a + 82 >> 1] = d
              d = 0
              break
            }
          } else {
            d = 1
          }
        } while (0)
        l = g
        return d | 0
      }

      function dU(d, e) {
        d = d | 0
        e = e | 0
        var f = 0, g = 0, h = 0, i = 0, j = 0, k = 0
        k = l
        l = l + 16 | 0
        i = k
        h = 0
        a:while (1) {
          b:while (1) {
            g = e + 1 | 0
            e = a[e >> 0] | 0
            if (!(e << 24 >> 24)) {
              break a
            }
            e = e << 24 >> 24
            f = (O$(e) | 0) + -98 | 0
            switch (f >>> 1 | f << 31 | 0) {
              case 5: {
                j = 5
                break b
              }
              case 9: {
                f = 2048
                break b
              }
              case 8: {
                j = 6
                break b
              }
              case 0: {
                j = 7
                break b
              }
              default: {
              }
            }
            c[i >> 2] = e
            c[i + 4 >> 2] = e
            Ow(0, 138190, i) | 0
            e = g
          }
          if ((j | 0) == 5) {
            j = 0
            f = 1024
          } else if ((j | 0) == 6) {
            j = 0
            f = 4096
          } else if ((j | 0) == 7) {
            j = 0
            f = 8192
          }
          e = g
          h = h | f
        }
        if (h << 16 >> 16 != 15360) {
          j = d + 36 | 0
          b[j >> 1] = b[j >> 1] | h
        }
        l = k
        return 0
      }

      function eU(d, e) {
        d = d | 0
        e = e | 0
        var f = 0, g = 0, h = 0, i = 0, j = 0, k = 0
        k = l
        l = l + 16 | 0
        j = k + 8 | 0
        i = k
        h = m1(e) | 0
        g = d + 42 | 0
        f = 0
        e = h
        while (1) {
          d = j1(e, 138100) | 0
          if (!d) {
            break
          }
          if (((H0(a[d >> 0] | 0) | 0) & 255 | 0) == 82) {
            e = d + 1 | 0
            if (!(N$(e, 138103) | 0)) {
              b[g >> 1] = b[g >> 1] | 4
              d = f
              e = 0
              f = d
              continue
            }
            if (!(N$(e, 138110) | 0)) {
              b[g >> 1] = b[g >> 1] | 2
              d = f
              e = 0
              f = d
              continue
            } else {
              c[i >> 2] = d
              Ow(0, 138116, i) | 0
              f = 1
              e = 0
              continue
            }
          }
          if (!(N$(d, 138154) | 0)) {
            b[g >> 1] = b[g >> 1] & -385
            d = f
            e = 0
            f = d
            continue
          }
          if (N$(d, 138160) | 0 ? N$(d, 138170) | 0 : 0) {
            if (!(N$(d, 138176) | 0)) {
              b[g >> 1] = b[g >> 1] | 128
              d = f
              e = 0
              f = d
              continue
            }
            if (!(N$(d, 138183) | 0)) {
              b[g >> 1] = b[g >> 1] | 256
              d = f
              e = 0
              f = d
              continue
            } else {
              c[j >> 2] = d
              Ow(0, 138116, j) | 0
              f = 1
              e = 0
              continue
            }
          }
          b[g >> 1] = b[g >> 1] | 32
          d = f
          e = 0
          f = d
        }
        C_(h)
        l = k
        return f | 0
      }

      function fU(a, b) {
        a = a | 0
        b = b | 0
        c[a + 8 >> 2] = m1(b) | 0
        return 0
      }

      function gU(a, b) {
        a = a | 0
        b = b | 0
        c[a + 12 >> 2] = m1(b) | 0
        return 0
      }

      function hU(d, e) {
        d = d | 0
        e = e | 0
        var f = 0, g = 0, h = 0
        h = l
        l = l + 16 | 0
        f = h
        switch ((H0(a[e >> 0] | 0) | 0) << 24 >> 24 | 0) {
          case 66: {
            if (!(N$(e + 1 | 0, 138046) | 0)) {
              d = d + 36 | 0
              b[d >> 1] = b[d >> 1] | 16
              d = 0
            } else {
              g = 7
            }
            break
          }
          case 84: {
            if (!(N$(e + 1 | 0, 138052) | 0)) {
              d = d + 36 | 0
              b[d >> 1] = b[d >> 1] | 8
              d = 0
            } else {
              g = 7
            }
            break
          }
          case 77: {
            if (!(N$(e + 1 | 0, 138055) | 0)) {
              d = 0
            } else {
              g = 7
            }
            break
          }
          default:
            g = 7
        }
        if ((g | 0) == 7) {
          c[f >> 2] = e
          Ow(0, 138061, f) | 0
          d = 1
        }
        l = h
        return d | 0
      }

      function iU(a, d) {
        a = a | 0
        d = d | 0
        var e = 0, f = 0
        f = l
        l = l + 16 | 0
        e = f
        if (!(PT(d, 138040, 0, 65535, e) | 0)) {
          b[a + 38 >> 1] = c[e >> 2]
          a = 0
        } else {
          a = 1
        }
        l = f
        return a | 0
      }

      function jU(d, e) {
        d = d | 0
        e = e | 0
        var f = 0, g = 0, h = 0
        h = l
        l = l + 16 | 0
        f = h
        switch ((H0(a[e >> 0] | 0) | 0) << 24 >> 24 | 0) {
          case 76: {
            if (!(N$(e + 1 | 0, 137686) | 0)) {
              d = d + 36 | 0
              b[d >> 1] = b[d >> 1] | 4
              d = 0
            } else {
              g = 7
            }
            break
          }
          case 82: {
            if (!(N$(e + 1 | 0, 137681) | 0)) {
              d = d + 36 | 0
              b[d >> 1] = b[d >> 1] | 2
              d = 0
            } else {
              g = 7
            }
            break
          }
          case 67: {
            if (!(N$(e + 1 | 0, 137690) | 0)) {
              d = 0
            } else {
              g = 7
            }
            break
          }
          default:
            g = 7
        }
        if ((g | 0) == 7) {
          c[f >> 2] = e
          Ow(0, 137696, f) | 0
          d = 1
        }
        l = h
        return d | 0
      }

      function kU(b, d) {
        b = b | 0
        d = d | 0
        var e = 0, f = 0
        f = l
        l = l + 16 | 0
        e = f
        if (!(PT(d, 138638, 0, 127, e) | 0)) {
          a[b + 88 >> 0] = c[e >> 2]
          b = 0
        } else {
          b = 1
        }
        l = f
        return b | 0
      }

      function lU(b, d) {
        b = b | 0
        d = d | 0
        var e = 0, f = 0
        f = l
        l = l + 16 | 0
        e = f
        if ((a[d >> 0] | 0) == 42) {
          b = b + 112 | 0
          a[b >> 0] = a[b >> 0] | 1
          b = 0
        } else {
          c[e >> 2] = d
          Ow(0, 138598, e) | 0
          b = 1
        }
        l = f
        return b | 0
      }

      function mU(b, d) {
        b = b | 0
        d = d | 0
        var e = 0, f = 0
        f = l
        l = l + 16 | 0
        e = f
        if ((a[d >> 0] | 0) == 42) {
          b = b + 112 | 0
          a[b >> 0] = a[b >> 0] | 2
          b = 0
        } else {
          c[e >> 2] = d
          Ow(0, 138561, e) | 0
          b = 1
        }
        l = f
        return b | 0
      }

      function nU() {
        var b = 0
        b = (a[186581] | a[186580]) << 24 >> 24
        IV(c[46637] | 0)
        Ww(186564)
        return b | 0
      }

      function oU() {
        var b = 0, d = 0, e = 0, f = 0, g = 0, h = 0, i = 0, j = 0
        j = l
        l = l + 16 | 0
        i = j
        c[46639] = 0
        d = 0
        a:do {
          b:do {
            switch (a[186583] | 0) {
              case 2: {
                b = -1
                break a
              }
              case 0: {
                a[186583] = 1
                h = 6
                b = 138650
                d = 0
                break
              }
              default: {
                b = c[46638] | 0
                if (!(a[b >> 0] | 0)) {
                  a[186583] = 2
                  h = 7
                  b = 138657
                  break b
                } else {
                  d = pU(b) | 0
                  h = d - b | 0
                  break b
                }
              }
            }
          } while (0)
          c[46647] = c[46646]
          c[46649] = c[46648]
          c[46646] = b
          c[46648] = h
          e = c[46642] | 0
          f = e - (c[46641] | 0) | 0
          g = c[46637] | 0
          if (!f) {
            b = UW(g, b, h, (h | 0) == 0 & 1) | 0
          } else {
            if (e >>> 0 < (c[46643] | 0) >>> 0) {
              b = e
            } else {
              Tw(186564, 1) | 0
              b = c[46642] | 0
            }
            a[b >> 0] = 0
            b = c[46641] | 0
            c[46642] = b
            b = UW(g, b, f, 0) | 0
          }
          if (!((b | 0) != 0 | (a[186581] | 0) != 0)) {
            g = dX(bX(c[46637] | 0) | 0) | 0
            h = vT() | 0
            c[i >> 2] = g
            c[i + 4 >> 2] = h
            Ow(1, 137493, i) | 0
            wT()
            a[186581] = 1
            c[46639] = 268
          }
          if (d | 0) {
            c[46638] = d
          }
          b = c[46639] | 0
        } while ((b | 0) == 0)
        l = j
        return b | 0
      }

      function pU(b) {
        b = b | 0
        var d = 0, e = 0, f = 0, g = 0, h = 0
        h = l
        l = l + 16 | 0
        f = h
        d = b + 1 | 0
        e = a[b >> 0] | 0
        a:do {
          if (e << 24 >> 24 == 60) {
            e = a[d >> 0] | 0
            if (e << 24 >> 24 == 33) {
              if (!(y$(b + 2 | 0, 138665, 2) | 0)) {
                e = qU(b + 4 | 0) | 0
                d = e
                e = a[e >> 0] | 0
                g = 8
              } else {
                e = d
                g = 5
              }
            } else {
              g = 6
            }
            b:while (1) {
              if ((g | 0) == 5) {
                d = e
                e = a[e >> 0] | 0
                g = 6
                continue
              } else if ((g | 0) == 6) {
                switch (e << 24 >> 24) {
                  case 62:
                  case 0: {
                    g = 8
                    continue b
                  }
                  default: {
                  }
                }
                e = d + 1 | 0
                g = 5
                continue
              } else if ((g | 0) == 8) {
                if (e << 24 >> 24 == 62) {
                  g = 10
                  break
                } else {
                  g = 9
                  break
                }
              }
            }
            if ((g | 0) == 9) {
              Ow(0, 138668, f) | 0
              a[186580] = 1
              break
            } else if ((g | 0) == 10) {
              d = d + 1 | 0
              break
            }
          } else {
            d = b
            b = e
            while (1) {
              switch (b << 24 >> 24) {
                case 60:
                case 0:
                  break a
                case 38: {
                  e = d + 1 | 0
                  if ((a[e >> 0] | 0) == 35) {
                    g = 15
                  } else {
                    e = LM(e, 186564) | 0
                  }
                  break
                }
                default:
                  g = 15
              }
              if ((g | 0) == 15) {
                g = 0
                e = c[46642] | 0
                if (e >>> 0 >= (c[46643] | 0) >>> 0) {
                  Tw(186564, 1) | 0
                  e = c[46642] | 0
                }
                c[46642] = e + 1
                a[e >> 0] = b
                e = d + 1 | 0
              }
              d = e
              b = a[e >> 0] | 0
            }
          }
        } while (0)
        l = h
        return d | 0
      }

      function qU(b) {
        b = b | 0
        var c = 0, d = 0, e = 0, f = 0, g = 0, h = 0, i = 0, j = 0
        j = l
        l = l + 16 | 0
        i = j
        f = 1
        c = b
        a:while (1) {
          e = (f | 0) == 0
          d = c
          b:while (1) {
            if (e) {
              break a
            }
            g = d + 1 | 0
            switch (a[d >> 0] | 0) {
              case 0: {
                c = g
                break a
              }
              case 60: {
                h = 5
                break b
              }
              case 62: {
                c = -1
                break b
              }
              default:
                d = g
            }
          }
          if ((h | 0) == 5) {
            h = 0
            c = 1
          }
          f = f + c | 0
          c = g
        }
        d = c + -1 | 0
        do {
          if (a[d >> 0] | 0) {
            c = c + -3 | 0
            if (c >>> 0 >= b >>> 0 ? (y$(c, 138665, 2) | 0) == 0 : 0) {
              break
            }
            Ow(0, 138709, i) | 0
            a[186580] = 1
          }
        } while (0)
        l = j
        return d | 0
      }

      function rU(a, b) {
        a = a | 0
        b = b | 0
        var d = 0, e = 0, f = 0, g = 0, h = 0, i = 0, j = 0, k = 0, l = 0, m = 0, n = 0, o = 0, p = 0, q = 0, r = 0,
            s = 0
        d = B_(28) | 0
        if (!d) {
          d = 0
        } else {
          e = 0
          f = 0
          while (1) {
            if ((e | 0) >= (b | 0)) {
              break
            }
            r = (c[(c[a + (e << 2) >> 2] | 0) + 4 >> 2] | 0) + f | 0
            e = e + 1 | 0
            f = r
          }
          o = d + 8 | 0
          c[o >> 2] = sU(f << 4) | 0
          p = d + 12 | 0
          c[p >> 2] = sU((b << 2) + 4 | 0) | 0
          e = f << 2
          q = d + 16 | 0
          c[q >> 2] = sU(e) | 0
          e = sU(e) | 0
          r = d + 20 | 0
          c[r >> 2] = e
          c[d + 4 >> 2] = f
          c[d >> 2] = b
          f = 0
          h = 0
          while (1) {
            c[(c[p >> 2] | 0) + (h << 2) >> 2] = f
            if ((h | 0) >= (b | 0)) {
              break
            }
            j = a + (h << 2) | 0
            n = c[j >> 2] | 0
            k = c[n + 4 >> 2] | 0
            l = f + -1 | 0
            g = 0
            i = f
            m = k
            while (1) {
              if ((g | 0) >= (m | 0)) {
                break
              }
              m = (c[o >> 2] | 0) + (i << 4) | 0
              e = (c[n >> 2] | 0) + (g << 4) | 0
              c[m >> 2] = c[e >> 2]
              c[m + 4 >> 2] = c[e + 4 >> 2]
              c[m + 8 >> 2] = c[e + 8 >> 2]
              c[m + 12 >> 2] = c[e + 12 >> 2]
              m = i + 1 | 0
              c[(c[q >> 2] | 0) + (i << 2) >> 2] = m
              e = c[r >> 2] | 0
              c[e + (i << 2) >> 2] = i + -1
              s = c[j >> 2] | 0
              g = g + 1 | 0
              i = m
              m = c[s + 4 >> 2] | 0
              n = s
            }
            s = l + k | 0
            c[(c[q >> 2] | 0) + (s << 2) >> 2] = f
            c[e + (f << 2) >> 2] = s
            f = i
            h = h + 1 | 0
          }
          sV(d)
        }
        return d | 0
      }

      function sU(a) {
        a = a | 0
        if (!a) {
          a = 0
        } else {
          a = B_(a) | 0
        }
        return a | 0
      }

      function tU(a) {
        a = a | 0
        var b = 0, d = 0
        C_(c[a + 8 >> 2] | 0)
        C_(c[a + 12 >> 2] | 0)
        C_(c[a + 16 >> 2] | 0)
        C_(c[a + 20 >> 2] | 0)
        d = a + 24 | 0
        b = c[d >> 2] | 0
        if (b | 0) {
          C_(c[b >> 2] | 0)
          C_(c[d >> 2] | 0)
        }
        C_(a)
        return
      }

      function uU(a, b, d, e, f, g) {
        a = a | 0
        b = b | 0
        d = d | 0
        e = e | 0
        f = f | 0
        g = g | 0
        var h = 0, i = 0, j = 0, k = 0, m = 0, n = 0, o = 0, p = 0
        p = l
        l = l + 32 | 0
        m = p + 16 | 0
        j = p
        c[m >> 2] = c[b >> 2]
        c[m + 4 >> 2] = c[b + 4 >> 2]
        c[m + 8 >> 2] = c[b + 8 >> 2]
        c[m + 12 >> 2] = c[b + 12 >> 2]
        n = zV(a, d, m) | 0
        c[m >> 2] = c[e >> 2]
        c[m + 4 >> 2] = c[e + 4 >> 2]
        c[m + 8 >> 2] = c[e + 8 >> 2]
        c[m + 12 >> 2] = c[e + 12 >> 2]
        o = zV(a, f, m) | 0
        c[j >> 2] = c[b >> 2]
        c[j + 4 >> 2] = c[b + 4 >> 2]
        c[j + 8 >> 2] = c[b + 8 >> 2]
        c[j + 12 >> 2] = c[b + 12 >> 2]
        c[m >> 2] = c[e >> 2]
        c[m + 4 >> 2] = c[e + 4 >> 2]
        c[m + 8 >> 2] = c[e + 8 >> 2]
        c[m + 12 >> 2] = c[e + 12 >> 2]
        m = iV(j, d, n, m, f, o, a) | 0
        d = c[a + 4 >> 2] | 0
        j = d + 1 | 0
        f = 1
        h = d
        while (1) {
          h = c[m + (h << 2) >> 2] | 0
          k = f + 1 | 0
          if ((h | 0) == (j | 0)) {
            break
          } else {
            f = k
          }
        }
        i = B_(k << 4) | 0
        h = i + (f << 4) | 0
        c[h >> 2] = c[e >> 2]
        c[h + 4 >> 2] = c[e + 4 >> 2]
        c[h + 8 >> 2] = c[e + 8 >> 2]
        c[h + 12 >> 2] = c[e + 12 >> 2]
        a = a + 8 | 0
        while (1) {
          d = c[m + (d << 2) >> 2] | 0
          f = f + -1 | 0
          h = i + (f << 4) | 0
          if ((d | 0) == (j | 0)) {
            break
          }
          e = (c[a >> 2] | 0) + (d << 4) | 0
          c[h >> 2] = c[e >> 2]
          c[h + 4 >> 2] = c[e + 4 >> 2]
          c[h + 8 >> 2] = c[e + 8 >> 2]
          c[h + 12 >> 2] = c[e + 12 >> 2]
        }
        c[h >> 2] = c[b >> 2]
        c[h + 4 >> 2] = c[b + 4 >> 2]
        c[h + 8 >> 2] = c[b + 8 >> 2]
        c[h + 12 >> 2] = c[b + 12 >> 2]
        if (f | 0) {
          qa(138727, 138734, 148, 138740)
        }
        if (n | 0) {
          C_(n)
        }
        if (o | 0) {
          C_(o)
        }
        c[g + 4 >> 2] = k
        c[g >> 2] = i
        C_(m)
        l = p
        return 1
      }

      function vU(a, b) {
        a = a | 0
        b = b | 0
        var d = 0, e = 0, f = 0, g = 0, h = 0, i = 0, j = 0, k = 0, m = 0
        j = l
        l = l + 48 | 0
        h = j + 32 | 0
        g = j + 16 | 0
        f = j
        i = c[a >> 2] | 0
        d = c[a + 4 >> 2] | 0
        e = d + -1 | 0
        a = 0
        while (1) {
          if ((a | 0) >= (d | 0)) {
            a = 1
            break
          }
          m = i + (((e + a | 0) % (d | 0) | 0) << 4) | 0
          k = i + (a << 4) | 0
          c[f >> 2] = c[m >> 2]
          c[f + 4 >> 2] = c[m + 4 >> 2]
          c[f + 8 >> 2] = c[m + 8 >> 2]
          c[f + 12 >> 2] = c[m + 12 >> 2]
          c[g >> 2] = c[k >> 2]
          c[g + 4 >> 2] = c[k + 4 >> 2]
          c[g + 8 >> 2] = c[k + 8 >> 2]
          c[g + 12 >> 2] = c[k + 12 >> 2]
          c[h >> 2] = c[b >> 2]
          c[h + 4 >> 2] = c[b + 4 >> 2]
          c[h + 8 >> 2] = c[b + 8 >> 2]
          c[h + 12 >> 2] = c[b + 12 >> 2]
          if ((oV(f, g, h) | 0) == 1) {
            a = 0
            break
          } else {
            a = a + 1 | 0
          }
        }
        l = j
        return a | 0
      }

      function wU(a, b, d, e, f) {
        a = a | 0
        b = b | 0
        d = d | 0
        e = e | 0
        f = f | 0
        var g = 0, h = 0, i = 0, j = 0, k = 0, m = 0, n = 0, q = 0, r = 0, s = 0, t = 0, u = 0
        u = l
        l = l + 64 | 0
        m = u + 48 | 0
        k = u + 32 | 0
        s = 4
        j = B_(40) | 0
        c[j >> 2] = 0
        n = u + 16 | 0
        q = u
        r = c[d >> 2] | 0
        i = c[d + 4 >> 2] | 0
        s = C3(186600, 1, j | 0, s | 0) | 0
        j = z
        o = 0
        d = o
        o = 0
        if ((d | 0) != 0 & (p | 0) != 0) {
          g = D3(c[d >> 2] | 0, s | 0, j | 0) | 0
          if (!g) {
            bb(d | 0, p | 0)
          }
          z = p
        } else {
          g = -1
        }
        if ((g | 0) == 1) {
          d = z
        } else {
          d = 0
        }
        while (1) {
          if (d | 0) {
            d = -1
            break
          }
          o = 0
          c[m >> 2] = c[e >> 2]
          c[m + 4 >> 2] = c[e + 4 >> 2]
          c[m + 8 >> 2] = c[e + 8 >> 2]
          c[m + 12 >> 2] = c[e + 12 >> 2]
          ja(28, n | 0, m | 0)
          d = o
          o = 0
          if ((d | 0) != 0 & (p | 0) != 0) {
            g = D3(c[d >> 2] | 0, s | 0, j | 0) | 0
            if (!g) {
              bb(d | 0, p | 0)
            }
            z = p
          } else {
            g = -1
          }
          if ((g | 0) == 1) {
            d = z
            continue
          }
          c[e >> 2] = c[n >> 2]
          c[e + 4 >> 2] = c[n + 4 >> 2]
          c[e + 8 >> 2] = c[n + 8 >> 2]
          c[e + 12 >> 2] = c[n + 12 >> 2]
          h = e + 16 | 0
          o = 0
          c[m >> 2] = c[h >> 2]
          c[m + 4 >> 2] = c[h + 4 >> 2]
          c[m + 8 >> 2] = c[h + 8 >> 2]
          c[m + 12 >> 2] = c[h + 12 >> 2]
          ja(28, q | 0, m | 0)
          d = o
          o = 0
          if ((d | 0) != 0 & (p | 0) != 0) {
            g = D3(c[d >> 2] | 0, s | 0, j | 0) | 0
            if (!g) {
              bb(d | 0, p | 0)
            }
            z = p
          } else {
            g = -1
          }
          if ((g | 0) == 1) {
            d = z
            continue
          }
          c[h >> 2] = c[q >> 2]
          c[h + 4 >> 2] = c[q + 4 >> 2]
          c[h + 8 >> 2] = c[q + 8 >> 2]
          c[h + 12 >> 2] = c[q + 12 >> 2]
          c[46689] = 0
          o = 0
          ia(112, 4)
          d = o
          o = 0
          if ((d | 0) != 0 & (p | 0) != 0) {
            g = D3(c[d >> 2] | 0, s | 0, j | 0) | 0
            if (!g) {
              bb(d | 0, p | 0)
            }
            z = p
          } else {
            g = -1
          }
          if ((g | 0) == 1) {
            d = z
            continue
          }
          g = c[46690] | 0
          d = c[46689] | 0
          c[46689] = d + 1
          d = g + (d << 4) | 0
          c[d >> 2] = c[r >> 2]
          c[d + 4 >> 2] = c[r + 4 >> 2]
          c[d + 8 >> 2] = c[r + 8 >> 2]
          c[d + 12 >> 2] = c[r + 12 >> 2]
          o = 0
          c[k >> 2] = c[e >> 2]
          c[k + 4 >> 2] = c[e + 4 >> 2]
          c[k + 8 >> 2] = c[e + 8 >> 2]
          c[k + 12 >> 2] = c[e + 12 >> 2]
          c[m >> 2] = c[h >> 2]
          c[m + 4 >> 2] = c[h + 4 >> 2]
          c[m + 8 >> 2] = c[h + 8 >> 2]
          c[m + 12 >> 2] = c[h + 12 >> 2]
          d = fa(1, a | 0, b | 0, r | 0, i | 0, k | 0, m | 0) | 0
          g = o
          o = 0
          if ((g | 0) != 0 & (p | 0) != 0) {
            h = D3(c[g >> 2] | 0, s | 0, j | 0) | 0
            if (!h) {
              bb(g | 0, p | 0)
            }
            z = p
          } else {
            h = -1
          }
          if ((h | 0) == 1) {
            d = z
          } else {
            t = 8
            break
          }
        }
        if ((t | 0) == 8) {
          if ((d | 0) == -1) {
            d = -1
          } else {
            c[f + 4 >> 2] = c[46689]
            c[f >> 2] = c[46690]
            d = 0
          }
        }
        C_(s | 0)
        l = u
        return d | 0
      }

      function xU(a, b) {
        a = a | 0
        b = b | 0
        var d = 0.0, e = 0, f = 0.0, g = 0.0, i = 0.0
        d = +h[b >> 3]
        e = b + 8 | 0
        f = +h[e >> 3]
        i = f * f + d * d
        g = +C(+i)
        if (i > 1.0e-06) {
          h[b >> 3] = d / g
          h[e >> 3] = f / g
        }
        c[a >> 2] = c[b >> 2]
        c[a + 4 >> 2] = c[b + 4 >> 2]
        c[a + 8 >> 2] = c[b + 8 >> 2]
        c[a + 12 >> 2] = c[b + 12 >> 2]
        return
      }

      function yU(a) {
        a = a | 0
        var b = 0, d = 0, e = 0, f = 0
        f = l
        l = l + 32 | 0
        e = f + 16 | 0
        d = f
        if ((c[46693] | 0) < (a | 0)) {
          b = c[46690] | 0
          if (!b) {
            e = B_(a << 4) | 0
            c[46690] = e
            if (!e) {
              e = c[15686] | 0
              c[d >> 2] = 138749
              c[d + 4 >> 2] = 531
              c[d + 8 >> 2] = 138884
              f1(e, 138757, d) | 0
              bb(186600, 1)
            }
          } else {
            d = E_(b, a << 4) | 0
            c[46690] = d
            if (!d) {
              d = c[15686] | 0
              c[e >> 2] = 138749
              c[e + 4 >> 2] = 537
              c[e + 8 >> 2] = 138902
              f1(d, 138757, e) | 0
              bb(186600, 1)
            }
          }
          c[46693] = a
        }
        l = f
        return
      }

      function zU(a, b, d, e, f, g) {
        a = a | 0
        b = b | 0
        d = d | 0
        e = e | 0
        f = f | 0
        g = g | 0
        var i = 0, j = 0.0, k = 0, m = 0.0, n = 0, o = 0.0, p = 0.0, q = 0, r = 0.0, s = 0.0, t = 0.0, u = 0.0, v = 0.0,
            w = 0, x = 0, y = 0, z = 0, A = 0, B = 0, C = 0, D = 0, E = 0, F = 0, G = 0, H = 0, I = 0, J = 0, K = 0,
            L = 0, M = 0, N = 0, O = 0, P = 0, Q = 0, R = 0, S = 0, T = 0.0, U = 0.0, V = 0.0, W = 0.0
        R = l
        l = l + 336 | 0
        J = R + 320 | 0
        I = R + 304 | 0
        w = R + 144 | 0
        q = R + 128 | 0
        G = R + 112 | 0
        H = R + 96 | 0
        Q = R + 80 | 0
        A = R + 64 | 0
        C = R + 48 | 0
        K = R + 32 | 0
        L = R + 16 | 0
        M = R
        x = R + 288 | 0
        y = R + 272 | 0
        z = R + 256 | 0
        B = R + 240 | 0
        D = R + 224 | 0
        E = R + 208 | 0
        N = R + 192 | 0
        O = R + 176 | 0
        P = R + 160 | 0
        i = c[46692] | 0
        do {
          if ((c[46691] | 0) < (e | 0)) {
            if (!i) {
              i = B_(e * 40 | 0) | 0
              c[46692] = i
              if (!i) {
                i = -1
                break
              }
            } else {
              i = E_(i, e * 40 | 0) | 0
              c[46692] = i
              if (!i) {
                i = -1
                break
              }
            }
            c[46691] = e
            k = 6
          } else {
            k = 6
          }
        } while (0)
        if ((k | 0) == 6) {
          h[i >> 3] = 0.0
          k = 1
          j = 0.0
          while (1) {
            if ((k | 0) >= (e | 0)) {
              break
            }
            n = d + (k << 4) | 0
            F = d + (k + -1 << 4) | 0
            c[I >> 2] = c[n >> 2]
            c[I + 4 >> 2] = c[n + 4 >> 2]
            c[I + 8 >> 2] = c[n + 8 >> 2]
            c[I + 12 >> 2] = c[n + 12 >> 2]
            c[J >> 2] = c[F >> 2]
            c[J + 4 >> 2] = c[F + 4 >> 2]
            c[J + 8 >> 2] = c[F + 8 >> 2]
            c[J + 12 >> 2] = c[F + 12 >> 2]
            v = +AU(I, J) + j
            h[i + (k * 40 | 0) >> 3] = v
            k = k + 1 | 0
            j = v
          }
          F = e + -1 | 0
          n = i + (F * 40 | 0) | 0
          k = 1
          while (1) {
            if ((k | 0) >= (e | 0)) {
              break
            }
            S = i + (k * 40 | 0) | 0
            h[S >> 3] = +h[S >> 3] / +h[n >> 3]
            k = k + 1 | 0
          }
          k = 0
          while (1) {
            if ((k | 0) >= (e | 0)) {
              break
            }
            S = i + (k * 40 | 0) + 8 | 0
            n = i + (k * 40 | 0) | 0
            v = +BU(+h[n >> 3])
            c[J >> 2] = c[f >> 2]
            c[J + 4 >> 2] = c[f + 4 >> 2]
            c[J + 8 >> 2] = c[f + 8 >> 2]
            c[J + 12 >> 2] = c[f + 12 >> 2]
            CU(x, J, v)
            c[S >> 2] = c[x >> 2]
            c[S + 4 >> 2] = c[x + 4 >> 2]
            c[S + 8 >> 2] = c[x + 8 >> 2]
            c[S + 12 >> 2] = c[x + 12 >> 2]
            S = i + (k * 40 | 0) + 24 | 0
            v = +DU(+h[n >> 3])
            c[J >> 2] = c[g >> 2]
            c[J + 4 >> 2] = c[g + 4 >> 2]
            c[J + 8 >> 2] = c[g + 8 >> 2]
            c[J + 12 >> 2] = c[g + 12 >> 2]
            CU(y, J, v)
            c[S >> 2] = c[y >> 2]
            c[S + 4 >> 2] = c[y + 4 >> 2]
            c[S + 8 >> 2] = c[y + 8 >> 2]
            c[S + 12 >> 2] = c[y + 12 >> 2]
            k = k + 1 | 0
          }
          c[I >> 2] = c[f >> 2]
          c[I + 4 >> 2] = c[f + 4 >> 2]
          c[I + 8 >> 2] = c[f + 8 >> 2]
          c[I + 12 >> 2] = c[f + 12 >> 2]
          c[J >> 2] = c[g >> 2]
          c[J + 4 >> 2] = c[g + 4 >> 2]
          c[J + 8 >> 2] = c[g + 8 >> 2]
          c[J + 12 >> 2] = c[g + 12 >> 2]
          EU(d, e, i, I, J, G, A, H, C)
          c[q >> 2] = c[G >> 2]
          c[q + 4 >> 2] = c[G + 4 >> 2]
          c[q + 8 >> 2] = c[G + 8 >> 2]
          c[q + 12 >> 2] = c[G + 12 >> 2]
          c[w >> 2] = c[A >> 2]
          c[w + 4 >> 2] = c[A + 4 >> 2]
          c[w + 8 >> 2] = c[A + 8 >> 2]
          c[w + 12 >> 2] = c[A + 12 >> 2]
          c[I >> 2] = c[H >> 2]
          c[I + 4 >> 2] = c[H + 4 >> 2]
          c[I + 8 >> 2] = c[H + 8 >> 2]
          c[I + 12 >> 2] = c[H + 12 >> 2]
          c[J >> 2] = c[C >> 2]
          c[J + 4 >> 2] = c[C + 4 >> 2]
          c[J + 8 >> 2] = c[C + 8 >> 2]
          c[J + 12 >> 2] = c[C + 12 >> 2]
          if (!(FU(a, b, q, w, I, J, d, e) | 0)) {
            c[J >> 2] = c[A >> 2]
            c[J + 4 >> 2] = c[A + 4 >> 2]
            c[J + 8 >> 2] = c[A + 8 >> 2]
            c[J + 12 >> 2] = c[A + 12 >> 2]
            CU(z, J, .3333333333333333)
            c[I >> 2] = c[G >> 2]
            c[I + 4 >> 2] = c[G + 4 >> 2]
            c[I + 8 >> 2] = c[G + 8 >> 2]
            c[I + 12 >> 2] = c[G + 12 >> 2]
            c[J >> 2] = c[z >> 2]
            c[J + 4 >> 2] = c[z + 4 >> 2]
            c[J + 8 >> 2] = c[z + 8 >> 2]
            c[J + 12 >> 2] = c[z + 12 >> 2]
            GU(B, I, J)
            v = +h[B >> 3]
            u = +h[B + 8 >> 3]
            c[J >> 2] = c[C >> 2]
            c[J + 4 >> 2] = c[C + 4 >> 2]
            c[J + 8 >> 2] = c[C + 8 >> 2]
            c[J + 12 >> 2] = c[C + 12 >> 2]
            CU(D, J, .3333333333333333)
            c[I >> 2] = c[H >> 2]
            c[I + 4 >> 2] = c[H + 4 >> 2]
            c[I + 8 >> 2] = c[H + 8 >> 2]
            c[I + 12 >> 2] = c[H + 12 >> 2]
            c[J >> 2] = c[D >> 2]
            c[J + 4 >> 2] = c[D + 4 >> 2]
            c[J + 8 >> 2] = c[D + 8 >> 2]
            c[J + 12 >> 2] = c[D + 12 >> 2]
            HU(E, I, J)
            t = +h[E >> 3]
            p = +h[E + 8 >> 3]
            q = c[46692] | 0
            r = +h[G >> 3]
            s = +h[H >> 3]
            o = +h[G + 8 >> 3]
            m = +h[H + 8 >> 3]
            n = Q + 8 | 0
            i = -1
            j = -1.0
            k = 1
            while (1) {
              if ((k | 0) >= (F | 0)) {
                break
              }
              T = +h[q + (k * 40 | 0) >> 3]
              U = +IU(T)
              V = +BU(T)
              W = +DU(T)
              T = +JU(T)
              h[Q >> 3] = V * v + r * U + W * t + s * T
              h[n >> 3] = W * p + V * u + o * U + m * T
              S = d + (k << 4) | 0
              c[I >> 2] = c[Q >> 2]
              c[I + 4 >> 2] = c[Q + 4 >> 2]
              c[I + 8 >> 2] = c[Q + 8 >> 2]
              c[I + 12 >> 2] = c[Q + 12 >> 2]
              c[J >> 2] = c[S >> 2]
              c[J + 4 >> 2] = c[S + 4 >> 2]
              c[J + 8 >> 2] = c[S + 8 >> 2]
              c[J + 12 >> 2] = c[S + 12 >> 2]
              T = +AU(I, J)
              S = T > j
              i = S ? k : i
              j = S ? T : j
              k = k + 1 | 0
            }
            S = d + (i << 4) | 0
            Q = d + (i + -1 << 4) | 0
            c[I >> 2] = c[S >> 2]
            c[I + 4 >> 2] = c[S + 4 >> 2]
            c[I + 8 >> 2] = c[S + 8 >> 2]
            c[I + 12 >> 2] = c[S + 12 >> 2]
            c[J >> 2] = c[Q >> 2]
            c[J + 4 >> 2] = c[Q + 4 >> 2]
            c[J + 8 >> 2] = c[Q + 8 >> 2]
            c[J + 12 >> 2] = c[Q + 12 >> 2]
            HU(N, I, J)
            c[J >> 2] = c[N >> 2]
            c[J + 4 >> 2] = c[N + 4 >> 2]
            c[J + 8 >> 2] = c[N + 8 >> 2]
            c[J + 12 >> 2] = c[N + 12 >> 2]
            xU(L, J)
            Q = i + 1 | 0
            N = d + (Q << 4) | 0
            c[I >> 2] = c[N >> 2]
            c[I + 4 >> 2] = c[N + 4 >> 2]
            c[I + 8 >> 2] = c[N + 8 >> 2]
            c[I + 12 >> 2] = c[N + 12 >> 2]
            c[J >> 2] = c[S >> 2]
            c[J + 4 >> 2] = c[S + 4 >> 2]
            c[J + 8 >> 2] = c[S + 8 >> 2]
            c[J + 12 >> 2] = c[S + 12 >> 2]
            HU(O, I, J)
            c[J >> 2] = c[O >> 2]
            c[J + 4 >> 2] = c[O + 4 >> 2]
            c[J + 8 >> 2] = c[O + 8 >> 2]
            c[J + 12 >> 2] = c[O + 12 >> 2]
            xU(M, J)
            c[I >> 2] = c[L >> 2]
            c[I + 4 >> 2] = c[L + 4 >> 2]
            c[I + 8 >> 2] = c[L + 8 >> 2]
            c[I + 12 >> 2] = c[L + 12 >> 2]
            c[J >> 2] = c[M >> 2]
            c[J + 4 >> 2] = c[M + 4 >> 2]
            c[J + 8 >> 2] = c[M + 8 >> 2]
            c[J + 12 >> 2] = c[M + 12 >> 2]
            GU(P, I, J)
            c[J >> 2] = c[P >> 2]
            c[J + 4 >> 2] = c[P + 4 >> 2]
            c[J + 8 >> 2] = c[P + 8 >> 2]
            c[J + 12 >> 2] = c[P + 12 >> 2]
            xU(K, J)
            c[I >> 2] = c[f >> 2]
            c[I + 4 >> 2] = c[f + 4 >> 2]
            c[I + 8 >> 2] = c[f + 8 >> 2]
            c[I + 12 >> 2] = c[f + 12 >> 2]
            c[J >> 2] = c[K >> 2]
            c[J + 4 >> 2] = c[K + 4 >> 2]
            c[J + 8 >> 2] = c[K + 8 >> 2]
            c[J + 12 >> 2] = c[K + 12 >> 2]
            zU(a, b, d, Q, I, J) | 0
            c[I >> 2] = c[K >> 2]
            c[I + 4 >> 2] = c[K + 4 >> 2]
            c[I + 8 >> 2] = c[K + 8 >> 2]
            c[I + 12 >> 2] = c[K + 12 >> 2]
            c[J >> 2] = c[g >> 2]
            c[J + 4 >> 2] = c[g + 4 >> 2]
            c[J + 8 >> 2] = c[g + 8 >> 2]
            c[J + 12 >> 2] = c[g + 12 >> 2]
            zU(a, b, S, e - i | 0, I, J) | 0
            i = 0
          } else {
            i = 0
          }
        }
        l = R
        return i | 0
      }

      function AU(a, b) {
        a = a | 0
        b = b | 0
        var c = 0.0, d = 0.0
        c = +h[b >> 3] - +h[a >> 3]
        d = +h[b + 8 >> 3] - +h[a + 8 >> 3]
        return +(+C(+(d * d + c * c)))
      }

      function BU(a) {
        a = +a
        var b = 0.0
        b = 1.0 - a
        return +(b * b * (a * 3.0))
      }

      function CU(a, b, d) {
        a = a | 0
        b = b | 0
        d = +d
        var e = 0
        h[b >> 3] = +h[b >> 3] * d
        e = b + 8 | 0
        h[e >> 3] = +h[e >> 3] * d
        c[a >> 2] = c[b >> 2]
        c[a + 4 >> 2] = c[b + 4 >> 2]
        c[a + 8 >> 2] = c[b + 8 >> 2]
        c[a + 12 >> 2] = c[b + 12 >> 2]
        return
      }

      function DU(a) {
        a = +a
        return +(a * a * 3.0 * (1.0 - a))
      }

      function EU(a, b, d, e, f, g, i, j, k) {
        a = a | 0
        b = b | 0
        d = d | 0
        e = e | 0
        f = f | 0
        g = g | 0
        i = i | 0
        j = j | 0
        k = k | 0
        var m = 0.0, n = 0.0, o = 0.0, p = 0.0, q = 0, r = 0, s = 0, t = 0, u = 0, v = 0, w = 0.0, x = 0.0, y = 0.0,
            z = 0.0, A = 0.0, B = 0, C = 0, D = 0, E = 0, F = 0, G = 0, H = 0.0, I = 0.0, J = 0, K = 0, L = 0, M = 0
        G = l
        l = l + 128 | 0
        B = G + 112 | 0
        v = G + 80 | 0
        u = G
        r = G + 96 | 0
        s = G + 64 | 0
        t = G + 48 | 0
        C = G + 32 | 0
        D = G + 16 | 0
        E = a + (b + -1 << 4) | 0
        q = 0
        w = 0.0
        x = 0.0
        y = 0.0
        z = 0.0
        A = 0.0
        while (1) {
          if ((q | 0) >= (b | 0)) {
            break
          }
          K = d + (q * 40 | 0) + 8 | 0
          c[v >> 2] = c[K >> 2]
          c[v + 4 >> 2] = c[K + 4 >> 2]
          c[v + 8 >> 2] = c[K + 8 >> 2]
          c[v + 12 >> 2] = c[K + 12 >> 2]
          c[B >> 2] = c[K >> 2]
          c[B + 4 >> 2] = c[K + 4 >> 2]
          c[B + 8 >> 2] = c[K + 8 >> 2]
          c[B + 12 >> 2] = c[K + 12 >> 2]
          H = +PU(v, B) + x
          J = d + (q * 40 | 0) + 24 | 0
          c[v >> 2] = c[K >> 2]
          c[v + 4 >> 2] = c[K + 4 >> 2]
          c[v + 8 >> 2] = c[K + 8 >> 2]
          c[v + 12 >> 2] = c[K + 12 >> 2]
          c[B >> 2] = c[J >> 2]
          c[B + 4 >> 2] = c[J + 4 >> 2]
          c[B + 8 >> 2] = c[J + 8 >> 2]
          c[B + 12 >> 2] = c[J + 12 >> 2]
          p = +PU(v, B) + A
          c[v >> 2] = c[J >> 2]
          c[v + 4 >> 2] = c[J + 4 >> 2]
          c[v + 8 >> 2] = c[J + 8 >> 2]
          c[v + 12 >> 2] = c[J + 12 >> 2]
          c[B >> 2] = c[J >> 2]
          c[B + 4 >> 2] = c[J + 4 >> 2]
          c[B + 8 >> 2] = c[J + 8 >> 2]
          c[B + 12 >> 2] = c[J + 12 >> 2]
          o = +PU(v, B) + y
          L = a + (q << 4) | 0
          M = d + (q * 40 | 0) | 0
          I = +QU(+h[M >> 3])
          c[B >> 2] = c[a >> 2]
          c[B + 4 >> 2] = c[a + 4 >> 2]
          c[B + 8 >> 2] = c[a + 8 >> 2]
          c[B + 12 >> 2] = c[a + 12 >> 2]
          CU(s, B, I)
          I = +RU(+h[M >> 3])
          c[B >> 2] = c[E >> 2]
          c[B + 4 >> 2] = c[E + 4 >> 2]
          c[B + 8 >> 2] = c[E + 8 >> 2]
          c[B + 12 >> 2] = c[E + 12 >> 2]
          CU(t, B, I)
          c[v >> 2] = c[s >> 2]
          c[v + 4 >> 2] = c[s + 4 >> 2]
          c[v + 8 >> 2] = c[s + 8 >> 2]
          c[v + 12 >> 2] = c[s + 12 >> 2]
          c[B >> 2] = c[t >> 2]
          c[B + 4 >> 2] = c[t + 4 >> 2]
          c[B + 8 >> 2] = c[t + 8 >> 2]
          c[B + 12 >> 2] = c[t + 12 >> 2]
          GU(r, v, B)
          c[v >> 2] = c[L >> 2]
          c[v + 4 >> 2] = c[L + 4 >> 2]
          c[v + 8 >> 2] = c[L + 8 >> 2]
          c[v + 12 >> 2] = c[L + 12 >> 2]
          c[B >> 2] = c[r >> 2]
          c[B + 4 >> 2] = c[r + 4 >> 2]
          c[B + 8 >> 2] = c[r + 8 >> 2]
          c[B + 12 >> 2] = c[r + 12 >> 2]
          HU(u, v, B)
          c[v >> 2] = c[K >> 2]
          c[v + 4 >> 2] = c[K + 4 >> 2]
          c[v + 8 >> 2] = c[K + 8 >> 2]
          c[v + 12 >> 2] = c[K + 12 >> 2]
          c[B >> 2] = c[u >> 2]
          c[B + 4 >> 2] = c[u + 4 >> 2]
          c[B + 8 >> 2] = c[u + 8 >> 2]
          c[B + 12 >> 2] = c[u + 12 >> 2]
          I = +PU(v, B) + w
          c[v >> 2] = c[J >> 2]
          c[v + 4 >> 2] = c[J + 4 >> 2]
          c[v + 8 >> 2] = c[J + 8 >> 2]
          c[v + 12 >> 2] = c[J + 12 >> 2]
          c[B >> 2] = c[u >> 2]
          c[B + 4 >> 2] = c[u + 4 >> 2]
          c[B + 8 >> 2] = c[u + 8 >> 2]
          c[B + 12 >> 2] = c[u + 12 >> 2]
          q = q + 1 | 0
          w = I
          x = H
          y = o
          z = +PU(v, B) + z
          A = p
        }
        o = y * x - A * A
        p = o >= 0.0 ? o : -o
        if (!(p >= 1.0e-06 ? (m = (y * w - A * z) / o, n = (x * z - A * w) / o, !(p < 1.0e-06 | m <= 0.0 | n <= 0.0))
            : 0)) {
          F = 6
        }
        if ((F | 0) == 6) {
          c[v >> 2] = c[a >> 2]
          c[v + 4 >> 2] = c[a + 4 >> 2]
          c[v + 8 >> 2] = c[a + 8 >> 2]
          c[v + 12 >> 2] = c[a + 12 >> 2]
          c[B >> 2] = c[E >> 2]
          c[B + 4 >> 2] = c[E + 4 >> 2]
          c[B + 8 >> 2] = c[E + 8 >> 2]
          c[B + 12 >> 2] = c[E + 12 >> 2]
          m = +AU(v, B) * .3333333333333333
          n = m
        }
        c[g >> 2] = c[a >> 2]
        c[g + 4 >> 2] = c[a + 4 >> 2]
        c[g + 8 >> 2] = c[a + 8 >> 2]
        c[g + 12 >> 2] = c[a + 12 >> 2]
        c[B >> 2] = c[e >> 2]
        c[B + 4 >> 2] = c[e + 4 >> 2]
        c[B + 8 >> 2] = c[e + 8 >> 2]
        c[B + 12 >> 2] = c[e + 12 >> 2]
        CU(C, B, m)
        c[i >> 2] = c[C >> 2]
        c[i + 4 >> 2] = c[C + 4 >> 2]
        c[i + 8 >> 2] = c[C + 8 >> 2]
        c[i + 12 >> 2] = c[C + 12 >> 2]
        c[j >> 2] = c[E >> 2]
        c[j + 4 >> 2] = c[E + 4 >> 2]
        c[j + 8 >> 2] = c[E + 8 >> 2]
        c[j + 12 >> 2] = c[E + 12 >> 2]
        c[B >> 2] = c[f >> 2]
        c[B + 4 >> 2] = c[f + 4 >> 2]
        c[B + 8 >> 2] = c[f + 8 >> 2]
        c[B + 12 >> 2] = c[f + 12 >> 2]
        CU(D, B, n)
        c[k >> 2] = c[D >> 2]
        c[k + 4 >> 2] = c[D + 4 >> 2]
        c[k + 8 >> 2] = c[D + 8 >> 2]
        c[k + 12 >> 2] = c[D + 12 >> 2]
        l = G
        return
      }

      function FU(a, b, d, e, f, g, i, j) {
        a = a | 0
        b = b | 0
        d = d | 0
        e = e | 0
        f = f | 0
        g = g | 0
        i = i | 0
        j = j | 0
        var k = 0.0, m = 0.0, n = 0.0, o = 0.0, p = 0.0, q = 0, r = 0.0, s = 0.0, t = 0, u = 0.0, v = 0, w = 0.0, x = 0,
            y = 0.0, z = 0, A = 0, B = 0, C = 0, D = 0.0, E = 0
        C = l
        l = l + 64 | 0
        B = C
        z = (j | 0) == 2
        y = +h[d >> 3]
        u = +h[d + 8 >> 3]
        v = B + 8 | 0
        w = +h[e >> 3]
        x = B + 16 | 0
        p = +h[e + 8 >> 3]
        q = B + 24 | 0
        r = +h[f >> 3]
        s = +h[g >> 3]
        t = B + 32 | 0
        o = +h[f + 8 >> 3]
        n = +h[g + 8 >> 3]
        e = B + 40 | 0
        f = B + 48 | 0
        g = B + 56 | 0
        d = 1
        k = 4.0
        m = 4.0
        while (1) {
          h[B >> 3] = y
          h[v >> 3] = u
          D = m * .3333333333333333
          h[x >> 3] = D * w + y
          h[q >> 3] = D * p + u
          D = k * .3333333333333333
          h[t >> 3] = r - D * s
          h[e >> 3] = o - D * n
          h[f >> 3] = r
          h[g >> 3] = o
          if (d ? (D = +KU(B, 4), D < +KU(i, j) + -.001) : 0) {
            d = 0
            break
          }
          if (LU(a, b, B) | 0) {
            A = 5
            break
          }
          if (m == 0.0 & k == 0.0) {
            A = 9
            break
          }
          E = m > .01
          d = 0
          k = E ? k * .5 : 0.0
          m = E ? m * .5 : 0.0
        }
        a:do {
          if ((A | 0) == 5) {
            yU((c[46689] | 0) + 4 | 0)
            e = c[46690] | 0
            d = 1
            while (1) {
              if ((d | 0) == 4) {
                d = 1
                break a
              }
              E = c[46689] | 0
              h[e + (E << 4) >> 3] = +h[B + (d << 4) >> 3]
              D = +h[B + (d << 4) + 8 >> 3]
              c[46689] = E + 1
              h[e + (E << 4) + 8 >> 3] = D
              d = d + 1 | 0
            }
          } else if ((A | 0) == 9) {
            if (z) {
              yU((c[46689] | 0) + 4 | 0)
              e = c[46690] | 0
              d = 1
              while (1) {
                if ((d | 0) == 4) {
                  d = 1
                  break a
                }
                E = c[46689] | 0
                h[e + (E << 4) >> 3] = +h[B + (d << 4) >> 3]
                D = +h[B + (d << 4) + 8 >> 3]
                c[46689] = E + 1
                h[e + (E << 4) + 8 >> 3] = D
                d = d + 1 | 0
              }
            } else {
              d = 0
            }
          }
        } while (0)
        l = C
        return d | 0
      }

      function GU(a, b, d) {
        a = a | 0
        b = b | 0
        d = d | 0
        var e = 0
        h[b >> 3] = +h[b >> 3] + +h[d >> 3]
        e = b + 8 | 0
        h[e >> 3] = +h[e >> 3] + +h[d + 8 >> 3]
        c[a >> 2] = c[b >> 2]
        c[a + 4 >> 2] = c[b + 4 >> 2]
        c[a + 8 >> 2] = c[b + 8 >> 2]
        c[a + 12 >> 2] = c[b + 12 >> 2]
        return
      }

      function HU(a, b, d) {
        a = a | 0
        b = b | 0
        d = d | 0
        var e = 0
        h[b >> 3] = +h[b >> 3] - +h[d >> 3]
        e = b + 8 | 0
        h[e >> 3] = +h[e >> 3] - +h[d + 8 >> 3]
        c[a >> 2] = c[b >> 2]
        c[a + 4 >> 2] = c[b + 4 >> 2]
        c[a + 8 >> 2] = c[b + 8 >> 2]
        c[a + 12 >> 2] = c[b + 12 >> 2]
        return
      }

      function IU(a) {
        a = +a
        a = 1.0 - a
        return +(a * a * a)
      }

      function JU(a) {
        a = +a
        return +(a * a * a)
      }

      function KU(a, b) {
        a = a | 0
        b = b | 0
        var c = 0.0, d = 0, e = 0.0, f = 0.0, g = 0
        c = 0.0
        d = 1
        while (1) {
          if ((d | 0) >= (b | 0)) {
            break
          }
          g = d + -1 | 0
          e = +h[a + (d << 4) >> 3] - +h[a + (g << 4) >> 3]
          f = +h[a + (d << 4) + 8 >> 3] - +h[a + (g << 4) + 8 >> 3]
          c = +C(+(f * f + e * e)) + c
          d = d + 1 | 0
        }
        return +c
      }

      function LU(a, b, d) {
        a = a | 0
        b = b | 0
        d = d | 0
        var e = 0, f = 0, g = 0, i = 0, j = 0, k = 0, m = 0, n = 0, o = 0.0, p = 0.0, q = 0.0, r = 0.0, s = 0.0, t = 0,
            u = 0, v = 0.0, w = 0, x = 0.0, y = 0, z = 0, A = 0, B = 0, C = 0, D = 0.0, E = 0.0
        C = l
        l = l + 64 | 0
        t = C + 32 | 0
        u = C
        w = u + 16 | 0
        y = d + 16 | 0
        z = d + 32 | 0
        A = d + 48 | 0
        B = d + 8 | 0
        g = d + 24 | 0
        i = d + 40 | 0
        j = d + 56 | 0
        k = u + 8 | 0
        m = u + 24 | 0
        f = 0
        a:while (1) {
          if ((f | 0) >= (b | 0)) {
            e = 1
            break
          }
          n = a + (f << 5) | 0
          c[u >> 2] = c[n >> 2]
          c[u + 4 >> 2] = c[n + 4 >> 2]
          c[u + 8 >> 2] = c[n + 8 >> 2]
          c[u + 12 >> 2] = c[n + 12 >> 2]
          n = a + (f << 5) + 16 | 0
          c[w >> 2] = c[n >> 2]
          c[w + 4 >> 2] = c[n + 4 >> 2]
          c[w + 8 >> 2] = c[n + 8 >> 2]
          c[w + 12 >> 2] = c[n + 12 >> 2]
          n = MU(d, u, t) | 0
          b:do {
            if ((n | 0) != 4) {
              o = +h[u >> 3]
              p = +h[k >> 3]
              q = +h[w >> 3]
              r = +h[m >> 3]
              e = 0
              while (1) {
                if ((e | 0) >= (n | 0)) {
                  break b
                }
                s = +h[t + (e << 3) >> 3]
                if ((!(s < 1.0e-06 | s > .999999) ? (x = s * s * s, E = s * 3.0, D = 1.0 - s, s = E * s * D, v = D
                    * D, E = v * E, D = v * D, v = +h[y >> 3] * E + +h[d >> 3] * D + +h[z >> 3] * s + +h[A >> 3]
                    * x, x = +h[g >> 3] * E + +h[B >> 3] * D + +h[i >> 3] * s + +h[j >> 3] * x, s = v - o, D = x
                    - p, !(D
                    * D + s * s < .001)) : 0) ? (E = v - q, D = x - r, !(D * D + E * E < .001)) : 0) {
                  e = 0
                  break a
                }
                e = e + 1 | 0
              }
            }
          } while (0)
          f = f + 1 | 0
        }
        l = C
        return e | 0
      }

      function MU(a, b, d) {
        a = a | 0
        b = b | 0
        d = d | 0
        var e = 0, f = 0, g = 0.0, i = 0, j = 0.0, k = 0, m = 0, n = 0, o = 0, p = 0.0, q = 0.0, r = 0, s = 0, t = 0,
            u = 0, v = 0
        v = l
        l = l + 96 | 0
        s = v + 48 | 0
        t = v + 24 | 0
        k = v
        u = v + 80 | 0
        p = +h[b >> 3]
        g = +h[b + 16 >> 3] - p
        q = +h[b + 8 >> 3]
        j = +h[b + 24 >> 3] - q
        c[u >> 2] = 0
        a:do {
          if (!(g == 0.0)) {
            j = j / g
            m = a + 16 | 0
            n = a + 32 | 0
            o = a + 48 | 0
            NU(+h[a + 8 >> 3] - +h[a >> 3] * j, +h[a + 24 >> 3] - +h[m >> 3] * j, +h[a + 40 >> 3] - +h[n >> 3] * j,
                +h[a + 56 >> 3] - +h[o >> 3] * j, s)
            h[s >> 3] = j * p - q + +h[s >> 3]
            e = jV(s, t) | 0
            if ((e | 0) == 4) {
              b = 4
            } else {
              f = s + 8 | 0
              i = s + 16 | 0
              k = s + 24 | 0
              g = 1.0 / g
              b = 0
              while (1) {
                if ((b | 0) >= (e | 0)) {
                  break
                }
                j = +h[t + (b << 3) >> 3]
                if (j >= 0.0 & j <= 1.0 ? (NU(+h[a >> 3], +h[m >> 3], +h[n >> 3], +h[o >> 3], s), q = (+h[s >> 3] - p
                    + ((+h[k >> 3] * j + +h[i >> 3]) * j + +h[f >> 3]) * j) * g, q >= 0.0 & q <= 1.0) : 0) {
                  OU(j, d, u)
                }
                b = b + 1 | 0
              }
              b = c[u >> 2] | 0
            }
          } else {
            NU(+h[a >> 3], +h[a + 16 >> 3], +h[a + 32 >> 3], +h[a + 48 >> 3], s)
            h[s >> 3] = +h[s >> 3] - p
            r = jV(s, t) | 0
            if (!(j == 0.0)) {
              if ((r | 0) == 4) {
                b = 4
                break
              }
              m = a + 8 | 0
              n = a + 24 | 0
              o = a + 40 | 0
              e = a + 56 | 0
              f = s + 8 | 0
              i = s + 16 | 0
              k = s + 24 | 0
              g = 1.0 / j
              b = 0
              while (1) {
                if ((b | 0) >= (r | 0)) {
                  break
                }
                j = +h[t + (b << 3) >> 3]
                if (j >= 0.0 & j <= 1.0 ? (NU(+h[m >> 3], +h[n >> 3], +h[o >> 3], +h[e >> 3], s), p = (+h[s >> 3] - q
                    + ((+h[k >> 3] * j + +h[i >> 3]) * j + +h[f >> 3]) * j) * g, p >= 0.0 & p <= 1.0) : 0) {
                  OU(j, d, u)
                }
                b = b + 1 | 0
              }
              b = c[u >> 2] | 0
              break
            }
            NU(+h[a + 8 >> 3], +h[a + 24 >> 3], +h[a + 40 >> 3], +h[a + 56 >> 3], s)
            h[s >> 3] = +h[s >> 3] - q
            i = jV(s, k) | 0
            b = (i | 0) == 4
            b:do {
              if ((r | 0) == 4) {
                if (b) {
                  b = 4
                  break a
                } else {
                  b = 0
                }
                while (1) {
                  if ((b | 0) >= (i | 0)) {
                    break b
                  }
                  OU(+h[k + (b << 3) >> 3], d, u)
                  b = b + 1 | 0
                }
              } else {
                if (b) {
                  b = 0
                  while (1) {
                    if ((b | 0) >= (r | 0)) {
                      break b
                    }
                    OU(+h[t + (b << 3) >> 3], d, u)
                    b = b + 1 | 0
                  }
                } else {
                  e = 0
                }
                while (1) {
                  if ((e | 0) >= (r | 0)) {
                    break b
                  }
                  f = t + (e << 3) | 0
                  b = 0
                  while (1) {
                    if ((b | 0) >= (i | 0)) {
                      break
                    }
                    g = +h[f >> 3]
                    if (g == +h[k + (b << 3) >> 3]) {
                      OU(g, d, u)
                    }
                    b = b + 1 | 0
                  }
                  e = e + 1 | 0
                }
              }
            } while (0)
            b = c[u >> 2] | 0
          }
        } while (0)
        l = v
        return b | 0
      }

      function NU(a, b, c, d, e) {
        a = +a
        b = +b
        c = +c
        d = +d
        e = e | 0
        h[e + 24 >> 3] = d - a + (b - c) * 3.0
        h[e + 16 >> 3] = (c + a) * 3.0 - b * 6.0
        h[e + 8 >> 3] = (b - a) * 3.0
        h[e >> 3] = a
        return
      }

      function OU(a, b, d) {
        a = +a
        b = b | 0
        d = d | 0
        var e = 0
        if (a >= 0.0 & a <= 1.0) {
          e = c[d >> 2] | 0
          h[b + (e << 3) >> 3] = a
          c[d >> 2] = e + 1
        }
        return
      }

      function PU(a, b) {
        a = a | 0
        b = b | 0
        return +(+h[b + 8 >> 3] * +h[a + 8 >> 3] + +h[b >> 3] * +h[a >> 3])
      }

      function QU(a) {
        a = +a
        var b = 0.0
        b = 1.0 - a
        return +(b * b * (b + a * 3.0))
      }

      function RU(a) {
        a = +a
        return +(a * a * ((1.0 - a) * 3.0 + a))
      }

      function SU(a, b, d) {
        a = a | 0
        b = b | 0
        d = d | 0
        var e = 0, f = 0, g = 0, i = 0.0, j = 0, k = 0, m = 0, n = 0, q = 0, r = 0, s = 0, u = 0, v = 0, w = 0, x = 0,
            y = 0, A = 0, B = 0, C = 0, D = 0, E = 0, F = 0, G = 0, H = 0, I = 0.0
        H = l
        l = l + 112 | 0
        E = H + 80 | 0
        D = H + 64 | 0
        C = H + 48 | 0
        G = 4
        F = B_(40) | 0
        c[F >> 2] = 0
        w = H + 32 | 0
        x = H + 16 | 0
        y = H
        A = H + 96 | 0
        G = C3(186776, 1, F | 0, G | 0) | 0
        F = z
        o = 0
        e = o
        o = 0
        if ((e | 0) != 0 & (p | 0) != 0) {
          f = D3(c[e >> 2] | 0, G | 0, F | 0) | 0
          if (!f) {
            bb(e | 0, p | 0)
          }
          z = p
        } else {
          f = -1
        }
        if ((f | 0) == 1) {
          e = z
        } else {
          e = 0
        }
        a:while (1) {
          if (e | 0) {
            e = -2
            break
          }
          g = a + 4 | 0
          o = 0
          ia(113, c[g >> 2] | 0)
          e = o
          o = 0
          if ((e | 0) != 0 & (p | 0) != 0) {
            f = D3(c[e >> 2] | 0, G | 0, F | 0) | 0
            if (!f) {
              bb(e | 0, p | 0)
            }
            z = p
          } else {
            f = -1
          }
          if ((f | 0) == 1) {
            e = z
            continue
          }
          c[46733] = 0
          c[46734] = 0
          o = 0
          ia(114, c[g >> 2] << 1 | 0)
          e = o
          o = 0
          if ((e | 0) != 0 & (p | 0) != 0) {
            f = D3(c[e >> 2] | 0, G | 0, F | 0) | 0
            if (!f) {
              bb(e | 0, p | 0)
            }
            z = p
          } else {
            f = -1
          }
          if ((f | 0) == 1) {
            e = z
            continue
          }
          m = (c[46736] | 0) / 2 | 0
          c[46737] = m
          c[46738] = m + -1
          m = c[g >> 2] | 0
          g = c[a >> 2] | 0
          e = 0
          f = -1
          i = t
          while (1) {
            if ((e | 0) >= (m | 0)) {
              break
            }
            I = +h[g + (e << 4) >> 3]
            v = i > I
            u = v ? e : f
            e = e + 1 | 0
            f = u
            i = v ? I : i
          }
          v = g + (f << 4) | 0
          c[x >> 2] = c[v >> 2]
          c[x + 4 >> 2] = c[v + 4 >> 2]
          c[x + 8 >> 2] = c[v + 8 >> 2]
          c[x + 12 >> 2] = c[v + 12 >> 2]
          v = g + (((f | 0) == 0 ? m : f) + -1 << 4) | 0
          c[w >> 2] = c[v >> 2]
          c[w + 4 >> 2] = c[v + 4 >> 2]
          c[w + 8 >> 2] = c[v + 8 >> 2]
          c[w + 12 >> 2] = c[v + 12 >> 2]
          v = g + (((f | 0) == (m + -1 | 0) ? 0 : f + 1 | 0) << 4) | 0
          c[y >> 2] = c[v >> 2]
          c[y + 4 >> 2] = c[v + 4 >> 2]
          c[y + 8 >> 2] = c[v + 8 >> 2]
          c[y + 12 >> 2] = c[v + 12 >> 2]
          I = +h[x >> 3]
          if ((+h[w >> 3] == I ? I == +h[y >> 3] : 0) ? +h[y + 8 >> 3] > +h[x + 8 >> 3] : 0) {
            v = 15
          } else {
            v = 12
          }
          b:do {
            if ((v | 0) == 12) {
              v = 0
              o = 0
              e = ca(33, w | 0, x | 0, y | 0) | 0
              f = o
              o = 0
              if ((f | 0) != 0 & (p | 0) != 0) {
                g = D3(c[f >> 2] | 0, G | 0, F | 0) | 0
                if (!g) {
                  bb(f | 0, p | 0)
                }
                z = p
              } else {
                g = -1
              }
              if ((g | 0) == 1) {
                e = z
                continue a
              }
              if ((e | 0) == 1) {
                g = c[46740] | 0
                e = c[46741] | 0
                f = 0
                while (1) {
                  if ((f | 0) >= (m | 0)) {
                    break b
                  }
                  j = c[a >> 2] | 0
                  if (!(((f | 0) > 0 ? (B = f + -1 | 0, +h[j + (f << 4) >> 3] == +h[j + (B << 4) >> 3]) : 0) ? +h[j + (f
                      << 4) + 8 >> 3] == +h[j + (B << 4) + 8 >> 3] : 0)) {
                    u = c[46733] | 0
                    c[g + (u << 3) >> 2] = j + (f << 4)
                    c[g + (u << 3) + 4 >> 2] = g + (((u | 0) % (m | 0) | 0) << 3)
                    c[e + (u << 2) >> 2] = g + (u << 3)
                    c[46733] = u + 1
                  }
                  f = f + 1 | 0
                }
              } else {
                v = 15
              }
            }
          } while (0)
          c:do {
            if ((v | 0) == 15) {
              v = 0
              j = c[46740] | 0
              e = c[46741] | 0
              g = m
              while (1) {
                f = g + -1 | 0
                if ((g | 0) <= 0) {
                  break c
                }
                k = c[a >> 2] | 0
                if (((g | 0) < (m | 0) ? +h[k + (f << 4) >> 3] == +h[k + (g << 4) >> 3] : 0) ? +h[k + (f << 4) + 8 >> 3]
                    == +h[k + (g << 4) + 8 >> 3] : 0) {
                  g = f
                  continue
                }
                g = c[46733] | 0
                c[j + (g << 3) >> 2] = k + (f << 4)
                c[j + (g << 3) + 4 >> 2] = j + (((g | 0) % (m | 0) | 0) << 3)
                c[e + (g << 2) >> 2] = j + (g << 3)
                c[46733] = g + 1
                g = f
              }
            }
          } while (0)
          o = 0
          ja(29, e | 0, c[46733] | 0)
          e = o
          o = 0
          if ((e | 0) != 0 & (p | 0) != 0) {
            f = D3(c[e >> 2] | 0, G | 0, F | 0) | 0
            if (!f) {
              bb(e | 0, p | 0)
            }
            z = p
          } else {
            f = -1
          }
          if ((f | 0) == 1) {
            e = z
            continue
          }
          j = 0
          e = c[46734] | 0
          d:while (1) {
            if ((j | 0) >= (e | 0)) {
              s = 0
              break
            }
            k = j + 1 | 0
            g = k
            while (1) {
              if ((g | 0) >= (e | 0)) {
                j = k
                continue d
              }
              o = 0
              ja(30, j | 0, g | 0)
              e = o
              o = 0
              if ((e | 0) != 0 & (p | 0) != 0) {
                f = D3(c[e >> 2] | 0, G | 0, F | 0) | 0
                if (!f) {
                  bb(e | 0, p | 0)
                }
                z = p
              } else {
                f = -1
              }
              if ((f | 0) == 1) {
                e = z
                continue a
              }
              g = g + 1 | 0
              e = c[46734] | 0
            }
          }
          while (1) {
            if ((s | 0) >= (e | 0)) {
              break
            }
            o = 0
            f = aa(103, s | 0, b | 0) | 0
            g = o
            o = 0
            if ((g | 0) != 0 & (p | 0) != 0) {
              j = D3(c[g >> 2] | 0, G | 0, F | 0) | 0
              if (!j) {
                bb(g | 0, p | 0)
              }
              z = p
            } else {
              j = -1
            }
            if ((j | 0) == 1) {
              e = z
              continue a
            }
            if (f | 0) {
              break
            }
            s = s + 1 | 0
          }
          if ((s | 0) == (e | 0)) {
            e = c[15686] | 0
            o = 0
            c[C >> 2] = 138776
            c[C + 4 >> 2] = 192
            c[C + 8 >> 2] = 138787
            ca(29, e | 0, 138757, C | 0) | 0
            e = o
            o = 0
            if ((e | 0) != 0 & (p | 0) != 0) {
              f = D3(c[e >> 2] | 0, G | 0, F | 0) | 0
              if (!f) {
                bb(e | 0, p | 0)
              }
              z = p
            } else {
              f = -1
            }
            if ((f | 0) == 1) {
              e = z
              continue
            } else {
              v = 41
              break
            }
          }
          u = b + 16 | 0
          k = 0
          while (1) {
            if ((k | 0) >= (e | 0)) {
              break
            }
            o = 0
            f = aa(103, k | 0, u | 0) | 0
            g = o
            o = 0
            if ((g | 0) != 0 & (p | 0) != 0) {
              j = D3(c[g >> 2] | 0, G | 0, F | 0) | 0
              if (!j) {
                bb(g | 0, p | 0)
              }
              z = p
            } else {
              j = -1
            }
            if ((j | 0) == 1) {
              e = z
              continue a
            }
            if (f | 0) {
              break
            }
            k = k + 1 | 0
          }
          if ((k | 0) == (e | 0)) {
            e = c[15686] | 0
            o = 0
            c[D >> 2] = 138776
            c[D + 4 >> 2] = 200
            c[D + 8 >> 2] = 138820
            ca(29, e | 0, 138757, D | 0) | 0
            e = o
            o = 0
            if ((e | 0) != 0 & (p | 0) != 0) {
              f = D3(c[e >> 2] | 0, G | 0, F | 0) | 0
              if (!f) {
                bb(e | 0, p | 0)
              }
              z = p
            } else {
              f = -1
            }
            if ((f | 0) == 1) {
              e = z
              continue
            } else {
              v = 48
              break
            }
          }
          o = 0
          e = aa(104, s | 0, k | 0) | 0
          f = o
          o = 0
          if ((f | 0) != 0 & (p | 0) != 0) {
            g = D3(c[f >> 2] | 0, G | 0, F | 0) | 0
            if (!g) {
              bb(f | 0, p | 0)
            }
            z = p
          } else {
            g = -1
          }
          if ((g | 0) == 1) {
            e = z
            continue
          }
          if (!e) {
            e = c[15686] | 0
            o = 0
            c[E >> 2] = 138776
            c[E + 4 >> 2] = 207
            c[E + 8 >> 2] = 138858
            ca(29, e | 0, 138757, E | 0) | 0
            e = o
            o = 0
            if ((e | 0) != 0 & (p | 0) != 0) {
              f = D3(c[e >> 2] | 0, G | 0, F | 0) | 0
              if (!f) {
                bb(e | 0, p | 0)
              }
              z = p
            } else {
              f = -1
            }
            if ((f | 0) == 1) {
              e = z
              continue
            }
            o = 0
            ia(115, 2)
            e = o
            o = 0
            if ((e | 0) != 0 & (p | 0) != 0) {
              f = D3(c[e >> 2] | 0, G | 0, F | 0) | 0
              if (!f) {
                bb(e | 0, p | 0)
              }
              z = p
            } else {
              f = -1
            }
            if ((f | 0) == 1) {
              e = z
              continue
            } else {
              v = 53
              break
            }
          }
          if ((s | 0) == (k | 0)) {
            o = 0
            ia(115, 2)
            e = o
            o = 0
            if ((e | 0) != 0 & (p | 0) != 0) {
              f = D3(c[e >> 2] | 0, G | 0, F | 0) | 0
              if (!f) {
                bb(e | 0, p | 0)
              }
              z = p
            } else {
              f = -1
            }
            if ((f | 0) == 1) {
              e = z
              continue
            } else {
              v = 56
              break
            }
          }
          c[A >> 2] = b
          c[A + 4 >> 2] = 0
          f = A + 8 | 0
          c[f >> 2] = u
          c[A + 12 >> 2] = 0
          o = 0
          ja(31, 1, A | 0)
          e = o
          o = 0
          if ((e | 0) != 0 & (p | 0) != 0) {
            g = D3(c[e >> 2] | 0, G | 0, F | 0) | 0
            if (!g) {
              bb(e | 0, p | 0)
            }
            z = p
          } else {
            g = -1
          }
          if ((g | 0) == 1) {
            e = z
            continue
          }
          c[46739] = c[46737]
          q = s
          e:while (1) {
            if ((q | 0) == -1) {
              g = f
              e = 0
              break
            }
            r = c[46743] | 0
            c[r + (q * 52 | 0) >> 2] = 2
            e = 0
            while (1) {
              if ((e | 0) >= 3) {
                v = 65
                break
              }
              v = c[r + (q * 52 | 0) + 4 + (e << 4) + 12 >> 2] | 0
              if (v | 0 ? (c[v >> 2] | 0) == 1 : 0) {
                v = 68
                break
              }
              e = e + 1 | 0
            }
            if ((v | 0) == 65) {
              v = 0
              if ((e | 0) == 3) {
                e = c[46735] | 0
                k = c[e + (c[46738] << 2) >> 2] | 0
                o = 0
                e = ca(33, u | 0, c[c[e + (c[46737] << 2) >> 2] >> 2] | 0, c[k >> 2] | 0) | 0
                g = o
                o = 0
                if ((g | 0) != 0 & (p | 0) != 0) {
                  j = D3(c[g >> 2] | 0, G | 0, F | 0) | 0
                  if (!j) {
                    bb(g | 0, p | 0)
                  }
                  z = p
                } else {
                  j = -1
                }
                if ((j | 0) == 1) {
                  e = z
                  continue a
                }
                j = (e | 0) == 1
                n = j ? f : k
                j = j ? k : f
              } else {
                v = 68
              }
            }
            if ((v | 0) == 68) {
              v = 0
              k = c[r + (q * 52 | 0) + 4 + (e << 4) >> 2] | 0
              m = c[r + (q * 52 | 0) + 4 + (e << 4) + 4 >> 2] | 0
              o = 0
              e = ca(33, c[k >> 2] | 0, c[c[r + (q * 52 | 0) + 4 + (((e + 1 | 0) % 3 | 0) << 4) + 4 >> 2] >> 2] | 0,
                  c[m >> 2] | 0) | 0
              g = o
              o = 0
              if ((g | 0) != 0 & (p | 0) != 0) {
                j = D3(c[g >> 2] | 0, G | 0, F | 0) | 0
                if (!j) {
                  bb(g | 0, p | 0)
                }
                z = p
              } else {
                j = -1
              }
              if ((j | 0) == 1) {
                e = z
                continue a
              }
              j = (e | 0) == 1
              n = j ? k : m
              j = j ? m : k
            }
            do {
              if ((q | 0) == (s | 0)) {
                o = 0
                ja(31, 2, j | 0)
                e = o
                o = 0
                if ((e | 0) != 0 & (p | 0) != 0) {
                  g = D3(c[e >> 2] | 0, G | 0, F | 0) | 0
                  if (!g) {
                    bb(e | 0, p | 0)
                  }
                  z = p
                } else {
                  g = -1
                }
                if ((g | 0) == 1) {
                  e = z
                  continue a
                }
                o = 0
                ja(31, 1, n | 0)
                e = o
                o = 0
                if ((e | 0) != 0 & (p | 0) != 0) {
                  g = D3(c[e >> 2] | 0, G | 0, F | 0) | 0
                  if (!g) {
                    bb(e | 0, p | 0)
                  }
                  z = p
                } else {
                  g = -1
                }
                if ((g | 0) == 1) {
                  e = z
                  continue a
                }
                e = 0
              } else {
                m = c[46735] | 0
                if ((c[m + (c[46737] << 2) >> 2] | 0) != (n | 0) ? (c[m + (c[46738] << 2) >> 2] | 0) != (n | 0) : 0) {
                  o = 0
                  j = $(34, n | 0) | 0
                  e = o
                  o = 0
                  if ((e | 0) != 0 & (p | 0) != 0) {
                    g = D3(c[e >> 2] | 0, G | 0, F | 0) | 0
                    if (!g) {
                      bb(e | 0, p | 0)
                    }
                    z = p
                  } else {
                    g = -1
                  }
                  if ((g | 0) == 1) {
                    e = z
                    continue a
                  }
                  o = 0
                  ja(32, 2, j | 0)
                  e = o
                  o = 0
                  if ((e | 0) != 0 & (p | 0) != 0) {
                    g = D3(c[e >> 2] | 0, G | 0, F | 0) | 0
                    if (!g) {
                      bb(e | 0, p | 0)
                    }
                    z = p
                  } else {
                    g = -1
                  }
                  if ((g | 0) == 1) {
                    e = z
                    continue a
                  }
                  o = 0
                  ja(31, 1, n | 0)
                  e = o
                  o = 0
                  if ((e | 0) != 0 & (p | 0) != 0) {
                    g = D3(c[e >> 2] | 0, G | 0, F | 0) | 0
                    if (!g) {
                      bb(e | 0, p | 0)
                    }
                    z = p
                  } else {
                    g = -1
                  }
                  if ((g | 0) == 1) {
                    e = z
                    continue a
                  }
                  if ((j | 0) <= (c[46739] | 0)) {
                    e = 0
                    break
                  }
                  c[46739] = j
                  e = 0
                  break
                }
                o = 0
                k = $(34, j | 0) | 0
                e = o
                o = 0
                if ((e | 0) != 0 & (p | 0) != 0) {
                  g = D3(c[e >> 2] | 0, G | 0, F | 0) | 0
                  if (!g) {
                    bb(e | 0, p | 0)
                  }
                  z = p
                } else {
                  g = -1
                }
                if ((g | 0) == 1) {
                  e = z
                  continue a
                }
                o = 0
                ja(32, 1, k | 0)
                e = o
                o = 0
                if ((e | 0) != 0 & (p | 0) != 0) {
                  g = D3(c[e >> 2] | 0, G | 0, F | 0) | 0
                  if (!g) {
                    bb(e | 0, p | 0)
                  }
                  z = p
                } else {
                  g = -1
                }
                if ((g | 0) == 1) {
                  e = z
                  continue a
                }
                o = 0
                ja(31, 2, j | 0)
                e = o
                o = 0
                if ((e | 0) != 0 & (p | 0) != 0) {
                  g = D3(c[e >> 2] | 0, G | 0, F | 0) | 0
                  if (!g) {
                    bb(e | 0, p | 0)
                  }
                  z = p
                } else {
                  g = -1
                }
                if ((g | 0) == 1) {
                  e = z
                  continue a
                }
                if ((k | 0) >= (c[46739] | 0)) {
                  e = 0
                  break
                }
                c[46739] = k
                e = 0
              }
            } while (0)
            while (1) {
              if ((e | 0) >= 3) {
                q = -1
                continue e
              }
              g = c[r + (q * 52 | 0) + 4 + (e << 4) + 12 >> 2] | 0
              if (g | 0 ? (c[g >> 2] | 0) == 1 : 0) {
                break
              }
              e = e + 1 | 0
            }
            q = (g - (c[46743] | 0) | 0) / 52 | 0
          }
          while (1) {
            if (!g) {
              break
            }
            g = c[g + 4 >> 2] | 0
            e = e + 1 | 0
          }
          o = 0
          ia(115, e | 0)
          g = o
          o = 0
          if ((g | 0) != 0 & (p | 0) != 0) {
            j = D3(c[g >> 2] | 0, G | 0, F | 0) | 0
            if (!j) {
              bb(g | 0, p | 0)
            }
            z = p
          } else {
            j = -1
          }
          if ((j | 0) == 1) {
            e = z
          } else {
            v = 94
            break
          }
        }
        if ((v | 0) == 41) {
          e = -1
        } else if ((v | 0) == 48) {
          e = -1
        } else if ((v | 0) == 53) {
          c[d + 4 >> 2] = 2
          e = c[46742] | 0
          c[e >> 2] = c[b >> 2]
          c[e + 4 >> 2] = c[b + 4 >> 2]
          c[e + 8 >> 2] = c[b + 8 >> 2]
          c[e + 12 >> 2] = c[b + 12 >> 2]
          F = e + 16 | 0
          c[F >> 2] = c[u >> 2]
          c[F + 4 >> 2] = c[u + 4 >> 2]
          c[F + 8 >> 2] = c[u + 8 >> 2]
          c[F + 12 >> 2] = c[u + 12 >> 2]
          c[d >> 2] = e
          e = 0
        } else if ((v | 0) == 56) {
          c[d + 4 >> 2] = 2
          e = c[46742] | 0
          c[e >> 2] = c[b >> 2]
          c[e + 4 >> 2] = c[b + 4 >> 2]
          c[e + 8 >> 2] = c[b + 8 >> 2]
          c[e + 12 >> 2] = c[b + 12 >> 2]
          F = e + 16 | 0
          c[F >> 2] = c[u >> 2]
          c[F + 4 >> 2] = c[u + 4 >> 2]
          c[F + 8 >> 2] = c[u + 8 >> 2]
          c[F + 12 >> 2] = c[u + 12 >> 2]
          c[d >> 2] = e
          e = 0
        } else if ((v | 0) == 94) {
          c[d + 4 >> 2] = e
          g = c[46742] | 0
          while (1) {
            e = e + -1 | 0
            if (!f) {
              break
            }
            F = g + (e << 4) | 0
            E = c[f >> 2] | 0
            c[F >> 2] = c[E >> 2]
            c[F + 4 >> 2] = c[E + 4 >> 2]
            c[F + 8 >> 2] = c[E + 8 >> 2]
            c[F + 12 >> 2] = c[E + 12 >> 2]
            f = c[f + 4 >> 2] | 0
          }
          c[d >> 2] = g
          e = 0
        }
        C_(G | 0)
        l = H
        return e | 0
      }

      function TU(a) {
        a = a | 0
        var b = 0, d = 0, e = 0, f = 0, g = 0, h = 0
        h = l
        l = l + 64 | 0
        e = h + 48 | 0
        g = h + 32 | 0
        f = h + 16 | 0
        d = h
        if ((c[46746] | 0) < (a | 0)) {
          b = c[46740] | 0
          if (!b) {
            g = B_(a << 3) | 0
            c[46740] = g
            if (!g) {
              g = c[15686] | 0
              c[d >> 2] = 138776
              c[d + 4 >> 2] = 523
              c[d + 8 >> 2] = 139026
              f1(g, 138757, d) | 0
              bb(186776, 1)
            }
            g = B_(a << 2) | 0
            c[46741] = g
            if (!g) {
              g = c[15686] | 0
              c[f >> 2] = 138776
              c[f + 4 >> 2] = 527
              c[f + 8 >> 2] = 139045
              f1(g, 138757, f) | 0
              bb(186776, 1)
            }
          } else {
            f = E_(b, a << 3) | 0
            c[46740] = f
            if (!f) {
              f = c[15686] | 0
              c[g >> 2] = 138776
              c[g + 4 >> 2] = 533
              c[g + 8 >> 2] = 139065
              f1(f, 138757, g) | 0
              bb(186776, 1)
            }
            g = E_(c[46741] | 0, a << 2) | 0
            c[46741] = g
            if (!g) {
              g = c[15686] | 0
              c[e >> 2] = 138776
              c[e + 4 >> 2] = 539
              c[e + 8 >> 2] = 139085
              f1(g, 138757, e) | 0
              bb(186776, 1)
            }
          }
          c[46746] = a
        }
        l = h
        return
      }

      function UU(a) {
        a = a | 0
        var b = 0, d = 0, e = 0, f = 0
        f = l
        l = l + 32 | 0
        e = f + 16 | 0
        d = f
        if ((c[46736] | 0) < (a | 0)) {
          b = c[46735] | 0
          if (!b) {
            e = B_(a << 2) | 0
            c[46735] = e
            if (!e) {
              e = c[15686] | 0
              c[d >> 2] = 138776
              c[d + 4 >> 2] = 573
              c[d + 8 >> 2] = 138981
              f1(e, 138757, d) | 0
              bb(186776, 1)
            }
          } else {
            d = E_(b, a << 2) | 0
            c[46735] = d
            if (!d) {
              d = c[15686] | 0
              c[e >> 2] = 138776
              c[e + 4 >> 2] = 580
              c[e + 8 >> 2] = 139003
              f1(d, 138757, e) | 0
              bb(186776, 1)
            }
          }
          c[46736] = a
        }
        l = f
        return
      }

      function VU(a, b, c) {
        a = a | 0
        b = b | 0
        c = c | 0
        var d = 0.0, e = 0.0
        d = +h[b + 8 >> 3]
        e = +h[b >> 3]
        d = (+h[c >> 3] - e) * (+h[a + 8 >> 3] - d) - (+h[a >> 3] - e) * (+h[c + 8 >> 3] - d)
        return (d > 0.0 ? 1 : d < 0.0 ? 2 : 3) | 0
      }

      function WU(a, b) {
        a = a | 0
        b = b | 0
        var d = 0, e = 0, f = 0, g = 0, h = 0, i = 0
        i = l
        l = l + 16 | 0
        h = i
        a:while (1) {
          if ((b | 0) > 3) {
            e = 0
          } else {
            b = 9
            break
          }
          while (1) {
            if ((e | 0) >= (b | 0)) {
              b = 8
              break a
            }
            f = e + 1 | 0
            d = (f | 0) % (b | 0) | 0
            g = (e + 2 | 0) % (b | 0) | 0
            if (!(cV(e, g, a, b) | 0)) {
              e = f
            } else {
              break
            }
          }
          dV(c[a + (e << 2) >> 2] | 0, c[a + (d << 2) >> 2] | 0, c[a + (g << 2) >> 2] | 0)
          b = b + -1 | 0
          while (1) {
            if ((d | 0) >= (b | 0)) {
              continue a
            }
            g = d + 1 | 0
            c[a + (d << 2) >> 2] = c[a + (g << 2) >> 2]
            d = g
          }
        }
        if ((b | 0) == 8) {
          a = c[15686] | 0
          c[h >> 2] = 138776
          c[h + 4 >> 2] = 324
          c[h + 8 >> 2] = 138921
          f1(a, 138757, h) | 0
        } else if ((b | 0) == 9) {
          dV(c[a >> 2] | 0, c[a + 4 >> 2] | 0, c[a + 8 >> 2] | 0)
        }
        l = i
        return
      }

      function XU(a, b) {
        a = a | 0
        b = b | 0
        var d = 0, e = 0, f = 0, g = 0, h = 0, i = 0, j = 0, k = 0, l = 0, m = 0, n = 0, o = 0
        i = c[46743] | 0
        j = i + (a * 52 | 0) | 0
        k = i + (b * 52 | 0) | 0
        g = 0
        while (1) {
          if ((g | 0) == 3) {
            break
          }
          l = i + (a * 52 | 0) + 4 + (g << 4) | 0
          m = i + (a * 52 | 0) + 4 + (g << 4) + 4 | 0
          n = i + (a * 52 | 0) + 4 + (g << 4) + 12 | 0
          f = 0
          while (1) {
            if ((f | 0) == 3) {
              break
            }
            o = c[c[l >> 2] >> 2] | 0
            h = c[c[i + (b * 52 | 0) + 4 + (f << 4) >> 2] >> 2] | 0
            if ((o | 0) == (h | 0)) {
              d = c[c[i + (b * 52 | 0) + 4 + (f << 4) + 4 >> 2] >> 2] | 0
              if ((c[c[m >> 2] >> 2] | 0) == (d | 0)) {
                e = 10
              } else {
                e = 8
              }
            } else {
              d = c[c[i + (b * 52 | 0) + 4 + (f << 4) + 4 >> 2] >> 2] | 0
              e = 8
            }
            if (((e | 0) == 8 ? (e = 0, (o | 0) == (d | 0)) : 0) ? (c[c[m >> 2] >> 2] | 0) == (h | 0) : 0) {
              e = 10
            }
            if ((e | 0) == 10) {
              c[n >> 2] = k
              c[i + (b * 52 | 0) + 4 + (f << 4) + 12 >> 2] = j
            }
            f = f + 1 | 0
          }
          g = g + 1 | 0
        }
        return
      }

      function YU(a, b) {
        a = a | 0
        b = b | 0
        var d = 0, e = 0, f = 0
        f = c[46743] | 0
        d = 0
        e = 0
        while (1) {
          if ((e | 0) == 3) {
            break
          }
          d = d + ((VU(c[c[f + (a * 52 | 0) + 4 + (e << 4) >> 2] >> 2] | 0,
              c[c[f + (a * 52 | 0) + 4 + (e << 4) + 4 >> 2] >> 2] | 0, b) | 0) != 2 & 1) | 0
          e = e + 1 | 0
        }
        return ((d | 0) == 3 | (d | 0) == 0) & 1 | 0
      }

      function ZU(a, b) {
        a = a | 0
        b = b | 0
        var d = 0, e = 0, f = 0
        d = c[46743] | 0
        e = d + (a * 52 | 0) | 0
        a:do {
          if (!(c[e >> 2] | 0)) {
            c[e >> 2] = 1
            if ((a | 0) == (b | 0)) {
              d = 1
            } else {
              f = 0
              while (1) {
                if ((f | 0) >= 3) {
                  break
                }
                e = c[d + (a * 52 | 0) + 4 + (f << 4) + 12 >> 2] | 0
                if (e) {
                  if (ZU((e - d | 0) / 52 | 0, b) | 0) {
                    d = 1
                    break a
                  }
                  d = c[46743] | 0
                }
                f = f + 1 | 0
              }
              c[d + (a * 52 | 0) >> 2] = 0
              d = 0
            }
          } else {
            d = 0
          }
        } while (0)
        return d | 0
      }

      function _U(a) {
        a = a | 0
        var b = 0, d = 0, e = 0, f = 0
        f = l
        l = l + 32 | 0
        e = f + 16 | 0
        d = f
        if ((c[46744] | 0) < (a | 0)) {
          b = c[46742] | 0
          if (!b) {
            e = B_(a << 4) | 0
            c[46742] = e
            if (!e) {
              e = c[15686] | 0
              c[d >> 2] = 138776
              c[d + 4 >> 2] = 593
              c[d + 8 >> 2] = 138884
              f1(e, 138757, d) | 0
              bb(186776, 1)
            }
          } else {
            d = E_(b, a << 4) | 0
            c[46742] = d
            if (!d) {
              d = c[15686] | 0
              c[e >> 2] = 138776
              c[e + 4 >> 2] = 599
              c[e + 8 >> 2] = 138902
              f1(d, 138757, e) | 0
              bb(186776, 1)
            }
          }
          c[46744] = a
        }
        l = f
        return
      }

      function $U(a, b) {
        a = a | 0
        b = b | 0
        var d = 0, e = 0, f = 0
        d = c[46738] | 0
        e = c[46737] | 0
        f = (d | 0) >= (e | 0)
        if ((a | 0) == 1) {
          if (f) {
            c[b + 4 >> 2] = c[(c[46735] | 0) + (e << 2) >> 2]
            a = 186948
            d = -1
          } else {
            a = 186948
            d = -1
          }
        } else if (f) {
          c[b + 4 >> 2] = c[(c[46735] | 0) + (d << 2) >> 2]
          a = 186952
          d = 1
        } else {
          a = 186952
          d = 1
        }
        f = (c[a >> 2] | 0) + d | 0
        c[a >> 2] = f
        c[(c[46735] | 0) + (f << 2) >> 2] = b
        return
      }

      function aV(a) {
        a = a | 0
        var b = 0, d = 0, e = 0, f = 0, g = 0
        f = c[46739] | 0
        g = c[46735] | 0
        b = c[46737] | 0
        while (1) {
          if ((b | 0) >= (f | 0)) {
            e = 4
            break
          }
          d = b + 1 | 0
          if ((VU(c[c[g + (d << 2) >> 2] >> 2] | 0, c[c[g + (b << 2) >> 2] >> 2] | 0, c[a >> 2] | 0) | 0)
              == 1) {
            break
          } else {
            b = d
          }
        }
        a:do {
          if ((e | 0) == 4) {
            b = c[46738] | 0
            while (1) {
              if ((b | 0) <= (f | 0)) {
                b = f
                break a
              }
              d = b + -1 | 0
              if ((VU(c[c[g + (d << 2) >> 2] >> 2] | 0, c[c[g + (b << 2) >> 2] >> 2] | 0, c[a >> 2] | 0) | 0)
                  == 2) {
                break
              } else {
                b = d
              }
            }
          }
        } while (0)
        return b | 0
      }

      function bV(a, b) {
        a = a | 0
        b = b | 0
        c[((a | 0) == 1 ? 186952 : 186948) >> 2] = b
        return
      }

      function cV(a, b, d, e) {
        a = a | 0
        b = b | 0
        d = d | 0
        e = e | 0
        var f = 0, g = 0, h = 0, i = 0, j = 0, k = 0
        f = c[c[d + (((a + -1 + e | 0) % (e | 0) | 0) << 2) >> 2] >> 2] | 0
        i = c[c[d + (a << 2) >> 2] >> 2] | 0
        g = c[c[d + (((a + 1 | 0) % (e | 0) | 0) << 2) >> 2] >> 2] | 0
        k = (VU(f, i, g) | 0) == 1
        j = c[c[d + (b << 2) >> 2] >> 2] | 0
        if (k) {
          if ((VU(i, j, f) | 0) == 1) {
            f = VU(j, i, g) | 0
            g = 1
            h = 5
          } else {
            f = 0
          }
        } else {
          f = VU(i, j, g) | 0
          g = 2
          h = 5
        }
        a:do {
          if ((h | 0) == 5) {
            if ((f | 0) == (g | 0)) {
              f = 0
              while (1) {
                if ((f | 0) >= (e | 0)) {
                  f = 1
                  break a
                }
                g = f
                f = f + 1 | 0
                h = (f | 0) % (e | 0) | 0
                if ((h | 0) == (b | 0) | ((g | 0) == (b | 0) | ((g | 0) == (a | 0) | (h | 0) == (a | 0)))) {
                  continue
                }
                if (fV(i, j, c[c[d + (g << 2) >> 2] >> 2] | 0, c[c[d + (h << 2) >> 2] >> 2] | 0) | 0) {
                  f = 0
                  break
                }
              }
            } else {
              f = 0
            }
          }
        } while (0)
        return f | 0
      }

      function dV(a, b, d) {
        a = a | 0
        b = b | 0
        d = d | 0
        var e = 0, f = 0, g = 0, h = 0
        e = c[46734] | 0
        f = c[46745] | 0
        if ((e | 0) < (f | 0)) {
          h = e
        } else {
          eV(f + 20 | 0)
          h = c[46734] | 0
        }
        g = c[46743] | 0
        c[46734] = h + 1
        f = g + (h * 52 | 0) | 0
        c[f >> 2] = 0
        c[g + (h * 52 | 0) + 4 >> 2] = a
        c[g + (h * 52 | 0) + 8 >> 2] = b
        c[g + (h * 52 | 0) + 16 >> 2] = 0
        c[g + (h * 52 | 0) + 20 >> 2] = b
        c[g + (h * 52 | 0) + 24 >> 2] = d
        c[g + (h * 52 | 0) + 32 >> 2] = 0
        c[g + (h * 52 | 0) + 36 >> 2] = d
        c[g + (h * 52 | 0) + 40 >> 2] = a
        c[g + (h * 52 | 0) + 48 >> 2] = 0
        e = 0
        while (1) {
          if ((e | 0) == 3) {
            break
          }
          c[g + (h * 52 | 0) + 4 + (e << 4) + 8 >> 2] = f
          e = e + 1 | 0
        }
        return
      }

      function eV(a) {
        a = a | 0
        var b = 0, d = 0, e = 0, f = 0
        f = l
        l = l + 32 | 0
        e = f + 16 | 0
        d = f
        if ((c[46745] | 0) < (a | 0)) {
          b = c[46743] | 0
          if (!b) {
            e = B_(a * 52 | 0) | 0
            c[46743] = e
            if (!e) {
              e = c[15686] | 0
              c[d >> 2] = 138776
              c[d + 4 >> 2] = 552
              c[d + 8 >> 2] = 138942
              f1(e, 138757, d) | 0
              bb(186776, 1)
            }
          } else {
            d = E_(b, a * 52 | 0) | 0
            c[46743] = d
            if (!d) {
              d = c[15686] | 0
              c[e >> 2] = 138776
              c[e + 4 >> 2] = 558
              c[e + 8 >> 2] = 138961
              f1(d, 138757, e) | 0
              bb(186776, 1)
            }
          }
          c[46745] = a
        }
        l = f
        return
      }

      function fV(a, b, c, d) {
        a = a | 0
        b = b | 0
        c = c | 0
        d = d | 0
        var e = 0, f = 0, g = 0, h = 0
        f = VU(a, b, c) | 0
        if ((((f | 0) != 3 ? (g = VU(a, b, d) | 0, (g | 0) != 3) : 0) ? (h = VU(c, d, a) | 0, (h | 0) != 3) : 0)
            ? (e = VU(c, d, b) | 0, (e | 0) != 3) : 0) {
          return ((f | 0) == 1 ^ (g | 0) == 1) & ((h | 0) == 1 ^ (e | 0)
              == 1) & 1 | 0
        }
        if (((gV(a, b, c) | 0) == 0 ? (gV(a, b, d) | 0) == 0 : 0) ? (gV(c, d, a) | 0) == 0 : 0) {
          return (gV(c, d, b) | 0)
              != 0 | 0
        }
        return 1
      }

      function gV(a, b, c) {
        a = a | 0
        b = b | 0
        c = c | 0
        var d = 0.0, e = 0.0, f = 0.0, g = 0.0
        e = +h[a >> 3]
        g = +h[b >> 3] - e
        f = +h[a + 8 >> 3]
        d = +h[b + 8 >> 3] - f
        e = +h[c >> 3] - e
        f = +h[c + 8 >> 3] - f
        if ((VU(a, b, c) | 0) == 3 ? f * d + e * g >= 0.0 : 0) {
          a = f * f + e * e <= d * d + g * g & 1
        } else {
          a = 0
        }
        return a | 0
      }

      function hV(a, b, d, e) {
        a = a | 0
        b = b | 0
        d = d | 0
        e = e | 0
        var f = 0, g = 0.0, i = 0, j = 0.0, k = 0, l = 0, m = 0, n = 0, o = 0, p = 0.0, q = 0
        m = B_(d << 2) | 0
        n = B_((d << 3) + 8 | 0) | 0
        o = n + 8 | 0
        f = 0
        while (1) {
          if ((f | 0) >= (d | 0)) {
            break
          }
          c[m + (f << 2) >> 2] = -1
          h[o + (f << 3) >> 3] = -2147483647.0
          f = f + 1 | 0
        }
        h[n >> 3] = -2147483648.0
        a:while (1) {
          if ((a | 0) == (b | 0)) {
            break
          }
          l = o + (a << 3) | 0
          j = +h[l >> 3]
          h[l >> 3] = j == -2147483647.0 ? 0.0 : -j
          k = 0
          f = -1
          while (1) {
            if ((k | 0) >= (d | 0)) {
              a = f
              continue a
            }
            i = o + (k << 3) | 0
            g = +h[i >> 3]
            if (g < 0.0) {
              q = (a | 0) < (k | 0)
              p = +h[(c[e + ((q ? k : a) << 2) >> 2] | 0) + ((q ? a : k) << 3) >> 3]
              j = -(p + +h[l >> 3])
              if (p != 0.0 & g < j) {
                h[i >> 3] = j
                c[m + (k << 2) >> 2] = a
                g = j
              }
              f = g > +h[o + (f << 3) >> 3] ? k : f
            }
            k = k + 1 | 0
          }
        }
        C_(n)
        return m | 0
      }

      function iV(a, b, d, e, f, g, h) {
        a = a | 0
        b = b | 0
        d = d | 0
        e = e | 0
        f = f | 0
        g = g | 0
        h = h | 0
        var i = 0, j = 0, k = 0, m = 0
        j = l
        l = l + 32 | 0
        k = j + 16 | 0
        m = j
        i = c[h + 4 >> 2] | 0
        c[m >> 2] = c[a >> 2]
        c[m + 4 >> 2] = c[a + 4 >> 2]
        c[m + 8 >> 2] = c[a + 8 >> 2]
        c[m + 12 >> 2] = c[a + 12 >> 2]
        c[k >> 2] = c[e >> 2]
        c[k + 4 >> 2] = c[e + 4 >> 2]
        c[k + 8 >> 2] = c[e + 8 >> 2]
        c[k + 12 >> 2] = c[e + 12 >> 2]
        if (!(BV(m, b, k, f, h) | 0)) {
          a = c[h + 24 >> 2] | 0
          c[a + (i << 2) >> 2] = g
          m = i + 1 | 0
          c[a + (m << 2) >> 2] = d
          a = hV(m, i, i + 2 | 0, a) | 0
        } else {
          a = B_((i << 2) + 8 | 0) | 0
          m = i + 1 | 0
          c[a + (i << 2) >> 2] = m
          c[a + (m << 2) >> 2] = -1
        }
        l = j
        return a | 0
      }

      function jV(a, b) {
        a = a | 0
        b = b | 0
        var c = 0, d = 0.0, e = 0.0, f = 0.0, g = 0.0, i = 0.0, j = 0
        d = +h[a + 24 >> 3]
        a:do {
          if (d < 1.0e-07 & d > -1.0e-07) {
            a = kV(a, b) | 0
          } else {
            g = +h[a + 16 >> 3] / (d * 3.0)
            f = +h[a + 8 >> 3] / d
            e = g * g
            d = g * 2.0 * e - g * f + +h[a >> 3] / d
            e = f * .3333333333333333 - e
            e = e * e * 4.0 * e
            f = d * d + e
            if (!(f < 0.0)) {
              i = (+C(+f) - d) * .5
              e = +m$(i)
              d = +m$(-d - i) + e
              h[b >> 3] = d
              if (f > 0.0) {
                a = 1
              } else {
                d = d * -.5
                h[b + 16 >> 3] = d
                a = 1
                c = 7
              }
            } else {
              i = +K(+(+C(+-f)), +-d)
              d = +m$(+C(+-e) * .5) * 2.0
              h[b >> 3] = d * +E(+(i * .3333333333333333))
              h[b + 8 >> 3] = +E(+((i + 6.283185307179586) * .3333333333333333)) * d
              d = +E(+((i + -6.283185307179586) * .3333333333333333)) * d
              a = 2
              c = 7
            }
            if ((c | 0) == 7) {
              h[b + (a << 3) >> 3] = d
              a = 3
            }
            c = 0
            while (1) {
              if ((c | 0) >= (a | 0)) {
                break a
              }
              j = b + (c << 3) | 0
              h[j >> 3] = +h[j >> 3] - g
              c = c + 1 | 0
            }
          }
        } while (0)
        return a | 0
      }

      function kV(a, b) {
        a = a | 0
        b = b | 0
        var c = 0.0, d = 0.0
        c = +h[a + 16 >> 3]
        do {
          if (!(c < 1.0e-07 & c > -1.0e-07)) {
            d = +h[a + 8 >> 3] / (c * 2.0)
            c = d * d - +h[a >> 3] / c
            if (!(c < 0.0)) {
              if (c == 0.0) {
                h[b >> 3] = -d
                a = 1
                break
              } else {
                c = +C(+c) - d
                h[b >> 3] = c
                h[b + 8 >> 3] = d * -2.0 - c
                a = 2
                break
              }
            } else {
              a = 0
            }
          } else {
            a = lV(a, b) | 0
          }
        } while (0)
        return a | 0
      }

      function lV(a, b) {
        a = a | 0
        b = b | 0
        var c = 0.0, d = 0.0
        d = +h[a + 8 >> 3]
        c = +h[a >> 3]
        if (d < 1.0e-07 & d > -1.0e-07) {
          a = c < 1.0e-07 & c > -1.0e-07 ? 4 : 0
        } else {
          h[b >> 3] = -c / d
          a = 1
        }
        return a | 0
      }

      function mV(a) {
        a = a | 0
        C_(c[a >> 2] | 0)
        C_(a)
        return
      }

      function nV(a, b) {
        a = a | 0
        b = b | 0
        var d = 0, e = 0, f = 0, g = 0, h = 0, i = 0, j = 0, k = 0, l = 0, m = 0
        e = c[a + 4 >> 2] | 0
        i = (e * 3 | 0) + -2 | 0
        d = c[46748] | 0
        if ((i | 0) > (c[46747] | 0)) {
          if (!d) {
            d = B_(i << 4) | 0
          } else {
            d = E_(d, i << 4) | 0
          }
          c[46748] = d
          c[46747] = i
          h = d
          g = d
        } else {
          h = d
          g = d
        }
        f = c[a >> 2] | 0
        c[h >> 2] = c[f >> 2]
        c[h + 4 >> 2] = c[f + 4 >> 2]
        c[h + 8 >> 2] = c[f + 8 >> 2]
        c[h + 12 >> 2] = c[f + 12 >> 2]
        F3(h + 16 | 0, f | 0, 16) | 0
        e = e + -1 | 0
        d = 1
        a = 2
        while (1) {
          if ((d | 0) >= (e | 0)) {
            break
          }
          j = h + (a + 2 << 4) | 0
          k = h + (a + 1 << 4) | 0
          m = h + (a << 4) | 0
          l = f + (d << 4) | 0
          c[m >> 2] = c[l >> 2]
          c[m + 4 >> 2] = c[l + 4 >> 2]
          c[m + 8 >> 2] = c[l + 8 >> 2]
          c[m + 12 >> 2] = c[l + 12 >> 2]
          F3(k | 0, l | 0, 16) | 0
          c[j >> 2] = c[k >> 2]
          c[j + 4 >> 2] = c[k + 4 >> 2]
          c[j + 8 >> 2] = c[k + 8 >> 2]
          c[j + 12 >> 2] = c[k + 12 >> 2]
          d = d + 1 | 0
          a = a + 3 | 0
        }
        l = h + (a << 4) | 0
        m = f + (d << 4) | 0
        c[l >> 2] = c[m >> 2]
        c[l + 4 >> 2] = c[m + 4 >> 2]
        c[l + 8 >> 2] = c[m + 8 >> 2]
        c[l + 12 >> 2] = c[m + 12 >> 2]
        F3(h + (a + 1 << 4) | 0, m | 0, 16) | 0
        c[b + 4 >> 2] = i
        c[b >> 2] = g
        return
      }

      function oV(a, b, c) {
        a = a | 0
        b = b | 0
        c = c | 0
        var d = 0.0, e = 0.0
        d = +h[b + 8 >> 3]
        e = +h[b >> 3]
        d = (+h[c >> 3] - e) * (+h[a + 8 >> 3] - d) - (+h[a >> 3] - e) * (+h[c + 8 >> 3] - d)
        return (d > .0001 ? 1 : (d < -.0001) << 31 >> 31) | 0
      }

      function pV(a, b, c) {
        a = a | 0
        b = b | 0
        c = c | 0
        var d = 0.0, e = 0.0, f = 0.0
        e = +h[a >> 3]
        f = +h[b >> 3]
        if (e != f) {
          d = +h[c >> 3]
          if (!(e < d & d < f)) {
            if (f < d) {
              a = d < e
            } else {
              a = 0
            }
          } else {
            a = 1
          }
        } else {
          f = +h[a + 8 >> 3]
          e = +h[c + 8 >> 3]
          d = +h[b + 8 >> 3]
          if (!(f < e & e < d)) {
            if (d < e) {
              a = e < f
            } else {
              a = 0
            }
          } else {
            a = 1
          }
        }
        return a & 1 | 0
      }

      function qV(a, b, d, e) {
        a = a | 0
        b = b | 0
        d = d | 0
        e = e | 0
        var f = 0, g = 0, h = 0, i = 0, j = 0, k = 0, m = 0
        m = l
        l = l + 48 | 0
        i = m + 32 | 0
        h = m + 16 | 0
        g = m
        c[g >> 2] = c[a >> 2]
        c[g + 4 >> 2] = c[a + 4 >> 2]
        c[g + 8 >> 2] = c[a + 8 >> 2]
        c[g + 12 >> 2] = c[a + 12 >> 2]
        c[h >> 2] = c[b >> 2]
        c[h + 4 >> 2] = c[b + 4 >> 2]
        c[h + 8 >> 2] = c[b + 8 >> 2]
        c[h + 12 >> 2] = c[b + 12 >> 2]
        c[i >> 2] = c[d >> 2]
        c[i + 4 >> 2] = c[d + 4 >> 2]
        c[i + 8 >> 2] = c[d + 8 >> 2]
        c[i + 12 >> 2] = c[d + 12 >> 2]
        j = oV(g, h, i) | 0
        if ((j | 0) == 0 ? (c[g >> 2] = c[a >> 2], c[g + 4 >> 2] = c[a + 4 >> 2], c[g + 8 >> 2] = c[a + 8 >> 2], c[g
        + 12 >> 2] = c[a + 12 >> 2], c[h >> 2] = c[b >> 2], c[h + 4 >> 2] = c[b + 4 >> 2], c[h + 8 >> 2] = c[b + 8
        >> 2], c[h + 12 >> 2] = c[b + 12 >> 2], c[i >> 2] = c[d >> 2], c[i + 4 >> 2] = c[d + 4 >> 2], c[i + 8
        >> 2] = c[d + 8 >> 2], c[i + 12 >> 2] = c[d + 12 >> 2], (pV(g, h, i) | 0) != 0) : 0) {
          f = 1
        } else {
          k = 3
        }
        do {
          if ((k | 0) == 3) {
            c[g >> 2] = c[a >> 2]
            c[g + 4 >> 2] = c[a + 4 >> 2]
            c[g + 8 >> 2] = c[a + 8 >> 2]
            c[g + 12 >> 2] = c[a + 12 >> 2]
            c[h >> 2] = c[b >> 2]
            c[h + 4 >> 2] = c[b + 4 >> 2]
            c[h + 8 >> 2] = c[b + 8 >> 2]
            c[h + 12 >> 2] = c[b + 12 >> 2]
            c[i >> 2] = c[e >> 2]
            c[i + 4 >> 2] = c[e + 4 >> 2]
            c[i + 8 >> 2] = c[e + 8 >> 2]
            c[i + 12 >> 2] = c[e + 12 >> 2]
            f = oV(g, h, i) | 0
            if ((f | 0) == 0 ? (c[g >> 2] = c[a >> 2], c[g + 4 >> 2] = c[a + 4 >> 2], c[g + 8 >> 2] = c[a + 8 >> 2], c[g
            + 12 >> 2] = c[a + 12 >> 2], c[h >> 2] = c[b >> 2], c[h + 4 >> 2] = c[b + 4 >> 2], c[h + 8 >> 2] = c[b + 8
            >> 2], c[h + 12 >> 2] = c[b + 12 >> 2], c[i >> 2] = c[e >> 2], c[i + 4 >> 2] = c[e + 4 >> 2], c[i + 8
            >> 2] = c[e + 8 >> 2], c[i + 12 >> 2] = c[e + 12 >> 2], pV(g, h, i) | 0) : 0) {
              f = 1
              break
            }
            c[g >> 2] = c[d >> 2]
            c[g + 4 >> 2] = c[d + 4 >> 2]
            c[g + 8 >> 2] = c[d + 8 >> 2]
            c[g + 12 >> 2] = c[d + 12 >> 2]
            c[h >> 2] = c[e >> 2]
            c[h + 4 >> 2] = c[e + 4 >> 2]
            c[h + 8 >> 2] = c[e + 8 >> 2]
            c[h + 12 >> 2] = c[e + 12 >> 2]
            c[i >> 2] = c[a >> 2]
            c[i + 4 >> 2] = c[a + 4 >> 2]
            c[i + 8 >> 2] = c[a + 8 >> 2]
            c[i + 12 >> 2] = c[a + 12 >> 2]
            a = oV(g, h, i) | 0
            c[g >> 2] = c[d >> 2]
            c[g + 4 >> 2] = c[d + 4 >> 2]
            c[g + 8 >> 2] = c[d + 8 >> 2]
            c[g + 12 >> 2] = c[d + 12 >> 2]
            c[h >> 2] = c[e >> 2]
            c[h + 4 >> 2] = c[e + 4 >> 2]
            c[h + 8 >> 2] = c[e + 8 >> 2]
            c[h + 12 >> 2] = c[e + 12 >> 2]
            c[i >> 2] = c[b >> 2]
            c[i + 4 >> 2] = c[b + 4 >> 2]
            c[i + 8 >> 2] = c[b + 8 >> 2]
            c[i + 12 >> 2] = c[b + 12 >> 2]
            k = (O(f, j) | 0) < 0
            f = (O(oV(g, h, i) | 0, a) | 0) >>> 31
            f = k ? f : 0
          }
        } while (0)
        l = m
        return f | 0
      }

      function rV(a, b) {
        a = a | 0
        b = b | 0
        var c = 0.0, d = 0.0
        c = +h[a >> 3] - +h[b >> 3]
        d = +h[a + 8 >> 3] - +h[b + 8 >> 3]
        return +(d * d + c * c)
      }

      function sV(a) {
        a = a | 0
        c[a + 24 >> 2] = tV(c[a + 4 >> 2] | 0) | 0
        uV(a)
        return
      }

      function tV(a) {
        a = a | 0
        var b = 0, d = 0, e = 0, f = 0
        e = a + 2 | 0
        f = B_(e << 2) | 0
        b = D_(O(a, a) | 0, 8) | 0
        d = 0
        while (1) {
          if ((d | 0) >= (a | 0)) {
            break
          }
          c[f + (d << 2) >> 2] = b
          b = b + (a << 3) | 0
          d = d + 1 | 0
        }
        while (1) {
          if ((a | 0) >= (e | 0)) {
            break
          }
          c[f + (a << 2) >> 2] = 0
          a = a + 1 | 0
        }
        return f | 0
      }

      function uV(a) {
        a = a | 0
        var b = 0, d = 0, e = 0, f = 0, g = 0, i = 0, j = 0, k = 0, m = 0, n = 0, o = 0, p = 0, q = 0, r = 0.0
        p = l
        l = l + 32 | 0
        i = p + 16 | 0
        g = p
        j = c[a + 4 >> 2] | 0
        m = c[a + 8 >> 2] | 0
        n = c[a + 16 >> 2] | 0
        o = c[a + 20 >> 2] | 0
        d = c[a + 24 >> 2] | 0
        b = 0
        while (1) {
          if ((b | 0) >= (j | 0)) {
            break
          }
          q = c[o + (b << 2) >> 2] | 0
          e = m + (b << 4) | 0
          f = m + (q << 4) | 0
          c[g >> 2] = c[e >> 2]
          c[g + 4 >> 2] = c[e + 4 >> 2]
          c[g + 8 >> 2] = c[e + 8 >> 2]
          c[g + 12 >> 2] = c[e + 12 >> 2]
          c[i >> 2] = c[f >> 2]
          c[i + 4 >> 2] = c[f + 4 >> 2]
          c[i + 8 >> 2] = c[f + 8 >> 2]
          c[i + 12 >> 2] = c[f + 12 >> 2]
          r = +vV(g, i)
          f = c[d + (b << 2) >> 2] | 0
          h[f + (q << 3) >> 3] = r
          h[(c[d + (q << 2) >> 2] | 0) + (b << 3) >> 3] = r
          a = b + -1 | 0
          a = (q | 0) == (a | 0) ? b + -2 | 0 : a
          while (1) {
            if ((a | 0) <= -1) {
              break
            }
            if ((wV(b, a, m, n, o) | 0 ? wV(a, b, m, n, o) | 0 : 0) ? (k = m + (a << 4) | 0, c[g >> 2] = c[e >> 2], c[g
            + 4 >> 2] = c[e + 4 >> 2], c[g + 8 >> 2] = c[e + 8 >> 2], c[g + 12 >> 2] = c[e + 12 >> 2], c[i >> 2] = c[k
            >> 2], c[i + 4 >> 2] = c[k + 4 >> 2], c[i + 8 >> 2] = c[k + 8 >> 2], c[i + 12 >> 2] = c[k + 12 >> 2], xV(g,
                i, j, j, j, m, n) | 0) : 0) {
              c[g >> 2] = c[e >> 2]
              c[g + 4 >> 2] = c[e + 4 >> 2]
              c[g + 8 >> 2] = c[e + 8 >> 2]
              c[g + 12 >> 2] = c[e + 12 >> 2]
              c[i >> 2] = c[k >> 2]
              c[i + 4 >> 2] = c[k + 4 >> 2]
              c[i + 8 >> 2] = c[k + 8 >> 2]
              c[i + 12 >> 2] = c[k + 12 >> 2]
              r = +vV(g, i)
              h[f + (a << 3) >> 3] = r
              h[(c[d + (a << 2) >> 2] | 0) + (b << 3) >> 3] = r
            }
            a = a + -1 | 0
          }
          b = b + 1 | 0
        }
        l = p
        return
      }

      function vV(a, b) {
        a = a | 0
        b = b | 0
        var d = 0.0, e = 0, f = 0, g = 0
        e = l
        l = l + 32 | 0
        f = e + 16 | 0
        g = e
        c[g >> 2] = c[a >> 2]
        c[g + 4 >> 2] = c[a + 4 >> 2]
        c[g + 8 >> 2] = c[a + 8 >> 2]
        c[g + 12 >> 2] = c[a + 12 >> 2]
        c[f >> 2] = c[b >> 2]
        c[f + 4 >> 2] = c[b + 4 >> 2]
        c[f + 8 >> 2] = c[b + 8 >> 2]
        c[f + 12 >> 2] = c[b + 12 >> 2]
        d = +C(+(+rV(g, f)))
        l = e
        return +d
      }

      function wV(a, b, d, e, f) {
        a = a | 0
        b = b | 0
        d = d | 0
        e = e | 0
        f = f | 0
        var g = 0, h = 0, i = 0, j = 0, k = 0, m = 0, n = 0
        g = l
        l = l + 64 | 0
        h = g + 48 | 0
        i = g + 32 | 0
        j = g + 16 | 0
        k = g
        n = d + (c[f + (a << 2) >> 2] << 4) | 0
        m = d + (a << 4) | 0
        e = d + (c[e + (a << 2) >> 2] << 4) | 0
        f = d + (b << 4) | 0
        c[k >> 2] = c[n >> 2]
        c[k + 4 >> 2] = c[n + 4 >> 2]
        c[k + 8 >> 2] = c[n + 8 >> 2]
        c[k + 12 >> 2] = c[n + 12 >> 2]
        c[j >> 2] = c[m >> 2]
        c[j + 4 >> 2] = c[m + 4 >> 2]
        c[j + 8 >> 2] = c[m + 8 >> 2]
        c[j + 12 >> 2] = c[m + 12 >> 2]
        c[i >> 2] = c[e >> 2]
        c[i + 4 >> 2] = c[e + 4 >> 2]
        c[i + 8 >> 2] = c[e + 8 >> 2]
        c[i + 12 >> 2] = c[e + 12 >> 2]
        c[h >> 2] = c[f >> 2]
        c[h + 4 >> 2] = c[f + 4 >> 2]
        c[h + 8 >> 2] = c[f + 8 >> 2]
        c[h + 12 >> 2] = c[f + 12 >> 2]
        f = yV(k, j, i, h) | 0
        l = g
        return f | 0
      }

      function xV(a, b, d, e, f, g, h) {
        a = a | 0
        b = b | 0
        d = d | 0
        e = e | 0
        f = f | 0
        g = g | 0
        h = h | 0
        var i = 0, j = 0, k = 0, m = 0, n = 0, o = 0, p = 0, q = 0, r = 0
        p = l
        l = l + 64 | 0
        n = p + 48 | 0
        m = p + 32 | 0
        k = p + 16 | 0
        j = p
        i = 0
        while (1) {
          if ((i | 0) >= (d | 0)) {
            o = 4
            break
          }
          r = g + (i << 4) | 0
          q = g + (c[h + (i << 2) >> 2] << 4) | 0
          c[j >> 2] = c[a >> 2]
          c[j + 4 >> 2] = c[a + 4 >> 2]
          c[j + 8 >> 2] = c[a + 8 >> 2]
          c[j + 12 >> 2] = c[a + 12 >> 2]
          c[k >> 2] = c[b >> 2]
          c[k + 4 >> 2] = c[b + 4 >> 2]
          c[k + 8 >> 2] = c[b + 8 >> 2]
          c[k + 12 >> 2] = c[b + 12 >> 2]
          c[m >> 2] = c[r >> 2]
          c[m + 4 >> 2] = c[r + 4 >> 2]
          c[m + 8 >> 2] = c[r + 8 >> 2]
          c[m + 12 >> 2] = c[r + 12 >> 2]
          c[n >> 2] = c[q >> 2]
          c[n + 4 >> 2] = c[q + 4 >> 2]
          c[n + 8 >> 2] = c[q + 8 >> 2]
          c[n + 12 >> 2] = c[q + 12 >> 2]
          if (!(qV(j, k, m, n) | 0)) {
            i = i + 1 | 0
          } else {
            e = 0
            break
          }
        }
        a:do {
          if ((o | 0) == 4) {
            while (1) {
              if ((e | 0) >= (f | 0)) {
                e = 1
                break a
              }
              q = g + (e << 4) | 0
              r = g + (c[h + (e << 2) >> 2] << 4) | 0
              c[j >> 2] = c[a >> 2]
              c[j + 4 >> 2] = c[a + 4 >> 2]
              c[j + 8 >> 2] = c[a + 8 >> 2]
              c[j + 12 >> 2] = c[a + 12 >> 2]
              c[k >> 2] = c[b >> 2]
              c[k + 4 >> 2] = c[b + 4 >> 2]
              c[k + 8 >> 2] = c[b + 8 >> 2]
              c[k + 12 >> 2] = c[b + 12 >> 2]
              c[m >> 2] = c[q >> 2]
              c[m + 4 >> 2] = c[q + 4 >> 2]
              c[m + 8 >> 2] = c[q + 8 >> 2]
              c[m + 12 >> 2] = c[q + 12 >> 2]
              c[n >> 2] = c[r >> 2]
              c[n + 4 >> 2] = c[r + 4 >> 2]
              c[n + 8 >> 2] = c[r + 8 >> 2]
              c[n + 12 >> 2] = c[r + 12 >> 2]
              if (!(qV(j, k, m, n) | 0)) {
                e = e + 1 | 0
                o = 4
              } else {
                e = 0
                break
              }
            }
          }
        } while (0)
        l = p
        return e | 0
      }

      function yV(a, b, d, e) {
        a = a | 0
        b = b | 0
        d = d | 0
        e = e | 0
        var f = 0, g = 0, h = 0, i = 0, j = 0
        g = l
        l = l + 48 | 0
        h = g + 32 | 0
        i = g + 16 | 0
        j = g
        c[j >> 2] = c[e >> 2]
        c[j + 4 >> 2] = c[e + 4 >> 2]
        c[j + 8 >> 2] = c[e + 8 >> 2]
        c[j + 12 >> 2] = c[e + 12 >> 2]
        c[i >> 2] = c[a >> 2]
        c[i + 4 >> 2] = c[a + 4 >> 2]
        c[i + 8 >> 2] = c[a + 8 >> 2]
        c[i + 12 >> 2] = c[a + 12 >> 2]
        c[h >> 2] = c[b >> 2]
        c[h + 4 >> 2] = c[b + 4 >> 2]
        c[h + 8 >> 2] = c[b + 8 >> 2]
        c[h + 12 >> 2] = c[b + 12 >> 2]
        f = oV(j, i, h) | 0
        c[j >> 2] = c[e >> 2]
        c[j + 4 >> 2] = c[e + 4 >> 2]
        c[j + 8 >> 2] = c[e + 8 >> 2]
        c[j + 12 >> 2] = c[e + 12 >> 2]
        c[i >> 2] = c[b >> 2]
        c[i + 4 >> 2] = c[b + 4 >> 2]
        c[i + 8 >> 2] = c[b + 8 >> 2]
        c[i + 12 >> 2] = c[b + 12 >> 2]
        c[h >> 2] = c[d >> 2]
        c[h + 4 >> 2] = c[d + 4 >> 2]
        c[h + 8 >> 2] = c[d + 8 >> 2]
        c[h + 12 >> 2] = c[d + 12 >> 2]
        e = oV(j, i, h) | 0
        c[j >> 2] = c[a >> 2]
        c[j + 4 >> 2] = c[a + 4 >> 2]
        c[j + 8 >> 2] = c[a + 8 >> 2]
        c[j + 12 >> 2] = c[a + 12 >> 2]
        c[i >> 2] = c[b >> 2]
        c[i + 4 >> 2] = c[b + 4 >> 2]
        c[i + 8 >> 2] = c[b + 8 >> 2]
        c[i + 12 >> 2] = c[b + 12 >> 2]
        c[h >> 2] = c[d >> 2]
        c[h + 4 >> 2] = c[d + 4 >> 2]
        c[h + 8 >> 2] = c[d + 8 >> 2]
        c[h + 12 >> 2] = c[d + 12 >> 2]
        d = (oV(j, i, h) | 0) > 0
        l = g
        return (d ? e | f : e & f) >>> 31 ^ 1 | 0
      }

      function zV(a, b, d) {
        a = a | 0
        b = b | 0
        d = d | 0
        var e = 0.0, f = 0, g = 0, i = 0, j = 0, k = 0, m = 0, n = 0, o = 0, p = 0, q = 0, r = 0, s = 0, t = 0, u = 0
        s = l
        l = l + 80 | 0
        j = s + 64 | 0
        i = s + 48 | 0
        g = s + 32 | 0
        k = s + 16 | 0
        o = s
        p = c[a + 4 >> 2] | 0
        q = c[a + 8 >> 2] | 0
        r = c[a + 16 >> 2] | 0
        m = c[a + 20 >> 2] | 0
        n = B_((p << 3) + 16 | 0) | 0
        if ((b | 0) == -2222) {
          c[j >> 2] = c[d >> 2]
          c[j + 4 >> 2] = c[d + 4 >> 2]
          c[j + 8 >> 2] = c[d + 8 >> 2]
          c[j + 12 >> 2] = c[d + 12 >> 2]
          b = AV(a, j) | 0
        }
        if ((b | 0) > -1) {
          a = c[a + 12 >> 2] | 0
          f = c[a + (b + 1 << 2) >> 2] | 0
          a = c[a + (b << 2) >> 2] | 0
        } else {
          f = p
          a = p
        }
        b = 0
        while (1) {
          if ((b | 0) >= (a | 0)) {
            b = a
            break
          }
          u = q + (b << 4) | 0
          c[o >> 2] = c[u >> 2]
          c[o + 4 >> 2] = c[u + 4 >> 2]
          c[o + 8 >> 2] = c[u + 8 >> 2]
          c[o + 12 >> 2] = c[u + 12 >> 2]
          u = q + (c[m + (b << 2) >> 2] << 4) | 0
          t = q + (c[r + (b << 2) >> 2] << 4) | 0
          c[k >> 2] = c[u >> 2]
          c[k + 4 >> 2] = c[u + 4 >> 2]
          c[k + 8 >> 2] = c[u + 8 >> 2]
          c[k + 12 >> 2] = c[u + 12 >> 2]
          c[g >> 2] = c[o >> 2]
          c[g + 4 >> 2] = c[o + 4 >> 2]
          c[g + 8 >> 2] = c[o + 8 >> 2]
          c[g + 12 >> 2] = c[o + 12 >> 2]
          c[i >> 2] = c[t >> 2]
          c[i + 4 >> 2] = c[t + 4 >> 2]
          c[i + 8 >> 2] = c[t + 8 >> 2]
          c[i + 12 >> 2] = c[t + 12 >> 2]
          c[j >> 2] = c[d >> 2]
          c[j + 4 >> 2] = c[d + 4 >> 2]
          c[j + 8 >> 2] = c[d + 8 >> 2]
          c[j + 12 >> 2] = c[d + 12 >> 2]
          if ((yV(k, g, i, j) | 0) != 0 ? (c[i >> 2] = c[d >> 2], c[i + 4 >> 2] = c[d + 4 >> 2], c[i + 8 >> 2] = c[d + 8
          >> 2], c[i + 12 >> 2] = c[d + 12 >> 2], c[j >> 2] = c[o >> 2], c[j + 4 >> 2] = c[o + 4 >> 2], c[j + 8
          >> 2] = c[o + 8 >> 2], c[j + 12 >> 2] = c[o + 12 >> 2], (xV(i, j, a, f, p, q, r) | 0) != 0) : 0) {
            c[i >> 2] = c[d >> 2]
            c[i + 4 >> 2] = c[d + 4 >> 2]
            c[i + 8 >> 2] = c[d + 8 >> 2]
            c[i + 12 >> 2] = c[d + 12 >> 2]
            c[j >> 2] = c[o >> 2]
            c[j + 4 >> 2] = c[o + 4 >> 2]
            c[j + 8 >> 2] = c[o + 8 >> 2]
            c[j + 12 >> 2] = c[o + 12 >> 2]
            e = +vV(i, j)
          } else {
            e = 0.0
          }
          h[n + (b << 3) >> 3] = e
          b = b + 1 | 0
        }
        while (1) {
          if ((b | 0) >= (f | 0)) {
            b = f
            break
          }
          h[n + (b << 3) >> 3] = 0.0
          b = b + 1 | 0
        }
        while (1) {
          if ((b | 0) >= (p | 0)) {
            break
          }
          t = q + (b << 4) | 0
          c[o >> 2] = c[t >> 2]
          c[o + 4 >> 2] = c[t + 4 >> 2]
          c[o + 8 >> 2] = c[t + 8 >> 2]
          c[o + 12 >> 2] = c[t + 12 >> 2]
          t = q + (c[m + (b << 2) >> 2] << 4) | 0
          u = q + (c[r + (b << 2) >> 2] << 4) | 0
          c[k >> 2] = c[t >> 2]
          c[k + 4 >> 2] = c[t + 4 >> 2]
          c[k + 8 >> 2] = c[t + 8 >> 2]
          c[k + 12 >> 2] = c[t + 12 >> 2]
          c[g >> 2] = c[o >> 2]
          c[g + 4 >> 2] = c[o + 4 >> 2]
          c[g + 8 >> 2] = c[o + 8 >> 2]
          c[g + 12 >> 2] = c[o + 12 >> 2]
          c[i >> 2] = c[u >> 2]
          c[i + 4 >> 2] = c[u + 4 >> 2]
          c[i + 8 >> 2] = c[u + 8 >> 2]
          c[i + 12 >> 2] = c[u + 12 >> 2]
          c[j >> 2] = c[d >> 2]
          c[j + 4 >> 2] = c[d + 4 >> 2]
          c[j + 8 >> 2] = c[d + 8 >> 2]
          c[j + 12 >> 2] = c[d + 12 >> 2]
          if ((yV(k, g, i, j) | 0) != 0 ? (c[i >> 2] = c[d >> 2], c[i + 4 >> 2] = c[d + 4 >> 2], c[i + 8 >> 2] = c[d + 8
          >> 2], c[i + 12 >> 2] = c[d + 12 >> 2], c[j >> 2] = c[o >> 2], c[j + 4 >> 2] = c[o + 4 >> 2], c[j + 8
          >> 2] = c[o + 8 >> 2], c[j + 12 >> 2] = c[o + 12 >> 2], (xV(i, j, a, f, p, q, r) | 0) != 0) : 0) {
            c[i >> 2] = c[d >> 2]
            c[i + 4 >> 2] = c[d + 4 >> 2]
            c[i + 8 >> 2] = c[d + 8 >> 2]
            c[i + 12 >> 2] = c[d + 12 >> 2]
            c[j >> 2] = c[o >> 2]
            c[j + 4 >> 2] = c[o + 4 >> 2]
            c[j + 8 >> 2] = c[o + 8 >> 2]
            c[j + 12 >> 2] = c[o + 12 >> 2]
            e = +vV(i, j)
          } else {
            e = 0.0
          }
          h[n + (b << 3) >> 3] = e
          b = b + 1 | 0
        }
        h[n + (p << 3) >> 3] = 0.0
        h[n + (p + 1 << 3) >> 3] = 0.0
        l = s
        return n | 0
      }

      function AV(a, b) {
        a = a | 0
        b = b | 0
        var d = 0, e = 0, f = 0, g = 0, h = 0, i = 0, j = 0, k = 0, m = 0, n = 0, o = 0
        m = l
        l = l + 32 | 0
        f = m + 8 | 0
        e = m
        h = m + 24 | 0
        i = a + 8 | 0
        j = a + 12 | 0
        k = h + 4 | 0
        d = 0
        while (1) {
          if ((d | 0) >= (c[a >> 2] | 0)) {
            d = -1111
            break
          }
          o = c[j >> 2] | 0
          n = c[o + (d << 2) >> 2] | 0
          c[h >> 2] = (c[i >> 2] | 0) + (n << 4)
          g = d + 1 | 0
          c[k >> 2] = (c[o + (g << 2) >> 2] | 0) - n
          c[e >> 2] = c[h >> 2]
          c[e + 4 >> 2] = c[h + 4 >> 2]
          c[f >> 2] = c[b >> 2]
          c[f + 4 >> 2] = c[b + 4 >> 2]
          c[f + 8 >> 2] = c[b + 8 >> 2]
          c[f + 12 >> 2] = c[b + 12 >> 2]
          if (!(vU(e, f) | 0)) {
            d = g
          } else {
            break
          }
        }
        l = m
        return d | 0
      }

      function BV(a, b, d, e, f) {
        a = a | 0
        b = b | 0
        d = d | 0
        e = e | 0
        f = f | 0
        var g = 0, h = 0, i = 0, j = 0, k = 0, m = 0, n = 0, o = 0, p = 0, q = 0, r = 0, s = 0, t = 0
        t = l
        l = l + 64 | 0
        n = t + 48 | 0
        m = t + 32 | 0
        p = t + 16 | 0
        o = t
        r = c[f + 4 >> 2] | 0
        s = c[f + 8 >> 2] | 0
        q = c[f + 16 >> 2] | 0
        g = (e | 0) < 0
        do {
          if ((b | 0) < 0) {
            if (g) {
              g = 0
              i = 0
              f = 0
              h = 0
            } else {
              b = c[f + 12 >> 2] | 0
              f = 0
              h = 0
              i = e
              j = b
              b = b + (e << 2) | 0
              k = 9
            }
          } else {
            if (g) {
              k = c[f + 12 >> 2] | 0
              f = 0
              h = 0
              i = b
              j = k
              b = k + (b << 2) | 0
              k = 9
              break
            }
            g = c[f + 12 >> 2] | 0
            if ((b | 0) > (e | 0)) {
              f = c[g + (e + 1 << 2) >> 2] | 0
              h = c[g + (e << 2) >> 2] | 0
              i = b
              j = g
              b = g + (b << 2) | 0
              k = 9
              break
            } else {
              f = c[g + (b + 1 << 2) >> 2] | 0
              h = c[g + (b << 2) >> 2] | 0
              i = e
              j = g
              b = g + (e << 2) | 0
              k = 9
              break
            }
          }
        } while (0)
        if ((k | 0) == 9) {
          g = c[j + (i + 1 << 2) >> 2] | 0
          i = c[b >> 2] | 0
        }
        b = 0
        while (1) {
          if ((b | 0) >= (h | 0)) {
            k = 13
            break
          }
          j = s + (b << 4) | 0
          e = s + (c[q + (b << 2) >> 2] << 4) | 0
          c[o >> 2] = c[a >> 2]
          c[o + 4 >> 2] = c[a + 4 >> 2]
          c[o + 8 >> 2] = c[a + 8 >> 2]
          c[o + 12 >> 2] = c[a + 12 >> 2]
          c[p >> 2] = c[d >> 2]
          c[p + 4 >> 2] = c[d + 4 >> 2]
          c[p + 8 >> 2] = c[d + 8 >> 2]
          c[p + 12 >> 2] = c[d + 12 >> 2]
          c[m >> 2] = c[j >> 2]
          c[m + 4 >> 2] = c[j + 4 >> 2]
          c[m + 8 >> 2] = c[j + 8 >> 2]
          c[m + 12 >> 2] = c[j + 12 >> 2]
          c[n >> 2] = c[e >> 2]
          c[n + 4 >> 2] = c[e + 4 >> 2]
          c[n + 8 >> 2] = c[e + 8 >> 2]
          c[n + 12 >> 2] = c[e + 12 >> 2]
          if (!(qV(o, p, m, n) | 0)) {
            b = b + 1 | 0
          } else {
            g = 0
            break
          }
        }
        a:do {
          if ((k | 0) == 13) {
            while (1) {
              if ((f | 0) >= (i | 0)) {
                break
              }
              e = s + (f << 4) | 0
              k = s + (c[q + (f << 2) >> 2] << 4) | 0
              c[o >> 2] = c[a >> 2]
              c[o + 4 >> 2] = c[a + 4 >> 2]
              c[o + 8 >> 2] = c[a + 8 >> 2]
              c[o + 12 >> 2] = c[a + 12 >> 2]
              c[p >> 2] = c[d >> 2]
              c[p + 4 >> 2] = c[d + 4 >> 2]
              c[p + 8 >> 2] = c[d + 8 >> 2]
              c[p + 12 >> 2] = c[d + 12 >> 2]
              c[m >> 2] = c[e >> 2]
              c[m + 4 >> 2] = c[e + 4 >> 2]
              c[m + 8 >> 2] = c[e + 8 >> 2]
              c[m + 12 >> 2] = c[e + 12 >> 2]
              c[n >> 2] = c[k >> 2]
              c[n + 4 >> 2] = c[k + 4 >> 2]
              c[n + 8 >> 2] = c[k + 8 >> 2]
              c[n + 12 >> 2] = c[k + 12 >> 2]
              if (!(qV(o, p, m, n) | 0)) {
                f = f + 1 | 0
                k = 13
              } else {
                g = 0
                break a
              }
            }
            while (1) {
              if ((g | 0) >= (r | 0)) {
                g = 1
                break a
              }
              e = s + (g << 4) | 0
              k = s + (c[q + (g << 2) >> 2] << 4) | 0
              c[o >> 2] = c[a >> 2]
              c[o + 4 >> 2] = c[a + 4 >> 2]
              c[o + 8 >> 2] = c[a + 8 >> 2]
              c[o + 12 >> 2] = c[a + 12 >> 2]
              c[p >> 2] = c[d >> 2]
              c[p + 4 >> 2] = c[d + 4 >> 2]
              c[p + 8 >> 2] = c[d + 8 >> 2]
              c[p + 12 >> 2] = c[d + 12 >> 2]
              c[m >> 2] = c[e >> 2]
              c[m + 4 >> 2] = c[e + 4 >> 2]
              c[m + 8 >> 2] = c[e + 8 >> 2]
              c[m + 12 >> 2] = c[e + 12 >> 2]
              c[n >> 2] = c[k >> 2]
              c[n + 4 >> 2] = c[k + 4 >> 2]
              c[n + 8 >> 2] = c[k + 8 >> 2]
              c[n + 12 >> 2] = c[k + 12 >> 2]
              if (!(qV(o, p, m, n) | 0)) {
                g = g + 1 | 0
              } else {
                g = 0
                break
              }
            }
          }
        } while (0)
        l = t
        return g | 0
      }

      function CV(a) {
        a = a | 0
        return DV(a, 0, 0) | 0
      }

      function DV(a, b, c) {
        a = a | 0
        b = b | 0
        c = c | 0
        return EV(a, b, c, 0) | 0
      }

      function EV(b, d, e, f) {
        b = b | 0
        d = d | 0
        e = e | 0
        f = f | 0
        var g = 0, h = 0, i = 0, j = 0
        if (!d) {
          g = B_(496) | 0
          if (!g) {
            g = 0
          } else {
            c[g + 12 >> 2] = 35
            c[g + 16 >> 2] = 105
            c[g + 20 >> 2] = 103
            d = 35
            h = 6
          }
        } else {
          g = kb[c[d >> 2] & 63](496) | 0
          if (!g) {
            g = 0
          } else {
            h = c[d >> 2] | 0
            c[g + 12 >> 2] = h
            c[g + 16 >> 2] = c[d + 4 >> 2]
            c[g + 20 >> 2] = c[d + 8 >> 2]
            d = h
            h = 6
          }
        }
        do {
          if ((h | 0) == 6) {
            c[g + 8 >> 2] = 0
            c[g + 32 >> 2] = 0
            c[g + 376 >> 2] = 16
            j = g + 12 | 0
            i = kb[d & 63](256) | 0
            d = g + 388 | 0
            c[d >> 2] = i
            if (!i) {
              tb[c[g + 20 >> 2] & 127](g)
              g = 0
              break
            }
            h = kb[c[j >> 2] & 63](1024) | 0
            i = g + 44 | 0
            c[i >> 2] = h
            if (!h) {
              e = g + 20 | 0
              tb[c[e >> 2] & 127](c[d >> 2] | 0)
              tb[c[e >> 2] & 127](g)
              g = 0
              break
            }
            c[g + 48 >> 2] = h + 1024
            if (!f) {
              f = FV(j) | 0
              c[g + 352 >> 2] = f
              if (!f) {
                e = g + 20 | 0
                tb[c[e >> 2] & 127](c[i >> 2] | 0)
                tb[c[e >> 2] & 127](c[d >> 2] | 0)
                tb[c[e >> 2] & 127](g)
                g = 0
                break
              }
            } else {
              c[g + 352 >> 2] = f
            }
            c[g + 372 >> 2] = 0
            c[g + 364 >> 2] = 0
            c[g + 300 >> 2] = 0
            c[g + 464 >> 2] = 0
            c[g + 460 >> 2] = 0
            c[g + 124 >> 2] = 0
            c[g + 244 >> 2] = 0
            d = g + 468 | 0
            a[d >> 0] = 33
            h = g + 232 | 0
            a[h >> 0] = 0
            a[g + 233 >> 0] = 0
            c[g + 392 >> 2] = 0
            c[g + 396 >> 2] = 0
            a[g + 400 >> 0] = 0
            f = g + 228 | 0
            c[f >> 2] = 0
            GV(g + 412 | 0, j)
            GV(g + 436 | 0, j)
            HV(g, b)
            if (b | 0 ? (c[f >> 2] | 0) == 0 : 0) {
              IV(g)
              g = 0
              break
            }
            if (!e) {
              c[g + 224 >> 2] = SX() | 0
              break
            } else {
              a[h >> 0] = 1
              c[g + 224 >> 2] = wZ() | 0
              a[d >> 0] = a[e >> 0] | 0
              break
            }
          }
        } while (0)
        return g | 0
      }

      function FV(b) {
        b = b | 0
        var d = 0
        d = kb[c[b >> 2] & 63](188) | 0
        if (d | 0) {
          GV(d + 80 | 0, b)
          GV(d + 104 | 0, b)
          PW(d, b)
          PW(d + 20 | 0, b)
          PW(d + 40 | 0, b)
          PW(d + 60 | 0, b)
          a[d + 131 >> 0] = 0
          PW(d + 132 | 0, b)
          c[d + 152 >> 2] = 0
          c[d + 156 >> 2] = 0
          a[d + 160 >> 0] = 0
          b = d + 164 | 0
          c[b >> 2] = 0
          c[b + 4 >> 2] = 0
          c[b + 8 >> 2] = 0
          c[b + 12 >> 2] = 0
          c[b + 16 >> 2] = 0
          c[b + 20 >> 2] = 0
          a[d + 128 >> 0] = 1
          a[d + 129 >> 0] = 0
          a[d + 130 >> 0] = 0
        }
        return d | 0
      }

      function GV(a, b) {
        a = a | 0
        b = b | 0
        c[a >> 2] = 0
        c[a + 4 >> 2] = 0
        c[a + 8 >> 2] = 0
        c[a + 12 >> 2] = 0
        c[a + 16 >> 2] = 0
        c[a + 20 >> 2] = b
        return
      }

      function HV(d, e) {
        d = d | 0
        e = e | 0
        var f = 0, g = 0, h = 0
        c[d + 276 >> 2] = 56
        DZ(d + 252 | 0)
        if (e | 0) {
          c[d + 228 >> 2] = QV(e, d + 12 | 0) | 0
        }
        c[d + 356 >> 2] = 0
        GY(d + 148 | 0, d + 144 | 0, 0) | 0
        c[d >> 2] = 0
        c[d + 4 >> 2] = 0
        e = d + 116 | 0
        g = d + 52 | 0
        h = g + 64 | 0
        do {
          c[g >> 2] = 0
          g = g + 4 | 0
        } while ((g | 0) < (h | 0))
        c[e >> 2] = d
        c[d + 120 >> 2] = 0
        e = d + 128 | 0
        c[e >> 2] = 0
        c[e + 4 >> 2] = 0
        c[e + 8 >> 2] = 0
        c[e + 12 >> 2] = 0
        e = c[d + 8 >> 2] | 0
        c[d + 24 >> 2] = e
        c[d + 28 >> 2] = e
        c[d + 36 >> 2] = 0
        c[d + 40 >> 2] = 0
        e = d + 312 | 0
        g = d + 404 | 0
        c[g >> 2] = 0
        c[g + 4 >> 2] = 0
        g = d + 280 | 0
        f = d + 304 | 0
        c[g >> 2] = 0
        c[g + 4 >> 2] = 0
        c[g + 8 >> 2] = 0
        c[g + 12 >> 2] = 0
        c[g + 16 >> 2] = 0
        g = e
        h = g + 36 | 0
        do {
          c[g >> 2] = 0
          g = g + 4 | 0
        } while ((g | 0) < (h | 0))
        b[e + 36 >> 1] = 0
        a[f >> 0] = 1
        c[d + 308 >> 2] = 0
        c[d + 360 >> 2] = 0
        c[d + 368 >> 2] = 0
        c[d + 380 >> 2] = 0
        c[d + 236 >> 2] = 0
        c[d + 248 >> 2] = 0
        c[d + 240 >> 2] = 0
        c[d + 472 >> 2] = 0
        c[d + 476 >> 2] = 0
        a[d + 484 >> 0] = 0
        a[d + 485 >> 0] = 0
        c[d + 488 >> 2] = 0
        c[d + 492 >> 2] = 0
        return
      }

      function IV(b) {
        b = b | 0
        var d = 0, e = 0, f = 0, g = 0, h = 0
        if (b | 0) {
          e = b + 364 | 0
          g = b + 20 | 0
          d = c[b + 360 >> 2] | 0
          while (1) {
            if (!d) {
              d = c[e >> 2] | 0
              if (!d) {
                break
              }
              c[e >> 2] = 0
            }
            h = c[d >> 2] | 0
            tb[c[g >> 2] & 127](c[d + 36 >> 2] | 0)
            JV(c[d + 44 >> 2] | 0, b)
            tb[c[g >> 2] & 127](d)
            d = h
          }
          e = b + 300 | 0
          d = c[b + 296 >> 2] | 0
          while (1) {
            if (!d) {
              d = c[e >> 2] | 0
              if (!d) {
                break
              }
              c[e >> 2] = 0
            }
            h = c[d + 8 >> 2] | 0
            tb[c[g >> 2] & 127](d)
            d = h
          }
          JV(c[b + 372 >> 2] | 0, b)
          JV(c[b + 368 >> 2] | 0, b)
          KV(b + 412 | 0)
          KV(b + 436 | 0)
          d = b + 12 | 0
          tb[c[g >> 2] & 127](c[b + 228 >> 2] | 0)
          if ((a[b + 484 >> 0] | 0) == 0 ? (f = c[b + 352 >> 2] | 0, f | 0) : 0) {
            LV(f, (c[b + 472 >> 2] | 0) == 0 & 1,
                d)
          }
          tb[c[g >> 2] & 127](c[b + 388 >> 2] | 0)
          tb[c[g >> 2] & 127](c[b + 460 >> 2] | 0)
          tb[c[g >> 2] & 127](c[b + 8 >> 2] | 0)
          tb[c[g >> 2] & 127](c[b + 44 >> 2] | 0)
          tb[c[g >> 2] & 127](c[b + 392 >> 2] | 0)
          tb[c[g >> 2] & 127](c[b + 236 >> 2] | 0)
          d = c[b + 248 >> 2] | 0
          if (d | 0) {
            tb[d & 127](c[b + 240 >> 2] | 0)
          }
          tb[c[g >> 2] & 127](b)
        }
        return
      }

      function JV(a, b) {
        a = a | 0
        b = b | 0
        var d = 0
        b = b + 20 | 0
        while (1) {
          if (!a) {
            break
          }
          d = c[a + 4 >> 2] | 0
          tb[c[b >> 2] & 127](c[a + 16 >> 2] | 0)
          tb[c[b >> 2] & 127](a)
          a = d
        }
        return
      }

      function KV(a) {
        a = a | 0
        var b = 0, d = 0, e = 0
        d = a + 20 | 0
        b = c[a >> 2] | 0
        while (1) {
          if (!b) {
            break
          }
          e = c[b >> 2] | 0
          tb[c[(c[d >> 2] | 0) + 8 >> 2] & 127](b)
          b = e
        }
        b = c[a + 4 >> 2] | 0
        while (1) {
          if (!b) {
            break
          }
          e = c[b >> 2] | 0
          tb[c[(c[d >> 2] | 0) + 8 >> 2] & 127](b)
          b = e
        }
        return
      }

      function LV(a, b, d) {
        a = a | 0
        b = b | 0
        d = d | 0
        var e = 0, f = 0, g = 0, h = 0
        h = l
        l = l + 16 | 0
        f = h
        g = a + 20 | 0
        MV(f, g)
        d = d + 8 | 0
        while (1) {
          e = NV(f) | 0
          if (!e) {
            break
          }
          if (!(c[e + 16 >> 2] | 0)) {
            continue
          }
          tb[c[d >> 2] & 127](c[e + 20 >> 2] | 0)
        }
        OV(a)
        OV(a + 132 | 0)
        OV(g)
        OV(a + 40 | 0)
        OV(a + 60 | 0)
        KV(a + 80 | 0)
        KV(a + 104 | 0)
        if (b << 24 >> 24) {
          tb[c[d >> 2] & 127](c[a + 184 >> 2] | 0)
          tb[c[d >> 2] & 127](c[a + 164 >> 2] | 0)
        }
        tb[c[d >> 2] & 127](a)
        l = h
        return
      }

      function MV(a, b) {
        a = a | 0
        b = b | 0
        var d = 0
        d = c[b >> 2] | 0
        c[a >> 2] = d
        c[a + 4 >> 2] = d + (c[b + 8 >> 2] << 2)
        return
      }

      function NV(a) {
        a = a | 0
        var b = 0, d = 0, e = 0
        d = c[a + 4 >> 2] | 0
        e = c[a >> 2] | 0
        do {
          if ((e | 0) == (d | 0)) {
            b = 0
            break
          }
          b = e
          e = e + 4 | 0
          c[a >> 2] = e
          b = c[b >> 2] | 0
        } while (!(b | 0))
        return b | 0
      }

      function OV(a) {
        a = a | 0
        var b = 0, d = 0, e = 0, f = 0, g = 0
        d = a + 8 | 0
        e = a + 16 | 0
        b = 0
        while (1) {
          f = c[(c[e >> 2] | 0) + 8 >> 2] | 0
          g = c[a >> 2] | 0
          if (b >>> 0 >= (c[d >> 2] | 0) >>> 0) {
            break
          }
          tb[f & 127](c[g + (b << 2) >> 2] | 0)
          b = b + 1 | 0
        }
        tb[f & 127](g)
        return
      }

      function PV(a, b, d, e) {
        a = a | 0
        b = b | 0
        d = d | 0
        e = e | 0
        var f = 0
        f = RV(a) | 0
        if (!f) {
          c[a + 276 >> 2] = 57
          f = SV(a, b, d, e) | 0
        }
        return f | 0
      }

      function QV(b, d) {
        b = b | 0
        d = d | 0
        var e = 0, f = 0
        e = 0
        do {
          f = e
          e = e + 1 | 0
        } while ((a[b + f >> 0] | 0) != 0)
        d = kb[c[d >> 2] & 63](e) | 0
        if (!d) {
          d = 0
        } else {
          E3(d | 0, b | 0, e | 0) | 0
        }
        return d | 0
      }

      function RV(b) {
        b = b | 0
        var d = 0
        d = b + 228 | 0
        if (!(nb[(a[b + 232 >> 0] << 24 >> 24 ? 35 : 34) & 63](b + 148 | 0, b + 144 | 0, c[d >> 2] | 0) | 0)) {
          b = OW(b,
              c[d >> 2] | 0) | 0
        } else {
          b = 0
        }
        return b | 0
      }

      function SV(b, d, e, f) {
        b = b | 0
        d = d | 0
        e = e | 0
        f = f | 0
        var g = 0, h = 0, i = 0, j = 0
        g = l
        l = l + 16 | 0
        h = g
        c[h >> 2] = d
        j = b + 144 | 0
        i = c[j >> 2] | 0
        i = ob[c[i >> 2] & 127](i, d, e, h) | 0
        f = TV(b, c[j >> 2] | 0, d, e, i, c[h >> 2] | 0, f, (a[b + 480 >> 0] | 0) == 0 & 1) | 0
        l = g
        return f | 0
      }

      function TV(b, e, f, g, h, i, j, k) {
        b = b | 0
        e = e | 0
        f = f | 0
        g = g | 0
        h = h | 0
        i = i | 0
        j = j | 0
        k = k | 0
        var m = 0, n = 0, o = 0, p = 0, q = 0, r = 0, s = 0, t = 0, u = 0, v = 0, w = 0, x = 0, y = 0, z = 0, A = 0,
            B = 0, C = 0, D = 0, E = 0, F = 0, G = 0, H = 0, I = 0, J = 0, K = 0, L = 0, M = 0, N = 0, O = 0, P = 0,
            Q = 0, R = 0, S = 0, T = 0, U = 0, V = 0, W = 0, X = 0, Y = 0, Z = 0, _ = 0, $ = 0, aa = 0, ba = 0, ca = 0,
            da = 0, ea = 0, fa = 0, ga = 0, ha = 0, ia = 0, ja = 0, ka = 0, la = 0, ma = 0, na = 0, oa = 0, pa = 0,
            qa = 0, ra = 0, sa = 0, ta = 0, ua = 0, va = 0, wa = 0, xa = 0, ya = 0, za = 0, Aa = 0, Ba = 0, Ca = 0,
            Da = 0, Ea = 0, Fa = 0, Ga = 0
        Ga = l
        l = l + 16 | 0
        Da = Ga
        c[Da >> 2] = i
        r = c[b + 352 >> 2] | 0
        s = b + 144 | 0
        if ((c[s >> 2] | 0) == (e | 0)) {
          p = b + 284 | 0
          q = b + 288 | 0
          na = b + 296 | 0
        } else {
          na = b + 296 | 0
          q = c[na >> 2] | 0
          p = q
          q = q + 4 | 0
        }
        t = k << 24 >> 24 != 0
        pa = b + 252 | 0
        u = b + 80 | 0
        v = b + 476 | 0
        w = b + 84 | 0
        x = b + 320 | 0
        y = b + 412 | 0
        z = b + 316 | 0
        A = b + 424 | 0
        B = b + 428 | 0
        C = b + 324 | 0
        ra = b + 4 | 0
        D = b + 485 | 0
        E = r + 132 | 0
        F = b + 312 | 0
        ta = r + 129 | 0
        G = r + 128 | 0
        H = r + 80 | 0
        I = r + 92 | 0
        J = r + 96 | 0
        K = b + 136 | 0
        L = b + 88 | 0
        M = b + 488 | 0
        va = b + 112 | 0
        wa = r + 131 | 0
        xa = b + 116 | 0
        ya = r + 130 | 0
        za = b + 108 | 0
        Aa = b + 356 | 0
        N = b + 340 | 0
        O = b + 132 | 0
        P = b + 344 | 0
        Q = b + 348 | 0
        R = b + 328 | 0
        S = b + 349 | 0
        T = b + 420 | 0
        U = r + 120 | 0
        V = r + 116 | 0
        W = b + 92 | 0
        X = b + 472 | 0
        Y = b + 336 | 0
        Z = b + 332 | 0
        _ = b + 96 | 0
        $ = b + 256 | 0
        aa = b + 464 | 0
        ba = b + 460 | 0
        ca = r + 160 | 0
        da = r + 184 | 0
        ea = r + 180 | 0
        fa = r + 164 | 0
        ga = b + 128 | 0
        ha = b + 12 | 0
        ia = b + 16 | 0
        ja = b + 268 | 0
        ka = b + 120 | 0
        la = r + 176 | 0
        ma = r + 168 | 0
        o = e
        n = f
        e = h
        a:while (1) {
          c[p >> 2] = n
          f = c[Da >> 2] | 0
          c[q >> 2] = f
          i = f
          b:do {
            if ((e | 0) < 1) {
              if (t & (e | 0) != 0) {
                m = 7
                break a
              }
              switch (e | 0) {
                case -1: {
                  i = 5
                  m = 280
                  break a
                }
                case 0: {
                  m = 9
                  break a
                }
                case -2: {
                  i = 6
                  break a
                }
                case -4: {
                  m = 10
                  break a
                }
                case -15: {
                  e = 15
                  break b
                }
                default: {
                }
              }
              c[Da >> 2] = g
              e = 0 - e | 0
              i = g
            }
          } while (0)
          h = pb[c[pa >> 2] & 127](pa, e, n, i, o) | 0
          c:do {
            switch (h | 0) {
              case 2: {
                m = 58
                break a
              }
              case -1: {
                m = 184
                break a
              }
              case 1: {
                i = UV(b, 0, n, c[Da >> 2] | 0) | 0
                if (i | 0) {
                  m = 280
                  break a
                }
                i = c[s >> 2] | 0
                break
              }
              case 4: {
                if (!(c[w >> 2] | 0)) {
                  i = 1
                } else {
                  m = VV(y, o, n, c[Da >> 2] | 0) | 0
                  c[z >> 2] = m
                  if (!m) {
                    i = 1
                    m = 280
                    break a
                  }
                  c[B >> 2] = c[A >> 2]
                  c[C >> 2] = 0
                  i = 0
                }
                c[x >> 2] = 0
                m = 274
                break
              }
              case 7: {
                i = c[w >> 2] | 0
                if (!i) {
                  m = 275
                } else {
                  yb[i & 15](c[ra >> 2] | 0, c[z >> 2] | 0, c[x >> 2] | 0, c[C >> 2] | 0, 1)
                  c[z >> 2] = 0
                  WV(y)
                  i = o
                }
                break
              }
              case 57: {
                i = UV(b, 1, n, c[Da >> 2] | 0) | 0
                if (i | 0) {
                  m = 280
                  break a
                }
                i = c[s >> 2] | 0
                break
              }
              case 6: {
                a[D >> 0] = 0
                m = XV(b, E, 75291, 36) | 0
                c[F >> 2] = m
                if (!m) {
                  i = 1
                  m = 280
                  break a
                }
                a[ta >> 0] = 1
                if (!(c[w >> 2] | 0)) {
                  m = 33
                } else {
                  if (!(ob[c[o + 52 >> 2] & 127](o, n, c[Da >> 2] | 0, p) | 0)) {
                    i = 32
                    m = 280
                    break a
                  }
                  i = c[o + 64 >> 2] | 0
                  i = VV(y, o, n + i | 0, (c[Da >> 2] | 0) + (0 - i) | 0) | 0
                  if (!i) {
                    i = 1
                    m = 280
                    break a
                  }
                  YV(i)
                  c[B >> 2] = c[A >> 2]
                  c[C >> 2] = i
                  i = 0
                  m = 34
                }
                break
              }
              case 14: {
                m = 33
                break
              }
              case 8: {
                i = c[z >> 2] | 0
                if (!i) {
                  i = 1
                } else {
                  yb[c[w >> 2] & 15](c[ra >> 2] | 0, i, c[x >> 2] | 0, c[C >> 2] | 0, 0)
                  WV(y)
                  i = 0
                }
                if (!((c[x >> 2] | 0) == 0 ? !(a[D >> 0] | 0) : 0)) {
                  f = a[ta >> 0] | 0
                  a[ta >> 0] = 1
                  do {
                    if (c[M >> 2] | 0 ? c[va >> 2] | 0 : 0) {
                      h = XV(b, E, 75291, 36) | 0
                      if (!h) {
                        i = 1
                        m = 280
                        break a
                      }
                      if (!(a[D >> 0] | 0)) {
                        e = h + 20 | 0
                      } else {
                        e = h + 20 | 0
                        c[e >> 2] = c[Aa >> 2]
                      }
                      a[wa >> 0] = 0
                      if (!(pb[c[va >> 2] & 127](c[xa >> 2] | 0, 0, c[e >> 2] | 0, c[h + 16 >> 2] | 0,
                          c[h + 24 >> 2] | 0)
                          | 0)) {
                        i = 21
                        m = 280
                        break a
                      }
                      if (!(a[wa >> 0] | 0)) {
                        if (c[x >> 2] | 0) {
                          break
                        }
                        a[ta >> 0] = f
                        break
                      }
                      if (((a[ya >> 0] | 0) == 0 ? (oa = c[za >> 2] | 0, oa | 0) : 0) ? (kb[oa & 63](c[ra >> 2] | 0)
                          | 0)
                          == 0 : 0) {
                        i = 22
                        m = 280
                        break a
                      }
                    }
                  } while (0)
                  a[D >> 0] = 0
                }
                e = c[L >> 2] | 0
                if (!e) {
                  m = 274
                } else {
                  tb[e & 127](c[ra >> 2] | 0)
                  i = o
                }
                break
              }
              case 34: {
                m = _V(b, o, n, c[Da >> 2] | 0) | 0
                c[N >> 2] = m
                if (!m) {
                  i = 1
                  m = 280
                  break a
                } else {
                  m = 80
                }
                break
              }
              case 22: {
                m = $V(b, o, n, c[Da >> 2] | 0) | 0
                c[P >> 2] = m
                if (!m) {
                  i = 1
                  m = 280
                  break a
                }
                a[Q >> 0] = 0
                c[R >> 2] = 0
                a[S >> 0] = 0
                m = 80
                break
              }
              case 23: {
                a[Q >> 0] = 1
                c[R >> 2] = 139106
                m = 80
                break
              }
              case 24: {
                a[S >> 0] = 1
                c[R >> 2] = 139112
                m = 80
                break
              }
              case 25: {
                c[R >> 2] = 139115
                m = 80
                break
              }
              case 26: {
                c[R >> 2] = 139121
                m = 80
                break
              }
              case 27: {
                c[R >> 2] = 139128
                m = 80
                break
              }
              case 28: {
                c[R >> 2] = 139135
                m = 80
                break
              }
              case 29: {
                c[R >> 2] = 139144
                m = 80
                break
              }
              case 30: {
                c[R >> 2] = 139152
                m = 80
                break
              }
              case 32:
              case 31: {
                if ((a[G >> 0] | 0) != 0 ? (c[O >> 2] | 0) != 0 : 0) {
                  if (!(aW(y, (c[R >> 2] | 0) == 0 ? ((h | 0) == 32 ? 139161 : 139171) : 139173) | 0)) {
                    i = 1
                    m = 280
                    break a
                  }
                  if (!(bW(y, o, n, c[Da >> 2] | 0) | 0)) {
                    i = 1
                    m = 280
                    break a
                  }
                  c[R >> 2] = c[B >> 2]
                  i = o
                } else {
                  m = 275
                }
                break
              }
              case 36:
              case 35: {
                if (a[G >> 0] | 0) {
                  if (!(cW(c[N >> 2] | 0, c[P >> 2] | 0, a[Q >> 0] | 0, a[S >> 0] | 0, 0, b) | 0)) {
                    i = 1
                    m = 280
                    break a
                  }
                  if ((c[O >> 2] | 0) != 0 ? (qa = c[R >> 2] | 0, (qa | 0) != 0) : 0) {
                    switch (a[qa >> 0] | 0) {
                      case 40: {
                        m = 93
                        break
                      }
                      case 78: {
                        if ((a[qa + 1 >> 0] | 0) == 79) {
                          m = 93
                        }
                        break
                      }
                      default: {
                      }
                    }
                    if ((m | 0) == 93) {
                      m = 0
                      i = c[A >> 2] | 0
                      if ((i | 0) == (c[T >> 2] | 0)) {
                        if (!((dW(y) | 0) << 24 >> 24)) {
                          i = 1
                          m = 280
                          break a
                        }
                        i = c[A >> 2] | 0
                      }
                      c[A >> 2] = i + 1
                      a[i >> 0] = 41
                      i = c[A >> 2] | 0
                      if ((i | 0) == (c[T >> 2] | 0)) {
                        if (!((dW(y) | 0) << 24 >> 24)) {
                          i = 1
                          m = 280
                          break a
                        }
                        i = c[A >> 2] | 0
                      }
                      c[A >> 2] = i + 1
                      a[i >> 0] = 0
                      c[R >> 2] = c[B >> 2]
                      c[B >> 2] = c[A >> 2]
                    }
                    c[q >> 2] = n
                    zb[c[O >> 2] & 15](c[ra >> 2] | 0, c[c[N >> 2] >> 2] | 0, c[c[P >> 2] >> 2] | 0, c[R >> 2] | 0, 0,
                        (h | 0) == 36 & 1)
                    WV(y)
                    i = o
                  } else {
                    m = 275
                  }
                } else {
                  m = 275
                }
                break
              }
              case 38:
              case 37: {
                if (a[G >> 0] | 0) {
                  i = c[o + 64 >> 2] | 0
                  i = eW(b, o, a[Q >> 0] | 0, n + i | 0, (c[Da >> 2] | 0) + (0 - i) | 0, H) | 0
                  if (i | 0) {
                    m = 280
                    break a
                  }
                  e = c[J >> 2] | 0
                  c[J >> 2] = c[I >> 2]
                  if (!(cW(c[N >> 2] | 0, c[P >> 2] | 0, a[Q >> 0] | 0, 0, e, b) | 0)) {
                    i = 1
                    m = 280
                    break a
                  }
                  if ((c[O >> 2] | 0) != 0 ? (sa = c[R >> 2] | 0, (sa | 0) != 0) : 0) {
                    switch (a[sa >> 0] | 0) {
                      case 40: {
                        m = 108
                        break
                      }
                      case 78: {
                        if ((a[sa + 1 >> 0] | 0) == 79) {
                          m = 108
                        }
                        break
                      }
                      default: {
                      }
                    }
                    if ((m | 0) == 108) {
                      m = 0
                      i = c[A >> 2] | 0
                      if ((i | 0) == (c[T >> 2] | 0)) {
                        if (!((dW(y) | 0) << 24 >> 24)) {
                          i = 1
                          m = 280
                          break a
                        }
                        i = c[A >> 2] | 0
                      }
                      c[A >> 2] = i + 1
                      a[i >> 0] = 41
                      i = c[A >> 2] | 0
                      if ((i | 0) == (c[T >> 2] | 0)) {
                        if (!((dW(y) | 0) << 24 >> 24)) {
                          i = 1
                          m = 280
                          break a
                        }
                        i = c[A >> 2] | 0
                      }
                      c[A >> 2] = i + 1
                      a[i >> 0] = 0
                      c[R >> 2] = c[B >> 2]
                      c[B >> 2] = c[A >> 2]
                    }
                    c[q >> 2] = n
                    zb[c[O >> 2] & 15](c[ra >> 2] | 0, c[c[N >> 2] >> 2] | 0, c[c[P >> 2] >> 2] | 0, c[R >> 2] | 0, e,
                        (h | 0) == 38 & 1)
                    WV(y)
                    i = o
                  } else {
                    m = 275
                  }
                } else {
                  m = 275
                }
                break
              }
              case 12: {
                if (a[G >> 0] | 0) {
                  i = c[o + 64 >> 2] | 0
                  i = fW(b, o, n + i | 0, (c[Da >> 2] | 0) + (0 - i) | 0) | 0
                  e = c[F >> 2] | 0
                  f = c[U >> 2] | 0
                  if (e) {
                    c[e + 4 >> 2] = f
                    c[(c[F >> 2] | 0) + 8 >> 2] = (c[V >> 2] | 0) - (c[U >> 2] | 0)
                    c[U >> 2] = c[V >> 2]
                    if (!(c[K >> 2] | 0)) {
                      e = 1
                    } else {
                      c[q >> 2] = n
                      e = c[F >> 2] | 0
                      Ab[c[K >> 2] & 0](c[ra >> 2] | 0, c[e >> 2] | 0, d[e + 33 >> 0] | 0, c[e + 4 >> 2] | 0,
                          c[e + 8 >> 2] | 0, c[Aa >> 2] | 0, 0, 0, 0)
                      e = 0
                    }
                  } else {
                    c[V >> 2] = f
                    e = 1
                  }
                  if (!i) {
                    i = e
                    m = 274
                  } else {
                    m = 280
                    break a
                  }
                } else {
                  m = 275
                }
                break
              }
              case 5: {
                a[D >> 0] = 0
                a[ta >> 0] = 1
                if (!(c[w >> 2] | 0)) {
                  c[x >> 2] = 75291
                  i = 1
                } else {
                  m = c[o + 64 >> 2] | 0
                  m = VV(y, o, n + m | 0, (c[Da >> 2] | 0) + (0 - m) | 0) | 0
                  c[x >> 2] = m
                  if (!m) {
                    i = 1
                    m = 280
                    break a
                  }
                  c[B >> 2] = c[A >> 2]
                  i = 0
                }
                if ((((a[ya >> 0] | 0) == 0 ? (c[M >> 2] | 0) == 0 : 0) ? (ua = c[za >> 2] | 0, ua | 0) : 0) ? (kb[ua
                & 63](c[ra >> 2] | 0) | 0) == 0 : 0) {
                  i = 22
                  m = 280
                  break a
                }
                if (!(c[F >> 2] | 0)) {
                  e = XV(b, E, 75291, 36) | 0
                  c[F >> 2] = e
                  if (!e) {
                    i = 1
                    m = 280
                    break a
                  }
                  c[e + 24 >> 2] = 0
                  m = 133
                } else {
                  m = 133
                }
                break
              }
              case 13: {
                i = 1
                m = 133
                break
              }
              case 15: {
                if (((a[G >> 0] | 0) != 0 ? (c[F >> 2] | 0) != 0 : 0) ? (c[K >> 2] | 0) != 0 : 0) {
                  c[q >> 2] = n
                  i = c[F >> 2] | 0
                  Ab[c[K >> 2] & 0](c[ra >> 2] | 0, c[i >> 2] | 0, d[i + 33 >> 0] | 0, 0, 0, c[i + 20 >> 2] | 0,
                      c[i + 16 >> 2] | 0, c[i + 24 >> 2] | 0, 0)
                  i = o
                } else {
                  m = 275
                }
                break
              }
              case 16: {
                if ((a[G >> 0] | 0) != 0 ? (c[F >> 2] | 0) != 0 : 0) {
                  h = VV(H, o, n, c[Da >> 2] | 0) | 0
                  c[(c[F >> 2] | 0) + 28 >> 2] = h
                  if (!(c[(c[F >> 2] | 0) + 28 >> 2] | 0)) {
                    i = 1
                    m = 280
                    break a
                  }
                  c[J >> 2] = c[I >> 2]
                  if (c[W >> 2] | 0) {
                    c[q >> 2] = n
                    i = c[F >> 2] | 0
                    zb[c[W >> 2] & 15](c[ra >> 2] | 0, c[i >> 2] | 0, c[i + 20 >> 2] | 0, c[i + 16 >> 2] | 0,
                        c[i + 24 >> 2] | 0, c[i + 28 >> 2] | 0)
                    i = o
                    break c
                  }
                  if (c[K >> 2] | 0) {
                    c[q >> 2] = n
                    i = c[F >> 2] | 0
                    Ab[c[K >> 2] & 0](c[ra >> 2] | 0, c[i >> 2] | 0, 0, 0, 0, c[i + 20 >> 2] | 0, c[i + 16 >> 2] | 0,
                        c[i + 24 >> 2] | 0, c[i + 28 >> 2] | 0)
                    i = o
                  } else {
                    m = 275
                  }
                } else {
                  m = 275
                }
                break
              }
              case 9: {
                if (nb[c[o + 44 >> 2] & 63](o, n, c[Da >> 2] | 0) | 0) {
                  c[F >> 2] = 0
                  m = 275
                  break c
                }
                if (!(a[G >> 0] | 0)) {
                  c[I >> 2] = c[J >> 2]
                  c[F >> 2] = 0
                  m = 275
                  break c
                }
                i = VV(H, o, n, c[Da >> 2] | 0) | 0
                if (!i) {
                  i = 1
                  m = 280
                  break a
                }
                e = XV(b, r, i, 36) | 0
                c[F >> 2] = e
                if (!e) {
                  i = 1
                  m = 280
                  break a
                }
                if ((c[e >> 2] | 0) != (i | 0)) {
                  c[I >> 2] = c[J >> 2]
                  c[F >> 2] = 0
                  m = 275
                  break c
                }
                c[J >> 2] = c[I >> 2]
                c[(c[F >> 2] | 0) + 24 >> 2] = 0
                a[(c[F >> 2] | 0) + 33 >> 0] = 0
                if (!(c[X >> 2] | 0)) {
                  i = (c[na >> 2] | 0) != 0
                } else {
                  i = 1
                }
                a[(c[F >> 2] | 0) + 34 >> 0] = (i ^ 1) & 1
                if (!(c[K >> 2] | 0)) {
                  m = 275
                } else {
                  i = o
                }
                break
              }
              case 10: {
                if (!(a[G >> 0] | 0)) {
                  c[I >> 2] = c[J >> 2]
                  c[F >> 2] = 0
                  m = 275
                  break c
                }
                i = VV(H, o, n, c[Da >> 2] | 0) | 0
                if (!i) {
                  i = 1
                  m = 280
                  break a
                }
                e = XV(b, E, i, 36) | 0
                c[F >> 2] = e
                if (!e) {
                  i = 1
                  m = 280
                  break a
                }
                if ((c[e >> 2] | 0) != (i | 0)) {
                  c[I >> 2] = c[J >> 2]
                  c[F >> 2] = 0
                  m = 275
                  break c
                }
                c[J >> 2] = c[I >> 2]
                c[(c[F >> 2] | 0) + 24 >> 2] = 0
                a[(c[F >> 2] | 0) + 33 >> 0] = 1
                if (!(c[X >> 2] | 0)) {
                  i = (c[na >> 2] | 0) != 0
                } else {
                  i = 1
                }
                a[(c[F >> 2] | 0) + 34 >> 0] = (i ^ 1) & 1
                if (!(c[K >> 2] | 0)) {
                  m = 275
                } else {
                  i = o
                }
                break
              }
              case 18: {
                c[Y >> 2] = 0
                c[Z >> 2] = 0
                if (!(c[_ >> 2] | 0)) {
                  m = 275
                } else {
                  n = VV(y, o, n, c[Da >> 2] | 0) | 0
                  c[Z >> 2] = n
                  if (!n) {
                    i = 1
                    m = 280
                    break a
                  }
                  c[B >> 2] = c[A >> 2]
                  i = o
                }
                break
              }
              case 21: {
                if (!(ob[c[o + 52 >> 2] & 127](o, n, c[Da >> 2] | 0, p) | 0)) {
                  i = 32
                  m = 280
                  break a
                }
                if (!(c[Z >> 2] | 0)) {
                  m = 275
                } else {
                  i = c[o + 64 >> 2] | 0
                  i = VV(y, o, n + i | 0, (c[Da >> 2] | 0) + (0 - i) | 0) | 0
                  if (!i) {
                    i = 1
                    m = 280
                    break a
                  }
                  YV(i)
                  c[Y >> 2] = i
                  c[B >> 2] = c[A >> 2]
                  i = o
                }
                break
              }
              case 19: {
                if ((c[Z >> 2] | 0) != 0 ? (c[_ >> 2] | 0) != 0 : 0) {
                  i = c[o + 64 >> 2] | 0
                  i = VV(y, o, n + i | 0, (c[Da >> 2] | 0) + (0 - i) | 0) | 0
                  if (!i) {
                    i = 1
                    m = 280
                    break a
                  }
                  c[q >> 2] = n
                  yb[c[_ >> 2] & 15](c[ra >> 2] | 0, c[Z >> 2] | 0, c[Aa >> 2] | 0, i, c[Y >> 2] | 0)
                  i = 0
                } else {
                  i = 1
                }
                WV(y)
                m = 274
                break
              }
              case 20: {
                if ((c[Y >> 2] | 0) != 0 ? (c[_ >> 2] | 0) != 0 : 0) {
                  c[q >> 2] = n
                  yb[c[_ >> 2] & 15](c[ra >> 2] | 0, c[Z >> 2] | 0, c[Aa >> 2] | 0, 0, c[Y >> 2] | 0)
                  i = 0
                } else {
                  i = 1
                }
                WV(y)
                m = 274
                break
              }
              case 58: {
                if (c[u >> 2] | 0) {
                  gW(b, o, n, c[Da >> 2] | 0)
                }
                i = hW(b, o, Da, g, j, k) | 0
                if (i | 0) {
                  m = 280
                  break a
                }
                if (!(c[Da >> 2] | 0)) {
                  m = 189
                  break a
                } else {
                  i = o
                }
                break
              }
              case 44: {
                i = c[aa >> 2] | 0
                do {
                  if ((c[$ >> 2] | 0) >>> 0 >= i >>> 0) {
                    if (!i) {
                      h = c[ha >> 2] | 0
                      c[aa >> 2] = 32
                      h = kb[h & 63](32) | 0
                      c[ba >> 2] = h
                      if (!h) {
                        m = 198
                        break a
                      } else {
                        break
                      }
                    }
                    f = c[ia >> 2] | 0
                    h = c[ba >> 2] | 0
                    i = i << 1
                    c[aa >> 2] = i
                    i = lb[f & 127](h, i) | 0
                    if (!i) {
                      m = 193
                      break a
                    }
                    c[ba >> 2] = i
                    i = c[da >> 2] | 0
                    if (i | 0) {
                      i = lb[c[ia >> 2] & 127](i, c[aa >> 2] << 2) | 0
                      if (!i) {
                        i = 1
                        m = 280
                        break a
                      }
                      c[da >> 2] = i
                    }
                  }
                } while (0)
                a[(c[ba >> 2] | 0) + (c[$ >> 2] | 0) >> 0] = 0
                if (a[ca >> 0] | 0) {
                  i = jW(b) | 0
                  if ((i | 0) < 0) {
                    i = 1
                    m = 280
                    break a
                  }
                  c[(c[da >> 2] | 0) + (c[ea >> 2] << 2) >> 2] = i
                  c[ea >> 2] = (c[ea >> 2] | 0) + 1
                  c[(c[fa >> 2] | 0) + (i * 28 | 0) >> 2] = 6
                  if (c[ga >> 2] | 0) {
                    i = o
                  } else {
                    m = 275
                  }
                } else {
                  m = 275
                }
                break
              }
              case 50: {
                i = (c[ba >> 2] | 0) + (c[$ >> 2] | 0) | 0
                if ((a[i >> 0] | 0) == 124) {
                  i = 2
                  m = 280
                  break a
                }
                a[i >> 0] = 44
                if ((a[ca >> 0] | 0) != 0 ? (c[ga >> 2] | 0) != 0 : 0) {
                  i = o
                } else {
                  m = 275
                }
                break
              }
              case 49: {
                f = c[ba >> 2] | 0
                e = c[$ >> 2] | 0
                i = a[f + e >> 0] | 0
                if (i << 24 >> 24 == 44) {
                  i = 2
                  m = 280
                  break a
                }
                if (i << 24 >> 24 == 0 & (a[ca >> 0] | 0) != 0 ? (Ba = (c[fa >> 2] | 0) + ((c[(c[da >> 2] | 0) + ((c[ea
                >> 2] | 0) + -1 << 2) >> 2] | 0) * 28 | 0) | 0, (c[Ba >> 2] | 0) != 3) : 0) {
                  c[Ba >> 2] = 5
                  i = (c[ga >> 2] | 0) == 0 & 1
                  f = c[ba >> 2] | 0
                  e = c[$ >> 2] | 0
                } else {
                  i = 1
                }
                a[f + e >> 0] = 124
                m = 274
                break
              }
              case 59:
              case 60: {
                a[ta >> 0] = 1
                if (c[M >> 2] | 0) {
                  e = c[o + 64 >> 2] | 0
                  e = VV(H, o, n + e | 0, (c[Da >> 2] | 0) + (0 - e) | 0) | 0
                  if (!e) {
                    i = 1
                    m = 280
                    break a
                  }
                  f = XV(b, E, e, 0) | 0
                  c[I >> 2] = c[J >> 2]
                  do {
                    if (c[ja >> 2] | 0) {
                      if (!(a[ya >> 0] | 0)) {
                        if (a[ta >> 0] | 0) {
                          m = 219
                          break
                        }
                      } else if (c[na >> 2] | 0) {
                        m = 219
                        break
                      }
                      if (!f) {
                        i = 11
                        m = 280
                        break a
                      }
                      if (!(a[f + 34 >> 0] | 0)) {
                        i = 24
                        m = 280
                        break a
                      }
                    } else {
                      m = 219
                    }
                  } while (0)
                  if ((m | 0) == 219 ? (m = 0, (f | 0) == 0) : 0) {
                    a[G >> 0] = a[ya >> 0] | 0
                    if ((h | 0) != 60) {
                      m = 275
                      break c
                    }
                    i = c[ka >> 2] | 0
                    if (!i) {
                      m = 275
                      break c
                    }
                    vb[i & 127](c[ra >> 2] | 0, e, 1)
                    i = o
                    break c
                  }
                  i = f + 32 | 0
                  if (a[i >> 0] | 0) {
                    i = 12
                    m = 280
                    break a
                  }
                  if (c[f + 4 >> 2] | 0) {
                    i = kW(b, f, (h | 0) == 60 & 1) | 0
                    e = (i | 0) == 0
                    if (e) {
                      i = (e ^ 1) & 1
                      m = 274
                      break c
                    } else {
                      m = 280
                      break a
                    }
                  }
                  if (!(c[va >> 2] | 0)) {
                    a[G >> 0] = a[ya >> 0] | 0
                    m = 275
                    break c
                  }
                  a[wa >> 0] = 0
                  a[i >> 0] = 1
                  h = (pb[c[va >> 2] & 127](c[xa >> 2] | 0, 0, c[f + 20 >> 2] | 0, c[f + 16 >> 2] | 0,
                      c[f + 24 >> 2] | 0)
                      | 0) == 0
                  a[i >> 0] = 0
                  if (h) {
                    i = 21
                    m = 280
                    break a
                  }
                  e = a[ya >> 0] | 0
                  if (!(a[wa >> 0] | 0)) {
                    a[G >> 0] = e
                    i = o
                    break c
                  } else {
                    i = 0
                  }
                } else {
                  e = a[ya >> 0] | 0
                  a[G >> 0] = e
                  i = 1
                }
                if ((e << 24 >> 24 == 0 ? (Ca = c[za >> 2] | 0, (Ca | 0) != 0) : 0) ? (kb[Ca & 63](c[ra >> 2] | 0) | 0)
                    == 0 : 0) {
                  i = 22
                  m = 280
                  break a
                } else {
                  m = 274
                }
                break
              }
              case 40: {
                if (!(c[ga >> 2] | 0)) {
                  m = 275
                } else {
                  n = _V(b, o, n, c[Da >> 2] | 0) | 0
                  c[N >> 2] = n
                  if (!n) {
                    i = 1
                    m = 280
                    break a
                  }
                  c[ea >> 2] = 0
                  c[la >> 2] = 0
                  a[ca >> 0] = 1
                  i = o
                }
                break
              }
              case 42:
              case 41: {
                if (!(a[ca >> 0] | 0)) {
                  m = 275
                } else {
                  if (!(c[ga >> 2] | 0)) {
                    i = 1
                  } else {
                    i = kb[c[ha >> 2] & 63](20) | 0
                    if (!i) {
                      i = 1
                      m = 280
                      break a
                    }
                    m = i + 4 | 0
                    c[m >> 2] = 0
                    c[m + 4 >> 2] = 0
                    c[m + 8 >> 2] = 0
                    c[m + 12 >> 2] = 0
                    c[i >> 2] = (h | 0) == 41 ? 2 : 1
                    c[q >> 2] = n
                    vb[c[ga >> 2] & 127](c[ra >> 2] | 0, c[c[N >> 2] >> 2] | 0, i)
                    i = 0
                  }
                  a[ca >> 0] = 0
                  m = 274
                }
                break
              }
              case 43: {
                if ((a[ca >> 0] | 0) != 0 ? (c[(c[fa >> 2] | 0) + ((c[(c[da >> 2] | 0) + ((c[ea >> 2] | 0) + -1 << 2)
                >> 2] | 0) * 28 | 0) >> 2] = 3, (c[ga >> 2] | 0) != 0) : 0) {
                  i = o
                } else {
                  m = 275
                }
                break
              }
              case 51: {
                e = 0
                m = 247
                break
              }
              case 53: {
                e = 1
                m = 247
                break
              }
              case 52: {
                e = 2
                m = 247
                break
              }
              case 54: {
                e = 3
                m = 247
                break
              }
              case 45: {
                f = 0
                m = 258
                break
              }
              case 47: {
                f = 1
                m = 258
                break
              }
              case 46: {
                f = 2
                m = 258
                break
              }
              case 48: {
                f = 3
                m = 258
                break
              }
              case 55: {
                if (!(mW(b, o, n, c[Da >> 2] | 0) | 0)) {
                  i = 1
                  m = 280
                  break a
                } else {
                  i = o
                }
                break
              }
              case 56: {
                if (!(nW(b, o, n, c[Da >> 2] | 0) | 0)) {
                  i = 1
                  m = 280
                  break a
                } else {
                  i = o
                }
                break
              }
              case 0: {
                if ((e | 0) == 14) {
                  i = o
                } else {
                  m = 275
                }
                break
              }
              case 3: {
                if (!(c[w >> 2] | 0)) {
                  m = 275
                } else {
                  i = o
                }
                break
              }
              case 11: {
                if ((a[G >> 0] | 0) != 0 ? (c[K >> 2] | 0) != 0 : 0) {
                  i = o
                } else {
                  m = 275
                }
                break
              }
              case 17: {
                if (!(c[_ >> 2] | 0)) {
                  m = 275
                } else {
                  i = o
                }
                break
              }
              case 33: {
                if ((a[G >> 0] | 0) != 0 ? (c[O >> 2] | 0) != 0 : 0) {
                  i = o
                } else {
                  m = 275
                }
                break
              }
              case 39: {
                if (!(c[ga >> 2] | 0)) {
                  m = 275
                } else {
                  i = o
                }
                break
              }
              default:
                m = 275
            }
          } while (0)
          if ((m | 0) == 33) {
            if (!(ob[c[o + 52 >> 2] & 127](o, n, c[Da >> 2] | 0, p) | 0)) {
              i = 32
              m = 280
              break
            } else {
              i = 1
              m = 34
            }
          } else if ((m | 0) == 80) {
            m = 0
            if ((a[G >> 0] | 0) != 0 ? (c[O >> 2] | 0) != 0 : 0) {
              i = o
            } else {
              m = 275
            }
          } else if ((m | 0) == 133) {
            m = 0
            if ((a[G >> 0] | 0) != 0 ? (c[F >> 2] | 0) != 0 : 0) {
              e = c[o + 64 >> 2] | 0
              e = VV(H, o, n + e | 0, (c[Da >> 2] | 0) + (0 - e) | 0) | 0
              c[(c[F >> 2] | 0) + 16 >> 2] = e
              e = c[F >> 2] | 0
              if (!(c[e + 16 >> 2] | 0)) {
                i = 1
                m = 280
                break
              }
              c[e + 20 >> 2] = c[Aa >> 2]
              c[J >> 2] = c[I >> 2]
              if ((h | 0) == 13 & (c[K >> 2] | 0) != 0) {
                i = o
              } else {
                m = 274
              }
            } else {
              m = 274
            }
          } else if ((m | 0) == 247) {
            m = 0
            if (a[ca >> 0] | 0) {
              i = c[Da >> 2] | 0
              if (e) {
                i = i + (0 - (c[o + 64 >> 2] | 0)) | 0
              }
              f = jW(b) | 0
              if ((f | 0) < 0) {
                i = 1
                m = 280
                break
              }
              c[(c[fa >> 2] | 0) + (f * 28 | 0) >> 2] = 4
              c[(c[fa >> 2] | 0) + (f * 28 | 0) + 4 >> 2] = e
              i = _V(b, o, n, i) | 0
              if (!i) {
                i = 1
                m = 280
                break
              }
              e = c[i >> 2] | 0
              c[(c[fa >> 2] | 0) + (f * 28 | 0) + 8 >> 2] = e
              i = 0
              do {
                h = i
                i = i + 1 | 0
              } while ((a[e + h >> 0] | 0) != 0)
              c[ma >> 2] = (c[ma >> 2] | 0) + i
              if (c[ga >> 2] | 0) {
                i = o
              } else {
                m = 275
              }
            } else {
              m = 275
            }
          } else if ((m | 0) == 258) {
            if (a[ca >> 0] | 0) {
              e = (c[ga >> 2] | 0) == 0
              i = e & 1
              m = (c[ea >> 2] | 0) + -1 | 0
              c[ea >> 2] = m
              c[(c[fa >> 2] | 0) + ((c[(c[da >> 2] | 0) + (m << 2) >> 2] | 0) * 28 | 0) + 4 >> 2] = f
              if (!(c[ea >> 2] | 0)) {
                if (!e) {
                  e = lW(b) | 0
                  if (!e) {
                    i = 1
                    m = 280
                    break
                  }
                  c[q >> 2] = n
                  vb[c[ga >> 2] & 127](c[ra >> 2] | 0, c[c[N >> 2] >> 2] | 0, e)
                }
                a[ca >> 0] = 0
                c[ma >> 2] = 0
                m = 274
              } else {
                m = 274
              }
            } else {
              m = 275
            }
          }
          if ((m | 0) == 34) {
            m = 0
            if ((a[G >> 0] | 0) != 0 ? (c[F >> 2] | 0) != 0 : 0) {
              e = c[o + 64 >> 2] | 0
              e = VV(H, o, n + e | 0, (c[Da >> 2] | 0) + (0 - e) | 0) | 0
              if (!e) {
                i = 1
                m = 280
                break
              }
              YV(e)
              c[(c[F >> 2] | 0) + 24 >> 2] = e
              c[J >> 2] = c[I >> 2]
              if ((h | 0) == 14 & (c[K >> 2] | 0) != 0) {
                i = o
              } else {
                m = 274
              }
            } else {
              m = 274
            }
          }
          if ((m | 0) == 274) {
            m = 0
            if (!(i << 24 >> 24)) {
              i = o
            } else {
              m = 275
            }
          }
          if ((m | 0) == 275) {
            m = 0
            if (!(c[u >> 2] | 0)) {
              i = o
            } else {
              gW(b, o, n, c[Da >> 2] | 0)
              i = o
            }
          }
          switch (c[v >> 2] | 0) {
            case 3: {
              m = 278
              break a
            }
            case 2: {
              i = 35
              m = 280
              break a
            }
            default: {
            }
          }
          e = c[Da >> 2] | 0
          o = i
          n = e
          e = ob[c[i >> 2] & 127](i, e, g, Da) | 0
        }
        d:switch (m | 0) {
          case 7: {
            c[j >> 2] = n
            i = 0
            break
          }
          case 9: {
            c[p >> 2] = f
            i = 4
            break
          }
          case 10: {
            i = (o | 0) == (c[s >> 2] | 0)
            if (!i ? (a[(c[na >> 2] | 0) + 20 >> 0] | 0) == 0 : 0) {
              c[j >> 2] = n
              i = 0
              break
            }
            if ((a[b + 484 >> 0] | 0) != 0 | i ^ 1) {
              if ((pb[c[pa >> 2] & 127](pa, -4, g, g, o) | 0)
                  == -1) {
                i = 29
              } else {
                c[j >> 2] = n
                i = 0
              }
            } else {
              i = 3
            }
            break
          }
          case 58: {
            do {
              if ((a[D >> 0] | 0 ? (Ea = a[ta >> 0] | 0, a[ta >> 0] = 1, c[M >> 2] | 0) : 0) ? c[va >> 2] | 0 : 0) {
                i = XV(b, E, 75291, 36) | 0
                if (!i) {
                  i = 1
                  break d
                }
                Da = i + 20 | 0
                c[Da >> 2] = c[Aa >> 2]
                a[wa >> 0] = 0
                if (!(pb[c[va >> 2] & 127](c[xa >> 2] | 0, 0, c[Da >> 2] | 0, c[i + 16 >> 2] | 0, c[i + 24 >> 2] | 0)
                    | 0)) {
                  i = 21
                  break d
                }
                if (!(a[wa >> 0] | 0)) {
                  a[ta >> 0] = Ea
                  break
                }
                if (((a[ya >> 0] | 0) == 0 ? (Fa = c[za >> 2] | 0, Fa | 0) : 0) ? (kb[Fa & 63](c[ra >> 2] | 0) | 0) == 0
                    : 0) {
                  i = 22
                  break d
                }
              }
            } while (0)
            c[b + 276 >> 2] = 58
            i = ZV(b, n, g, j) | 0
            break
          }
          case 184: {
            i = (e | 0) == 28 ? 10 : (e | 0) == 12 ? 17 : 2
            break
          }
          case 189: {
            c[b + 276 >> 2] = 59
            i = 0
            break
          }
          case 193: {
            c[aa >> 2] = (c[aa >> 2] | 0) >>> 1
            i = 1
            break
          }
          case 198: {
            c[aa >> 2] = 0
            i = 1
            break
          }
          case 278: {
            c[j >> 2] = c[Da >> 2]
            i = 0
            break
          }
          case 280:
            break
        }
        l = Ga
        return i | 0
      }

      function UV(b, d, e, f) {
        b = b | 0
        d = d | 0
        e = e | 0
        f = f | 0
        var g = 0, h = 0, i = 0, j = 0, k = 0, m = 0, n = 0, o = 0, p = 0, q = 0
        q = l
        l = l + 32 | 0
        p = q + 16 | 0
        m = q + 12 | 0
        i = q + 8 | 0
        j = q + 4 | 0
        k = q
        c[p >> 2] = 0
        c[m >> 2] = 0
        c[i >> 2] = 0
        c[k >> 2] = -1
        n = b + 144 | 0
        o = b + 284 | 0
        g = (d | 0) != 0
        a:do {
          if (rb[(a[b + 232 >> 0] << 24 >> 24 ? 2 : 1) & 3](d, c[n >> 2] | 0, e, f, o, i, j, p, m, k) | 0) {
            if ((c[k >> 2] | 0) == 1 & (g ^ 1) ? (a[(c[b + 352 >> 2] | 0) + 130 >> 0] = 1, h = b + 488 | 0, (c[h >> 2]
                | 0) == 1) : 0) {
              c[h >> 2] = 0
            }
            h = b + 140 | 0
            if (!(c[h >> 2] | 0)) {
              if (!(c[b + 80 >> 2] | 0)) {
                e = 0
                d = 0
              } else {
                gW(b, c[n >> 2] | 0, e, f)
                e = 0
                d = 0
              }
            } else {
              d = c[p >> 2] | 0
              if (!d) {
                d = 0
              } else {
                f = c[n >> 2] | 0
                d = VV(b + 436 | 0, f, d, d + (lb[c[f + 28 >> 2] & 127](f, d) | 0) | 0) | 0
                if (!d) {
                  d = 1
                  break
                }
                c[b + 452 >> 2] = c[b + 448 >> 2]
              }
              g = c[i >> 2] | 0
              if (g) {
                i = c[n >> 2] | 0
                g = VV(b + 436 | 0, i, g, (c[j >> 2] | 0) + (0 - (c[i + 64 >> 2] | 0)) | 0) | 0
                if (!g) {
                  d = 1
                  break
                }
              } else {
                g = 0
              }
              xb[c[h >> 2] & 31](c[b + 4 >> 2] | 0, g, d, c[k >> 2] | 0)
              e = g
            }
            do {
              if (!(c[b + 228 >> 2] | 0)) {
                g = c[m >> 2] | 0
                h = g
                if (g | 0) {
                  k = c[g + 64 >> 2] | 0
                  m = c[n >> 2] | 0
                  if ((k | 0) == (c[m + 64 >> 2] | 0) ? (k | 0) != 2 | (g | 0) == (m | 0) : 0) {
                    c[n >> 2] = h
                    break
                  }
                  c[o >> 2] = c[p >> 2]
                  d = 19
                  break a
                }
                g = c[p >> 2] | 0
                if (g | 0) {
                  h = b + 436 | 0
                  if (!d) {
                    d = c[n >> 2] | 0
                    d = VV(h, d, g, g + (lb[c[d + 28 >> 2] & 127](d, g) | 0) | 0) | 0
                    if (!d) {
                      d = 1
                      break a
                    }
                  }
                  d = OW(b, d) | 0
                  WV(h)
                  if ((d | 0) != 18) {
                    break a
                  }
                  c[o >> 2] = c[p >> 2]
                  d = 18
                  break a
                }
              }
            } while (0)
            if ((d | 0) != 0 | (e | 0) != 0) {
              WV(b + 436 | 0)
              d = 0
            } else {
              d = 0
            }
          } else {
            d = g ? 31 : 30
          }
        } while (0)
        l = q
        return d | 0
      }

      function VV(b, d, e, f) {
        b = b | 0
        d = d | 0
        e = e | 0
        f = f | 0
        do {
          if (!(bW(b, d, e, f) | 0)) {
            d = 0
          } else {
            e = b + 12 | 0
            d = c[e >> 2] | 0
            if ((d | 0) == (c[b + 8 >> 2] | 0)) {
              if (!((dW(b) | 0) << 24 >> 24)) {
                d = 0
                break
              }
              d = c[e >> 2] | 0
            }
            c[e >> 2] = d + 1
            a[d >> 0] = 0
            d = c[b + 16 >> 2] | 0
          }
        } while (0)
        return d | 0
      }

      function WV(a) {
        a = a | 0
        var b = 0, d = 0, e = 0, f = 0, g = 0
        e = a + 4 | 0
        b = c[e >> 2] | 0
        a:do {
          if (!b) {
            c[e >> 2] = c[a >> 2]
            b = a
          } else {
            d = c[a >> 2] | 0
            while (1) {
              if (!d) {
                b = a
                break a
              }
              g = c[d >> 2] | 0
              c[d >> 2] = b
              c[e >> 2] = d
              f = d
              d = g
              b = f
            }
          }
        } while (0)
        c[b >> 2] = 0
        c[a + 16 >> 2] = 0
        c[a + 12 >> 2] = 0
        c[a + 8 >> 2] = 0
        return
      }

      function XV(b, e, f, g) {
        b = b | 0
        e = e | 0
        f = f | 0
        g = g | 0
        var h = 0, i = 0, j = 0, k = 0, l = 0, m = 0, n = 0, o = 0, p = 0, q = 0, r = 0, s = 0, t = 0, u = 0, v = 0,
            w = 0, x = 0
        w = e + 8 | 0
        a:do {
          if (!(c[w >> 2] | 0)) {
            if (g) {
              a[e + 4 >> 0] = 6
              c[w >> 2] = 64
              h = e + 16 | 0
              i = kb[c[c[h >> 2] >> 2] & 63](256) | 0
              c[e >> 2] = i
              if (!i) {
                c[w >> 2] = 0
                h = 0
                break
              } else {
                G3(i | 0, 0, 256) | 0
                j = MW(b, f) | 0
                j = (c[w >> 2] | 0) + -1 & j
                i = e
                o = 27
                break
              }
            } else {
              h = 0
            }
          } else {
            v = MW(b, f) | 0
            k = c[w >> 2] | 0
            j = k + -1 | 0
            l = c[e >> 2] | 0
            m = v & 0 - k
            u = e + 4 | 0
            n = j >>> 2
            i = 0
            j = j & v
            while (1) {
              h = c[l + (j << 2) >> 2] | 0
              if (!h) {
                break
              }
              if ((NW(f, c[h >> 2] | 0) | 0) << 24 >> 24) {
                break a
              }
              if (!(i << 24 >> 24)) {
                h = (m >>> ((d[u >> 0] | 0) + -1 | 0) & n | 1) & 255
              } else {
                h = i
              }
              t = h & 255
              i = h
              j = j - t + (j >>> 0 < t >>> 0 ? k : 0) | 0
            }
            if (g) {
              i = a[u >> 0] | 0
              h = i & 255
              if (!((c[e + 12 >> 2] | 0) >>> (h + -1 | 0))) {
                h = e + 16 | 0
                i = e
                o = 27
                break
              }
              q = h + 1 & 255
              j = i + 1 & 255
              s = 1 << j
              r = s + -1 | 0
              i = s << 2
              h = e + 16 | 0
              t = kb[c[c[h >> 2] >> 2] & 63](i) | 0
              if (t) {
                G3(t | 0, 0, i | 0) | 0
                p = 0 - s | 0
                n = j + -1 | 0
                o = r >>> 2
                m = 0
                while (1) {
                  if (m >>> 0 >= (c[w >> 2] | 0) >>> 0) {
                    break
                  }
                  i = c[(c[e >> 2] | 0) + (m << 2) >> 2] | 0
                  if (i | 0) {
                    i = MW(b, c[i >> 2] | 0) | 0
                    k = ((i & p) >>> n & o | 1) & 255
                    i = i & r
                    j = 0
                    while (1) {
                      l = t + (i << 2) | 0
                      if (!(c[l >> 2] | 0)) {
                        break
                      }
                      l = j << 24 >> 24 == 0 ? k : j
                      x = l & 255
                      i = i + (i >>> 0 < x >>> 0 ? s : 0) - x | 0
                      j = l
                    }
                    c[l >> 2] = c[(c[e >> 2] | 0) + (m << 2) >> 2]
                  }
                  m = m + 1 | 0
                }
                tb[c[(c[h >> 2] | 0) + 8 >> 2] & 127](c[e >> 2] | 0)
                c[e >> 2] = t
                a[u >> 0] = q
                c[w >> 2] = s
                k = ((v & p) >>> n & o | 1) & 255
                i = r & v
                j = 0
                while (1) {
                  if (!(c[t + (i << 2) >> 2] | 0)) {
                    j = i
                    i = e
                    o = 27
                    break a
                  }
                  x = j << 24 >> 24 == 0 ? k : j
                  w = x & 255
                  i = i + (i >>> 0 < w >>> 0 ? s : 0) - w | 0
                  j = x
                }
              } else {
                h = 0
              }
            } else {
              h = 0
            }
          }
        } while (0)
        if ((o | 0) == 27) {
          h = kb[c[c[h >> 2] >> 2] & 63](g) | 0
          c[(c[i >> 2] | 0) + (j << 2) >> 2] = h
          h = c[(c[i >> 2] | 0) + (j << 2) >> 2] | 0
          if (!h) {
            h = 0
          } else {
            G3(h | 0, 0, g | 0) | 0
            c[c[(c[i >> 2] | 0) + (j << 2) >> 2] >> 2] = f
            h = e + 12 | 0
            c[h >> 2] = (c[h >> 2] | 0) + 1
            h = c[(c[i >> 2] | 0) + (j << 2) >> 2] | 0
          }
        }
        return h | 0
      }

      function YV(b) {
        b = b | 0
        var c = 0, d = 0, e = 0
        e = b
        c = b
        while (1) {
          d = a[e >> 0] | 0
          if (!(d << 24 >> 24)) {
            break
          }
          switch (d << 24 >> 24 | 0) {
            case 10:
            case 13:
            case 32: {
              if ((c | 0) != (b | 0)) {
                if ((a[c + -1 >> 0] | 0) != 32) {
                  a[c >> 0] = 32
                  c = c + 1 | 0
                }
              } else {
                c = b
              }
              break
            }
            default: {
              a[c >> 0] = d
              c = c + 1 | 0
            }
          }
          e = e + 1 | 0
        }
        if ((c | 0) != (b | 0)) {
          b = c + -1 | 0
          b = (a[b >> 0] | 0) == 32 ? b : c
        }
        a[b >> 0] = 0
        return
      }

      function ZV(b, d, e, f) {
        b = b | 0
        d = d | 0
        e = e | 0
        f = f | 0
        d = qW(b, 0, c[b + 144 >> 2] | 0, d, e, f, (a[b + 480 >> 0] | 0) == 0 & 1) | 0
        if ((d | 0) == 0 ? (zW(b) | 0) << 24 >> 24 == 0 : 0) {
          d = 1
        }
        return d | 0
      }

      function _V(a, b, d, e) {
        a = a | 0
        b = b | 0
        d = d | 0
        e = e | 0
        var f = 0, g = 0
        g = c[a + 352 >> 2] | 0
        b = VV(g + 80 | 0, b, d, e) | 0
        do {
          if ((b | 0) != 0 ? (f = XV(a, g + 20 | 0, b, 24) | 0, (f | 0) != 0) : 0) {
            if ((c[f >> 2] | 0) == (b | 0)) {
              c[g + 96 >> 2] = c[g + 92 >> 2]
              if (!(BW(a, f) | 0)) {
                f = 0
                break
              }
            } else {
              c[g + 92 >> 2] = c[g + 96 >> 2]
            }
          } else {
            f = 0
          }
        } while (0)
        return f | 0
      }

      function $V(b, d, e, f) {
        b = b | 0
        d = d | 0
        e = e | 0
        f = f | 0
        var g = 0, h = 0, i = 0, j = 0, k = 0, l = 0, m = 0, n = 0
        m = c[b + 352 >> 2] | 0
        k = m + 80 | 0
        n = m + 92 | 0
        h = c[n >> 2] | 0
        l = m + 88 | 0
        if ((h | 0) == (c[l >> 2] | 0)) {
          if (!((dW(k) | 0) << 24 >> 24)) {
            g = 0
          } else {
            h = c[n >> 2] | 0
            i = 4
          }
        } else {
          i = 4
        }
        a:do {
          if ((i | 0) == 4) {
            c[n >> 2] = h + 1
            a[h >> 0] = 0
            d = VV(k, d, e, f) | 0
            if ((d | 0) != 0 ? (j = d + 1 | 0, g = XV(b, m + 40 | 0, j, 12) | 0, (g | 0) != 0) : 0) {
              if ((c[g >> 2] | 0) != (j | 0)) {
                c[n >> 2] = c[m + 96 >> 2]
                break
              }
              h = c[n >> 2] | 0
              i = m + 96 | 0
              c[i >> 2] = h
              if (a[b + 232 >> 0] | 0) {
                e = a[j >> 0] | 0
                b:do {
                  if (e << 24 >> 24 == 120) {
                    if ((((a[d + 2 >> 0] | 0) == 109 ? (a[d + 3 >> 0] | 0) == 108 : 0) ? (a[d
                    + 4 >> 0] | 0) == 110 : 0) ? (a[d + 5 >> 0] | 0) == 115 : 0) {
                      switch (a[d + 6 >> 0] | 0) {
                        case 0: {
                          h = m + 152 | 0
                          break
                        }
                        case 58: {
                          h = XV(b, m + 60 | 0, d + 7 | 0, 8) | 0
                          break
                        }
                        default: {
                          f = 0
                          d = 120
                          break b
                        }
                      }
                      c[g + 4 >> 2] = h
                      a[g + 9 >> 0] = 1
                      break a
                    } else {
                      f = 0
                      d = 120
                    }
                  } else {
                    f = 0
                    d = e
                  }
                } while (0)
                c:while (1) {
                  switch (d << 24 >> 24) {
                    case 0:
                      break a
                    case 58: {
                      e = 0
                      break c
                    }
                    default: {
                    }
                  }
                  d = f + 1 | 0
                  f = d
                  d = a[j + d >> 0] | 0
                }
                while (1) {
                  d = (h | 0) == (c[l >> 2] | 0)
                  if ((e | 0) >= (f | 0)) {
                    break
                  }
                  if (d) {
                    if (!((dW(k) | 0) << 24 >> 24)) {
                      g = 0
                      break a
                    }
                    h = c[n >> 2] | 0
                  }
                  d = a[j + e >> 0] | 0
                  c[n >> 2] = h + 1
                  a[h >> 0] = d
                  e = e + 1 | 0
                  h = c[n >> 2] | 0
                }
                if (d) {
                  if (!((dW(k) | 0) << 24 >> 24)) {
                    g = 0
                    break
                  }
                  h = c[n >> 2] | 0
                }
                c[n >> 2] = h + 1
                a[h >> 0] = 0
                h = XV(b, m + 60 | 0, c[i >> 2] | 0, 8) | 0
                c[g + 4 >> 2] = h
                if (h) {
                  d = c[i >> 2] | 0
                  if ((c[h >> 2] | 0) == (d | 0)) {
                    c[i >> 2] = c[n >> 2]
                    break
                  } else {
                    c[n >> 2] = d
                    break
                  }
                } else {
                  g = 0
                }
              }
            } else {
              g = 0
            }
          }
        } while (0)
        return g | 0
      }

      function aW(b, d) {
        b = b | 0
        d = d | 0
        var e = 0, f = 0, g = 0, h = 0, i = 0
        g = b + 12 | 0
        h = b + 8 | 0
        while (1) {
          e = a[d >> 0] | 0
          if (!(e << 24 >> 24)) {
            i = 7
            break
          }
          f = c[g >> 2] | 0
          if ((f | 0) == (c[h >> 2] | 0)) {
            if (!((dW(b) | 0) << 24 >> 24)) {
              d = 0
              break
            }
            f = c[g >> 2] | 0
            e = a[d >> 0] | 0
          }
          c[g >> 2] = f + 1
          a[f >> 0] = e
          d = d + 1 | 0
        }
        if ((i | 0) == 7) {
          d = c[b + 16 >> 2] | 0
        }
        return d | 0
      }

      function bW(a, b, d, e) {
        a = a | 0
        b = b | 0
        d = d | 0
        e = e | 0
        var f = 0, g = 0, h = 0, i = 0
        i = l
        l = l + 16 | 0
        h = i
        c[h >> 2] = d
        g = a + 12 | 0
        if ((c[g >> 2] | 0) == 0 ? (dW(a) | 0) << 24 >> 24 == 0 : 0) {
          d = 0
        } else {
          f = 3
        }
        a:do {
          if ((f | 0) == 3) {
            d = b + 56 | 0
            f = a + 8 | 0
            while (1) {
              if ((pb[c[d >> 2] & 127](b, h, e, g, c[f >> 2] | 0) | 0) >>> 0 < 2) {
                break
              }
              if (!((dW(a) | 0) << 24 >> 24)) {
                d = 0
                break a
              }
            }
            d = c[a + 16 >> 2] | 0
          }
        } while (0)
        l = i
        return d | 0
      }

      function cW(b, d, e, f, g, h) {
        b = b | 0
        d = d | 0
        e = e | 0
        f = f | 0
        g = g | 0
        h = h | 0
        var i = 0, j = 0, k = 0, l = 0, m = 0, n = 0
        i = f << 24 >> 24 == 0
        n = b + 12 | 0
        m = c[n >> 2] | 0
        a:do {
          if (!(i & (g | 0) == 0)) {
            j = b + 20 | 0
            f = 0
            while (1) {
              if ((f | 0) >= (m | 0)) {
                break
              }
              if ((c[(c[j >> 2] | 0) + (f * 12 | 0) >> 2] | 0) == (d | 0)) {
                f = 1
                break a
              } else {
                f = f + 1 | 0
              }
            }
            if ((!i ? (k = b + 8 | 0, (c[k >> 2] | 0) == 0) : 0) ? (a[d + 9 >> 0] | 0) == 0 : 0) {
              c[k >> 2] = d
              l = 9
            } else {
              l = 9
            }
          } else {
            l = 9
          }
        } while (0)
        b:do {
          if ((l | 0) == 9) {
            j = b + 16 | 0
            do {
              if ((m | 0) == (c[j >> 2] | 0)) {
                if (!m) {
                  c[j >> 2] = 8
                  f = kb[c[h + 12 >> 2] & 63](96) | 0
                  c[b + 20 >> 2] = f
                  if (f | 0) {
                    break
                  }
                  c[j >> 2] = 0
                  f = 0
                  break b
                } else {
                  i = b + 20 | 0
                  f = lb[c[h + 16 >> 2] & 127](c[i >> 2] | 0, m * 24 | 0) | 0
                  if (!f) {
                    f = 0
                    break b
                  }
                  c[j >> 2] = m << 1
                  c[i >> 2] = f
                  break
                }
              } else {
                f = c[b + 20 >> 2] | 0
              }
            } while (0)
            h = c[n >> 2] | 0
            c[f + (h * 12 | 0) >> 2] = d
            c[f + (h * 12 | 0) + 8 >> 2] = g
            a[f + (h * 12 | 0) + 4 >> 0] = e
            if (!(e << 24 >> 24)) {
              a[d + 8 >> 0] = 1
            }
            c[n >> 2] = (c[n >> 2] | 0) + 1
            f = 1
          }
        } while (0)
        return f | 0
      }

      function dW(a) {
        a = a | 0
        var b = 0, d = 0, e = 0, f = 0, g = 0, h = 0, i = 0, j = 0, k = 0, l = 0
        b = a + 4 | 0
        e = c[b >> 2] | 0
        do {
          if (e) {
            f = a + 16 | 0
            g = c[f >> 2] | 0
            if (!g) {
              c[a >> 2] = e
              c[b >> 2] = c[e >> 2]
              c[e >> 2] = 0
              l = c[a >> 2] | 0
              b = l + 8 | 0
              c[f >> 2] = b
              c[a + 8 >> 2] = (c[l + 4 >> 2] | 0) + (l + 8)
              c[a + 12 >> 2] = b
              b = 1
              break
            }
            d = a + 8 | 0
            if (((c[d >> 2] | 0) - g | 0) < (c[e + 4 >> 2] | 0)) {
              k = c[e >> 2] | 0
              c[e >> 2] = c[a >> 2]
              l = c[b >> 2] | 0
              c[a >> 2] = l
              c[b >> 2] = k
              b = c[f >> 2] | 0
              E3(l + 8 | 0, b | 0, (c[d >> 2] | 0) - b | 0) | 0
              b = c[a >> 2] | 0
              l = a + 12 | 0
              c[l >> 2] = (c[l >> 2] | 0) - (c[f >> 2] | 0) + (b + 8)
              c[f >> 2] = b + 8
              c[d >> 2] = (c[b + 4 >> 2] | 0) + (b + 8)
              b = 1
            } else {
              h = 6
            }
          } else {
            h = 6
          }
        } while (0)
        a:do {
          if ((h | 0) == 6) {
            e = c[a >> 2] | 0
            k = a + 16 | 0
            do {
              if (!e) {
                i = k
                b = c[k >> 2] | 0
              } else {
                j = c[k >> 2] | 0
                b = j
                if ((j | 0) != (e + 8 | 0)) {
                  i = k
                  break
                }
                f = a + 8 | 0
                g = (c[f >> 2] | 0) - b << 1
                h = a + 12 | 0
                d = (c[h >> 2] | 0) - b | 0
                if ((g | 0) < 0) {
                  b = 0
                  break a
                }
                b = LW(g) | 0
                if (!b) {
                  b = 0
                  break a
                }
                b = lb[c[(c[a + 20 >> 2] | 0) + 4 >> 2] & 127](e, b) | 0
                if (!b) {
                  b = 0
                  break a
                }
                c[a >> 2] = b
                c[b + 4 >> 2] = g
                b = c[a >> 2] | 0
                c[h >> 2] = b + 8 + d
                c[k >> 2] = b + 8
                c[f >> 2] = b + 8 + g
                b = 1
                break a
              }
            } while (0)
            j = a + 8 | 0
            b = (c[j >> 2] | 0) - b | 0
            if ((b | 0) >= 0) {
              if ((b | 0) >= 1024) {
                b = b << 1
                if ((b | 0) < 0) {
                  b = 0
                  break
                }
              } else {
                b = 1024
              }
              d = LW(b) | 0
              if ((d | 0) != 0 ? (l = kb[c[c[a + 20 >> 2] >> 2] & 63](d) | 0, (l | 0) != 0) : 0) {
                c[l + 4 >> 2] = b
                c[l >> 2] = c[a >> 2]
                c[a >> 2] = l
                h = a + 12 | 0
                a = c[h >> 2] | 0
                e = c[k >> 2] | 0
                d = a
                f = e
                if ((a | 0) == (e | 0)) {
                  g = l + 8 | 0
                  e = f
                } else {
                  g = l + 8 | 0
                  E3(g | 0, e | 0, d - f | 0) | 0
                  e = c[i >> 2] | 0
                  d = c[h >> 2] | 0
                }
                c[h >> 2] = l + 8 + (d - e)
                c[k >> 2] = g
                c[j >> 2] = l + 8 + b
                b = 1
              } else {
                b = 0
              }
            } else {
              b = 0
            }
          }
        } while (0)
        return b | 0
      }

      function eW(b, d, e, f, g, h) {
        b = b | 0
        d = d | 0
        e = e | 0
        f = f | 0
        g = g | 0
        h = h | 0
        var i = 0
        b = KW(b, d, e, f, g, h) | 0
        do {
          if (!b) {
            d = h + 12 | 0
            b = c[d >> 2] | 0
            if ((e << 24 >> 24 == 0 ? (c[h + 16 >> 2] | 0) != (b | 0) : 0) ? (i = b + -1 | 0, (a[i >> 0] | 0) == 32)
                : 0) {
              c[d >> 2] = i
              b = i
            }
            if ((b | 0) == (c[h + 8 >> 2] | 0)) {
              if (!((dW(h) | 0) << 24 >> 24)) {
                b = 1
                break
              }
              b = c[d >> 2] | 0
            }
            c[d >> 2] = b + 1
            a[b >> 0] = 0
            b = 0
          }
        } while (0)
        return b | 0
      }

      function fW(b, d, e, f) {
        b = b | 0
        d = d | 0
        e = e | 0
        f = f | 0
        var g = 0, h = 0, i = 0, j = 0, k = 0, m = 0, n = 0, o = 0, p = 0, q = 0, r = 0, s = 0, t = 0, u = 0, v = 0,
            w = 0, x = 0, y = 0, z = 0, A = 0, B = 0, C = 0, D = 0, E = 0, F = 0, G = 0, H = 0
        H = l
        l = l + 16 | 0
        B = H
        C = H + 4 | 0
        g = c[b + 352 >> 2] | 0
        D = g + 104 | 0
        F = b + 272 | 0
        E = c[F >> 2] | 0
        c[F >> 2] = 1
        if ((c[D >> 2] | 0) == 0 ? (dW(D) | 0) << 24 >> 24 == 0 : 0) {
          g = 1
        } else {
          n = d + 20 | 0
          o = b + 484 | 0
          p = b + 144 | 0
          q = b + 412 | 0
          r = d + 64 | 0
          s = g + 132 | 0
          t = b + 428 | 0
          u = b + 424 | 0
          v = b + 224 | 0
          w = b + 112 | 0
          m = g + 130 | 0
          x = g + 128 | 0
          y = g + 131 | 0
          z = b + 116 | 0
          A = g + 112 | 0
          j = g + 116 | 0
          k = d + 40 | 0
          a:while (1) {
            b:do {
              switch (ob[c[n >> 2] & 127](d, e, f, B) | 0) {
                case -4: {
                  g = 0
                  break a
                }
                case -1: {
                  G = 37
                  break a
                }
                case 0: {
                  G = 39
                  break a
                }
                case 28: {
                  if ((a[o >> 0] | 0) == 0 ? (c[p >> 2] | 0) == (d | 0) : 0) {
                    G = 19
                    break a
                  }
                  g = c[r >> 2] | 0
                  g = VV(q, d, e + g | 0, (c[B >> 2] | 0) + (0 - g) | 0) | 0
                  if (!g) {
                    g = 1
                    break a
                  }
                  h = XV(b, s, g, 0) | 0
                  c[u >> 2] = c[t >> 2]
                  if (!h) {
                    G = 9
                    break a
                  }
                  i = h + 32 | 0
                  if (a[i >> 0] | 0) {
                    G = 11
                    break a
                  }
                  g = h + 16 | 0
                  if (!(c[g >> 2] | 0)) {
                    a[i >> 0] = 1
                    g = c[h + 4 >> 2] | 0
                    g = fW(b, c[v >> 2] | 0, g, g + (c[h + 8 >> 2] | 0) | 0) | 0
                    a[i >> 0] = 0
                    if (!g) {
                      break b
                    } else {
                      break a
                    }
                  }
                  if (c[w >> 2] | 0) {
                    a[y >> 0] = 0
                    a[i >> 0] = 1
                    h = (pb[c[w >> 2] & 127](c[z >> 2] | 0, 0, c[h + 20 >> 2] | 0, c[g >> 2] | 0, c[h + 24 >> 2] | 0)
                        | 0)
                        == 0
                    a[i >> 0] = 0
                    if (h) {
                      g = 21
                      break a
                    }
                    if (a[y >> 0] | 0) {
                      break b
                    }
                  }
                  a[x >> 0] = a[m >> 0] | 0
                  break
                }
                case 6:
                case 9: {
                  if (!(bW(D, d, e, c[B >> 2] | 0) | 0)) {
                    g = 1
                    break a
                  }
                  break
                }
                case -3: {
                  c[B >> 2] = e + (c[r >> 2] | 0)
                  G = 22
                  break
                }
                case 7: {
                  G = 22
                  break
                }
                case 10: {
                  g = lb[c[k >> 2] & 127](d, e) | 0
                  if ((g | 0) < 0) {
                    G = 27
                    break a
                  }
                  h = fX(g, C) | 0
                  e = 0
                  while (1) {
                    if ((e | 0) >= (h | 0)) {
                      break
                    }
                    g = c[j >> 2] | 0
                    if ((c[A >> 2] | 0) == (g | 0)) {
                      if (!((dW(D) | 0) << 24 >> 24)) {
                        g = 1
                        G = 35
                        break a
                      }
                      g = c[j >> 2] | 0
                    }
                    i = a[C + e >> 0] | 0
                    c[j >> 2] = g + 1
                    a[g >> 0] = i
                    e = e + 1 | 0
                  }
                  break
                }
                default: {
                  G = 41
                  break a
                }
              }
            } while (0)
            if ((G | 0) == 22) {
              G = 0
              g = c[j >> 2] | 0
              if ((c[A >> 2] | 0) == (g | 0)) {
                if (!((dW(D) | 0) << 24 >> 24)) {
                  g = 1
                  break
                }
                g = c[j >> 2] | 0
              }
              c[j >> 2] = g + 1
              a[g >> 0] = 10
            }
            e = c[B >> 2] | 0
          }
          if ((G | 0) == 9) {
            a[x >> 0] = a[m >> 0] | 0
            g = 0
          } else if ((G | 0) == 11) {
            if ((c[p >> 2] | 0) == (d | 0)) {
              c[b + 284 >> 2] = e
              g = 12
            } else {
              g = 12
            }
          } else if ((G | 0) == 19) {
            c[b + 284 >> 2] = e
            g = 10
          } else if ((G | 0) == 27) {
            if ((c[p >> 2] | 0) == (d | 0)) {
              c[b + 284 >> 2] = e
              g = 14
              G = 35
            } else {
              g = 14
              G = 35
            }
          } else if ((G | 0) == 37) {
            if ((c[p >> 2] | 0) == (d | 0)) {
              c[b + 284 >> 2] = e
              g = 4
            } else {
              g = 4
            }
          } else if ((G | 0) == 39) {
            if ((c[p >> 2] | 0) == (d | 0)) {
              c[b + 284 >> 2] = c[B >> 2]
              g = 4
            } else {
              g = 4
            }
          } else if ((G | 0) == 41) {
            if ((c[p >> 2] | 0) == (d | 0)) {
              c[b + 284 >> 2] = e
              g = 23
            } else {
              g = 23
            }
          }
          c[F >> 2] = E
        }
        l = H
        return g | 0
      }

      function gW(b, d, e, f) {
        b = b | 0
        d = d | 0
        e = e | 0
        f = f | 0
        var g = 0, h = 0, i = 0, j = 0, k = 0, m = 0, n = 0, o = 0, p = 0, q = 0
        p = l
        l = l + 16 | 0
        n = p
        o = p + 4 | 0
        c[n >> 2] = e
        if (!(a[d + 68 >> 0] | 0)) {
          if ((c[b + 144 >> 2] | 0) == (d | 0)) {
            g = b + 288 | 0
            h = b + 284 | 0
          } else {
            h = c[b + 296 >> 2] | 0
            g = h + 4 | 0
          }
          i = b + 44 | 0
          j = d + 56 | 0
          k = b + 48 | 0
          m = b + 80 | 0
          e = b + 4 | 0
          do {
            c[o >> 2] = c[i >> 2]
            b = pb[c[j >> 2] & 127](d, n, f, o, c[k >> 2] | 0) | 0
            c[g >> 2] = c[n >> 2]
            q = c[i >> 2] | 0
            vb[c[m >> 2] & 127](c[e >> 2] | 0, q, (c[o >> 2] | 0) - q | 0)
            c[h >> 2] = c[n >> 2]
          } while (b >>> 0 > 1)
        } else {
          vb[c[b + 80 >> 2] & 127](c[b + 4 >> 2] | 0, e, f - e | 0)
        }
        l = p
        return
      }

      function hW(a, b, d, e, f, g) {
        a = a | 0
        b = b | 0
        d = d | 0
        e = e | 0
        f = f | 0
        g = g | 0
        var h = 0, i = 0, j = 0, k = 0, m = 0, n = 0
        m = l
        l = l + 16 | 0
        j = m
        k = c[d >> 2] | 0
        if ((c[a + 144 >> 2] | 0) == (b | 0)) {
          i = a + 284 | 0
          c[i >> 2] = k
          h = a + 288 | 0
        } else {
          i = c[a + 296 >> 2] | 0
          h = i + 4 | 0
        }
        c[i >> 2] = k
        c[d >> 2] = 0
        n = ob[c[b + 12 >> 2] & 127](b, k, e, j) | 0
        e = c[j >> 2] | 0
        c[h >> 2] = e
        switch (n | 0) {
          case 42: {
            if (c[a + 80 >> 2] | 0) {
              gW(a, b, k, e)
              e = c[j >> 2] | 0
            }
            c[d >> 2] = e
            c[f >> 2] = e
            e = (c[a + 476 >> 2] | 0) == 2 ? 35 : 0
            break
          }
          case 0: {
            c[i >> 2] = e
            e = 4
            break
          }
          case -2: {
            if (!(g << 24 >> 24)) {
              e = 6
            } else {
              c[f >> 2] = k
              e = 0
            }
            break
          }
          case -4:
          case -1: {
            if (!(g << 24 >> 24)) {
              e = 2
            } else {
              c[f >> 2] = k
              e = 0
            }
            break
          }
          default: {
            c[i >> 2] = e
            e = 23
          }
        }
        l = m
        return e | 0
      }

      function iW(b, d, e, f) {
        b = b | 0
        d = d | 0
        e = e | 0
        f = f | 0
        var g = 0, h = 0
        h = l
        l = l + 16 | 0
        g = h
        c[g >> 2] = d
        d = hW(b, c[b + 144 >> 2] | 0, g, e, f, (a[b + 480 >> 0] | 0) == 0 & 1) | 0
        g = c[g >> 2] | 0
        if (!((d | 0) != 0 | (g | 0) == 0)) {
          c[b + 276 >> 2] = 57
          d = SV(b, g, e, f) | 0
        }
        l = h
        return d | 0
      }

      function jW(a) {
        a = a | 0
        var b = 0, d = 0, e = 0, f = 0, g = 0, h = 0, i = 0, j = 0
        i = c[a + 352 >> 2] | 0
        j = i + 184 | 0
        if (!(c[j >> 2] | 0)) {
          b = kb[c[a + 12 >> 2] & 63](c[a + 464 >> 2] << 2) | 0
          c[j >> 2] = b
          if (!b) {
            b = -1
          } else {
            c[b >> 2] = 0
            d = 4
          }
        } else {
          d = 4
        }
        do {
          if ((d | 0) == 4) {
            h = i + 176 | 0
            b = c[h >> 2] | 0
            g = i + 172 | 0
            d = c[g >> 2] | 0
            f = i + 164 | 0
            e = c[f >> 2] | 0
            if (b >>> 0 < d >>> 0) {
              g = e
            } else {
              if (!e) {
                b = kb[c[a + 12 >> 2] & 63](896) | 0
                if (!b) {
                  b = -1
                  break
                } else {
                  d = b
                  b = 32
                }
              } else {
                b = lb[c[a + 16 >> 2] & 127](e, d * 56 | 0) | 0
                if (!b) {
                  b = -1
                  break
                }
                d = b
                b = c[g >> 2] << 1
              }
              c[g >> 2] = b
              c[f >> 2] = d
              b = c[h >> 2] | 0
              g = d
            }
            c[h >> 2] = b + 1
            d = c[i + 180 >> 2] | 0
            if (d | 0) {
              a = c[(c[j >> 2] | 0) + (d + -1 << 2) >> 2] | 0
              f = g + (a * 28 | 0) + 16 | 0
              d = c[f >> 2] | 0
              if (d | 0) {
                c[g + (d * 28 | 0) + 24 >> 2] = b
              }
              d = g + (a * 28 | 0) + 20 | 0
              e = c[d >> 2] | 0
              if (!e) {
                c[g + (a * 28 | 0) + 12 >> 2] = b
              }
              c[f >> 2] = b
              c[d >> 2] = e + 1
            }
            j = g + (b * 28 | 0) + 12 | 0
            c[j >> 2] = 0
            c[j + 4 >> 2] = 0
            c[j + 8 >> 2] = 0
            c[j + 12 >> 2] = 0
          }
        } while (0)
        return b | 0
      }

      function kW(b, d, e) {
        b = b | 0
        d = d | 0
        e = e | 0
        var f = 0, g = 0, h = 0, i = 0, j = 0, k = 0, m = 0, n = 0, o = 0, p = 0
        p = l
        l = l + 16 | 0
        n = p
        o = b + 300 | 0
        f = c[o >> 2] | 0
        if (!f) {
          f = kb[c[b + 12 >> 2] & 63](24) | 0
          if (!f) {
            f = 1
          } else {
            m = f
            g = 4
          }
        } else {
          c[o >> 2] = c[f + 8 >> 2]
          m = f
          g = 4
        }
        do {
          if ((g | 0) == 4) {
            h = d + 32 | 0
            a[h >> 0] = 1
            i = d + 12 | 0
            c[i >> 2] = 0
            j = b + 296 | 0
            k = m + 8 | 0
            c[k >> 2] = c[j >> 2]
            c[j >> 2] = m
            c[m + 12 >> 2] = d
            f = b + 308 | 0
            c[m + 16 >> 2] = c[f >> 2]
            a[m + 20 >> 0] = e
            c[m >> 2] = 0
            c[m + 4 >> 2] = 0
            g = c[d + 4 >> 2] | 0
            e = g + (c[d + 8 >> 2] | 0) | 0
            c[n >> 2] = g
            if (!(a[d + 33 >> 0] | 0)) {
              f = qW(b, c[f >> 2] | 0, c[b + 224 >> 2] | 0, g, e, n, 0) | 0
            } else {
              d = b + 224 | 0
              f = c[d >> 2] | 0
              f = ob[c[f >> 2] & 127](f, g, e, n) | 0
              f = TV(b, c[d >> 2] | 0, g, e, f, c[n >> 2] | 0, n, 0) | 0
            }
            if (!f) {
              f = c[n >> 2] | 0
              if ((e | 0) != (f | 0) ? (c[b + 476 >> 2] | 0) == 3 : 0) {
                c[i >> 2] = f - g
                c[b + 276 >> 2] = 60
                f = 0
                break
              }
              a[h >> 0] = 0
              c[j >> 2] = c[k >> 2]
              c[k >> 2] = c[o >> 2]
              c[o >> 2] = m
              f = 0
            }
          }
        } while (0)
        l = p
        return f | 0
      }

      function lW(a) {
        a = a | 0
        var b = 0, d = 0, e = 0, f = 0, g = 0
        g = l
        l = l + 16 | 0
        d = g + 4 | 0
        e = g
        b = c[a + 352 >> 2] | 0
        f = b + 176 | 0
        b = kb[c[a + 12 >> 2] & 63](((c[f >> 2] | 0) * 20 | 0) + (c[b + 168 >> 2] | 0) | 0) | 0
        if (!b) {
          b = 0
        } else {
          c[e >> 2] = b + ((c[f >> 2] | 0) * 20 | 0)
          c[d >> 2] = b + 20
          pW(a, 0, b, d, e)
        }
        l = g
        return b | 0
      }

      function mW(a, b, d, e) {
        a = a | 0
        b = b | 0
        d = d | 0
        e = e | 0
        var f = 0, g = 0, h = 0, i = 0, j = 0
        j = a + 64 | 0
        if (!(c[j >> 2] | 0)) {
          if (!(c[a + 80 >> 2] | 0)) {
            d = 1
          } else {
            gW(a, b, d, e)
            d = 1
          }
        } else {
          h = b + 64 | 0
          g = d + (c[h >> 2] << 1) | 0
          d = g + (lb[c[b + 28 >> 2] & 127](b, g) | 0) | 0
          f = a + 412 | 0
          g = VV(f, b, g, d) | 0
          if ((g | 0) != 0 ? (c[a + 428 >> 2] = c[a + 424 >> 2], i = lb[c[b + 32 >> 2] & 127](b, d) | 0, i = VV(f, b, i,
              e + (0 - (c[h >> 2] << 1)) | 0) | 0, (i | 0) != 0) : 0) {
            oW(i)
            vb[c[j >> 2] & 127](c[a + 4 >> 2] | 0, g, i)
            WV(f)
            d = 1
          } else {
            d = 0
          }
        }
        return d | 0
      }

      function nW(a, b, d, e) {
        a = a | 0
        b = b | 0
        d = d | 0
        e = e | 0
        var f = 0, g = 0, h = 0
        g = a + 68 | 0
        if (!(c[g >> 2] | 0)) {
          if (!(c[a + 80 >> 2] | 0)) {
            b = 1
          } else {
            gW(a, b, d, e)
            b = 1
          }
        } else {
          f = a + 412 | 0
          h = c[b + 64 >> 2] | 0
          b = VV(f, b, d + (h << 2) | 0, e + (O(h, -3) | 0) | 0) | 0
          if (!b) {
            b = 0
          } else {
            oW(b)
            ub[c[g >> 2] & 63](c[a + 4 >> 2] | 0, b)
            WV(f)
            b = 1
          }
        }
        return b | 0
      }

      function oW(b) {
        b = b | 0
        var c = 0, d = 0, e = 0
        a:while (1) {
          switch (a[b >> 0] | 0) {
            case 0:
              break a
            case 13: {
              d = b
              c = 13
              e = 4
              break a
            }
            default: {
            }
          }
          b = b + 1 | 0
        }
        if ((e | 0) == 4) {
          while (1) {
            if (c << 24 >> 24 == 13) {
              a[d >> 0] = 10
              e = b + 1 | 0
              b = (a[e >> 0] | 0) == 10 ? b + 2 | 0 : e
            } else {
              a[d >> 0] = c
              b = b + 1 | 0
            }
            d = d + 1 | 0
            c = a[b >> 0] | 0
            if (!(c << 24 >> 24)) {
              break
            } else {
              e = 4
            }
          }
          a[d >> 0] = 0
        }
        return
      }

      function pW(b, d, e, f, g) {
        b = b | 0
        d = d | 0
        e = e | 0
        f = f | 0
        g = g | 0
        var h = 0, i = 0, j = 0, k = 0
        k = (c[b + 352 >> 2] | 0) + 164 | 0
        j = c[(c[k >> 2] | 0) + (d * 28 | 0) >> 2] | 0
        c[e >> 2] = j
        c[e + 4 >> 2] = c[(c[k >> 2] | 0) + (d * 28 | 0) + 4 >> 2]
        if ((j | 0) == 4) {
          c[e + 8 >> 2] = c[g >> 2]
          d = c[(c[k >> 2] | 0) + (d * 28 | 0) + 8 >> 2] | 0
          while (1) {
            j = a[d >> 0] | 0
            k = c[g >> 2] | 0
            c[g >> 2] = k + 1
            a[k >> 0] = j
            if (!(a[d >> 0] | 0)) {
              break
            } else {
              d = d + 1 | 0
            }
          }
          c[e + 12 >> 2] = 0
          c[e + 16 >> 2] = 0
        } else {
          h = c[(c[k >> 2] | 0) + (d * 28 | 0) + 20 >> 2] | 0
          i = e + 12 | 0
          c[i >> 2] = h
          j = e + 16 | 0
          c[j >> 2] = c[f >> 2]
          c[f >> 2] = (c[f >> 2] | 0) + (h * 20 | 0)
          d = (c[k >> 2] | 0) + (d * 28 | 0) + 12 | 0
          h = 0
          while (1) {
            d = c[d >> 2] | 0
            if (h >>> 0 >= (c[i >> 2] | 0) >>> 0) {
              break
            }
            pW(b, d, (c[j >> 2] | 0) + (h * 20 | 0) | 0, f, g)
            d = (c[k >> 2] | 0) + (d * 28 | 0) + 24 | 0
            h = h + 1 | 0
          }
          c[e + 8 >> 2] = 0
        }
        return
      }

      function qW(b, d, e, f, g, h, i) {
        b = b | 0
        d = d | 0
        e = e | 0
        f = f | 0
        g = g | 0
        h = h | 0
        i = i | 0
        var j = 0, k = 0, m = 0, n = 0, o = 0, p = 0, q = 0, r = 0, s = 0, t = 0, u = 0, v = 0, w = 0, x = 0, y = 0,
            z = 0, A = 0, B = 0, C = 0, D = 0, E = 0, F = 0, G = 0, H = 0, I = 0, J = 0, K = 0, L = 0, M = 0, N = 0,
            O = 0, P = 0, Q = 0, R = 0, S = 0, T = 0, U = 0, V = 0, W = 0, X = 0, Y = 0, Z = 0, _ = 0, $ = 0, aa = 0,
            ba = 0, ca = 0, da = 0, ea = 0, fa = 0, ga = 0, ha = 0, ia = 0, ja = 0, ka = 0, la = 0, ma = 0, na = 0
        ma = l
        l = l + 48 | 0
        ja = ma + 28 | 0
        ea = ma + 32 | 0
        ka = ma + 24 | 0
        Z = ma
        c[ja >> 2] = f
        _ = c[b + 352 >> 2] | 0
        if ((c[b + 144 >> 2] | 0) == (e | 0)) {
          fa = b + 284 | 0
          Y = b + 288 | 0
        } else {
          Y = c[b + 296 >> 2] | 0
          fa = Y
          Y = Y + 4 | 0
        }
        c[fa >> 2] = f
        t = e + 4 | 0
        ga = b + 80 | 0
        u = b + 476 | 0
        v = e + 44 | 0
        w = e + 64 | 0
        x = _ + 80 | 0
        y = _ + 96 | 0
        z = _ + 92 | 0
        A = _ + 129 | 0
        B = b + 112 | 0
        C = b + 116 | 0
        D = b + 428 | 0
        E = b + 424 | 0
        F = b + 304 | 0
        G = b + 120 | 0
        ha = b + 4 | 0
        H = _ + 130 | 0
        $ = b + 60 | 0
        I = b + 364 | 0
        J = b + 12 | 0
        K = b + 360 | 0
        L = e + 28 | 0
        ia = b + 308 | 0
        aa = e + 56 | 0
        M = b + 16 | 0
        N = b + 52 | 0
        O = b + 412 | 0
        P = b + 388 | 0
        Q = b + 56 | 0
        R = b + 232 | 0
        S = b + 233 | 0
        T = b + 468 | 0
        U = b + 104 | 0
        V = b + 372 | 0
        W = e + 40 | 0
        X = b + 72 | 0
        ba = e + 68 | 0
        ca = b + 44 | 0
        da = b + 48 | 0
        a:while (1) {
          s = c[ja >> 2] | 0
          c[ea >> 2] = s
          s = ob[c[t >> 2] & 127](e, s, g, ea) | 0
          f = c[ea >> 2] | 0
          c[Y >> 2] = f
          k = f
          b:do {
            switch (s | 0) {
              case -3: {
                la = 6
                break a
              }
              case -4: {
                la = 15
                break a
              }
              case 0: {
                la = 20
                break a
              }
              case -1: {
                la = 21
                break a
              }
              case -2: {
                la = 23
                break a
              }
              case 12: {
                f = 17
                break a
              }
              case -5: {
                la = 134
                break a
              }
              case 9: {
                s = c[w >> 2] | 0
                s = (nb[c[v >> 2] & 63](e, (c[ja >> 2] | 0) + s | 0, k + (0 - s) | 0) | 0) & 255
                a[ka >> 0] = s
                do {
                  if (s << 24 >> 24) {
                    f = c[$ >> 2] | 0
                    if (f | 0) {
                      vb[f & 127](c[ha >> 2] | 0, ka, 1)
                      break
                    }
                    if (c[ga >> 2] | 0) {
                      gW(b, e, c[ja >> 2] | 0, c[ea >> 2] | 0)
                    }
                  } else {
                    j = c[w >> 2] | 0
                    j = VV(x, e, (c[ja >> 2] | 0) + j | 0, (c[ea >> 2] | 0) + (0 - j) | 0) | 0
                    if (!j) {
                      f = 1
                      la = 56
                      break a
                    }
                    k = XV(b, _, j, 0) | 0
                    c[z >> 2] = c[y >> 2]
                    if ((a[A >> 0] | 0) != 0 ? (a[H >> 0] | 0) == 0 : 0) {
                      if (!k) {
                        f = c[G >> 2] | 0
                        if (f | 0) {
                          vb[f & 127](c[ha >> 2] | 0, j, 0)
                          break
                        }
                        if (!(c[ga >> 2] | 0)) {
                          break
                        }
                        gW(b, e, c[ja >> 2] | 0, c[ea >> 2] | 0)
                        break
                      }
                    } else {
                      if (!k) {
                        f = 11
                        la = 56
                        break a
                      }
                      if (!(a[k + 34 >> 0] | 0)) {
                        f = 24
                        la = 56
                        break a
                      }
                    }
                    f = k + 32 | 0
                    if (a[f >> 0] | 0) {
                      f = 12
                      la = 56
                      break a
                    }
                    if (c[k + 28 >> 2] | 0) {
                      f = 15
                      la = 56
                      break a
                    }
                    if (!(c[k + 4 >> 2] | 0)) {
                      if (!(c[B >> 2] | 0)) {
                        if (!(c[ga >> 2] | 0)) {
                          break
                        }
                        gW(b, e, c[ja >> 2] | 0, c[ea >> 2] | 0)
                        break
                      }
                      a[f >> 0] = 1
                      j = sW(b) | 0
                      a[f >> 0] = 0
                      if (!j) {
                        f = 1
                        la = 56
                        break a
                      }
                      if (!(pb[c[B >> 2] & 127](c[C >> 2] | 0, j, c[k + 20 >> 2] | 0, c[k + 16 >> 2] | 0,
                          c[k + 24 >> 2] | 0) | 0)) {
                        f = 21
                        la = 56
                        break a
                      }
                      c[E >> 2] = c[D >> 2]
                      break
                    }
                    if (a[F >> 0] | 0) {
                      f = kW(b, k, 0) | 0
                      if (!f) {
                        break
                      } else {
                        la = 58
                        break a
                      }
                    }
                    f = c[G >> 2] | 0
                    if (!f) {
                      if (c[ga >> 2] | 0) {
                        gW(b, e, c[ja >> 2] | 0, c[ea >> 2] | 0)
                      }
                    } else {
                      vb[f & 127](c[ha >> 2] | 0, c[k >> 2] | 0, 0)
                    }
                    break b
                  }
                } while (0)
                break
              }
              case 1:
              case 2: {
                f = c[I >> 2] | 0
                if (!f) {
                  f = kb[c[J >> 2] & 63](48) | 0
                  if (!f) {
                    f = 1
                    la = 75
                    break a
                  }
                  j = kb[c[J >> 2] & 63](32) | 0
                  c[f + 36 >> 2] = j
                  if (!j) {
                    la = 63
                    break a
                  }
                  c[f + 40 >> 2] = j + 32
                } else {
                  c[I >> 2] = c[f >> 2]
                }
                o = f + 44 | 0
                c[o >> 2] = 0
                c[f >> 2] = c[K >> 2]
                c[K >> 2] = f
                s = f + 12 | 0
                c[f + 16 >> 2] = 0
                c[f + 20 >> 2] = 0
                r = (c[ja >> 2] | 0) + (c[w >> 2] | 0) | 0
                q = f + 4 | 0
                c[q >> 2] = r
                p = f + 8 | 0
                c[p >> 2] = lb[c[L >> 2] & 127](e, r) | 0
                c[ia >> 2] = (c[ia >> 2] | 0) + 1
                q = c[q >> 2] | 0
                p = q + (c[p >> 2] | 0) | 0
                c[Z >> 2] = q
                q = f + 36 | 0
                c[ka >> 2] = c[q >> 2]
                r = f + 40 | 0
                j = c[r >> 2] | 0
                while (1) {
                  na = pb[c[aa >> 2] & 127](e, Z, p, ka, j + -1 | 0) | 0
                  j = c[ka >> 2] | 0
                  m = c[q >> 2] | 0
                  k = m
                  n = j - k | 0
                  if ((na | 0) == 1 ? 1 : (c[Z >> 2] | 0) >>> 0 >= p >>> 0) {
                    break
                  }
                  k = (c[r >> 2] | 0) - k << 1
                  j = lb[c[M >> 2] & 127](m, k) | 0
                  if (!j) {
                    la = 69
                    break a
                  }
                  c[q >> 2] = j
                  na = j + k | 0
                  c[r >> 2] = na
                  c[ka >> 2] = j + n
                  j = na
                }
                c[f + 24 >> 2] = n
                c[s >> 2] = k
                a[j >> 0] = 0
                f = tW(b, e, c[ja >> 2] | 0, s, o) | 0
                if (f | 0) {
                  la = 75
                  break a
                }
                f = c[N >> 2] | 0
                if (!f) {
                  if (c[ga >> 2] | 0) {
                    gW(b, e, c[ja >> 2] | 0, c[ea >> 2] | 0)
                  }
                } else {
                  vb[f & 127](c[ha >> 2] | 0, c[s >> 2] | 0, c[P >> 2] | 0)
                }
                WV(O)
                break
              }
              case 3:
              case 4: {
                na = (c[ja >> 2] | 0) + (c[w >> 2] | 0) | 0
                c[ka >> 2] = 0
                na = VV(O, e, na, na + (lb[c[L >> 2] & 127](e, na) | 0) | 0) | 0
                c[Z >> 2] = na
                if (!na) {
                  f = 1
                  la = 89
                  break a
                }
                c[D >> 2] = c[E >> 2]
                f = tW(b, e, c[ja >> 2] | 0, Z, ka) | 0
                if (f | 0) {
                  la = 79
                  break a
                }
                c[D >> 2] = c[E >> 2]
                f = c[N >> 2] | 0
                if (!f) {
                  j = 1
                } else {
                  vb[f & 127](c[ha >> 2] | 0, c[Z >> 2] | 0, c[P >> 2] | 0)
                  j = 0
                }
                f = c[Q >> 2] | 0
                if (!f) {
                  if (j | 0 ? c[ga >> 2] | 0 : 0) {
                    gW(b, e, c[ja >> 2] | 0, c[ea >> 2] | 0)
                  }
                } else {
                  if (c[N >> 2] | 0) {
                    c[fa >> 2] = c[Y >> 2]
                    f = c[Q >> 2] | 0
                  }
                  ub[f & 63](c[ha >> 2] | 0, c[Z >> 2] | 0)
                }
                WV(O)
                uW(b, c[ka >> 2] | 0)
                if ((c[ia >> 2] | 0) == 0 ? (c[u >> 2] & -2 | 0) != 2 : 0) {
                  la = 92
                  break a
                }
                break
              }
              case 5: {
                if ((c[ia >> 2] | 0) == (d | 0)) {
                  f = 13
                  break a
                }
                n = c[K >> 2] | 0
                c[K >> 2] = c[n >> 2]
                c[n >> 2] = c[I >> 2]
                c[I >> 2] = n
                f = (c[ja >> 2] | 0) + (c[w >> 2] << 1) | 0
                j = lb[c[L >> 2] & 127](e, f) | 0
                if ((j | 0) != (c[n + 8 >> 2] | 0)) {
                  la = 96
                  break a
                }
                if (K0(c[n + 4 >> 2] | 0, f, j) | 0) {
                  la = 96
                  break a
                }
                c[ia >> 2] = (c[ia >> 2] | 0) + -1
                f = c[Q >> 2] | 0
                if (!f) {
                  if (c[ga >> 2] | 0) {
                    gW(b, e, c[ja >> 2] | 0, c[ea >> 2] | 0)
                  }
                } else {
                  j = c[n + 16 >> 2] | 0
                  m = n + 12 | 0
                  if ((j | 0) != 0 & (a[R >> 0] | 0) != 0) {
                    f = (c[m >> 2] | 0) + (c[n + 28 >> 2] | 0) | 0
                    while (1) {
                      k = a[j >> 0] | 0
                      if (!(k << 24 >> 24)) {
                        break
                      }
                      a[f >> 0] = k
                      f = f + 1 | 0
                      j = j + 1 | 0
                    }
                    j = c[n + 20 >> 2] | 0
                    c:do {
                      if ((j | 0) != 0 & (a[S >> 0] | 0) != 0) {
                        a[f >> 0] = a[T >> 0] | 0
                        while (1) {
                          f = f + 1 | 0
                          k = a[j >> 0] | 0
                          if (!(k << 24 >> 24)) {
                            break c
                          }
                          a[f >> 0] = k
                          j = j + 1 | 0
                        }
                      }
                    } while (0)
                    a[f >> 0] = 0
                    f = c[Q >> 2] | 0
                  }
                  ub[f & 63](c[ha >> 2] | 0, c[m >> 2] | 0)
                }
                k = n + 44 | 0
                while (1) {
                  m = c[k >> 2] | 0
                  if (!m) {
                    break
                  }
                  f = c[U >> 2] | 0
                  if (!f) {
                    f = m
                    j = m
                  } else {
                    ub[f & 63](c[ha >> 2] | 0, c[c[m >> 2] >> 2] | 0)
                    f = m
                    j = c[k >> 2] | 0
                  }
                  c[k >> 2] = c[j + 4 >> 2]
                  c[m + 4 >> 2] = c[V >> 2]
                  c[V >> 2] = m
                  c[(c[f >> 2] | 0) + 4 >> 2] = c[m + 8 >> 2]
                }
                if (!(c[ia >> 2] | 0)) {
                  la = 117
                  break a
                }
                break
              }
              case 10: {
                f = lb[c[W >> 2] & 127](e, c[ja >> 2] | 0) | 0
                if ((f | 0) < 0) {
                  f = 14
                  break a
                }
                j = c[$ >> 2] | 0
                if (j | 0) {
                  s = c[ha >> 2] | 0
                  na = fX(f, ka) | 0
                  vb[j & 127](s, ka, na)
                  break b
                }
                if (c[ga >> 2] | 0) {
                  gW(b, e, c[ja >> 2] | 0, c[ea >> 2] | 0)
                }
                break
              }
              case 7: {
                f = c[$ >> 2] | 0
                if (f | 0) {
                  a[ka >> 0] = 10
                  vb[f & 127](c[ha >> 2] | 0, ka, 1)
                  break b
                }
                if (c[ga >> 2] | 0) {
                  gW(b, e, c[ja >> 2] | 0, k)
                }
                break
              }
              case 8: {
                f = c[X >> 2] | 0
                if (!f) {
                  if (c[ga >> 2] | 0) {
                    gW(b, e, c[ja >> 2] | 0, k)
                  }
                } else {
                  tb[f & 127](c[ha >> 2] | 0)
                }
                f = wW(b, e, ea, g, h, i) | 0
                if (f | 0) {
                  break a
                }
                if (!(c[ea >> 2] | 0)) {
                  la = 133
                  break a
                }
                break
              }
              case 6: {
                j = c[$ >> 2] | 0
                if (!j) {
                  if (!(c[ga >> 2] | 0)) {
                    break b
                  }
                  gW(b, e, c[ja >> 2] | 0, k)
                  break b
                }
                if (!(a[ba >> 0] | 0)) {
                  f = k
                } else {
                  na = c[ja >> 2] | 0
                  vb[j & 127](c[ha >> 2] | 0, na, f - na | 0)
                  break b
                }
                while (1) {
                  c[ka >> 2] = c[ca >> 2]
                  na = pb[c[aa >> 2] & 127](e, ja, f, ka, c[da >> 2] | 0) | 0
                  c[Y >> 2] = c[ja >> 2]
                  s = c[ca >> 2] | 0
                  vb[j & 127](c[ha >> 2] | 0, s, (c[ka >> 2] | 0) - s | 0)
                  if (na >>> 0 < 2) {
                    break
                  }
                  c[fa >> 2] = c[ja >> 2]
                  f = c[ea >> 2] | 0
                }
                break
              }
              case 11: {
                if (!(mW(b, e, c[ja >> 2] | 0, k) | 0)) {
                  f = 1
                  break a
                }
                break
              }
              case 13: {
                if (!(nW(b, e, c[ja >> 2] | 0, k) | 0)) {
                  f = 1
                  break a
                }
                break
              }
              default:
                if (c[ga >> 2] | 0) {
                  gW(b, e, c[ja >> 2] | 0, k)
                }
            }
          } while (0)
          na = c[ea >> 2] | 0
          c[ja >> 2] = na
          c[fa >> 2] = na
          switch (c[u >> 2] | 0) {
            case 2: {
              f = 35
              break a
            }
            case 3: {
              la = 160
              break a
            }
            default: {
            }
          }
        }
        switch (la | 0) {
          case 6: {
            if (i << 24 >> 24) {
              c[h >> 2] = c[ja >> 2]
              f = 0
              break
            }
            c[Y >> 2] = g
            f = c[$ >> 2] | 0
            if (!f) {
              if (c[ga >> 2] | 0) {
                gW(b, e, c[ja >> 2] | 0, g)
              }
            } else {
              a[ka >> 0] = 10
              vb[f & 127](c[ha >> 2] | 0, ka, 1)
            }
            if (d) {
              if ((c[ia >> 2] | 0) == (d | 0)) {
                c[h >> 2] = g
                f = 0
              } else {
                f = 13
              }
            } else {
              f = 3
            }
            break
          }
          case 15: {
            if (i << 24 >> 24) {
              c[h >> 2] = c[ja >> 2]
              f = 0
              break
            }
            if ((d | 0) > 0) {
              if ((c[ia >> 2] | 0) == (d | 0)) {
                c[h >> 2] = c[ja >> 2]
                f = 0
              } else {
                f = 13
              }
            } else {
              f = 3
            }
            break
          }
          case 20: {
            c[fa >> 2] = f
            f = 4
            break
          }
          case 21: {
            if (!(i << 24 >> 24)) {
              f = 5
            } else {
              c[h >> 2] = c[ja >> 2]
              f = 0
            }
            break
          }
          case 23: {
            if (!(i << 24 >> 24)) {
              f = 6
            } else {
              c[h >> 2] = c[ja >> 2]
              f = 0
            }
            break
          }
          case 56:
            break
          case 58:
            break
          case 63: {
            tb[c[b + 20 >> 2] & 127](f)
            f = 1
            la = 75
            break
          }
          case 69: {
            f = 1
            la = 75
            break
          }
          case 79: {
            uW(b, c[ka >> 2] | 0)
            la = 89
            break
          }
          case 92: {
            f = vW(b, c[ea >> 2] | 0, g, h) | 0
            break
          }
          case 96: {
            c[fa >> 2] = f
            f = 7
            break
          }
          case 117: {
            f = vW(b, c[ea >> 2] | 0, g, h) | 0
            break
          }
          case 133: {
            c[b + 276 >> 2] = 61
            f = 0
            break
          }
          case 134: {
            if (i << 24 >> 24) {
              c[h >> 2] = c[ja >> 2]
              f = 0
              break
            }
            f = c[$ >> 2] | 0
            do {
              if (!f) {
                if (c[ga >> 2] | 0) {
                  gW(b, e, c[ja >> 2] | 0, g)
                }
              } else if (!(a[ba >> 0] | 0)) {
                c[ka >> 2] = c[ca >> 2]
                pb[c[aa >> 2] & 127](e, ja, g, ka, c[da >> 2] | 0) | 0
                na = c[ca >> 2] | 0
                vb[c[$ >> 2] & 127](c[ha >> 2] | 0, na, (c[ka >> 2] | 0) - na | 0)
                break
              } else {
                na = c[ja >> 2] | 0
                vb[f & 127](c[ha >> 2] | 0, na, g - na | 0)
                break
              }
            } while (0)
            if (!d) {
              c[fa >> 2] = g
              f = 3
              break
            }
            if ((c[ia >> 2] | 0) == (d | 0)) {
              c[h >> 2] = g
              f = 0
              break
            } else {
              c[fa >> 2] = g
              f = 13
              break
            }
          }
          case 160: {
            c[h >> 2] = c[ea >> 2]
            f = 0
            break
          }
        }
        l = ma
        return f | 0
      }

      function rW(b, d, e, f) {
        b = b | 0
        d = d | 0
        e = e | 0
        f = f | 0
        var g = 0, h = 0, i = 0, j = 0, k = 0, m = 0, n = 0, o = 0, p = 0, q = 0, r = 0, s = 0
        q = l
        l = l + 16 | 0
        p = q
        k = b + 296 | 0
        m = c[k >> 2] | 0
        do {
          if (m) {
            n = c[m + 12 >> 2] | 0
            h = n + 4 | 0
            j = c[h >> 2] | 0
            i = n + 12 | 0
            g = j + (c[i >> 2] | 0) | 0
            j = j + (c[n + 8 >> 2] | 0) | 0
            c[p >> 2] = g
            o = n + 33 | 0
            if (!(a[o >> 0] | 0)) {
              g = qW(b, c[m + 16 >> 2] | 0, c[b + 224 >> 2] | 0, g, j, p, 0) | 0
            } else {
              s = b + 224 | 0
              r = c[s >> 2] | 0
              r = ob[c[r >> 2] & 127](r, g, j, p) | 0
              g = TV(b, c[s >> 2] | 0, g, j, r, c[p >> 2] | 0, p, 0) | 0
            }
            if (!g) {
              g = c[p >> 2] | 0
              if ((j | 0) != (g | 0) ? (c[b + 476 >> 2] | 0) == 3 : 0) {
                c[i >> 2] = g - (c[h >> 2] | 0)
                g = 0
                break
              }
              a[n + 32 >> 0] = 0
              s = m + 8 | 0
              c[k >> 2] = c[s >> 2]
              g = b + 300 | 0
              c[s >> 2] = c[g >> 2]
              c[g >> 2] = m
              g = b + 276 | 0
              if (!(a[o >> 0] | 0)) {
                c[g >> 2] = 58
                g = qW(b, (c[b + 472 >> 2] | 0) != 0 & 1, c[b + 144 >> 2] | 0, d, e, f, (a[b + 480 >> 0] | 0) == 0 & 1)
                    | 0
                break
              } else {
                c[g >> 2] = 57
                s = b + 144 | 0
                g = c[s >> 2] | 0
                g = ob[c[g >> 2] & 127](g, d, e, p) | 0
                g = TV(b, c[s >> 2] | 0, d, e, g, c[p >> 2] | 0, f, (a[b + 480 >> 0] | 0) == 0 & 1) | 0
                break
              }
            }
          } else {
            g = 23
          }
        } while (0)
        l = q
        return g | 0
      }

      function sW(b) {
        b = b | 0
        var d = 0, e = 0, f = 0, g = 0, h = 0, i = 0, j = 0, k = 0, m = 0, n = 0, o = 0, p = 0, q = 0
        q = l
        l = l + 16 | 0
        n = q
        m = c[b + 352 >> 2] | 0
        h = m + 156 | 0
        o = b + 412 | 0
        p = b + 424 | 0
        a:do {
          if (!(c[h >> 2] | 0)) {
            d = 0
            i = b + 420 | 0
            k = b + 468 | 0
            j = 12
          } else {
            d = c[p >> 2] | 0
            i = b + 420 | 0
            if ((d | 0) == (c[i >> 2] | 0)) {
              if (!((dW(o) | 0) << 24 >> 24)) {
                d = 0
                break
              }
              d = c[p >> 2] | 0
            }
            c[p >> 2] = d + 1
            a[d >> 0] = 61
            g = b + 468 | 0
            e = (c[(c[h >> 2] | 0) + 20 >> 2] | 0) + (((a[g >> 0] | 0) != 0) << 31 >> 31) | 0
            f = 0
            while (1) {
              if ((f | 0) >= (e | 0)) {
                d = 1
                k = g
                j = 12
                break a
              }
              d = c[p >> 2] | 0
              if ((d | 0) == (c[i >> 2] | 0)) {
                if (!((dW(o) | 0) << 24 >> 24)) {
                  d = 0
                  break a
                }
                d = c[p >> 2] | 0
              }
              k = a[(c[(c[h >> 2] | 0) + 16 >> 2] | 0) + f >> 0] | 0
              c[p >> 2] = d + 1
              a[d >> 0] = k
              f = f + 1 | 0
            }
          }
        } while (0)
        b:do {
          if ((j | 0) == 12) {
            MV(n, m + 60 | 0)
            c:while (1) {
              do {
                e = NV(n) | 0
                if (!e) {
                  break c
                }
                h = e + 4 | 0
              } while (!(c[h >> 2] | 0))
              if (d << 24 >> 24) {
                d = c[p >> 2] | 0
                if ((d | 0) == (c[i >> 2] | 0)) {
                  if (!((dW(o) | 0) << 24 >> 24)) {
                    d = 0
                    break b
                  }
                  d = c[p >> 2] | 0
                }
                c[p >> 2] = d + 1
                a[d >> 0] = 12
              }
              g = c[e >> 2] | 0
              while (1) {
                e = a[g >> 0] | 0
                d = c[p >> 2] | 0
                f = (d | 0) == (c[i >> 2] | 0)
                if (!(e << 24 >> 24)) {
                  break
                }
                if (f) {
                  if (!((dW(o) | 0) << 24 >> 24)) {
                    d = 0
                    break b
                  }
                  d = c[p >> 2] | 0
                  e = a[g >> 0] | 0
                }
                c[p >> 2] = d + 1
                a[d >> 0] = e
                g = g + 1 | 0
              }
              if (f) {
                if (!((dW(o) | 0) << 24 >> 24)) {
                  d = 0
                  break b
                }
                d = c[p >> 2] | 0
              }
              c[p >> 2] = d + 1
              a[d >> 0] = 61
              f = (c[(c[h >> 2] | 0) + 20 >> 2] | 0) + (((a[k >> 0] | 0) != 0) << 31 >> 31) | 0
              e = 0
              while (1) {
                if ((e | 0) >= (f | 0)) {
                  d = 1
                  continue c
                }
                d = c[p >> 2] | 0
                if ((d | 0) == (c[i >> 2] | 0)) {
                  if (!((dW(o) | 0) << 24 >> 24)) {
                    d = 0
                    break b
                  }
                  d = c[p >> 2] | 0
                }
                j = a[(c[(c[h >> 2] | 0) + 16 >> 2] | 0) + e >> 0] | 0
                c[p >> 2] = d + 1
                a[d >> 0] = j
                e = e + 1 | 0
              }
            }
            MV(n, m)
            d:while (1) {
              do {
                e = NV(n) | 0
                if (!e) {
                  break d
                }
              } while (!(a[e + 32 >> 0] | 0))
              if (d << 24 >> 24) {
                d = c[p >> 2] | 0
                if ((d | 0) == (c[i >> 2] | 0)) {
                  if (!((dW(o) | 0) << 24 >> 24)) {
                    d = 0
                    break b
                  }
                  d = c[p >> 2] | 0
                }
                c[p >> 2] = d + 1
                a[d >> 0] = 12
              }
              f = c[e >> 2] | 0
              while (1) {
                e = a[f >> 0] | 0
                if (!(e << 24 >> 24)) {
                  d = 1
                  continue d
                }
                d = c[p >> 2] | 0
                if ((d | 0) == (c[i >> 2] | 0)) {
                  if (!((dW(o) | 0) << 24 >> 24)) {
                    d = 0
                    break b
                  }
                  d = c[p >> 2] | 0
                  e = a[f >> 0] | 0
                }
                c[p >> 2] = d + 1
                a[d >> 0] = e
                f = f + 1 | 0
              }
            }
            d = c[p >> 2] | 0
            if ((d | 0) == (c[i >> 2] | 0)) {
              if (!((dW(o) | 0) << 24 >> 24)) {
                d = 0
                break
              }
              d = c[p >> 2] | 0
            }
            c[p >> 2] = d + 1
            a[d >> 0] = 0
            d = c[b + 428 >> 2] | 0
          }
        } while (0)
        l = q
        return d | 0
      }

      function tW(b, e, f, g, h) {
        b = b | 0
        e = e | 0
        f = f | 0
        g = g | 0
        h = h | 0
        var i = 0, j = 0, k = 0, m = 0, n = 0, o = 0, p = 0, q = 0, r = 0, s = 0, t = 0, u = 0, v = 0, w = 0, x = 0,
            y = 0, z = 0, A = 0, B = 0, C = 0, D = 0, E = 0, F = 0, G = 0, H = 0, I = 0, J = 0, K = 0, L = 0, M = 0,
            N = 0, O = 0, P = 0
        O = l
        l = l + 80 | 0
        K = O + 16 | 0
        L = O
        M = c[b + 352 >> 2] | 0
        k = M + 20 | 0
        i = XV(b, k, c[g >> 2] | 0, 0) | 0
        if (!i) {
          i = AW(M + 80 | 0, c[g >> 2] | 0) | 0
          if ((i | 0) != 0 ? (j = XV(b, k, i, 24) | 0, (j | 0) != 0) : 0) {
            if ((a[b + 232 >> 0] | 0) != 0 ? (BW(b, j)
                | 0) == 0 : 0) {
              i = 1
            } else {
              A = 6
            }
          } else {
            i = 1
          }
        } else {
          j = i
          A = 6
        }
        a:do {
          if ((A | 0) == 6) {
            x = c[j + 12 >> 2] | 0
            k = e + 36 | 0
            m = b + 376 | 0
            t = b + 388 | 0
            u = ob[c[k >> 2] & 127](e, f, c[m >> 2] | 0, c[t >> 2] | 0) | 0
            i = u + x | 0
            n = c[m >> 2] | 0
            if ((i | 0) > (n | 0)) {
              i = i + 16 | 0
              c[m >> 2] = i
              i = lb[c[b + 16 >> 2] & 127](c[t >> 2] | 0, i << 4) | 0
              if (!i) {
                c[m >> 2] = n
                i = 1
                break
              }
              c[t >> 2] = i
              if ((u | 0) > (n | 0)) {
                ob[c[k >> 2] & 127](e, f, u, i) | 0
              }
            }
            J = c[t >> 2] | 0
            r = e + 28 | 0
            H = b + 412 | 0
            I = b + 428 | 0
            w = j + 20 | 0
            q = b + 424 | 0
            s = 0
            p = 0
            k = 0
            while (1) {
              if ((p | 0) >= (u | 0)) {
                break
              }
              o = c[(c[t >> 2] | 0) + (p << 4) >> 2] | 0
              o = $V(b, e, o, o + (lb[c[r >> 2] & 127](e, o) | 0) | 0) | 0
              if (!o) {
                i = 1
                break a
              }
              i = (c[o >> 2] | 0) + -1 | 0
              if (a[i >> 0] | 0) {
                A = 15
                break
              }
              a[i >> 0] = 1
              f = s + 1 | 0
              c[J + (s << 2) >> 2] = c[o >> 2]
              n = c[t >> 2] | 0
              if (a[n + (p << 4) + 12 >> 0] | 0) {
                G = VV(H, e, c[n + (p << 4) + 4 >> 2] | 0, c[n + (p << 4) + 8 >> 2] | 0) | 0
                c[J + (f << 2) >> 2] = G
                if (!G) {
                  i = 1
                  break a
                }
              } else {
                b:do {
                  if (!(a[o + 8 >> 0] | 0)) {
                    i = 1
                  } else {
                    i = 0
                    while (1) {
                      if ((i | 0) >= (x | 0)) {
                        i = 1
                        break b
                      }
                      m = c[w >> 2] | 0
                      if ((o | 0) == (c[m + (i * 12 | 0) >> 2] | 0)) {
                        break
                      }
                      i = i + 1 | 0
                    }
                    i = a[m + (i * 12 | 0) + 4 >> 0] | 0
                  }
                } while (0)
                i = eW(b, e, i, c[n + (p << 4) + 4 >> 2] | 0, c[n + (p << 4) + 8 >> 2] | 0, H) | 0
                if (i | 0) {
                  break a
                }
                c[J + (f << 2) >> 2] = c[I >> 2]
              }
              c[I >> 2] = c[q >> 2]
              i = c[o + 4 >> 2] | 0
              do {
                if (i) {
                  if (a[o + 9 >> 0] | 0) {
                    i = CW(b, i, o, c[J + (f << 2) >> 2] | 0, h) | 0
                    if (!i) {
                      i = s
                      break
                    } else {
                      break a
                    }
                  } else {
                    a[(c[o >> 2] | 0) + -1 >> 0] = 2
                    k = k + 1 | 0
                    i = s + 2 | 0
                    break
                  }
                } else {
                  i = s + 2 | 0
                }
              } while (0)
              s = i
              p = p + 1 | 0
            }
            if ((A | 0) == 15) {
              if ((c[b + 144 >> 2] | 0) != (e | 0)) {
                i = 8
                break
              }
              c[b + 284 >> 2] = c[(c[t >> 2] | 0) + (p << 4) >> 2]
              i = 8
              break
            }
            c[b + 380 >> 2] = s
            i = c[j + 8 >> 2] | 0
            c:do {
              if ((i | 0) != 0 ? (v = c[i >> 2] | 0, (a[v + -1 >> 0] | 0) != 0) : 0) {
                i = 0
                while (1) {
                  if ((i | 0) >= (s | 0)) {
                    f = 0
                    p = k
                    G = s
                    break c
                  }
                  if ((c[J + (i << 2) >> 2] | 0) == (v | 0)) {
                    A = 37
                    break c
                  }
                  i = i + 2 | 0
                }
              } else {
                i = -1
                A = 37
              }
            } while (0)
            if ((A | 0) == 37) {
              c[b + 384 >> 2] = i
              f = 0
              p = k
              G = s
            }
            while (1) {
              if ((f | 0) >= (x | 0)) {
                break
              }
              i = c[w >> 2] | 0
              n = i + (f * 12 | 0) | 0
              k = c[n >> 2] | 0
              m = (c[k >> 2] | 0) + -1 | 0
              d:do {
                if ((a[m >> 0] | 0) == 0 ? (y = i + (f * 12 | 0) + 8 | 0, z = c[y >> 2] | 0, (z | 0) != 0) : 0) {
                  i = c[k + 4 >> 2] | 0
                  do {
                    if (i) {
                      if (a[k + 9 >> 0] | 0) {
                        i = CW(b, i, k, z, h) | 0
                        if (!i) {
                          i = p
                          k = G
                          break d
                        } else {
                          break a
                        }
                      } else {
                        a[m >> 0] = 2
                        i = p + 1 | 0
                        break
                      }
                    } else {
                      a[m >> 0] = 1
                      i = p
                    }
                  } while (0)
                  c[J + (G << 2) >> 2] = c[c[n >> 2] >> 2]
                  c[J + (G + 1 << 2) >> 2] = c[y >> 2]
                  k = G + 2 | 0
                } else {
                  i = p
                  k = G
                }
              } while (0)
              f = f + 1 | 0
              p = i
              G = k
            }
            c[J + (G << 2) >> 2] = 0
            e:do {
              if (!p) {
                i = 0
              } else {
                o = b + 396 | 0
                n = c[o >> 2] | 0
                F = b + 400 | 0
                f = a[F >> 0] | 0
                i = f & 255
                do {
                  if (!(p << 1 >> i)) {
                    i = 1 << i
                    m = b + 392 | 0
                    if (!n) {
                      k = i
                      A = 55
                    } else {
                      k = i
                      i = n
                    }
                  } else {
                    i = f
                    do {
                      E = i
                      i = i + 1 << 24 >> 24
                    } while ((p >> (E & 255) | 0) != 0)
                    i = (i & 255) > 3 ? i : 3
                    a[F >> 0] = i
                    i = i & 255
                    m = b + 392 | 0
                    k = lb[c[b + 16 >> 2] & 127](c[m >> 2] | 0, 12 << i) | 0
                    if (!k) {
                      a[F >> 0] = f
                      i = 1
                      break a
                    } else {
                      c[m >> 2] = k
                      k = 1 << i
                      A = 55
                      break
                    }
                  }
                } while (0)
                f:do {
                  if ((A | 0) == 55) {
                    i = k
                    while (1) {
                      if (!i) {
                        i = -1
                        break f
                      }
                      E = i + -1 | 0
                      c[(c[m >> 2] | 0) + (E * 12 | 0) >> 2] = -1
                      i = E
                    }
                  }
                } while (0)
                E = i + -1 | 0
                c[o >> 2] = E
                w = M + 40 | 0
                x = b + 424 | 0
                y = b + 420 | 0
                z = k + -1 | 0
                A = 0 - k | 0
                B = z >>> 2
                C = b + 233 | 0
                D = b + 468 | 0
                i = 0
                v = p
                g:while (1) {
                  while (1) {
                    if ((i | 0) >= (G | 0)) {
                      break e
                    }
                    e = J + (i << 2) | 0
                    n = c[e >> 2] | 0
                    f = n + -1 | 0
                    if ((a[f >> 0] | 0) == 2) {
                      break
                    }
                    a[f >> 0] = 0
                    i = i + 2 | 0
                  }
                  DW(b, L)
                  EW(K, L)
                  a[f >> 0] = 0
                  f = XV(b, w, n, 0) | 0
                  if (!f) {
                    i = 1
                    break
                  }
                  f = c[f + 4 >> 2] | 0
                  if (!f) {
                    i = 1
                    break
                  }
                  u = c[f + 4 >> 2] | 0
                  if (!u) {
                    i = 27
                    break
                  }
                  q = u + 20 | 0
                  r = u + 16 | 0
                  p = 0
                  while (1) {
                    f = c[q >> 2] | 0
                    o = c[r >> 2] | 0
                    if ((p | 0) >= (f | 0)) {
                      break
                    }
                    o = a[o + p >> 0] | 0
                    f = c[x >> 2] | 0
                    if ((f | 0) == (c[y >> 2] | 0)) {
                      if (!((dW(H) | 0) << 24 >> 24)) {
                        i = 1
                        break g
                      }
                      f = c[x >> 2] | 0
                    }
                    c[x >> 2] = f + 1
                    a[f >> 0] = o
                    p = p + 1 | 0
                  }
                  FW(K, o, f)
                  do {
                    t = n
                    n = n + 1 | 0
                  } while ((a[t >> 0] | 0) != 58)
                  FW(K, n, GW(n) | 0)
                  while (1) {
                    f = c[x >> 2] | 0
                    if ((f | 0) == (c[y >> 2] | 0)) {
                      if (!((dW(H) | 0) << 24 >> 24)) {
                        i = 1
                        break g
                      }
                      f = c[x >> 2] | 0
                    }
                    t = a[n >> 0] | 0
                    c[x >> 2] = f + 1
                    a[f >> 0] = t
                    if (!(a[n >> 0] | 0)) {
                      break
                    } else {
                      n = n + 1 | 0
                    }
                  }
                  t = HW(K) | 0
                  q = c[m >> 2] | 0
                  r = t & A
                  n = 0
                  s = z & t
                  while (1) {
                    if ((c[q + (s * 12 | 0) >> 2] | 0) != (E | 0)) {
                      break
                    }
                    if ((c[q + (s * 12 | 0) + 4 >> 2] | 0) == (t | 0)) {
                      f = c[q + (s * 12 | 0) + 8 >> 2] | 0
                      o = c[I >> 2] | 0
                      while (1) {
                        P = a[o >> 0] | 0
                        p = P << 24 >> 24 == 0
                        if (p | P << 24 >> 24 != (a[f >> 0] | 0)) {
                          break
                        }
                        f = f + 1 | 0
                        o = o + 1 | 0
                      }
                      if (p) {
                        i = 8
                        break g
                      }
                    }
                    if (!(n << 24 >> 24)) {
                      n = (r >>> ((d[F >> 0] | 0) + -1 | 0) & B | 1) & 255
                    }
                    P = n & 255
                    s = s + ((s | 0) < (P | 0) ? k : 0) - P | 0
                  }
                  if (a[C >> 0] | 0) {
                    a[(c[x >> 2] | 0) + -1 >> 0] = a[D >> 0] | 0
                    f = c[c[u >> 2] >> 2] | 0
                    while (1) {
                      n = c[x >> 2] | 0
                      if ((n | 0) == (c[y >> 2] | 0)) {
                        if (!((dW(H) | 0) << 24 >> 24)) {
                          i = 1
                          break g
                        }
                        n = c[x >> 2] | 0
                      }
                      P = a[f >> 0] | 0
                      c[x >> 2] = n + 1
                      a[n >> 0] = P
                      if (!(a[f >> 0] | 0)) {
                        break
                      } else {
                        f = f + 1 | 0
                      }
                    }
                  }
                  P = c[I >> 2] | 0
                  c[I >> 2] = c[x >> 2]
                  c[e >> 2] = P
                  c[(c[m >> 2] | 0) + (s * 12 | 0) >> 2] = E
                  c[(c[m >> 2] | 0) + (s * 12 | 0) + 4 >> 2] = t
                  c[(c[m >> 2] | 0) + (s * 12 | 0) + 8 >> 2] = P
                  v = v + -1 | 0
                  i = i + 2 | 0
                  if (!v) {
                    break e
                  }
                }
                break a
              }
            } while (0)
            while (1) {
              if ((i | 0) >= (G | 0)) {
                i = h
                break
              }
              a[(c[J + (i << 2) >> 2] | 0) + -1 >> 0] = 0
              i = i + 2 | 0
            }
            while (1) {
              i = c[i >> 2] | 0
              if (!i) {
                break
              }
              a[(c[c[i + 12 >> 2] >> 2] | 0) + -1 >> 0] = 0
              i = i + 4 | 0
            }
            if (!(a[b + 232 >> 0] | 0)) {
              i = 0
            } else {
              i = c[j + 4 >> 2] | 0
              if (!i) {
                i = c[M + 156 >> 2] | 0
                if (!i) {
                  i = 0
                  break
                }
                k = c[g >> 2] | 0
              } else {
                i = c[i + 4 >> 2] | 0
                if (!i) {
                  i = 27
                  break
                }
                j = c[g >> 2] | 0
                while (1) {
                  k = j + 1 | 0
                  if ((a[j >> 0] | 0) == 58) {
                    break
                  } else {
                    j = k
                  }
                }
              }
              if ((a[b + 233 >> 0] | 0) != 0 ? (N = c[c[i >> 2] >> 2] | 0, (N | 0) != 0) : 0) {
                j = 0
                while (1) {
                  m = j + 1 | 0
                  if (!(a[N + j >> 0] | 0)) {
                    break
                  } else {
                    j = m
                  }
                }
              } else {
                m = 0
              }
              c[g + 4 >> 2] = k
              p = i + 20 | 0
              c[g + 16 >> 2] = c[p >> 2]
              c[g + 8 >> 2] = c[c[i >> 2] >> 2]
              c[g + 20 >> 2] = m
              q = 0
              while (1) {
                r = q + 1 | 0
                if (!(a[k + q >> 0] | 0)) {
                  break
                } else {
                  q = r
                }
              }
              j = c[p >> 2] | 0
              n = r + m + j | 0
              f = i + 24 | 0
              if ((n | 0) > (c[f >> 2] | 0)) {
                j = n + 24 | 0
                o = kb[c[b + 12 >> 2] & 63](j) | 0
                if (!o) {
                  i = 1
                  break
                }
                c[f >> 2] = j
                f = i + 16 | 0
                E3(o | 0, c[f >> 2] | 0, c[p >> 2] | 0) | 0
                j = b + 360 | 0
                while (1) {
                  j = c[j >> 2] | 0
                  if (!j) {
                    break
                  }
                  n = j + 12 | 0
                  if ((c[n >> 2] | 0) == (c[f >> 2] | 0)) {
                    c[n >> 2] = o
                  }
                }
                tb[c[b + 20 >> 2] & 127](c[f >> 2] | 0)
                c[f >> 2] = o
                n = o
                j = c[p >> 2] | 0
              } else {
                n = i + 16 | 0
                f = n
                n = c[n >> 2] | 0
              }
              j = n + j | 0
              E3(j | 0, k | 0, r | 0) | 0
              if (m | 0) {
                P = j + q | 0
                a[P >> 0] = a[b + 468 >> 0] | 0
                E3(P + 1 | 0, c[c[i >> 2] >> 2] | 0, m | 0) | 0
              }
              c[g >> 2] = c[f >> 2]
              i = 0
            }
          }
        } while (0)
        l = O
        return i | 0
      }

      function uW(a, b) {
        a = a | 0
        b = b | 0
        var d = 0, e = 0, f = 0, g = 0, h = 0
        e = a + 104 | 0
        f = a + 372 | 0
        d = a + 4 | 0
        while (1) {
          if (!b) {
            break
          }
          a = c[e >> 2] | 0
          if (!a) {
            a = b
          } else {
            ub[a & 63](c[d >> 2] | 0, c[c[b >> 2] >> 2] | 0)
            a = b
          }
          h = b + 4 | 0
          g = c[h >> 2] | 0
          c[h >> 2] = c[f >> 2]
          c[f >> 2] = b
          c[(c[a >> 2] | 0) + 4 >> 2] = c[b + 8 >> 2]
          b = g
        }
        return
      }

      function vW(b, d, e, f) {
        b = b | 0
        d = d | 0
        e = e | 0
        f = f | 0
        var g = 0, h = 0, i = 0, j = 0, k = 0, m = 0, n = 0, o = 0, p = 0, q = 0, r = 0
        q = l
        l = l + 16 | 0
        j = q
        c[b + 276 >> 2] = 62
        k = b + 284 | 0
        c[k >> 2] = d
        m = b + 144 | 0
        n = b + 288 | 0
        o = b + 80 | 0
        i = b + 476 | 0
        g = d
        a:while (1) {
          c[j >> 2] = 0
          r = c[m >> 2] | 0
          r = ob[c[r >> 2] & 127](r, g, e, j) | 0
          d = c[j >> 2] | 0
          c[n >> 2] = d
          h = d
          switch (r | 0) {
            case -15: {
              p = 3
              break a
            }
            case -4: {
              p = 7
              break a
            }
            case 0: {
              p = 12
              break a
            }
            case -1: {
              p = 13
              break a
            }
            case -2: {
              p = 15
              break a
            }
            case 15: {
              if (c[o >> 2] | 0) {
                gW(b, c[m >> 2] | 0, g, h)
              }
              break
            }
            case 11: {
              if (!(mW(b, c[m >> 2] | 0, g, h) | 0)) {
                d = 1
                break a
              }
              break
            }
            case 13: {
              if (!(nW(b, c[m >> 2] | 0, g, h) | 0)) {
                d = 1
                break a
              }
              break
            }
            default: {
              d = 9
              break a
            }
          }
          d = c[j >> 2] | 0
          c[k >> 2] = d
          switch (c[i >> 2] | 0) {
            case 2: {
              d = 35
              break a
            }
            case 3: {
              p = 18
              break a
            }
            default: {
            }
          }
          g = d
        }
        do {
          if ((p | 0) == 3) {
            if (c[o >> 2] | 0) {
              gW(b, c[m >> 2] | 0, g, h)
              if ((c[i >> 2] | 0) == 2) {
                d = 35
                break
              }
              d = c[j >> 2] | 0
            }
            c[f >> 2] = d
            d = 0
          } else if ((p | 0) == 7) {
            c[f >> 2] = g
            d = 0
          } else if ((p | 0) == 12) {
            c[k >> 2] = d
            d = 4
          } else if ((p | 0) == 13) {
            if (!(a[b + 480 >> 0] | 0)) {
              c[f >> 2] = g
              d = 0
            } else {
              d = 5
            }
          } else if ((p | 0) == 15) {
            if (!(a[b + 480 >> 0] | 0)) {
              c[f >> 2] = g
              d = 0
            } else {
              d = 6
            }
          } else if ((p | 0) == 18) {
            c[f >> 2] = d
            d = 0
          }
        } while (0)
        l = q
        return d | 0
      }

      function wW(b, d, e, f, g, h) {
        b = b | 0
        d = d | 0
        e = e | 0
        f = f | 0
        g = g | 0
        h = h | 0
        var i = 0, j = 0, k = 0, m = 0, n = 0, o = 0, p = 0, q = 0, r = 0, s = 0, t = 0, u = 0, v = 0, w = 0, x = 0,
            y = 0, z = 0, A = 0, B = 0
        B = l
        l = l + 16 | 0
        y = B + 8 | 0
        z = B + 4 | 0
        x = B
        i = c[e >> 2] | 0
        c[y >> 2] = i
        if ((c[b + 144 >> 2] | 0) == (d | 0)) {
          s = b + 284 | 0
          c[s >> 2] = i
          t = b + 288 | 0
        } else {
          t = c[b + 296 >> 2] | 0
          s = t
          t = t + 4 | 0
        }
        c[s >> 2] = i
        c[e >> 2] = 0
        k = d + 8 | 0
        m = b + 60 | 0
        u = b + 80 | 0
        v = b + 4 | 0
        w = b + 476 | 0
        n = d + 68 | 0
        o = b + 44 | 0
        p = d + 56 | 0
        q = b + 48 | 0
        a:while (1) {
          j = ob[c[k >> 2] & 127](d, c[y >> 2] | 0, f, z) | 0
          i = c[z >> 2] | 0
          c[t >> 2] = i
          r = i
          b:do {
            switch (j | 0) {
              case 40: {
                A = 6
                break a
              }
              case 0: {
                A = 23
                break a
              }
              case -2: {
                A = 24
                break a
              }
              case -4:
              case -1: {
                A = 26
                break a
              }
              case 7: {
                i = c[m >> 2] | 0
                if (i | 0) {
                  a[x >> 0] = 10
                  vb[i & 127](c[v >> 2] | 0, x, 1)
                  break b
                }
                if (c[u >> 2] | 0) {
                  gW(b, d, c[y >> 2] | 0, r)
                }
                break
              }
              case 6: {
                j = c[m >> 2] | 0
                if (!j) {
                  if (!(c[u >> 2] | 0)) {
                    break b
                  }
                  gW(b, d, c[y >> 2] | 0, r)
                  break b
                }
                if (!(a[n >> 0] | 0)) {
                  i = r
                } else {
                  r = c[y >> 2] | 0
                  vb[j & 127](c[v >> 2] | 0, r, i - r | 0)
                  break b
                }
                while (1) {
                  c[x >> 2] = c[o >> 2]
                  r = pb[c[p >> 2] & 127](d, y, i, x, c[q >> 2] | 0) | 0
                  c[t >> 2] = c[z >> 2]
                  i = c[o >> 2] | 0
                  vb[j & 127](c[v >> 2] | 0, i, (c[x >> 2] | 0) - i | 0)
                  if (r >>> 0 < 2) {
                    break
                  }
                  c[s >> 2] = c[y >> 2]
                  i = c[z >> 2] | 0
                }
                break
              }
              default: {
                A = 28
                break a
              }
            }
          } while (0)
          r = c[z >> 2] | 0
          c[y >> 2] = r
          c[s >> 2] = r
          switch (c[w >> 2] | 0) {
            case 3: {
              A = 30
              break a
            }
            case 2: {
              i = 35
              break a
            }
            default: {
            }
          }
        }
        if ((A | 0) == 6) {
          i = c[b + 76 >> 2] | 0
          if (!i) {
            if (c[u >> 2] | 0) {
              gW(b, d, c[y >> 2] | 0, r)
            }
          } else {
            tb[i & 127](c[v >> 2] | 0)
          }
          i = c[z >> 2] | 0
          c[e >> 2] = i
          c[g >> 2] = i
          i = (c[w >> 2] | 0) == 2 ? 35 : 0
        } else if ((A | 0) == 23) {
          c[s >> 2] = i
          i = 4
        } else if ((A | 0) == 24) {
          if (!(h << 24 >> 24)) {
            i = 6
          } else {
            c[g >> 2] = c[y >> 2]
            i = 0
          }
        } else if ((A | 0) == 26) {
          if (!(h << 24 >> 24)) {
            i = 20
          } else {
            c[g >> 2] = c[y >> 2]
            i = 0
          }
        } else if ((A | 0) == 28) {
          c[s >> 2] = i
          i = 23
        } else if ((A | 0) == 30) {
          c[g >> 2] = c[z >> 2]
          i = 0
        }
        l = B
        return i | 0
      }

      function xW(b, d, e, f) {
        b = b | 0
        d = d | 0
        e = e | 0
        f = f | 0
        var g = 0, h = 0
        h = l
        l = l + 16 | 0
        g = h
        c[g >> 2] = d
        d = wW(b, c[b + 144 >> 2] | 0, g, e, f, (a[b + 480 >> 0] | 0) == 0 & 1) | 0
        g = c[g >> 2] | 0
        do {
          if (!((d | 0) != 0 | (g | 0) == 0)) {
            d = b + 276 | 0
            if (!(c[b + 472 >> 2] | 0)) {
              c[d >> 2] = 58
              d = ZV(b, g, e, f) | 0
              break
            } else {
              c[d >> 2] = 63
              d = yW(b, g, e, f) | 0
              break
            }
          }
        } while (0)
        l = h
        return d | 0
      }

      function yW(b, d, e, f) {
        b = b | 0
        d = d | 0
        e = e | 0
        f = f | 0
        d = qW(b, 1, c[b + 144 >> 2] | 0, d, e, f, (a[b + 480 >> 0] | 0) == 0 & 1) | 0
        if ((d | 0) == 0 ? (zW(b) | 0) << 24 >> 24 == 0 : 0) {
          d = 1
        }
        return d | 0
      }

      function zW(a) {
        a = a | 0
        var b = 0, d = 0, e = 0, f = 0, g = 0, h = 0, i = 0, j = 0, k = 0, l = 0, m = 0
        m = a + 16 | 0
        a = a + 360 | 0
        while (1) {
          a = c[a >> 2] | 0
          if (!a) {
            a = 1
            break
          }
          i = (c[a + 24 >> 2] | 0) + 1 | 0
          j = a + 36 | 0
          f = c[j >> 2] | 0
          e = f + i | 0
          l = a + 4 | 0
          d = c[l >> 2] | 0
          if ((d | 0) == (e | 0)) {
            a = 1
            break
          }
          k = a + 8 | 0
          b = c[k >> 2] | 0
          g = b + i | 0
          h = a + 40 | 0
          if ((g | 0) > ((c[h >> 2] | 0) - f | 0)) {
            e = lb[c[m >> 2] & 127](f, g) | 0
            if (!e) {
              a = 0
              break
            }
            b = a + 12 | 0
            f = c[j >> 2] | 0
            if ((c[b >> 2] | 0) == (f | 0)) {
              c[b >> 2] = e
            }
            b = a + 16 | 0
            d = c[b >> 2] | 0
            if (d | 0) {
              c[b >> 2] = e + (d - f)
            }
            c[j >> 2] = e
            c[h >> 2] = e + g
            e = e + i | 0
            d = c[l >> 2] | 0
            b = c[k >> 2] | 0
          }
          E3(e | 0, d | 0, b | 0) | 0
          c[l >> 2] = e
        }
        return a | 0
      }

      function AW(b, d) {
        b = b | 0
        d = d | 0
        var e = 0, f = 0, g = 0, h = 0, i = 0
        f = b + 12 | 0
        g = b + 8 | 0
        while (1) {
          e = c[f >> 2] | 0
          if ((e | 0) == (c[g >> 2] | 0)) {
            if (!((dW(b) | 0) << 24 >> 24)) {
              d = 0
              break
            }
            e = c[f >> 2] | 0
          }
          i = a[d >> 0] | 0
          c[f >> 2] = e + 1
          a[e >> 0] = i
          if (!(a[d >> 0] | 0)) {
            h = 6
            break
          } else {
            d = d + 1 | 0
          }
        }
        if ((h | 0) == 6) {
          i = b + 16 | 0
          d = c[i >> 2] | 0
          c[i >> 2] = c[f >> 2]
        }
        return d | 0
      }

      function BW(b, d) {
        b = b | 0
        d = d | 0
        var e = 0, f = 0, g = 0, h = 0, i = 0, j = 0, k = 0, l = 0, m = 0, n = 0
        n = c[b + 352 >> 2] | 0
        j = n + 80 | 0
        k = n + 92 | 0
        l = n + 88 | 0
        m = n + 60 | 0
        n = n + 96 | 0
        i = d + 4 | 0
        h = c[d >> 2] | 0
        a:while (1) {
          switch (a[h >> 0] | 0) {
            case 0: {
              e = 1
              break a
            }
            case 58: {
              g = c[d >> 2] | 0
              while (1) {
                e = c[k >> 2] | 0
                f = (e | 0) == (c[l >> 2] | 0)
                if ((g | 0) == (h | 0)) {
                  break
                }
                if (f) {
                  if (!((dW(j) | 0) << 24 >> 24)) {
                    e = 0
                    break a
                  }
                  e = c[k >> 2] | 0
                }
                f = a[g >> 0] | 0
                c[k >> 2] = e + 1
                a[e >> 0] = f
                g = g + 1 | 0
              }
              if (f) {
                if (!((dW(j) | 0) << 24 >> 24)) {
                  e = 0
                  break a
                }
                e = c[k >> 2] | 0
              }
              c[k >> 2] = e + 1
              a[e >> 0] = 0
              e = XV(b, m, c[n >> 2] | 0, 8) | 0
              if (!e) {
                e = 0
                break a
              }
              f = c[n >> 2] | 0
              if ((c[e >> 2] | 0) == (f | 0)) {
                c[n >> 2] = c[k >> 2]
              } else {
                c[k >> 2] = f
              }
              c[i >> 2] = e
              break
            }
            default: {
            }
          }
          h = h + 1 | 0
        }
        return e | 0
      }

      function CW(b, d, e, f, g) {
        b = b | 0
        d = d | 0
        e = e | 0
        f = f | 0
        g = g | 0
        var h = 0, i = 0, j = 0, k = 0, l = 0, m = 0, n = 0, o = 0, p = 0
        k = a[f >> 0] | 0
        i = c[d >> 2] | 0
        h = (i | 0) == 0
        do {
          if (!(k << 24 >> 24)) {
            if (h) {
              m = 0
              j = 11
            } else {
              h = 28
            }
          } else if (((!h ? (a[i >> 0] | 0) == 120 : 0) ? (a[i + 1 >> 0] | 0) == 109 : 0) ? (a[i + 2 >> 0]
              | 0) == 108 : 0) {
            h = a[i + 3 >> 0] | 0
            if ((h << 24 >> 24 == 110 ? (a[i + 4 >> 0] | 0) == 115 : 0) ? (a[i + 5 >> 0] | 0) == 0 : 0) {
              h = 39
              break
            }
            m = h << 24 >> 24 == 0 & 1
            j = 11
          } else {
            m = 0
            j = 11
          }
        } while (0)
        a:do {
          if ((j | 0) == 11) {
            l = m << 24 >> 24 != 0
            h = 1
            i = 1
            n = 0
            while (1) {
              j = i << 24 >> 24 != 0
              if (!(k << 24 >> 24)) {
                break
              }
              do {
                if (j) {
                  if ((n | 0) <= 36 ? k << 24 >> 24 == (a[139175 + n >> 0] | 0) : 0) {
                    break
                  }
                  i = 0
                } else {
                  i = 0
                }
              } while (0)
              do {
                if (!(l | h << 24 >> 24 == 0)) {
                  if ((n | 0) <= 29 ? k << 24 >> 24 == (a[139212 + n >> 0] | 0) : 0) {
                    break
                  }
                  h = 0
                }
              } while (0)
              k = n + 1 | 0
              n = k
              k = a[f + k >> 0] | 0
            }
            if ((m & 255 | 0) != (j & (n | 0) == 36 & 1 | 0)) {
              h = l ? 38 : 40
              break
            }
            if (!(h << 24 >> 24 != 0 & (n | 0) == 29)) {
              o = b + 468 | 0
              n = n + ((a[o >> 0] | 0) != 0 & 1) | 0
              h = b + 372 | 0
              j = c[h >> 2] | 0
              do {
                if (!j) {
                  h = b + 12 | 0
                  i = kb[c[h >> 2] & 63](28) | 0
                  if (!i) {
                    h = 1
                    break a
                  }
                  j = n + 24 | 0
                  m = kb[c[h >> 2] & 63](j) | 0
                  c[i + 16 >> 2] = m
                  if (!m) {
                    tb[c[b + 20 >> 2] & 127](i)
                    h = 1
                    break a
                  } else {
                    c[i + 24 >> 2] = j
                    j = i
                    break
                  }
                } else {
                  i = j + 24 | 0
                  if ((n | 0) > (c[i >> 2] | 0)) {
                    k = j + 16 | 0
                    l = n + 24 | 0
                    m = lb[c[b + 16 >> 2] & 127](c[k >> 2] | 0, l) | 0
                    if (!m) {
                      h = 1
                      break a
                    }
                    c[k >> 2] = m
                    c[i >> 2] = l
                  }
                  c[h >> 2] = c[j + 4 >> 2]
                }
              } while (0)
              c[j + 20 >> 2] = n
              i = j + 16 | 0
              E3(c[i >> 2] | 0, f | 0, n | 0) | 0
              h = a[o >> 0] | 0
              if (h << 24 >> 24) {
                a[(c[i >> 2] | 0) + (n + -1) >> 0] = h
              }
              c[j >> 2] = d
              c[j + 12 >> 2] = e
              i = d + 4 | 0
              c[j + 8 >> 2] = c[i >> 2]
              if ((a[f >> 0] | 0) == 0 ? ((c[b + 352 >> 2] | 0) + 152 | 0) == (d | 0) : 0) {
                h = 0
              } else {
                h = j
              }
              c[i >> 2] = h
              c[j + 4 >> 2] = c[g >> 2]
              c[g >> 2] = j
              if ((e | 0) != 0 ? (p = c[b + 100 >> 2] | 0, (p | 0) != 0) : 0) {
                vb[p & 127](c[b + 4 >> 2] | 0, c[d >> 2] | 0, c[i >> 2] | 0 ? f : 0)
                h = 0
              } else {
                h = 0
              }
            } else {
              h = 40
            }
          }
        } while (0)
        return h | 0
      }

      function DW(a, b) {
        a = a | 0
        b = b | 0
        var d = 0
        d = b
        c[d >> 2] = 0
        c[d + 4 >> 2] = 0
        b = b + 8 | 0
        c[b >> 2] = JW(a) | 0
        c[b + 4 >> 2] = 0
        return
      }

      function EW(a, b) {
        a = a | 0
        b = b | 0
        var d = 0, e = 0, f = 0, g = 0
        d = b
        g = c[d + 4 >> 2] ^ 1936682341
        e = a
        c[e >> 2] = c[d >> 2] ^ 1886610805
        c[e + 4 >> 2] = g
        e = b + 8 | 0
        g = e
        d = c[g + 4 >> 2] ^ 1685025377
        f = a + 8 | 0
        c[f >> 2] = c[g >> 2] ^ 1852075885
        c[f + 4 >> 2] = d
        f = b
        b = c[f + 4 >> 2] ^ 1819895653
        d = a + 16 | 0
        c[d >> 2] = c[f >> 2] ^ 1852142177
        c[d + 4 >> 2] = b
        d = c[e + 4 >> 2] ^ 1952801890
        b = a + 24 | 0
        c[b >> 2] = c[e >> 2] ^ 2037671283
        c[b + 4 >> 2] = d
        c[a + 40 >> 2] = a + 32
        b = a + 48 | 0
        c[b >> 2] = 0
        c[b + 4 >> 2] = 0
        return
      }

      function FW(b, e, f) {
        b = b | 0
        e = e | 0
        f = f | 0
        var g = 0, h = 0, i = 0, j = 0, k = 0, l = 0, m = 0, n = 0, o = 0, p = 0, q = 0, r = 0, s = 0, t = 0, u = 0,
            v = 0, w = 0, x = 0, y = 0, A = 0, B = 0
        n = e + f | 0
        o = b + 40 | 0
        p = b + 40 | 0
        q = b + 32 | 0
        r = b + 33 | 0
        s = b + 34 | 0
        t = b + 35 | 0
        h = b + 36 | 0
        i = b + 37 | 0
        j = b + 38 | 0
        k = b + 39 | 0
        l = b + 24 | 0
        m = b + 48 | 0
        f = e
        do {
          while (1) {
            g = c[o >> 2] | 0
            if (f >>> 0 >= n >>> 0) {
              e = 0
              break
            }
            if (g >>> 0 >= p >>> 0) {
              e = 1
              break
            }
            e = a[f >> 0] | 0
            c[o >> 2] = g + 1
            a[g >> 0] = e
            f = f + 1 | 0
          }
          if (g >>> 0 < p >>> 0) {
            break
          }
          A = d[q >> 0] | 0
          B = z3(d[r >> 0] | 0 | 0, 0, 8) | 0
          g = z
          y = z3(d[s >> 0] | 0 | 0, 0, 16) | 0
          g = g | z
          w = z3(d[t >> 0] | 0 | 0, 0, 24) | 0
          g = g | z | (d[h >> 0] | 0)
          u = z3(d[i >> 0] | 0 | 0, 0, 40) | 0
          g = g | z
          x = z3(d[j >> 0] | 0 | 0, 0, 48) | 0
          g = g | z
          v = z3(d[k >> 0] | 0 | 0, 0, 56) | 0
          v = B | A | y | w | u | x | v
          g = g | z
          x = l
          u = g ^ c[x + 4 >> 2]
          w = l
          c[w >> 2] = v ^ c[x >> 2]
          c[w + 4 >> 2] = u
          IW(b, 2)
          w = b
          g = c[w + 4 >> 2] ^ g
          u = b
          c[u >> 2] = c[w >> 2] ^ v
          c[u + 4 >> 2] = g
          c[o >> 2] = q
          u = m
          u = r3(c[u >> 2] | 0, c[u + 4 >> 2] | 0, 8, 0) | 0
          g = m
          c[g >> 2] = u
          c[g + 4 >> 2] = z
        } while (e)
        return
      }

      function GW(b) {
        b = b | 0
        var c = 0
        c = 0
        while (1) {
          if (!(a[b >> 0] | 0)) {
            break
          }
          c = c + 1 | 0
          b = b + 1 | 0
        }
        return c | 0
      }

      function HW(a) {
        a = a | 0
        var b = 0, e = 0, f = 0, g = 0, h = 0, i = 0
        f = a + 32 | 0
        h = (c[a + 40 >> 2] | 0) - f | 0
        e = a + 48 | 0
        e = r3(c[e >> 2] | 0, c[e + 4 >> 2] | 0, h | 0, 0) | 0
        e = z3(e | 0, z | 0, 56) | 0
        b = z
        switch (h << 24 >> 24 | 0) {
          case 7: {
            e = z3(d[a + 38 >> 0] | 0 | 0, 0, 48) | 0 | e
            b = z | b
            g = 3
            break
          }
          case 6: {
            g = 3
            break
          }
          case 5: {
            g = 4
            break
          }
          case 4: {
            g = 5
            break
          }
          case 3: {
            g = 6
            break
          }
          case 2: {
            g = 7
            break
          }
          case 1: {
            g = 8
            break
          }
          default: {
          }
        }
        if ((g | 0) == 3) {
          h = z3(d[a + 37 >> 0] | 0 | 0, 0, 40) | 0
          e = h | e
          b = z | b
          g = 4
        }
        if ((g | 0) == 4) {
          b = d[a + 36 >> 0] | 0 | b
          g = 5
        }
        if ((g | 0) == 5) {
          h = z3(d[a + 35 >> 0] | 0 | 0, 0, 24) | 0
          e = h | e
          b = z | b
          g = 6
        }
        if ((g | 0) == 6) {
          h = z3(d[a + 34 >> 0] | 0 | 0, 0, 16) | 0
          e = h | e
          b = z | b
          g = 7
        }
        if ((g | 0) == 7) {
          h = z3(d[a + 33 >> 0] | 0 | 0, 0, 8) | 0
          b = z | b
          e = h | e
          g = 8
        }
        if ((g | 0) == 8) {
          e = e | (d[f >> 0] | 0)
        }
        h = a + 24 | 0
        i = h
        g = c[i + 4 >> 2] ^ b
        f = h
        c[f >> 2] = c[i >> 2] ^ e
        c[f + 4 >> 2] = g
        IW(a, 2)
        f = a
        b = c[f + 4 >> 2] ^ b
        g = a
        c[g >> 2] = c[f >> 2] ^ e
        c[g + 4 >> 2] = b
        g = a + 16 | 0
        b = g
        e = c[b + 4 >> 2] | 0
        f = g
        c[f >> 2] = c[b >> 2] ^ 255
        c[f + 4 >> 2] = e
        IW(a, 4)
        f = a
        a = a + 8 | 0
        z = c[a + 4 >> 2] ^ c[f + 4 >> 2] ^ c[g + 4 >> 2] ^ c[h + 4 >> 2]
        return c[a >> 2] ^ c[f >> 2] ^ c[g >> 2] ^ c[h >> 2] | 0
      }

      function IW(a, b) {
        a = a | 0
        b = b | 0
        var d = 0, e = 0, f = 0, g = 0, h = 0, i = 0, j = 0, k = 0, l = 0, m = 0, n = 0, o = 0, p = 0, q = 0
        e = a + 8 | 0
        f = a + 24 | 0
        g = a + 16 | 0
        d = 0
        while (1) {
          if ((d | 0) >= (b | 0)) {
            break
          }
          h = e
          n = c[h >> 2] | 0
          h = c[h + 4 >> 2] | 0
          o = a
          o = r3(c[o >> 2] | 0, c[o + 4 >> 2] | 0, n | 0, h | 0) | 0
          k = z
          m = z3(n | 0, h | 0, 13) | 0
          l = z
          h = y3(n | 0, h | 0, 51) | 0
          h = (m | h) ^ o
          l = (l | z) ^ k
          m = f
          n = c[m >> 2] | 0
          m = c[m + 4 >> 2] | 0
          j = g
          j = r3(c[j >> 2] | 0, c[j + 4 >> 2] | 0, n | 0, m | 0) | 0
          i = z
          q = z3(n | 0, m | 0, 16) | 0
          p = z
          m = y3(n | 0, m | 0, 48) | 0
          m = (q | m) ^ j
          p = (p | z) ^ i
          o = r3(k | 0, o | 0, m | 0, p | 0) | 0
          k = z
          q = a
          c[q >> 2] = o
          c[q + 4 >> 2] = k
          q = z3(m | 0, p | 0, 21) | 0
          n = z
          p = y3(m | 0, p | 0, 43) | 0
          m = f
          c[m >> 2] = (q | p) ^ o
          c[m + 4 >> 2] = (n | z) ^ k
          i = r3(j | 0, i | 0, h | 0, l | 0) | 0
          j = z
          m = z3(h | 0, l | 0, 17) | 0
          k = z
          l = y3(h | 0, l | 0, 47) | 0
          h = e
          c[h >> 2] = (m | l) ^ i
          c[h + 4 >> 2] = (k | z) ^ j
          h = g
          c[h >> 2] = j
          c[h + 4 >> 2] = i
          d = d + 1 | 0
        }
        return
      }

      function JW(a) {
        a = a | 0
        var b = 0
        while (1) {
          b = c[a + 472 >> 2] | 0
          if (!b) {
            break
          } else {
            a = b
          }
        }
        return c[a + 492 >> 2] | 0
      }

      function KW(b, d, e, f, g, h) {
        b = b | 0
        d = d | 0
        e = e | 0
        f = f | 0
        g = g | 0
        h = h | 0
        var i = 0, j = 0, k = 0, m = 0, n = 0, o = 0, p = 0, q = 0, r = 0, s = 0, t = 0, u = 0, v = 0, w = 0, x = 0,
            y = 0, z = 0, A = 0, B = 0, C = 0, D = 0, E = 0, F = 0, G = 0, H = 0, I = 0, J = 0, K = 0, L = 0, M = 0
        L = l
        l = l + 16 | 0
        I = L
        J = L + 4 | 0
        K = c[b + 352 >> 2] | 0
        o = d + 16 | 0
        p = d + 40 | 0
        q = b + 144 | 0
        r = b + 284 | 0
        s = e << 24 >> 24 == 0
        t = h + 12 | 0
        v = h + 16 | 0
        w = h + 8 | 0
        x = d + 44 | 0
        y = d + 64 | 0
        z = b + 436 | 0
        A = b + 452 | 0
        B = b + 448 | 0
        C = (K + 80 | 0) == (h | 0)
        D = b + 268 | 0
        E = K + 130 | 0
        F = K + 129 | 0
        G = b + 296 | 0
        H = b + 224 | 0
        i = 0
        a:while (1) {
          b:while (1) {
            switch (ob[c[o >> 2] & 127](d, f, g, I) | 0) {
              case -4: {
                i = 0
                n = 61
                break a
              }
              case 0: {
                n = 4
                break a
              }
              case -1: {
                n = 6
                break a
              }
              case 6: {
                n = 21
                break b
              }
              case -3: {
                n = 22
                break b
              }
              case 7:
              case 39: {
                n = 23
                break b
              }
              case 10: {
                j = lb[c[p >> 2] & 127](d, f) | 0
                c:do {
                  if ((j | 0) < 0) {
                    if ((c[q >> 2] | 0) == (d | 0)) {
                      c[r >> 2] = f
                      j = 1
                      i = 14
                    } else {
                      j = 1
                      i = 14
                    }
                  } else {
                    if (s & (j | 0) == 32) {
                      k = c[t >> 2] | 0
                      if ((c[v >> 2] | 0) == (k | 0)) {
                        j = 4
                        break
                      }
                      if ((a[k + -1 >> 0] | 0) == 32) {
                        j = 4
                        break
                      }
                    }
                    m = fX(j, J) | 0
                    k = 0
                    while (1) {
                      if ((k | 0) >= (m | 0)) {
                        j = 0
                        break c
                      }
                      j = c[t >> 2] | 0
                      if ((j | 0) == (c[w >> 2] | 0)) {
                        if (!((dW(h) | 0) << 24 >> 24)) {
                          j = 1
                          i = 1
                          break c
                        }
                        j = c[t >> 2] | 0
                      }
                      M = a[J + k >> 0] | 0
                      c[t >> 2] = j + 1
                      a[j >> 0] = M
                      k = k + 1 | 0
                    }
                  }
                } while (0)
                switch (j & 7) {
                  case 4:
                  case 0:
                    break b
           