/*
 * Decompiled with CFR 0.152.
 */
package graphql.kickstart.autoconfigure.editor.altair;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import graphql.kickstart.autoconfigure.editor.altair.AltairOptions;
import graphql.kickstart.autoconfigure.editor.altair.AltairProperties;
import graphql.kickstart.autoconfigure.editor.altair.AltairResources;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringSubstitutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Controller;
import org.springframework.util.StreamUtils;
import org.springframework.web.bind.annotation.GetMapping;

@Controller
public class AltairController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AltairController.class);
    private static final String CDN_JSDELIVR_NET_NPM = "//cdn.jsdelivr.net/npm/";
    private static final String ALTAIR = "altair-static";
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final AltairProperties altairProperties;
    private final AltairOptions altairOptions;
    private final AltairResources altairResources;
    private String template;

    @PostConstruct
    public void onceConstructed() throws IOException {
        this.objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        this.altairResources.load(this.altairOptions);
        this.loadTemplate();
    }

    private void loadTemplate() throws IOException {
        try (InputStream inputStream = new ClassPathResource("templates/altair.html").getInputStream();){
            this.template = StreamUtils.copyToString((InputStream)inputStream, (Charset)Charset.defaultCharset());
        }
    }

    @GetMapping(value={"${graphql.altair.mapping:/altair}"})
    public void altair(HttpServletResponse response) throws IOException {
        response.setContentType("text/html; charset=UTF-8");
        String populatedTemplate = StringSubstitutor.replace((Object)this.template, this.getReplacements());
        response.getOutputStream().write(populatedTemplate.getBytes(Charset.defaultCharset()));
    }

    private Map<String, String> getReplacements() {
        HashMap<String, String> replacements = new HashMap<String, String>();
        replacements.put("pageTitle", this.altairProperties.getPageTitle());
        replacements.put("pageFavicon", this.getResourceUrl("favicon.ico", "favicon.ico"));
        replacements.put("altairBaseUrl", this.getResourceUrl(StringUtils.join((Object[])new String[]{this.altairProperties.getBasePath(), "/vendor/altair/"}), this.joinJsdelivrPath(this.altairProperties.getCdn().getVersion())));
        replacements.put("altairLogoUrl", this.getResourceUrl("assets/img/logo_350.svg", "assets/img/logo_350.svg"));
        replacements.put("altairCssUrl", this.getResourceUrl("styles.css", "styles.css"));
        String suffix = this.isJsSuffixAdded() ? "-es2018.js" : ".js";
        replacements.put("altairMainJsUrl", this.getResourceUrl("main-es2018.js", "main" + suffix));
        replacements.put("altairPolyfillsJsUrl", this.getResourceUrl("polyfills-es2018.js", "polyfills" + suffix));
        replacements.put("altairRuntimeJsUrl", this.getResourceUrl("runtime-es2018.js", "runtime" + suffix));
        replacements.put("options", this.objectMapper.writeValueAsString((Object)this.altairOptions));
        return replacements;
    }

    private boolean isJsSuffixAdded() {
        if (Objects.nonNull(this.altairProperties.getCdn().getVersion())) {
            String[] versionValues = this.altairProperties.getCdn().getVersion().split("\\.");
            return StringUtils.isNumeric((CharSequence)versionValues[0]) && Integer.parseInt(versionValues[0]) >= 4 && versionValues.length > 2 && StringUtils.isNumeric((CharSequence)versionValues[1]) && Integer.parseInt(versionValues[1]) < 2;
        }
        return false;
    }

    private String getResourceUrl(String staticFileName, String cdnUrl) {
        if (this.altairProperties.getCdn().isEnabled() && StringUtils.isNotBlank((CharSequence)cdnUrl)) {
            return cdnUrl;
        }
        return staticFileName;
    }

    private String joinJsdelivrPath(String cdnVersion) {
        return "//cdn.jsdelivr.net/npm/altair-static@" + cdnVersion + "/build/dist/";
    }

    @Generated
    public AltairController(AltairProperties altairProperties, AltairOptions altairOptions, AltairResources altairResources) {
        this.altairProperties = altairProperties;
        this.altairOptions = altairOptions;
        this.altairResources = altairResources;
    }
}

