/*
 * Decompiled with CFR 0.152.
 */
package graphql.kickstart.autoconfigure.editor.graphiql;

import graphql.kickstart.autoconfigure.editor.graphiql.GraphiQLProperties;
import graphql.kickstart.autoconfigure.editor.graphiql.ReactiveGraphiQLController;
import graphql.kickstart.autoconfigure.editor.graphiql.ServletGraphiQLController;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.web.reactive.function.server.RouterFunction;
import org.springframework.web.reactive.function.server.RouterFunctions;
import org.springframework.web.reactive.function.server.ServerResponse;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@AutoConfiguration
@ConditionalOnProperty(value={"graphql.graphiql.enabled"}, havingValue="true")
@EnableConfigurationProperties(value={GraphiQLProperties.class})
public class GraphiQLAutoConfiguration {
    @Bean(name={"graphiQLController"})
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
    ServletGraphiQLController servletGraphiQLController(GraphiQLProperties properties) {
        return new ServletGraphiQLController(properties);
    }

    @Bean(name={"graphiQLController"})
    @ConditionalOnMissingBean(value={ServletGraphiQLController.class})
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
    ReactiveGraphiQLController reactiveGraphiQLController(GraphiQLProperties properties) {
        return new ReactiveGraphiQLController(properties);
    }

    @Bean
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
    @ConditionalOnExpression(value="'${graphql.graphiql.cdn.enabled:false}' == 'false'")
    public RouterFunction<ServerResponse> graphiqlStaticFilesRouter() {
        return RouterFunctions.resources((String)"/vendor/graphiql/**", (Resource)new ClassPathResource("static/vendor/graphiql/"));
    }

    @Configuration
    @EnableWebMvc
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
    @ConditionalOnExpression(value="'${graphql.graphiql.cdn.enabled:false}' == 'false'")
    public static class GraphiQLWebMvcResourceConfiguration
    implements WebMvcConfigurer {
        public void addResourceHandlers(ResourceHandlerRegistry registry) {
            registry.addResourceHandler(new String[]{"/vendor/graphiql/**"}).addResourceLocations(new Resource[]{new ClassPathResource("static/vendor/graphiql/")});
        }
    }
}

